#ifndef REGISTRY_H
#define REGISTRY_H

#include <stdio.h>


//========================================================================
// $Id: registry.h,v 1.4 2001/01/19 09:17:15 radnev Exp $
//========================================================================


class Registry {

public:
	Registry(const char *path, const char *file, const char *suffix);
	~Registry();
	char *getString(const char *property, const char *defaultValue = "");
	int getInt(const char *property, const int defaultValue = 0);
	int getInt(const char *property, const int defaultValue, const int minValue, const int maxValue);
	bool getBool(const char *property, const bool defaultValue = false);
	bool setString(const char *property, const char *value);
	bool setInt(const char *property, const int value);
	bool setBool(const char *property, const bool value);

private:
	static const int MAX_LINE_LEN;
	static const int MAX_KEY_LEN;
	char *buf;
	char *sbuf;
	char *key;
	char *fileName;
	char *backupFileName;

}; // End of class Registry

#endif
