// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: internal/tunnel/info/info.proto

package info

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Method with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Method) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Method with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in MethodMultiError, or nil if none found.
func (m *Method) ValidateAll() error {
	return m.validate(true)
}

func (m *Method) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) < 1 {
		err := MethodValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return MethodMultiError(errors)
	}

	return nil
}

// MethodMultiError is an error wrapping multiple validation errors returned by
// Method.ValidateAll() if the designated constraints aren't met.
type MethodMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m MethodMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m MethodMultiError) AllErrors() []error { return m }

// MethodValidationError is the validation error returned by Method.Validate if
// the designated constraints aren't met.
type MethodValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MethodValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MethodValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MethodValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MethodValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MethodValidationError) ErrorName() string { return "MethodValidationError" }

// Error satisfies the builtin error interface
func (e MethodValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMethod.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MethodValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MethodValidationError{}

// Validate checks the field values on Service with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Service) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Service with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ServiceMultiError, or nil if none found.
func (m *Service) ValidateAll() error {
	return m.validate(true)
}

func (m *Service) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) < 1 {
		err := ServiceValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetMethods() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ServiceValidationError{
						field:  fmt.Sprintf("Methods[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ServiceValidationError{
						field:  fmt.Sprintf("Methods[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ServiceValidationError{
					field:  fmt.Sprintf("Methods[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ServiceMultiError(errors)
	}

	return nil
}

// ServiceMultiError is an error wrapping multiple validation errors returned
// by Service.ValidateAll() if the designated constraints aren't met.
type ServiceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ServiceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ServiceMultiError) AllErrors() []error { return m }

// ServiceValidationError is the validation error returned by Service.Validate
// if the designated constraints aren't met.
type ServiceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ServiceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ServiceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ServiceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ServiceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ServiceValidationError) ErrorName() string { return "ServiceValidationError" }

// Error satisfies the builtin error interface
func (e ServiceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sService.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ServiceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ServiceValidationError{}

// Validate checks the field values on APIDescriptor with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *APIDescriptor) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on APIDescriptor with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in APIDescriptorMultiError, or
// nil if none found.
func (m *APIDescriptor) ValidateAll() error {
	return m.validate(true)
}

func (m *APIDescriptor) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetServices() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, APIDescriptorValidationError{
						field:  fmt.Sprintf("Services[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, APIDescriptorValidationError{
						field:  fmt.Sprintf("Services[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return APIDescriptorValidationError{
					field:  fmt.Sprintf("Services[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return APIDescriptorMultiError(errors)
	}

	return nil
}

// APIDescriptorMultiError is an error wrapping multiple validation errors
// returned by APIDescriptor.ValidateAll() if the designated constraints
// aren't met.
type APIDescriptorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m APIDescriptorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m APIDescriptorMultiError) AllErrors() []error { return m }

// APIDescriptorValidationError is the validation error returned by
// APIDescriptor.Validate if the designated constraints aren't met.
type APIDescriptorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e APIDescriptorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e APIDescriptorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e APIDescriptorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e APIDescriptorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e APIDescriptorValidationError) ErrorName() string { return "APIDescriptorValidationError" }

// Error satisfies the builtin error interface
func (e APIDescriptorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAPIDescriptor.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = APIDescriptorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = APIDescriptorValidationError{}
