/* gtkui.h - GTK GUI function prototypes
 *
 * Copyright 2010, 2016 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ABX_GTK_UI_H
#define ABX_GTK_UI_H

#include "playback.h"
#include <gtk/gtk.h>

extern Metadata metadata_a;
extern Metadata metadata_b;
extern gchar *basename_a;
extern gchar *basename_b;
extern int current_trial;
extern GtkWidget *main_window;

/* gtkui.c */
extern int ui_main(int argc, char *argv[]);
extern void error_dialog(GtkWidget *parent_win, char *msg);
extern void reset_test(void);

/* mainwin.c */
extern void show_main_window(void);
extern void update_main_window(void);

/* decidewin.c */
extern void show_decide_dialog(GtkWindow *parent);
extern void hide_decide_dialog(void);

/* newtestwin.c */
extern void show_new_test_window(void);

/* resultwin.c */
extern void show_result_window(void);
extern void hide_result_window(void);

#endif
