;;; EMAIL-ADDRESS

;;(email-address-init env) -> env
;; initialize environment
(defun email-address-init (env)
  (begin
   (cw "  [email-address-init]~%")
  (set-var 'correspondents '() 
  (set-var 'translation    '() env))))

;;(email-address-command string list[<anything>] env -> env
;;
(defun email-address-command (cmd args env)
  (begin 
   (cw "  [email-address-command: ~x0]~%" (lookup 'user))
  (cond ((equal 'ADD_TRANSLATION cmd)
         (let ((?rcpt  (caar  args))
	       (?trans (cadar args)))
	   (begin
	    (cw "rcpt: ~x0~%" (stringify ?rcpt))
	    (cw "tran: ~x0~%" (stringify ?trans))

	   (if (member-equal ?rcpt (lookup 'correspondents))
	       (begin 
		(cw "")
	       (set-hash-var ?rcpt
			     (cons ?trans (lookup 'translation ?rcpt))
			     'translation 
			     env))
	       (set-var 'correspondents
			(cons ?rcpt (lookup 'correspondents))
	       (set-hash-var ?rcpt
			     (cons ?trans '())
			     'translation 
			     env))))))
	   (t env))))



;;(email-address-outgoing message env) -> action
;;
(defun email-address-outgoing (msg env)
  (begin
   (cw "  [email-address-outgoing: ~x0]~%" (lookup 'user))
   (cw "  msg-->~x0~%" (stringify msg))
   (let ((?rcpt (recipient msg)))
     (if (member-equal ?rcpt (lookup 'correspondents))
	 (let ((?true-rcpts (lookup 'translation ?rcpt)))
	   (make-action 'mail
			(make-message
			 (sender msg)
			 (cons (car ?true-rcpts) '())
			 (headers msg)
			 (body-lines msg))
			env))
; !! haven't figured out how to do multiple actions yet...
;	   (if (> (length ?true-rcpts) 1)
;	       (make-action 'mail
;			    (make-message
;			     (sender msg)
;			     (cons (cadr ?true-rcpts) '())
;			     (headers msg)
;			     (body-lines msg))
;			    env)))
       (make-action 'mail msg env)))))
	     

;;(email-address-incoming message env) -> action
;;
(defun email-address-incoming (msg env)
  (declare (ignore msg))
  (begin
   (cw "  [email-address-incoming: ~x0]~%" (lookup 'user))
   (mv nil env)))


