# ---------------------------------------------------------------------------
# - SEC0020.als                                                             -
# - afnix:sec module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2022 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   gcm mode test unit
# @author amaury darsch

# get the module
interp:library "afnix-sec"

const test-gcm-128 (k i e a p c t) {
  # create a key with a buffer
  trans key (afnix:sec:Key k)
  assert 128 (key:get-bits)
  # create the cipher
  trans aes (afnix:sec:Aes key)
  aes:set-block-mode afnix:sec:ModeCipher:MODE-ECB
  aes:set-padding-mode afnix:sec:ModeCipher:PAD-NONE
  # create the gcm by cipher
  trans gcm (afnix:sec:Gcm aes)
  assert true (afnix:sec:aead-cipher-p gcm)
  assert true (afnix:sec:gcm-p gcm)
  assert "Gcm" (gcm:repr)
  # set the initial vector and authentication data
  if (string-p i) (gcm:set-iv i)
  if (string-p e) (gcm:add-iv e)
  if (string-p a) (gcm:set-authentication-data a)

  # process a buffer
  trans ib (Buffer p)
  trans cb (Buffer c)
  trans ob (Buffer)
  assert (p:length) (gcm:stream ob ib)
  assert (cb:format) (ob:format)
  # check the tag
  trans tb (gcm:get-authentication-tag)
  assert t (tb:format)

  # reverse the cipher and check
  gcm:set-reverse true
  if (string-p e) (gcm:add-iv e)
  assert true (gcm:get-reverse)
  trans db (Buffer)
  assert (p:length) (gcm:stream db ob)
  # check decode
  trans ib (Buffer p)
  assert (ib:format) (db:format)
  # check the tag
  trans bt (gcm:get-authentication-tag)
  assert t (bt:format)
}

# test 0
const K0 "00000000000000000000000000000000"
const I0 "000000000000000000000000"
const E0 nil
const A0 nil
const P0 (Vector
  0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
  0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
)
const C0 (Vector
  0x03 0x88 0xda 0xce 0x60 0xb6 0xa3 0x92
  0xf3 0x28 0xc2 0xb9 0x71 0xb2 0xfe 0x78
)
const T0 "AB6E47D42CEC13BDF53A67B21257BDDF"
test-gcm-128 K0 I0 E0 A0 P0 C0 T0

# test 1
const K1 "FEFFE9928665731C6D6A8F9467308308"
const I1 "CAFEBABEFACEDBADDECAF888"
const E1 nil
const A1 nil
const P1 (Vector
  0xd9 0x31 0x32 0x25 0xf8 0x84 0x06 0xe5
  0xa5 0x59 0x09 0xc5 0xaf 0xf5 0x26 0x9a
  0x86 0xa7 0xa9 0x53 0x15 0x34 0xf7 0xda
  0x2e 0x4c 0x30 0x3d 0x8a 0x31 0x8a 0x72
  0x1c 0x3c 0x0c 0x95 0x95 0x68 0x09 0x53
  0x2f 0xcf 0x0e 0x24 0x49 0xa6 0xb5 0x25
  0xb1 0x6a 0xed 0xf5 0xaa 0x0d 0xe6 0x57
  0xba 0x63 0x7b 0x39 0x1a 0xaf 0xd2 0x55
)
const C1 (Vector
  0x42 0x83 0x1e 0xc2 0x21 0x77 0x74 0x24
  0x4b 0x72 0x21 0xb7 0x84 0xd0 0xd4 0x9c
  0xe3 0xaa 0x21 0x2f 0x2c 0x02 0xa4 0xe0
  0x35 0xc1 0x7e 0x23 0x29 0xac 0xa1 0x2e
  0x21 0xd5 0x14 0xb2 0x54 0x66 0x93 0x1c
  0x7d 0x8f 0x6a 0x5a 0xac 0x84 0xaa 0x05
  0x1b 0xa3 0x0b 0x39 0x6a 0x0a 0xac 0x97
  0x3d 0x58 0xe0 0x91 0x47 0x3f 0x59 0x85
)
const T1 "4D5C2AF327CD64A62CF35ABD2BA6FAB4"
test-gcm-128 K1 I1 E1 A1 P1 C1 T1

# test 2
const K2 "FEFFE9928665731C6D6A8F9467308308"
const I2 "CAFEBABEFACEDBADDECAF888"
const E2 nil
const A2 "FEEDFACEDEADBEEFFEEDFACEDEADBEEFABADDAD2"
const P2 (Vector
  0xd9 0x31 0x32 0x25 0xf8 0x84 0x06 0xe5
  0xa5 0x59 0x09 0xc5 0xaf 0xf5 0x26 0x9a
  0x86 0xa7 0xa9 0x53 0x15 0x34 0xf7 0xda
  0x2e 0x4c 0x30 0x3d 0x8a 0x31 0x8a 0x72
  0x1c 0x3c 0x0c 0x95 0x95 0x68 0x09 0x53
  0x2f 0xcf 0x0e 0x24 0x49 0xa6 0xb5 0x25
  0xb1 0x6a 0xed 0xf5 0xaa 0x0d 0xe6 0x57
  0xba 0x63 0x7b 0x39
)
const C2 (Vector
  0x42 0x83 0x1e 0xc2 0x21 0x77 0x74 0x24
  0x4b 0x72 0x21 0xb7 0x84 0xd0 0xd4 0x9c
  0xe3 0xaa 0x21 0x2f 0x2c 0x02 0xa4 0xe0
  0x35 0xc1 0x7e 0x23 0x29 0xac 0xa1 0x2e
  0x21 0xd5 0x14 0xb2 0x54 0x66 0x93 0x1c
  0x7d 0x8f 0x6a 0x5a 0xac 0x84 0xaa 0x05
  0x1b 0xa3 0x0b 0x39 0x6a 0x0a 0xac 0x97
  0x3d 0x58 0xe0 0x91
)
const T2 "5BC94FBC3221A5DB94FAE95AE7121A47"
test-gcm-128 K2 I2 E2 A2 P2 C2 T2

# test 3
const K3 "1F5CE521FA87CE4EBAE657E0B648EB49"
const I3 "DE97B3E051F43D595FB420AD"
const E3 nil
const A3 "00000000000000001603030010"
const P3 (Vector
  0x14 0x00 0x00 0x0c 0xbb 0x28 0xa5 0xe7
  0x94 0xc5 0xab 0x4b 0xd2 0xbd 0x32 0x6c
)
const C3 (Vector
  0x62 0x7d 0x66 0xd0 0xce 0x8a 0x98 0x8e
  0x74 0x45 0x83 0x22 0x7e 0x28 0x59 0xd1
)
const T3 "D08E65E52ADB7B180DCF95B886E8BC49"
test-gcm-128 K3 I3 E3 A3 P3 C3 T3

# test 4
const K4 "1F5CE521FA87CE4EBAE657E0B648EB49"
const I4 "DE97B3E0"
const E4 "51F43D595FB420AD"
const A4 "00000000000000001603030010"
const P4 (Vector
  0x14 0x00 0x00 0x0c 0xbb 0x28 0xa5 0xe7
  0x94 0xc5 0xab 0x4b 0xd2 0xbd 0x32 0x6c
)
const C4 (Vector
  0x62 0x7d 0x66 0xd0 0xce 0x8a 0x98 0x8e
  0x74 0x45 0x83 0x22 0x7e 0x28 0x59 0xd1
)
const T4 "D08E65E52ADB7B180DCF95B886E8BC49"
test-gcm-128 K4 I4 E4 A4 P4 C4 T4

# test 5
const K5 "1C9F018FFDE5A516F4F1FFFE5917DF24"
const I5 "7F9790CD"
const E5 "0D6962EDFD51C212"
const A5 "00000000000000B01703030001"
const P5 (Vector
  0x0A
)
const C5 (Vector
  0x57
)
const T5 "0CB2BFBA990E36DBB4093F49B09235C3"
test-gcm-128 K5 I5 E5 A5 P5 C5 T5

# test 6
const K6 "1C9F018FFDE5A516F4F1FFFE5917DF24"
const I6 "7F9790CD"
const E6 "0D6962EDFD51C213"
const A6 "00000000000000B11703030001"
const P6 (Vector
  0x0A
)
const C6 (Vector
  0x16
)
const T6 "687A7518DFCF77AAD9756A488ECB581F"
test-gcm-128 K6 I6 E6 A6 P6 C6 T6
