/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.speech;

import android.annotation.NonNull;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;

import com.android.internal.util.DataClass;

import java.util.List;

/** Encodes the level of support for a given speech recognition request */
@DataClass(
        genConstructor = false,
        genBuilder = true,
        genEqualsHashCode = true,
        genHiddenConstDefs = true,
        genParcelable = true,
        genToString = true
)
public final class RecognitionSupport implements Parcelable {

    /** Support for this request is ready for use on this device for the returned languages. */
    @NonNull
    @DataClass.PluralOf("installedOnDeviceLanguage")
    private List<String> mInstalledOnDeviceLanguages = List.of();

    /** Support for this request is scheduled for download for the returned languages. */
    @NonNull
    @DataClass.PluralOf("pendingOnDeviceLanguage")
    private List<String> mPendingOnDeviceLanguages = List.of();

    /**
     * These languages are supported but need to be downloaded before use. See {@link
     * SpeechRecognizer#triggerModelDownload(Intent)}.
     */
    @NonNull
    @DataClass.PluralOf("supportedOnDeviceLanguage")
    private List<String> mSupportedOnDeviceLanguages = List.of();

    /**
     * Support for this request is available via a remote implementation. {@link SpeechRecognizer}
     * created via {@link SpeechRecognizer#createOnDeviceSpeechRecognizer(Context)} are expected to
     * return an empty list.
     */
    @NonNull
    @DataClass.PluralOf("onlineLanguage")
    private List<String> mOnlineLanguages = List.of();



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/speech/RecognitionSupport.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ RecognitionSupport(
            @NonNull List<String> installedOnDeviceLanguages,
            @NonNull List<String> pendingOnDeviceLanguages,
            @NonNull List<String> supportedOnDeviceLanguages,
            @NonNull List<String> onlineLanguages) {
        this.mInstalledOnDeviceLanguages = installedOnDeviceLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mInstalledOnDeviceLanguages);
        this.mPendingOnDeviceLanguages = pendingOnDeviceLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPendingOnDeviceLanguages);
        this.mSupportedOnDeviceLanguages = supportedOnDeviceLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mSupportedOnDeviceLanguages);
        this.mOnlineLanguages = onlineLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mOnlineLanguages);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Support for this request is ready for use on this device for the returned languages.
     */
    @DataClass.Generated.Member
    public @NonNull List<String> getInstalledOnDeviceLanguages() {
        return mInstalledOnDeviceLanguages;
    }

    /**
     * Support for this request is scheduled for download for the returned languages.
     */
    @DataClass.Generated.Member
    public @NonNull List<String> getPendingOnDeviceLanguages() {
        return mPendingOnDeviceLanguages;
    }

    /**
     * These languages are supported but need to be downloaded before use. See {@link
     * SpeechRecognizer#triggerModelDownload(Intent)}.
     */
    @DataClass.Generated.Member
    public @NonNull List<String> getSupportedOnDeviceLanguages() {
        return mSupportedOnDeviceLanguages;
    }

    /**
     * Support for this request is available via a remote implementation. {@link SpeechRecognizer}
     * created via {@link SpeechRecognizer#createOnDeviceSpeechRecognizer(Context)} are expected to
     * return an empty list.
     */
    @DataClass.Generated.Member
    public @NonNull List<String> getOnlineLanguages() {
        return mOnlineLanguages;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "RecognitionSupport { " +
                "installedOnDeviceLanguages = " + mInstalledOnDeviceLanguages + ", " +
                "pendingOnDeviceLanguages = " + mPendingOnDeviceLanguages + ", " +
                "supportedOnDeviceLanguages = " + mSupportedOnDeviceLanguages + ", " +
                "onlineLanguages = " + mOnlineLanguages +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(RecognitionSupport other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        RecognitionSupport that = (RecognitionSupport) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mInstalledOnDeviceLanguages, that.mInstalledOnDeviceLanguages)
                && java.util.Objects.equals(mPendingOnDeviceLanguages, that.mPendingOnDeviceLanguages)
                && java.util.Objects.equals(mSupportedOnDeviceLanguages, that.mSupportedOnDeviceLanguages)
                && java.util.Objects.equals(mOnlineLanguages, that.mOnlineLanguages);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mInstalledOnDeviceLanguages);
        _hash = 31 * _hash + java.util.Objects.hashCode(mPendingOnDeviceLanguages);
        _hash = 31 * _hash + java.util.Objects.hashCode(mSupportedOnDeviceLanguages);
        _hash = 31 * _hash + java.util.Objects.hashCode(mOnlineLanguages);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeStringList(mInstalledOnDeviceLanguages);
        dest.writeStringList(mPendingOnDeviceLanguages);
        dest.writeStringList(mSupportedOnDeviceLanguages);
        dest.writeStringList(mOnlineLanguages);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ RecognitionSupport(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        List<String> installedOnDeviceLanguages = new java.util.ArrayList<>();
        in.readStringList(installedOnDeviceLanguages);
        List<String> pendingOnDeviceLanguages = new java.util.ArrayList<>();
        in.readStringList(pendingOnDeviceLanguages);
        List<String> supportedOnDeviceLanguages = new java.util.ArrayList<>();
        in.readStringList(supportedOnDeviceLanguages);
        List<String> onlineLanguages = new java.util.ArrayList<>();
        in.readStringList(onlineLanguages);

        this.mInstalledOnDeviceLanguages = installedOnDeviceLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mInstalledOnDeviceLanguages);
        this.mPendingOnDeviceLanguages = pendingOnDeviceLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPendingOnDeviceLanguages);
        this.mSupportedOnDeviceLanguages = supportedOnDeviceLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mSupportedOnDeviceLanguages);
        this.mOnlineLanguages = onlineLanguages;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mOnlineLanguages);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<RecognitionSupport> CREATOR
            = new Parcelable.Creator<RecognitionSupport>() {
        @Override
        public RecognitionSupport[] newArray(int size) {
            return new RecognitionSupport[size];
        }

        @Override
        public RecognitionSupport createFromParcel(@NonNull android.os.Parcel in) {
            return new RecognitionSupport(in);
        }
    };

    /**
     * A builder for {@link RecognitionSupport}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull List<String> mInstalledOnDeviceLanguages;
        private @NonNull List<String> mPendingOnDeviceLanguages;
        private @NonNull List<String> mSupportedOnDeviceLanguages;
        private @NonNull List<String> mOnlineLanguages;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * Support for this request is ready for use on this device for the returned languages.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setInstalledOnDeviceLanguages(@NonNull List<String> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mInstalledOnDeviceLanguages = value;
            return this;
        }

        /** @see #setInstalledOnDeviceLanguages */
        @DataClass.Generated.Member
        public @NonNull Builder addInstalledOnDeviceLanguage(@NonNull String value) {
            if (mInstalledOnDeviceLanguages == null) setInstalledOnDeviceLanguages(new java.util.ArrayList<>());
            mInstalledOnDeviceLanguages.add(value);
            return this;
        }

        /**
         * Support for this request is scheduled for download for the returned languages.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setPendingOnDeviceLanguages(@NonNull List<String> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mPendingOnDeviceLanguages = value;
            return this;
        }

        /** @see #setPendingOnDeviceLanguages */
        @DataClass.Generated.Member
        public @NonNull Builder addPendingOnDeviceLanguage(@NonNull String value) {
            if (mPendingOnDeviceLanguages == null) setPendingOnDeviceLanguages(new java.util.ArrayList<>());
            mPendingOnDeviceLanguages.add(value);
            return this;
        }

        /**
         * These languages are supported but need to be downloaded before use. See {@link
         * SpeechRecognizer#triggerModelDownload(Intent)}.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setSupportedOnDeviceLanguages(@NonNull List<String> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mSupportedOnDeviceLanguages = value;
            return this;
        }

        /** @see #setSupportedOnDeviceLanguages */
        @DataClass.Generated.Member
        public @NonNull Builder addSupportedOnDeviceLanguage(@NonNull String value) {
            if (mSupportedOnDeviceLanguages == null) setSupportedOnDeviceLanguages(new java.util.ArrayList<>());
            mSupportedOnDeviceLanguages.add(value);
            return this;
        }

        /**
         * Support for this request is available via a remote implementation. {@link SpeechRecognizer}
         * created via {@link SpeechRecognizer#createOnDeviceSpeechRecognizer(Context)} are expected to
         * return an empty list.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setOnlineLanguages(@NonNull List<String> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mOnlineLanguages = value;
            return this;
        }

        /** @see #setOnlineLanguages */
        @DataClass.Generated.Member
        public @NonNull Builder addOnlineLanguage(@NonNull String value) {
            if (mOnlineLanguages == null) setOnlineLanguages(new java.util.ArrayList<>());
            mOnlineLanguages.add(value);
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull RecognitionSupport build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mInstalledOnDeviceLanguages = List.of();
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mPendingOnDeviceLanguages = List.of();
            }
            if ((mBuilderFieldsSet & 0x4) == 0) {
                mSupportedOnDeviceLanguages = List.of();
            }
            if ((mBuilderFieldsSet & 0x8) == 0) {
                mOnlineLanguages = List.of();
            }
            RecognitionSupport o = new RecognitionSupport(
                    mInstalledOnDeviceLanguages,
                    mPendingOnDeviceLanguages,
                    mSupportedOnDeviceLanguages,
                    mOnlineLanguages);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x10) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1648131602084L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/speech/RecognitionSupport.java",
            inputSignatures = "private @android.annotation.NonNull @com.android.internal.util.DataClass.PluralOf(\"installedOnDeviceLanguage\") java.util.List<java.lang.String> mInstalledOnDeviceLanguages\nprivate @android.annotation.NonNull @com.android.internal.util.DataClass.PluralOf(\"pendingOnDeviceLanguage\") java.util.List<java.lang.String> mPendingOnDeviceLanguages\nprivate @android.annotation.NonNull @com.android.internal.util.DataClass.PluralOf(\"supportedOnDeviceLanguage\") java.util.List<java.lang.String> mSupportedOnDeviceLanguages\nprivate @android.annotation.NonNull @com.android.internal.util.DataClass.PluralOf(\"onlineLanguage\") java.util.List<java.lang.String> mOnlineLanguages\nclass RecognitionSupport extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genConstructor=false, genBuilder=true, genEqualsHashCode=true, genHiddenConstDefs=true, genParcelable=true, genToString=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
