# Code Coverage

Code coverage can be checked using clang's source-based coverage tools.  You
must use the GN argument `use_coverage=true`.  It's recommended to do this in a
separate output directory since the added instrumentation will affect
performance and generate an output file every time a binary is run.  You can
read more about this in [clang's documentation](
http://clang.llvm.org/docs/SourceBasedCodeCoverage.html) but the
bare minimum steps are also outlined below.  You will also need to download the
pre-built clang coverage tools, which are not downloaded by default.  The
easiest way to do this is to set a custom variable in your `.gclient` file.
Under the "openscreen" solution, add:
```python
  "custom_vars": {
    "checkout_clang_coverage_tools": True,
  },
```
then run `gclient runhooks`.  You can also run the python command from the
`clang_coverage_tools` hook in `//DEPS` yourself or even download the tools
manually
([link](https://storage.googleapis.com/chromium-browser-clang-staging/)).

Once you have your GN directory (we'll call it `out/coverage`) and have
downloaded the tools, do the following to generate an HTML coverage report:
```bash
out/coverage/openscreen_unittests
third_party/llvm-build/Release+Asserts/bin/llvm-profdata merge -sparse default.profraw -o foo.profdata
third_party/llvm-build/Release+Asserts/bin/llvm-cov show out/coverage/openscreen_unittests -instr-profile=foo.profdata -format=html -output-dir=<out dir> [filter paths]
```
There are a few things to note here:
 - `default.profraw` is generated by running the instrumented code, but
 `foo.profdata` can be any path you want.
 - `<out dir>` should be an empty directory for placing the generated HTML
 files.  You can view the report at `<out dir>/index.html`.
 - `[filter paths]` is a list of paths to which you want to limit the coverage
 report.  For example, you may want to limit it to cast/ or even
 cast/streaming/.  If this list is empty, all data will be in the report.

The same process can be used to check the coverage of a fuzzer's corpus.  Just
add `-runs=0` to the fuzzer arguments to make sure it only runs the existing
corpus then exits.
