/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */

package org.apache.log4j;

import org.apache.log4j.spi.LoggingEvent;

public class CustomNoopAppender extends AppenderSkeleton {

    private boolean booleanA;
    private int intA;
    private String stringA;

    @Override
    protected void append(final LoggingEvent event) {
        // Noop
    }

    @Override
    public void close() {
        // Noop
    }

    public boolean getBooleanA() {
        return booleanA;
    }

    public int getIntA() {
        return intA;
    }

    public String getStringA() {
        return stringA;
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    public void setBooleanA(final boolean booleanA) {
        this.booleanA = booleanA;
    }

    public void setIntA(final int intA) {
        this.intA = intA;
    }

    public void setStringA(final String stringA) {
        this.stringA = stringA;
    }

}
