/*
 * Copyright (c) 2022-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(ARM_COMPUTE_ENABLE_SME2)

#include <algorithm>
#include <cstddef>

namespace arm_conv {
namespace depthwise {

void sme2_fp32bf16fp32_planar_5x5_s1_4rows_dot_za_impl(
  const float *inptr,
  size_t ld_in_row,
  size_t ld_in_col,
  size_t ld_in_vl,
  unsigned int pad_top,
  unsigned int valid_input_rows,
  unsigned int pad_left,
  unsigned int valid_input_cols,
  const float *weights,
  const float *bias,
  float **outptrs,
  const size_t *outlds,
  const size_t *outvllds,
  unsigned int output_cols,
  unsigned int start_channel,
  unsigned int valid_channels,
  float act_min,
  float act_max
)
{
  struct Args
  {
    const float *inptr;
    size_t ld_in_vl;
    long unsigned int pad_top, pad_bottom, pad_left;
    const float *weights;
    const float *bias;
    long unsigned int input_cols, output_cols;
    float **outptrs;
    const size_t *ld_out_cols;
    const size_t *ld_out_vls;
    long unsigned int current_channel, n_channels;
    float clamp_min, clamp_max;
  };

  Args args = { inptr, ld_in_vl, pad_top, 8u - std::min(8u, pad_top + valid_input_rows), pad_left, weights, bias, valid_input_cols, output_cols, outptrs, outlds, outvllds, start_channel, valid_channels, act_min, act_max };

  __asm__ __volatile__(
    "ldr x6, [%x[args], %[offsetof_Args_pad_bottom]]\n"
    "mov x22, SP\n"
    "mov x21, #0x8\n"
    ".inst 0xd503477f  // SMSTART ZA\n"
    "ldr x5, [%x[args], %[offsetof_Args_pad_top]]\n"
    "sub x20, x22, #0x8\n"
    "ptrue p2.b\n"
    "ldr x7, [%x[args], %[offsetof_Args_n_channels]]\n"
    "and x20, x20, #-0x400\n"
    ".inst 0x25207812  // ptrue pn10.b\n"
    "ld1rw { z8.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_min]]\n"
    "sub x21, x21, x6\n"
    "mov SP, x20\n"
    "ldr x17, [%x[args], %[offsetof_Args_current_channel]]\n"
    "ld1rw { z29.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_max]]\n"
    "str x22, [SP]\n"
    "addvl SP, SP, #-30\n"
    "whilelt p1.s, XZR, x7\n"
    "whilelt p9.s, XZR, x21\n"
    "whilelt p8.s, XZR, x5\n"
    "eor p8.b, p2/Z, p8.b, p9.b\n"
    "1:"  // Channel loop
    "ldr x20, [%x[args], %[offsetof_Args_bias]]\n"
    "fmov z18.s, #0x0\n"
    "cbz x20, 2f\n"
    "ld1w { z18.s }, p1/Z, [x20, x17, LSL #2]\n"
    "2:"  // Load bias: Done
    "ldr x28, [%x[args], %[offsetof_Args_weights]]\n"
    "fmov z27.s, #0x0\n"
    "addvl x27, SP, #30\n"
    "mov x26, #0x8\n"
    "addvl x27, x27, #-6\n"
    "ldr x25, [%x[args], %[offsetof_Args_input_cols]]\n"
    "add x24, x5, x6\n"
    "mov z19.d, z18.d\n"
    "ldr x16, [%x[args], %[offsetof_Args_inptr]]\n"
    "lsl x23, %x[ld_in_row], #0x2\n"
    "mov x11, #0x0\n"
    "mov x22, x28\n"
    "incb x28\n"
    "ldr x15, [%x[args], %[offsetof_Args_output_cols]]\n"
    "ld1w { z23.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    "sub x20, x25, #0x1\n"
    "ld1w { z30.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    "orr x21, x20, %x[ld_in_col], LSL #18\n"
    "ld1w { z25.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    "orr x21, x7, x21, LSL #20\n"
    "ld1w { z26.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    ".inst 0x658aaaef  // bfcvt z15.h, p2/M, z23.s\n"
    ".inst 0x648aaafb  // bfcvtnt z27.h, p2/M, z23.s\n"
    "ld1w { z16.s }, p2/Z, [x22]\n"
    ".inst 0x658aabc4  // bfcvt z4.h, p2/M, z30.s\n"
    "mov x20, x28\n"
    "incb x28\n"
    ".inst 0x658aab21  // bfcvt z1.h, p2/M, z25.s\n"
    "ld1w { z22.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "mov x8, #0x8\n"
    ".inst 0x658aab4c  // bfcvt z12.h, p2/M, z26.s\n"
    "lsl x21, x21, #0x2\n"
    "sub x26, x26, x24\n"
    "st1h { z27.h }, p2, [x27]\n"
    ".inst 0x648aabcf  // bfcvtnt z15.h, p2/M, z30.s\n"
    "ld1w { z7.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "fmov z17.s, #0x0\n"
    ".inst 0x648aab24  // bfcvtnt z4.h, p2/M, z25.s\n"
    "ld1w { z0.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aab41  // bfcvtnt z1.h, p2/M, z26.s\n"
    "ld1w { z21.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aaa0e  // bfcvt z14.h, p2/M, z16.s\n"
    ".inst 0x648aaa0c  // bfcvtnt z12.h, p2/M, z16.s\n"
    "ld1w { z20.s }, p2/Z, [x20]\n"
    "mov x20, x28\n"
    "incb x28\n"
    "st1h { z15.h }, p2, [x27, #1, MUL VL]\n"
    ".inst 0x658aaadf  // bfcvt z31.h, p2/M, z22.s\n"
    "madd x23, x23, x5, x16\n"
    "st1h { z4.h }, p2, [x27, #2, MUL VL]\n"
    ".inst 0x658aa8fc  // bfcvt z28.h, p2/M, z7.s\n"
    ".inst 0x648aaad1  // bfcvtnt z17.h, p2/M, z22.s\n"
    "st1h { z1.h }, p2, [x27, #3, MUL VL]\n"
    ".inst 0x658aa81b  // bfcvt z27.h, p2/M, z0.s\n"
    "ld1w { z9.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z12.h }, p2, [x27, #4, MUL VL]\n"
    ".inst 0x658aaaaf  // bfcvt z15.h, p2/M, z21.s\n"
    "st1h { z14.h }, p2, [x27, #5, MUL VL]\n"
    "addvl x27, x27, #-6\n"
    ".inst 0x648aa8ff  // bfcvtnt z31.h, p2/M, z7.s\n"
    "ld1w { z26.s }, p2/Z, [x20]\n"
    "st1h { z17.h }, p2, [x27]\n"
    "incb x20, ALL, MUL #5\n"
    "fmov z25.s, #0x0\n"
    ".inst 0x648aa81c  // bfcvtnt z28.h, p2/M, z0.s\n"
    "ld1w { z1.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aaabb  // bfcvtnt z27.h, p2/M, z21.s\n"
    ".inst 0x658aaa83  // bfcvt z3.h, p2/M, z20.s\n"
    "ld1w { z4.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aaa8f  // bfcvtnt z15.h, p2/M, z20.s\n"
    "st1h { z31.h }, p2, [x27, #1, MUL VL]\n"
    ".inst 0x658aa92c  // bfcvt z12.h, p2/M, z9.s\n"
    "ld1w { z0.s }, p2/Z, [x20]\n"
    "mov x20, x28\n"
    "st1h { z28.h }, p2, [x27, #2, MUL VL]\n"
    ".inst 0x658aab57  // bfcvt z23.h, p2/M, z26.s\n"
    ".inst 0x648aa939  // bfcvtnt z25.h, p2/M, z9.s\n"
    "incb x28\n"
    "st1h { z27.h }, p2, [x27, #3, MUL VL]\n"
    ".inst 0x658aa83e  // bfcvt z30.h, p2/M, z1.s\n"
    "ld1w { z11.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z15.h }, p2, [x27, #4, MUL VL]\n"
    ".inst 0x658aa894  // bfcvt z20.h, p2/M, z4.s\n"
    "st1h { z3.h }, p2, [x27, #5, MUL VL]\n"
    "addvl x27, x27, #-6\n"
    ".inst 0x648aab4c  // bfcvtnt z12.h, p2/M, z26.s\n"
    "ld1w { z7.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z25.h }, p2, [x27]\n"
    ".inst 0x648aa837  // bfcvtnt z23.h, p2/M, z1.s\n"
    "fmov z22.s, #0x0\n"
    "ld1w { z25.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aa89e  // bfcvtnt z30.h, p2/M, z4.s\n"
    ".inst 0x658aa810  // bfcvt z16.h, p2/M, z0.s\n"
    "ld1w { z3.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aa814  // bfcvtnt z20.h, p2/M, z0.s\n"
    "st1h { z12.h }, p2, [x27, #1, MUL VL]\n"
    ".inst 0x658aa964  // bfcvt z4.h, p2/M, z11.s\n"
    "ld1w { z24.s }, p2/Z, [x20]\n"
    "mov x20, x28\n"
    "st1h { z23.h }, p2, [x27, #2, MUL VL]\n"
    ".inst 0x658aa8e9  // bfcvt z9.h, p2/M, z7.s\n"
    ".inst 0x648aa976  // bfcvtnt z22.h, p2/M, z11.s\n"
    "st1h { z30.h }, p2, [x27, #3, MUL VL]\n"
    ".inst 0x658aab3c  // bfcvt z28.h, p2/M, z25.s\n"
    "ld1w { z11.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z20.h }, p2, [x27, #4, MUL VL]\n"
    ".inst 0x658aa861  // bfcvt z1.h, p2/M, z3.s\n"
    ".inst 0x648aa8e4  // bfcvtnt z4.h, p2/M, z7.s\n"
    "ld1w { z2.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z16.h }, p2, [x27, #5, MUL VL]\n"
    ".inst 0x648aab29  // bfcvtnt z9.h, p2/M, z25.s\n"
    "ld1w { z12.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "addvl x27, x27, #-6\n"
    ".inst 0x648aa87c  // bfcvtnt z28.h, p2/M, z3.s\n"
    "ld1w { z27.s }, p2/Z, [x20]\n"
    "st1h { z22.h }, p2, [x27]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aab01  // bfcvtnt z1.h, p2/M, z24.s\n"
    "fmov z17.s, #0x0\n"
    "st1h { z4.h }, p2, [x27, #1, MUL VL]\n"
    ".inst 0x658aa97e  // bfcvt z30.h, p2/M, z11.s\n"
    ".inst 0x658aab0a  // bfcvt z10.h, p2/M, z24.s\n"
    "st1h { z9.h }, p2, [x27, #2, MUL VL]\n"
    ".inst 0x658aa84f  // bfcvt z15.h, p2/M, z2.s\n"
    "ld1w { z26.s }, p2/Z, [x20]\n"
    "st1h { z28.h }, p2, [x27, #3, MUL VL]\n"
    ".inst 0x658aa98e  // bfcvt z14.h, p2/M, z12.s\n"
    "st1h { z1.h }, p2, [x27, #4, MUL VL]\n"
    ".inst 0x658aab75  // bfcvt z21.h, p2/M, z27.s\n"
    ".inst 0x648aa971  // bfcvtnt z17.h, p2/M, z11.s\n"
    "st1h { z10.h }, p2, [x27, #5, MUL VL]\n"
    "addvl x27, x27, #-6\n"
    ".inst 0x648aa85e  // bfcvtnt z30.h, p2/M, z2.s\n"
    ".inst 0x658aab4a  // bfcvt z10.h, p2/M, z26.s\n"
    ".inst 0x648aa98f  // bfcvtnt z15.h, p2/M, z12.s\n"
    ".inst 0x648aab6e  // bfcvtnt z14.h, p2/M, z27.s\n"
    "st1h { z17.h }, p2, [x27]\n"
    ".inst 0x648aab55  // bfcvtnt z21.h, p2/M, z26.s\n"
    "st1h { z30.h }, p2, [x27, #1, MUL VL]\n"
    "st1h { z15.h }, p2, [x27, #2, MUL VL]\n"
    "st1h { z14.h }, p2, [x27, #3, MUL VL]\n"
    "st1h { z21.h }, p2, [x27, #4, MUL VL]\n"
    "st1h { z10.h }, p2, [x27, #5, MUL VL]\n"
    "3:"  // Issue prefetches
    "subs x26, x26, #0x1\n"
    ".inst 0xf8b54afc  // rprfm pldstrm, x21, [x23]\n"
    "add x23, x23, %x[ld_in_col], LSL #2\n"
    "bgt 3b\n"
    "ldr x23, [%x[args], %[offsetof_Args_outptrs]]\n"
    "lsl x21, %x[ld_in_row], #0x2\n"
    ".inst 0xc0046a40  // mova za.d[x11, #0], { z18.d-z19.d }\n"
    "mov x22, #0x4\n"
    "ldr x20, [%x[args], %[offsetof_Args_ld_out_cols]]\n"
    "msub x16, x5, x21, x16\n"
    ".inst 0xc0046a41  // mova za.d[x11, #1], { z18.d-z19.d }\n"
    "ldr x21, [%x[args], %[offsetof_Args_pad_left]]\n"
    ".inst 0xc0046a42  // mova za.d[x11, #2], { z18.d-z19.d }\n"
    "ldp x14, x13, [x23], #0x10\n"
    ".inst 0xc0046a43  // mova za.d[x11, #3], { z18.d-z19.d }\n"
    "ldp x2, x10, [x20], #0x10\n"
    ".inst 0xc0046a44  // mova za.d[x11, #4], { z18.d-z19.d }\n"
    ".inst 0xc0046a45  // mova za.d[x11, #5], { z18.d-z19.d }\n"
    "ldp x9, x28, [x23], #0x10\n"
    ".inst 0xc0046a46  // mova za.d[x11, #6], { z18.d-z19.d }\n"
    "ldp x27, x26, [x20], #0x10\n"
    ".inst 0xc0046a47  // mova za.d[x11, #7], { z18.d-z19.d }\n"
    ".inst 0xc0040a40  // mova za.d[x8, #0], { z18.d-z19.d }\n"
    ".inst 0xc0040a41  // mova za.d[x8, #1], { z18.d-z19.d }\n"
    "cbz x21, 5f\n"
    "cmp x21, x22\n"
    "csel x20, x21, x22, LT\n"
    "sub x21, x21, x20\n"
    "sub x22, x22, x20\n"
    "cbz x21, 5f\n"
    ".inst 0xc0066800  // mova { z0.d-z1.d }, za.d[x11, #0]\n"
    "sub x15, x15, x21\n"
    ".inst 0xc0066822  // mova { z2.d-z3.d }, za.d[x11, #1]\n"
    ".inst 0xc1bdc900  // fclamp { z0.s-z3.s }, z8.s, z29.s\n"
    "4:"  // Left padding
    "subs x21, x21, #0x1\n"
    "st1w { z0.s }, p1, [x14]\n"
    "add x14, x14, x2, LSL #2\n"
    "st1w { z2.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "st1w { z1.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z3.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 4b\n"
    "5:"  // Left padding: End
    "adds XZR, x5, x6\n"
    "bne 12f\n"
    "cbz x22, 10f\n"
    "cmp x22, #0x1\n"
    "sub x25, x25, x22\n"
    "beq 9f\n"
    "cmp x22, #0x2\n"
    "beq 8f\n"
    "cmp x22, #0x3\n"
    "beq 7f\n"
    "6:"  // Unpadded: 4 priming loads
    "add x21, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z21.s }, p1/Z, [x16]\n"
    "addvl x20, SP, #24\n"
    "ld1w { z0.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z11.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "ld1w { z28.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaab7  // bfcvt z23.h, p2/M, z21.s\n"
    "ld1w { z13.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa978  // bfcvt z24.h, p2/M, z11.s\n"
    "ld1w { z14.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1402a81  // ld1h { z1.h, z9.h }, pn10.b/Z, [x20]\n"
    ".inst 0x648aa817  // bfcvtnt z23.h, p2/M, z0.s\n"
    ".inst 0x658aa9b9  // bfcvt z25.h, p2/M, z13.s\n"
    "ld1w { z6.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1412a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0x648aab98  // bfcvtnt z24.h, p2/M, z28.s\n"
    "ld1w { z30.s }, p1/Z, [x21]\n"
    ".inst 0x658aa8da  // bfcvt z26.h, p2/M, z6.s\n"
    ".inst 0xa1422a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0x648aa9d9  // bfcvtnt z25.h, p2/M, z14.s\n"
    ".inst 0xc12972f0  // bfdot za.s[x11, 0], { z23.h-z24.h }, z9.h\n"
    ".inst 0xc12172f1  // bfdot za.s[x11, 1], { z23.h-z24.h }, z1.h\n"
    ".inst 0x648aabda  // bfcvtnt z26.h, p2/M, z30.s\n"
    ".inst 0xc12d7310  // bfdot za.s[x11, 0], { z24.h-z25.h }, z13.h\n"
    ".inst 0xc1257311  // bfdot za.s[x11, 1], { z24.h-z25.h }, z5.h\n"
    ".inst 0xc12f7330  // bfdot za.s[x11, 0], { z25.h-z26.h }, z15.h\n"
    ".inst 0xc1277331  // bfdot za.s[x11, 1], { z25.h-z26.h }, z7.h\n"
    "7:"  // Unpadded: 3 priming loads
    "add x22, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z31.s }, p1/Z, [x16]\n"
    "addvl x21, SP, #18\n"
    "ld1w { z15.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "addvl x20, SP, #24\n"
    "ld1w { z21.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z23.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabfe  // bfcvt z30.h, p2/M, z31.s\n"
    "ld1w { z20.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaabf  // bfcvt z31.h, p2/M, z21.s\n"
    "ld1w { z10.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1402aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21]\n"
    ".inst 0x648aa9fe  // bfcvtnt z30.h, p2/M, z15.s\n"
    ".inst 0x658aaa80  // bfcvt z0.h, p2/M, z20.s\n"
    "ld1w { z15.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1412aa3  // ld1h { z3.h, z11.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0x648aaaff  // bfcvtnt z31.h, p2/M, z23.s\n"
    "ld1w { z4.s }, p1/Z, [x22]\n"
    ".inst 0x658aa9e1  // bfcvt z1.h, p2/M, z15.s\n"
    ".inst 0xa1422aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0x648aa940  // bfcvtnt z0.h, p2/M, z10.s\n"
    ".inst 0xc12e73d0  // bfdot za.s[x11, 0], { z30.h-z31.h }, z14.h\n"
    ".inst 0xc12673d1  // bfdot za.s[x11, 1], { z30.h-z31.h }, z6.h\n"
    ".inst 0xa1402a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20]\n"
    ".inst 0x648aa881  // bfcvtnt z1.h, p2/M, z4.s\n"
    ".inst 0xc12f73d2  // bfdot za.s[x11, 2], { z30.h-z31.h }, z15.h\n"
    ".inst 0xc12773d3  // bfdot za.s[x11, 3], { z30.h-z31.h }, z7.h\n"
    ".inst 0xc12b73f0  // bfdot za.s[x11, 0], { z31.h-z0.h }, z11.h\n"
    ".inst 0xc12373f1  // bfdot za.s[x11, 1], { z31.h-z0.h }, z3.h\n"
    ".inst 0xa0412a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12f73f2  // bfdot za.s[x11, 2], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12e73f3  // bfdot za.s[x11, 3], { z31.h-z0.h }, z14.h\n"
    ".inst 0xc12d7010  // bfdot za.s[x11, 0], { z0.h-z1.h }, z13.h\n"
    ".inst 0xc1257011  // bfdot za.s[x11, 1], { z0.h-z1.h }, z5.h\n"
    ".inst 0xa1422a82  // ld1h { z2.h, z10.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12a7012  // bfdot za.s[x11, 2], { z0.h-z1.h }, z10.h\n"
    ".inst 0xc1227013  // bfdot za.s[x11, 3], { z0.h-z1.h }, z2.h\n"
    "8:"  // Unpadded: 2 priming loads
    "add x23, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z15.s }, p1/Z, [x16]\n"
    "addvl x22, SP, #12\n"
    "ld1w { z21.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "addvl x21, SP, #18\n"
    "ld1w { z31.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "addvl x20, SP, #24\n"
    "ld1w { z22.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa9e2  // bfcvt z2.h, p2/M, z15.s\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z10.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabe3  // bfcvt z3.h, p2/M, z31.s\n"
    "ld1w { z1.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xa0402ace  // ld1h { z14.h-z15.h }, pn10.b/Z, [x22]\n"
    ".inst 0x648aaaa2  // bfcvtnt z2.h, p2/M, z21.s\n"
    ".inst 0x658aa944  // bfcvt z4.h, p2/M, z10.s\n"
    "ld1w { z13.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xa0412ac6  // ld1h { z6.h-z7.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0x648aaac3  // bfcvtnt z3.h, p2/M, z22.s\n"
    "ld1w { z12.s }, p1/Z, [x23]\n"
    ".inst 0x658aa9a5  // bfcvt z5.h, p2/M, z13.s\n"
    ".inst 0xa0422aca  // ld1h { z10.h-z11.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0x648aa824  // bfcvtnt z4.h, p2/M, z1.s\n"
    ".inst 0xc12f7050  // bfdot za.s[x11, 0], { z2.h-z3.h }, z15.h\n"
    ".inst 0xc12e7051  // bfdot za.s[x11, 1], { z2.h-z3.h }, z14.h\n"
    ".inst 0xa1402aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21]\n"
    ".inst 0x648aa985  // bfcvtnt z5.h, p2/M, z12.s\n"
    ".inst 0xc1297052  // bfdot za.s[x11, 2], { z2.h-z3.h }, z9.h\n"
    ".inst 0xc1217053  // bfdot za.s[x11, 3], { z2.h-z3.h }, z1.h\n"
    ".inst 0xa0402a8c  // ld1h { z12.h-z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1277070  // bfdot za.s[x11, 0], { z3.h-z4.h }, z7.h\n"
    ".inst 0xc1267071  // bfdot za.s[x11, 1], { z3.h-z4.h }, z6.h\n"
    ".inst 0xa0412aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12d7054  // bfdot za.s[x11, 4], { z2.h-z3.h }, z13.h\n"
    ".inst 0xc12c7055  // bfdot za.s[x11, 5], { z2.h-z3.h }, z12.h\n"
    ".inst 0xc12f7072  // bfdot za.s[x11, 2], { z3.h-z4.h }, z15.h\n"
    ".inst 0xc12e7073  // bfdot za.s[x11, 3], { z3.h-z4.h }, z14.h\n"
    ".inst 0xa0412a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12b7090  // bfdot za.s[x11, 0], { z4.h-z5.h }, z11.h\n"
    ".inst 0xc12a7091  // bfdot za.s[x11, 1], { z4.h-z5.h }, z10.h\n"
    ".inst 0xa0422aaa  // ld1h { z10.h-z11.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12f7074  // bfdot za.s[x11, 4], { z3.h-z4.h }, z15.h\n"
    ".inst 0xc12e7075  // bfdot za.s[x11, 5], { z3.h-z4.h }, z14.h\n"
    ".inst 0xc12b7092  // bfdot za.s[x11, 2], { z4.h-z5.h }, z11.h\n"
    ".inst 0xc12a7093  // bfdot za.s[x11, 3], { z4.h-z5.h }, z10.h\n"
    ".inst 0xa1422a86  // ld1h { z6.h, z14.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12e7094  // bfdot za.s[x11, 4], { z4.h-z5.h }, z14.h\n"
    ".inst 0xc1267095  // bfdot za.s[x11, 5], { z4.h-z5.h }, z6.h\n"
    "9:"  // Unpadded: 1 priming loads
    "add x24, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z7.s }, p1/Z, [x16]\n"
    "addvl x23, SP, #6\n"
    "ld1w { z27.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    "addvl x22, SP, #12\n"
    "ld1w { z26.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    "addvl x21, SP, #18\n"
    "ld1w { z23.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8ff  // bfcvt z31.h, p2/M, z7.s\n"
    "addvl x20, SP, #24\n"
    "ld1w { z7.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0x658aab40  // bfcvt z0.h, p2/M, z26.s\n"
    "ld1w { z24.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1402ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23]\n"
    ".inst 0x648aab7f  // bfcvtnt z31.h, p2/M, z27.s\n"
    ".inst 0x658aa8e1  // bfcvt z1.h, p2/M, z7.s\n"
    "ld1w { z30.s }, p1/Z, [x24]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xa0412aec  // ld1h { z12.h-z13.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0x648aaae0  // bfcvtnt z0.h, p2/M, z23.s\n"
    "ld1w { z9.s }, p1/Z, [x24]\n"
    ".inst 0x658aabc2  // bfcvt z2.h, p2/M, z30.s\n"
    ".inst 0xa0422ae4  // ld1h { z4.h-z5.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0x648aab01  // bfcvtnt z1.h, p2/M, z24.s\n"
    ".inst 0xc12e73f0  // bfdot za.s[x11, 0], { z31.h-z0.h }, z14.h\n"
    ".inst 0xc12673f1  // bfdot za.s[x11, 1], { z31.h-z0.h }, z6.h\n"
    ".inst 0xa1402ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22]\n"
    ".inst 0x648aa922  // bfcvtnt z2.h, p2/M, z9.s\n"
    ".inst 0xc12f73f2  // bfdot za.s[x11, 2], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12773f3  // bfdot za.s[x11, 3], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1402aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12d7010  // bfdot za.s[x11, 0], { z0.h-z1.h }, z13.h\n"
    ".inst 0xc12c7011  // bfdot za.s[x11, 1], { z0.h-z1.h }, z12.h\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12e73f4  // bfdot za.s[x11, 4], { z31.h-z0.h }, z14.h\n"
    ".inst 0xc12673f5  // bfdot za.s[x11, 5], { z31.h-z0.h }, z6.h\n"
    ".inst 0xa1402a86  // ld1h { z6.h, z14.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f7012  // bfdot za.s[x11, 2], { z0.h-z1.h }, z15.h\n"
    ".inst 0xc1277013  // bfdot za.s[x11, 3], { z0.h-z1.h }, z7.h\n"
    ".inst 0xa0412aac  // ld1h { z12.h-z13.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc1257030  // bfdot za.s[x11, 0], { z1.h-z2.h }, z5.h\n"
    ".inst 0xc1247031  // bfdot za.s[x11, 1], { z1.h-z2.h }, z4.h\n"
    ".inst 0xa0422aca  // ld1h { z10.h-z11.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12e73f6  // bfdot za.s[x11, 6], { z31.h-z0.h }, z14.h\n"
    ".inst 0xc12673f7  // bfdot za.s[x11, 7], { z31.h-z0.h }, z6.h\n"
    ".inst 0xc12d7014  // bfdot za.s[x11, 4], { z0.h-z1.h }, z13.h\n"
    ".inst 0xc12c7015  // bfdot za.s[x11, 5], { z0.h-z1.h }, z12.h\n"
    ".inst 0xa0412a86  // ld1h { z6.h-z7.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12b7032  // bfdot za.s[x11, 2], { z1.h-z2.h }, z11.h\n"
    ".inst 0xc12a7033  // bfdot za.s[x11, 3], { z1.h-z2.h }, z10.h\n"
    ".inst 0xa0422aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc1277016  // bfdot za.s[x11, 6], { z0.h-z1.h }, z7.h\n"
    ".inst 0xc1267017  // bfdot za.s[x11, 7], { z0.h-z1.h }, z6.h\n"
    ".inst 0xc12f7034  // bfdot za.s[x11, 4], { z1.h-z2.h }, z15.h\n"
    ".inst 0xc12e7035  // bfdot za.s[x11, 5], { z1.h-z2.h }, z14.h\n"
    ".inst 0xa1422a86  // ld1h { z6.h, z14.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12e7036  // bfdot za.s[x11, 6], { z1.h-z2.h }, z14.h\n"
    ".inst 0xc1267037  // bfdot za.s[x11, 7], { z1.h-z2.h }, z6.h\n"
    "10:"  // Unpadded: 0 priming loads
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    ".inst 0xa0412be4  // ld1h { z4.h-z5.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0xa1422be2  // ld1h { z2.h, z10.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    "cbz x25, 20f\n"
    "add x20, x16, %x[ld_in_row], LSL #2\n"
    "ld1w { z22.s }, p1/Z, [x16]\n"
    "sub x25, x25, #0x1\n"
    "ld1w { z16.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "sub x15, x15, #0x1\n"
    "ld1w { z25.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "cmp x25, x15\n"
    "ld1w { z7.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaade  // bfcvt z30.h, p2/M, z22.s\n"
    "csel x25, x25, x15, LT\n"
    "ld1w { z28.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "ld1w { z9.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab3f  // bfcvt z31.h, p2/M, z25.s\n"
    "sub x15, x15, x25\n"
    "ld1w { z17.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab80  // bfcvt z0.h, p2/M, z28.s\n"
    "ld1w { z12.s }, p1/Z, [x20]\n"
    ".inst 0x648aaa1e  // bfcvtnt z30.h, p2/M, z16.s\n"
    ".inst 0x658aaa21  // bfcvt z1.h, p2/M, z17.s\n"
    ".inst 0x648aa8ff  // bfcvtnt z31.h, p2/M, z7.s\n"
    ".inst 0x648aa920  // bfcvtnt z0.h, p2/M, z9.s\n"
    ".inst 0x648aa981  // bfcvtnt z1.h, p2/M, z12.s\n"
    "cbz x25, 19f\n"
    "11:"  // Unpadded: Main loop
    "addvl x24, SP, #6\n"
    ".inst 0xc12b73d0  // bfdot za.s[x11, 0], { z30.h-z31.h }, z11.h\n"
    "addvl x23, SP, #12\n"
    "ld1w { z25.s }, p1/Z, [x16]\n"
    ".inst 0xc12373d1  // bfdot za.s[x11, 1], { z30.h-z31.h }, z3.h\n"
    ".inst 0xa0402b0e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x24]\n"
    "addvl x22, SP, #18\n"
    "addvl x21, SP, #24\n"
    "add x20, x16, %x[ld_in_row], LSL #2\n"
    "subs x25, x25, #0x1\n"
    "ld1w { z24.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xc12f73d2  // bfdot za.s[x11, 2], { z30.h-z31.h }, z15.h\n"
    "ld1w { z23.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12e73d3  // bfdot za.s[x11, 3], { z30.h-z31.h }, z14.h\n"
    ".inst 0xa1402ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23]\n"
    ".inst 0xc12573f0  // bfdot za.s[x11, 0], { z31.h-z0.h }, z5.h\n"
    "ld1w { z22.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12473f1  // bfdot za.s[x11, 1], { z31.h-z0.h }, z4.h\n"
    ".inst 0xa1412b07  // ld1h { z7.h, z15.h }, pn10.b/Z, [x24, #0x2, MUL VL]\n"
    ".inst 0xc12e73d4  // bfdot za.s[x11, 4], { z30.h-z31.h }, z14.h\n"
    "ld1w { z21.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12673d5  // bfdot za.s[x11, 5], { z30.h-z31.h }, z6.h\n"
    ".inst 0xa1402ac5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc12f73f2  // bfdot za.s[x11, 2], { z31.h-z0.h }, z15.h\n"
    "ld1w { z20.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12773f3  // bfdot za.s[x11, 3], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12a7010  // bfdot za.s[x11, 0], { z0.h-z1.h }, z10.h\n"
    "ld1w { z17.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1227011  // bfdot za.s[x11, 1], { z0.h-z1.h }, z2.h\n"
    ".inst 0xa1422b06  // ld1h { z6.h, z14.h }, pn10.b/Z, [x24, #0x4, MUL VL]\n"
    ".inst 0xc12d73d6  // bfdot za.s[x11, 6], { z30.h-z31.h }, z13.h\n"
    "ld1w { z16.s }, p1/Z, [x20]\n"
    ".inst 0xc12573d7  // bfdot za.s[x11, 7], { z30.h-z31.h }, z5.h\n"
    ".inst 0xa1402aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12f73f4  // bfdot za.s[x11, 4], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12773f5  // bfdot za.s[x11, 5], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12e7012  // bfdot za.s[x11, 2], { z0.h-z1.h }, z14.h\n"
    ".inst 0xc1267013  // bfdot za.s[x11, 3], { z0.h-z1.h }, z6.h\n"
    ".inst 0xa1422ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc12f73f6  // bfdot za.s[x11, 6], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12773f7  // bfdot za.s[x11, 7], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12e7014  // bfdot za.s[x11, 4], { z0.h-z1.h }, z14.h\n"
    ".inst 0xc1267015  // bfdot za.s[x11, 5], { z0.h-z1.h }, z6.h\n"
    ".inst 0xa1422ac3  // ld1h { z3.h, z11.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12b7016  // bfdot za.s[x11, 6], { z0.h-z1.h }, z11.h\n"
    ".inst 0xc1237017  // bfdot za.s[x11, 7], { z0.h-z1.h }, z3.h\n"
    ".inst 0xa1422aa2  // ld1h { z2.h, z10.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12d13d0  // bfdot za.s[x8, 0], { z30.h-z31.h }, z13.h\n"
    ".inst 0xc12513d1  // bfdot za.s[x8, 1], { z30.h-z31.h }, z5.h\n"
    ".inst 0x658aab3e  // bfcvt z30.h, p2/M, z25.s\n"
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    ".inst 0xc12f13f0  // bfdot za.s[x8, 0], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12713f1  // bfdot za.s[x8, 1], { z31.h-z0.h }, z7.h\n"
    ".inst 0x658aaaff  // bfcvt z31.h, p2/M, z23.s\n"
    ".inst 0xa0412be4  // ld1h { z4.h-z5.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0x648aab1e  // bfcvtnt z30.h, p2/M, z24.s\n"
    ".inst 0xc12a1010  // bfdot za.s[x8, 0], { z0.h-z1.h }, z10.h\n"
    ".inst 0xc1221011  // bfdot za.s[x8, 1], { z0.h-z1.h }, z2.h\n"
    ".inst 0x658aaaa0  // bfcvt z0.h, p2/M, z21.s\n"
    ".inst 0x658aaa21  // bfcvt z1.h, p2/M, z17.s\n"
    "add x8, x8, #0x2\n"
    ".inst 0xa1422be2  // ld1h { z2.h, z10.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    ".inst 0x648aaadf  // bfcvtnt z31.h, p2/M, z22.s\n"
    ".inst 0xc006680c  // mova { z12.d-z13.d }, za.d[x11, #0]\n"
    ".inst 0x648aaa80  // bfcvtnt z0.h, p2/M, z20.s\n"
    ".inst 0x648aaa01  // bfcvtnt z1.h, p2/M, z16.s\n"
    ".inst 0xc006682e  // mova { z14.d-z15.d }, za.d[x11, #1]\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040a40  // mova za.d[x8, #0], { z18.d-z19.d }\n"
    ".inst 0xc0040a41  // mova za.d[x8, #1], { z18.d-z19.d }\n"
    ".inst 0xc1bdc90c  // fclamp { z12.s-z15.s }, z8.s, z29.s\n"
    "st1w { z12.s }, p1, [x14]\n"
    "add x14, x14, x2, LSL #2\n"
    "st1w { z14.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "st1w { z13.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z15.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 11b\n"
    "b 19f\n"
    "12:"  // Padded
    "cbz x22, 17f\n"
    "cmp x22, #0x1\n"
    "sub x25, x25, x22\n"
    "beq 16f\n"
    "cmp x22, #0x2\n"
    "beq 15f\n"
    "cmp x22, #0x3\n"
    "beq 14f\n"
    "13:"  // Padded: 4 priming loads
    "mov x12, #0x0\n"
    "add x21, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x20, SP, #24\n"
    ".inst 0xa1402a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xa1412a86  // ld1h { z6.h, z14.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    "ld1w { z17.s }, p0/Z, [x16]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xa1422a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa29  // bfcvt z9.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa09  // bfcvtnt z9.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa2a  // bfcvt z10.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa0a  // bfcvtnt z10.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa2b  // bfcvt z11.h, p2/M, z17.s\n"
    ".inst 0xc12d7130  // bfdot za.s[x11, 0], { z9.h-z10.h }, z13.h\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1257131  // bfdot za.s[x11, 1], { z9.h-z10.h }, z5.h\n"
    ".inst 0x648aaa0b  // bfcvtnt z11.h, p2/M, z16.s\n"
    ".inst 0x658aaa2c  // bfcvt z12.h, p2/M, z17.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0xc12e7150  // bfdot za.s[x11, 0], { z10.h-z11.h }, z14.h\n"
    ".inst 0xc1267151  // bfdot za.s[x11, 1], { z10.h-z11.h }, z6.h\n"
    ".inst 0x648aaa0c  // bfcvtnt z12.h, p2/M, z16.s\n"
    ".inst 0xc12f7170  // bfdot za.s[x11, 0], { z11.h-z12.h }, z15.h\n"
    ".inst 0xc1277171  // bfdot za.s[x11, 1], { z11.h-z12.h }, z7.h\n"
    "14:"  // Padded: 3 priming loads
    "mov x12, #0x0\n"
    "add x22, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x21, SP, #18\n"
    ".inst 0xa1402aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21]\n"
    "addvl x20, SP, #24\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xa0422aa0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa18  // bfcvt z24.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa38  // bfcvtnt z24.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa19  // bfcvt z25.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa39  // bfcvtnt z25.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1a  // bfcvt z26.h, p2/M, z16.s\n"
    ".inst 0xc12e7310  // bfdot za.s[x11, 0], { z24.h-z25.h }, z14.h\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1267311  // bfdot za.s[x11, 1], { z24.h-z25.h }, z6.h\n"
    ".inst 0x648aaa3a  // bfcvtnt z26.h, p2/M, z17.s\n"
    ".inst 0xa1402a84  // ld1h { z4.h, z12.h }, pn10.b/Z, [x20]\n"
    ".inst 0x658aaa1b  // bfcvt z27.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0xc12c7312  // bfdot za.s[x11, 2], { z24.h-z25.h }, z12.h\n"
    ".inst 0xc1247313  // bfdot za.s[x11, 3], { z24.h-z25.h }, z4.h\n"
    ".inst 0xc12f7330  // bfdot za.s[x11, 0], { z25.h-z26.h }, z15.h\n"
    ".inst 0x648aaa1b  // bfcvtnt z27.h, p2/M, z16.s\n"
    ".inst 0xc1277331  // bfdot za.s[x11, 1], { z25.h-z26.h }, z7.h\n"
    ".inst 0xa0412a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12f7332  // bfdot za.s[x11, 2], { z25.h-z26.h }, z15.h\n"
    ".inst 0xc12e7333  // bfdot za.s[x11, 3], { z25.h-z26.h }, z14.h\n"
    ".inst 0xc1217350  // bfdot za.s[x11, 0], { z26.h-z27.h }, z1.h\n"
    ".inst 0xc1207351  // bfdot za.s[x11, 1], { z26.h-z27.h }, z0.h\n"
    ".inst 0xa0422a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12f7352  // bfdot za.s[x11, 2], { z26.h-z27.h }, z15.h\n"
    ".inst 0xc12e7353  // bfdot za.s[x11, 3], { z26.h-z27.h }, z14.h\n"
    "15:"  // Padded: 2 priming loads
    "mov x12, #0x0\n"
    "add x23, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x22, SP, #12\n"
    ".inst 0xa1402ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22]\n"
    "addvl x21, SP, #18\n"
    "addvl x20, SP, #24\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xa1422ac4  // ld1h { z4.h, z12.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    "ld1w { z17.s }, p0/Z, [x23]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa19  // bfcvt z25.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa39  // bfcvtnt z25.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x23]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1a  // bfcvt z26.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa3a  // bfcvtnt z26.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x23]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1b  // bfcvt z27.h, p2/M, z16.s\n"
    ".inst 0xc12e7330  // bfdot za.s[x11, 0], { z25.h-z26.h }, z14.h\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1267331  // bfdot za.s[x11, 1], { z25.h-z26.h }, z6.h\n"
    ".inst 0x648aaa3b  // bfcvtnt z27.h, p2/M, z17.s\n"
    ".inst 0xa0402aaa  // ld1h { z10.h-z11.h }, pn10.b/Z, [x21]\n"
    ".inst 0x658aaa1c  // bfcvt z28.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x23]\n"
    ".inst 0xc12b7332  // bfdot za.s[x11, 2], { z25.h-z26.h }, z11.h\n"
    ".inst 0xc12a7333  // bfdot za.s[x11, 3], { z25.h-z26.h }, z10.h\n"
    ".inst 0xa1402a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f7350  // bfdot za.s[x11, 0], { z26.h-z27.h }, z15.h\n"
    ".inst 0x648aaa1c  // bfcvtnt z28.h, p2/M, z16.s\n"
    ".inst 0xc1277351  // bfdot za.s[x11, 1], { z26.h-z27.h }, z7.h\n"
    ".inst 0xa0412aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12d7334  // bfdot za.s[x11, 4], { z25.h-z26.h }, z13.h\n"
    ".inst 0xc1257335  // bfdot za.s[x11, 5], { z25.h-z26.h }, z5.h\n"
    ".inst 0xc12f7352  // bfdot za.s[x11, 2], { z26.h-z27.h }, z15.h\n"
    ".inst 0xc12e7353  // bfdot za.s[x11, 3], { z26.h-z27.h }, z14.h\n"
    ".inst 0xa1412a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12c7370  // bfdot za.s[x11, 0], { z27.h-z28.h }, z12.h\n"
    ".inst 0xc1247371  // bfdot za.s[x11, 1], { z27.h-z28.h }, z4.h\n"
    ".inst 0xa0422aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12d7354  // bfdot za.s[x11, 4], { z26.h-z27.h }, z13.h\n"
    ".inst 0xc1257355  // bfdot za.s[x11, 5], { z26.h-z27.h }, z5.h\n"
    ".inst 0xc12f7372  // bfdot za.s[x11, 2], { z27.h-z28.h }, z15.h\n"
    ".inst 0xc12e7373  // bfdot za.s[x11, 3], { z27.h-z28.h }, z14.h\n"
    ".inst 0xa0422a84  // ld1h { z4.h-z5.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc1257374  // bfdot za.s[x11, 4], { z27.h-z28.h }, z5.h\n"
    ".inst 0xc1247375  // bfdot za.s[x11, 5], { z27.h-z28.h }, z4.h\n"
    "16:"  // Padded: 1 priming loads
    "mov x12, #0x0\n"
    "add x24, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x23, SP, #6\n"
    ".inst 0xa1402ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23]\n"
    "addvl x22, SP, #12\n"
    "addvl x21, SP, #18\n"
    ".inst 0xa1412ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    "addvl x20, SP, #24\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xa0422ae0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    "ld1w { z17.s }, p0/Z, [x24]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa19  // bfcvt z25.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa39  // bfcvtnt z25.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x24]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1a  // bfcvt z26.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa3a  // bfcvtnt z26.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x24]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1b  // bfcvt z27.h, p2/M, z16.s\n"
    ".inst 0xc12e7330  // bfdot za.s[x11, 0], { z25.h-z26.h }, z14.h\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1267331  // bfdot za.s[x11, 1], { z25.h-z26.h }, z6.h\n"
    ".inst 0x648aaa3b  // bfcvtnt z27.h, p2/M, z17.s\n"
    ".inst 0xa1402ac2  // ld1h { z2.h, z10.h }, pn10.b/Z, [x22]\n"
    ".inst 0x658aaa1c  // bfcvt z28.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0xc12a7332  // bfdot za.s[x11, 2], { z25.h-z26.h }, z10.h\n"
    ".inst 0xc1227333  // bfdot za.s[x11, 3], { z25.h-z26.h }, z2.h\n"
    ".inst 0xa1402aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12f7350  // bfdot za.s[x11, 0], { z26.h-z27.h }, z15.h\n"
    ".inst 0x648aaa1c  // bfcvtnt z28.h, p2/M, z16.s\n"
    ".inst 0xc1277351  // bfdot za.s[x11, 1], { z26.h-z27.h }, z7.h\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12e7334  // bfdot za.s[x11, 4], { z25.h-z26.h }, z14.h\n"
    ".inst 0xc1267335  // bfdot za.s[x11, 5], { z25.h-z26.h }, z6.h\n"
    ".inst 0xa1402a85  // ld1h { z5.h, z13.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f7352  // bfdot za.s[x11, 2], { z26.h-z27.h }, z15.h\n"
    ".inst 0xc1277353  // bfdot za.s[x11, 3], { z26.h-z27.h }, z7.h\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc1217370  // bfdot za.s[x11, 0], { z27.h-z28.h }, z1.h\n"
    ".inst 0xc1207371  // bfdot za.s[x11, 1], { z27.h-z28.h }, z0.h\n"
    ".inst 0xa1422ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12d7336  // bfdot za.s[x11, 6], { z25.h-z26.h }, z13.h\n"
    ".inst 0xc1257337  // bfdot za.s[x11, 7], { z25.h-z26.h }, z5.h\n"
    ".inst 0xc12f7354  // bfdot za.s[x11, 4], { z26.h-z27.h }, z15.h\n"
    ".inst 0xc1277355  // bfdot za.s[x11, 5], { z26.h-z27.h }, z7.h\n"
    ".inst 0xa1412a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12e7372  // bfdot za.s[x11, 2], { z27.h-z28.h }, z14.h\n"
    ".inst 0xc1267373  // bfdot za.s[x11, 3], { z27.h-z28.h }, z6.h\n"
    ".inst 0xa1422aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12f7356  // bfdot za.s[x11, 6], { z26.h-z27.h }, z15.h\n"
    ".inst 0xc1277357  // bfdot za.s[x11, 7], { z26.h-z27.h }, z7.h\n"
    ".inst 0xc1297374  // bfdot za.s[x11, 4], { z27.h-z28.h }, z9.h\n"
    ".inst 0xc1217375  // bfdot za.s[x11, 5], { z27.h-z28.h }, z1.h\n"
    ".inst 0xa0422a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc1217376  // bfdot za.s[x11, 6], { z27.h-z28.h }, z1.h\n"
    ".inst 0xc1207377  // bfdot za.s[x11, 7], { z27.h-z28.h }, z0.h\n"
    "17:"  // Padded: 0 priming loads
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    ".inst 0xa0412be4  // ld1h { z4.h-z5.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0xa1422be2  // ld1h { z2.h, z10.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    "cbz x25, 20f\n"
    "mov x12, #0x0\n"
    "add x20, x16, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "sub x25, x25, #0x1\n"
    "sub x15, x15, #0x1\n"
    "cmp x25, x15\n"
    "ld1w { z16.s }, p0/Z, [x16]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "csel x25, x25, x15, LT\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    "sub x15, x15, x25\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1e  // bfcvt z30.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa3e  // bfcvtnt z30.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1f  // bfcvt z31.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa3f  // bfcvtnt z31.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa00  // bfcvt z0.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa20  // bfcvtnt z0.h, p2/M, z17.s\n"
    ".inst 0x658aaa01  // bfcvt z1.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x648aaa01  // bfcvtnt z1.h, p2/M, z16.s\n"
    "cbz x25, 19f\n"
    "18:"  // Padded: Main loop
    "mov x12, #0x0\n"
    "addvl x24, SP, #6\n"
    ".inst 0xc12b73d0  // bfdot za.s[x11, 0], { z30.h-z31.h }, z11.h\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc12373d1  // bfdot za.s[x11, 1], { z30.h-z31.h }, z3.h\n"
    ".inst 0xa1402b03  // ld1h { z3.h, z11.h }, pn10.b/Z, [x24]\n"
    "addvl x23, SP, #12\n"
    "add x22, x16, %x[ld_in_row], LSL #2\n"
    "addvl x21, SP, #18\n"
    "addvl x20, SP, #24\n"
    "subs x25, x25, #0x1\n"
    "ld1w { z22.s }, p0/Z, [x16]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc12b73d2  // bfdot za.s[x11, 2], { z30.h-z31.h }, z11.h\n"
    "add x16, x16, %x[ld_in_col], LSL #2\n"
    ".inst 0xc12373d3  // bfdot za.s[x11, 3], { z30.h-z31.h }, z3.h\n"
    ".inst 0xa1402ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23]\n"
    ".inst 0xc12573f0  // bfdot za.s[x11, 0], { z31.h-z0.h }, z5.h\n"
    ".inst 0xc12473f1  // bfdot za.s[x11, 1], { z31.h-z0.h }, z4.h\n"
    ".inst 0xa1412b07  // ld1h { z7.h, z15.h }, pn10.b/Z, [x24, #0x2, MUL VL]\n"
    "ld1w { z9.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xc12e73d4  // bfdot za.s[x11, 4], { z30.h-z31.h }, z14.h\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12673d5  // bfdot za.s[x11, 5], { z30.h-z31.h }, z6.h\n"
    ".inst 0xa1402aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12f73f2  // bfdot za.s[x11, 2], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12773f3  // bfdot za.s[x11, 3], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412ae7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12a7010  // bfdot za.s[x11, 0], { z0.h-z1.h }, z10.h\n"
    "ld1w { z25.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x4\n"
    ".inst 0xc1227011  // bfdot za.s[x11, 1], { z0.h-z1.h }, z2.h\n"
    ".inst 0xa1422b06  // ld1h { z6.h, z14.h }, pn10.b/Z, [x24, #0x4, MUL VL]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12d73d6  // bfdot za.s[x11, 6], { z30.h-z31.h }, z13.h\n"
    ".inst 0xc12573d7  // bfdot za.s[x11, 7], { z30.h-z31.h }, z5.h\n"
    ".inst 0xa0402a84  // ld1h { z4.h-z5.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f73f4  // bfdot za.s[x11, 4], { z31.h-z0.h }, z15.h\n"
    "ld1w { z24.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12773f5  // bfdot za.s[x11, 5], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12e7012  // bfdot za.s[x11, 2], { z0.h-z1.h }, z14.h\n"
    ".inst 0xc1267013  // bfdot za.s[x11, 3], { z0.h-z1.h }, z6.h\n"
    ".inst 0xa1422ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc12f73f6  // bfdot za.s[x11, 6], { z31.h-z0.h }, z15.h\n"
    "ld1w { z23.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12773f7  // bfdot za.s[x11, 7], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12e7014  // bfdot za.s[x11, 4], { z0.h-z1.h }, z14.h\n"
    ".inst 0xc1267015  // bfdot za.s[x11, 5], { z0.h-z1.h }, z6.h\n"
    ".inst 0xa0422aa2  // ld1h { z2.h-z3.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    "ld1w { z20.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1237016  // bfdot za.s[x11, 6], { z0.h-z1.h }, z3.h\n"
    ".inst 0xc1227017  // bfdot za.s[x11, 7], { z0.h-z1.h }, z2.h\n"
    ".inst 0xa1422a82  // ld1h { z2.h, z10.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc12513d0  // bfdot za.s[x8, 0], { z30.h-z31.h }, z5.h\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0xc12413d1  // bfdot za.s[x8, 1], { z30.h-z31.h }, z4.h\n"
    ".inst 0x658aaade  // bfcvt z30.h, p2/M, z22.s\n"
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    ".inst 0xc12f13f0  // bfdot za.s[x8, 0], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12713f1  // bfdot za.s[x8, 1], { z31.h-z0.h }, z7.h\n"
    ".inst 0x658aab3f  // bfcvt z31.h, p2/M, z25.s\n"
    ".inst 0xa0412be4  // ld1h { z4.h-z5.h }, pn10.b/Z, [SP, #0x2, MUL VL]\n"
    ".inst 0x648aa93e  // bfcvtnt z30.h, p2/M, z9.s\n"
    ".inst 0xc12a1010  // bfdot za.s[x8, 0], { z0.h-z1.h }, z10.h\n"
    ".inst 0xc1221011  // bfdot za.s[x8, 1], { z0.h-z1.h }, z2.h\n"
    ".inst 0x658aaae0  // bfcvt z0.h, p2/M, z23.s\n"
    ".inst 0x658aaa21  // bfcvt z1.h, p2/M, z17.s\n"
    "add x8, x8, #0x2\n"
    ".inst 0xa1422be2  // ld1h { z2.h, z10.h }, pn10.b/Z, [SP, #0x4, MUL VL]\n"
    ".inst 0x648aab1f  // bfcvtnt z31.h, p2/M, z24.s\n"
    ".inst 0xc006680c  // mova { z12.d-z13.d }, za.d[x11, #0]\n"
    ".inst 0x648aaa80  // bfcvtnt z0.h, p2/M, z20.s\n"
    ".inst 0x648aaa01  // bfcvtnt z1.h, p2/M, z16.s\n"
    ".inst 0xc006682e  // mova { z14.d-z15.d }, za.d[x11, #1]\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040a40  // mova za.d[x8, #0], { z18.d-z19.d }\n"
    ".inst 0xc0040a41  // mova za.d[x8, #1], { z18.d-z19.d }\n"
    ".inst 0xc1bdc90c  // fclamp { z12.s-z15.s }, z8.s, z29.s\n"
    "st1w { z12.s }, p1, [x14]\n"
    "add x14, x14, x2, LSL #2\n"
    "st1w { z14.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "st1w { z13.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z15.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 18b\n"
    "19:"  // Main loop tail
    "addvl x23, SP, #6\n"
    ".inst 0xc12b73d0  // bfdot za.s[x11, 0], { z30.h-z31.h }, z11.h\n"
    "addvl x22, SP, #12\n"
    ".inst 0xc12373d1  // bfdot za.s[x11, 1], { z30.h-z31.h }, z3.h\n"
    ".inst 0xa1402ae3  // ld1h { z3.h, z11.h }, pn10.b/Z, [x23]\n"
    "addvl x21, SP, #18\n"
    "addvl x20, SP, #24\n"
    ".inst 0xc12b73d2  // bfdot za.s[x11, 2], { z30.h-z31.h }, z11.h\n"
    ".inst 0xc12373d3  // bfdot za.s[x11, 3], { z30.h-z31.h }, z3.h\n"
    ".inst 0xa0402acc  // ld1h { z12.h-z13.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc12573f0  // bfdot za.s[x11, 0], { z31.h-z0.h }, z5.h\n"
    ".inst 0xc12473f1  // bfdot za.s[x11, 1], { z31.h-z0.h }, z4.h\n"
    ".inst 0xa1412ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23, #0x2, MUL VL]\n"
    ".inst 0xc12d73d4  // bfdot za.s[x11, 4], { z30.h-z31.h }, z13.h\n"
    ".inst 0xc12c73d5  // bfdot za.s[x11, 5], { z30.h-z31.h }, z12.h\n"
    ".inst 0xa1402aa5  // ld1h { z5.h, z13.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc12e73f2  // bfdot za.s[x11, 2], { z31.h-z0.h }, z14.h\n"
    ".inst 0xc12673f3  // bfdot za.s[x11, 3], { z31.h-z0.h }, z6.h\n"
    ".inst 0xa1412ac7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x22, #0x2, MUL VL]\n"
    ".inst 0xc12a7010  // bfdot za.s[x11, 0], { z0.h-z1.h }, z10.h\n"
    ".inst 0xc1227011  // bfdot za.s[x11, 1], { z0.h-z1.h }, z2.h\n"
    ".inst 0xa1422ae6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x23, #0x4, MUL VL]\n"
    ".inst 0xc12d73d6  // bfdot za.s[x11, 6], { z30.h-z31.h }, z13.h\n"
    ".inst 0xc12573d7  // bfdot za.s[x11, 7], { z30.h-z31.h }, z5.h\n"
    ".inst 0xa0402a84  // ld1h { z4.h-z5.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc12f73f4  // bfdot za.s[x11, 4], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12773f5  // bfdot za.s[x11, 5], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412aa7  // ld1h { z7.h, z15.h }, pn10.b/Z, [x21, #0x2, MUL VL]\n"
    ".inst 0xc12e7012  // bfdot za.s[x11, 2], { z0.h-z1.h }, z14.h\n"
    ".inst 0xc1267013  // bfdot za.s[x11, 3], { z0.h-z1.h }, z6.h\n"
    ".inst 0xa1422ac6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x22, #0x4, MUL VL]\n"
    ".inst 0xc12f73f6  // bfdot za.s[x11, 6], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12773f7  // bfdot za.s[x11, 7], { z31.h-z0.h }, z7.h\n"
    ".inst 0xa1412a87  // ld1h { z7.h, z15.h }, pn10.b/Z, [x20, #0x2, MUL VL]\n"
    ".inst 0xc12e7014  // bfdot za.s[x11, 4], { z0.h-z1.h }, z14.h\n"
    ".inst 0xc1267015  // bfdot za.s[x11, 5], { z0.h-z1.h }, z6.h\n"
    ".inst 0xa1422aa3  // ld1h { z3.h, z11.h }, pn10.b/Z, [x21, #0x4, MUL VL]\n"
    ".inst 0xc12b7016  // bfdot za.s[x11, 6], { z0.h-z1.h }, z11.h\n"
    ".inst 0xc1237017  // bfdot za.s[x11, 7], { z0.h-z1.h }, z3.h\n"
    ".inst 0xa0422a82  // ld1h { z2.h-z3.h }, pn10.b/Z, [x20, #0x4, MUL VL]\n"
    ".inst 0xc12513d0  // bfdot za.s[x8, 0], { z30.h-z31.h }, z5.h\n"
    ".inst 0xc12413d1  // bfdot za.s[x8, 1], { z30.h-z31.h }, z4.h\n"
    ".inst 0xc12f13f0  // bfdot za.s[x8, 0], { z31.h-z0.h }, z15.h\n"
    ".inst 0xc12713f1  // bfdot za.s[x8, 1], { z31.h-z0.h }, z7.h\n"
    ".inst 0xc1231010  // bfdot za.s[x8, 0], { z0.h-z1.h }, z3.h\n"
    ".inst 0xc1221011  // bfdot za.s[x8, 1], { z0.h-z1.h }, z2.h\n"
    "add x8, x8, #0x2\n"
    ".inst 0xc0066814  // mova { z20.d-z21.d }, za.d[x11, #0]\n"
    ".inst 0xc0066836  // mova { z22.d-z23.d }, za.d[x11, #1]\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040a40  // mova za.d[x8, #0], { z18.d-z19.d }\n"
    ".inst 0xc0040a41  // mova za.d[x8, #1], { z18.d-z19.d }\n"
    ".inst 0xc1bdc914  // fclamp { z20.s-z23.s }, z8.s, z29.s\n"
    "st1w { z20.s }, p1, [x14]\n"
    "add x14, x14, x2, LSL #2\n"
    "st1w { z22.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "st1w { z21.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z23.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "20:"  // Main loop skip tail
    "cbz x15, 22f\n"
    "21:"  // Right padding loop
    ".inst 0xc0066800  // mova { z0.d-z1.d }, za.d[x11, #0]\n"
    "add x8, x8, #0x2\n"
    "subs x15, x15, #0x1\n"
    ".inst 0xc0066822  // mova { z2.d-z3.d }, za.d[x11, #1]\n"
    "add x11, x11, #0x2\n"
    ".inst 0xc0040a40  // mova za.d[x8, #0], { z18.d-z19.d }\n"
    ".inst 0xc0040a41  // mova za.d[x8, #1], { z18.d-z19.d }\n"
    ".inst 0xc1bdc900  // fclamp { z0.s-z3.s }, z8.s, z29.s\n"
    "st1w { z0.s }, p1, [x14]\n"
    "add x14, x14, x2, LSL #2\n"
    "st1w { z2.s }, p1, [x13]\n"
    "add x13, x13, x10, LSL #2\n"
    "st1w { z1.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z3.s }, p1, [x28]\n"
    "add x28, x28, x26, LSL #2\n"
    "bgt 21b\n"
    "22:"  // End
    "ldr x20, [%x[args], %[offsetof_Args_weights]]\n"
    "incw x17\n"
    "whilelt p1.s, x17, x7\n"
    "incb x20, ALL, MUL #16\n"
    "incb x20, ALL, MUL #9\n"
    "str x20, [%x[args], %[offsetof_Args_weights]]\n"
    "ldr x21, [%x[args], %[offsetof_Args_ld_in_vl]]\n"
    "ldr x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "add x20, x20, x21, LSL #2\n"
    "str x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "ldr x25, [%x[args], %[offsetof_Args_outptrs]]\n"
    "ldr x24, [%x[args], %[offsetof_Args_ld_out_vls]]\n"
    "ldp x23, x22, [x25, #0x0]\n"
    "ldp x21, x20, [x24, #0x0]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x0]\n"
    "ldp x23, x22, [x25, #0x10]\n"
    "ldp x21, x20, [x24, #0x10]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x10]\n"
    "b.any 1b\n"
    "addvl SP, SP, #30\n"
    ".inst 0xd503467f  // SMSTOP\n"
    "ldr x20, [SP, #0x0]\n"
    "mov SP, x20\n"
    :
    : [args] "r" (&args), [ld_in_col] "r" (ld_in_col), [ld_in_row] "r" (ld_in_row), [offsetof_Args_bias] "I" (offsetof(Args, bias)), [offsetof_Args_clamp_max] "I" (offsetof(Args, clamp_max)), [offsetof_Args_clamp_min] "I" (offsetof(Args, clamp_min)), [offsetof_Args_current_channel] "I" (offsetof(Args, current_channel)), [offsetof_Args_inptr] "I" (offsetof(Args, inptr)), [offsetof_Args_input_cols] "I" (offsetof(Args, input_cols)), [offsetof_Args_ld_in_vl] "I" (offsetof(Args, ld_in_vl)), [offsetof_Args_ld_out_cols] "I" (offsetof(Args, ld_out_cols)), [offsetof_Args_ld_out_vls] "I" (offsetof(Args, ld_out_vls)), [offsetof_Args_n_channels] "I" (offsetof(Args, n_channels)), [offsetof_Args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_Args_output_cols] "I" (offsetof(Args, output_cols)), [offsetof_Args_pad_bottom] "I" (offsetof(Args, pad_bottom)), [offsetof_Args_pad_left] "I" (offsetof(Args, pad_left)), [offsetof_Args_pad_top] "I" (offsetof(Args, pad_top)), [offsetof_Args_weights] "I" (offsetof(Args, weights))
    : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "x2", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SME2)
