# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network custom-ip prefix create",
)
class Create(AAZCommand):
    """Create a custom IP prefix resource.

    :example: Create a custom IP prefix resource.
        az network custom-ip prefix create --location westus2 --name MyCustomIpPrefix --resource-group MyResourceGroup
    """

    _aaz_info = {
        "version": "2022-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/customipprefixes/{}", "2022-05-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the custom IP prefix.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location. Values from: `az account list-locations`. You can configure the default location using `az configure --defaults location=<location>`.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.asn = AAZStrArg(
            options=["--asn"],
            help="The ASN for CIDR advertising. Should be an integer as string.",
        )
        _args_schema.authorization_message = AAZStrArg(
            options=["--authorization-message"],
            help="Authorization message for WAN validation.",
        )
        _args_schema.cidr = AAZStrArg(
            options=["--cidr"],
            help="The prefix range in CIDR notation. Should include the start address and the prefix length.",
        )
        _args_schema.cip_prefix_parent = AAZStrArg(
            options=["-c", "--cip-prefix-parent"],
            help="The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.",
        )
        _args_schema.express_route_advertise = AAZBoolArg(
            options=["--is-advertised", "--express-route-advertise"],
            help="Whether to do express route advertise.",
        )
        _args_schema.geo = AAZStrArg(
            options=["--geo"],
            help="The Geo for CIDR advertising. Should be an Geo code.",
            enum={"AFRI": "AFRI", "APAC": "APAC", "AQ": "AQ", "EURO": "EURO", "GLOBAL": "GLOBAL", "LATAM": "LATAM", "ME": "ME", "NAM": "NAM", "OCEANIA": "OCEANIA"},
        )
        _args_schema.signed_message = AAZStrArg(
            options=["--signed-message"],
            help="Signed message for WAN validation.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...].",
        )
        _args_schema.zone = AAZListArg(
            options=["-z", "--zone"],
            help="Space-separated list of availability zones into which to provision the resource.  Allowed values: 1, 2, 3.",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        zone = cls._args_schema.zone
        zone.Element = AAZStrArg()

        # define Arg Group "Parameters"

        # define Arg Group "Properties"
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.CustomIPPrefixesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class CustomIPPrefixesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/customIpPrefixes/{customIpPrefixName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "customIpPrefixName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")
            _builder.set_prop("zones", AAZListType, ".zone")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("asn", AAZStrType, ".asn")
                properties.set_prop("authorizationMessage", AAZStrType, ".authorization_message")
                properties.set_prop("cidr", AAZStrType, ".cidr")
                properties.set_prop("customIpPrefixParent", AAZObjectType)
                properties.set_prop("expressRouteAdvertise", AAZBoolType, ".express_route_advertise")
                properties.set_prop("geo", AAZStrType, ".geo")
                properties.set_prop("signedMessage", AAZStrType, ".signed_message")

            custom_ip_prefix_parent = _builder.get(".properties.customIpPrefixParent")
            if custom_ip_prefix_parent is not None:
                custom_ip_prefix_parent.set_prop("id", AAZStrType, ".cip_prefix_parent")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            zones = _builder.get(".zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.extended_location = AAZObjectType(
                serialized_name="extendedLocation",
            )
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.zones = AAZListType()

            extended_location = cls._schema_on_200_201.extended_location
            extended_location.name = AAZStrType()
            extended_location.type = AAZStrType()

            properties = cls._schema_on_200_201.properties
            properties.asn = AAZStrType()
            properties.authorization_message = AAZStrType(
                serialized_name="authorizationMessage",
            )
            properties.child_custom_ip_prefixes = AAZListType(
                serialized_name="childCustomIpPrefixes",
                flags={"read_only": True},
            )
            properties.cidr = AAZStrType()
            properties.commissioned_state = AAZStrType(
                serialized_name="commissionedState",
            )
            properties.custom_ip_prefix_parent = AAZObjectType(
                serialized_name="customIpPrefixParent",
            )
            _build_schema_sub_resource_read(properties.custom_ip_prefix_parent)
            properties.express_route_advertise = AAZBoolType(
                serialized_name="expressRouteAdvertise",
            )
            properties.failed_reason = AAZStrType(
                serialized_name="failedReason",
                flags={"read_only": True},
            )
            properties.geo = AAZStrType()
            properties.no_internet_advertise = AAZBoolType(
                serialized_name="noInternetAdvertise",
            )
            properties.prefix_type = AAZStrType(
                serialized_name="prefixType",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.public_ip_prefixes = AAZListType(
                serialized_name="publicIpPrefixes",
                flags={"read_only": True},
            )
            properties.resource_guid = AAZStrType(
                serialized_name="resourceGuid",
                flags={"read_only": True},
            )
            properties.signed_message = AAZStrType(
                serialized_name="signedMessage",
            )

            child_custom_ip_prefixes = cls._schema_on_200_201.properties.child_custom_ip_prefixes
            child_custom_ip_prefixes.Element = AAZObjectType()
            _build_schema_sub_resource_read(child_custom_ip_prefixes.Element)

            public_ip_prefixes = cls._schema_on_200_201.properties.public_ip_prefixes
            public_ip_prefixes.Element = AAZObjectType()
            _build_schema_sub_resource_read(public_ip_prefixes.Element)

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            zones = cls._schema_on_200_201.zones
            zones.Element = AAZStrType()

            return cls._schema_on_200_201


_schema_sub_resource_read = None


def _build_schema_sub_resource_read(_schema):
    global _schema_sub_resource_read
    if _schema_sub_resource_read is not None:
        _schema.id = _schema_sub_resource_read.id
        return

    _schema_sub_resource_read = AAZObjectType()

    sub_resource_read = _schema_sub_resource_read
    sub_resource_read.id = AAZStrType()

    _schema.id = _schema_sub_resource_read.id


__all__ = ["Create"]
