/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// generated by Fast Light User Interface Designer (fluid) version 1.0104

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl_Pixmap.H>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Help_Dialog.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <util.hpp>


#include <chain_prop.hpp>





void chain_prop_cancel_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();
}

void chain_prop_ok_cb(Fl_Widget* w, void* d){
  chain_prop* wi=dynamic_cast<chain_prop*>(w->parent());
    
  char* tail;
  float rot_deg=strtof(dynamic_cast<Fl_Input*>(wi->child(2))->value(),&tail);
  if(tail[0]=='\0'){
    wi->_angl=rot_deg*2.0*M_PI/360.0;
  }else{
    wi->_angl=0;
  }
  long int noc=strtol(dynamic_cast<Fl_Input*>(wi->child(1))->value(),&tail,10);

  if(tail[0]=='\0'){
    wi->_no_c=static_cast<unsigned int>(noc);
  }else{
    wi->_no_c=3;
  }
  wi->hide();
  	 
}


chain_prop::~chain_prop(){

}

chain_prop::chain_prop()
  :Fl_Double_Window(340, 90, _("Draw chain...")),
   _no_c(0),
   _angl(0)
 {
   
    { Fl_Box* o = new Fl_Box(10, 5, 330, 40);
      o->box(FL_ENGRAVED_BOX);
    }
    { Fl_Input* o = new Fl_Input(280, 10, 40, 25, _("Number of carbon:"));//1
      o->type(2);
    }
    { Fl_Input* o = new Fl_Input(80, 10, 40, 25, _("Angle:"));//2
      o->type(1);
    }
    Fl_Return_Button* ok=new Fl_Return_Button(100, 50, 80, 30, _("OK"));
    ok->callback(chain_prop_ok_cb);
    add(ok);
    Fl_Button* c=new Fl_Button(180, 50, 70, 30, _("Cancel"));
    c->callback(chain_prop_cancel_cb);
    add(c);
    end();
    set_modal();

    dialog_position(this,0);
}
