//
// C++ Interface: boatProperties
//
// Description:
//
//
// Author: Thibaut GRIDEL <tgridel@free.fr>
//
// Copyright (c) 2019 Thibaut GRIDEL
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//
#ifndef BOATPROPERTIES_H
#define BOATPROPERTIES_H

#include <QPointF>
#include <QRectF>
#include <QPainterPath>
#include <QJsonObject>
#include <QMap>

class BoatProperties : public QObject {
    Q_OBJECT
    Q_PROPERTY(QString series READ series CONSTANT)
    Q_PROPERTY(QString name READ name CONSTANT)
    Q_PROPERTY(qreal size READ size CONSTANT)
    Q_PROPERTY(qreal border READ border CONSTANT)
    Q_PROPERTY(qreal numberSize READ numberSize CONSTANT)
    Q_PROPERTY(QPointF numberPos READ numberPos CONSTANT)
    Q_PROPERTY(bool hasSail READ hasSail CONSTANT)
    Q_PROPERTY(qreal sailSize READ sailSize CONSTANT)
    Q_PROPERTY(bool hasJib READ hasJib CONSTANT)
    Q_PROPERTY(qreal jibSize READ jibSize CONSTANT)
    Q_PROPERTY(QPointF jibTackPos READ jibTackPos CONSTANT)
    Q_PROPERTY(bool hasSpin READ hasSpin CONSTANT)
    Q_PROPERTY(qreal spinSize READ spinSize CONSTANT)
    Q_PROPERTY(bool hasGennaker READ hasGennaker CONSTANT)
    Q_PROPERTY(qreal gennakerSize READ gennakerSize CONSTANT)
    Q_PROPERTY(QPointF gennakerTackPos READ gennakerTackPos CONSTANT)
    Q_PROPERTY(qreal gennakerPoleSize READ gennakerPoleSize CONSTANT)
    Q_PROPERTY(QPointF mastPos READ mastPos CONSTANT)
    Q_PROPERTY(QRectF flagRect READ flagRect CONSTANT)
    Q_PROPERTY(QPainterPath path READ path CONSTANT)

    public:
    BoatProperties(QString filename);

        QString series();
        QString name(QString locale="en");
        qreal size();
        qreal border();
        qreal numberSize();
        QPointF numberPos();
        bool hasSail();
        qreal sailSize();
        qreal sailMaxNormalAngle();
        qreal sailMaxSpinAngle();
        bool hasJib();
        qreal jibSize();
        QPointF jibTackPos();
        qreal jibMaxNormalAngle();
        qreal jibMaxSpinAngle();
        bool hasSpin();
        qreal spinSize();
        bool hasGennaker();
        qreal gennakerSize();
        QPointF gennakerTackPos();
        qreal gennakerPoleSize();
        QPointF mastPos();
        QRectF flagRect();
        QPainterPath path();

    private:
        void appendMoveTo(QJsonObject object, QPainterPath& path);
        void appendLineTo(QJsonObject object, QPainterPath& path);
        void appendCubicTo(QJsonObject object, QPainterPath& path);
        void appendQuadTo(QJsonObject object, QPainterPath& path);

        QJsonObject m_object;

        QString m_series;
        QMap<QString, QString> m_name;
        qreal m_size;
        qreal m_border;
        qreal m_numberSize;
        QPointF m_numberPos;
        bool m_hasSail;
        qreal m_sailSize;
        qreal m_sailMaxNormalAngle;
        qreal m_sailMaxSpinAngle;
        bool m_hasJib;
        qreal m_jibSize;
        QPointF m_jibTackPos;
        qreal m_jibMaxNormalAngle;
        qreal m_jibMaxSpinAngle;
        bool m_hasSpin;
        qreal m_spinSize;
        bool m_hasGennaker;
        qreal m_gennakerSize;
        QPointF m_gennakerTackPos;
        qreal m_gennakerPoleSize;
        QPointF m_mastPos;
        QRectF m_flagRect;
        QPainterPath m_path;
};

#endif // BOATPROPERTIES_H
