# BornAgain packaging

include(InstallRequiredSystemLibraries)

set(CPACK_PACKAGE_VENDOR "Forschungszentrum Juelich GmbH")

configure_file(COPYING LICENSE.txt COPYONLY)
set(CPACK_RESOURCE_FILE_LICENSE ${CMAKE_BINARY_DIR}/LICENSE.txt)

set(CPACK_PACKAGE_RELOCATABLE True)

set(CPACK_SOURCE_PACKAGE_FILE_NAME ${CMAKE_PROJECT_NAME}-${CMAKE_PROJECT_VERSION})
set(CPACK_PACKAGE_INSTALL_DIRECTORY ${CPACK_SOURCE_PACKAGE_FILE_NAME})

set(CPACK_PACKAGE_FILE_NAME ${CMAKE_PACKAGE_INSTALL_DIRECTORY}-${BORNAGAIN_ARCHITECTURE})
if(NOT CMAKE_BUILD_TYPE STREQUAL Release)
    string(APPEND CPACK_PACKAGE_FILE_NAME -${CMAKE_BUILD_TYPE})
endif()


if(WIN32)
    include(BornAgain/PackWindows)
elseif(APPLE)
    include(BornAgain/PackMacOS)
elseif(UNIX AND BUILD_DEBIAN) # one can build debian package only on UNIX system
    include(BornAgain/PackDebian)
else()
  set(CPACK_GENERATOR "TGZ")
endif()


# Generating the source package
set(CPACK_SOURCE_GENERATOR "TGZ")

message(STATUS "Installer name: ${CPACK_PACKAGE_FILE_NAME}")
message(STATUS "Source package name: ${CPACK_SOURCE_PACKAGE_FILE_NAME}")

# Specify which files not to include into the source package generated by make package_source
set(CPACK_SOURCE_IGNORE_FILES
    ${CPACK_SOURCE_IGNORE_FILES} # first take the default parameters
    "/Doc/FFCatalog/"
    "/Doc/PhysicsManual/"
    "/devtools/edit-scripts/"
    "/devtools/packaging/"
    "/devtools/tmp-examples/"
    "/devtools/tmp-unsorted/"
    "/XCode_BornAgain.xcodeproj/"
    "~$"
    "/.git/"
    "/\\\\.git/"
    "/\\\\\\\\.git/"  # more screeneng symbols is neccesary because of double file processing by cmake and cpack
    "\\\\\\\\.swp$"
    "\\\\.swp$"
    "/.metadata/"
    "/.settings/"
    "\\\\.cproject"
    "\\\\.project"
    "/\\\\.idea/"
    "\\\\.lssrc"
    "\\\\.gitignore"
    "\\\\.DS_Store"
    "\\\\.obj"
    "CMakeLists.txt.user"
    "/bin/release.sh.in" # user will not need it
    "/devtools/git-utils/cl_lines_of_code.py"
    "/devtools/git-utils/qqq.png" # remove this line when unneeded
    ".pro$"
    ".pro.user$"
    ".pri$"
    "build/"
)


include(CPack)

set(CPACK_COMPONENTS_ALL Libraries Headers Examples)
