/*
 * widgets/SelectionControl.h is is part of Brewtarget, and is copyright the following
 * authors 2018-2021:
 * - Iman Ahmadvand <iman72411@gmail.com>
 * - Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Brewtarget is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef WIDGETS_SELECTIONCONTROL_H
#define WIDGETS_SELECTIONCONTROL_H
#pragma once

#include <QAbstractButton>

class QEvent;
class QWidget;

/**
 * \brief
 */
class SelectionControl : public QAbstractButton {
   Q_OBJECT

public:
   explicit SelectionControl(QWidget * parent = nullptr);
   ~SelectionControl() override;

   Qt::CheckState checkState() const;

Q_SIGNALS:
   void stateChanged(int);

protected:
   void enterEvent(QEvent *) override;
   void checkStateSet() override;
   void nextCheckState() override;
   virtual void toggle(Qt::CheckState state) = 0;
};

#endif
