#include <check.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <openssl/md5.h>
#include "test.h"
#include "../src/alloc.h"
#include "../src/hexmap.h"

struct md5data
{
	const char *str;
	uint8_t bytes[MD5_DIGEST_LENGTH];
};

static struct md5data m[] = {
	{ "d41d8cd98f00b204e9800998ecf8427e",
		{ 0xD4, 0x1D, 0x8C, 0xD9, 0x8F, 0x00, 0xB2, 0x04,
			0xE9, 0x80, 0x09, 0x98, 0xEC, 0xF8, 0x42, 0x7E } },
	{ "00000000000000000000000000000000",
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ "ffffffffffffffffffffffffffffffff",
		{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF } },
	{ "0123456789abcdef0123456789abcdef",
		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF,
			0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF } },
};

START_TEST(test_bytes_to_md5str)
{
	FOREACH(m)
	{
		const char *str;
		str=bytes_to_md5str(m[i].bytes);
		fail_unless(!strcmp(m[i].str, str));
	}
}
END_TEST

Suite *suite_hexmap(void)
{
	Suite *s;
	TCase *tc_core;

	s=suite_create("hexmap");

	tc_core=tcase_create("Core");

	tcase_add_test(tc_core, test_bytes_to_md5str);
	suite_add_tcase(s, tc_core);

	return s;
}
