/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2024 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ShowArbitraryViewer.h"

#include <MedicalImageViewer.h>
using namespace camitk;

// --------------- constructor -------------------
ShowArbitraryViewer::ShowArbitraryViewer(ActionExtension* extension) : Action(extension) {
    // Setting name, description and input component
    setName("Show Arbitrary Viewer");
    setEmbedded(false);
    setDescription(tr("Show the Arbitrary Slice Viewer Only"));
    setComponentClassName("");

    // Setting classification family and tags
    setFamily("Application");
    addTag(tr("Arbitrary Slice Viewer"));
    addTag(tr("Slice"));

    // add a shortcut
    getQAction()->setShortcut(tr("Ctrl+5"));
    getQAction()->setShortcutContext(Qt::ApplicationShortcut);

    // can be checked or not (on/off), useful when group in a QActionGroup (radio buttons)
    getQAction()->setCheckable(true);
}

// --------------- destructor -------------------
ShowArbitraryViewer::~ShowArbitraryViewer() {
    // do not delete the widget has it might have been used in the ActionViewer (i.e. the ownership might have been taken by the stacked widget)
}

// --------------- getWidget --------------
QWidget* ShowArbitraryViewer::getWidget() {
    return nullptr;
}

// --------------- apply -------------------
Action::ApplyStatus ShowArbitraryViewer::apply() {
    MedicalImageViewer* medicalImageViewer = dynamic_cast<MedicalImageViewer*>(Application::getViewer("Medical Image Viewer"));
    if (medicalImageViewer != nullptr) {
        medicalImageViewer->setVisibleViewer(MedicalImageViewer::VIEWER_ARBITRARY);
    }
    Application::refresh();
    return SUCCESS;
}
