package charactermanaj;

import java.util.Locale;
import java.util.Properties;

import charactermanaj.model.AppConfig;
import charactermanaj.util.LocalizedResourcePropertyLoader;

/**
 * Java7 on OSX で、クラス名がメニューの「〜の終了」「〜について」の起動クラス名がアプリ名に使われており、
 * info.pinfoのBundleNameでも変更できないため、回避方法がみつかるまで、本クラス名を表示させることにする。
 *
 * @author seraphy
 */
public class CharacterManaJ {

	public static void main(String[] args) throws Exception {
		// アプリケーション名表示オプションか？
		for (String arg : args) {
			if ("--show-appinfo".equals(arg)) {
				showAppinfo();
				return;
			}
		}

		Main.main(args);
	}

	/**
	 * アプリケーション名の表示
	 */
	public static void showAppinfo() {
		Properties strings = LocalizedResourcePropertyLoader.getCachedInstance()
				.getLocalizedProperties("languages/mainframe");
		AppConfig appConfig = AppConfig.getInstance();

		System.out.println(strings.getProperty("title"));
		System.out.println(Locale.getDefault().getLanguage());
		System.out.println(appConfig.getSpecificationVersion());
		System.out.println(appConfig.getImplementationVersion());
	}
}
