#ifndef __WU_QWT_PLOT_H__
#define __WU_QWT_PLOT_H__

/*LICENSE_START*/
/*
 *  Copyright (C) 2014 Washington University School of Medicine
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
/*LICENSE_END*/


#include "qwt_plot.h"

namespace caret {

    class WuQwtPlot : public QwtPlot {
        
        Q_OBJECT

    public:
        WuQwtPlot(QWidget* w = 0);
        
        virtual ~WuQwtPlot();
        
        virtual void contextMenuEvent(QContextMenuEvent* event);

        // ADD_NEW_METHODS_HERE

        QPointF inverseTransform( const QPoint &pos ) const;
        
    signals:
        void contextMenuDisplay(QContextMenuEvent* event,
                                float graphX,
                                float graphY);
        
    private:
        WuQwtPlot(const WuQwtPlot&);

        WuQwtPlot& operator=(const WuQwtPlot&);
        
        // ADD_NEW_MEMBERS_HERE

    };
    
#ifdef __WU_QWT_PLOT_DECLARE__
    // <PLACE DECLARATIONS OF STATIC MEMBERS HERE>
#endif // __WU_QWT_PLOT_DECLARE__

} // namespace
#endif  //__WU_QWT_PLOT_H__
