---
title: Regular Language Representations in Coq
lang: en
header-includes:
  - |
    <style type="text/css"> body {font-family: Arial, Helvetica; margin-left: 5em; font-size: large;} </style>
    <style type="text/css"> h1 {margin-left: 0em; padding: 0px; text-align: center} </style>
    <style type="text/css"> h2 {margin-left: 0em; padding: 0px; color: #580909} </style>
    <style type="text/css"> h3 {margin-left: 1em; padding: 0px; color: #C05001;} </style>
    <style type="text/css"> body { width: 1100px; margin-left: 30px; }</style>
---

<div style="text-align:left"><img src="https://github.githubassets.com/images/modules/logos_page/Octocat.png" height="25" style="border:0px">
[View the project on GitHub](https://github.com/coq-community/reglang)
<img src="https://github.githubassets.com/images/modules/logos_page/Octocat.png" height="25" style="border:0px"></div>

## About

Welcome to the Regular Language Representations in Coq project website! This project is part of [coq-community](https://github.com/coq-community/manifesto).

This library provides definitions and verified translations between
different representations of regular languages: various forms of
automata (deterministic, nondeterministic, one-way, two-way),
regular expressions, and the logic WS1S. It also contains various
decidability results and closure properties of regular languages.

This is an open source project, licensed under CeCILL-B.

## Get the code

The current stable release of Regular Language Representations in Coq can be [downloaded from GitHub](https://github.com/coq-community/reglang/releases).

## Documentation

The coqdoc presentations of releases can be browsed online:

- [v1.1.1](docs/v1.1.1/coqdoc/toc.html)
- [v1.1](docs/v1.1/coqdoc/toc.html)

See also related publications:

- [Regular Language Representations in the Constructive Type Theory of Coq](https://hal.archives-ouvertes.fr/hal-01832031/document) doi:[10.1007/s10817-018-9460-x](https://doi.org/10.1007/s10817-018-9460-x)

## Help and contact

- Report issues on [GitHub](https://github.com/coq-community/reglang/issues)
- Chat with us on [Zulip](https://coq.zulipchat.com/#narrow/stream/237663-coq-community-devs.20.26.20users)
- Discuss with us on Coq's [Discourse](https://coq.discourse.group) forum

## Authors and contributors

- Christian Doczkal
- Jan-Oliver Kaiser
- Gert Smolka
