package raw_test

import (
	"testing"

	"review.coreboot.org/coreboot.git/util/intelp2m/config/p2m"
	"review.coreboot.org/coreboot.git/util/intelp2m/platforms/common/fields/test"
)

func TestRAWFields(t *testing.T) {
	p2m.SettingsReset()
	p2m.Config.Field = p2m.RawFlds
	referenceSlice := []string{
		"_PAD_CFG_STRUCT(, 0x80000000, 0x80000000),",
		"_PAD_CFG_STRUCT(, 0x40000000, 0x40000000),",
		"_PAD_CFG_STRUCT(, 0x20000000, 0x20000000),",
		"_PAD_CFG_STRUCT(, 0x10000000, 0x10000000),",
		"_PAD_CFG_STRUCT(, 0x08000000, 0x08000000),",
		"_PAD_CFG_STRUCT(, 0x04000000, 0x04000000),",
		"_PAD_CFG_STRUCT(, 0x02000000, 0x02000000),",
		"_PAD_CFG_STRUCT(, 0x01000000, 0x01000000),",
		"_PAD_CFG_STRUCT(, 0x00800000, 0x00800000),",
		"_PAD_CFG_STRUCT(, 0x00400000, 0x00400000),",
		"_PAD_CFG_STRUCT(, 0x00200000, 0x00200000),",
		"_PAD_CFG_STRUCT(, 0x00100000, 0x00100000),",
		"_PAD_CFG_STRUCT(, 0x00080000, 0x00080000),",
		"_PAD_CFG_STRUCT(, 0x00040000, 0x00040000),",
		"_PAD_CFG_STRUCT(, 0x00020000, 0x00020000),",
		"_PAD_CFG_STRUCT(, 0x00010000, 0x00010000),",
		"_PAD_CFG_STRUCT(, 0x00008000, 0x00008000),",
		"_PAD_CFG_STRUCT(, 0x00004000, 0x00004000),",
		"_PAD_CFG_STRUCT(, 0x00002000, 0x00002000),",
		"_PAD_CFG_STRUCT(, 0x00001000, 0x00001000),",
		"_PAD_CFG_STRUCT(, 0x00000800, 0x00000800),",
		"_PAD_CFG_STRUCT(, 0x00000400, 0x00000400),",
		"_PAD_CFG_STRUCT(, 0x00000200, 0x00000200),",
		"_PAD_CFG_STRUCT(, 0x00000100, 0x00000100),",
		"_PAD_CFG_STRUCT(, 0x00000080, 0x00000080),",
		"_PAD_CFG_STRUCT(, 0x00000040, 0x00000040),",
		"_PAD_CFG_STRUCT(, 0x00000020, 0x00000020),",
		"_PAD_CFG_STRUCT(, 0x00000010, 0x00000010),",
		"_PAD_CFG_STRUCT(, 0x00000008, 0x00000008),",
		"_PAD_CFG_STRUCT(, 0x00000004, 0x00000004),",
		"_PAD_CFG_STRUCT(, 0x00000002, 0x00000002),",
		"_PAD_CFG_STRUCT(, 0x00000001, 0x00000001),",
	}
	test.SlidingOneTestSuiteCreate(referenceSlice).Run(t, "SLIDING-ONE-TEST")
}
