/*
 *  Copyright (C) 2002-2021  The DOSBox Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#include "dosbox.h"
#include "mem.h"
#include "bios.h"
#include "inout.h"
#include "int10.h"

bool rom_bios_vptable_enable = true;

const uint8_t vparams[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2d, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5 and 6
	0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x06, 0x07, 0,0,0,0,
	// mode 7 MDA text
	0x61, 0x50, 0x52, 0x0f, 0x19, 0x06, 0x19, 0x19, 0x02, 0x0d, 0x0b, 0x0c, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};

const uint8_t vparams_pcjr[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2c, 0x06, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0c, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5, 6, 8
	0x38, 0x28, 0x2b, 0x06, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x26, 0x07, 0,0,0,0,
	// other graphics modes
	0x71, 0x50, 0x56, 0x0c, 0x3f, 0x06, 0x32, 0x38, 0x02, 0x03, 0x26, 0x07, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};

const uint8_t vparams_tandy[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2c, 0x08, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x58, 0x10, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5 and 6
	0x38, 0x28, 0x2c, 0x08, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x06, 0x07, 0,0,0,0,
	// graphics mode 7
	0x71, 0x50, 0x58, 0x10, 0x3f, 0x06, 0x32, 0x38, 0x02, 0x03, 0x06, 0x07, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};

#if 0//unused
const uint8_t vparams_tandy_td[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2d, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5 and 6
	0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x06, 0x07, 0,0,0,0,
	// mode 7 MDA text
	0x61, 0x50, 0x52, 0x0f, 0x19, 0x06, 0x19, 0x19, 0x02, 0x0d, 0x0b, 0x0c, 0,0,0,0,
	// ?? mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0a, 0x3f, 0x06, 0x32, 0x38, 0x02, 0x03, 0x06, 0x07, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};
#endif

/* layout:
 *
 * struct {
 *    uint8_t         number of displayed character columns          +0x00
 *    uint8_t         number of displayed screen rows minus 1        +0x01
 *    uint8_t         character matrix height in points              +0x02
 *    uint16_t        video buffer size in bytes                     +0x03
 *    uint8_t[4]      contents of sequencer registers 1-4            +0x05
 *    uint8_t         miscellaneous output register value            +0x09
 *    uint8_t[25]     contents of CRTC registers 0-18h               +0x0A
 *    uint8_t[20]     contents of attribute controller regs 0-13h    +0x23
 *    uint8_t[9]      contents of graphics controller regs 0-8       +0x37
 *                                                                   =0x40
 * } = 64 bytes;
 */

/* Values copied from VP table snapshot on an IBM PS/2 model 30 [http://hackipedia.org/raw/Computer/Platform/PC%2c%20IBM%20compatible/Video/VGA/VGA%20register%20snapshots/IBM%20PS%2d2%20MODEL%2030%20286%20with%20VGA%20%282019%2d09%2d28%29%2etar%2exz] */
static uint8_t video_parameter_table_vga[0x40*0x1d]={
// video parameter table for mode 0 (40x25 text CGA emulation grayscale)
  0x28, 0x18, 0x08, 0x00, 0x08, 0x09, 0x03, 0x00, 0x02, 0x63, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0,
  0xbf, 0x1f, 0x00, 0xc7, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x14, 0x1f, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 1 (40x25 text CGA emulation)
  0x28, 0x18, 0x08, 0x00, 0x08, 0x09, 0x03, 0x00, 0x02, 0x63, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0,
  0xbf, 0x1f, 0x00, 0xc7, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x14, 0x1f, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 2 (80x25 text CGA emulation grayscale)
  0x50, 0x18, 0x08, 0x00, 0x10, 0x01, 0x03, 0x00, 0x02, 0x63, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0xc7, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 3 (80x25 text CGA emulation)
  0x50, 0x18, 0x08, 0x00, 0x10, 0x01, 0x03, 0x00, 0x02, 0x63, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0xc7, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 4 (CGA 320x200 4-color grayscale)
  0x28, 0x18, 0x08, 0x00, 0x40, 0x09, 0x03, 0x00, 0x02, 0x63, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80,
  0xbf, 0x1f, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96,
  0xb9, 0xa2, 0xff, 0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x00, 0xff,
// video parameter table for mode 5 (CGA 320x200 4-color)
  0x28, 0x18, 0x08, 0x00, 0x40, 0x09, 0x03, 0x00, 0x02, 0x63, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80,
  0xbf, 0x1f, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96,
  0xb9, 0xa2, 0xff, 0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x00, 0xff,
// video parameter table for mode 6 (CGA 640x200 2-color)
  0x50, 0x18, 0x08, 0x00, 0x40, 0x01, 0x01, 0x00, 0x06, 0x63, 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80,
  0xbf, 0x1f, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x00, 0x96,
  0xb9, 0xc2, 0xff, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0xff,
// video parameter table for mode 7 (80x25 text MDA emulation)
  0x50, 0x18, 0x0e, 0x00, 0x10, 0x00, 0x03, 0x00, 0x03, 0xa6, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x83, 0x85, 0x5d, 0x28, 0x0d, 0x63,
  0xba, 0xa3, 0xff, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x0e, 0x00, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x00, 0xff,
// video parameter table for mode 8
  0x50, 0x18, 0x10, 0x00, 0x7d, 0x21, 0x0f, 0x00, 0x06, 0x63, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96,
  0xb9, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode 9
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode a
  0x28, 0x18, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x03, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x31, 0x15,
  0x04, 0x11, 0x00, 0x47, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode b
  0x50, 0x00, 0x00, 0x00, 0x00, 0x29, 0x0f, 0x00, 0x06, 0x62, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96,
  0xb9, 0xe3, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x08, 0x05, 0x0f, 0xff,
// video parameter table for mode c
  0x50, 0x00, 0x00, 0x00, 0x00, 0x29, 0x0f, 0x00, 0x06, 0x63, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96,
  0xb9, 0xe3, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x08, 0x05, 0x0f, 0xff,
// video parameter table for mode d (EGA 320x200 16-color planar graphics)
  0x28, 0x18, 0x08, 0x00, 0x20, 0x09, 0x0f, 0x00, 0x06, 0x63, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80,
  0xbf, 0x1f, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96,
  0xb9, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode e (EGA 640x200 16-color planar graphics)
  0x50, 0x18, 0x08, 0x00, 0x40, 0x01, 0x0f, 0x00, 0x06, 0x63, 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80,
  0xbf, 0x1f, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x00, 0x96,
  0xb9, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode f (EGA 640x350 monochrone graphics, 64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x05, 0x0f, 0x00, 0x00, 0xa2, 0x60, 0x4f, 0x56, 0x1a, 0x50, 0xe0,
  0x70, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2e, 0x5d, 0x14, 0x00, 0x5e,
  0x6e, 0x8b, 0xff, 0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x0b, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0f, 0xff,
// video parameter table for mode 10 (EGA 640x350 4-color planar graphics, 64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x05, 0x0f, 0x00, 0x00, 0xa7, 0x5b, 0x4f, 0x53, 0x17, 0x50, 0xba,
  0x6c, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2b, 0x5d, 0x14, 0x0f, 0x5f,
  0x0a, 0x8b, 0xff, 0x00, 0x01, 0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04,
  0x07, 0x00, 0x00, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0f, 0xff,
// video parameter table for mode f (EGA 640x350 monochrome graphics, >64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x01, 0x0f, 0x00, 0x06, 0xa2, 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80,
  0xbf, 0x1f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63,
  0xba, 0xe3, 0xff, 0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x0b, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0xff,
// video parameter table for mode 10 (EGA 640x350 16-color planar graphics, >64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x01, 0x0f, 0x00, 0x06, 0xa3, 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80,
  0xbf, 0x1f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63,
  0xba, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode 0 (40x25 text high res grayscale EGA)
  0x28, 0x18, 0x0e, 0x00, 0x08, 0x09, 0x03, 0x00, 0x02, 0xa3, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0,
  0xbf, 0x1f, 0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x83, 0x85, 0x5d, 0x14, 0x1f, 0x63,
  0xba, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 1 (40x25 text high res EGA)
  0x28, 0x18, 0x0e, 0x00, 0x08, 0x09, 0x03, 0x00, 0x02, 0xa3, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0,
  0xbf, 0x1f, 0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x83, 0x85, 0x5d, 0x14, 0x1f, 0x63,
  0xba, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 2 (80x25 text high res grayscale EGA)
  0x50, 0x18, 0x0e, 0x00, 0x10, 0x01, 0x03, 0x00, 0x02, 0xa3, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x83, 0x85, 0x5d, 0x28, 0x1f, 0x63,
  0xba, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 3 (80x25 text high res EGA)
  0x50, 0x18, 0x0e, 0x00, 0x10, 0x01, 0x03, 0x00, 0x02, 0xa3, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x83, 0x85, 0x5d, 0x28, 0x1f, 0x63,
  0xba, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode e (40x25 text high res VGA)
  0x28, 0x18, 0x10, 0x00, 0x08, 0x08, 0x03, 0x00, 0x02, 0x67, 0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0,
  0xbf, 0x1f, 0x00, 0x4f, 0x0d, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x14, 0x1f, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x0c, 0x00, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode f (80x25 text high res VGA)
  0x50, 0x18, 0x10, 0x00, 0x10, 0x00, 0x03, 0x00, 0x02, 0x67, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x4f, 0x0d, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x0c, 0x00, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 10 (80x25 text high res monochrome VGA)
  0x50, 0x18, 0x10, 0x00, 0x10, 0x00, 0x03, 0x00, 0x02, 0x66, 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81,
  0xbf, 0x1f, 0x00, 0x4f, 0x0d, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x0f, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x0e, 0x00, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x00, 0xff,
// video parameter table for mode 11 (MCGA 640x480 monochrome graphics)
  0x50, 0x1d, 0x10, 0x00, 0xa0, 0x01, 0x0f, 0x00, 0x06, 0xe3, 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80,
  0x0b, 0x3e, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x8c, 0xdf, 0x28, 0x00, 0xe7,
  0x04, 0xc3, 0xff, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
  0x3f, 0x3f, 0x3f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0xff,
// video parameter table for mode 12 (VGA 640x480 16-color planar graphics)
  0x50, 0x1d, 0x10, 0x00, 0xa0, 0x01, 0x0f, 0x00, 0x06, 0xe3, 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80,
  0x0b, 0x3e, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x8c, 0xdf, 0x28, 0x00, 0xe7,
  0x04, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode 13 (VGA 320x200 256-color graphics)
  0x28, 0x18, 0x08, 0x00, 0x20, 0x01, 0x0f, 0x00, 0x0e, 0x63, 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80,
  0xbf, 0x1f, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x40, 0x96,
  0xb9, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c,
  0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x0f, 0xff,
};

static uint8_t video_parameter_table_ega[0x40*0x17]={
// video parameter table for mode 0 (40x25 text CGA emulation grayscale)
  0x28, 0x18, 0x08, 0x00, 0x08, 0x0b, 0x03, 0x00, 0x03, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x31, 0x15,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 1 (40x25 text CGA emulation)
  0x28, 0x18, 0x08, 0x00, 0x08, 0x0b, 0x03, 0x00, 0x03, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x31, 0x15,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 2 (80x25 text CGA emulation grayscale)
  0x50, 0x18, 0x08, 0x00, 0x10, 0x01, 0x03, 0x00, 0x03, 0x23, 0x70, 0x4f, 0x5c, 0x2f, 0x5f, 0x07,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x28, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 3 (80x25 text CGA emulation)
  0x50, 0x18, 0x08, 0x00, 0x10, 0x01, 0x03, 0x00, 0x03, 0x23, 0x70, 0x4f, 0x5c, 0x2f, 0x5f, 0x07,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x28, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 4 (CGA 320x200 4-color grayscale)
  0x28, 0x18, 0x08, 0x00, 0x40, 0x0b, 0x03, 0x00, 0x02, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x30, 0x14,
  0x04, 0x11, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x00, 0xe0,
  0xf0, 0xa2, 0xff, 0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x00, 0xff,
// video parameter table for mode 5 (CGA 320x200 4-color)
  0x28, 0x18, 0x08, 0x00, 0x40, 0x0b, 0x03, 0x00, 0x02, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x30, 0x14,
  0x04, 0x11, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x00, 0xe0,
  0xf0, 0xa2, 0xff, 0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x00, 0xff,
// video parameter table for mode 6 (CGA 640x200 2-color)
  0x50, 0x18, 0x08, 0x00, 0x40, 0x01, 0x01, 0x00, 0x06, 0x23, 0x70, 0x4f, 0x59, 0x2d, 0x5e, 0x06,
  0x04, 0x11, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x23, 0xc7, 0x28, 0x00, 0xdf,
  0xef, 0xc2, 0xff, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0xff,
// video parameter table for mode 7 (80x25 text MDA emulation)
  0x50, 0x18, 0x0e, 0x00, 0x10, 0x00, 0x03, 0x00, 0x03, 0xa6, 0x60, 0x4f, 0x56, 0x3a, 0x51, 0x60,
  0x70, 0x1f, 0x00, 0x0d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2e, 0x5d, 0x28, 0x0d, 0x5e,
  0x6e, 0xa3, 0xff, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x0e, 0x00, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x00, 0xff,
// video parameter table for mode 8
  0x28, 0x18, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x03, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x31, 0x15,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 9
  0x28, 0x18, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x03, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x31, 0x15,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode a
  0x28, 0x18, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x03, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x31, 0x15,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode b
  0x50, 0x18, 0x08, 0x00, 0x10, 0x01, 0x04, 0x00, 0x07, 0x23, 0x70, 0x4f, 0x5c, 0x2f, 0x5f, 0x07,
  0x04, 0x11, 0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x28, 0x08, 0xe0,
  0xf0, 0xa3, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xff,
// video parameter table for mode c
  0x50, 0x18, 0x0e, 0x00, 0x10, 0x00, 0x04, 0x00, 0x07, 0xa6, 0x60, 0x4f, 0x56, 0x3a, 0x51, 0x60,
  0x70, 0x1f, 0x00, 0x0d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2e, 0x5d, 0x28, 0x0d, 0x5e,
  0x6e, 0xa3, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0e, 0x00, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xff,
// video parameter table for mode d (EGA 320x200 16-color planar graphics)
  0x28, 0x18, 0x08, 0x00, 0x20, 0x0b, 0x0f, 0x00, 0x06, 0x23, 0x37, 0x27, 0x2d, 0x37, 0x30, 0x14,
  0x04, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x24, 0xc7, 0x14, 0x00, 0xe0,
  0xf0, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode e (EGA 640x200 16-color planar graphics)
  0x50, 0x18, 0x08, 0x00, 0x40, 0x01, 0x0f, 0x00, 0x06, 0x23, 0x70, 0x4f, 0x59, 0x2d, 0x5e, 0x06,
  0x04, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x23, 0xc7, 0x28, 0x00, 0xdf,
  0xef, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13, 0x14,
  0x15, 0x16, 0x17, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode f (EGA 640x350 monochrone graphics, 64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x05, 0x0f, 0x00, 0x00, 0xa2, 0x60, 0x4f, 0x56, 0x1a, 0x50, 0xe0,
  0x70, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2e, 0x5d, 0x14, 0x0d, 0x5e,
  0x6e, 0x8b, 0xff, 0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x0b, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0f, 0xff,
// video parameter table for mode 10 (EGA 640x350 4-color planar graphics, 64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x05, 0x0f, 0x00, 0x00, 0xa7, 0x5b, 0x4f, 0x53, 0x17, 0x50, 0xba,
  0x6c, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2b, 0x5d, 0x14, 0x0f, 0x5f,
  0x0a, 0x8b, 0xff, 0x00, 0x01, 0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04,
  0x07, 0x00, 0x00, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0f, 0xff,
// video parameter table for mode f (EGA 640x350 monochrome graphics, >64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x01, 0x0f, 0x00, 0x06, 0xa2, 0x60, 0x4f, 0x56, 0x3a, 0x50, 0x60,
  0x70, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2e, 0x5d, 0x28, 0x0d, 0x5e,
  0x6e, 0xe3, 0xff, 0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x0b, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode 10 (EGA 640x350 16-color planar graphics, >64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, 0x01, 0x0f, 0x00, 0x06, 0xa7, 0x5b, 0x4f, 0x53, 0x37, 0x52, 0x00,
  0x6c, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2b, 0x5d, 0x28, 0x0f, 0x5f,
  0x0a, 0xe3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff,
// video parameter table for mode 0 (40x25 text high res grayscale)
  0x28, 0x18, 0x0e, 0x00, 0x08, 0x0b, 0x03, 0x00, 0x03, 0xa7, 0x2d, 0x27, 0x2b, 0x2d, 0x28, 0x6d,
  0x6c, 0x1f, 0x00, 0x0d, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2b, 0x5d, 0x14, 0x0f, 0x5e,
  0x0a, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 1 (40x25 text high res)
  0x28, 0x18, 0x0e, 0x00, 0x08, 0x0b, 0x03, 0x00, 0x03, 0xa7, 0x2d, 0x27, 0x2b, 0x2d, 0x28, 0x6d,
  0x6c, 0x1f, 0x00, 0x0d, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2b, 0x5d, 0x14, 0x0f, 0x5e,
  0x0a, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 2 (80x25 text high res grayscale)
  0x50, 0x18, 0x0e, 0x00, 0x10, 0x01, 0x03, 0x00, 0x03, 0xa7, 0x5b, 0x4f, 0x53, 0x37, 0x51, 0x5b,
  0x6c, 0x1f, 0x00, 0x0d, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2b, 0x5d, 0x28, 0x0f, 0x5e,
  0x0a, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff,
// video parameter table for mode 3 (80x25 text high res)
  0x50, 0x18, 0x0e, 0x00, 0x10, 0x01, 0x03, 0x00, 0x03, 0xa7, 0x5b, 0x4f, 0x53, 0x37, 0x51, 0x5b,
  0x6c, 0x1f, 0x00, 0x0d, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x2b, 0x5d, 0x28, 0x0f, 0x5e,
  0x0a, 0xa3, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
  0x3d, 0x3e, 0x3f, 0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff
};

// TODO: Apparent MCGA video parameter table
//
// +0x0000-0x002F = ??
// +0x0030-0x006F = Video mode 0/1 params
// +0x0070-0x00AF = Video mode 2/3 params
// +0x00B0-0x00EF = Video mode 4/5 params
// +0x00F0-0x012F = Video mode 6 params
// +0x0130-0x014F = Video mode 17 (0x11) params
// +0x0150-0x016F = Video mode 19 (0x13) params
//
// BIOS code:
//
// ES:BX = [40:A8]          READ TABLE LOCATION FROM 40:A8
// ES:BX = [ES:BX]          READ FROM FIRST POINTER IN TABLE
// BX += 0x30               TABLE ENTRIES OFFSET BY 0x30 BYTES (?)
// IF AH <= 6 THEN
//   CX = VIDEO MODE
//   IF CX != 0 THEN
//     DO
//       IF (CX & 1) == 0 THEN
//         BX += 0x40
//       ENDIF
//       CX--
//     WHILE CX != 0
//   ENDIF
//   GOTO END
// ENDIF
// IF AH != 0x11
//   IF AH != 0x13
//     GOTO END
//   ENDIF
//   BX += 0x120            AH = 0x13 HERE
//   GOTO END
// ENDIF
// BX += 0x100              AH = 0x11 HERE
// GOTO END
// END:
//   (RETURN)
//
// TODO: Copy 0x170 bytes of video parameter table from MCGA BIOS.
//       Refer to NOTES, which has a snapshot of the MCGA BIOS within it.

uint16_t INT10_SetupVideoParameterTable(PhysPt basepos) {
	if (IS_VGA_ARCH) {
		for (uint16_t i=0;i<0x40*0x1d;i++) {
			phys_writeb(basepos+i,video_parameter_table_vga[i]);
		}
		return 0x40*0x1d;
	} else {
		for (uint16_t i=0;i<0x40*0x17;i++) {
			phys_writeb(basepos+i,video_parameter_table_ega[i]);
		}
		return 0x40*0x17;
	}
    // TODO: MCGA
}

Bitu RealToPhys(Bitu x) {
	return PhysMake((uint16_t)(x>>16),x&0xFFFF);
}

void INT10_SetupBasicVideoParameterTable(void) {
	const unsigned char *copy = NULL;
	size_t copy_sz = 0;
	Bitu ofs;

	switch (machine) {
		case MCH_TANDY:
			copy = vparams_tandy;
			copy_sz = sizeof(vparams_tandy);
			break;
		case MCH_PCJR:
			copy = vparams_pcjr;
			copy_sz = sizeof(vparams_pcjr);
			break;
		default:
			copy = vparams;
			copy_sz = sizeof(vparams);
			break;
	}

	if (BIOS_VIDEO_TABLE_LOCATION == ~(0U) || BIOS_VIDEO_TABLE_SIZE != (Bitu)copy_sz) {
		if (rom_bios_vptable_enable) {
			/* TODO: Free previous block */

			BIOS_VIDEO_TABLE_SIZE = (Bitu)copy_sz;
            BIOS_VIDEO_TABLE_LOCATION = (Bitu)PhysToReal416((PhysPt)ROMBIOS_GetMemory((Bitu)copy_sz,"BIOS video table (INT 1Dh)")); /* TODO: make option */

			/* NTS: Failure to allocate means BIOS_VIDEO_TABLE_LOCATION == 0 */
		}
		else {
			BIOS_VIDEO_TABLE_LOCATION = 0;
		}
	}

	RealSetVec(0x1d,(RealPt)BIOS_VIDEO_TABLE_LOCATION);
	ofs = RealToPhys(BIOS_VIDEO_TABLE_LOCATION);
	if (ofs != 0) {
		if (copy && copy_sz <= BIOS_VIDEO_TABLE_SIZE) {
			for (size_t i=0;i < copy_sz;i++)
				phys_writeb((PhysPt)(ofs+(PhysPt)i),copy[i]);
		}
		else {
			E_Exit("Somehow, INT 10 video param table too large");
		}
	}
}

#if 0
void INT10_GenerateVideoParameterTable(void) {
	if (!IS_VGA_ARCH) E_Exit("Be sure that all graphics registers are readable!");
	Bitu i;
	for (i=0; i<4; i++) {
		LOG_MSG("// video parameter table for mode %x (cga emulation)",i);
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
	}
	for (i=4; i<0x0f; i++) {
		Bitu ct;
		LOG_MSG("// video parameter table for mode %x",i);
		if ((i>=8) && (i<0x0d)) {
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		} else {
			INT10_SetVideoMode(i);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
			Bitu seq_regs[4];
			for (ct=0; ct<4; ct++) {
				IO_WriteB(0x3c4,ct+1);
				seq_regs[ct]=IO_ReadB(0x3c5);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
			LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
			Bitu crtc_regs[0x19];
			uint16_t crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
			for (ct=0; ct<0x19; ct++) {
				IO_WriteB(crt_addr,ct);
				crtc_regs[ct]=IO_ReadB(crt_addr+1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
				crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
				crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
				crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
				crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
				crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
				crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
			Bitu attr_regs[0x14];
			for (ct=0; ct<0x14; ct++) {
				IO_ReadB(crt_addr+6);
				IO_WriteB(0x3c0,ct);
				attr_regs[ct]=IO_ReadB(0x3c1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
				attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
				attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
				attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
				attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
				attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
			Bitu gfx_regs[9];
			for (ct=0; ct<0x09; ct++) {
				IO_WriteB(0x3ce,ct);
				gfx_regs[ct]=IO_ReadB(0x3cf);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
				gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
				gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
		}
	}
	for (i=0x0f; i<0x11; i++) {
		LOG_MSG("// video parameter table for mode %x (64k graphics memory)",i);
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
	}
	for (i=0x0f; i<0x11; i++) {
		Bitu ct;
		INT10_SetVideoMode(i);
		LOG_MSG("// video parameter table for mode %x (>64k graphics memory)",i);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
		Bitu seq_regs[4];
		for (ct=0; ct<4; ct++) {
			IO_WriteB(0x3c4,ct+1);
			seq_regs[ct]=IO_ReadB(0x3c5);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
		LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
		Bitu crtc_regs[0x19];
		uint16_t crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
		for (ct=0; ct<0x19; ct++) {
			IO_WriteB(crt_addr,ct);
			crtc_regs[ct]=IO_ReadB(crt_addr+1);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
			crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
			crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
			crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
			crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
			crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
			crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
		Bitu attr_regs[0x14];
		for (ct=0; ct<0x14; ct++) {
			IO_ReadB(crt_addr+6);
			IO_WriteB(0x3c0,ct);
			attr_regs[ct]=IO_ReadB(0x3c1);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
			attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
			attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
			attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
			attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
			attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
		Bitu gfx_regs[9];
		for (ct=0; ct<0x09; ct++) {
			IO_WriteB(0x3ce,ct);
			gfx_regs[ct]=IO_ReadB(0x3cf);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
			gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
			gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
	}
	for (i=0; i<4; i++) {
		if (IS_VGA_ARCH) {
			LOG_MSG("// video parameter table for mode %x (350 lines)",i);
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		} else {
			Bitu ct;
			INT10_SetVideoMode(i);
			LOG_MSG("// video parameter table for mode %x (350 lines)",i);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
			Bitu seq_regs[4];
			for (ct=0; ct<4; ct++) {
				IO_WriteB(0x3c4,ct+1);
				seq_regs[ct]=IO_ReadB(0x3c5);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
			LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
			Bitu crtc_regs[0x19];
			uint16_t crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
			for (ct=0; ct<0x19; ct++) {
				IO_WriteB(crt_addr,ct);
				crtc_regs[ct]=IO_ReadB(crt_addr+1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
				crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
				crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
				crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
				crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
				crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
				crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
			Bitu attr_regs[0x14];
			for (ct=0; ct<0x14; ct++) {
				IO_ReadB(crt_addr+6);
				IO_WriteB(0x3c0,ct);
				attr_regs[ct]=IO_ReadB(0x3c1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
				attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
				attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
				attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
				attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
				attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
			Bitu gfx_regs[9];
			for (ct=0; ct<0x09; ct++) {
				IO_WriteB(0x3ce,ct);
				gfx_regs[ct]=IO_ReadB(0x3cf);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
				gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
				gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
		}
	}
	if (IS_VGA_ARCH) {
		for (i=0x0e; i<0x14; i++) {
			Bitu ct=i;
			if (i==0x0e) ct=1;
			if (i==0x0f) ct=3;
			if (i==0x010) ct=7;
			INT10_SetVideoMode(ct);
			LOG_MSG("// video parameter table for mode %x",i);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
			Bitu seq_regs[4];
			for (ct=0; ct<4; ct++) {
				IO_WriteB(0x3c4,ct+1);
				seq_regs[ct]=IO_ReadB(0x3c5);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
			LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
			Bitu crtc_regs[0x19];
			uint16_t crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
			for (ct=0; ct<0x19; ct++) {
				IO_WriteB(crt_addr,ct);
				crtc_regs[ct]=IO_ReadB(crt_addr+1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
				crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
				crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
				crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
				crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
				crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
				crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
			Bitu attr_regs[0x14];
			for (ct=0; ct<0x14; ct++) {
				IO_ReadB(crt_addr+6);
				IO_WriteB(0x3c0,ct);
				attr_regs[ct]=IO_ReadB(0x3c1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
				attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
				attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
				attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
				attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
				attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
			Bitu gfx_regs[9];
			for (ct=0; ct<0x09; ct++) {
				IO_WriteB(0x3ce,ct);
				gfx_regs[ct]=IO_ReadB(0x3cf);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
				gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
				gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
		}
	}
	INT10_SetVideoMode(3);
	E_Exit("done!");
}
#endif 
