C -------------------------------------------------------------
C CHI2INV returns the inverse of the chi-square cdf with V
C degrees of freedom at the values in P. The variate is computed
C only for a selected number of degrees of freedom (1:100)
C and P-values (.05:.1:.95). P and V take integer values
C Developed by A.Rossi, C.Planas and G.Fiorentini
C
C Copyright (C) 2010-2014 European Commission
C
C This file is part of Program DMM
C
C DMM is free software developed at the Joint Research Centre of the
C European Commission: you can redistribute it and/or modify it under
C the terms of the GNU General Public License as published by
C the Free Software Foundation, either version 3 of the License, or
C (at your option) any later version.
C
C DMM is distributed in the hope that it will be useful,
C but WITHOUT ANY WARRANTY; without even the implied warranty of
C MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C GNU General Public License for more details.
C
C You should have received a copy of the GNU General Public License
C along with DMM.  If not, see <http://www.gnu.org/licenses/>.
C -------------------------------------------------------------
      DOUBLE PRECISION FUNCTION CHI2INV(P,V)
C INPUT
      INTEGER P,V
C LOCALS
      DOUBLE PRECISION T(200,10)

      DATA T( 1,1:5)  /  0.0039, 0.0358, 0.1015, 0.2059, 0.3573/
      DATA T( 2,1:5)  /  0.1026, 0.3250, 0.5754, 0.8616, 1.1957/
      DATA T( 3,1:5)  /  0.3518, 0.7978, 1.2125, 1.6416, 2.1095/
      DATA T( 4,1:5)  /  0.7107, 1.3665, 1.9226, 2.4701, 3.0469/
      DATA T( 5,1:5)  /  1.1455, 1.9938, 2.6746, 3.3251, 3.9959/
      DATA T( 6,1:5)  /  1.6354, 2.6613, 3.4546, 4.1973, 4.9519/
      DATA T( 7,1:5)  /  2.1673, 3.3583, 4.2549, 5.0816, 5.9125/
      DATA T( 8,1:5)  /  2.7326, 4.0782, 5.0706, 5.9753, 6.8766/
      DATA T( 9,1:5)  /  3.3251, 4.8165, 5.8988, 6.8763, 7.8434/
      DATA T(10,1:5)  /  3.9403, 5.5701, 6.7372, 7.7832, 8.8124/
      DATA T(11,1:5)  /  4.5748, 6.3364, 7.5841, 8.6952, 9.7831/
      DATA T(12,1:5)  /  5.2260, 7.1138, 8.4384, 9.6115,10.7553/
      DATA T(13,1:5)  /  5.8919, 7.9008, 9.2991,10.5315,11.7288/
      DATA T(14,1:5)  /  6.5706, 8.6963,10.1653,11.4548,12.7034/
      DATA T(15,1:5)  /  7.2609, 9.4993,11.0365,12.3809,13.6790/
      DATA T(16,1:5)  /  7.9616,10.3090,11.9122,13.3096,14.6555/
      DATA T(17,1:5)  /  8.6718,11.1249,12.7919,14.2407,15.6328/
      DATA T(18,1:5)  /  9.3905,11.9463,13.6753,15.1738,16.6108/
      DATA T(19,1:5)  / 10.1170,12.7727,14.5620,16.1089,17.5894/
      DATA T(20,1:5)  / 10.8508,13.6039,15.4518,17.0458,18.5687/
      DATA T(21,1:5)  / 11.5913,14.4393,16.3444,17.9843,19.5485/
      DATA T(22,1:5)  / 12.3380,15.2788,17.2396,18.9243,20.5288/
      DATA T(23,1:5)  / 13.0905,16.1219,18.1373,19.8657,21.5096/
      DATA T(24,1:5)  / 13.8484,16.9686,19.0373,20.8084,22.4908/
      DATA T(25,1:5)  / 14.6114,17.8184,19.9393,21.7524,23.4724/
      DATA T(26,1:5)  / 15.3792,18.6714,20.8434,22.6975,24.4544/
      DATA T(27,1:5)  / 16.1514,19.5272,21.7494,23.6437,25.4368/
      DATA T(28,1:5)  / 16.9279,20.3857,22.6572,24.5909,26.4195/
      DATA T(29,1:5)  / 17.7084,21.2468,23.5666,25.5391,27.4025/
      DATA T(30,1:5)  / 18.4927,22.1103,24.4776,26.4881,28.3858/
      DATA T(31,1:5)  / 19.2806,22.9762,25.3901,27.4381,29.3694/
      DATA T(32,1:5)  / 20.0719,23.8442,26.3041,28.3889,30.3533/
      DATA T(33,1:5)  / 20.8665,24.7143,27.2194,29.3405,31.3375/
      DATA T(34,1:5)  / 21.6643,25.5864,28.1361,30.2928,32.3219/
      DATA T(35,1:5)  / 22.4650,26.4604,29.0540,31.2458,33.3065/
      DATA T(36,1:5)  / 23.2686,27.3362,29.9730,32.1995,34.2913/
      DATA T(37,1:5)  / 24.0749,28.2138,30.8933,33.1539,35.2764/
      DATA T(38,1:5)  / 24.8839,29.0931,31.8146,34.1089,36.2617/
      DATA T(39,1:5)  / 25.6954,29.9739,32.7369,35.0645,37.2472/
      DATA T(40,1:5)  / 26.5093,30.8563,33.6603,36.0207,38.2328/
      DATA T(41,1:5)  / 27.3256,31.7402,34.5846,36.9774,39.2187/
      DATA T(42,1:5)  / 28.1440,32.6255,35.5099,37.9347,40.2047/
      DATA T(43,1:5)  / 28.9647,33.5122,36.4361,38.8924,41.1909/
      DATA T(44,1:5)  / 29.7875,34.4002,37.3631,39.8507,42.1773/
      DATA T(45,1:5)  / 30.6123,35.2895,38.2910,40.8095,43.1638/
      DATA T(46,1:5)  / 31.4390,36.1801,39.2197,41.7687,44.1505/
      DATA T(47,1:5)  / 32.2676,37.0719,40.1492,42.7284,45.1373/
      DATA T(48,1:5)  / 33.0981,37.9648,41.0794,43.6885,46.1243/
      DATA T(49,1:5)  / 33.9303,38.8588,42.0104,44.6491,47.1114/
      DATA T(50,1:5)  / 34.7643,39.7539,42.9421,45.6100,48.0986/
      DATA T(51,1:5)  / 35.5999,40.6501,43.8745,46.5713,49.0860/
      DATA T(52,1:5)  / 36.4371,41.5473,44.8075,47.5331,50.0735/
      DATA T(53,1:5)  / 37.2759,42.4455,45.7412,48.4952,51.0611/
      DATA T(54,1:5)  / 38.1162,43.3447,46.6755,49.4576,52.0488/
      DATA T(55,1:5)  / 38.9580,44.2448,47.6105,50.4204,53.0367/
      DATA T(56,1:5)  / 39.8013,45.1459,48.5460,51.3836,54.0246/
      DATA T(57,1:5)  / 40.6459,46.0478,49.4821,52.3470,55.0127/
      DATA T(58,1:5)  / 41.4920,46.9506,50.4188,53.3109,56.0009/
      DATA T(59,1:5)  / 42.3393,47.8542,51.3560,54.2750,56.9892/
      DATA T(60,1:5)  / 43.1880,48.7587,52.2938,55.2394,57.9776/
      DATA T(61,1:5)  / 44.0379,49.6639,53.2321,56.2041,58.9660/
      DATA T(62,1:5)  / 44.8890,50.5700,54.1709,57.1692,59.9546/
      DATA T(63,1:5)  / 45.7414,51.4768,55.1102,58.1345,60.9433/
      DATA T(64,1:5)  / 46.5949,52.3843,56.0500,59.1000,61.9320/
      DATA T(65,1:5)  / 47.4496,53.2926,56.9903,60.0659,62.9209/
      DATA T(66,1:5)  / 48.3054,54.2016,57.9310,61.0320,63.9098/
      DATA T(67,1:5)  / 49.1623,55.1112,58.8722,61.9984,64.8988/
      DATA T(68,1:5)  / 50.0202,56.0216,59.8138,62.9650,65.8880/
      DATA T(69,1:5)  / 50.8792,56.9326,60.7559,63.9319,66.8771/
      DATA T(70,1:5)  / 51.7393,57.8443,61.6983,64.8990,67.8664/
      DATA T(71,1:5)  / 52.6003,58.7566,62.6412,65.8664,68.8557/
      DATA T(72,1:5)  / 53.4623,59.6695,63.5845,66.8340,69.8452/
      DATA T(73,1:5)  / 54.3253,60.5830,64.5282,67.8018,70.8347/
      DATA T(74,1:5)  / 55.1892,61.4972,65.4723,68.7698,71.8242/
      DATA T(75,1:5)  / 56.0541,62.4119,66.4168,69.7381,72.8139/
      DATA T(76,1:5)  / 56.9198,63.3272,67.3616,70.7066,73.8036/
      DATA T(77,1:5)  / 57.7864,64.2430,68.3068,71.6752,74.7933/
      DATA T(78,1:5)  / 58.6539,65.1594,69.2523,72.6441,75.7832/
      DATA T(79,1:5)  / 59.5223,66.0763,70.1983,73.6132,76.7731/
      DATA T(80,1:5)  / 60.3915,66.9938,71.1445,74.5825,77.7631/
      DATA T(81,1:5)  / 61.2615,67.9118,72.0911,75.5520,78.7531/
      DATA T(82,1:5)  / 62.1323,68.8303,73.0380,76.5216,79.7432/
      DATA T(83,1:5)  / 63.0039,69.7492,73.9853,77.4915,80.7334/
      DATA T(84,1:5)  / 63.8763,70.6687,74.9328,78.4615,81.7236/
      DATA T(85,1:5)  / 64.7494,71.5887,75.8807,79.4317,82.7139/
      DATA T(86,1:5)  / 65.6233,72.5091,76.8289,80.4021,83.7042/
      DATA T(87,1:5)  / 66.4979,73.4300,77.7774,81.3727,84.6946/
      DATA T(88,1:5)  / 67.3732,74.3514,78.7262,82.3434,85.6850/
      DATA T(89,1:5)  / 68.2493,75.2732,79.6753,83.3143,86.6755/
      DATA T(90,1:5)  / 69.1260,76.1954,80.6247,84.2854,87.6661/
      DATA T(91,1:5)  / 70.0035,77.1181,81.5743,85.2566,88.6567/
      DATA T(92,1:5)  / 70.8816,78.0412,82.5243,86.2280,89.6474/
      DATA T(93,1:5)  / 71.7603,78.9647,83.4745,87.1996,90.6381/
      DATA T(94,1:5)  / 72.6398,79.8887,84.4249,88.1713,91.6288/
      DATA T(95,1:5)  / 73.5198,80.8130,85.3757,89.1431,92.6197/
      DATA T(96,1:5)  / 74.4005,81.7378,86.3267,90.1151,93.6105/
      DATA T(97,1:5)  / 75.2819,82.6629,87.2779,91.0873,94.6014/
      DATA T(98,1:5)  / 76.1638,83.5884,88.2295,92.0596,95.5924/
      DATA T(99,1:5)  / 77.0463,84.5143,89.1812,93.0320,96.5834/
      DATA T(100,1:5) / 77.9295,85.4406,90.1332,94.0046,97.5744/
      DATA T( 1,6:10) /  0.5707,  0.8735,  1.3233,  2.0723,  3.8415/
      DATA T( 2,6:10) /  1.5970,  2.0996,  2.7726,  3.7942,  5.9915/
      DATA T( 3,6:10) /  2.6430,  3.2831,  4.1083,  5.3170,  7.8147/
      DATA T( 4,6:10) /  3.6871,  4.4377,  5.3853,  6.7449,  9.4877/
      DATA T( 5,6:10) /  4.7278,  5.5731,  6.6257,  8.1152, 11.0705/
      DATA T( 6,6:10) /  5.7652,  6.6948,  7.8408,  9.4461, 12.5916/
      DATA T( 7,6:10) /  6.8000,  7.8061,  9.0371, 10.7479, 14.0671/
      DATA T( 8,6:10) /  7.8325,  8.9094, 10.2189, 12.0271, 15.5073/
      DATA T( 9,6:10) /  8.8632, 10.0060, 11.3888, 13.2880, 16.9190/
      DATA T(10,6:10) /  9.8922, 11.0971, 12.5489, 14.5339, 18.3070/
      DATA T(11,6:10) / 10.9199, 12.1836, 13.7007, 15.7671, 19.6751/
      DATA T(12,6:10) / 11.9463, 13.2661, 14.8454, 16.9893, 21.0261/
      DATA T(13,6:10) / 12.9717, 14.3451, 15.9839, 18.2020, 22.3620/
      DATA T(14,6:10) / 13.9961, 15.4209, 17.1169, 19.4062, 23.6848/
      DATA T(15,6:10) / 15.0197, 16.4940, 18.2451, 20.6030, 24.9958/
      DATA T(16,6:10) / 16.0425, 17.5646, 19.3689, 21.7931, 26.2962/
      DATA T(17,6:10) / 17.0646, 18.6330, 20.4887, 22.9770, 27.5871/
      DATA T(18,6:10) / 18.0860, 19.6993, 21.6049, 24.1555, 28.8693/
      DATA T(19,6:10) / 19.1069, 20.7638, 22.7178, 25.3289, 30.1435/
      DATA T(20,6:10) / 20.1272, 21.8265, 23.8277, 26.4976, 31.4104/
      DATA T(21,6:10) / 21.1470, 22.8876, 24.9348, 27.6620, 32.6706/
      DATA T(22,6:10) / 22.1663, 23.9473, 26.0393, 28.8225, 33.9244/
      DATA T(23,6:10) / 23.1852, 25.0055, 27.1413, 29.9792, 35.1725/
      DATA T(24,6:10) / 24.2037, 26.0625, 28.2412, 31.1325, 36.4150/
      DATA T(25,6:10) / 25.2218, 27.1183, 29.3389, 32.2825, 37.6525/
      DATA T(26,6:10) / 26.2395, 28.1730, 30.4346, 33.4295, 38.8851/
      DATA T(27,6:10) / 27.2569, 29.2266, 31.5284, 34.5736, 40.1133/
      DATA T(28,6:10) / 28.2740, 30.2791, 32.6205, 35.7150, 41.3371/
      DATA T(29,6:10) / 29.2908, 31.3308, 33.7109, 36.8538, 42.5570/
      DATA T(30,6:10) / 30.3073, 32.3815, 34.7997, 37.9903, 43.7730/
      DATA T(31,6:10) / 31.3235, 33.4314, 35.8871, 39.1244, 44.9853/
      DATA T(32,6:10) / 32.3394, 34.4804, 36.9730, 40.2563, 46.1943/
      DATA T(33,6:10) / 33.3551, 35.5287, 38.0575, 41.3861, 47.3999/
      DATA T(34,6:10) / 34.3706, 36.5763, 39.1408, 42.5140, 48.6024/
      DATA T(35,6:10) / 35.3858, 37.6231, 40.2228, 43.6399, 49.8018/
      DATA T(36,6:10) / 36.4008, 38.6693, 41.3036, 44.7641, 50.9985/
      DATA T(37,6:10) / 37.4156, 39.7148, 42.3833, 45.8865, 52.1923/
      DATA T(38,6:10) / 38.4302, 40.7597, 43.4619, 47.0072, 53.3835/
      DATA T(39,6:10) / 39.4446, 41.8040, 44.5395, 48.1263, 54.5722/
      DATA T(40,6:10) / 40.4589, 42.8477, 45.6160, 49.2439, 55.7585/
      DATA T(41,6:10) / 41.4729, 43.8909, 46.6916, 50.3599, 56.9424/
      DATA T(42,6:10) / 42.4868, 44.9335, 47.7663, 51.4746, 58.1240/
      DATA T(43,6:10) / 43.5005, 45.9757, 48.8400, 52.5879, 59.3035/
      DATA T(44,6:10) / 44.5141, 47.0173, 49.9129, 53.6998, 60.4809/
      DATA T(45,6:10) / 45.5275, 48.0585, 50.9849, 54.8105, 61.6562/
      DATA T(46,6:10) / 46.5407, 49.0991, 52.0562, 55.9199, 62.8296/
      DATA T(47,6:10) / 47.5538, 50.1394, 53.1267, 57.0281, 64.0011/
      DATA T(48,6:10) / 48.5668, 51.1792, 54.1964, 58.1352, 65.1708/
      DATA T(49,6:10) / 49.5796, 52.2186, 55.2653, 59.2411, 66.3386/
      DATA T(50,6:10) / 50.5923, 53.2576, 56.3336, 60.3460, 67.5048/
      DATA T(51,6:10) / 51.6049, 54.2962, 57.4012, 61.4498, 68.6693/
      DATA T(52,6:10) / 52.6173, 55.3344, 58.4681, 62.5526, 69.8322/
      DATA T(53,6:10) / 53.6296, 56.3723, 59.5344, 63.6543, 70.9935/
      DATA T(54,6:10) / 54.6418, 57.4098, 60.6000, 64.7551, 72.1532/
      DATA T(55,6:10) / 55.6539, 58.4469, 61.6650, 65.8550, 73.3115/
      DATA T(56,6:10) / 56.6659, 59.4837, 62.7294, 66.9540, 74.4683/
      DATA T(57,6:10) / 57.6778, 60.5202, 63.7933, 68.0520, 75.6237/
      DATA T(58,6:10) / 58.6896, 61.5563, 64.8565, 69.1492, 76.7778/
      DATA T(59,6:10) / 59.7012, 62.5922, 65.9193, 70.2456, 77.9305/
      DATA T(60,6:10) / 60.7128, 63.6277, 66.9815, 71.3411, 79.0819/
      DATA T(61,6:10) / 61.7243, 64.6629, 68.0431, 72.4358, 80.2321/
      DATA T(62,6:10) / 62.7357, 65.6979, 69.1043, 73.5298, 81.3810/
      DATA T(63,6:10) / 63.7470, 66.7325, 70.1650, 74.6230, 82.5287/
      DATA T(64,6:10) / 64.7582, 67.7669, 71.2251, 75.7154, 83.6753/
      DATA T(65,6:10) / 65.7693, 68.8010, 72.2848, 76.8071, 84.8206/
      DATA T(66,6:10) / 66.7803, 69.8349, 73.3441, 77.8981, 85.9649/
      DATA T(67,6:10) / 67.7912, 70.8685, 74.4029, 78.9884, 87.1081/
      DATA T(68,6:10) / 68.8021, 71.9018, 75.4612, 80.0781, 88.2502/
      DATA T(69,6:10) / 69.8129, 72.9349, 76.5192, 81.1670, 89.3912/
      DATA T(70,6:10) / 70.8236, 73.9677, 77.5767, 82.2554, 90.5312/
      DATA T(71,6:10) / 71.8342, 75.0003, 78.6337, 83.3430, 91.6702/
      DATA T(72,6:10) / 72.8448, 76.0327, 79.6904, 84.4301, 92.8083/
      DATA T(73,6:10) / 73.8552, 77.0649, 80.7467, 85.5166, 93.9453/
      DATA T(74,6:10) / 74.8656, 78.0968, 81.8026, 86.6024, 95.0815/
      DATA T(75,6:10) / 75.8760, 79.1285, 82.8581, 87.6877, 96.2167/
      DATA T(76,6:10) / 76.8862, 80.1600, 83.9133, 88.7724, 97.3510/
      DATA T(77,6:10) / 77.8964, 81.1913, 84.9680, 89.8566, 98.4844/
      DATA T(78,6:10) / 78.9066, 82.2224, 86.0225, 90.9402, 99.6169/
      DATA T(79,6:10) / 79.9166, 83.2533, 87.0765, 92.0232,100.7486/
      DATA T(80,6:10) / 80.9266, 84.2840, 88.1303, 93.1058,101.8795/
      DATA T(81,6:10) / 81.9366, 85.3145, 89.1836, 94.1878,103.0095/
      DATA T(82,6:10) / 82.9465, 86.3448, 90.2367, 95.2693,104.1387/
      DATA T(83,6:10) / 83.9563, 87.3749, 91.2894, 96.3503,105.2672/
      DATA T(84,6:10) / 84.9660, 88.4049, 92.3418, 97.4308,106.3948/
      DATA T(85,6:10) / 85.9757, 89.4346, 93.3939, 98.5108,107.5217/
      DATA T(86,6:10) / 86.9854, 90.4642, 94.4457, 99.5904,108.6479/
      DATA T(87,6:10) / 87.9950, 91.4936, 95.4972,100.6695,109.7733/
      DATA T(88,6:10) / 89.0045, 92.5229, 96.5484,101.7481,110.8980/
      DATA T(89,6:10) / 90.0140, 93.5520, 97.5993,102.8263,112.0220/
      DATA T(90,6:10) / 91.0234, 94.5809, 98.6499,103.9041,113.1453/
      DATA T(91,6:10) / 92.0328, 95.6096, 99.7003,104.9814,114.2679/
      DATA T(92,6:10) / 93.0421, 96.6382,100.7503,106.0583,115.3898/
      DATA T(93,6:10) / 94.0513, 97.6666,101.8001,107.1347,116.5110/
      DATA T(94,6:10) / 95.0606, 98.6949,102.8496,108.2108,117.6317/
      DATA T(95,6:10) / 96.0697, 99.7231,103.8988,109.2864,118.7516/
      DATA T(96,6:10) / 97.0789,100.7511,104.9478,110.3617,119.8709/
      DATA T(97,6:10) / 98.0879,101.7789,105.9966,111.4365,120.9896/
      DATA T(98,6:10) / 99.0970,102.8066,107.0450,112.5110,122.1077/
      DATA T(99,6:10) /100.1059,103.8341,108.0933,113.5851,123.2252/
      DATA T(100,6:10)/101.1149,104.8615,109.1412,114.6588,124.3421/
      DATA T(101,1:5) / 78.8132,  86.3673,  91.0855,  94.9773,  98.5655/
      DATA T(102,1:5) / 79.6975,  87.2943,  92.0380,  95.9501,  99.5567/
      DATA T(103,1:5) / 80.5823,  88.2217,  92.9907,  96.9231, 100.5478/
      DATA T(104,1:5) / 81.4678,  89.1494,  93.9436,  97.8962, 101.5391/
      DATA T(105,1:5) / 82.3537,  90.0775,  94.8968,  98.8695, 102.5303/
      DATA T(106,1:5) / 83.2403,  91.0059,  95.8502,  99.8428, 103.5217/
      DATA T(107,1:5) / 84.1273,  91.9347,  96.8038, 100.8163, 104.5130/
      DATA T(108,1:5) / 85.0149,  92.8637,  97.7577, 101.7899, 105.5044/
      DATA T(109,1:5) / 85.9030,  93.7932,  98.7117, 102.7637, 106.4958/
      DATA T(110,1:5) / 86.7916,  94.7229,  99.6660, 103.7376, 107.4873/
      DATA T(111,1:5) / 87.6808,  95.6530, 100.6204, 104.7115, 108.4788/
      DATA T(112,1:5) / 88.5704,  96.5834, 101.5751, 105.6856, 109.4704/
      DATA T(113,1:5) / 89.4605,  97.5141, 102.5300, 106.6599, 110.4619/
      DATA T(114,1:5) / 90.3511,  98.4451, 103.4851, 107.6342, 111.4536/
      DATA T(115,1:5) / 91.2422,  99.3764, 104.4404, 108.6086, 112.4452/
      DATA T(116,1:5) / 92.1338, 100.3080, 105.3959, 109.5832, 113.4369/
      DATA T(117,1:5) / 93.0258, 101.2399, 106.3515, 110.5579, 114.4287/
      DATA T(118,1:5) / 93.9183, 102.1721, 107.3074, 111.5326, 115.4204/
      DATA T(119,1:5) / 94.8112, 103.1046, 108.2634, 112.5075, 116.4122/
      DATA T(120,1:5) / 95.7046, 104.0374, 109.2197, 113.4825, 117.4041/
      DATA T(121,1:5) / 96.5985, 104.9704, 110.1761, 114.4576, 118.3960/
      DATA T(122,1:5) / 97.4928, 105.9038, 111.1327, 115.4328, 119.3879/
      DATA T(123,1:5) / 98.3875, 106.8374, 112.0895, 116.4081, 120.3798/
      DATA T(124,1:5) / 99.2826, 107.7712, 113.0464, 117.3835, 121.3718/
      DATA T(125,1:5) /100.1782, 108.7054, 114.0035, 118.3590, 122.3638/
      DATA T(126,1:5) /101.0742, 109.6398, 114.9608, 119.3346, 123.3558/
      DATA T(127,1:5) /101.9706, 110.5745, 115.9183, 120.3103, 124.3479/
      DATA T(128,1:5) /102.8674, 111.5094, 116.8759, 121.2861, 125.3400/
      DATA T(129,1:5) /103.7646, 112.4446, 117.8337, 122.2620, 126.3321/
      DATA T(130,1:5) /104.6622, 113.3800, 118.7917, 123.2380, 127.3243/
      DATA T(131,1:5) /105.5602, 114.3157, 119.7498, 124.2141, 128.3165/
      DATA T(132,1:5) /106.4586, 115.2516, 120.7081, 125.1902, 129.3087/
      DATA T(133,1:5) /107.3574, 116.1878, 121.6666, 126.1665, 130.3010/
      DATA T(134,1:5) /108.2566, 117.1242, 122.6252, 127.1428, 131.2932/
      DATA T(135,1:5) /109.1561, 118.0609, 123.5839, 128.1193, 132.2856/
      DATA T(136,1:5) /110.0560, 118.9977, 124.5429, 129.0958, 133.2779/
      DATA T(137,1:5) /110.9563, 119.9349, 125.5019, 130.0724, 134.2703/
      DATA T(138,1:5) /111.8570, 120.8722, 126.4611, 131.0491, 135.2627/
      DATA T(139,1:5) /112.7580, 121.8098, 127.4205, 132.0259, 136.2551/
      DATA T(140,1:5) /113.6593, 122.7476, 128.3800, 133.0027, 137.2475/
      DATA T(141,1:5) /114.5611, 123.6856, 129.3397, 133.9797, 138.2400/
      DATA T(142,1:5) /115.4631, 124.6239, 130.2995, 134.9567, 139.2325/
      DATA T(143,1:5) /116.3655, 125.5623, 131.2594, 135.9338, 140.2251/
      DATA T(144,1:5) /117.2683, 126.5010, 132.2195, 136.9110, 141.2176/
      DATA T(145,1:5) /118.1714, 127.4399, 133.1797, 137.8883, 142.2102/
      DATA T(146,1:5) /119.0748, 128.3790, 134.1401, 138.8656, 143.2028/
      DATA T(147,1:5) /119.9786, 129.3183, 135.1006, 139.8431, 144.1954/
      DATA T(148,1:5) /120.8826, 130.2578, 136.0612, 140.8206, 145.1881/
      DATA T(149,1:5) /121.7870, 131.1976, 137.0220, 141.7982, 146.1808/
      DATA T(150,1:5) /122.6918, 132.1375, 137.9829, 142.7758, 147.1735/
      DATA T(151,1:5) /123.5968, 133.0776, 138.9439, 143.7535, 148.1662/
      DATA T(152,1:5) /124.5022, 134.0179, 139.9050, 144.7313, 149.1590/
      DATA T(153,1:5) /125.4079, 134.9585, 140.8663, 145.7092, 150.1518/
      DATA T(154,1:5) /126.3138, 135.8992, 141.8277, 146.6872, 151.1446/
      DATA T(155,1:5) /127.2201, 136.8401, 142.7893, 147.6652, 152.1374/
      DATA T(156,1:5) /128.1267, 137.7812, 143.7509, 148.6433, 153.1303/
      DATA T(157,1:5) /129.0336, 138.7225, 144.7127, 149.6215, 154.1231/
      DATA T(158,1:5) /129.9408, 139.6640, 145.6746, 150.5997, 155.1160/
      DATA T(159,1:5) /130.8483, 140.6056, 146.6367, 151.5780, 156.1090/
      DATA T(160,1:5) /131.7561, 141.5475, 147.5988, 152.5564, 157.1019/
      DATA T(161,1:5) /132.6641, 142.4895, 148.5611, 153.5348, 158.0949/
      DATA T(162,1:5) /133.5725, 143.4317, 149.5234, 154.5133, 159.0879/
      DATA T(163,1:5) /134.4811, 144.3741, 150.4859, 155.4919, 160.0809/
      DATA T(164,1:5) /135.3900, 145.3167, 151.4486, 156.4705, 161.0739/
      DATA T(165,1:5) /136.2992, 146.2594, 152.4113, 157.4492, 162.0670/
      DATA T(166,1:5) /137.2087, 147.2024, 153.3741, 158.4280, 163.0600/
      DATA T(167,1:5) /138.1184, 148.1455, 154.3371, 159.4068, 164.0531/
      DATA T(168,1:5) /139.0284, 149.0887, 155.3002, 160.3857, 165.0462/
      DATA T(169,1:5) /139.9387, 150.0321, 156.2633, 161.3647, 166.0394/
      DATA T(170,1:5) /140.8492, 150.9757, 157.2266, 162.3437, 167.0325/
      DATA T(171,1:5) /141.7600, 151.9195, 158.1900, 163.3228, 168.0257/
      DATA T(172,1:5) /142.6711, 152.8634, 159.1535, 164.3019, 169.0189/
      DATA T(173,1:5) /143.5824, 153.8075, 160.1171, 165.2811, 170.0121/
      DATA T(174,1:5) /144.4940, 154.7518, 161.0808, 166.2604, 171.0054/
      DATA T(175,1:5) /145.4058, 155.6962, 162.0447, 167.2397, 171.9986/
      DATA T(176,1:5) /146.3179, 156.6408, 163.0086, 168.2191, 172.9919/
      DATA T(177,1:5) /147.2303, 157.5855, 163.9726, 169.1986, 173.9852/
      DATA T(178,1:5) /148.1429, 158.5304, 164.9367, 170.1781, 174.9785/
      DATA T(179,1:5) /149.0557, 159.4754, 165.9010, 171.1576, 175.9718/
      DATA T(180,1:5) /149.9688, 160.4206, 166.8653, 172.1373, 176.9652/
      DATA T(181,1:5) /150.8821, 161.3660, 167.8297, 173.1169, 177.9586/
      DATA T(182,1:5) /151.7956, 162.3115, 168.7942, 174.0967, 178.9519/
      DATA T(183,1:5) /152.7094, 163.2571, 169.7589, 175.0764, 179.9453/
      DATA T(184,1:5) /153.6235, 164.2029, 170.7236, 176.0563, 180.9388/
      DATA T(185,1:5) /154.5377, 165.1489, 171.6884, 177.0362, 181.9322/
      DATA T(186,1:5) /155.4522, 166.0950, 172.6533, 178.0161, 182.9257/
      DATA T(187,1:5) /156.3670, 167.0412, 173.6183, 178.9961, 183.9192/
      DATA T(188,1:5) /157.2819, 167.9876, 174.5834, 179.9762, 184.9126/
      DATA T(189,1:5) /158.1971, 168.9341, 175.5486, 180.9563, 185.9062/
      DATA T(190,1:5) /159.1125, 169.8808, 176.5139, 181.9365, 186.8997/
      DATA T(191,1:5) /160.0281, 170.8276, 177.4793, 182.9167, 187.8932/
      DATA T(192,1:5) /160.9440, 171.7746, 178.4447, 183.8970, 188.8868/
      DATA T(193,1:5) /161.8601, 172.7216, 179.4103, 184.8773, 189.8804/
      DATA T(194,1:5) /162.7763, 173.6689, 180.3759, 185.8577, 190.8740/
      DATA T(195,1:5) /163.6929, 174.6162, 181.3417, 186.8381, 191.8676/
      DATA T(196,1:5) /164.6096, 175.5637, 182.3075, 187.8186, 192.8612/
      DATA T(197,1:5) /165.5265, 176.5114, 183.2734, 188.7991, 193.8549/
      DATA T(198,1:5) /166.4436, 177.4591, 184.2394, 189.7797, 194.8485/
      DATA T(199,1:5) /167.3610, 178.4070, 185.2055, 190.7603, 195.8422/
      DATA T(200,1:5) /168.2786, 179.3550, 186.1717, 191.7409, 196.8359/

      DATA T(101,6:10)/102.1238, 105.8888, 110.1890, 115.7322, 125.4584/
      DATA T(102,6:10)/103.1326, 106.9160, 111.2365, 116.8051, 126.5741/
      DATA T(103,6:10)/104.1414, 107.9430, 112.2838, 117.8778, 127.6893/
      DATA T(104,6:10)/105.1502, 108.9698, 113.3308, 118.9500, 128.8039/
      DATA T(105,6:10)/106.1589, 109.9966, 114.3776, 120.0219, 129.9180/
      DATA T(106,6:10)/107.1676, 111.0232, 115.4242, 121.0935, 131.0315/
      DATA T(107,6:10)/108.1762, 112.0497, 116.4706, 122.1647, 132.1444/
      DATA T(108,6:10)/109.1848, 113.0761, 117.5167, 123.2356, 133.2569/
      DATA T(109,6:10)/110.1933, 114.1023, 118.5627, 124.3062, 134.3688/
      DATA T(110,6:10)/111.2019, 115.1284, 119.6084, 125.3765, 135.4802/
      DATA T(111,6:10)/112.2103, 116.1544, 120.6539, 126.4464, 136.5911/
      DATA T(112,6:10)/113.2188, 117.1803, 121.6992, 127.5160, 137.7015/
      DATA T(113,6:10)/114.2272, 118.2061, 122.7443, 128.5853, 138.8114/
      DATA T(114,6:10)/115.2355, 119.2317, 123.7892, 129.6543, 139.9208/
      DATA T(115,6:10)/116.2439, 120.2573, 124.8339, 130.7230, 141.0297/
      DATA T(116,6:10)/117.2521, 121.2827, 125.8784, 131.7913, 142.1382/
      DATA T(117,6:10)/118.2604, 122.3080, 126.9228, 132.8594, 143.2461/
      DATA T(118,6:10)/119.2686, 123.3332, 127.9669, 133.9272, 144.3537/
      DATA T(119,6:10)/120.2768, 124.3583, 129.0108, 134.9947, 145.4607/
      DATA T(120,6:10)/121.2850, 125.3833, 130.0546, 136.0620, 146.5674/
      DATA T(121,6:10)/122.2931, 126.4082, 131.0982, 137.1289, 147.6735/
      DATA T(122,6:10)/123.3012, 127.4330, 132.1416, 138.1956, 148.7793/
      DATA T(123,6:10)/124.3092, 128.4577, 133.1848, 139.2620, 149.8846/
      DATA T(124,6:10)/125.3172, 129.4823, 134.2278, 140.3281, 150.9894/
      DATA T(125,6:10)/126.3252, 130.5068, 135.2707, 141.3939, 152.0939/
      DATA T(126,6:10)/127.3332, 131.5312, 136.3134, 142.4595, 153.1979/
      DATA T(127,6:10)/128.3411, 132.5555, 137.3559, 143.5249, 154.3015/
      DATA T(128,6:10)/129.3490, 133.5797, 138.3983, 144.5899, 155.4047/
      DATA T(129,6:10)/130.3568, 134.6038, 139.4404, 145.6547, 156.5075/
      DATA T(130,6:10)/131.3646, 135.6278, 140.4825, 146.7193, 157.6099/
      DATA T(131,6:10)/132.3724, 136.6517, 141.5243, 147.7836, 158.7119/
      DATA T(132,6:10)/133.3802, 137.6755, 142.5660, 148.8477, 159.8135/
      DATA T(133,6:10)/134.3879, 138.6993, 143.6076, 149.9115, 160.9148/
      DATA T(134,6:10)/135.3957, 139.7229, 144.6490, 150.9751, 162.0156/
      DATA T(135,6:10)/136.4033, 140.7465, 145.6902, 152.0384, 163.1161/
      DATA T(136,6:10)/137.4110, 141.7699, 146.7313, 153.1016, 164.2162/
      DATA T(137,6:10)/138.4186, 142.7933, 147.7722, 154.1644, 165.3159/
      DATA T(138,6:10)/139.4262, 143.8166, 148.8130, 155.2271, 166.4153/
      DATA T(139,6:10)/140.4338, 144.8398, 149.8536, 156.2895, 167.5143/
      DATA T(140,6:10)/141.4413, 145.8629, 150.8941, 157.3517, 168.6130/
      DATA T(141,6:10)/142.4488, 146.8860, 151.9344, 158.4137, 169.7113/
      DATA T(142,6:10)/143.4563, 147.9090, 152.9746, 159.4754, 170.8092/
      DATA T(143,6:10)/144.4638, 148.9318, 154.0147, 160.5370, 171.9068/
      DATA T(144,6:10)/145.4712, 149.9546, 155.0546, 161.5983, 173.0041/
      DATA T(145,6:10)/146.4786, 150.9774, 156.0944, 162.6594, 174.1010/
      DATA T(146,6:10)/147.4860, 152.0000, 157.1340, 163.7203, 175.1976/
      DATA T(147,6:10)/148.4933, 153.0226, 158.1735, 164.7810, 176.2938/
      DATA T(148,6:10)/149.5007, 154.0451, 159.2129, 165.8414, 177.3897/
      DATA T(149,6:10)/150.5080, 155.0675, 160.2521, 166.9017, 178.4854/
      DATA T(150,6:10)/151.5153, 156.0898, 161.2912, 167.9618, 179.5806/
      DATA T(151,6:10)/152.5225, 157.1121, 162.3302, 169.0216, 180.6756/
      DATA T(152,6:10)/153.5298, 158.1343, 163.3690, 170.0813, 181.7702/
      DATA T(153,6:10)/154.5370, 159.1564, 164.4077, 171.1408, 182.8646/
      DATA T(154,6:10)/155.5442, 160.1784, 165.4463, 172.2001, 183.9586/
      DATA T(155,6:10)/156.5513, 161.2004, 166.4848, 173.2591, 185.0523/
      DATA T(156,6:10)/157.5585, 162.2223, 167.5231, 174.3180, 186.1458/
      DATA T(157,6:10)/158.5656, 163.2441, 168.5613, 175.3767, 187.2389/
      DATA T(158,6:10)/159.5727, 164.2659, 169.5994, 176.4353, 188.3317/
      DATA T(159,6:10)/160.5797, 165.2876, 170.6374, 177.4936, 189.4242/
      DATA T(160,6:10)/161.5868, 166.3092, 171.6752, 178.5517, 190.5165/
      DATA T(161,6:10)/162.5938, 167.3307, 172.7129, 179.6097, 191.6084/
      DATA T(162,6:10)/163.6008, 168.3522, 173.7505, 180.6675, 192.7001/
      DATA T(163,6:10)/164.6078, 169.3737, 174.7880, 181.7251, 193.7914/
      DATA T(164,6:10)/165.6148, 170.3950, 175.8254, 182.7825, 194.8825/
      DATA T(165,6:10)/166.6217, 171.4163, 176.8627, 183.8398, 195.9734/
      DATA T(166,6:10)/167.6286, 172.4375, 177.8998, 184.8969, 197.0639/
      DATA T(167,6:10)/168.6355, 173.4587, 178.9369, 185.9538, 198.1542/
      DATA T(168,6:10)/169.6424, 174.4798, 179.9738, 187.0105, 199.2442/
      DATA T(169,6:10)/170.6493, 175.5008, 181.0106, 188.0671, 200.3339/
      DATA T(170,6:10)/171.6561, 176.5218, 182.0473, 189.1235, 201.4234/
      DATA T(171,6:10)/172.6629, 177.5427, 183.0839, 190.1797, 202.5126/
      DATA T(172,6:10)/173.6697, 178.5635, 184.1204, 191.2358, 203.6015/
      DATA T(173,6:10)/174.6765, 179.5843, 185.1568, 192.2917, 204.6902/
      DATA T(174,6:10)/175.6833, 180.6051, 186.1931, 193.3474, 205.7786/
      DATA T(175,6:10)/176.6900, 181.6257, 187.2293, 194.4030, 206.8668/
      DATA T(176,6:10)/177.6967, 182.6463, 188.2654, 195.4584, 207.9547/
      DATA T(177,6:10)/178.7034, 183.6669, 189.3013, 196.5137, 209.0424/
      DATA T(178,6:10)/179.7101, 184.6874, 190.3372, 197.5688, 210.1298/
      DATA T(179,6:10)/180.7168, 185.7078, 191.3730, 198.6238, 211.2170/
      DATA T(180,6:10)/181.7234, 186.7282, 192.4086, 199.6786, 212.3039/
      DATA T(181,6:10)/182.7300, 187.7485, 193.4442, 200.7332, 213.3906/
      DATA T(182,6:10)/183.7366, 188.7688, 194.4797, 201.7877, 214.4771/
      DATA T(183,6:10)/184.7432, 189.7890, 195.5151, 202.8421, 215.5633/
      DATA T(184,6:10)/185.7498, 190.8091, 196.5503, 203.8963, 216.6492/
      DATA T(185,6:10)/186.7564, 191.8292, 197.5855, 204.9503, 217.7350/
      DATA T(186,6:10)/187.7629, 192.8493, 198.6206, 206.0042, 218.8205/
      DATA T(187,6:10)/188.7694, 193.8693, 199.6556, 207.0580, 219.9058/
      DATA T(188,6:10)/189.7759, 194.8892, 200.6905, 208.1116, 220.9908/
      DATA T(189,6:10)/190.7824, 195.9091, 201.7253, 209.1651, 222.0756/
      DATA T(190,6:10)/191.7889, 196.9289, 202.7600, 210.2184, 223.1602/
      DATA T(191,6:10)/192.7953, 197.9487, 203.7946, 211.2716, 224.2446/
      DATA T(192,6:10)/193.8017, 198.9684, 204.8291, 212.3246, 225.3288/
      DATA T(193,6:10)/194.8082, 199.9881, 205.8636, 213.3775, 226.4127/
      DATA T(194,6:10)/195.8146, 201.0077, 206.8979, 214.4303, 227.4964/
      DATA T(195,6:10)/196.8209, 202.0273, 207.9322, 215.4829, 228.5799/
      DATA T(196,6:10)/197.8273, 203.0468, 208.9664, 216.5354, 229.6632/
      DATA T(197,6:10)/198.8337, 204.0663, 210.0004, 217.5878, 230.7463/
      DATA T(198,6:10)/199.8400, 205.0857, 211.0344, 218.6401, 231.8292/
      DATA T(199,6:10)/200.8463, 206.1051, 212.0684, 219.6922, 232.9118/
      DATA T(200,6:10)/201.8526,207.1244, 213.1022, 220.7441, 233.9943/

      IF (V.GT.200) THEN
       WRITE(*,*) 'CHI2INV: Too many degrees of freedom'
       PAUSE
       RETURN
      ENDIF

      CHI2INV = T(V,P)

      RETURN
      END
