
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2016 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://home.gna.org/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Marxbot wheel

#include <QtOpenGL>

namespace Enki
{
	static short face_indicies[492][9] = {
{195,315,7,199,321,7,197,318,7},      {91,117,7,177,276,7,179,278,7},
{1,1,1,2,2,1,3,3,1},                  {4,4,2,2,5,3,1,6,4},                  {5,7,5,6,8,6,4,4,2},                  {7,9,7,8,10,7,9,11,7},                {10,12,8,1,6,4,11,13,9},
{12,14,1,13,15,1,14,16,1},            {4,4,2,1,6,4,10,12,8},                {2,2,1,6,17,1,3,3,1},                 {10,12,8,11,13,9,15,18,10},           {13,15,1,16,19,1,14,16,1},
{17,20,1,18,21,1,19,22,1},            {20,23,11,15,18,10,21,24,12},         {22,25,1,15,26,1,11,27,1},            {23,28,1,24,29,1,25,30,1},            {10,12,8,15,18,10,20,23,11},
{26,31,1,21,32,1,27,33,1},            {20,23,11,21,24,12,28,34,13},         {16,19,1,29,35,1,30,36,1},            {31,37,1,26,31,1,32,38,1},            {28,39,13,26,31,14,31,37,15},
{7,9,7,33,40,7,34,41,7},              {32,38,1,35,42,1,31,37,1},            {36,43,16,31,44,15,35,45,17},         {28,46,13,31,44,15,36,43,16},         {32,38,1,39,47,1,35,42,1},
{36,43,16,35,45,17,39,48,18},         {40,49,1,41,50,1,39,47,1},            {42,51,19,39,48,18,41,52,20},         {32,38,1,40,49,1,39,47,1},            {36,43,16,39,48,18,42,51,19},
{40,49,1,43,53,1,41,50,1},            {42,51,19,41,52,20,44,54,21},         {45,55,1,46,56,1,43,53,1},            {44,54,21,43,57,22,46,58,23},         {40,49,1,45,55,1,43,53,1},
{47,59,24,48,60,25,49,61,26},         {50,62,1,51,63,1,45,55,1},            {52,64,27,46,58,23,51,65,28},         {44,54,21,46,58,23,52,64,27},         {50,62,1,53,66,1,51,63,1},
{52,64,27,51,65,28,53,67,29},         {54,68,1,55,69,1,50,62,1},            {56,70,30,53,67,29,55,71,31},         {52,64,27,53,67,29,56,70,30},         {54,68,1,59,72,1,55,69,1},
{56,70,30,55,71,31,60,73,32},         {60,73,32,59,74,33,61,75,34},         {62,76,1,63,77,1,64,78,1},            {65,79,35,63,80,36,66,81,37},         {67,82,1,68,83,1,54,68,1},
{69,84,38,61,75,34,68,85,39},         {60,73,32,61,75,34,69,84,38},         {70,86,1,67,82,1,71,87,1},            {69,88,38,68,89,39,70,90,40},         {72,91,1,73,92,1,74,93,1},
{29,35,1,19,22,1,75,94,1},            {76,95,41,70,90,40,71,96,42},         {71,87,1,13,15,1,12,14,1},            {74,93,1,24,29,1,23,28,1},            {69,88,38,70,90,40,76,95,41},
{76,95,41,71,96,42,77,97,43},         {78,98,1,14,16,1,16,19,1},            {77,97,43,12,99,44,14,100,45},        {22,25,1,11,27,1,1,1,1},              {80,101,46,81,102,47,82,103,48},
{30,36,1,78,98,1,16,19,1},            {77,97,43,14,100,45,83,104,49},       {83,104,49,78,105,50,30,106,51},      {6,8,6,2,5,3,4,4,2},                  {84,107,52,30,106,51,75,108,53},
{84,107,52,83,104,49,30,106,51},      {84,107,52,75,108,53,19,109,54},      {85,110,7,86,111,7,87,112,7},         {88,113,55,19,109,54,18,114,56},      {84,107,52,19,109,54,88,113,55},
{89,115,1,18,21,1,17,20,1},           {88,113,55,18,114,56,90,116,57},      {91,117,7,92,118,7,93,119,7},         {94,120,1,89,115,1,95,121,1},         {90,122,57,89,123,58,94,124,59},
{22,25,1,27,33,1,15,26,1},            {21,24,12,26,125,14,28,34,13},        {95,121,1,96,126,1,94,120,1},         {97,127,60,94,124,59,96,128,61},      {26,31,1,27,33,1,32,38,1},
{90,122,57,94,124,59,97,127,60},      {95,121,1,98,129,1,96,126,1},         {97,127,60,96,128,61,98,130,62},      {99,131,1,100,132,1,98,129,1},        {101,133,63,98,130,62,100,134,64},
{95,121,1,99,131,1,98,129,1},         {97,127,60,98,130,62,101,133,63},     {99,131,1,102,135,1,100,132,1},       {101,133,63,100,134,64,103,136,65},   {104,137,1,105,138,1,102,135,1},
{103,136,65,102,139,66,105,140,67},   {99,131,1,104,137,1,102,135,1},       {41,52,20,43,57,22,44,54,21},         {106,141,1,107,142,1,104,137,1},      {108,143,68,105,140,67,107,144,69},
{51,63,1,46,56,1,45,55,1},            {103,136,65,105,140,67,108,143,68},   {106,141,1,109,145,1,107,142,1},      {108,143,68,107,144,69,109,146,70},   {64,78,1,65,147,1,106,141,1},
{110,148,71,109,146,70,65,79,35},     {55,69,1,53,66,1,50,62,1},            {108,143,68,109,146,70,110,148,71},   {64,78,1,63,77,1,65,147,1},           {110,148,71,65,79,35,66,81,37},
{68,83,1,61,149,1,54,68,1},           {66,81,37,63,80,36,62,150,72},        {111,151,73,112,152,74,113,153,75},   {74,93,1,73,92,1,64,78,1},            {114,154,76,62,150,72,73,155,77},
{66,81,37,62,150,72,114,154,76},      {72,91,1,74,93,1,23,28,1},            {114,156,76,73,157,77,72,158,78},     {115,159,7,116,160,7,117,161,7},      {118,162,79,72,158,78,23,163,80},
{114,156,76,72,158,78,118,162,79},    {118,162,79,23,163,80,5,7,5},         {25,164,81,6,8,6,5,7,5},              {71,96,42,12,99,44,77,97,43},         {119,165,82,3,166,82,120,167,83},
{121,168,84,22,169,84,119,165,82},    {122,170,85,123,171,86,52,64,27},     {124,172,87,24,173,88,74,174,89},     {120,167,83,24,173,88,124,172,87},    {125,175,90,74,176,89,64,177,91},
{124,178,87,74,176,89,125,175,90},    {126,179,92,64,177,91,106,180,93},    {125,175,90,64,177,91,126,179,92},    {127,181,94,106,180,93,104,182,95},   {126,179,92,106,180,93,127,181,94},
{128,183,96,104,182,95,99,184,97},    {127,181,94,104,182,95,128,183,96},   {129,185,98,99,184,97,95,186,98},     {128,183,96,99,184,97,129,185,98},    {130,187,99,95,188,98,17,189,99},
{129,190,98,95,188,98,130,187,99},    {130,187,99,17,189,99,57,191,100},    {57,191,100,29,192,100,58,193,101},   {27,194,102,22,169,84,121,168,84},    {58,193,101,16,195,101,79,196,103},
{37,197,104,13,198,105,67,199,106},   {3,166,82,24,173,88,120,167,83},      {79,196,103,13,198,105,37,197,104},   {38,200,107,67,199,106,54,201,108},   {37,197,104,67,199,106,38,200,107},
{131,202,109,54,203,108,50,204,110},  {38,205,107,54,203,108,131,202,109},  {132,206,111,50,204,110,45,207,112},  {131,202,109,50,204,110,132,206,111}, {133,208,113,45,207,112,40,209,114},
{132,206,111,45,207,112,133,208,113}, {134,210,115,40,209,114,32,211,115},  {133,208,113,40,209,114,134,210,115}, {135,212,102,32,213,115,27,194,102},  {134,214,115,32,213,115,135,212,102},
{135,212,102,27,194,102,121,168,84},  {136,215,7,137,216,7,138,217,7},      {139,218,116,137,219,117,136,220,118},{140,221,119,141,222,120,139,218,116},{142,223,121,143,224,122,144,225,123},
{24,29,1,3,3,1,6,17,1},               {145,226,124,136,220,118,146,227,125},{145,226,124,139,218,116,136,220,118},{147,228,7,148,229,7,142,230,7},      {145,226,124,146,227,125,87,231,126},
{137,216,7,141,232,7,138,217,7},      {33,40,7,149,233,7,34,41,7},          {150,234,127,87,231,126,86,235,128},  {151,236,7,87,112,7,146,237,7},       {152,238,7,92,118,7,141,232,7},
{150,234,127,145,226,124,87,231,126}, {153,239,7,86,111,7,85,110,7},        {150,234,127,86,235,128,154,240,129}, {3,3,1,22,25,1,1,1,1},                {155,241,7,153,239,7,156,242,7},
{154,243,129,153,244,130,155,245,131},{70,86,1,68,83,1,67,82,1},            {149,246,132,157,247,133,158,248,134},{156,242,7,159,249,7,155,241,7},      {160,250,135,155,245,131,159,251,136},
{73,92,1,62,76,1,64,78,1},            {160,250,135,154,243,129,155,245,131},{156,242,7,161,252,7,159,249,7},      {160,250,135,159,251,136,161,253,137},{162,254,7,163,255,7,161,252,7},
{164,256,138,161,253,137,163,257,139},{156,242,7,162,254,7,161,252,7},      {164,256,138,160,250,135,161,253,137},{162,254,7,165,258,7,163,255,7},      {164,256,138,163,257,139,166,259,140},
{167,260,7,168,261,7,165,258,7},      {166,259,140,165,262,141,168,263,142},{162,254,7,167,260,7,165,258,7},      {169,264,7,147,228,7,80,265,7},       {167,260,7,170,266,7,168,261,7},
{171,267,143,166,259,140,168,263,142},{172,269,7,173,270,7,170,266,7},      {171,267,143,170,268,144,173,271,145},{167,260,7,172,269,7,170,266,7},      {117,161,7,174,272,7,172,269,7},
{175,273,146,173,271,145,174,274,147},{65,147,1,109,145,1,106,141,1},       {175,273,146,171,267,143,173,271,145},{117,161,7,116,160,7,174,272,7},      {171,267,143,168,263,142,170,268,144},
{175,273,146,174,274,147,176,275,148},{177,276,7,178,277,7,179,278,7},      {176,275,148,116,279,149,115,280,150},{178,277,7,112,281,7,179,278,7},      {169,264,7,182,282,7,117,161,7},
{183,283,151,115,159,150,182,282,152},{183,284,151,176,275,148,115,280,150},{184,285,7,169,264,7,80,265,7},       {183,286,151,182,287,152,184,288,153},{29,35,1,17,20,1,19,22,1},
{80,265,7,147,228,7,81,289,7},        {185,290,154,184,288,153,80,101,46},  {27,33,1,21,32,1,15,26,1},            {185,290,154,183,286,151,184,288,153},{7,9,7,34,41,7,8,10,7},
{185,290,154,80,101,46,82,103,48},    {81,289,7,147,228,7,142,230,7},       {143,291,7,142,230,7,148,229,7},      {82,103,48,81,102,47,142,223,121},    {29,35,1,75,94,1,30,36,1},
{93,292,155,152,293,156,140,221,119}, {9,11,7,143,291,7,148,229,7},         {82,103,48,142,223,121,144,225,123},  {151,236,7,146,237,7,136,215,7},      {144,225,123,143,224,122,9,294,157},
{14,100,45,78,105,50,83,104,49},      {186,295,158,9,294,157,8,296,159},    {186,295,158,144,225,123,9,294,157},  {186,295,158,8,296,159,34,297,160},   {67,82,1,13,15,1,71,87,1},
{187,298,161,34,297,160,149,246,132}, {187,298,161,186,295,158,34,297,160}, {157,299,7,149,233,7,33,40,7},        {187,298,161,149,246,132,158,248,134},{138,217,7,151,236,7,136,215,7},
{188,300,7,157,299,7,189,301,7},      {158,248,134,157,247,133,188,302,162},{151,236,7,85,110,7,87,112,7},        {18,114,56,89,303,58,90,116,57},      {189,301,7,190,304,7,188,300,7},
{191,305,163,188,302,162,190,306,164},{153,239,7,85,110,7,156,242,7},       {191,305,163,158,248,134,188,302,162},{189,301,7,192,307,7,190,304,7},      {191,308,163,190,309,164,192,310,165},
{193,311,7,47,312,7,192,307,7},       {194,313,166,192,310,165,47,59,24},   {189,301,7,193,311,7,192,307,7},      {194,313,166,191,308,163,192,310,165},{193,311,7,48,314,7,47,312,7},
{194,313,166,47,59,24,49,61,26},      {195,315,7,196,316,7,48,314,7},       {49,61,26,48,60,25,196,317,167},      {193,311,7,195,315,7,48,314,7},       {163,257,139,165,262,141,166,259,140},
{195,315,7,197,318,7,196,316,7},      {198,319,168,196,317,167,197,320,169},{198,319,168,49,61,26,196,317,167},   {199,321,7,200,322,7,197,318,7},      {198,319,168,197,320,169,200,323,170},
{179,278,7,111,324,7,199,321,7},      {201,325,171,200,323,170,111,151,73}, {174,272,7,173,270,7,172,269,7},      {201,325,171,198,319,168,200,323,170},{179,278,7,112,281,7,111,324,7},
{201,325,171,111,151,73,113,153,75},  {89,115,1,17,20,1,95,121,1},          {113,326,75,112,327,74,178,328,172},  {61,149,1,59,72,1,54,68,1},           {174,274,147,116,279,149,176,275,148},
{202,329,173,178,328,172,177,330,174},{202,329,173,113,326,75,178,328,172}, {203,331,7,91,117,7,93,119,7},        {202,329,173,177,330,174,203,332,175},{184,285,7,182,282,7,169,264,7},
{93,119,7,92,118,7,152,238,7},        {204,333,176,203,332,175,93,292,155}, {204,333,176,202,329,173,203,332,175},{204,333,176,93,292,155,140,221,119}, {140,221,119,152,293,156,141,222,120},
{205,334,82,148,335,82,206,336,177},  {207,337,178,7,338,179,148,335,82},   {205,334,82,207,337,178,148,335,82},  {206,336,177,147,339,177,169,340,180},{138,341,101,92,342,181,181,343,181},
{208,344,180,169,340,180,117,345,182},{208,344,180,206,336,177,169,340,180},{209,346,115,117,347,182,172,348,114},{209,349,115,208,344,180,117,345,182},{210,350,113,172,348,114,167,351,112},
{210,350,113,209,346,115,172,348,114},{211,352,111,167,351,112,162,353,110},{211,352,111,210,350,113,167,351,112},{212,354,109,162,353,110,156,355,108},{212,354,109,211,352,111,162,353,110},
{213,356,183,156,357,108,85,358,184}, {213,359,183,212,354,109,156,355,108},{214,360,185,85,358,184,151,361,186}, {214,360,185,213,356,183,85,358,184}, {215,362,187,151,361,186,138,341,101},
{215,362,187,214,360,185,151,361,186},{180,363,101,138,341,101,181,343,181},{215,362,187,138,341,101,180,363,101},{181,343,181,92,342,181,91,364,188},  {216,365,188,91,364,188,179,366,189},
{216,365,188,181,343,181,91,364,188}, {217,367,98,179,368,189,199,369,97},  {217,370,98,216,365,188,179,366,189}, {218,371,96,199,369,97,195,372,95},   {218,371,96,217,367,98,199,369,97},
{219,373,94,195,372,95,193,374,93},   {219,373,94,218,371,96,195,372,95},   {220,375,92,193,374,93,189,376,91},   {220,375,92,219,373,94,193,374,93},   {221,377,190,189,376,91,33,378,191},
{221,377,190,220,375,92,189,376,91},  {222,379,192,33,380,191,7,338,179},   {222,381,192,221,377,190,33,378,191}, {207,337,178,222,379,192,7,338,179},  {107,142,1,105,138,1,104,137,1},
{203,331,7,177,276,7,91,117,7},       {86,235,128,153,382,130,154,240,129}, {100,134,64,102,139,66,103,136,65},   {148,335,82,147,339,177,206,336,177}, {23,163,80,25,164,81,5,7,5},
{182,282,7,115,159,7,117,161,7},      {186,295,158,187,298,161,223,383,193},{29,192,100,16,195,101,58,193,101},   {148,229,7,7,9,7,9,11,7},             {157,299,7,33,40,7,189,301,7},
{111,324,7,200,322,7,199,321,7},      {55,71,31,59,74,33,60,73,32},         {16,195,101,13,198,105,79,196,103},   {17,189,99,29,192,100,57,191,100},    {92,118,7,138,217,7,141,232,7},
{25,30,1,24,29,1,6,17,1},             {141,222,120,137,219,117,139,218,116},{224,384,194,139,218,116,145,226,124},{225,385,195,139,218,116,224,384,194},{225,385,195,140,221,119,139,218,116},
{226,386,196,145,226,124,150,234,127},{226,386,196,224,384,194,145,226,124},{227,387,197,150,234,127,154,240,129},{227,387,197,226,386,196,150,234,127},{228,388,198,154,243,129,160,250,135},
{228,389,198,227,387,197,154,240,129},{229,390,199,160,250,135,164,256,138},{229,390,199,228,388,198,160,250,135},{122,170,85,164,256,138,123,171,86},  {122,170,85,229,390,199,164,256,138},
{123,171,86,166,259,140,171,267,143}, {223,383,193,230,391,200,114,156,76}, {231,392,201,171,267,143,175,273,146},{231,392,201,123,171,86,171,267,143}, {232,393,202,175,273,146,176,275,148},
{232,393,202,231,392,201,175,273,146},{233,394,203,176,275,148,183,284,151},{233,394,203,232,393,202,176,275,148},{234,395,204,183,286,151,185,290,154},{234,396,204,233,394,203,183,284,151},
{235,397,205,185,290,154,82,103,48},  {235,397,205,234,395,204,185,290,154},{236,398,206,82,103,48,144,225,123},  {236,398,206,235,397,205,82,103,48},  {237,399,207,236,398,206,144,225,123},
{186,295,158,237,399,207,144,225,123},{83,104,49,224,384,194,226,386,196},  {84,107,52,224,384,194,83,104,49},    {84,107,52,225,385,195,224,384,194},  {77,97,43,226,386,196,227,387,197},
{77,97,43,83,104,49,226,386,196},     {76,95,41,227,387,197,228,389,198},   {76,95,41,77,97,43,227,387,197},      {69,84,38,228,388,198,60,73,32},      {69,88,38,76,95,41,228,389,198},
{60,73,32,229,390,199,56,70,30},      {164,256,138,166,259,140,123,171,86}, {56,70,30,122,170,85,52,64,27},       {202,329,173,204,333,176,238,400,208},{52,64,27,123,171,86,231,392,201},
{234,395,204,235,397,205,20,23,11},   {44,54,21,231,392,201,232,393,202},   {44,54,21,52,64,27,231,392,201},      {42,51,19,232,393,202,36,43,16},      {42,51,19,44,54,21,232,393,202},
{36,43,16,233,394,203,234,396,204},   {229,390,199,122,170,85,56,70,30},    {28,34,13,234,395,204,20,23,11},      {28,46,13,36,43,16,234,396,204},      {20,23,11,235,397,205,236,398,206},
{239,401,209,223,383,193,118,162,79}, {10,12,8,236,398,206,237,399,207},    {10,12,8,20,23,11,236,398,206},       {4,4,2,10,12,8,237,399,207},          {239,401,209,4,4,2,237,399,207},
{239,401,209,237,399,207,186,295,158},{5,7,5,4,4,2,239,401,209},            {239,401,209,186,295,158,223,383,193},{223,383,193,187,298,161,158,248,134},{194,313,166,49,61,26,240,402,210},
{230,391,200,158,248,134,241,403,211},{230,391,200,223,383,193,158,248,134},{241,404,211,191,308,163,194,313,166},{22,169,84,3,166,82,119,165,82},      {242,405,212,194,313,166,240,402,210},
{242,405,212,241,404,211,194,313,166},{240,402,210,49,61,26,198,319,168},   {242,405,212,240,402,210,108,143,68}, {243,406,213,198,319,168,201,325,171},{243,406,213,240,402,210,198,319,168},
{244,407,214,201,325,171,113,153,75}, {244,407,214,243,406,213,201,325,171},{245,408,215,113,326,75,202,329,173}, {245,409,215,244,407,214,113,153,75}, {246,410,216,202,329,173,238,400,208},
{246,410,216,245,408,215,202,329,173},{238,400,208,204,333,176,140,221,119},{230,411,200,241,404,211,66,81,37},   {225,385,195,238,400,208,140,221,119},{5,7,5,239,401,209,118,162,79},
{118,162,79,223,383,193,114,156,76},  {232,393,202,233,394,203,36,43,16},   {114,154,76,230,411,200,66,81,37},    {158,248,134,191,305,163,241,403,211},{66,81,37,241,404,211,242,405,212},
{110,148,71,242,405,212,108,143,68},  {110,148,71,66,81,37,242,405,212},    {108,143,68,240,402,210,243,406,213}, {228,388,198,229,390,199,60,73,32},   {103,136,65,243,406,213,244,407,214},
{103,136,65,108,143,68,243,406,213},  {101,133,63,244,407,214,245,409,215}, {101,133,63,103,136,65,244,407,214},  {97,127,60,245,409,215,246,412,216},  {97,127,60,101,133,63,245,409,215},
{90,116,57,246,410,216,238,400,208},  {90,122,57,97,127,60,246,412,216},    {88,113,55,238,400,208,225,385,195},  {88,113,55,90,116,57,238,400,208},    {84,107,52,88,113,55,225,385,195},
{129,413,1,247,414,1,128,415,1},      {218,416,7,248,417,7,217,418,7},      {219,419,7,248,417,7,218,416,7},      {220,420,7,248,417,7,219,419,7},      {221,421,7,248,417,7,220,420,7},
{222,422,7,248,417,7,221,421,7},      {222,422,7,207,423,7,248,417,7},      {217,418,7,248,417,7,216,424,7},      {216,424,7,248,417,7,181,425,7},      {181,425,7,248,417,7,180,426,7},
{215,427,7,180,426,7,248,417,7},      {215,427,7,248,417,7,214,428,7},      {214,428,7,248,417,7,213,429,7},      {213,429,7,248,417,7,212,430,7},      {212,430,7,248,417,7,211,431,7},
{211,431,7,248,417,7,210,432,7},      {210,432,7,248,417,7,209,433,7},      {209,433,7,248,417,7,208,434,7},      {207,423,7,205,435,7,248,417,7},      {206,436,7,248,417,7,205,435,7},
{208,434,7,248,417,7,206,436,7},      {128,415,1,247,414,1,127,437,1},      {127,437,1,247,414,1,126,438,1},      {126,438,1,247,414,1,125,439,1},      {125,439,1,247,414,1,124,440,1},
{124,440,1,247,414,1,120,441,1},      {120,441,1,247,414,1,119,442,1},      {121,443,1,119,442,1,247,414,1},      {135,444,1,121,443,1,247,414,1},      {135,444,1,247,414,1,134,445,1},
{134,445,1,247,414,1,133,446,1},      {133,446,1,247,414,1,132,447,1},      {132,447,1,247,414,1,131,448,1},      {131,448,1,247,414,1,38,449,1},       {38,449,1,247,414,1,37,450,1},
{79,451,1,37,450,1,247,414,1},        {79,451,1,247,414,1,58,452,1},        {58,452,1,247,414,1,57,453,1},        {130,454,1,247,414,1,129,413,1},      {130,454,1,57,453,1,247,414,1}
	};
	static GLfloat vertices [248][3] = {
{-0.269891,0.000000,-1.880731}, {0.000000,0.000000,-1.900000},  {0.000000,0.000000,-1.650000},
{0.000000,0.346113,-2.122218},  {0.507880,0.346113,-2.060550},  {0.269838,0.000000,-1.880739},  {0.509030,1.500000,-1.569512},  {0.534843,1.500000,-1.823168},
{0.269838,1.500000,-1.880739},  {-0.507880,0.346113,-2.060550}, {-0.534898,0.000000,-1.823152}, {-0.534843,0.000000,1.823168},  {-0.509131,0.000000,1.569480},
{-0.269838,0.000000,1.880739},  {-0.788949,0.000000,-1.728456}, {-0.000000,0.000000,1.650000},  {0.969301,0.000000,1.335255},   {1.026948,0.000000,1.598554},
{0.788949,0.000000,1.728456},   {-0.986244,0.346113,-1.879131}, {-1.026948,0.000000,-1.598554}, {-0.509028,0.000000,-1.569513}, {0.788897,0.000000,-1.728480},
{0.509131,0.000000,-1.569480},  {0.534843,0.000000,-1.823168},  {-1.244031,0.000000,-1.436101}, {-0.969301,0.000000,-1.335255}, {-1.407291,0.346113,-1.588503},
{0.509028,0.000000,1.569513},   {0.269891,0.000000,1.880731},   {-1.435780,0.000000,-1.244402}, {-1.334634,0.000000,-0.970154}, {0.969322,1.500000,-1.335239},
{0.788897,1.500000,-1.728480},  {-1.598289,0.000000,-1.027361}, {-1.746552,0.346113,-1.205557}, {-0.969228,0.250000,1.335308},  {-1.334599,0.250000,0.970204},
{-1.728250,0.000000,-0.789398}, {-1.569185,0.000000,-0.510032}, {-1.823017,0.000000,-0.535360}, {-1.984309,0.346113,-0.752549}, {-1.880658,0.000000,-0.270419},
{-2.106745,0.346113,-0.255805}, {-1.649999,0.000000,-0.000051}, {-1.899999,0.000000,0.000029},  {1.823000,1.500000,-0.535415},  {1.880649,1.500000,-0.270476},
{2.106440,1.154656,-0.255768},  {-1.569216,0.000000,0.509935},  {-1.880649,0.000000,0.270476},  {-2.106745,0.346113,0.255805},  {-1.823000,0.000000,0.535415},
{-1.334694,0.000000,0.970072},  {-1.728226,0.000000,0.789451},  {-1.984309,0.346113,0.752549},  {0.509030,0.250000,1.569512},   {-0.000000,0.250000,1.650000},
{-1.598258,0.000000,1.027409},  {-1.746552,0.346113,1.205557},  {-1.435742,0.000000,1.244445},  {1.435742,0.000000,-1.244445},  {1.598258,0.000000,-1.027409},
{1.334694,0.000000,-0.970072},  {1.728226,0.000000,-0.789451},  {1.746552,0.346113,-1.205557},  {-0.969383,0.000000,1.335195},  {-1.243987,0.000000,1.436138},
{-1.407291,0.346113,1.588503},  {-1.026900,0.000000,1.598585},  {-0.788897,0.000000,1.728480},  {1.026900,0.000000,-1.598585},  {1.243987,0.000000,-1.436138},
{0.969383,0.000000,-1.335195},  {0.534898,0.000000,1.823152},   {-0.986244,0.346113,1.879131},  {-0.507880,0.346113,2.060550},  {-0.000000,0.000000,1.900000},
{-0.508912,0.250000,1.569550},  {-0.788949,1.500000,-1.728456}, {-0.534898,1.500000,-1.823152}, {-0.507806,1.154656,-2.060252}, {-0.000000,0.346113,2.122218},
{0.507880,0.346113,2.060550},   {-0.969322,1.500000,1.335239},  {-1.026900,1.500000,1.598585},  {-0.788897,1.500000,1.728480},  {0.986244,0.346113,1.879131},
{1.244031,0.000000,1.436101},   {1.407291,0.346113,1.588503},   {0.969228,1.500000,1.335308},   {0.508912,1.500000,1.569550},   {0.788949,1.500000,1.728456},
{1.435780,0.000000,1.244402},   {1.334634,0.000000,0.970154},   {1.598289,0.000000,1.027361},   {1.746552,0.346113,1.205557},   {1.728250,0.000000,0.789398},
{1.569185,0.000000,0.510032},   {1.823017,0.000000,0.535360},   {1.984309,0.346113,0.752549},   {1.880658,0.000000,0.270419},   {2.106745,0.346113,0.255805},
{1.649999,0.000000,0.000051},   {1.899999,0.000000,-0.000029},  {1.569216,0.000000,-0.509935},  {1.880649,0.000000,-0.270476},  {2.106745,0.346113,-0.255805},
{1.823000,0.000000,-0.535415},  {1.984309,0.346113,-0.752549},  {1.728250,1.500000,0.789398},   {1.598289,1.500000,1.027361},   {1.746298,1.154656,1.205383},
{1.407291,0.346113,-1.588503},  {-1.435780,1.500000,-1.244402}, {-1.598289,1.500000,-1.027361}, {-1.334599,1.500000,-0.970204}, {0.986244,0.346113,-1.879131},
{0.000000,0.250000,-1.650000},  {0.508912,0.250000,-1.569550},  {-0.509030,0.250000,-1.569512}, {-2.057036,0.750414,0.780131},  {-2.183959,0.750414,0.265181},
{0.969228,0.250000,-1.335308},  {1.334599,0.250000,-0.970204},  {1.569176,0.250000,-0.510065},  {1.650000,0.250000,-0.000058},  {1.569212,0.250000,0.509954},
{1.334667,0.250000,0.970110},   {0.969323,0.250000,1.335239},   {-1.569176,0.250000,0.510065},  {-1.650000,0.250000,0.000058},  {-1.569212,0.250000,-0.509954},
{-1.334667,0.250000,-0.970110}, {-0.969323,0.250000,-1.335239}, {-0.269838,1.500000,1.880739},  {-0.000000,1.500000,1.900000},  {-0.000000,1.500000,1.650000},
{-0.000000,1.154656,2.121911},  {0.507806,1.154656,2.060252},   {0.269891,1.500000,1.880731},   {-0.269891,1.500000,-1.880731}, {0.000000,1.500000,-1.900000},
{0.000000,1.154656,-2.121911},  {-0.507806,1.154656,2.060252},  {-0.534843,1.500000,1.823168},  {-0.508912,1.500000,-1.569550}, {0.000000,1.500000,-1.650000},
{1.026900,1.500000,-1.598585},  {-0.986101,1.154656,1.878859},  {-0.509030,1.500000,1.569512},  {0.534898,1.500000,1.823152},   {-1.243987,1.500000,1.436138},
{-1.407087,1.154656,1.588273},  {-1.435742,1.500000,1.244445},  {-1.334667,1.500000,0.970110},  {1.243987,1.500000,-1.436138},  {1.407087,1.154656,-1.588273},
{-1.598258,1.500000,1.027409},  {-1.746298,1.154656,1.205383},  {-1.728226,1.500000,0.789451},  {-1.569212,1.500000,0.509954},  {-1.823000,1.500000,0.535415},
{-1.984021,1.154656,0.752440},  {-1.880649,1.500000,0.270476},  {-2.106440,1.154656,0.255768},  {-1.650000,1.500000,-0.000058}, {-1.899999,1.500000,0.000029},
{-0.969228,1.500000,-1.335308}, {-1.880658,1.500000,-0.270419}, {-2.106440,1.154656,-0.255768}, {-1.569176,1.500000,-0.510065}, {-1.823017,1.500000,-0.535360},
{-1.728250,1.500000,-0.789398}, {-1.984021,1.154656,-0.752440}, {-1.746298,1.154656,-1.205383}, {1.244031,1.500000,1.436101},   {1.435780,1.500000,1.244402},
{1.334599,1.500000,0.970204},   {-0.000000,1.250000,1.650000},  {0.508906,1.250000,1.569550},   {-1.244031,1.500000,-1.436101}, {-1.407087,1.154656,-1.588273},
{-1.026948,1.500000,-1.598554}, {-0.986101,1.154656,-1.878859}, {0.507806,1.154656,-2.060252},  {0.986101,1.154656,-1.878859},  {1.435742,1.500000,-1.244445},
{1.334667,1.500000,-0.970110},  {1.598258,1.500000,-1.027409},  {1.746298,1.154656,-1.205383},  {1.728226,1.500000,-0.789451},  {1.569212,1.500000,-0.509954},
{1.984021,1.154656,-0.752440},  {1.650000,1.500000,0.000058},   {1.899999,1.500000,-0.000029},  {1.880658,1.500000,0.270419},   {2.106440,1.154656,0.255768},
{1.569176,1.500000,0.510065},   {1.823017,1.500000,0.535360},   {1.984021,1.154656,0.752440},   {1.407087,1.154656,1.588273},   {1.026948,1.500000,1.598554},
{0.986101,1.154656,1.878859},   {0.000000,1.250000,-1.650000},  {-0.508906,1.250000,-1.569550}, {0.508769,1.250000,-1.569594},  {-0.969249,1.250000,-1.335291},
{-1.334633,1.250000,-0.970154}, {-1.569203,1.250000,-0.509976}, {-1.649998,1.250000,0.000067},  {-1.569161,1.250000,0.510103},  {-1.334555,1.250000,0.970263},
{-0.969140,1.250000,1.335370},  {-0.508769,1.250000,1.569594},  {0.969249,1.250000,1.335291},   {1.334633,1.250000,0.970154},   {1.569203,1.250000,0.509976},
{1.649998,1.250000,-0.000067},  {1.569161,1.250000,-0.510103},  {1.334555,1.250000,-0.970263},  {0.969140,1.250000,-1.335370},  {1.022391,0.750414,-1.948003},
{-0.000000,0.750414,2.200000},  {0.526495,0.750414,2.136072},   {-0.526495,0.750414,2.136072},  {-1.022391,0.750414,1.948003},  {-1.458870,0.750414,1.646724},
{-1.810564,0.750414,1.249742},  {1.458870,0.750414,-1.646724},  {-2.183959,0.750414,-0.265181}, {-2.057036,0.750414,-0.780131}, {-1.810564,0.750414,-1.249742},
{-1.458870,0.750414,-1.646724}, {-1.022391,0.750414,-1.948003}, {-0.526495,0.750414,-2.136072}, {0.000000,0.750414,-2.200000},  {1.022391,0.750414,1.948003},
{0.526495,0.750414,-2.136072},  {2.183959,0.750414,-0.265181},  {1.810564,0.750414,-1.249742},  {2.057036,0.750414,-0.780131},  {2.183959,0.750414,0.265181},
{2.057036,0.750414,0.780131},   {1.810564,0.750414,1.249742},   {1.458870,0.750414,1.646724},   {0.000000,0.250000,0.000000},   {0.000000,1.250000,0.000000}
	};
	static GLfloat normals [217][3] = {
{0.0000,-1.0000,0.0000},  {-0.0000,-0.3586,-0.9335},{-0.0000,-0.5403,-0.8415},{-0.1167,-0.5338,-0.8375},{0.2243,-0.3590,-0.9060}, {0.1167,-0.5338,-0.8375},
{0.0000,1.0000,0.0000},   {-0.2243,-0.3590,-0.9060},{-0.2463,-0.5351,-0.8081},{-0.3426,-0.5337,-0.7732},{-0.4331,-0.3590,-0.8268},{-0.4614,-0.5339,-0.7086},{-0.6188,-0.3587,-0.6989},
{-0.5494,-0.5399,-0.6377},{-0.6378,-0.5338,-0.5551},{-0.7686,-0.3589,-0.5296},{-0.7130,-0.5373,-0.4504},{-0.7657,-0.5338,-0.3587},{-0.8727,-0.3588,-0.3312},{-0.8132,-0.5339,-0.2318},
{-0.9266,-0.3587,-0.1130},{-0.8331,-0.5390,-0.1243},{-0.8456,-0.5338,0.0000}, {0.8130,0.5342,-0.2317},  {0.8329,0.5393,-0.1243},  {0.9264,0.3593,-0.1130},  {-0.9266,-0.3587,0.1130},
{-0.8331,-0.5390,0.1244}, {-0.8132,-0.5339,0.2318}, {-0.8727,-0.3588,0.3312}, {-0.7657,-0.5338,0.3587}, {-0.7686,-0.3589,0.5296}, {-0.7130,-0.5373,0.4504}, {-0.6378,-0.5338,0.5552},
{0.7657,-0.5338,-0.3587}, {0.7130,-0.5373,-0.4504}, {0.7686,-0.3589,-0.5296}, {-0.6188,-0.3587,0.6989}, {-0.5494,-0.5399,0.6377}, {-0.4614,-0.5339,0.7086}, {-0.4331,-0.3590,0.8268},
{-0.3426,-0.5337,0.7732}, {-0.2243,-0.3590,0.9060}, {-0.2463,-0.5351,0.8081}, {-0.1167,-0.5338,0.8375}, {-0.3425,0.5340,-0.7730}, {-0.2463,0.5354,-0.8079}, {-0.2242,0.3596,-0.9058},
{0.0000,-0.3586,0.9335},  {0.0000,-0.5403,0.8415},  {0.1167,-0.5338,0.8375},  {0.2243,-0.3590,0.9060},  {0.2463,-0.5351,0.8081},  {0.3426,-0.5337,0.7732},  {0.4331,-0.3590,0.8268},
{0.4614,-0.5339,0.7086},  {0.6188,-0.3587,0.6989},  {0.5494,-0.5399,0.6377},  {0.6378,-0.5338,0.5551},  {0.7686,-0.3589,0.5296},  {0.7130,-0.5373,0.4504},  {0.7657,-0.5338,0.3587},
{0.8727,-0.3588,0.3312},  {0.8132,-0.5339,0.2318},  {0.9266,-0.3587,0.1130},  {0.8331,-0.5390,0.1243},  {0.8456,-0.5338,-0.0000}, {0.9266,-0.3587,-0.1130}, {0.8331,-0.5390,-0.1244},
{0.8132,-0.5339,-0.2318}, {0.8727,-0.3588,-0.3312}, {0.6378,-0.5338,-0.5552}, {0.7656,0.5341,0.3587},   {0.7129,0.5376,0.4503},   {0.7684,0.3594,0.5295},   {0.6188,-0.3587,-0.6989},
{0.5494,-0.5399,-0.6377}, {0.4614,-0.5339,-0.7086}, {0.4331,-0.3590,-0.8268}, {0.3426,-0.5337,-0.7732}, {0.2463,-0.5351,-0.8081}, {0.0000,-0.0000,1.0000},  {-0.3086,-0.0000,0.9512},
{0.3087,-0.0000,0.9512},  {-0.9350,0.0004,0.3546},  {-0.9927,0.0004,0.1205},  {-0.5874,-0.0000,0.8093}, {-0.3088,0.0000,0.9511},  {-0.5876,0.0000,0.8092},  {-0.8088,-0.0000,0.5880},
{-0.8089,0.0000,0.5879},  {-0.9510,-0.0000,0.3092}, {-0.9510,0.0000,0.3091},  {-1.0000,-0.0000,0.0001}, {-1.0000,0.0000,-0.0001}, {-0.9510,-0.0000,-0.3091},{-0.9510,0.0000,-0.3092},
{-0.8089,-0.0000,-0.5880},{-0.5875,-0.0000,-0.8092},{-0.3087,-0.0000,-0.9512},{-0.0000,-0.0000,-1.0000},{0.5875,0.0000,0.8092},   {0.3086,-0.0000,-0.9512}, {0.5874,-0.0000,-0.8093},
{0.3088,0.0000,-0.9511},  {0.5876,0.0000,-0.8092},  {0.8088,-0.0000,-0.5880}, {0.8089,0.0000,-0.5879},  {0.9510,-0.0000,-0.3092}, {0.9510,0.0000,-0.3091},  {1.0000,-0.0000,-0.0001},
{1.0000,0.0000,0.0001},   {0.9510,-0.0000,0.3091},  {0.9510,0.0000,0.3092},   {0.8089,-0.0000,0.5880},  {0.0000,0.3591,0.9333},   {0.0000,0.5406,0.8413},   {-0.1167,0.5341,0.8373},
{0.2242,0.3596,0.9058},   {0.1167,0.5341,0.8373},   {-0.1167,0.5341,-0.8373}, {-0.0000,0.5406,-0.8413}, {-0.0000,0.3591,-0.9333}, {-0.2242,0.3596,0.9058},  {-0.2462,0.5354,0.8079},
{-0.3425,0.5340,0.7730},  {-0.4330,0.3595,0.8266},  {-0.4613,0.5342,0.7084},  {-0.6187,0.3592,0.6987},  {-0.5492,0.5403,0.6376},  {-0.6377,0.5341,0.5550},  {0.4613,0.5342,-0.7084},
{0.5492,0.5403,-0.6376},  {0.6187,0.3592,-0.6987},  {-0.7684,0.3594,0.5295},  {-0.7129,0.5376,0.4503},  {-0.7655,0.5341,0.3587},  {-0.8725,0.3594,0.3312},  {-0.8130,0.5342,0.2317},
{-0.9264,0.3593,0.1130},  {-0.8329,0.5393,0.1243},  {-0.8454,0.5341,0.0000},  {-0.9264,0.3593,-0.1130}, {-0.8329,0.5393,-0.1243}, {-0.8130,0.5342,-0.2317}, {-0.8725,0.3594,-0.3312},
{-0.7656,0.5341,-0.3587}, {-0.7684,0.3594,-0.5295}, {-0.7129,0.5376,-0.4503}, {-0.6377,0.5341,-0.5550}, {-0.6187,0.3592,-0.6987}, {-0.5493,0.5403,-0.6375}, {-0.4613,0.5342,-0.7084},
{-0.4330,0.3595,-0.8266}, {0.3425,0.5340,0.7730},   {0.2463,0.5354,0.8079},   {0.1167,0.5341,-0.8373},  {0.2242,0.3596,-0.9058},  {0.2462,0.5354,-0.8079},  {0.3425,0.5340,-0.7730},
{0.4330,0.3595,-0.8266},  {0.6377,0.5341,-0.5550},  {0.7684,0.3594,-0.5295},  {0.7129,0.5376,-0.4503},  {0.7655,0.5341,-0.3587},  {0.8725,0.3594,-0.3312},  {0.8454,0.5341,-0.0000},
{0.9264,0.3593,0.1130},   {0.8329,0.5393,0.1243},   {0.8130,0.5342,0.2317},   {0.8725,0.3594,0.3312},   {0.6377,0.5341,0.5550},   {0.6187,0.3592,0.6987},   {0.5493,0.5403,0.6375},
{0.4613,0.5342,0.7084},   {0.4330,0.3595,0.8266},   {0.3086,0.0000,0.9512},   {-0.3085,0.0000,0.9512},  {-0.3087,-0.0000,0.9511}, {0.5874,0.0000,0.8093},   {-0.3086,0.0000,-0.9512},
{0.8088,-0.0000,0.5880},  {0.8088,0.0000,-0.5881},  {0.5875,-0.0000,-0.8092}, {0.5873,0.0000,-0.8093},  {0.3087,-0.0000,-0.9511}, {0.3085,0.0000,-0.9512},  {-0.5874,0.0000,-0.8093},
{-0.8088,-0.0000,-0.5880},{-0.8088,0.0000,0.5881},  {-0.5875,-0.0000,0.8092}, {-0.5873,0.0000,0.8093},  {0.4647,0.0004,-0.8855},  {-0.0000,0.0004,1.0000},  {0.2393,0.0004,0.9709},
{-0.2393,0.0004,0.9709},  {-0.4647,0.0004,0.8855},  {-0.6631,0.0004,0.7485},  {-0.8230,0.0004,0.5681},  {0.6631,0.0004,-0.7485},  {-0.9927,0.0004,-0.1205}, {-0.9350,0.0004,-0.3546},
{-0.8230,0.0004,-0.5681}, {-0.6631,0.0004,-0.7485}, {-0.4647,0.0004,-0.8855}, {-0.2393,0.0004,-0.9709}, {0.0000,0.0004,-1.0000},  {0.4647,0.0004,0.8855},   {0.2393,0.0004,-0.9709},
{0.9927,0.0004,-0.1205},  {0.8230,0.0004,-0.5681},  {0.9350,0.0004,-0.3546},  {0.9927,0.0004,0.1205},   {0.9350,0.0004,0.3546},   {0.8230,0.0004,0.5681},   {0.6631,0.0004,0.7485}
	};
	static GLfloat textures [454][2] = {
{0.7891,0.1969},{0.7851,0.2229},{0.7596,0.2178},{0.8251,0.1343},
{0.7891,0.1371},{0.7891,0.1114},{0.8251,0.1839},{0.7891,0.1633},{0.3457,0.1032},{0.3709,0.0956},{0.3826,0.1195},{0.8251,0.0862},{0.7891,0.0866},
{0.4182,0.0956},{0.4434,0.1032},{0.4065,0.1195},{0.7771,0.2481},{0.7891,0.0634},{0.4240,0.1498},{0.4346,0.2482},{0.4065,0.2482},{0.3986,0.2230},
{0.8251,0.0425},{0.7891,0.0421},{0.7627,0.1679},{0.7851,0.1446},{0.7891,0.1706},{0.7502,0.2941},{0.7402,0.2644},{0.7654,0.2720},{0.7654,0.0955},
{0.7771,0.1194},{0.7490,0.1194},{0.8251,0.0057},{0.4209,0.1997},{0.3945,0.1706},{0.7501,0.0734},{0.7200,0.0773},{0.7845,0.0831},{0.3117,0.0644},
{0.3557,0.0734},{0.7316,0.0535},{0.3753,0.9615},{0.3393,0.9610},{0.3393,0.9424},{0.3753,0.9937},{0.7103,0.0363},{0.3393,0.9213},{0.6784,0.0456},
{0.6866,0.0221},{0.3753,0.9212},{0.3393,0.8982},{0.6609,0.0111},{0.3753,0.8751},{0.6283,0.0274},{0.6338,0.0037},{0.3393,0.8735},{0.3393,0.8478},
{0.6799,0.5792},{0.6789,0.5535},{0.7104,0.5521},{0.5746,0.0246},{0.6059,0.0000},{0.3753,0.8260},{0.3393,0.8215},{0.5776,0.0000},{0.3393,0.7953},
{0.5226,0.0373},{0.5497,0.0038},{0.3753,0.7766},{0.3393,0.7696},{0.5226,0.0112},{0.3753,0.7299},{0.3393,0.7450},{0.3393,0.7220},{0.6867,0.3455},
{0.6610,0.3564},{0.6610,0.3302},{0.8355,0.6038},{0.8377,0.6269},{0.7996,0.6442},{0.4774,0.0644},{0.4732,0.0363},{0.3753,0.6886},{0.3393,0.7010},
{0.4519,0.0536},{0.4334,0.0734},{0.8799,0.6813},{0.8439,0.6636},{0.8439,0.6448},{0.7317,0.3140},{0.7104,0.3312},{0.7062,0.3031},{0.3945,0.1969},
{0.8799,0.6445},{0.8439,0.6236},{0.8799,0.6008},{0.3985,0.1447},{0.8439,0.6003},{0.8438,0.5756},{0.9452,0.0634},{0.9452,0.0866},{0.9093,0.0862},
{0.8799,0.5527},{0.8438,0.5499},{0.8438,0.5237},{0.8799,0.5031},{0.8438,0.4975},{0.8438,0.4719},{0.0829,0.3031},{0.0574,0.3140},{0.0389,0.2941},
{0.8799,0.4548},{0.8439,0.4473},{0.4182,0.2721},{0.8799,0.4106},{0.0400,0.1194},{0.0264,0.1679},{0.0040,0.1446},{0.4335,0.2942},{0.4636,0.2903},
{0.8055,0.3732},{0.8438,0.3880},{0.8405,0.4066},{0.7891,0.0233},{0.4520,0.3141},{0.7996,0.4104},{0.8377,0.4276},{0.4733,0.3313},{0.8355,0.4507},
{0.5052,0.3220},{0.4971,0.3455},{0.7955,0.4543},{0.8338,0.4754},{0.5227,0.3564},{0.7934,0.5025},{0.5553,0.3402},{0.5498,0.3638},{0.8328,0.5011},
{0.8325,0.5273},{0.6090,0.3430},{0.5778,0.3676},{0.7934,0.5521},{0.8328,0.5535},{0.6060,0.3676},{0.8338,0.5792},{0.6339,0.3638},{0.7955,0.6003},
{0.4970,0.0221},{0.8405,0.6480},{0.6815,0.4507},{0.6838,0.4276},{0.7166,0.4104},{0.8055,0.6813},{0.8438,0.6665},{0.8251,0.2763},{0.7891,0.2625},
{0.7891,0.2396},{0.3556,0.2942},{0.3371,0.3141},{0.3255,0.2903},{0.8251,0.2322},{0.7891,0.2151},{0.7891,0.1895},{0.5475,0.8206},{0.5735,0.8206},
{0.5475,0.8685},{0.5475,0.7707},{0.5735,0.7707},{0.4174,0.7750},{0.4174,0.8261},{0.5475,0.9098},{0.5735,0.8686},{0.5735,0.9098},{0.5214,0.7237},
{0.5475,0.6837},{0.5475,0.7237},{0.5215,0.6837},{0.5214,0.7710},{0.5475,0.7710},{0.5214,0.8211},{0.5475,0.8211},{0.5214,0.8690},{0.5475,0.8690},
{0.5215,0.9100},{0.5475,0.9100},{0.9452,0.0305},{0.9713,0.0000},{0.9713,0.0305},{0.9452,0.0000},{0.9452,0.0718},{0.9713,0.0718},{0.9452,0.1197},
{0.5735,0.7234},{0.9713,0.1197},{0.9452,0.1697},{0.9452,0.2169},{0.9713,0.1697},{0.9713,0.2169},{0.9452,0.2566},{0.9713,0.2567},{0.6577,0.8272},
{0.6361,0.8718},{0.6321,0.8272},{0.6618,0.8719},{0.6563,0.7778},{0.6307,0.7778},{0.6577,0.7283},{0.6321,0.7283},{0.6618,0.6837},{0.6361,0.6837},
{0.5475,0.7234},{0.5735,0.6837},{0.5475,0.6837},{0.0119,0.2481},{0.0040,0.2229},{0.0294,0.2178},{0.9640,0.5527},{1.0000,0.5499},{1.0000,0.5756},
{0.9640,0.5031},{1.0000,0.5237},{0.9452,0.1114},{0.9452,0.1371},{0.9093,0.1343},{0.9640,0.6007},{1.0000,0.6003},{0.3682,0.1997},{0.3651,0.1498},
{0.3945,0.1706},{1.0000,0.6236},{0.0000,0.1969},{0.3372,0.0536},{0.9640,0.6444},{1.0000,0.6448},{0.0489,0.2643},{0.0236,0.2720},{0.0000,0.1706},
{0.0787,0.3312},{0.9640,0.6812},{0.1024,0.3455},{0.1281,0.3302},{0.4595,0.6886},{0.4954,0.7010},{0.4954,0.7220},{0.9452,0.2396},{0.9452,0.2625},
{0.9093,0.2763},{0.1281,0.3564},{0.4595,0.7299},{0.4954,0.7450},{0.1552,0.3638},{0.4954,0.7696},{0.1801,0.3430},{0.1831,0.3676},{0.4594,0.7766},
{0.4954,0.7953},{0.2113,0.3676},{0.4594,0.8260},{0.2337,0.3402},{0.2393,0.3638},{0.4954,0.8215},{0.4954,0.8478},{0.3545,0.2481},{0.3905,0.2230},
{0.2663,0.3564},{0.4594,0.8751},{0.4954,0.8735},{0.2838,0.3220},{0.2920,0.3455},{0.4954,0.8982},{0.3158,0.3313},{0.4595,0.9212},{0.4954,0.9213},
{0.4595,0.9615},{0.0237,0.0955},{0.0390,0.0734},{0.0691,0.0773},{0.4954,0.9424},{0.4954,0.9611},{0.0574,0.0535},{0.3708,0.2721},{0.3899,0.2844},
{0.4595,0.9937},{0.3826,0.2482},{0.9093,0.0057},{0.9452,0.0233},{0.9452,0.0421},{0.3945,0.1969},{0.9093,0.0425},{0.3905,0.1447},{1.0000,0.4719},
{1.0000,0.4975},{0.9452,0.1633},{0.9093,0.1839},{0.9452,0.1895},{0.9452,0.2151},{0.9093,0.2321},{0.3159,0.0363},{0.2921,0.0221},{0.2664,0.0373},
{0.9452,0.2834},{0.8439,0.4244},{0.2665,0.0112},{0.9093,0.3138},{0.9452,0.3018},{0.2394,0.0038},{0.7166,0.6442},{0.6838,0.6269},{0.6815,0.6038},
{0.2145,0.0246},{0.2114,0.0000},{0.7125,0.6002},{0.1832,0.0000},{0.1608,0.0274},{0.1553,0.0037},{0.6785,0.5273},{0.1282,0.0111},{0.7104,0.5025},
{0.6789,0.5011},{0.1107,0.0456},{0.1025,0.0221},{0.6799,0.4754},{0.0788,0.0363},{0.7125,0.4543},{0.9640,0.3732},{1.0000,0.3852},{1.0000,0.4035},
{0.9640,0.4107},{1.0000,0.4244},{0.0120,0.1194},{1.0000,0.4473},{0.9640,0.4548},{0.5995,0.8206},{0.5735,0.8206},{0.5995,0.7707},{0.5995,0.8685},
{0.5735,0.8685},{0.5735,0.7707},{0.5735,0.7234},{0.9713,0.1197},{0.9713,0.0718},{0.9973,0.0718},{0.5995,0.7234},{0.5735,0.6837},{0.6050,0.6837},
{0.6307,0.6837},{0.6266,0.7283},{0.5995,0.6837},{0.6009,0.7283},{0.6252,0.7778},{0.5995,0.7778},{0.6266,0.8272},{0.6009,0.8272},{0.6307,0.8719},
{0.9973,0.2566},{0.9713,0.2566},{0.9713,0.2169},{0.6050,0.8719},{0.9973,0.2169},{0.9713,0.1697},{0.9973,0.1697},{0.9973,0.1197},{0.9713,0.0305},
{0.9973,0.0305},{0.9713,0.0000},{0.5214,0.9100},{0.4954,0.9100},{0.4954,0.8690},{0.9973,0.0000},{0.5214,0.8690},{0.4954,0.8211},{0.5214,0.8211},
{0.4954,0.7710},{0.5214,0.7710},{0.4954,0.7237},{0.5214,0.7237},{0.4954,0.6837},{0.5995,0.9098},{0.5735,0.9098},{0.5214,0.6837},{1.0000,0.6636},
{0.8672,0.2348},{0.9220,0.5537},{0.9220,0.5023},{0.9220,0.6035},{0.9220,0.6488},{0.4174,0.6837},{0.9220,0.6870},{0.4174,0.7265},{0.8672,0.2805},
{0.4174,0.8771},{0.4174,0.9248},{0.4174,0.9666},{0.8672,0.0000},{0.4174,1.0000},{0.8672,0.0382},{0.8672,0.0835},{0.8672,0.1333},{0.9220,0.4522},
{0.8672,0.1847},{0.7506,0.5530},{0.8672,0.3194},{0.7570,0.6485},{0.7527,0.6029},{0.7506,0.5016},{0.7527,0.4516},{0.9220,0.3676},{0.7570,0.4061},
{0.9220,0.4064},{0.7631,0.6870},{0.7631,0.3676},{0.4821,0.3676},{0.5089,0.5256},{0.4310,0.3830},{0.0166,0.4530},{0.1696,0.5256},{0.0000,0.5006},
{0.0482,0.4125},{0.0917,0.3830},{0.1429,0.3676},{0.1966,0.3676},{0.2478,0.3831},{0.0000,0.5507},{0.0166,0.5983},{0.0481,0.6387},{0.0915,0.6681},
{0.1426,0.6837},{0.1964,0.6837},{0.2475,0.6682},{0.2910,0.6388},{0.3226,0.5983},{0.3393,0.5507},{0.3393,0.5006},{0.2911,0.4125},{0.3226,0.4530},
{0.3875,0.4125},{0.3559,0.4530},{0.3393,0.5006},{0.3393,0.5507},{0.3559,0.5983},{0.3874,0.6387},{0.4308,0.6681},{0.4819,0.6837},{0.5357,0.6837},
{0.5868,0.6682},{0.6303,0.6388},{0.6619,0.5983},{0.6785,0.5507},{0.6785,0.5006},{0.6619,0.4530},{0.6304,0.4125},{0.5870,0.3831},{0.5359,0.3676}
	};

	GLint GenThymio2Wheel()
	{
		GLint lid=glGenLists(1);
		glNewList(lid, GL_COMPILE);

			glBegin (GL_TRIANGLES);
			for(unsigned int i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
			{
				for(unsigned int j=0;j<3;j++)
				{
					unsigned int vi = face_indicies[i][3*j]   - 1;
					unsigned int ti = face_indicies[i][3*j+1] - 1;
					unsigned int ni = face_indicies[i][3*j+2] - 1;

					glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
					glTexCoord2f(textures[ti][0],textures[ti][1]);
					glVertex3f(vertices[vi][0],vertices[vi][1],vertices[vi][2]);
				}
			}
			glEnd ();

		glEndList();
		return lid;
	};
}
