gap> START_TEST("randlist.tst");
#@if 8*GAPInfo.BytesPerVariable = 32
gap> l := [1..2^(8*GAPInfo.BytesPerVariable-4)-1];
[ 1 .. 268435455 ]
gap> Reset(GlobalMersenneTwister, 1);;
gap> List([1..10], i-> Random(1, 2^70));
[ 389420078096435786116, 1135477438879460122740, 425191437180319830675, 
  1083900231106243887320, 600872374094649387692, 39438917363375403157, 
  860639563472417594821, 1064153947161477828981, 140455377727366448871, 
  198677943275448576238 ]
gap> List([1..10], i-> Random(l));
[ 13155435, 3131483, 21560873, 174688373, 142786538, 140745645, 25528157, 
  45625016, 214994737, 84644 ]
gap> List([1..10], i-> Random(1,10^(3*i)));
[ 721, 46797, 22238206, 187185663184, 734387696875236, 101821667962893342, 
  669052909362560486368, 769723171201061857635320, 
  874658974599856967310222061, 397063360144420204491778152435 ]
gap> Reset(GlobalRandomSource, 1);;
gap> List([1..10], i-> Random(GlobalRandomSource, 1, 2^70));
[ 1128431629504922105781, 1101744982711025966526, 975266616221323178376, 
  678285771456235093359, 337368903834409162500, 1067481644129172537859, 
  666712591436546208470, 471773889319658808870, 27293053954741592585, 
  894173925476383505759 ]
gap> List([1..10], i-> Random(GlobalRandomSource, l));
[ 40228334, 111587641, 262452744, 44854923, 39845682, 206581571, 92903376, 
  231314873, 66408590, 258714463 ]
gap> List([1..10], i-> Random(GlobalRandomSource, l)) mod 2^28;
[ 184978940, 159620597, 123129748, 68026743, 233471294, 232591449, 24005304, 
  5708683, 167299138, 197744113 ]
gap> List([1..10], i-> Random(GlobalRandomSource, 1,10^(3*i)));
[ 602, 615764, 985971579, 527993069062, 970982477709403, 915182928712255106, 
  52224684171237700022, 63091858766485771208964, 391269615753496331510430301, 
  929557928485066381724613674190 ]
gap> rs := RandomSource(IsMersenneTwister, 1);
<RandomSource in IsMersenneTwister>
gap> List([1..10], i-> Random(rs, 1, 2^70));
[ 389420078096435786116, 1135477438879460122740, 425191437180319830675, 
  1083900231106243887320, 600872374094649387692, 39438917363375403157, 
  860639563472417594821, 1064153947161477828981, 140455377727366448871, 
  198677943275448576238 ]
gap> List([1..10], i-> Random(rs, l));
[ 13155435, 3131483, 21560873, 174688373, 142786538, 140745645, 25528157, 
  45625016, 214994737, 84644 ]
gap> List([1..10], i-> Random(rs, 1,10^(3*i)));
[ 721, 46797, 22238206, 187185663184, 734387696875236, 101821667962893342, 
  669052909362560486368, 769723171201061857635320, 
  874658974599856967310222061, 397063360144420204491778152435 ]
gap> rs := RandomSource(IsGAPRandomSource, 1);
<RandomSource in IsGAPRandomSource>
gap> List([1..10], i-> Random(rs, 1, 2^70));
[ 1128431629504922105781, 1101744982711025966526, 975266616221323178376, 
  678285771456235093359, 337368903834409162500, 1067481644129172537859, 
  666712591436546208470, 471773889319658808870, 27293053954741592585, 
  894173925476383505759 ]
gap> List([1..10], i-> Random(rs, l));
[ 40228334, 111587641, 262452744, 44854923, 39845682, 206581571, 92903376, 
  231314873, 66408590, 258714463 ]
gap> List([1..10], i-> Random(rs, l)) mod 2^28;
[ 184978940, 159620597, 123129748, 68026743, 233471294, 232591449, 24005304, 
  5708683, 167299138, 197744113 ]
gap> List([1..10], i-> Random(rs, 1,10^(3*i)));
[ 602, 615764, 985971579, 527993069062, 970982477709403, 915182928712255106, 
  52224684171237700022, 63091858766485771208964, 391269615753496331510430301, 
  929557928485066381724613674190 ]
#@else
gap> l4 := [1..2^28-1];
[ 1 .. 268435455 ]
gap> l8 := [1..2^60-1];
[ 1 .. 1152921504606846975 ]
gap> bits := Concatenation([27..33],[59..65],[95..97],[127..129]);;

#
gap> Reset(GlobalMersenneTwister, 1);;
gap> List(bits,    i-> Random(1, 2^i));
[ 18829054, 164251624, 474614219, 233454245, 213348187, 3257085298, 
  1185099587, 100418839541388781, 78936154011671244, 1951632504588564735, 
  1891846953557814001, 7380160538170766753, 4588549330382399543, 
  20212399778158554723, 25871717046293081269812882956, 
  74959154262646398646743466671, 52390258479956963774859779424, 
  46150081993482768205533540973984006122, 
  264304607032107166297612477092494666822, 
  369126435272860177990538082224405421325 ]
gap> List([1..10], i-> Random(1, 10^(3*i)));
[ 796, 488110, 337484392, 594009012741, 658311342730164, 718543835420643146, 
  192531588881827984252, 93448310516637261223301, 897306488169252919346512382,
  373729190135314870329223545530 ]
gap> List([1..10], i-> Random(l4));
[ 143468941, 48373072, 9645662, 124739889, 124982356, 178658837, 173118677, 
  117495931, 138389463, 242860897 ]
gap> List([1..10], i-> Random(l8));
[ 347927869732747975, 519413397450930047, 898055001130687869, 
  163763776991392067, 969052338240557373, 1038155658715349861, 
  493205527438070762, 28433991423533450, 173244587732492565, 
  990629399330982901 ]

#
gap> Reset(GlobalRandomSource, 1);;
gap> List(bits,    i-> Random(GlobalRandomSource, 1, 2^i));
[ 128287824, 93339996, 497514298, 126333050, 888008348, 3272686668, 
  3284765239, 246384569571494206, 899121525533970334, 2058504735678170118, 
  1295847095154625366, 1831951483667165481, 12413749580545794189, 
  21112300994467179461, 16479214171808335931562195799, 
  47077177305952446651710749862, 93051612446083908105560589039, 
  17595829529914834395994704246711425132, 
  189028623575818650885511742806844572497, 
  442802932679156364466206827982691923819 ]
gap> List([1..10], i-> Random(GlobalRandomSource, 1, 10^(3*i)));
[ 292, 540747, 68367363, 782766307890, 207951565811836, 269515013492647614, 
  168133019703503347058, 46702024622849426851426, 498676940076039327334874754,
  960893403060023160487783291143 ]
gap> List([1..10], i-> Random(GlobalRandomSource, l4));
[ 190962548, 17964291, 180726950, 185199085, 213556766, 109018187, 55718740, 
  216423086, 151137000, 48013178 ]
gap> List([1..10], i-> Random(GlobalRandomSource, l8));
[ 1128201256618036672, 890212987711716841, 228981350846997556, 
  962603471308182302, 697651637792723842, 464389630980588785, 
  463611844822187319, 195151234274091472, 339385016873630147, 
  670406272576191605 ]

#
gap> rs := RandomSource(IsMersenneTwister, 1);
<RandomSource in IsMersenneTwister>
gap> List(bits,    i-> Random(rs, 1, 2^i));
[ 18829054, 164251624, 474614219, 233454245, 213348187, 3257085298, 
  1185099587, 100418839541388781, 78936154011671244, 1951632504588564735, 
  1891846953557814001, 7380160538170766753, 4588549330382399543, 
  20212399778158554723, 25871717046293081269812882956, 
  74959154262646398646743466671, 52390258479956963774859779424, 
  46150081993482768205533540973984006122, 
  264304607032107166297612477092494666822, 
  369126435272860177990538082224405421325 ]
gap> List([1..10], i-> Random(rs, 1, 10^(3*i)));
[ 796, 488110, 337484392, 594009012741, 658311342730164, 718543835420643146, 
  192531588881827984252, 93448310516637261223301, 897306488169252919346512382,
  373729190135314870329223545530 ]
gap> List([1..10], i-> Random(rs, l4));
[ 143468941, 48373072, 9645662, 124739889, 124982356, 178658837, 173118677, 
  117495931, 138389463, 242860897 ]
gap> List([1..10], i-> Random(rs, l8));
[ 347927869732747975, 519413397450930047, 898055001130687869, 
  163763776991392067, 969052338240557373, 1038155658715349861, 
  493205527438070762, 28433991423533450, 173244587732492565, 
  990629399330982901 ]

#
gap> rs := RandomSource(IsGAPRandomSource, 1);
<RandomSource in IsGAPRandomSource>
gap> List(bits,    i-> Random(rs, 1, 2^i));
[ 128287824, 93339996, 497514298, 126333050, 888008348, 3272686668, 
  3284765239, 246384569571494206, 899121525533970334, 2058504735678170118, 
  1295847095154625366, 1831951483667165481, 12413749580545794189, 
  21112300994467179461, 16479214171808335931562195799, 
  47077177305952446651710749862, 93051612446083908105560589039, 
  17595829529914834395994704246711425132, 
  189028623575818650885511742806844572497, 
  442802932679156364466206827982691923819 ]
gap> List([1..10], i-> Random(rs, 1, 10^(3*i)));
[ 292, 540747, 68367363, 782766307890, 207951565811836, 269515013492647614, 
  168133019703503347058, 46702024622849426851426, 498676940076039327334874754,
  960893403060023160487783291143 ]
gap> List([1..10], i-> Random(rs, l4));
[ 190962548, 17964291, 180726950, 185199085, 213556766, 109018187, 55718740, 
  216423086, 151137000, 48013178 ]
gap> List([1..10], i-> Random(rs, l8));
[ 1128201256618036672, 890212987711716841, 228981350846997556, 
  962603471308182302, 697651637792723842, 464389630980588785, 
  463611844822187319, 195151234274091472, 339385016873630147, 
  670406272576191605 ]

#@fi
gap> STOP_TEST( "randlist.tst", 1);
