//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package internal

import (
	"context"
	"encoding/xml"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
	"time"
)

// TableClient contains the methods for the Table group.
// Don't use this type directly, use NewTableClient() instead.
type TableClient struct {
	endpoint string
	version  Enum0
	pl       runtime.Pipeline
}

// NewTableClient creates a new instance of TableClient with the specified values.
// endpoint - The URL of the service account or table that is the target of the desired operation.
// version - Specifies the version of the operation to use for this request.
// options - pass nil to accept the default values.
func NewTableClient(endpoint string, version Enum0, options *azcore.ClientOptions) *TableClient {
	if options == nil {
		options = &azcore.ClientOptions{}
	}
	client := &TableClient{
		endpoint: endpoint,
		version:  version,
		pl:       runtime.NewPipeline(moduleName, moduleVersion, runtime.PipelineOptions{}, options),
	}
	return client
}

// Create - Creates a new table under the given account.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// tableProperties - The Table properties.
// options - TableClientCreateOptions contains the optional parameters for the TableClient.Create method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) Create(ctx context.Context, dataServiceVersion Enum1, tableProperties TableProperties, options *TableClientCreateOptions, queryOptions *QueryOptions) (TableClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, dataServiceVersion, tableProperties, options, queryOptions)
	if err != nil {
		return TableClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated, http.StatusNoContent) {
		return TableClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *TableClient) createCreateRequest(ctx context.Context, dataServiceVersion Enum1, tableProperties TableProperties, options *TableClientCreateOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/Tables"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	if options != nil && options.ResponsePreference != nil {
		req.Raw().Header.Set("Prefer", string(*options.ResponsePreference))
	}
	req.Raw().Header.Set("Accept", "application/json;odata=minimalmetadata")
	return req, runtime.MarshalAsJSON(req, tableProperties)
}

// createHandleResponse handles the Create response.
func (client *TableClient) createHandleResponse(resp *http.Response) (TableClientCreateResponse, error) {
	result := TableClientCreateResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientCreateResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("Preference-Applied"); val != "" {
		result.PreferenceApplied = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.TableResponse); err != nil {
		return TableClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Operation permanently deletes the specified table.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// table - The name of the table.
// options - TableClientDeleteOptions contains the optional parameters for the TableClient.Delete method.
func (client *TableClient) Delete(ctx context.Context, table string, options *TableClientDeleteOptions) (TableClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, table, options)
	if err != nil {
		return TableClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return TableClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteHandleResponse(resp)
}

// deleteCreateRequest creates the Delete request.
func (client *TableClient) deleteCreateRequest(ctx context.Context, table string, options *TableClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/Tables('{table}')"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *TableClient) deleteHandleResponse(resp *http.Response) (TableClientDeleteResponse, error) {
	result := TableClientDeleteResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientDeleteResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// DeleteEntity - Deletes the specified entity in a table.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// table - The name of the table.
// partitionKey - The partition key of the entity.
// rowKey - The row key of the entity.
// ifMatch - Match condition for an entity to be deleted. If specified and a matching entity is not found, an error will be
// raised. To force an unconditional delete, set to the wildcard character (*).
// options - TableClientDeleteEntityOptions contains the optional parameters for the TableClient.DeleteEntity method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) DeleteEntity(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, ifMatch string, options *TableClientDeleteEntityOptions, queryOptions *QueryOptions) (TableClientDeleteEntityResponse, error) {
	req, err := client.DeleteEntityCreateRequest(ctx, dataServiceVersion, table, partitionKey, rowKey, ifMatch, options, queryOptions)
	if err != nil {
		return TableClientDeleteEntityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientDeleteEntityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return TableClientDeleteEntityResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteEntityHandleResponse(resp)
}

// deleteEntityCreateRequest creates the DeleteEntity request.
func (client *TableClient) DeleteEntityCreateRequest(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, ifMatch string, options *TableClientDeleteEntityOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	if partitionKey == "" {
		return nil, errors.New("parameter partitionKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{partitionKey}", url.PathEscape(partitionKey))
	urlPath = strings.ReplaceAll(urlPath, "{rowKey}", url.PathEscape(rowKey))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	req.Raw().Header.Set("If-Match", ifMatch)
	req.Raw().Header.Set("Accept", "application/json;odata=minimalmetadata")
	return req, nil
}

// deleteEntityHandleResponse handles the DeleteEntity response.
func (client *TableClient) deleteEntityHandleResponse(resp *http.Response) (TableClientDeleteEntityResponse, error) {
	result := TableClientDeleteEntityResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientDeleteEntityResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// GetAccessPolicy - Retrieves details about any stored access policies specified on the table that may be used with Shared
// Access Signatures.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// table - The name of the table.
// comp - Required query string to handle stored access policies for the table that may be used with Shared Access Signatures.
// options - TableClientGetAccessPolicyOptions contains the optional parameters for the TableClient.GetAccessPolicy method.
func (client *TableClient) GetAccessPolicy(ctx context.Context, table string, comp Enum4, options *TableClientGetAccessPolicyOptions) (TableClientGetAccessPolicyResponse, error) {
	req, err := client.getAccessPolicyCreateRequest(ctx, table, comp, options)
	if err != nil {
		return TableClientGetAccessPolicyResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientGetAccessPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TableClientGetAccessPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAccessPolicyHandleResponse(resp)
}

// getAccessPolicyCreateRequest creates the GetAccessPolicy request.
func (client *TableClient) getAccessPolicyCreateRequest(ctx context.Context, table string, comp Enum4, options *TableClientGetAccessPolicyOptions) (*policy.Request, error) {
	urlPath := "/{table}"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	reqQP.Set("comp", string(comp))
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getAccessPolicyHandleResponse handles the GetAccessPolicy response.
func (client *TableClient) getAccessPolicyHandleResponse(resp *http.Response) (TableClientGetAccessPolicyResponse, error) {
	result := TableClientGetAccessPolicyResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientGetAccessPolicyResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result); err != nil {
		return TableClientGetAccessPolicyResponse{}, err
	}
	return result, nil
}

// InsertEntity - Insert entity in a table.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// table - The name of the table.
// options - TableClientInsertEntityOptions contains the optional parameters for the TableClient.InsertEntity method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) InsertEntity(ctx context.Context, dataServiceVersion Enum1, table string, options *TableClientInsertEntityOptions, queryOptions *QueryOptions) (TableClientInsertEntityResponse, error) {
	req, err := client.InsertEntityCreateRequest(ctx, dataServiceVersion, table, options, queryOptions)
	if err != nil {
		return TableClientInsertEntityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientInsertEntityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated, http.StatusNoContent) {
		return TableClientInsertEntityResponse{}, runtime.NewResponseError(resp)
	}
	return client.insertEntityHandleResponse(resp)
}

// insertEntityCreateRequest creates the InsertEntity request.
func (client *TableClient) InsertEntityCreateRequest(ctx context.Context, dataServiceVersion Enum1, table string, options *TableClientInsertEntityOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/{table}"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	if options != nil && options.ResponsePreference != nil {
		req.Raw().Header.Set("Prefer", string(*options.ResponsePreference))
	}
	req.Raw().Header.Set("Accept", "application/json;odata=minimalmetadata")
	if options != nil && options.TableEntityProperties != nil {
		return req, runtime.MarshalAsJSON(req, options.TableEntityProperties)
	}
	return req, nil
}

// insertEntityHandleResponse handles the InsertEntity response.
func (client *TableClient) insertEntityHandleResponse(resp *http.Response) (TableClientInsertEntityResponse, error) {
	result := TableClientInsertEntityResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientInsertEntityResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Preference-Applied"); val != "" {
		result.PreferenceApplied = &val
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.Value); err != nil {
		return TableClientInsertEntityResponse{}, err
	}
	return result, nil
}

// MergeEntity - Merge entity in a table.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// table - The name of the table.
// partitionKey - The partition key of the entity.
// rowKey - The row key of the entity.
// options - TableClientMergeEntityOptions contains the optional parameters for the TableClient.MergeEntity method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) MergeEntity(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, options *TableClientMergeEntityOptions, queryOptions *QueryOptions) (TableClientMergeEntityResponse, error) {
	req, err := client.MergeEntityCreateRequest(ctx, dataServiceVersion, table, partitionKey, rowKey, options, queryOptions)
	if err != nil {
		return TableClientMergeEntityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientMergeEntityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return TableClientMergeEntityResponse{}, runtime.NewResponseError(resp)
	}
	return client.mergeEntityHandleResponse(resp)
}

// mergeEntityCreateRequest creates the MergeEntity request.
func (client *TableClient) MergeEntityCreateRequest(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, options *TableClientMergeEntityOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	if partitionKey == "" {
		return nil, errors.New("parameter partitionKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{partitionKey}", url.PathEscape(partitionKey))
	urlPath = strings.ReplaceAll(urlPath, "{rowKey}", url.PathEscape(rowKey))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	if options != nil && options.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *options.IfMatch)
	}
	req.Raw().Header.Set("Accept", "application/json")
	if options != nil && options.TableEntityProperties != nil {
		return req, runtime.MarshalAsJSON(req, options.TableEntityProperties)
	}
	return req, nil
}

// mergeEntityHandleResponse handles the MergeEntity response.
func (client *TableClient) mergeEntityHandleResponse(resp *http.Response) (TableClientMergeEntityResponse, error) {
	result := TableClientMergeEntityResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientMergeEntityResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	return result, nil
}

// Query - Queries tables under the given account.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// options - TableClientQueryOptions contains the optional parameters for the TableClient.Query method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) Query(ctx context.Context, dataServiceVersion Enum1, options *TableClientQueryOptions, queryOptions *QueryOptions) (TableClientQueryResponse, error) {
	req, err := client.queryCreateRequest(ctx, dataServiceVersion, options, queryOptions)
	if err != nil {
		return TableClientQueryResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientQueryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TableClientQueryResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryHandleResponse(resp)
}

// queryCreateRequest creates the Query request.
func (client *TableClient) queryCreateRequest(ctx context.Context, dataServiceVersion Enum1, options *TableClientQueryOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/Tables"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if options != nil && options.NextTableName != nil {
		reqQP.Set("NextTableName", *options.NextTableName)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	req.Raw().Header.Set("Accept", "application/json;odata=minimalmetadata")
	return req, nil
}

// queryHandleResponse handles the Query response.
func (client *TableClient) queryHandleResponse(resp *http.Response) (TableClientQueryResponse, error) {
	result := TableClientQueryResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientQueryResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-continuation-NextTableName"); val != "" {
		result.XMSContinuationNextTableName = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.TableQueryResponse); err != nil {
		return TableClientQueryResponse{}, err
	}
	return result, nil
}

// QueryEntities - Queries entities in a table.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// table - The name of the table.
// options - TableClientQueryEntitiesOptions contains the optional parameters for the TableClient.QueryEntities method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) QueryEntities(ctx context.Context, dataServiceVersion Enum1, table string, options *TableClientQueryEntitiesOptions, queryOptions *QueryOptions) (TableClientQueryEntitiesResponse, error) {
	req, err := client.queryEntitiesCreateRequest(ctx, dataServiceVersion, table, options, queryOptions)
	if err != nil {
		return TableClientQueryEntitiesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientQueryEntitiesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TableClientQueryEntitiesResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryEntitiesHandleResponse(resp)
}

// queryEntitiesCreateRequest creates the QueryEntities request.
func (client *TableClient) queryEntitiesCreateRequest(ctx context.Context, dataServiceVersion Enum1, table string, options *TableClientQueryEntitiesOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/{table}()"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if options != nil && options.NextPartitionKey != nil {
		reqQP.Set("NextPartitionKey", *options.NextPartitionKey)
	}
	if options != nil && options.NextRowKey != nil {
		reqQP.Set("NextRowKey", *options.NextRowKey)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	req.Raw().Header.Set("Accept", "application/json;odata=minimalmetadata")
	return req, nil
}

// queryEntitiesHandleResponse handles the QueryEntities response.
func (client *TableClient) queryEntitiesHandleResponse(resp *http.Response) (TableClientQueryEntitiesResponse, error) {
	result := TableClientQueryEntitiesResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientQueryEntitiesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-continuation-NextPartitionKey"); val != "" {
		result.XMSContinuationNextPartitionKey = &val
	}
	if val := resp.Header.Get("x-ms-continuation-NextRowKey"); val != "" {
		result.XMSContinuationNextRowKey = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.TableEntityQueryResponse); err != nil {
		return TableClientQueryEntitiesResponse{}, err
	}
	return result, nil
}

// QueryEntityWithPartitionAndRowKey - Queries a single entity in a table.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// table - The name of the table.
// partitionKey - The partition key of the entity.
// rowKey - The row key of the entity.
// options - TableClientQueryEntityWithPartitionAndRowKeyOptions contains the optional parameters for the TableClient.QueryEntityWithPartitionAndRowKey
// method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) QueryEntityWithPartitionAndRowKey(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, options *TableClientQueryEntityWithPartitionAndRowKeyOptions, queryOptions *QueryOptions) (TableClientQueryEntityWithPartitionAndRowKeyResponse, error) {
	req, err := client.queryEntityWithPartitionAndRowKeyCreateRequest(ctx, dataServiceVersion, table, partitionKey, rowKey, options, queryOptions)
	if err != nil {
		return TableClientQueryEntityWithPartitionAndRowKeyResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientQueryEntityWithPartitionAndRowKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TableClientQueryEntityWithPartitionAndRowKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryEntityWithPartitionAndRowKeyHandleResponse(resp)
}

// queryEntityWithPartitionAndRowKeyCreateRequest creates the QueryEntityWithPartitionAndRowKey request.
func (client *TableClient) queryEntityWithPartitionAndRowKeyCreateRequest(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, options *TableClientQueryEntityWithPartitionAndRowKeyOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	if partitionKey == "" {
		return nil, errors.New("parameter partitionKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{partitionKey}", url.PathEscape(partitionKey))
	urlPath = strings.ReplaceAll(urlPath, "{rowKey}", url.PathEscape(rowKey))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	req.Raw().Header.Set("Accept", "application/json;odata=minimalmetadata")
	return req, nil
}

// queryEntityWithPartitionAndRowKeyHandleResponse handles the QueryEntityWithPartitionAndRowKey response.
func (client *TableClient) queryEntityWithPartitionAndRowKeyHandleResponse(resp *http.Response) (TableClientQueryEntityWithPartitionAndRowKeyResponse, error) {
	result := TableClientQueryEntityWithPartitionAndRowKeyResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientQueryEntityWithPartitionAndRowKeyResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("x-ms-continuation-NextPartitionKey"); val != "" {
		result.XMSContinuationNextPartitionKey = &val
	}
	if val := resp.Header.Get("x-ms-continuation-NextRowKey"); val != "" {
		result.XMSContinuationNextRowKey = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.Value); err != nil {
		return TableClientQueryEntityWithPartitionAndRowKeyResponse{}, err
	}
	return result, nil
}

// SetAccessPolicy - Sets stored access policies for the table that may be used with Shared Access Signatures.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// table - The name of the table.
// comp - Required query string to handle stored access policies for the table that may be used with Shared Access Signatures.
// options - TableClientSetAccessPolicyOptions contains the optional parameters for the TableClient.SetAccessPolicy method.
func (client *TableClient) SetAccessPolicy(ctx context.Context, table string, comp Enum4, options *TableClientSetAccessPolicyOptions) (TableClientSetAccessPolicyResponse, error) {
	req, err := client.setAccessPolicyCreateRequest(ctx, table, comp, options)
	if err != nil {
		return TableClientSetAccessPolicyResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientSetAccessPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return TableClientSetAccessPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.setAccessPolicyHandleResponse(resp)
}

// setAccessPolicyCreateRequest creates the SetAccessPolicy request.
func (client *TableClient) setAccessPolicyCreateRequest(ctx context.Context, table string, comp Enum4, options *TableClientSetAccessPolicyOptions) (*policy.Request, error) {
	urlPath := "/{table}"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	reqQP.Set("comp", string(comp))
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	type wrapper struct {
		XMLName  xml.Name             `xml:"SignedIdentifiers"`
		TableACL *[]*SignedIdentifier `xml:"SignedIdentifier"`
	}
	if options != nil && options.TableACL != nil {
		return req, runtime.MarshalAsXML(req, wrapper{TableACL: &options.TableACL})
	}
	return req, nil
}

// setAccessPolicyHandleResponse handles the SetAccessPolicy response.
func (client *TableClient) setAccessPolicyHandleResponse(resp *http.Response) (TableClientSetAccessPolicyResponse, error) {
	result := TableClientSetAccessPolicyResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientSetAccessPolicyResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// UpdateEntity - Update entity in a table.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-02-02
// dataServiceVersion - Specifies the data service version.
// table - The name of the table.
// partitionKey - The partition key of the entity.
// rowKey - The row key of the entity.
// options - TableClientUpdateEntityOptions contains the optional parameters for the TableClient.UpdateEntity method.
// QueryOptions - QueryOptions contains a group of parameters for the TableClient.Query method.
func (client *TableClient) UpdateEntity(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, options *TableClientUpdateEntityOptions, queryOptions *QueryOptions) (TableClientUpdateEntityResponse, error) {
	req, err := client.UpdateEntityCreateRequest(ctx, dataServiceVersion, table, partitionKey, rowKey, options, queryOptions)
	if err != nil {
		return TableClientUpdateEntityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TableClientUpdateEntityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return TableClientUpdateEntityResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateEntityHandleResponse(resp)
}

// updateEntityCreateRequest creates the UpdateEntity request.
func (client *TableClient) UpdateEntityCreateRequest(ctx context.Context, dataServiceVersion Enum1, table string, partitionKey string, rowKey string, options *TableClientUpdateEntityOptions, queryOptions *QueryOptions) (*policy.Request, error) {
	urlPath := "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
	if table == "" {
		return nil, errors.New("parameter table cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{table}", url.PathEscape(table))
	if partitionKey == "" {
		return nil, errors.New("parameter partitionKey cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{partitionKey}", url.PathEscape(partitionKey))
	urlPath = strings.ReplaceAll(urlPath, "{rowKey}", url.PathEscape(rowKey))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if queryOptions != nil && queryOptions.Format != nil {
		reqQP.Set("$format", string(*queryOptions.Format))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", string(client.version))
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("DataServiceVersion", string(dataServiceVersion))
	if options != nil && options.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *options.IfMatch)
	}
	req.Raw().Header.Set("Accept", "application/json")
	if options != nil && options.TableEntityProperties != nil {
		return req, runtime.MarshalAsJSON(req, options.TableEntityProperties)
	}
	return req, nil
}

// updateEntityHandleResponse handles the UpdateEntity response.
func (client *TableClient) updateEntityHandleResponse(resp *http.Response) (TableClientUpdateEntityResponse, error) {
	result := TableClientUpdateEntityResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return TableClientUpdateEntityResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	return result, nil
}
