//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

import "time"

// APIClientBeginCreateOrUpdateOptions contains the optional parameters for the APIClient.BeginCreateOrUpdate method.
type APIClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APIClientDeleteOptions contains the optional parameters for the APIClient.Delete method.
type APIClientDeleteOptions struct {
	// Delete all revisions of the Api.
	DeleteRevisions *bool
}

// APIClientGetEntityTagOptions contains the optional parameters for the APIClient.GetEntityTag method.
type APIClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIClientGetOptions contains the optional parameters for the APIClient.Get method.
type APIClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIClientListByServiceOptions contains the optional parameters for the APIClient.ListByService method.
type APIClientListByServiceOptions struct {
	// Include full ApiVersionSet resource in response
	ExpandAPIVersionSet *bool
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | isCurrent | filter | eq, ne | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Include tags in the response.
	Tags *string
	// Number of records to return.
	Top *int32
}

// APIClientListByTagsOptions contains the optional parameters for the APIClient.ListByTags method.
type APIClientListByTagsOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiRevision | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | isCurrent | filter | eq | |
	Filter *string
	// Include not tagged APIs.
	IncludeNotTaggedApis *bool
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIClientUpdateOptions contains the optional parameters for the APIClient.Update method.
type APIClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APICollection - Paged API list representation.
type APICollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*APIContract `json:"value,omitempty" azure:"ro"`
}

// APIContactInformation - API contact information
type APIContactInformation struct {
	// The email address of the contact person/organization. MUST be in the format of an email address
	Email *string `json:"email,omitempty"`

	// The identifying name of the contact person/organization
	Name *string `json:"name,omitempty"`

	// The URL pointing to the contact information. MUST be in the format of a URL
	URL *string `json:"url,omitempty"`
}

// APIContract - API details.
type APIContract struct {
	// API entity contract properties.
	Properties *APIContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// APIContractProperties - API Entity Properties
type APIContractProperties struct {
	// REQUIRED; Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance.
	// It is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`

	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`

	// Description of the API Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`

	// Type of API.
	APIType *APIType `json:"type,omitempty"`

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`

	// Description of the API Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`

	// Version set details
	APIVersionSet *APIVersionSetContractDetails `json:"apiVersionSet,omitempty"`

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`

	// Contact information for the API.
	Contact *APIContactInformation `json:"contact,omitempty"`

	// Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// API name. Must be 1 to 300 characters long.
	DisplayName *string `json:"displayName,omitempty"`

	// Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`

	// License information for the API.
	License *APILicenseInformation `json:"license,omitempty"`

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol `json:"protocols,omitempty"`

	// Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
	ServiceURL *string `json:"serviceUrl,omitempty"`

	// API identifier of the source API.
	SourceAPIID *string `json:"sourceApiId,omitempty"`

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string `json:"termsOfServiceUrl,omitempty"`

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty" azure:"ro"`
}

// APIContractUpdateProperties - API update contract properties.
type APIContractUpdateProperties struct {
	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`

	// Description of the API Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`

	// Type of API.
	APIType *APIType `json:"type,omitempty"`

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`

	// Description of the API Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`

	// Contact information for the API.
	Contact *APIContactInformation `json:"contact,omitempty"`

	// Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// API name.
	DisplayName *string `json:"displayName,omitempty"`

	// Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`

	// License information for the API.
	License *APILicenseInformation `json:"license,omitempty"`

	// Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It
	// is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol `json:"protocols,omitempty"`

	// Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string `json:"termsOfServiceUrl,omitempty"`

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty" azure:"ro"`
}

// APICreateOrUpdateParameter - API Create or Update Parameters.
type APICreateOrUpdateParameter struct {
	// API entity create of update properties.
	Properties *APICreateOrUpdateProperties `json:"properties,omitempty"`
}

// APICreateOrUpdateProperties - API Create or Update Properties.
type APICreateOrUpdateProperties struct {
	// REQUIRED; Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance.
	// It is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`

	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`

	// Description of the API Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`

	// Type of API.
	APIType *APIType `json:"type,omitempty"`

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`

	// Description of the API Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`

	// Version set details
	APIVersionSet *APIVersionSetContractDetails `json:"apiVersionSet,omitempty"`

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`

	// Contact information for the API.
	Contact *APIContactInformation `json:"contact,omitempty"`

	// Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// API name. Must be 1 to 300 characters long.
	DisplayName *string `json:"displayName,omitempty"`

	// Format of the Content in which the API is getting imported.
	Format *ContentFormat `json:"format,omitempty"`

	// Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`

	// License information for the API.
	License *APILicenseInformation `json:"license,omitempty"`

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol `json:"protocols,omitempty"`

	// Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
	ServiceURL *string `json:"serviceUrl,omitempty"`

	// Type of API to create.
	// * http creates a REST API
	// * soap creates a SOAP pass-through API
	// * websocket creates websocket API
	// * graphql creates GraphQL API.
	SoapAPIType *SoapAPIType `json:"apiType,omitempty"`

	// API identifier of the source API.
	SourceAPIID *string `json:"sourceApiId,omitempty"`

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string `json:"termsOfServiceUrl,omitempty"`

	// Content value when Importing an API.
	Value *string `json:"value,omitempty"`

	// Criteria to limit import of WSDL to a subset of the document.
	WsdlSelector *APICreateOrUpdatePropertiesWsdlSelector `json:"wsdlSelector,omitempty"`

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty" azure:"ro"`
}

// APICreateOrUpdatePropertiesWsdlSelector - Criteria to limit import of WSDL to a subset of the document.
type APICreateOrUpdatePropertiesWsdlSelector struct {
	// Name of endpoint(port) to import from WSDL
	WsdlEndpointName *string `json:"wsdlEndpointName,omitempty"`

	// Name of service to import from WSDL
	WsdlServiceName *string `json:"wsdlServiceName,omitempty"`
}

// APIDiagnosticClientCreateOrUpdateOptions contains the optional parameters for the APIDiagnosticClient.CreateOrUpdate method.
type APIDiagnosticClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIDiagnosticClientDeleteOptions contains the optional parameters for the APIDiagnosticClient.Delete method.
type APIDiagnosticClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIDiagnosticClientGetEntityTagOptions contains the optional parameters for the APIDiagnosticClient.GetEntityTag method.
type APIDiagnosticClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIDiagnosticClientGetOptions contains the optional parameters for the APIDiagnosticClient.Get method.
type APIDiagnosticClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIDiagnosticClientListByServiceOptions contains the optional parameters for the APIDiagnosticClient.ListByService method.
type APIDiagnosticClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIDiagnosticClientUpdateOptions contains the optional parameters for the APIDiagnosticClient.Update method.
type APIDiagnosticClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIEntityBaseContract - API base contract details.
type APIEntityBaseContract struct {
	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`

	// Description of the API Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`

	// Type of API.
	APIType *APIType `json:"type,omitempty"`

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`

	// Description of the API Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`

	// Contact information for the API.
	Contact *APIContactInformation `json:"contact,omitempty"`

	// Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`

	// License information for the API.
	License *APILicenseInformation `json:"license,omitempty"`

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string `json:"termsOfServiceUrl,omitempty"`

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty" azure:"ro"`
}

// APIExportClientGetOptions contains the optional parameters for the APIExportClient.Get method.
type APIExportClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIExportResult - API Export result.
type APIExportResult struct {
	// Format in which the API Details are exported to the Storage Blob with Sas Key valid for 5 minutes.
	ExportResultFormat *ExportResultFormat `json:"format,omitempty"`

	// ResourceId of the API which was exported.
	ID *string `json:"id,omitempty"`

	// The object defining the schema of the exported API Detail
	Value *APIExportResultValue `json:"value,omitempty"`
}

// APIExportResultValue - The object defining the schema of the exported API Detail
type APIExportResultValue struct {
	// Link to the Storage Blob containing the result of the export operation. The Blob Uri is only valid for 5 minutes.
	Link *string `json:"link,omitempty"`
}

// APIIssueAttachmentClientCreateOrUpdateOptions contains the optional parameters for the APIIssueAttachmentClient.CreateOrUpdate
// method.
type APIIssueAttachmentClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIIssueAttachmentClientDeleteOptions contains the optional parameters for the APIIssueAttachmentClient.Delete method.
type APIIssueAttachmentClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIIssueAttachmentClientGetEntityTagOptions contains the optional parameters for the APIIssueAttachmentClient.GetEntityTag
// method.
type APIIssueAttachmentClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIIssueAttachmentClientGetOptions contains the optional parameters for the APIIssueAttachmentClient.Get method.
type APIIssueAttachmentClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIIssueAttachmentClientListByServiceOptions contains the optional parameters for the APIIssueAttachmentClient.ListByService
// method.
type APIIssueAttachmentClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIIssueClientCreateOrUpdateOptions contains the optional parameters for the APIIssueClient.CreateOrUpdate method.
type APIIssueClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIIssueClientDeleteOptions contains the optional parameters for the APIIssueClient.Delete method.
type APIIssueClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIIssueClientGetEntityTagOptions contains the optional parameters for the APIIssueClient.GetEntityTag method.
type APIIssueClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIIssueClientGetOptions contains the optional parameters for the APIIssueClient.Get method.
type APIIssueClientGetOptions struct {
	// Expand the comment attachments.
	ExpandCommentsAttachments *bool
}

// APIIssueClientListByServiceOptions contains the optional parameters for the APIIssueClient.ListByService method.
type APIIssueClientListByServiceOptions struct {
	// Expand the comment attachments.
	ExpandCommentsAttachments *bool
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIIssueClientUpdateOptions contains the optional parameters for the APIIssueClient.Update method.
type APIIssueClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientCreateOrUpdateOptions contains the optional parameters for the APIIssueCommentClient.CreateOrUpdate
// method.
type APIIssueCommentClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIIssueCommentClientDeleteOptions contains the optional parameters for the APIIssueCommentClient.Delete method.
type APIIssueCommentClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientGetEntityTagOptions contains the optional parameters for the APIIssueCommentClient.GetEntityTag method.
type APIIssueCommentClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientGetOptions contains the optional parameters for the APIIssueCommentClient.Get method.
type APIIssueCommentClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientListByServiceOptions contains the optional parameters for the APIIssueCommentClient.ListByService
// method.
type APIIssueCommentClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APILicenseInformation - API license information
type APILicenseInformation struct {
	// The license name used for the API
	Name *string `json:"name,omitempty"`

	// A URL to the license used for the API. MUST be in the format of a URL
	URL *string `json:"url,omitempty"`
}

// APIOperationClientCreateOrUpdateOptions contains the optional parameters for the APIOperationClient.CreateOrUpdate method.
type APIOperationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIOperationClientDeleteOptions contains the optional parameters for the APIOperationClient.Delete method.
type APIOperationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIOperationClientGetEntityTagOptions contains the optional parameters for the APIOperationClient.GetEntityTag method.
type APIOperationClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIOperationClientGetOptions contains the optional parameters for the APIOperationClient.Get method.
type APIOperationClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIOperationClientListByAPIOptions contains the optional parameters for the APIOperationClient.ListByAPI method.
type APIOperationClientListByAPIOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | method | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | urlTemplate | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Include tags in the response.
	Tags *string
	// Number of records to return.
	Top *int32
}

// APIOperationClientUpdateOptions contains the optional parameters for the APIOperationClient.Update method.
type APIOperationClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIOperationPolicyClientCreateOrUpdateOptions contains the optional parameters for the APIOperationPolicyClient.CreateOrUpdate
// method.
type APIOperationPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIOperationPolicyClientDeleteOptions contains the optional parameters for the APIOperationPolicyClient.Delete method.
type APIOperationPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIOperationPolicyClientGetEntityTagOptions contains the optional parameters for the APIOperationPolicyClient.GetEntityTag
// method.
type APIOperationPolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIOperationPolicyClientGetOptions contains the optional parameters for the APIOperationPolicyClient.Get method.
type APIOperationPolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// APIOperationPolicyClientListByOperationOptions contains the optional parameters for the APIOperationPolicyClient.ListByOperation
// method.
type APIOperationPolicyClientListByOperationOptions struct {
	// placeholder for future optional parameters
}

// APIPolicyClientCreateOrUpdateOptions contains the optional parameters for the APIPolicyClient.CreateOrUpdate method.
type APIPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIPolicyClientDeleteOptions contains the optional parameters for the APIPolicyClient.Delete method.
type APIPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIPolicyClientGetEntityTagOptions contains the optional parameters for the APIPolicyClient.GetEntityTag method.
type APIPolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIPolicyClientGetOptions contains the optional parameters for the APIPolicyClient.Get method.
type APIPolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// APIPolicyClientListByAPIOptions contains the optional parameters for the APIPolicyClient.ListByAPI method.
type APIPolicyClientListByAPIOptions struct {
	// placeholder for future optional parameters
}

// APIProductClientListByApisOptions contains the optional parameters for the APIProductClient.ListByApis method.
type APIProductClientListByApisOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIReleaseClientCreateOrUpdateOptions contains the optional parameters for the APIReleaseClient.CreateOrUpdate method.
type APIReleaseClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIReleaseClientDeleteOptions contains the optional parameters for the APIReleaseClient.Delete method.
type APIReleaseClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIReleaseClientGetEntityTagOptions contains the optional parameters for the APIReleaseClient.GetEntityTag method.
type APIReleaseClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIReleaseClientGetOptions contains the optional parameters for the APIReleaseClient.Get method.
type APIReleaseClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIReleaseClientListByServiceOptions contains the optional parameters for the APIReleaseClient.ListByService method.
type APIReleaseClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | notes | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIReleaseClientUpdateOptions contains the optional parameters for the APIReleaseClient.Update method.
type APIReleaseClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIReleaseCollection - Paged ApiRelease list representation.
type APIReleaseCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*APIReleaseContract `json:"value,omitempty" azure:"ro"`
}

// APIReleaseContract - ApiRelease details.
type APIReleaseContract struct {
	// ApiRelease entity contract properties.
	Properties *APIReleaseContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// APIReleaseContractProperties - API Release details
type APIReleaseContractProperties struct {
	// Identifier of the API the release belongs to.
	APIID *string `json:"apiId,omitempty"`

	// Release Notes
	Notes *string `json:"notes,omitempty"`

	// READ-ONLY; The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The time the API release was updated.
	UpdatedDateTime *time.Time `json:"updatedDateTime,omitempty" azure:"ro"`
}

// APIRevisionClientListByServiceOptions contains the optional parameters for the APIRevisionClient.ListByService method.
type APIRevisionClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | apiRevision | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIRevisionCollection - Paged API Revision list representation.
type APIRevisionCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*APIRevisionContract `json:"value,omitempty" azure:"ro"`
}

// APIRevisionContract - Summary of revision metadata.
type APIRevisionContract struct {
	// READ-ONLY; Identifier of the API Revision.
	APIID *string `json:"apiId,omitempty" azure:"ro"`

	// READ-ONLY; Revision number of API.
	APIRevision *string `json:"apiRevision,omitempty" azure:"ro"`

	// READ-ONLY; The time the API Revision was created. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Description of the API Revision.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsCurrent *bool `json:"isCurrent,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if API revision is the current api revision.
	IsOnline *bool `json:"isOnline,omitempty" azure:"ro"`

	// READ-ONLY; Gateway URL for accessing the non-current API Revision.
	PrivateURL *string `json:"privateUrl,omitempty" azure:"ro"`

	// READ-ONLY; The time the API Revision were updated. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	UpdatedDateTime *time.Time `json:"updatedDateTime,omitempty" azure:"ro"`
}

// APIRevisionInfoContract - Object used to create an API Revision or Version based on an existing API Revision
type APIRevisionInfoContract struct {
	// Description of new API Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`

	// Version identifier for the new API Version.
	APIVersionName *string `json:"apiVersionName,omitempty"`

	// Version set details
	APIVersionSet *APIVersionSetContractDetails `json:"apiVersionSet,omitempty"`

	// Resource identifier of API to be used to create the revision from.
	SourceAPIID *string `json:"sourceApiId,omitempty"`
}

// APISchemaClientBeginCreateOrUpdateOptions contains the optional parameters for the APISchemaClient.BeginCreateOrUpdate
// method.
type APISchemaClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APISchemaClientDeleteOptions contains the optional parameters for the APISchemaClient.Delete method.
type APISchemaClientDeleteOptions struct {
	// If true removes all references to the schema before deleting it.
	Force *bool
}

// APISchemaClientGetEntityTagOptions contains the optional parameters for the APISchemaClient.GetEntityTag method.
type APISchemaClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APISchemaClientGetOptions contains the optional parameters for the APISchemaClient.Get method.
type APISchemaClientGetOptions struct {
	// placeholder for future optional parameters
}

// APISchemaClientListByAPIOptions contains the optional parameters for the APISchemaClient.ListByAPI method.
type APISchemaClientListByAPIOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | contentType | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APITagDescriptionClientCreateOrUpdateOptions contains the optional parameters for the APITagDescriptionClient.CreateOrUpdate
// method.
type APITagDescriptionClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APITagDescriptionClientDeleteOptions contains the optional parameters for the APITagDescriptionClient.Delete method.
type APITagDescriptionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APITagDescriptionClientGetEntityTagOptions contains the optional parameters for the APITagDescriptionClient.GetEntityTag
// method.
type APITagDescriptionClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APITagDescriptionClientGetOptions contains the optional parameters for the APITagDescriptionClient.Get method.
type APITagDescriptionClientGetOptions struct {
	// placeholder for future optional parameters
}

// APITagDescriptionClientListByServiceOptions contains the optional parameters for the APITagDescriptionClient.ListByService
// method.
type APITagDescriptionClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APITagResourceContractProperties - API contract properties for the Tag Resources.
type APITagResourceContractProperties struct {
	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`

	// Description of the API Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`

	// Type of API.
	APIType *APIType `json:"type,omitempty"`

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`

	// Description of the API Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`

	// Contact information for the API.
	Contact *APIContactInformation `json:"contact,omitempty"`

	// Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// API identifier in the form /apis/{apiId}.
	ID *string `json:"id,omitempty"`

	// Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`

	// License information for the API.
	License *APILicenseInformation `json:"license,omitempty"`

	// API name.
	Name *string `json:"name,omitempty"`

	// Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It
	// is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol `json:"protocols,omitempty"`

	// Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string `json:"termsOfServiceUrl,omitempty"`

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty" azure:"ro"`
}

// APIUpdateContract - API update contract details.
type APIUpdateContract struct {
	// Properties of the API entity that can be updated.
	Properties *APIContractUpdateProperties `json:"properties,omitempty"`
}

// APIVersionConstraint - Control Plane Apis version constraint for the API Management service.
type APIVersionConstraint struct {
	// Limit control plane API calls to API Management service with version equal to or newer than this value.
	MinAPIVersion *string `json:"minApiVersion,omitempty"`
}

// APIVersionSetClientCreateOrUpdateOptions contains the optional parameters for the APIVersionSetClient.CreateOrUpdate method.
type APIVersionSetClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIVersionSetClientDeleteOptions contains the optional parameters for the APIVersionSetClient.Delete method.
type APIVersionSetClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIVersionSetClientGetEntityTagOptions contains the optional parameters for the APIVersionSetClient.GetEntityTag method.
type APIVersionSetClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIVersionSetClientGetOptions contains the optional parameters for the APIVersionSetClient.Get method.
type APIVersionSetClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIVersionSetClientListByServiceOptions contains the optional parameters for the APIVersionSetClient.ListByService method.
type APIVersionSetClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// APIVersionSetClientUpdateOptions contains the optional parameters for the APIVersionSetClient.Update method.
type APIVersionSetClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIVersionSetCollection - Paged API Version Set list representation.
type APIVersionSetCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*APIVersionSetContract `json:"value,omitempty"`
}

// APIVersionSetContract - API Version Set Contract details.
type APIVersionSetContract struct {
	// API VersionSet contract properties.
	Properties *APIVersionSetContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// APIVersionSetContractDetails - An API Version Set contains the common configuration for a set of API Versions relating
type APIVersionSetContractDetails struct {
	// Description of API Version Set.
	Description *string `json:"description,omitempty"`

	// Identifier for existing API Version Set. Omit this value to create a new Version Set.
	ID *string `json:"id,omitempty"`

	// The display Name of the API Version Set.
	Name *string `json:"name,omitempty"`

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string `json:"versionQueryName,omitempty"`

	// An value that determines where the API Version identifier will be located in a HTTP request.
	VersioningScheme *APIVersionSetContractDetailsVersioningScheme `json:"versioningScheme,omitempty"`
}

// APIVersionSetContractProperties - Properties of an API Version Set.
type APIVersionSetContractProperties struct {
	// REQUIRED; Name of API Version Set
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; An value that determines where the API Version identifier will be located in a HTTP request.
	VersioningScheme *VersioningScheme `json:"versioningScheme,omitempty"`

	// Description of API Version Set.
	Description *string `json:"description,omitempty"`

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string `json:"versionQueryName,omitempty"`
}

// APIVersionSetEntityBase - API Version set base parameters
type APIVersionSetEntityBase struct {
	// Description of API Version Set.
	Description *string `json:"description,omitempty"`

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string `json:"versionQueryName,omitempty"`
}

// APIVersionSetUpdateParameters - Parameters to update or create an API Version Set Contract.
type APIVersionSetUpdateParameters struct {
	// Parameters to update or create an API Version Set Contract.
	Properties *APIVersionSetUpdateParametersProperties `json:"properties,omitempty"`
}

// APIVersionSetUpdateParametersProperties - Properties used to create or update an API Version Set.
type APIVersionSetUpdateParametersProperties struct {
	// Description of API Version Set.
	Description *string `json:"description,omitempty"`

	// Name of API Version Set
	DisplayName *string `json:"displayName,omitempty"`

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string `json:"versionQueryName,omitempty"`

	// An value that determines where the API Version identifier will be located in a HTTP request.
	VersioningScheme *VersioningScheme `json:"versioningScheme,omitempty"`
}

// AccessInformationCollection - Paged AccessInformation list representation.
type AccessInformationCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*AccessInformationContract `json:"value,omitempty" azure:"ro"`
}

// AccessInformationContract - Tenant Settings.
type AccessInformationContract struct {
	// AccessInformation entity contract properties.
	Properties *AccessInformationContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccessInformationContractProperties - Tenant access information contract of the API Management service.
type AccessInformationContractProperties struct {
	// Determines whether direct access is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Access Information type ('access' or 'gitAccess')
	ID *string `json:"id,omitempty"`

	// Principal (User) Identifier.
	PrincipalID *string `json:"principalId,omitempty"`
}

// AccessInformationCreateParameterProperties - Tenant access information update parameters of the API Management service
type AccessInformationCreateParameterProperties struct {
	// Determines whether direct access is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Primary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Principal (User) Identifier.
	PrincipalID *string `json:"principalId,omitempty"`

	// Secondary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
	// value.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// AccessInformationCreateParameters - Tenant access information update parameters.
type AccessInformationCreateParameters struct {
	// Tenant access information update parameter properties.
	Properties *AccessInformationCreateParameterProperties `json:"properties,omitempty"`
}

// AccessInformationSecretsContract - Tenant access information contract of the API Management service.
type AccessInformationSecretsContract struct {
	// Determines whether direct access is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Access Information type ('access' or 'gitAccess')
	ID *string `json:"id,omitempty"`

	// Primary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Principal (User) Identifier.
	PrincipalID *string `json:"principalId,omitempty"`

	// Secondary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
	// value.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// AccessInformationUpdateParameterProperties - Tenant access information update parameters of the API Management service
type AccessInformationUpdateParameterProperties struct {
	// Determines whether direct access is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// AccessInformationUpdateParameters - Tenant access information update parameters.
type AccessInformationUpdateParameters struct {
	// Tenant access information update parameter properties.
	Properties *AccessInformationUpdateParameterProperties `json:"properties,omitempty"`
}

// AdditionalLocation - Description of an additional API Management resource location.
type AdditionalLocation struct {
	// REQUIRED; The location name of the additional region among Azure Data center regions.
	Location *string `json:"location,omitempty"`

	// REQUIRED; SKU properties of the API Management service.
	SKU *ServiceSKUProperties `json:"sku,omitempty"`

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in this additional location.
	DisableGateway *bool `json:"disableGateway,omitempty"`

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the location. Supported
	// only for Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`

	// Virtual network configuration for the location.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Gateway URL of the API Management service in the Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Compute Platform Version running the service.
	PlatformVersion *PlatformVersion `json:"platformVersion,omitempty" azure:"ro"`

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service which is deployed in an Internal Virtual
	// Network in a particular additional location. Available only for Basic, Standard,
	// Premium and Isolated SKU.
	PrivateIPAddresses []*string `json:"privateIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in the additional location. Available
	// only for Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string `json:"publicIPAddresses,omitempty" azure:"ro"`
}

// ApimResource - The Resource definition.
type ApimResource struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ArmIDWrapper - A wrapper for an ARM resource id
type ArmIDWrapper struct {
	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`
}

// AssociationContract - Association entity details.
type AssociationContract struct {
	// Association entity contract properties.
	Properties *AssociationContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssociationContractProperties - Association entity contract properties.
type AssociationContractProperties struct {
	// Provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AuthenticationSettingsContract - API Authentication Settings.
type AuthenticationSettingsContract struct {
	// OAuth2 Authentication settings
	OAuth2 *OAuth2AuthenticationSettingsContract `json:"oAuth2,omitempty"`

	// OpenID Connect Authentication Settings
	Openid *OpenIDAuthenticationSettingsContract `json:"openid,omitempty"`
}

// AuthorizationServerClientCreateOrUpdateOptions contains the optional parameters for the AuthorizationServerClient.CreateOrUpdate
// method.
type AuthorizationServerClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// AuthorizationServerClientDeleteOptions contains the optional parameters for the AuthorizationServerClient.Delete method.
type AuthorizationServerClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientGetEntityTagOptions contains the optional parameters for the AuthorizationServerClient.GetEntityTag
// method.
type AuthorizationServerClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientGetOptions contains the optional parameters for the AuthorizationServerClient.Get method.
type AuthorizationServerClientGetOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientListByServiceOptions contains the optional parameters for the AuthorizationServerClient.ListByService
// method.
type AuthorizationServerClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// AuthorizationServerClientListSecretsOptions contains the optional parameters for the AuthorizationServerClient.ListSecrets
// method.
type AuthorizationServerClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientUpdateOptions contains the optional parameters for the AuthorizationServerClient.Update method.
type AuthorizationServerClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerCollection - Paged OAuth2 Authorization Servers list representation.
type AuthorizationServerCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*AuthorizationServerContract `json:"value,omitempty"`
}

// AuthorizationServerContract - External OAuth authorization server settings.
type AuthorizationServerContract struct {
	// Properties of the External OAuth authorization server Contract.
	Properties *AuthorizationServerContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AuthorizationServerContractBaseProperties - External OAuth authorization server Update settings contract.
type AuthorizationServerContractBaseProperties struct {
	// HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods []*AuthorizationMethod `json:"authorizationMethods,omitempty"`

	// Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods []*BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`

	// Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or
	// Body. When Body is specified, client credentials and other parameters are passed
	// within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod []*ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`

	// Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in
	// the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`

	// Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`

	// If true, authorization server will include state parameter from the authorization request to its response. Client may use
	// state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`

	// Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects
	// with name and value string properties, i.e. {"name" : "name value", "value":
	// "a value"}.
	TokenBodyParameters []*TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`

	// OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
}

// AuthorizationServerContractProperties - External OAuth authorization server settings Properties.
type AuthorizationServerContractProperties struct {
	// REQUIRED; OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`

	// REQUIRED; Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`

	// REQUIRED; Optional reference to a page where client or app registration for this authorization server is performed. Contains
	// absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`

	// REQUIRED; User-friendly authorization server name.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; Form of an authorization grant, which the client uses to request the access token.
	GrantTypes []*GrantType `json:"grantTypes,omitempty"`

	// HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods []*AuthorizationMethod `json:"authorizationMethods,omitempty"`

	// Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods []*BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`

	// Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or
	// Body. When Body is specified, client credentials and other parameters are passed
	// within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod []*ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`

	// Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use
	// '/listSecrets' POST request to get the value.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in
	// the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`

	// Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`

	// If true, authorization server will include state parameter from the authorization request to its response. Client may use
	// state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`

	// Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects
	// with name and value string properties, i.e. {"name" : "name value", "value":
	// "a value"}.
	TokenBodyParameters []*TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`

	// OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
}

// AuthorizationServerSecretsContract - OAuth Server Secrets Contract.
type AuthorizationServerSecretsContract struct {
	// oAuth Authorization Server Secrets.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
}

// AuthorizationServerUpdateContract - External OAuth authorization server settings.
type AuthorizationServerUpdateContract struct {
	// Properties of the External OAuth authorization server update Contract.
	Properties *AuthorizationServerUpdateContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AuthorizationServerUpdateContractProperties - External OAuth authorization server Update settings contract.
type AuthorizationServerUpdateContractProperties struct {
	// OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`

	// HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods []*AuthorizationMethod `json:"authorizationMethods,omitempty"`

	// Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods []*BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`

	// Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or
	// Body. When Body is specified, client credentials and other parameters are passed
	// within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod []*ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`

	// Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`

	// Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute
	// URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`

	// Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use
	// '/listSecrets' POST request to get the value.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in
	// the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`

	// Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// User-friendly authorization server name.
	DisplayName *string `json:"displayName,omitempty"`

	// Form of an authorization grant, which the client uses to request the access token.
	GrantTypes []*GrantType `json:"grantTypes,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`

	// If true, authorization server will include state parameter from the authorization request to its response. Client may use
	// state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`

	// Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects
	// with name and value string properties, i.e. {"name" : "name value", "value":
	// "a value"}.
	TokenBodyParameters []*TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`

	// OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
}

// BackendAuthorizationHeaderCredentials - Authorization header information.
type BackendAuthorizationHeaderCredentials struct {
	// REQUIRED; Authentication Parameter value.
	Parameter *string `json:"parameter,omitempty"`

	// REQUIRED; Authentication Scheme name.
	Scheme *string `json:"scheme,omitempty"`
}

// BackendBaseParameters - Backend entity base Parameter set.
type BackendBaseParameters struct {
	// Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`

	// Backend Description.
	Description *string `json:"description,omitempty"`

	// Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`

	// Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`

	// Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or
	// API Apps.
	ResourceID *string `json:"resourceId,omitempty"`

	// Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`

	// Backend Title.
	Title *string `json:"title,omitempty"`
}

// BackendClientCreateOrUpdateOptions contains the optional parameters for the BackendClient.CreateOrUpdate method.
type BackendClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// BackendClientDeleteOptions contains the optional parameters for the BackendClient.Delete method.
type BackendClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BackendClientGetEntityTagOptions contains the optional parameters for the BackendClient.GetEntityTag method.
type BackendClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// BackendClientGetOptions contains the optional parameters for the BackendClient.Get method.
type BackendClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackendClientListByServiceOptions contains the optional parameters for the BackendClient.ListByService method.
type BackendClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | title | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | url | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// BackendClientReconnectOptions contains the optional parameters for the BackendClient.Reconnect method.
type BackendClientReconnectOptions struct {
	// Reconnect request parameters.
	Parameters *BackendReconnectContract
}

// BackendClientUpdateOptions contains the optional parameters for the BackendClient.Update method.
type BackendClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BackendCollection - Paged Backend list representation.
type BackendCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Backend values.
	Value []*BackendContract `json:"value,omitempty"`
}

// BackendContract - Backend details.
type BackendContract struct {
	// Backend entity contract properties.
	Properties *BackendContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackendContractProperties - Parameters supplied to the Create Backend operation.
type BackendContractProperties struct {
	// REQUIRED; Backend communication protocol.
	Protocol *BackendProtocol `json:"protocol,omitempty"`

	// REQUIRED; Runtime Url of the Backend.
	URL *string `json:"url,omitempty"`

	// Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`

	// Backend Description.
	Description *string `json:"description,omitempty"`

	// Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`

	// Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`

	// Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or
	// API Apps.
	ResourceID *string `json:"resourceId,omitempty"`

	// Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`

	// Backend Title.
	Title *string `json:"title,omitempty"`
}

// BackendCredentialsContract - Details of the Credentials used to connect to Backend.
type BackendCredentialsContract struct {
	// Authorization header authentication
	Authorization *BackendAuthorizationHeaderCredentials `json:"authorization,omitempty"`

	// List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
	Certificate []*string `json:"certificate,omitempty"`

	// List of Client Certificate Ids.
	CertificateIDs []*string `json:"certificateIds,omitempty"`

	// Header Parameter description.
	Header map[string][]*string `json:"header,omitempty"`

	// Query Parameter description.
	Query map[string][]*string `json:"query,omitempty"`
}

// BackendProperties - Properties specific to the Backend Type.
type BackendProperties struct {
	// Backend Service Fabric Cluster Properties
	ServiceFabricCluster *BackendServiceFabricClusterProperties `json:"serviceFabricCluster,omitempty"`
}

// BackendProxyContract - Details of the Backend WebProxy Server to use in the Request to Backend.
type BackendProxyContract struct {
	// REQUIRED; WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all
	// fragments and query strings.
	URL *string `json:"url,omitempty"`

	// Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`

	// Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
}

// BackendReconnectContract - Reconnect request parameters.
type BackendReconnectContract struct {
	// Reconnect request properties.
	Properties *BackendReconnectProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackendReconnectProperties - Properties to control reconnect requests.
type BackendReconnectProperties struct {
	// Duration in ISO8601 format after which reconnect will be initiated. Minimum duration of the Reconnect is PT2M.
	After *string `json:"after,omitempty"`
}

// BackendServiceFabricClusterProperties - Properties of the Service Fabric Type Backend.
type BackendServiceFabricClusterProperties struct {
	// REQUIRED; The cluster management endpoint.
	ManagementEndpoints []*string `json:"managementEndpoints,omitempty"`

	// The client certificate id for the management endpoint.
	ClientCertificateID *string `json:"clientCertificateId,omitempty"`

	// The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
	ClientCertificatethumbprint *string `json:"clientCertificatethumbprint,omitempty"`

	// Maximum number of retries while attempting resolve the partition.
	MaxPartitionResolutionRetries *int32 `json:"maxPartitionResolutionRetries,omitempty"`

	// Thumbprints of certificates cluster management service uses for tls communication
	ServerCertificateThumbprints []*string `json:"serverCertificateThumbprints,omitempty"`

	// Server X509 Certificate Names Collection
	ServerX509Names []*X509CertificateName `json:"serverX509Names,omitempty"`
}

// BackendTLSProperties - Properties controlling TLS Certificate Validation.
type BackendTLSProperties struct {
	// Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend
	// host.
	ValidateCertificateChain *bool `json:"validateCertificateChain,omitempty"`

	// Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend
	// host.
	ValidateCertificateName *bool `json:"validateCertificateName,omitempty"`
}

// BackendUpdateParameterProperties - Parameters supplied to the Update Backend operation.
type BackendUpdateParameterProperties struct {
	// Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`

	// Backend Description.
	Description *string `json:"description,omitempty"`

	// Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`

	// Backend communication protocol.
	Protocol *BackendProtocol `json:"protocol,omitempty"`

	// Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`

	// Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or
	// API Apps.
	ResourceID *string `json:"resourceId,omitempty"`

	// Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`

	// Backend Title.
	Title *string `json:"title,omitempty"`

	// Runtime Url of the Backend.
	URL *string `json:"url,omitempty"`
}

// BackendUpdateParameters - Backend update parameters.
type BackendUpdateParameters struct {
	// Backend entity update contract properties.
	Properties *BackendUpdateParameterProperties `json:"properties,omitempty"`
}

// BodyDiagnosticSettings - Body logging settings.
type BodyDiagnosticSettings struct {
	// Number of request body bytes to log.
	Bytes *int32 `json:"bytes,omitempty"`
}

// CacheClientCreateOrUpdateOptions contains the optional parameters for the CacheClient.CreateOrUpdate method.
type CacheClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// CacheClientDeleteOptions contains the optional parameters for the CacheClient.Delete method.
type CacheClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CacheClientGetEntityTagOptions contains the optional parameters for the CacheClient.GetEntityTag method.
type CacheClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// CacheClientGetOptions contains the optional parameters for the CacheClient.Get method.
type CacheClientGetOptions struct {
	// placeholder for future optional parameters
}

// CacheClientListByServiceOptions contains the optional parameters for the CacheClient.ListByService method.
type CacheClientListByServiceOptions struct {
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// CacheClientUpdateOptions contains the optional parameters for the CacheClient.Update method.
type CacheClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CacheCollection - Paged Caches list representation.
type CacheCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*CacheContract `json:"value,omitempty"`
}

// CacheContract - Cache details.
type CacheContract struct {
	// Cache properties details.
	Properties *CacheContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CacheContractProperties - Properties of the Cache contract.
type CacheContractProperties struct {
	// REQUIRED; Runtime connection string to cache
	ConnectionString *string `json:"connectionString,omitempty"`

	// REQUIRED; Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
	UseFromLocation *string `json:"useFromLocation,omitempty"`

	// Cache description
	Description *string `json:"description,omitempty"`

	// Original uri of entity in external system cache points to
	ResourceID *string `json:"resourceId,omitempty"`
}

// CacheUpdateParameters - Cache update details.
type CacheUpdateParameters struct {
	// Cache update properties details.
	Properties *CacheUpdateProperties `json:"properties,omitempty"`
}

// CacheUpdateProperties - Parameters supplied to the Update Cache operation.
type CacheUpdateProperties struct {
	// Runtime connection string to cache
	ConnectionString *string `json:"connectionString,omitempty"`

	// Cache description
	Description *string `json:"description,omitempty"`

	// Original uri of entity in external system cache points to
	ResourceID *string `json:"resourceId,omitempty"`

	// Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
	UseFromLocation *string `json:"useFromLocation,omitempty"`
}

// CertificateClientCreateOrUpdateOptions contains the optional parameters for the CertificateClient.CreateOrUpdate method.
type CertificateClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// CertificateClientDeleteOptions contains the optional parameters for the CertificateClient.Delete method.
type CertificateClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientGetEntityTagOptions contains the optional parameters for the CertificateClient.GetEntityTag method.
type CertificateClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientGetOptions contains the optional parameters for the CertificateClient.Get method.
type CertificateClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientListByServiceOptions contains the optional parameters for the CertificateClient.ListByService method.
type CertificateClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | subject | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | thumbprint | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | expirationDate | filter | ge, le, eq, ne, gt, lt | |
	Filter *string
	// When set to true, the response contains only certificates entities which failed refresh.
	IsKeyVaultRefreshFailed *bool
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// CertificateClientRefreshSecretOptions contains the optional parameters for the CertificateClient.RefreshSecret method.
type CertificateClientRefreshSecretOptions struct {
	// placeholder for future optional parameters
}

// CertificateCollection - Paged Certificates list representation.
type CertificateCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*CertificateContract `json:"value,omitempty"`
}

// CertificateConfiguration - Certificate configuration which consist of non-trusted intermediates and root certificates.
type CertificateConfiguration struct {
	// REQUIRED; The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority
	// are valid locations.
	StoreName *CertificateConfigurationStoreName `json:"storeName,omitempty"`

	// Certificate information.
	Certificate *CertificateInformation `json:"certificate,omitempty"`

	// Certificate Password.
	CertificatePassword *string `json:"certificatePassword,omitempty"`

	// Base64 Encoded certificate.
	EncodedCertificate *string `json:"encodedCertificate,omitempty"`
}

// CertificateContract - Certificate details.
type CertificateContract struct {
	// Certificate properties details.
	Properties *CertificateContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificateContractProperties - Properties of the Certificate contract.
type CertificateContractProperties struct {
	// REQUIRED; Expiration date of the certificate. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// REQUIRED; Subject attribute of the certificate.
	Subject *string `json:"subject,omitempty"`

	// REQUIRED; Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// KeyVault location details of the certificate.
	KeyVault *KeyVaultContractProperties `json:"keyVault,omitempty"`
}

// CertificateCreateOrUpdateParameters - Certificate create or update details.
type CertificateCreateOrUpdateParameters struct {
	// Certificate create or update properties details.
	Properties *CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
}

// CertificateCreateOrUpdateProperties - Parameters supplied to the CreateOrUpdate certificate operation.
type CertificateCreateOrUpdateProperties struct {
	// Base 64 encoded certificate using the application/x-pkcs12 representation.
	Data *string `json:"data,omitempty"`

	// KeyVault location details of the certificate.
	KeyVault *KeyVaultContractCreateProperties `json:"keyVault,omitempty"`

	// Password for the Certificate
	Password *string `json:"password,omitempty"`
}

// CertificateInformation - SSL certificate information.
type CertificateInformation struct {
	// REQUIRED; Expiration date of the certificate. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	Expiry *time.Time `json:"expiry,omitempty"`

	// REQUIRED; Subject of the certificate.
	Subject *string `json:"subject,omitempty"`

	// REQUIRED; Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// ClientBeginPerformConnectivityCheckAsyncOptions contains the optional parameters for the Client.BeginPerformConnectivityCheckAsync
// method.
type ClientBeginPerformConnectivityCheckAsyncOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientSecretContract - Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
type ClientSecretContract struct {
	// Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// ConnectivityCheckRequest - A request to perform the connectivity check operation on a API Management service.
type ConnectivityCheckRequest struct {
	// REQUIRED; The connectivity check operation destination.
	Destination *ConnectivityCheckRequestDestination `json:"destination,omitempty"`

	// REQUIRED; Definitions about the connectivity check origin.
	Source *ConnectivityCheckRequestSource `json:"source,omitempty"`

	// The IP version to be used. Only IPv4 is supported for now.
	PreferredIPVersion *PreferredIPVersion `json:"preferredIPVersion,omitempty"`

	// The request's protocol. Specific protocol configuration can be available based on this selection. The specified destination
	// address must be coherent with this value.
	Protocol *ConnectivityCheckProtocol `json:"protocol,omitempty"`

	// Protocol-specific configuration.
	ProtocolConfiguration *ConnectivityCheckRequestProtocolConfiguration `json:"protocolConfiguration,omitempty"`
}

// ConnectivityCheckRequestDestination - The connectivity check operation destination.
type ConnectivityCheckRequestDestination struct {
	// REQUIRED; Destination address. Can either be an IP address or a FQDN.
	Address *string `json:"address,omitempty"`

	// REQUIRED; Destination port.
	Port *int64 `json:"port,omitempty"`
}

// ConnectivityCheckRequestProtocolConfiguration - Protocol-specific configuration.
type ConnectivityCheckRequestProtocolConfiguration struct {
	// Configuration for HTTP or HTTPS requests.
	HTTPConfiguration *ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration `json:"HTTPConfiguration,omitempty"`
}

// ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration - Configuration for HTTP or HTTPS requests.
type ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration struct {
	// List of headers to be included in the request.
	Headers []*HTTPHeader `json:"headers,omitempty"`

	// The HTTP method to be used.
	Method *Method `json:"method,omitempty"`

	// List of HTTP status codes considered valid for the request response.
	ValidStatusCodes []*int64 `json:"validStatusCodes,omitempty"`
}

// ConnectivityCheckRequestSource - Definitions about the connectivity check origin.
type ConnectivityCheckRequestSource struct {
	// REQUIRED; The API Management service region from where to start the connectivity check operation.
	Region *string `json:"region,omitempty"`

	// The particular VMSS instance from which to fire the request.
	Instance *int64 `json:"instance,omitempty"`
}

// ConnectivityCheckResponse - Information on the connectivity status.
type ConnectivityCheckResponse struct {
	// READ-ONLY; Average latency in milliseconds.
	AvgLatencyInMs *int64 `json:"avgLatencyInMs,omitempty" azure:"ro"`

	// READ-ONLY; The connection status.
	ConnectionStatus *ConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; List of hops between the source and the destination.
	Hops []*ConnectivityHop `json:"hops,omitempty" azure:"ro"`

	// READ-ONLY; Maximum latency in milliseconds.
	MaxLatencyInMs *int64 `json:"maxLatencyInMs,omitempty" azure:"ro"`

	// READ-ONLY; Minimum latency in milliseconds.
	MinLatencyInMs *int64 `json:"minLatencyInMs,omitempty" azure:"ro"`

	// READ-ONLY; Number of failed probes.
	ProbesFailed *int64 `json:"probesFailed,omitempty" azure:"ro"`

	// READ-ONLY; Total number of probes sent.
	ProbesSent *int64 `json:"probesSent,omitempty" azure:"ro"`
}

// ConnectivityHop - Information about a hop between the source and the destination.
type ConnectivityHop struct {
	// READ-ONLY; The IP address of the hop.
	Address *string `json:"address,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the hop.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; List of issues.
	Issues []*ConnectivityIssue `json:"issues,omitempty" azure:"ro"`

	// READ-ONLY; List of next hop identifiers.
	NextHopIDs []*string `json:"nextHopIds,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the resource corresponding to this hop.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; The type of the hop.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectivityIssue - Information about an issue encountered in the process of checking for connectivity.
type ConnectivityIssue struct {
	// READ-ONLY; Provides additional context on the issue.
	Context []map[string]*string `json:"context,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the issue.
	Origin *Origin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; The severity of the issue.
	Severity *Severity `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; The type of issue.
	Type *IssueType `json:"type,omitempty" azure:"ro"`
}

// ConnectivityStatusContract - Details about connectivity to a resource.
type ConnectivityStatusContract struct {
	// REQUIRED; Whether this is optional.
	IsOptional *bool `json:"isOptional,omitempty"`

	// REQUIRED; The date when the resource connectivity status last Changed from success to failure or vice-versa. The date conforms
	// to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	LastStatusChange *time.Time `json:"lastStatusChange,omitempty"`

	// REQUIRED; The date when the resource connectivity status was last updated. This status should be updated every 15 minutes.
	// If this status has not been updated, then it means that the service has lost network
	// connectivity to the resource, from inside the Virtual Network.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	LastUpdated *time.Time `json:"lastUpdated,omitempty"`

	// REQUIRED; The hostname of the resource which the service depends on. This can be the database, storage or any other azure
	// resource on which the service depends upon.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Resource Type.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Resource Connectivity Status Type identifier.
	Status *ConnectivityStatusType `json:"status,omitempty"`

	// Error details of the connectivity to the resource.
	Error *string `json:"error,omitempty"`
}

// ContentItemClientCreateOrUpdateOptions contains the optional parameters for the ContentItemClient.CreateOrUpdate method.
type ContentItemClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ContentItemClientDeleteOptions contains the optional parameters for the ContentItemClient.Delete method.
type ContentItemClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContentItemClientGetEntityTagOptions contains the optional parameters for the ContentItemClient.GetEntityTag method.
type ContentItemClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// ContentItemClientGetOptions contains the optional parameters for the ContentItemClient.Get method.
type ContentItemClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContentItemClientListByServiceOptions contains the optional parameters for the ContentItemClient.ListByService method.
type ContentItemClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// ContentItemCollection - Paged list of content items.
type ContentItemCollection struct {
	// READ-ONLY; Next page link, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of content items.
	Value []*ContentItemContract `json:"value,omitempty" azure:"ro"`
}

// ContentItemContract - Content type contract details.
type ContentItemContract struct {
	// Properties of the content item.
	Properties map[string]interface{} `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContentTypeClientCreateOrUpdateOptions contains the optional parameters for the ContentTypeClient.CreateOrUpdate method.
type ContentTypeClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ContentTypeClientDeleteOptions contains the optional parameters for the ContentTypeClient.Delete method.
type ContentTypeClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContentTypeClientGetOptions contains the optional parameters for the ContentTypeClient.Get method.
type ContentTypeClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContentTypeClientListByServiceOptions contains the optional parameters for the ContentTypeClient.ListByService method.
type ContentTypeClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// ContentTypeCollection - Paged list of content types.
type ContentTypeCollection struct {
	// READ-ONLY; Next page link, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of content types.
	Value []*ContentTypeContract `json:"value,omitempty" azure:"ro"`
}

// ContentTypeContract - Content type contract details.
type ContentTypeContract struct {
	// Properties of the content type.
	Properties *ContentTypeContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ContentTypeContractProperties struct {
	// Content type description.
	Description *string `json:"description,omitempty"`

	// Content type identifier
	ID *string `json:"id,omitempty"`

	// Content type name. Must be 1 to 250 characters long.
	Name *string `json:"name,omitempty"`

	// Content type schema.
	Schema interface{} `json:"schema,omitempty"`

	// Content type version.
	Version *string `json:"version,omitempty"`
}

type DataMasking struct {
	// Masking settings for headers
	Headers []*DataMaskingEntity `json:"headers,omitempty"`

	// Masking settings for Url query parameters
	QueryParams []*DataMaskingEntity `json:"queryParams,omitempty"`
}

type DataMaskingEntity struct {
	// Data masking mode.
	Mode *DataMaskingMode `json:"mode,omitempty"`

	// The name of an entity to mask (e.g. a name of a header or a query parameter).
	Value *string `json:"value,omitempty"`
}

// DelegationSettingsClientCreateOrUpdateOptions contains the optional parameters for the DelegationSettingsClient.CreateOrUpdate
// method.
type DelegationSettingsClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// DelegationSettingsClientGetEntityTagOptions contains the optional parameters for the DelegationSettingsClient.GetEntityTag
// method.
type DelegationSettingsClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// DelegationSettingsClientGetOptions contains the optional parameters for the DelegationSettingsClient.Get method.
type DelegationSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DelegationSettingsClientListSecretsOptions contains the optional parameters for the DelegationSettingsClient.ListSecrets
// method.
type DelegationSettingsClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// DelegationSettingsClientUpdateOptions contains the optional parameters for the DelegationSettingsClient.Update method.
type DelegationSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DeletedServiceContract - Deleted API Management Service information.
type DeletedServiceContract struct {
	// Deleted API Management Service details.
	Properties *DeletedServiceContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; API Management Service Master Location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type DeletedServiceContractProperties struct {
	// UTC Timestamp when the service was soft-deleted. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	DeletionDate *time.Time `json:"deletionDate,omitempty"`

	// UTC Date and Time when the service will be automatically purged. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty"`

	// Fully-qualified API Management Service Resource ID
	ServiceID *string `json:"serviceId,omitempty"`
}

// DeletedServicesClientBeginPurgeOptions contains the optional parameters for the DeletedServicesClient.BeginPurge method.
type DeletedServicesClientBeginPurgeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeletedServicesClientGetByNameOptions contains the optional parameters for the DeletedServicesClient.GetByName method.
type DeletedServicesClientGetByNameOptions struct {
	// placeholder for future optional parameters
}

// DeletedServicesClientListBySubscriptionOptions contains the optional parameters for the DeletedServicesClient.ListBySubscription
// method.
type DeletedServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DeletedServicesCollection - Paged deleted API Management Services List Representation.
type DeletedServicesCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*DeletedServiceContract `json:"value,omitempty" azure:"ro"`
}

// DeployConfigurationParameterProperties - Parameters supplied to the Deploy Configuration operation.
type DeployConfigurationParameterProperties struct {
	// REQUIRED; The name of the Git branch from which the configuration is to be deployed to the configuration database.
	Branch *string `json:"branch,omitempty"`

	// The value enforcing deleting subscriptions to products that are deleted in this update.
	Force *bool `json:"force,omitempty"`
}

// DeployConfigurationParameters - Deploy Tenant Configuration Contract.
type DeployConfigurationParameters struct {
	// Deploy Configuration Parameter contract properties.
	Properties *DeployConfigurationParameterProperties `json:"properties,omitempty"`
}

// DiagnosticClientCreateOrUpdateOptions contains the optional parameters for the DiagnosticClient.CreateOrUpdate method.
type DiagnosticClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// DiagnosticClientDeleteOptions contains the optional parameters for the DiagnosticClient.Delete method.
type DiagnosticClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticClientGetEntityTagOptions contains the optional parameters for the DiagnosticClient.GetEntityTag method.
type DiagnosticClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticClientGetOptions contains the optional parameters for the DiagnosticClient.Get method.
type DiagnosticClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticClientListByServiceOptions contains the optional parameters for the DiagnosticClient.ListByService method.
type DiagnosticClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// DiagnosticClientUpdateOptions contains the optional parameters for the DiagnosticClient.Update method.
type DiagnosticClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticCollection - Paged Diagnostic list representation.
type DiagnosticCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*DiagnosticContract `json:"value,omitempty"`
}

// DiagnosticContract - Diagnostic details.
type DiagnosticContract struct {
	// Diagnostic entity contract properties.
	Properties *DiagnosticContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticContractProperties - Diagnostic Entity Properties
type DiagnosticContractProperties struct {
	// REQUIRED; Resource Id of a target logger.
	LoggerID *string `json:"loggerId,omitempty"`

	// Specifies for what type of messages sampling settings should not apply.
	AlwaysLog *AlwaysLog `json:"alwaysLog,omitempty"`

	// Diagnostic settings for incoming/outgoing HTTP messages to the Backend
	Backend *PipelineDiagnosticSettings `json:"backend,omitempty"`

	// Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
	Frontend *PipelineDiagnosticSettings `json:"frontend,omitempty"`

	// Sets correlation protocol to use for Application Insights diagnostics.
	HTTPCorrelationProtocol *HTTPCorrelationProtocol `json:"httpCorrelationProtocol,omitempty"`

	// Log the ClientIP. Default is false.
	LogClientIP *bool `json:"logClientIp,omitempty"`

	// The format of the Operation Name for Application Insights telemetries. Default is Name.
	OperationNameFormat *OperationNameFormat `json:"operationNameFormat,omitempty"`

	// Sampling settings for Diagnostic.
	Sampling *SamplingSettings `json:"sampling,omitempty"`

	// The verbosity level applied to traces emitted by trace policies.
	Verbosity *Verbosity `json:"verbosity,omitempty"`
}

// EmailTemplateClientCreateOrUpdateOptions contains the optional parameters for the EmailTemplateClient.CreateOrUpdate method.
type EmailTemplateClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// EmailTemplateClientDeleteOptions contains the optional parameters for the EmailTemplateClient.Delete method.
type EmailTemplateClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateClientGetEntityTagOptions contains the optional parameters for the EmailTemplateClient.GetEntityTag method.
type EmailTemplateClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateClientGetOptions contains the optional parameters for the EmailTemplateClient.Get method.
type EmailTemplateClientGetOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateClientListByServiceOptions contains the optional parameters for the EmailTemplateClient.ListByService method.
type EmailTemplateClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// EmailTemplateClientUpdateOptions contains the optional parameters for the EmailTemplateClient.Update method.
type EmailTemplateClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateCollection - Paged email template list representation.
type EmailTemplateCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*EmailTemplateContract `json:"value,omitempty"`
}

// EmailTemplateContract - Email Template details.
type EmailTemplateContract struct {
	// Email Template entity contract properties.
	Properties *EmailTemplateContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EmailTemplateContractProperties - Email Template Contract properties.
type EmailTemplateContractProperties struct {
	// REQUIRED; Email Template Body. This should be a valid XDocument
	Body *string `json:"body,omitempty"`

	// REQUIRED; Subject of the Template.
	Subject *string `json:"subject,omitempty"`

	// Description of the Email Template.
	Description *string `json:"description,omitempty"`

	// Email Template Parameter values.
	Parameters []*EmailTemplateParametersContractProperties `json:"parameters,omitempty"`

	// Title of the Template.
	Title *string `json:"title,omitempty"`

	// READ-ONLY; Whether the template is the default template provided by API Management or has been edited.
	IsDefault *bool `json:"isDefault,omitempty" azure:"ro"`
}

// EmailTemplateParametersContractProperties - Email Template Parameter contract.
type EmailTemplateParametersContractProperties struct {
	// Template parameter description.
	Description *string `json:"description,omitempty"`

	// Template parameter name.
	Name *string `json:"name,omitempty"`

	// Template parameter title.
	Title *string `json:"title,omitempty"`
}

// EmailTemplateUpdateParameterProperties - Email Template Update Contract properties.
type EmailTemplateUpdateParameterProperties struct {
	// Email Template Body. This should be a valid XDocument
	Body *string `json:"body,omitempty"`

	// Description of the Email Template.
	Description *string `json:"description,omitempty"`

	// Email Template Parameter values.
	Parameters []*EmailTemplateParametersContractProperties `json:"parameters,omitempty"`

	// Subject of the Template.
	Subject *string `json:"subject,omitempty"`

	// Title of the Template.
	Title *string `json:"title,omitempty"`
}

// EmailTemplateUpdateParameters - Email Template update Parameters.
type EmailTemplateUpdateParameters struct {
	// Email Template Update contract properties.
	Properties *EmailTemplateUpdateParameterProperties `json:"properties,omitempty"`
}

// EndpointDependency - A domain name that a service is reached at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`

	// The Ports used when connecting to DomainName.
	EndpointDetails []*EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail - Current TCP connectivity information from the Api Management Service to a single endpoint.
type EndpointDetail struct {
	// The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`

	// The region of the dependency.
	Region *string `json:"region,omitempty"`
}

// ErrorFieldContract - Error Field contract.
type ErrorFieldContract struct {
	// Property level error code.
	Code *string `json:"code,omitempty"`

	// Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`

	// Property name.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse - Error Response.
type ErrorResponse struct {
	// Properties of the Error Response.
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody - Error Body contract.
type ErrorResponseBody struct {
	// Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`

	// The list of invalid fields send in request, in case of validation error.
	Details []*ErrorFieldContract `json:"details,omitempty"`

	// Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// GatewayAPIClientCreateOrUpdateOptions contains the optional parameters for the GatewayAPIClient.CreateOrUpdate method.
type GatewayAPIClientCreateOrUpdateOptions struct {
	Parameters *AssociationContract
}

// GatewayAPIClientDeleteOptions contains the optional parameters for the GatewayAPIClient.Delete method.
type GatewayAPIClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayAPIClientGetEntityTagOptions contains the optional parameters for the GatewayAPIClient.GetEntityTag method.
type GatewayAPIClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayAPIClientListByServiceOptions contains the optional parameters for the GatewayAPIClient.ListByService method.
type GatewayAPIClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// GatewayCertificateAuthorityClientCreateOrUpdateOptions contains the optional parameters for the GatewayCertificateAuthorityClient.CreateOrUpdate
// method.
type GatewayCertificateAuthorityClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GatewayCertificateAuthorityClientDeleteOptions contains the optional parameters for the GatewayCertificateAuthorityClient.Delete
// method.
type GatewayCertificateAuthorityClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayCertificateAuthorityClientGetEntityTagOptions contains the optional parameters for the GatewayCertificateAuthorityClient.GetEntityTag
// method.
type GatewayCertificateAuthorityClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayCertificateAuthorityClientGetOptions contains the optional parameters for the GatewayCertificateAuthorityClient.Get
// method.
type GatewayCertificateAuthorityClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayCertificateAuthorityClientListByServiceOptions contains the optional parameters for the GatewayCertificateAuthorityClient.ListByService
// method.
type GatewayCertificateAuthorityClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | eq, ne | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// GatewayCertificateAuthorityCollection - Paged Gateway certificate authority list representation.
type GatewayCertificateAuthorityCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*GatewayCertificateAuthorityContract `json:"value,omitempty" azure:"ro"`
}

// GatewayCertificateAuthorityContract - Gateway certificate authority details.
type GatewayCertificateAuthorityContract struct {
	// Gateway certificate authority details.
	Properties *GatewayCertificateAuthorityContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GatewayCertificateAuthorityContractProperties - Gateway certificate authority details.
type GatewayCertificateAuthorityContractProperties struct {
	// Determines whether certificate authority is trusted.
	IsTrusted *bool `json:"isTrusted,omitempty"`
}

// GatewayClientCreateOrUpdateOptions contains the optional parameters for the GatewayClient.CreateOrUpdate method.
type GatewayClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GatewayClientDeleteOptions contains the optional parameters for the GatewayClient.Delete method.
type GatewayClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientGenerateTokenOptions contains the optional parameters for the GatewayClient.GenerateToken method.
type GatewayClientGenerateTokenOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientGetEntityTagOptions contains the optional parameters for the GatewayClient.GetEntityTag method.
type GatewayClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientGetOptions contains the optional parameters for the GatewayClient.Get method.
type GatewayClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientListByServiceOptions contains the optional parameters for the GatewayClient.ListByService method.
type GatewayClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | region | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// GatewayClientListKeysOptions contains the optional parameters for the GatewayClient.ListKeys method.
type GatewayClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientRegenerateKeyOptions contains the optional parameters for the GatewayClient.RegenerateKey method.
type GatewayClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientUpdateOptions contains the optional parameters for the GatewayClient.Update method.
type GatewayClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GatewayCollection - Paged Gateway list representation.
type GatewayCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*GatewayContract `json:"value,omitempty" azure:"ro"`
}

// GatewayContract - Gateway details.
type GatewayContract struct {
	// Gateway details.
	Properties *GatewayContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GatewayContractProperties - Properties of the Gateway contract.
type GatewayContractProperties struct {
	// Gateway description
	Description *string `json:"description,omitempty"`

	// Gateway location.
	LocationData *ResourceLocationDataContract `json:"locationData,omitempty"`
}

// GatewayHostnameConfigurationClientCreateOrUpdateOptions contains the optional parameters for the GatewayHostnameConfigurationClient.CreateOrUpdate
// method.
type GatewayHostnameConfigurationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GatewayHostnameConfigurationClientDeleteOptions contains the optional parameters for the GatewayHostnameConfigurationClient.Delete
// method.
type GatewayHostnameConfigurationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayHostnameConfigurationClientGetEntityTagOptions contains the optional parameters for the GatewayHostnameConfigurationClient.GetEntityTag
// method.
type GatewayHostnameConfigurationClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayHostnameConfigurationClientGetOptions contains the optional parameters for the GatewayHostnameConfigurationClient.Get
// method.
type GatewayHostnameConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayHostnameConfigurationClientListByServiceOptions contains the optional parameters for the GatewayHostnameConfigurationClient.ListByService
// method.
type GatewayHostnameConfigurationClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | hostname | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// GatewayHostnameConfigurationCollection - Paged Gateway hostname configuration list representation.
type GatewayHostnameConfigurationCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*GatewayHostnameConfigurationContract `json:"value,omitempty" azure:"ro"`
}

// GatewayHostnameConfigurationContract - Gateway hostname configuration details.
type GatewayHostnameConfigurationContract struct {
	// Gateway hostname configuration details.
	Properties *GatewayHostnameConfigurationContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GatewayHostnameConfigurationContractProperties - Gateway hostname configuration details.
type GatewayHostnameConfigurationContractProperties struct {
	// Identifier of Certificate entity that will be used for TLS connection establishment
	CertificateID *string `json:"certificateId,omitempty"`

	// Specifies if HTTP/2.0 is supported
	HTTP2Enabled *bool `json:"http2Enabled,omitempty"`

	// Hostname value. Supports valid domain name, partial or full wildcard
	Hostname *string `json:"hostname,omitempty"`

	// Determines whether gateway requests client certificate
	NegotiateClientCertificate *bool `json:"negotiateClientCertificate,omitempty"`

	// Specifies if TLS 1.0 is supported
	Tls10Enabled *bool `json:"tls10Enabled,omitempty"`

	// Specifies if TLS 1.1 is supported
	Tls11Enabled *bool `json:"tls11Enabled,omitempty"`
}

// GatewayKeyRegenerationRequestContract - Gateway key regeneration request contract properties.
type GatewayKeyRegenerationRequestContract struct {
	// REQUIRED; The Key being regenerated.
	KeyType *KeyType `json:"keyType,omitempty"`
}

// GatewayKeysContract - Gateway authentication keys.
type GatewayKeysContract struct {
	// Primary gateway key.
	Primary *string `json:"primary,omitempty"`

	// Secondary gateway key.
	Secondary *string `json:"secondary,omitempty"`
}

// GatewayTokenContract - Gateway access token.
type GatewayTokenContract struct {
	// Shared Access Authentication token value for the Gateway.
	Value *string `json:"value,omitempty"`
}

// GatewayTokenRequestContract - Gateway token request contract properties.
type GatewayTokenRequestContract struct {
	// REQUIRED; The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following
	// format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	Expiry *time.Time `json:"expiry,omitempty"`

	// REQUIRED; The Key to be used to generate gateway token.
	KeyType *KeyType `json:"keyType,omitempty"`
}

// GenerateSsoURLResult - Generate SSO Url operations response details.
type GenerateSsoURLResult struct {
	// Redirect Url containing the SSO URL value.
	Value *string `json:"value,omitempty"`
}

// GlobalSchemaClientBeginCreateOrUpdateOptions contains the optional parameters for the GlobalSchemaClient.BeginCreateOrUpdate
// method.
type GlobalSchemaClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GlobalSchemaClientDeleteOptions contains the optional parameters for the GlobalSchemaClient.Delete method.
type GlobalSchemaClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchemaClientGetEntityTagOptions contains the optional parameters for the GlobalSchemaClient.GetEntityTag method.
type GlobalSchemaClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchemaClientGetOptions contains the optional parameters for the GlobalSchemaClient.Get method.
type GlobalSchemaClientGetOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchemaClientListByServiceOptions contains the optional parameters for the GlobalSchemaClient.ListByService method.
type GlobalSchemaClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// GlobalSchemaCollection - The response of the list schema operation.
type GlobalSchemaCollection struct {
	// Total record count number.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Global Schema Contract value.
	Value []*GlobalSchemaContract `json:"value,omitempty" azure:"ro"`
}

// GlobalSchemaContract - Global Schema Contract details.
type GlobalSchemaContract struct {
	// Properties of the Global Schema.
	Properties *GlobalSchemaContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GlobalSchemaContractProperties - Schema create or update contract Properties.
type GlobalSchemaContractProperties struct {
	// REQUIRED; Schema Type. Immutable.
	SchemaType *SchemaType `json:"schemaType,omitempty"`

	// Free-form schema entity description.
	Description *string `json:"description,omitempty"`

	// Global Schema document object for json-based schema formats(e.g. json schema).
	Document interface{} `json:"document,omitempty"`

	// Json-encoded string for non json-based schema.
	Value interface{} `json:"value,omitempty"`
}

// GroupClientCreateOrUpdateOptions contains the optional parameters for the GroupClient.CreateOrUpdate method.
type GroupClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GroupClientDeleteOptions contains the optional parameters for the GroupClient.Delete method.
type GroupClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GroupClientGetEntityTagOptions contains the optional parameters for the GroupClient.GetEntityTag method.
type GroupClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GroupClientGetOptions contains the optional parameters for the GroupClient.Get method.
type GroupClientGetOptions struct {
	// placeholder for future optional parameters
}

// GroupClientListByServiceOptions contains the optional parameters for the GroupClient.ListByService method.
type GroupClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | externalId | filter | eq | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// GroupClientUpdateOptions contains the optional parameters for the GroupClient.Update method.
type GroupClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GroupCollection - Paged Group list representation.
type GroupCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*GroupContract `json:"value,omitempty"`
}

// GroupContract - Contract details.
type GroupContract struct {
	// Group entity contract properties.
	Properties *GroupContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GroupContractProperties - Group contract Properties.
type GroupContractProperties struct {
	// REQUIRED; Group name.
	DisplayName *string `json:"displayName,omitempty"`

	// Group description. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active
	// Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise
	// the value is null.
	ExternalID *string `json:"externalId,omitempty"`

	// Group type.
	Type *GroupType `json:"type,omitempty"`

	// READ-ONLY; true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
	BuiltIn *bool `json:"builtIn,omitempty" azure:"ro"`
}

// GroupCreateParameters - Parameters supplied to the Create Group operation.
type GroupCreateParameters struct {
	// Properties supplied to Create Group operation.
	Properties *GroupCreateParametersProperties `json:"properties,omitempty"`
}

// GroupCreateParametersProperties - Parameters supplied to the Create Group operation.
type GroupCreateParametersProperties struct {
	// REQUIRED; Group name.
	DisplayName *string `json:"displayName,omitempty"`

	// Group description.
	Description *string `json:"description,omitempty"`

	// Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g.
	// for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object
	// id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`

	// Group type.
	Type *GroupType `json:"type,omitempty"`
}

// GroupUpdateParameters - Parameters supplied to the Update Group operation.
type GroupUpdateParameters struct {
	// Group entity update contract properties.
	Properties *GroupUpdateParametersProperties `json:"properties,omitempty"`
}

// GroupUpdateParametersProperties - Parameters supplied to the Update Group operation.
type GroupUpdateParametersProperties struct {
	// Group description.
	Description *string `json:"description,omitempty"`

	// Group name.
	DisplayName *string `json:"displayName,omitempty"`

	// Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g.
	// for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object
	// id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`

	// Group type.
	Type *GroupType `json:"type,omitempty"`
}

// GroupUserClientCheckEntityExistsOptions contains the optional parameters for the GroupUserClient.CheckEntityExists method.
type GroupUserClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// GroupUserClientCreateOptions contains the optional parameters for the GroupUserClient.Create method.
type GroupUserClientCreateOptions struct {
	// placeholder for future optional parameters
}

// GroupUserClientDeleteOptions contains the optional parameters for the GroupUserClient.Delete method.
type GroupUserClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GroupUserClientListOptions contains the optional parameters for the GroupUserClient.List method.
type GroupUserClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | firstName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | lastName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | email | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | registrationDate | filter | ge, le, eq, ne, gt, lt | |
	// | note | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// HTTPHeader - HTTP header and it's value.
type HTTPHeader struct {
	// REQUIRED; Header name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Header value.
	Value *string `json:"value,omitempty"`
}

// HTTPMessageDiagnostic - Http message diagnostic settings.
type HTTPMessageDiagnostic struct {
	// Body logging settings.
	Body *BodyDiagnosticSettings `json:"body,omitempty"`

	// Data masking settings.
	DataMasking *DataMasking `json:"dataMasking,omitempty"`

	// Array of HTTP Headers to log.
	Headers []*string `json:"headers,omitempty"`
}

// HostnameConfiguration - Custom hostname configuration.
type HostnameConfiguration struct {
	// REQUIRED; Hostname to configure on the Api Management service.
	HostName *string `json:"hostName,omitempty"`

	// REQUIRED; Hostname type.
	Type *HostnameType `json:"type,omitempty"`

	// Certificate information.
	Certificate *CertificateInformation `json:"certificate,omitempty"`

	// Certificate Password.
	CertificatePassword *string `json:"certificatePassword,omitempty"`

	// Certificate Source.
	CertificateSource *CertificateSource `json:"certificateSource,omitempty"`

	// Certificate Status.
	CertificateStatus *CertificateStatus `json:"certificateStatus,omitempty"`

	// Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not
	// send the SNI header, then this will be the certificate that will be challenged.
	// The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate.
	// The setting only applied to Proxy Hostname Type.
	DefaultSSLBinding *bool `json:"defaultSslBinding,omitempty"`

	// Base64 Encoded certificate.
	EncodedCertificate *string `json:"encodedCertificate,omitempty"`

	// System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing
	// the SSL certificate.
	IdentityClientID *string `json:"identityClientId,omitempty"`

	// Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update
	// of ssl certificate will not work. This requires Api Management service to be
	// configured with aka.ms/apimmsi. The secret should be of type application/x-pkcs12
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// Specify true to always negotiate client certificate on the hostname. Default Value is false.
	NegotiateClientCertificate *bool `json:"negotiateClientCertificate,omitempty"`
}

// IdentityProviderBaseParameters - Identity Provider Base Parameter Properties.
type IdentityProviderBaseParameters struct {
	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string `json:"allowedTenants,omitempty"`

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string `json:"authority,omitempty"`

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string `json:"signinTenant,omitempty"`

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`

	// Identity Provider Type identifier.
	Type *IdentityProviderType `json:"type,omitempty"`
}

// IdentityProviderClientCreateOrUpdateOptions contains the optional parameters for the IdentityProviderClient.CreateOrUpdate
// method.
type IdentityProviderClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// IdentityProviderClientDeleteOptions contains the optional parameters for the IdentityProviderClient.Delete method.
type IdentityProviderClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientGetEntityTagOptions contains the optional parameters for the IdentityProviderClient.GetEntityTag
// method.
type IdentityProviderClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientGetOptions contains the optional parameters for the IdentityProviderClient.Get method.
type IdentityProviderClientGetOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientListByServiceOptions contains the optional parameters for the IdentityProviderClient.ListByService
// method.
type IdentityProviderClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientListSecretsOptions contains the optional parameters for the IdentityProviderClient.ListSecrets method.
type IdentityProviderClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientUpdateOptions contains the optional parameters for the IdentityProviderClient.Update method.
type IdentityProviderClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderContract - Identity Provider details.
type IdentityProviderContract struct {
	// Identity Provider contract properties.
	Properties *IdentityProviderContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IdentityProviderContractProperties - The external Identity Providers like Facebook, Google, Microsoft, Twitter or Azure
// Active Directory which can be used to enable access to the API Management service developer portal for all users.
type IdentityProviderContractProperties struct {
	// REQUIRED; Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for
	// Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`

	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string `json:"allowedTenants,omitempty"`

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string `json:"authority,omitempty"`

	// Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is
	// App Secret for Facebook login, API Key for Google login, Public Key for
	// Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string `json:"signinTenant,omitempty"`

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`

	// Identity Provider Type identifier.
	Type *IdentityProviderType `json:"type,omitempty"`
}

// IdentityProviderCreateContract - Identity Provider details.
type IdentityProviderCreateContract struct {
	// Identity Provider contract properties.
	Properties *IdentityProviderCreateContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IdentityProviderCreateContractProperties - The external Identity Providers like Facebook, Google, Microsoft, Twitter or
// Azure Active Directory which can be used to enable access to the API Management service developer portal for all users.
type IdentityProviderCreateContractProperties struct {
	// REQUIRED; Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for
	// Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`

	// REQUIRED; Client secret of the Application in external Identity Provider, used to authenticate login request. For example,
	// it is App Secret for Facebook login, API Key for Google login, Public Key for
	// Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string `json:"allowedTenants,omitempty"`

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string `json:"authority,omitempty"`

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string `json:"signinTenant,omitempty"`

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`

	// Identity Provider Type identifier.
	Type *IdentityProviderType `json:"type,omitempty"`
}

// IdentityProviderList - List of all the Identity Providers configured on the service instance.
type IdentityProviderList struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Identity Provider configuration values.
	Value []*IdentityProviderContract `json:"value,omitempty"`
}

// IdentityProviderUpdateParameters - Parameters supplied to update Identity Provider
type IdentityProviderUpdateParameters struct {
	// Identity Provider update properties.
	Properties *IdentityProviderUpdateProperties `json:"properties,omitempty"`
}

// IdentityProviderUpdateProperties - Parameters supplied to the Update Identity Provider operation.
type IdentityProviderUpdateProperties struct {
	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string `json:"allowedTenants,omitempty"`

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string `json:"authority,omitempty"`

	// Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login,
	// App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`

	// Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is
	// App Secret for Facebook login, API Key for Google login, Public Key for
	// Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string `json:"signinTenant,omitempty"`

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`

	// Identity Provider Type identifier.
	Type *IdentityProviderType `json:"type,omitempty"`
}

// IssueAttachmentCollection - Paged Issue Attachment list representation.
type IssueAttachmentCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Issue Attachment values.
	Value []*IssueAttachmentContract `json:"value,omitempty" azure:"ro"`
}

// IssueAttachmentContract - Issue Attachment Contract details.
type IssueAttachmentContract struct {
	// Properties of the Issue Attachment.
	Properties *IssueAttachmentContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IssueAttachmentContractProperties - Issue Attachment contract Properties.
type IssueAttachmentContractProperties struct {
	// REQUIRED; An HTTP link or Base64-encoded binary data.
	Content *string `json:"content,omitempty"`

	// REQUIRED; Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided
	// in the 'content' property.
	ContentFormat *string `json:"contentFormat,omitempty"`

	// REQUIRED; Filename by which the binary data will be saved.
	Title *string `json:"title,omitempty"`
}

// IssueClientGetOptions contains the optional parameters for the IssueClient.Get method.
type IssueClientGetOptions struct {
	// placeholder for future optional parameters
}

// IssueClientListByServiceOptions contains the optional parameters for the IssueClient.ListByService method.
type IssueClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | title | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | authorName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// IssueCollection - Paged Issue list representation.
type IssueCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Issue values.
	Value []*IssueContract `json:"value,omitempty" azure:"ro"`
}

// IssueCommentCollection - Paged Issue Comment list representation.
type IssueCommentCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Issue Comment values.
	Value []*IssueCommentContract `json:"value,omitempty" azure:"ro"`
}

// IssueCommentContract - Issue Comment Contract details.
type IssueCommentContract struct {
	// Properties of the Issue Comment.
	Properties *IssueCommentContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IssueCommentContractProperties - Issue Comment contract Properties.
type IssueCommentContractProperties struct {
	// REQUIRED; Comment text.
	Text *string `json:"text,omitempty"`

	// REQUIRED; A resource identifier for the user who left the comment.
	UserID *string `json:"userId,omitempty"`

	// Date and time when the comment was created.
	CreatedDate *time.Time `json:"createdDate,omitempty"`
}

// IssueContract - Issue Contract details.
type IssueContract struct {
	// Properties of the Issue.
	Properties *IssueContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IssueContractBaseProperties - Issue contract Base Properties.
type IssueContractBaseProperties struct {
	// A resource identifier for the API the issue was created for.
	APIID *string `json:"apiId,omitempty"`

	// Date and time when the issue was created.
	CreatedDate *time.Time `json:"createdDate,omitempty"`

	// Status of the issue.
	State *State `json:"state,omitempty"`
}

// IssueContractProperties - Issue contract Properties.
type IssueContractProperties struct {
	// REQUIRED; Text describing the issue.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The issue title.
	Title *string `json:"title,omitempty"`

	// REQUIRED; A resource identifier for the user created the issue.
	UserID *string `json:"userId,omitempty"`

	// A resource identifier for the API the issue was created for.
	APIID *string `json:"apiId,omitempty"`

	// Date and time when the issue was created.
	CreatedDate *time.Time `json:"createdDate,omitempty"`

	// Status of the issue.
	State *State `json:"state,omitempty"`
}

// IssueUpdateContract - Issue update Parameters.
type IssueUpdateContract struct {
	// Issue entity Update contract properties.
	Properties *IssueUpdateContractProperties `json:"properties,omitempty"`
}

// IssueUpdateContractProperties - Issue contract Update Properties.
type IssueUpdateContractProperties struct {
	// A resource identifier for the API the issue was created for.
	APIID *string `json:"apiId,omitempty"`

	// Date and time when the issue was created.
	CreatedDate *time.Time `json:"createdDate,omitempty"`

	// Text describing the issue.
	Description *string `json:"description,omitempty"`

	// Status of the issue.
	State *State `json:"state,omitempty"`

	// The issue title.
	Title *string `json:"title,omitempty"`

	// A resource identifier for the user created the issue.
	UserID *string `json:"userId,omitempty"`
}

// KeyVaultContractCreateProperties - Create keyVault contract details.
type KeyVaultContractCreateProperties struct {
	// Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
	IdentityClientID *string `json:"identityClientId,omitempty"`

	// Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires
	// API Management service to be configured with aka.ms/apimmsi
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`
}

// KeyVaultContractProperties - KeyVault contract details.
type KeyVaultContractProperties struct {
	// Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
	IdentityClientID *string `json:"identityClientId,omitempty"`

	// Last time sync and refresh status of secret from key vault.
	LastStatus *KeyVaultLastAccessStatusContractProperties `json:"lastStatus,omitempty"`

	// Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires
	// API Management service to be configured with aka.ms/apimmsi
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`
}

// KeyVaultLastAccessStatusContractProperties - Issue contract Update Properties.
type KeyVaultLastAccessStatusContractProperties struct {
	// Last status code for sync and refresh of secret from key vault.
	Code *string `json:"code,omitempty"`

	// Details of the error else empty.
	Message *string `json:"message,omitempty"`

	// Last time secret was accessed. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO
	// 8601 standard.
	TimeStampUTC *time.Time `json:"timeStampUtc,omitempty"`
}

// LoggerClientCreateOrUpdateOptions contains the optional parameters for the LoggerClient.CreateOrUpdate method.
type LoggerClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// LoggerClientDeleteOptions contains the optional parameters for the LoggerClient.Delete method.
type LoggerClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LoggerClientGetEntityTagOptions contains the optional parameters for the LoggerClient.GetEntityTag method.
type LoggerClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// LoggerClientGetOptions contains the optional parameters for the LoggerClient.Get method.
type LoggerClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoggerClientListByServiceOptions contains the optional parameters for the LoggerClient.ListByService method.
type LoggerClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | loggerType | filter | eq | |
	// | resourceId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// LoggerClientUpdateOptions contains the optional parameters for the LoggerClient.Update method.
type LoggerClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// LoggerCollection - Paged Logger list representation.
type LoggerCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Logger values.
	Value []*LoggerContract `json:"value,omitempty"`
}

// LoggerContract - Logger details.
type LoggerContract struct {
	// Logger entity contract properties.
	Properties *LoggerContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LoggerContractProperties - The Logger entity in API Management represents an event sink that you can use to log API Management
// events. Currently the Logger entity supports logging API Management events to Azure Event Hubs.
type LoggerContractProperties struct {
	// REQUIRED; Logger type.
	LoggerType *LoggerType `json:"loggerType,omitempty"`

	// The name and SendRule connection string of the event hub for azureEventHub logger. Instrumentation key for applicationInsights
	// logger.
	Credentials map[string]*string `json:"credentials,omitempty"`

	// Logger description.
	Description *string `json:"description,omitempty"`

	// Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`

	// Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
	ResourceID *string `json:"resourceId,omitempty"`
}

// LoggerUpdateContract - Logger update contract.
type LoggerUpdateContract struct {
	// Logger entity update contract properties.
	Properties *LoggerUpdateParameters `json:"properties,omitempty"`
}

// LoggerUpdateParameters - Parameters supplied to the Update Logger operation.
type LoggerUpdateParameters struct {
	// Logger credentials.
	Credentials map[string]*string `json:"credentials,omitempty"`

	// Logger description.
	Description *string `json:"description,omitempty"`

	// Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`

	// Logger type.
	LoggerType *LoggerType `json:"loggerType,omitempty"`
}

// NamedValueClientBeginCreateOrUpdateOptions contains the optional parameters for the NamedValueClient.BeginCreateOrUpdate
// method.
type NamedValueClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamedValueClientBeginRefreshSecretOptions contains the optional parameters for the NamedValueClient.BeginRefreshSecret
// method.
type NamedValueClientBeginRefreshSecretOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamedValueClientBeginUpdateOptions contains the optional parameters for the NamedValueClient.BeginUpdate method.
type NamedValueClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamedValueClientDeleteOptions contains the optional parameters for the NamedValueClient.Delete method.
type NamedValueClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NamedValueClientGetEntityTagOptions contains the optional parameters for the NamedValueClient.GetEntityTag method.
type NamedValueClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// NamedValueClientGetOptions contains the optional parameters for the NamedValueClient.Get method.
type NamedValueClientGetOptions struct {
	// placeholder for future optional parameters
}

// NamedValueClientListByServiceOptions contains the optional parameters for the NamedValueClient.ListByService method.
type NamedValueClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | tags | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith, any, all |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// When set to true, the response contains only named value entities which failed refresh.
	IsKeyVaultRefreshFailed *bool
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// NamedValueClientListValueOptions contains the optional parameters for the NamedValueClient.ListValue method.
type NamedValueClientListValueOptions struct {
	// placeholder for future optional parameters
}

// NamedValueCollection - Paged NamedValue list representation.
type NamedValueCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*NamedValueContract `json:"value,omitempty"`
}

// NamedValueContract - NamedValue details.
type NamedValueContract struct {
	// NamedValue entity contract properties.
	Properties *NamedValueContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NamedValueContractProperties - NamedValue Contract properties.
type NamedValueContractProperties struct {
	// REQUIRED; Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string `json:"displayName,omitempty"`

	// KeyVault location details of the namedValue.
	KeyVault *KeyVaultContractProperties `json:"keyVault,omitempty"`

	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string `json:"tags,omitempty"`

	// Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property
	// will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	Value *string `json:"value,omitempty"`
}

// NamedValueCreateContract - NamedValue details.
type NamedValueCreateContract struct {
	// NamedValue entity contract properties for PUT operation.
	Properties *NamedValueCreateContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NamedValueCreateContractProperties - NamedValue Contract properties.
type NamedValueCreateContractProperties struct {
	// REQUIRED; Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string `json:"displayName,omitempty"`

	// KeyVault location details of the namedValue.
	KeyVault *KeyVaultContractCreateProperties `json:"keyVault,omitempty"`

	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string `json:"tags,omitempty"`

	// Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property
	// will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	Value *string `json:"value,omitempty"`
}

// NamedValueEntityBaseParameters - NamedValue Entity Base Parameters set.
type NamedValueEntityBaseParameters struct {
	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string `json:"tags,omitempty"`
}

// NamedValueSecretContract - Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
type NamedValueSecretContract struct {
	// This is secret value of the NamedValue entity.
	Value *string `json:"value,omitempty"`
}

// NamedValueUpdateParameterProperties - NamedValue Contract properties.
type NamedValueUpdateParameterProperties struct {
	// Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string `json:"displayName,omitempty"`

	// KeyVault location details of the namedValue.
	KeyVault *KeyVaultContractCreateProperties `json:"keyVault,omitempty"`

	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string `json:"tags,omitempty"`

	// Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
}

// NamedValueUpdateParameters - NamedValue update Parameters.
type NamedValueUpdateParameters struct {
	// NamedValue entity Update contract properties.
	Properties *NamedValueUpdateParameterProperties `json:"properties,omitempty"`
}

// NetworkStatusClientListByLocationOptions contains the optional parameters for the NetworkStatusClient.ListByLocation method.
type NetworkStatusClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// NetworkStatusClientListByServiceOptions contains the optional parameters for the NetworkStatusClient.ListByService method.
type NetworkStatusClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// NetworkStatusContract - Network Status details.
type NetworkStatusContract struct {
	// REQUIRED; Gets the list of Connectivity Status to the Resources on which the service depends upon.
	ConnectivityStatus []*ConnectivityStatusContract `json:"connectivityStatus,omitempty"`

	// REQUIRED; Gets the list of DNS servers IPV4 addresses.
	DNSServers []*string `json:"dnsServers,omitempty"`
}

// NetworkStatusContractByLocation - Network Status in the Location
type NetworkStatusContractByLocation struct {
	// Location of service
	Location *string `json:"location,omitempty"`

	// Network status in Location
	NetworkStatus *NetworkStatusContract `json:"networkStatus,omitempty"`
}

// NotificationClientCreateOrUpdateOptions contains the optional parameters for the NotificationClient.CreateOrUpdate method.
type NotificationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// NotificationClientGetOptions contains the optional parameters for the NotificationClient.Get method.
type NotificationClientGetOptions struct {
	// placeholder for future optional parameters
}

// NotificationClientListByServiceOptions contains the optional parameters for the NotificationClient.ListByService method.
type NotificationClientListByServiceOptions struct {
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// NotificationCollection - Paged Notification list representation.
type NotificationCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*NotificationContract `json:"value,omitempty"`
}

// NotificationContract - Notification details.
type NotificationContract struct {
	// Notification entity contract properties.
	Properties *NotificationContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NotificationContractProperties - Notification Contract properties.
type NotificationContractProperties struct {
	// REQUIRED; Title of the Notification.
	Title *string `json:"title,omitempty"`

	// Description of the Notification.
	Description *string `json:"description,omitempty"`

	// Recipient Parameter values.
	Recipients *RecipientsContractProperties `json:"recipients,omitempty"`
}

// NotificationRecipientEmailClientCheckEntityExistsOptions contains the optional parameters for the NotificationRecipientEmailClient.CheckEntityExists
// method.
type NotificationRecipientEmailClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientEmailClientCreateOrUpdateOptions contains the optional parameters for the NotificationRecipientEmailClient.CreateOrUpdate
// method.
type NotificationRecipientEmailClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientEmailClientDeleteOptions contains the optional parameters for the NotificationRecipientEmailClient.Delete
// method.
type NotificationRecipientEmailClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientEmailClientListByNotificationOptions contains the optional parameters for the NotificationRecipientEmailClient.ListByNotification
// method.
type NotificationRecipientEmailClientListByNotificationOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientCheckEntityExistsOptions contains the optional parameters for the NotificationRecipientUserClient.CheckEntityExists
// method.
type NotificationRecipientUserClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientCreateOrUpdateOptions contains the optional parameters for the NotificationRecipientUserClient.CreateOrUpdate
// method.
type NotificationRecipientUserClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientDeleteOptions contains the optional parameters for the NotificationRecipientUserClient.Delete
// method.
type NotificationRecipientUserClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientListByNotificationOptions contains the optional parameters for the NotificationRecipientUserClient.ListByNotification
// method.
type NotificationRecipientUserClientListByNotificationOptions struct {
	// placeholder for future optional parameters
}

// OAuth2AuthenticationSettingsContract - API OAuth2 Authentication settings details.
type OAuth2AuthenticationSettingsContract struct {
	// OAuth authorization server identifier.
	AuthorizationServerID *string `json:"authorizationServerId,omitempty"`

	// operations scope.
	Scope *string `json:"scope,omitempty"`
}

// OpenIDAuthenticationSettingsContract - API OAuth2 Authentication settings details.
type OpenIDAuthenticationSettingsContract struct {
	// How to send token to the server.
	BearerTokenSendingMethods []*BearerTokenSendingMethods `json:"bearerTokenSendingMethods,omitempty"`

	// OAuth authorization server identifier.
	OpenidProviderID *string `json:"openidProviderId,omitempty"`
}

// OpenIDConnectProviderClientCreateOrUpdateOptions contains the optional parameters for the OpenIDConnectProviderClient.CreateOrUpdate
// method.
type OpenIDConnectProviderClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// OpenIDConnectProviderClientDeleteOptions contains the optional parameters for the OpenIDConnectProviderClient.Delete method.
type OpenIDConnectProviderClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientGetEntityTagOptions contains the optional parameters for the OpenIDConnectProviderClient.GetEntityTag
// method.
type OpenIDConnectProviderClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientGetOptions contains the optional parameters for the OpenIDConnectProviderClient.Get method.
type OpenIDConnectProviderClientGetOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientListByServiceOptions contains the optional parameters for the OpenIDConnectProviderClient.ListByService
// method.
type OpenIDConnectProviderClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// OpenIDConnectProviderClientListSecretsOptions contains the optional parameters for the OpenIDConnectProviderClient.ListSecrets
// method.
type OpenIDConnectProviderClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientUpdateOptions contains the optional parameters for the OpenIDConnectProviderClient.Update method.
type OpenIDConnectProviderClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderCollection - Paged OpenIdProviders list representation.
type OpenIDConnectProviderCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*OpenidConnectProviderContract `json:"value,omitempty"`
}

// OpenidConnectProviderContract - OpenId Connect Provider details.
type OpenidConnectProviderContract struct {
	// OpenId Connect Provider contract properties.
	Properties *OpenidConnectProviderContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OpenidConnectProviderContractProperties - OpenID Connect Providers Contract.
type OpenidConnectProviderContractProperties struct {
	// REQUIRED; Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`

	// REQUIRED; User-friendly OpenID Connect Provider name.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`

	// Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
}

// OpenidConnectProviderUpdateContract - Parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContract struct {
	// OpenId Connect Provider Update contract properties.
	Properties *OpenidConnectProviderUpdateContractProperties `json:"properties,omitempty"`
}

// OpenidConnectProviderUpdateContractProperties - Parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContractProperties struct {
	// Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`

	// Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`

	// User-friendly OpenID Connect Provider name.
	DisplayName *string `json:"displayName,omitempty"`

	// Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
}

// Operation - REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// The operation origin.
	Origin *string `json:"origin,omitempty"`

	// The operation properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationClientListByTagsOptions contains the optional parameters for the OperationClient.ListByTags method.
type OperationClientListByTagsOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | method | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | urlTemplate | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Include not tagged Operations.
	IncludeNotTaggedOperations *bool
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// OperationCollection - Paged Operation list representation.
type OperationCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*OperationContract `json:"value,omitempty" azure:"ro"`
}

// OperationContract - API Operation details.
type OperationContract struct {
	// Properties of the Operation Contract.
	Properties *OperationContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OperationContractProperties - Operation Contract Properties
type OperationContractProperties struct {
	// REQUIRED; Operation Name.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`

	// REQUIRED; Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`

	// Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Operation Policies
	Policies *string `json:"policies,omitempty"`

	// An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`

	// Array of Operation responses.
	Responses []*ResponseContract `json:"responses,omitempty"`

	// Collection of URL template parameters.
	TemplateParameters []*ParameterContract `json:"templateParameters,omitempty"`
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// Friendly name of the operation
	Description *string `json:"description,omitempty"`

	// Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`

	// Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntityBaseContract - API Operation Entity Base Contract details.
type OperationEntityBaseContract struct {
	// Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Operation Policies
	Policies *string `json:"policies,omitempty"`

	// An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`

	// Array of Operation responses.
	Responses []*ResponseContract `json:"responses,omitempty"`

	// Collection of URL template parameters.
	TemplateParameters []*ParameterContract `json:"templateParameters,omitempty"`
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationResultContract - Long Running Git Operation Results.
type OperationResultContract struct {
	// Properties of the Operation Contract.
	Properties *OperationResultContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OperationResultContractProperties - Operation Result.
type OperationResultContractProperties struct {
	// Error Body Contract
	Error *ErrorResponseBody `json:"error,omitempty"`

	// Operation result identifier.
	ID *string `json:"id,omitempty"`

	// Optional result info.
	ResultInfo *string `json:"resultInfo,omitempty"`

	// Start time of an async operation. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO
	// 8601 standard.
	Started *time.Time `json:"started,omitempty"`

	// Status of an async operation.
	Status *AsyncOperationStatus `json:"status,omitempty"`

	// Last update time of an async operation. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
	// the ISO 8601 standard.
	Updated *time.Time `json:"updated,omitempty"`

	// READ-ONLY; This property if only provided as part of the TenantConfigurationValidate operation. It contains the log the
	// entities which will be updated/created/deleted as part of the TenantConfigurationDeploy
	// operation.
	ActionLog []*OperationResultLogItemContract `json:"actionLog,omitempty" azure:"ro"`
}

// OperationResultLogItemContract - Log of the entity being created, updated or deleted.
type OperationResultLogItemContract struct {
	// Action like create/update/delete.
	Action *string `json:"action,omitempty"`

	// Identifier of the entity being created/updated/deleted.
	ObjectKey *string `json:"objectKey,omitempty"`

	// The type of entity contract.
	ObjectType *string `json:"objectType,omitempty"`
}

// OperationTagResourceContractProperties - Operation Entity contract Properties.
type OperationTagResourceContractProperties struct {
	// Identifier of the operation in form /operations/{operationId}.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; API Name.
	APIName *string `json:"apiName,omitempty" azure:"ro"`

	// READ-ONLY; API Revision.
	APIRevision *string `json:"apiRevision,omitempty" azure:"ro"`

	// READ-ONLY; API Version.
	APIVersion *string `json:"apiVersion,omitempty" azure:"ro"`

	// READ-ONLY; Operation Description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty" azure:"ro"`

	// READ-ONLY; Operation name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty" azure:"ro"`
}

// OperationUpdateContract - API Operation Update Contract details.
type OperationUpdateContract struct {
	// Properties of the API Operation entity that can be updated.
	Properties *OperationUpdateContractProperties `json:"properties,omitempty"`
}

// OperationUpdateContractProperties - Operation Update Contract Properties.
type OperationUpdateContractProperties struct {
	// Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Operation Name.
	DisplayName *string `json:"displayName,omitempty"`

	// A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`

	// Operation Policies
	Policies *string `json:"policies,omitempty"`

	// An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`

	// Array of Operation responses.
	Responses []*ResponseContract `json:"responses,omitempty"`

	// Collection of URL template parameters.
	TemplateParameters []*ParameterContract `json:"templateParameters,omitempty"`

	// Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutboundEnvironmentEndpoint - Endpoints accessed for a common purpose that the Api Management Service requires outbound
// network access to.
type OutboundEnvironmentEndpoint struct {
	// The type of service accessed by the Api Management Service, e.g., Azure Storage, Azure SQL Database, and Azure Active Directory.
	Category *string `json:"category,omitempty"`

	// The endpoints that the Api Management Service reaches the service at.
	Endpoints []*EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointList - Collection of Outbound Environment Endpoints
type OutboundEnvironmentEndpointList struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OutboundNetworkDependenciesEndpointsClientListByServiceOptions contains the optional parameters for the OutboundNetworkDependenciesEndpointsClient.ListByService
// method.
type OutboundNetworkDependenciesEndpointsClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// ParameterContract - Operation parameters details.
type ParameterContract struct {
	// REQUIRED; Parameter name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Parameter type.
	Type *string `json:"type,omitempty"`

	// Default parameter value.
	DefaultValue *string `json:"defaultValue,omitempty"`

	// Parameter description.
	Description *string `json:"description,omitempty"`

	// Exampled defined for the parameter.
	Examples map[string]*ParameterExampleContract `json:"examples,omitempty"`

	// Specifies whether parameter is required or not.
	Required *bool `json:"required,omitempty"`

	// Schema identifier.
	SchemaID *string `json:"schemaId,omitempty"`

	// Type name defined by the schema.
	TypeName *string `json:"typeName,omitempty"`

	// Parameter values.
	Values []*string `json:"values,omitempty"`
}

// ParameterExampleContract - Parameter example.
type ParameterExampleContract struct {
	// Long description for the example
	Description *string `json:"description,omitempty"`

	// A URL that points to the literal example
	ExternalValue *string `json:"externalValue,omitempty"`

	// Short description for the example
	Summary *string `json:"summary,omitempty"`

	// Example value. May be a primitive value, or an object.
	Value interface{} `json:"value,omitempty"`
}

// PipelineDiagnosticSettings - Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
type PipelineDiagnosticSettings struct {
	// Diagnostic settings for request.
	Request *HTTPMessageDiagnostic `json:"request,omitempty"`

	// Diagnostic settings for response.
	Response *HTTPMessageDiagnostic `json:"response,omitempty"`
}

// PolicyClientCreateOrUpdateOptions contains the optional parameters for the PolicyClient.CreateOrUpdate method.
type PolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// PolicyClientDeleteOptions contains the optional parameters for the PolicyClient.Delete method.
type PolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PolicyClientGetEntityTagOptions contains the optional parameters for the PolicyClient.GetEntityTag method.
type PolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// PolicyClientGetOptions contains the optional parameters for the PolicyClient.Get method.
type PolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// PolicyClientListByServiceOptions contains the optional parameters for the PolicyClient.ListByService method.
type PolicyClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PolicyCollection - The response of the list policy operation.
type PolicyCollection struct {
	// Total record count number.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Policy Contract value.
	Value []*PolicyContract `json:"value,omitempty"`
}

// PolicyContract - Policy Contract details.
type PolicyContract struct {
	// Properties of the Policy.
	Properties *PolicyContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PolicyContractProperties - Policy contract Properties.
type PolicyContractProperties struct {
	// REQUIRED; Contents of the Policy as defined by the format.
	Value *string `json:"value,omitempty"`

	// Format of the policyContent.
	Format *PolicyContentFormat `json:"format,omitempty"`
}

// PolicyDescriptionClientListByServiceOptions contains the optional parameters for the PolicyDescriptionClient.ListByService
// method.
type PolicyDescriptionClientListByServiceOptions struct {
	// Policy scope.
	Scope *PolicyScopeContract
}

// PolicyDescriptionCollection - Descriptions of APIM policies.
type PolicyDescriptionCollection struct {
	// Total record count number.
	Count *int64 `json:"count,omitempty"`

	// Descriptions of APIM policies.
	Value []*PolicyDescriptionContract `json:"value,omitempty"`
}

// PolicyDescriptionContract - Policy description details.
type PolicyDescriptionContract struct {
	// Policy description contract properties.
	Properties *PolicyDescriptionContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PolicyDescriptionContractProperties - Policy description properties.
type PolicyDescriptionContractProperties struct {
	// READ-ONLY; Policy description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Binary OR value of the Snippet scope.
	Scope *int64 `json:"scope,omitempty" azure:"ro"`
}

// PortalDelegationSettings - Delegation settings for a developer portal.
type PortalDelegationSettings struct {
	// Delegation settings contract properties.
	Properties *PortalDelegationSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PortalDelegationSettingsProperties - Delegation settings contract properties.
type PortalDelegationSettingsProperties struct {
	// Subscriptions delegation settings.
	Subscriptions *SubscriptionsDelegationSettingsProperties `json:"subscriptions,omitempty"`

	// A delegation Url.
	URL *string `json:"url,omitempty"`

	// User registration delegation settings.
	UserRegistration *RegistrationDelegationSettingsProperties `json:"userRegistration,omitempty"`

	// A base64-encoded validation key to validate, that a request is coming from Azure API Management.
	ValidationKey *string `json:"validationKey,omitempty"`
}

// PortalRevisionClientBeginCreateOrUpdateOptions contains the optional parameters for the PortalRevisionClient.BeginCreateOrUpdate
// method.
type PortalRevisionClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PortalRevisionClientBeginUpdateOptions contains the optional parameters for the PortalRevisionClient.BeginUpdate method.
type PortalRevisionClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PortalRevisionClientGetEntityTagOptions contains the optional parameters for the PortalRevisionClient.GetEntityTag method.
type PortalRevisionClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// PortalRevisionClientGetOptions contains the optional parameters for the PortalRevisionClient.Get method.
type PortalRevisionClientGetOptions struct {
	// placeholder for future optional parameters
}

// PortalRevisionClientListByServiceOptions contains the optional parameters for the PortalRevisionClient.ListByService method.
type PortalRevisionClientListByServiceOptions struct {
	// FIELD SUPPORTED OPERATORS SUPPORTED FUNCTIONS
	// |name | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith| |description | ge, le, eq, ne, gt, lt | substringof,
	// contains, startswith, endswith| |isCurrent | eq, ne | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// PortalRevisionCollection - Paged list of portal revisions.
type PortalRevisionCollection struct {
	// READ-ONLY; Next page link, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Collection of portal revisions.
	Value []*PortalRevisionContract `json:"value,omitempty" azure:"ro"`
}

// PortalRevisionContract - Portal Revision's contract details.
type PortalRevisionContract struct {
	// Properties of the portal revisions.
	Properties *PortalRevisionContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type PortalRevisionContractProperties struct {
	// Portal revision description.
	Description *string `json:"description,omitempty"`

	// Indicates if the portal's revision is public.
	IsCurrent *bool `json:"isCurrent,omitempty"`

	// READ-ONLY; Portal's revision creation date and time.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty" azure:"ro"`

	// READ-ONLY; Status of the portal's revision.
	Status *PortalRevisionStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Portal revision publishing status details.
	StatusDetails *string `json:"statusDetails,omitempty" azure:"ro"`

	// READ-ONLY; Last updated date and time.
	UpdatedDateTime *time.Time `json:"updatedDateTime,omitempty" azure:"ro"`
}

// PortalSettingValidationKeyContract - Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
type PortalSettingValidationKeyContract struct {
	// This is secret value of the validation key in portal settings.
	ValidationKey *string `json:"validationKey,omitempty"`
}

// PortalSettingsClientListByServiceOptions contains the optional parameters for the PortalSettingsClient.ListByService method.
type PortalSettingsClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PortalSettingsCollection - Descriptions of APIM policies.
type PortalSettingsCollection struct {
	// Total record count number.
	Count *int64 `json:"count,omitempty"`

	// Descriptions of APIM policies.
	Value []*PortalSettingsContract `json:"value,omitempty"`
}

// PortalSettingsContract - Portal Settings for the Developer Portal.
type PortalSettingsContract struct {
	// Portal Settings contract properties.
	Properties *PortalSettingsContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PortalSettingsContractProperties - Sign-in settings contract properties.
type PortalSettingsContractProperties struct {
	// Redirect Anonymous users to the Sign-In page.
	Enabled *bool `json:"enabled,omitempty"`

	// Subscriptions delegation settings.
	Subscriptions *SubscriptionsDelegationSettingsProperties `json:"subscriptions,omitempty"`

	// Terms of service contract properties.
	TermsOfService *TermsOfServiceProperties `json:"termsOfService,omitempty"`

	// A delegation Url.
	URL *string `json:"url,omitempty"`

	// User registration delegation settings.
	UserRegistration *RegistrationDelegationSettingsProperties `json:"userRegistration,omitempty"`

	// A base64-encoded validation key to validate, that a request is coming from Azure API Management.
	ValidationKey *string `json:"validationKey,omitempty"`
}

// PortalSigninSettingProperties - Sign-in settings contract properties.
type PortalSigninSettingProperties struct {
	// Redirect Anonymous users to the Sign-In page.
	Enabled *bool `json:"enabled,omitempty"`
}

// PortalSigninSettings - Sign-In settings for the Developer Portal.
type PortalSigninSettings struct {
	// Sign-in settings contract properties.
	Properties *PortalSigninSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PortalSignupSettings - Sign-Up settings for a developer portal.
type PortalSignupSettings struct {
	// Sign-up settings contract properties.
	Properties *PortalSignupSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PortalSignupSettingsProperties - Sign-up settings contract properties.
type PortalSignupSettingsProperties struct {
	// Allow users to sign up on a developer portal.
	Enabled *bool `json:"enabled,omitempty"`

	// Terms of service contract properties.
	TermsOfService *TermsOfServiceProperties `json:"termsOfService,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionClient.BeginDelete
// method.
type PrivateEndpointConnectionClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionClientGetByNameOptions contains the optional parameters for the PrivateEndpointConnectionClient.GetByName
// method.
type PrivateEndpointConnectionClientGetByNameOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientGetPrivateLinkResourceOptions contains the optional parameters for the PrivateEndpointConnectionClient.GetPrivateLinkResource
// method.
type PrivateEndpointConnectionClientGetPrivateLinkResourceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionClient.ListByService
// method.
type PrivateEndpointConnectionClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientListPrivateLinkResourcesOptions contains the optional parameters for the PrivateEndpointConnectionClient.ListPrivateLinkResources
// method.
type PrivateEndpointConnectionClientListPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionRequest - A request to approve or reject a private endpoint connection
type PrivateEndpointConnectionRequest struct {
	// Private Endpoint Connection Resource Id.
	ID *string `json:"id,omitempty"`

	// The connection state of the private endpoint connection.
	Properties *PrivateEndpointConnectionRequestProperties `json:"properties,omitempty"`
}

// PrivateEndpointConnectionRequestProperties - The connection state of the private endpoint connection.
type PrivateEndpointConnectionRequestProperties struct {
	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// PrivateEndpointConnectionWrapperProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionWrapperProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *ArmIDWrapper `json:"privateEndpoint,omitempty"`

	// READ-ONLY; All the Group ids.
	GroupIDs []*string `json:"groupIds,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// ProductAPIClientCheckEntityExistsOptions contains the optional parameters for the ProductAPIClient.CheckEntityExists method.
type ProductAPIClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// ProductAPIClientCreateOrUpdateOptions contains the optional parameters for the ProductAPIClient.CreateOrUpdate method.
type ProductAPIClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductAPIClientDeleteOptions contains the optional parameters for the ProductAPIClient.Delete method.
type ProductAPIClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProductAPIClientListByProductOptions contains the optional parameters for the ProductAPIClient.ListByProduct method.
type ProductAPIClientListByProductOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ProductClientCreateOrUpdateOptions contains the optional parameters for the ProductClient.CreateOrUpdate method.
type ProductClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ProductClientDeleteOptions contains the optional parameters for the ProductClient.Delete method.
type ProductClientDeleteOptions struct {
	// Delete existing subscriptions associated with the product or not.
	DeleteSubscriptions *bool
}

// ProductClientGetEntityTagOptions contains the optional parameters for the ProductClient.GetEntityTag method.
type ProductClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// ProductClientGetOptions contains the optional parameters for the ProductClient.Get method.
type ProductClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProductClientListByServiceOptions contains the optional parameters for the ProductClient.ListByService method.
type ProductClientListByServiceOptions struct {
	// When set to true, the response contains an array of groups that have visibility to the product. The default is false.
	ExpandGroups *bool
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | terms | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | groups | expand | | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Products which are part of a specific tag.
	Tags *string
	// Number of records to return.
	Top *int32
}

// ProductClientListByTagsOptions contains the optional parameters for the ProductClient.ListByTags method.
type ProductClientListByTagsOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | terms | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | substringof, contains, startswith, endswith |
	Filter *string
	// Include not tagged Products.
	IncludeNotTaggedProducts *bool
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ProductClientUpdateOptions contains the optional parameters for the ProductClient.Update method.
type ProductClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductCollection - Paged Products list representation.
type ProductCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*ProductContract `json:"value,omitempty"`
}

// ProductContract - Product details.
type ProductContract struct {
	// Product entity contract properties.
	Properties *ProductContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProductContractProperties - Product profile.
type ProductContractProperties struct {
	// REQUIRED; Product name.
	DisplayName *string `json:"displayName,omitempty"`

	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`

	// Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState `json:"state,omitempty"`

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
}

// ProductEntityBaseParameters - Product Entity Base Parameters
type ProductEntityBaseParameters struct {
	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`

	// Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState `json:"state,omitempty"`

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
}

// ProductGroupClientCheckEntityExistsOptions contains the optional parameters for the ProductGroupClient.CheckEntityExists
// method.
type ProductGroupClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// ProductGroupClientCreateOrUpdateOptions contains the optional parameters for the ProductGroupClient.CreateOrUpdate method.
type ProductGroupClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductGroupClientDeleteOptions contains the optional parameters for the ProductGroupClient.Delete method.
type ProductGroupClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProductGroupClientListByProductOptions contains the optional parameters for the ProductGroupClient.ListByProduct method.
type ProductGroupClientListByProductOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | |
	// | displayName | filter | eq, ne | |
	// | description | filter | eq, ne | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ProductPolicyClientCreateOrUpdateOptions contains the optional parameters for the ProductPolicyClient.CreateOrUpdate method.
type ProductPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ProductPolicyClientDeleteOptions contains the optional parameters for the ProductPolicyClient.Delete method.
type ProductPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProductPolicyClientGetEntityTagOptions contains the optional parameters for the ProductPolicyClient.GetEntityTag method.
type ProductPolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// ProductPolicyClientGetOptions contains the optional parameters for the ProductPolicyClient.Get method.
type ProductPolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// ProductPolicyClientListByProductOptions contains the optional parameters for the ProductPolicyClient.ListByProduct method.
type ProductPolicyClientListByProductOptions struct {
	// placeholder for future optional parameters
}

// ProductSubscriptionsClientListOptions contains the optional parameters for the ProductSubscriptionsClient.List method.
type ProductSubscriptionsClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | stateComment | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | ownerId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | scope | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | user | expand | | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ProductTagResourceContractProperties - Product profile.
type ProductTagResourceContractProperties struct {
	// REQUIRED; Product name.
	Name *string `json:"name,omitempty"`

	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`

	// Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Identifier of the product in the form of /products/{productId}
	ID *string `json:"id,omitempty"`

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState `json:"state,omitempty"`

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
}

// ProductUpdateParameters - Product Update parameters.
type ProductUpdateParameters struct {
	// Product entity Update contract properties.
	Properties *ProductUpdateProperties `json:"properties,omitempty"`
}

// ProductUpdateProperties - Parameters supplied to the Update Product operation.
type ProductUpdateProperties struct {
	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`

	// Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`

	// Product name.
	DisplayName *string `json:"displayName,omitempty"`

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState `json:"state,omitempty"`

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
}

// QuotaByCounterKeysClientListByServiceOptions contains the optional parameters for the QuotaByCounterKeysClient.ListByService
// method.
type QuotaByCounterKeysClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// QuotaByCounterKeysClientUpdateOptions contains the optional parameters for the QuotaByCounterKeysClient.Update method.
type QuotaByCounterKeysClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// QuotaByPeriodKeysClientGetOptions contains the optional parameters for the QuotaByPeriodKeysClient.Get method.
type QuotaByPeriodKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// QuotaByPeriodKeysClientUpdateOptions contains the optional parameters for the QuotaByPeriodKeysClient.Update method.
type QuotaByPeriodKeysClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// QuotaCounterCollection - Paged Quota Counter list representation.
type QuotaCounterCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Quota counter values.
	Value []*QuotaCounterContract `json:"value,omitempty"`
}

// QuotaCounterContract - Quota counter details.
type QuotaCounterContract struct {
	// REQUIRED; The Key value of the Counter. Must not be empty.
	CounterKey *string `json:"counterKey,omitempty"`

	// REQUIRED; The date of the end of Counter Period. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	PeriodEndTime *time.Time `json:"periodEndTime,omitempty"`

	// REQUIRED; Identifier of the Period for which the counter was collected. Must not be empty.
	PeriodKey *string `json:"periodKey,omitempty"`

	// REQUIRED; The date of the start of Counter Period. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	PeriodStartTime *time.Time `json:"periodStartTime,omitempty"`

	// Quota Value Properties
	Value *QuotaCounterValueContractProperties `json:"value,omitempty"`
}

// QuotaCounterValueContract - Quota counter value details.
type QuotaCounterValueContract struct {
	// Quota counter Value Properties.
	Value *QuotaCounterValueContractProperties `json:"value,omitempty"`
}

// QuotaCounterValueContractProperties - Quota counter value details.
type QuotaCounterValueContractProperties struct {
	// Number of times Counter was called.
	CallsCount *int32 `json:"callsCount,omitempty"`

	// Data Transferred in KiloBytes.
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// QuotaCounterValueUpdateContract - Quota counter value details.
type QuotaCounterValueUpdateContract struct {
	// Quota counter value details.
	Properties *QuotaCounterValueContractProperties `json:"properties,omitempty"`
}

// RecipientEmailCollection - Paged Recipient User list representation.
type RecipientEmailCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*RecipientEmailContract `json:"value,omitempty"`
}

// RecipientEmailContract - Recipient Email details.
type RecipientEmailContract struct {
	// Recipient Email contract properties.
	Properties *RecipientEmailContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecipientEmailContractProperties - Recipient Email Contract Properties.
type RecipientEmailContractProperties struct {
	// User Email subscribed to notification.
	Email *string `json:"email,omitempty"`
}

// RecipientUserCollection - Paged Recipient User list representation.
type RecipientUserCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*RecipientUserContract `json:"value,omitempty"`
}

// RecipientUserContract - Recipient User details.
type RecipientUserContract struct {
	// Recipient User entity contract properties.
	Properties *RecipientUsersContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecipientUsersContractProperties - Recipient User Contract Properties.
type RecipientUsersContractProperties struct {
	// API Management UserId subscribed to notification.
	UserID *string `json:"userId,omitempty"`
}

// RecipientsContractProperties - Notification Parameter contract.
type RecipientsContractProperties struct {
	// List of Emails subscribed for the notification.
	Emails []*string `json:"emails,omitempty"`

	// List of Users subscribed for the notification.
	Users []*string `json:"users,omitempty"`
}

// RegionClientListByServiceOptions contains the optional parameters for the RegionClient.ListByService method.
type RegionClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// RegionContract - Region profile.
type RegionContract struct {
	// whether Region is deleted.
	IsDeleted *bool `json:"isDeleted,omitempty"`

	// whether Region is the master region.
	IsMasterRegion *bool `json:"isMasterRegion,omitempty"`

	// READ-ONLY; Region name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// RegionListResult - Lists Regions operation response details.
type RegionListResult struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Lists of Regions.
	Value []*RegionContract `json:"value,omitempty"`
}

// RegistrationDelegationSettingsProperties - User registration delegation settings properties.
type RegistrationDelegationSettingsProperties struct {
	// Enable or disable delegation for user registration.
	Enabled *bool `json:"enabled,omitempty"`
}

// RemotePrivateEndpointConnectionWrapper - Remote Private Endpoint Connection resource.
type RemotePrivateEndpointConnectionWrapper struct {
	// Private Endpoint connection resource id
	ID *string `json:"id,omitempty"`

	// Private Endpoint Connection Name
	Name *string `json:"name,omitempty"`

	// Resource properties.
	Properties *PrivateEndpointConnectionWrapperProperties `json:"properties,omitempty"`

	// Private Endpoint Connection Resource Type
	Type *string `json:"type,omitempty"`
}

// ReportCollection - Paged Report records list representation.
type ReportCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*ReportRecordContract `json:"value,omitempty"`
}

// ReportRecordContract - Report data.
type ReportRecordContract struct {
	// API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`

	// API region identifier.
	APIRegion *string `json:"apiRegion,omitempty"`

	// Average time it took to process request.
	APITimeAvg *float64 `json:"apiTimeAvg,omitempty"`

	// Maximum time it took to process request.
	APITimeMax *float64 `json:"apiTimeMax,omitempty"`

	// Minimum time it took to process request.
	APITimeMin *float64 `json:"apiTimeMin,omitempty"`

	// Bandwidth consumed.
	Bandwidth *int64 `json:"bandwidth,omitempty"`

	// Number of times when content was served from cache policy.
	CacheHitCount *int32 `json:"cacheHitCount,omitempty"`

	// Number of times content was fetched from backend.
	CacheMissCount *int32 `json:"cacheMissCount,omitempty"`

	// Number of calls blocked due to invalid credentials. This includes calls returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden
	// and HttpStatusCode.TooManyRequests
	CallCountBlocked *int32 `json:"callCountBlocked,omitempty"`

	// Number of calls failed due to proxy or backend errors. This includes calls returning HttpStatusCode.BadRequest(400) and
	// any Code between HttpStatusCode.InternalServerError (500) and 600
	CallCountFailed *int32 `json:"callCountFailed,omitempty"`

	// Number of other calls.
	CallCountOther *int32 `json:"callCountOther,omitempty"`

	// Number of successful calls. This includes calls returning HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect
	CallCountSuccess *int32 `json:"callCountSuccess,omitempty"`

	// Total number of calls.
	CallCountTotal *int32 `json:"callCountTotal,omitempty"`

	// Country to which this record data is related.
	Country *string `json:"country,omitempty"`

	// Length of aggregation period. Interval must be multiple of 15 minutes and may not be zero. The value should be in ISO 8601
	// format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
	Interval *string `json:"interval,omitempty"`

	// Name depending on report endpoint specifies product, API, operation or developer name.
	Name *string `json:"name,omitempty"`

	// Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`

	// Country region to which this record data is related.
	Region *string `json:"region,omitempty"`

	// Average time it took to process request on backend.
	ServiceTimeAvg *float64 `json:"serviceTimeAvg,omitempty"`

	// Maximum time it took to process request on backend.
	ServiceTimeMax *float64 `json:"serviceTimeMax,omitempty"`

	// Minimum time it took to process request on backend.
	ServiceTimeMin *float64 `json:"serviceTimeMin,omitempty"`

	// Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// Start of aggregation period. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// Zip code to which this record data is related.
	Zip *string `json:"zip,omitempty"`

	// READ-ONLY; Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty" azure:"ro"`

	// READ-ONLY; User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty" azure:"ro"`
}

// ReportsClientListByAPIOptions contains the optional parameters for the ReportsClient.ListByAPI method.
type ReportsClientListByAPIOptions struct {
	// OData order by query option.
	Orderby *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ReportsClientListByGeoOptions contains the optional parameters for the ReportsClient.ListByGeo method.
type ReportsClientListByGeoOptions struct {
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ReportsClientListByOperationOptions contains the optional parameters for the ReportsClient.ListByOperation method.
type ReportsClientListByOperationOptions struct {
	// OData order by query option.
	Orderby *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ReportsClientListByProductOptions contains the optional parameters for the ReportsClient.ListByProduct method.
type ReportsClientListByProductOptions struct {
	// OData order by query option.
	Orderby *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ReportsClientListByRequestOptions contains the optional parameters for the ReportsClient.ListByRequest method.
type ReportsClientListByRequestOptions struct {
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ReportsClientListBySubscriptionOptions contains the optional parameters for the ReportsClient.ListBySubscription method.
type ReportsClientListBySubscriptionOptions struct {
	// OData order by query option.
	Orderby *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ReportsClientListByTimeOptions contains the optional parameters for the ReportsClient.ListByTime method.
type ReportsClientListByTimeOptions struct {
	// OData order by query option.
	Orderby *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// ReportsClientListByUserOptions contains the optional parameters for the ReportsClient.ListByUser method.
type ReportsClientListByUserOptions struct {
	// OData order by query option.
	Orderby *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// RepresentationContract - Operation request/response representation details.
type RepresentationContract struct {
	// REQUIRED; Specifies a registered or custom content type for this representation, e.g. application/xml.
	ContentType *string `json:"contentType,omitempty"`

	// Exampled defined for the representation.
	Examples map[string]*ParameterExampleContract `json:"examples,omitempty"`

	// Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
	FormParameters []*ParameterContract `json:"formParameters,omitempty"`

	// Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
	SchemaID *string `json:"schemaId,omitempty"`

	// Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded'
	// nor 'multipart/form-data'.
	TypeName *string `json:"typeName,omitempty"`
}

// RequestContract - Operation request details.
type RequestContract struct {
	// Operation request description.
	Description *string `json:"description,omitempty"`

	// Collection of operation request headers.
	Headers []*ParameterContract `json:"headers,omitempty"`

	// Collection of operation request query parameters.
	QueryParameters []*ParameterContract `json:"queryParameters,omitempty"`

	// Collection of operation request representations.
	Representations []*RepresentationContract `json:"representations,omitempty"`
}

// RequestReportCollection - Paged Report records list representation.
type RequestReportCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Page values.
	Value []*RequestReportRecordContract `json:"value,omitempty"`
}

// RequestReportRecordContract - Request Report data.
type RequestReportRecordContract struct {
	// API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`

	// Azure region where the gateway that processed this request is located.
	APIRegion *string `json:"apiRegion,omitempty"`

	// The total time it took to process this request.
	APITime *float64 `json:"apiTime,omitempty"`

	// The HTTP status code received by the gateway as a result of forwarding this request to the backend.
	BackendResponseCode *string `json:"backendResponseCode,omitempty"`

	// Specifies if response cache was involved in generating the response. If the value is none, the cache was not used. If the
	// value is hit, cached response was returned. If the value is miss, the cache
	// was used but lookup resulted in a miss and request was fulfilled by the backend.
	Cache *string `json:"cache,omitempty"`

	// The client IP address associated with this request.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The HTTP method associated with this request..
	Method *string `json:"method,omitempty"`

	// Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`

	// Request Identifier.
	RequestID *string `json:"requestId,omitempty"`

	// The size of this request..
	RequestSize *int32 `json:"requestSize,omitempty"`

	// The HTTP status code returned by the gateway.
	ResponseCode *int32 `json:"responseCode,omitempty"`

	// The size of the response returned by the gateway.
	ResponseSize *int32 `json:"responseSize,omitempty"`

	// he time it took to forward this request to the backend and get the response back.
	ServiceTime *float64 `json:"serviceTime,omitempty"`

	// Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The date and time when this request was received by the gateway in ISO 8601 format.
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// The full URL associated with this request.
	URL *string `json:"url,omitempty"`

	// READ-ONLY; Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty" azure:"ro"`

	// READ-ONLY; User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceLocationDataContract - Resource location data properties.
type ResourceLocationDataContract struct {
	// REQUIRED; A canonical name for the geographic or physical location.
	Name *string `json:"name,omitempty"`

	// The city or locality where the resource is located.
	City *string `json:"city,omitempty"`

	// The country or region where the resource is located.
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`

	// The district, state, or province where the resource is located.
	District *string `json:"district,omitempty"`
}

// ResourceSKU - Describes an available API Management SKU.
type ResourceSKU struct {
	// Name of the Sku.
	Name *SKUType `json:"name,omitempty"`
}

// ResourceSKUCapacity - Describes scaling information of a SKU.
type ResourceSKUCapacity struct {
	// READ-ONLY; The default capacity.
	Default *int32 `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; The maximum capacity that can be set.
	Maximum *int32 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The minimum capacity.
	Minimum *int32 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The scale type applicable to the sku.
	ScaleType *ResourceSKUCapacityScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// ResourceSKUResult - Describes an available API Management service SKU.
type ResourceSKUResult struct {
	// READ-ONLY; Specifies the number of API Management units.
	Capacity *ResourceSKUCapacity `json:"capacity,omitempty" azure:"ro"`

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Specifies API Management SKU.
	SKU *ResourceSKU `json:"sku,omitempty" azure:"ro"`
}

// ResourceSKUResults - The API Management service SKUs operation response.
type ResourceSKUResults struct {
	// REQUIRED; The list of skus available for the service.
	Value []*ResourceSKUResult `json:"value,omitempty"`

	// The uri to fetch the next page of API Management service Skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseContract - Operation response details.
type ResponseContract struct {
	// REQUIRED; Operation response HTTP status code.
	StatusCode *int32 `json:"statusCode,omitempty"`

	// Operation response description.
	Description *string `json:"description,omitempty"`

	// Collection of operation response headers.
	Headers []*ParameterContract `json:"headers,omitempty"`

	// Collection of operation response representations.
	Representations []*RepresentationContract `json:"representations,omitempty"`
}

// SKU - Describes an available ApiManagement SKU.
type SKU struct {
	// READ-ONLY; The api versions that support this SKU.
	APIVersions []*string `json:"apiVersions,omitempty" azure:"ro"`

	// READ-ONLY; A name value pair to describe the capability.
	Capabilities []*SKUCapabilities `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the number of virtual machines in the scale set.
	Capacity *SKUCapacity `json:"capacity,omitempty" azure:"ro"`

	// READ-ONLY; Metadata for retrieving price info.
	Costs []*SKUCosts `json:"costs,omitempty" azure:"ro"`

	// READ-ONLY; The Family of this particular SKU.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; A list of locations and availability zones in those locations where the SKU is available.
	LocationInfo []*SKULocationInfo `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available.
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of SKU.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*SKURestrictions `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The Size of the SKU.
	Size *string `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the tier of virtual machines in a scale set.
	// Possible Values:
	// Standard
	// Basic
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// SKUCapabilities - Describes The SKU capabilities object.
type SKUCapabilities struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// SKUCapacity - Describes scaling information of a SKU.
type SKUCapacity struct {
	// READ-ONLY; The default capacity.
	Default *int32 `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; The maximum capacity that can be set.
	Maximum *int32 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The minimum capacity.
	Minimum *int32 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The scale type applicable to the sku.
	ScaleType *APIManagementSKUCapacityScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// SKUCosts - Describes metadata for retrieving price info.
type SKUCosts struct {
	// READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty" azure:"ro"`

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterID,omitempty" azure:"ro"`

	// READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64 `json:"quantity,omitempty" azure:"ro"`
}

type SKULocationInfo struct {
	// READ-ONLY; Location of the SKU
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails []*SKUZoneDetails `json:"zoneDetails,omitempty" azure:"ro"`

	// READ-ONLY; List of availability zones where the SKU is supported.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

type SKURestrictionInfo struct {
	// READ-ONLY; Locations where the SKU is restricted
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; List of availability zones where the SKU is restricted.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// SKURestrictions - Describes scaling information of a SKU.
type SKURestrictions struct {
	// READ-ONLY; The reason for restriction.
	ReasonCode *APIManagementSKURestrictionsReasonCode `json:"reasonCode,omitempty" azure:"ro"`

	// READ-ONLY; The information about the restriction where the SKU cannot be used.
	RestrictionInfo *SKURestrictionInfo `json:"restrictionInfo,omitempty" azure:"ro"`

	// READ-ONLY; The type of restrictions.
	Type *APIManagementSKURestrictionsType `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// SKUZoneDetails - Describes The zonal capabilities of a SKU.
type SKUZoneDetails struct {
	// READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities []*SKUCapabilities `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name []*string `json:"name,omitempty" azure:"ro"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.List method.
type SKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// SKUsResult - The List Resource Skus operation response.
type SKUsResult struct {
	// REQUIRED; The list of skus available for the subscription.
	Value []*SKU `json:"value,omitempty"`

	// READ-ONLY; The URI to fetch the next page of Resource Skus. Call ListNext() with this URI to fetch the next page of Resource
	// Skus
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SamplingSettings - Sampling settings for Diagnostic.
type SamplingSettings struct {
	// Rate of sampling for fixed-rate sampling.
	Percentage *float64 `json:"percentage,omitempty"`

	// Sampling type.
	SamplingType *SamplingType `json:"samplingType,omitempty"`
}

// SaveConfigurationParameter - Save Tenant Configuration Contract details.
type SaveConfigurationParameter struct {
	// Properties of the Save Configuration Parameters.
	Properties *SaveConfigurationParameterProperties `json:"properties,omitempty"`
}

// SaveConfigurationParameterProperties - Parameters supplied to the Save Tenant Configuration operation.
type SaveConfigurationParameterProperties struct {
	// REQUIRED; The name of the Git branch in which to commit the current configuration snapshot.
	Branch *string `json:"branch,omitempty"`

	// The value if true, the current configuration database is committed to the Git repository, even if the Git repository has
	// newer changes that would be overwritten.
	Force *bool `json:"force,omitempty"`
}

// SchemaCollection - The response of the list schema operation.
type SchemaCollection struct {
	// Total record count number.
	Count *int64 `json:"count,omitempty"`

	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; API Schema Contract value.
	Value []*SchemaContract `json:"value,omitempty" azure:"ro"`
}

// SchemaContract - API Schema Contract details.
type SchemaContract struct {
	// Properties of the API Schema.
	Properties *SchemaContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SchemaContractProperties - API Schema create or update contract Properties.
type SchemaContractProperties struct {
	// REQUIRED; Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema
	// document (e.g. application/json, application/xml).
	// - Swagger Schema use application/vnd.ms-azure-apim.swagger.definitions+json
	// - WSDL Schema use application/vnd.ms-azure-apim.xsd+xml
	// - OpenApi Schema use application/vnd.oai.openapi.components+json
	// - WADL Schema use application/vnd.ms-azure-apim.wadl.grammars+xml.
	ContentType *string `json:"contentType,omitempty"`

	// Create or update Properties of the API Schema Document.
	Document *SchemaDocumentProperties `json:"document,omitempty"`
}

// SchemaDocumentProperties - Api Schema Document Properties.
type SchemaDocumentProperties struct {
	// Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
	Components interface{} `json:"components,omitempty"`

	// Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
	Definitions interface{} `json:"definitions,omitempty"`

	// Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
	Value *string `json:"value,omitempty"`
}

// ServiceApplyNetworkConfigurationParameters - Parameter supplied to the Apply Network configuration operation.
type ServiceApplyNetworkConfigurationParameters struct {
	// Location of the Api Management service to update for a multi-region service. For a service deployed in a single region,
	// this parameter is not required.
	Location *string `json:"location,omitempty"`
}

// ServiceBackupRestoreParameters - Parameters supplied to the Backup/Restore of an API Management service operation.
type ServiceBackupRestoreParameters struct {
	// REQUIRED; The name of the backup file to create/retrieve.
	BackupName *string `json:"backupName,omitempty"`

	// REQUIRED; The name of the blob container (used to place/retrieve the backup).
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; The name of the Azure storage account (used to place/retrieve the backup).
	StorageAccount *string `json:"storageAccount,omitempty"`

	// Storage account access key. Required only if accessType is set to AccessKey.
	AccessKey *string `json:"accessKey,omitempty"`

	// The type of access to be used for the storage account.
	AccessType *AccessType `json:"accessType,omitempty"`

	// The Client ID of user assigned managed identity. Required only if accessType is set to UserAssignedManagedIdentity.
	ClientID *string `json:"clientId,omitempty"`
}

// ServiceBaseProperties - Base Properties of an API Management service resource description.
type ServiceBaseProperties struct {
	// Control Plane Apis version constraint for the API Management service.
	APIVersionConstraint *APIVersionConstraint `json:"apiVersionConstraint,omitempty"`

	// Additional datacenter locations of the API Management service.
	AdditionalLocations []*AdditionalLocation `json:"additionalLocations,omitempty"`

	// List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed
	// is 10.
	Certificates []*CertificateConfiguration `json:"certificates,omitempty"`

	// Custom properties of the API Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168 will disable the cipher TLSRSAWITH3DESEDECBCSHA
	// for all TLS(1.0, 1.1 and 1.2).
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11 can be used to disable just TLS 1.1.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10 can be used to disable TLS 1.0 on an API
	// Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11 can be used to disable just TLS 1.1
	// for communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10 can be used to disable TLS 1.0 for
	// communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2 can be used to enable HTTP2 protocol on an
	// API Management service.
	// Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For
	// all the settings except Http2 the default value is True if the service was
	// created on or before April 1st 2018 and False otherwise. Http2 setting's default value is False.
	// You can disable any of next ciphers by using settings Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]:
	// TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES128CBCSHA, TLS
	// ECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES128CBCSHA, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES128CBCSHA256,
	// TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES128CBCSHA. For example,
	// Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256:false. The default value
	// is true for them. Note: next ciphers can't be disabled since they are required by
	// Azure CloudService internal components: TLSECDHEECDSAWITHAES256GCMSHA384,TLSECDHEECDSAWITHAES128GCMSHA256,TLSECDHERSAWITHAES256GCMSHA384,TLSECDHERSAWITHAES128GCMSHA256,TLSECDHEECDSAWITHAES256CBC
	// SHA384,TLSECDHEECDSAWITHAES128CBCSHA256,TLSECDHERSAWITHAES256CBCSHA384,TLSECDHERSAWITHAES128CBCSHA256,TLSRSAWITHAES256GCMSHA384
	CustomProperties map[string]*string `json:"customProperties,omitempty"`

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in master region.
	DisableGateway *bool `json:"disableGateway,omitempty"`

	// Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each
	// request to the gateway. This also enables the ability to authenticate the
	// certificate in the policy on the gateway.
	EnableClientCertificate *bool `json:"enableClientCertificate,omitempty"`

	// Custom hostname configuration of the API Management service.
	HostnameConfigurations []*HostnameConfiguration `json:"hostnameConfigurations,omitempty"`

	// Email address from which the notification will be sent.
	NotificationSenderEmail *string `json:"notificationSenderEmail,omitempty"`

	// List of Private Endpoint Connections of this service.
	PrivateEndpointConnections []*RemotePrivateEndpointConnectionWrapper `json:"privateEndpointConnections,omitempty"`

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported
	// only for Developer and Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`

	// Whether or not public endpoint access is allowed for this API Management service. Value is optional but if passed in, must
	// be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
	// exclusive access method. Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other
	// properties will be ignored.
	Restore *bool `json:"restore,omitempty"`

	// Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`

	// The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management
	// service is not part of any Virtual Network, External means the API Management
	// deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management
	// deployment is setup inside a Virtual Network having an Intranet Facing Endpoint
	// only.
	VirtualNetworkType *VirtualNetworkType `json:"virtualNetworkType,omitempty"`

	// READ-ONLY; Creation UTC date of the API Management service.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	CreatedAtUTC *time.Time `json:"createdAtUtc,omitempty" azure:"ro"`

	// READ-ONLY; DEveloper Portal endpoint URL of the API Management service.
	DeveloperPortalURL *string `json:"developerPortalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Gateway URL of the API Management service.
	GatewayURL *string `json:"gatewayUrl,omitempty" azure:"ro"`

	// READ-ONLY; Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty" azure:"ro"`

	// READ-ONLY; Compute Platform Version running the service in this location.
	PlatformVersion *PlatformVersion `json:"platformVersion,omitempty" azure:"ro"`

	// READ-ONLY; Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed
	// in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated
	// SKU.
	PrivateIPAddresses []*string `json:"privateIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for
	// Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string `json:"publicIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the API Management service, which is targeted by the long running operation started
	// on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty" azure:"ro"`
}

// ServiceCheckNameAvailabilityParameters - Parameters supplied to the CheckNameAvailability operation.
type ServiceCheckNameAvailabilityParameters struct {
	// REQUIRED; The name to check for availability.
	Name *string `json:"name,omitempty"`
}

// ServiceClientBeginApplyNetworkConfigurationUpdatesOptions contains the optional parameters for the ServiceClient.BeginApplyNetworkConfigurationUpdates
// method.
type ServiceClientBeginApplyNetworkConfigurationUpdatesOptions struct {
	// Parameters supplied to the Apply Network Configuration operation. If the parameters are empty, all the regions in which
	// the Api Management service is deployed will be updated sequentially without
	// incurring downtime in the region.
	Parameters *ServiceApplyNetworkConfigurationParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginBackupOptions contains the optional parameters for the ServiceClient.BeginBackup method.
type ServiceClientBeginBackupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceClient.BeginCreateOrUpdate method.
type ServiceClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginDeleteOptions contains the optional parameters for the ServiceClient.BeginDelete method.
type ServiceClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginRestoreOptions contains the optional parameters for the ServiceClient.BeginRestore method.
type ServiceClientBeginRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginUpdateOptions contains the optional parameters for the ServiceClient.BeginUpdate method.
type ServiceClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientCheckNameAvailabilityOptions contains the optional parameters for the ServiceClient.CheckNameAvailability
// method.
type ServiceClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientGetDomainOwnershipIdentifierOptions contains the optional parameters for the ServiceClient.GetDomainOwnershipIdentifier
// method.
type ServiceClientGetDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientGetOptions contains the optional parameters for the ServiceClient.Get method.
type ServiceClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientGetSsoTokenOptions contains the optional parameters for the ServiceClient.GetSsoToken method.
type ServiceClientGetSsoTokenOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientListByResourceGroupOptions contains the optional parameters for the ServiceClient.ListByResourceGroup method.
type ServiceClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientListOptions contains the optional parameters for the ServiceClient.List method.
type ServiceClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceGetDomainOwnershipIdentifierResult - Response of the GetDomainOwnershipIdentifier operation.
type ServiceGetDomainOwnershipIdentifierResult struct {
	// READ-ONLY; The domain ownership identifier value.
	DomainOwnershipIdentifier *string `json:"domainOwnershipIdentifier,omitempty" azure:"ro"`
}

// ServiceGetSsoTokenResult - The response of the GetSsoToken operation.
type ServiceGetSsoTokenResult struct {
	// Redirect URL to the Publisher Portal containing the SSO token.
	RedirectURI *string `json:"redirectUri,omitempty"`
}

// ServiceIdentity - Identity properties of the Api Management service resource.
type ServiceIdentity struct {
	// REQUIRED; The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly
	// created identity and a set of user assigned identities. The type 'None' will remove any
	// identities from the service.
	Type *ApimIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/ providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The client tenant id of the identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ServiceListResult - The response of the List API Management services operation.
type ServiceListResult struct {
	// REQUIRED; Result of the List API Management services operation.
	Value []*ServiceResource `json:"value,omitempty"`

	// Link to the next set of results. Not empty if Value contains incomplete list of API Management services.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceNameAvailabilityResult - Response of the CheckNameAvailability operation.
type ServiceNameAvailabilityResult struct {
	// Invalid indicates the name provided does not match the resource provider’s naming requirements (incorrect length, unsupported
	// characters, etc.) AlreadyExists indicates that the name is already in use
	// and is therefore unavailable.
	Reason *NameAvailabilityReason `json:"reason,omitempty"`

	// READ-ONLY; If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource
	// naming requirements so that the user can select a valid name. If reason == AlreadyExists,
	// explain that is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; True if the name is available and can be used to create a new API Management service; otherwise false.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`
}

// ServiceProperties - Properties of an API Management service resource description.
type ServiceProperties struct {
	// REQUIRED; Publisher email.
	PublisherEmail *string `json:"publisherEmail,omitempty"`

	// REQUIRED; Publisher name.
	PublisherName *string `json:"publisherName,omitempty"`

	// Control Plane Apis version constraint for the API Management service.
	APIVersionConstraint *APIVersionConstraint `json:"apiVersionConstraint,omitempty"`

	// Additional datacenter locations of the API Management service.
	AdditionalLocations []*AdditionalLocation `json:"additionalLocations,omitempty"`

	// List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed
	// is 10.
	Certificates []*CertificateConfiguration `json:"certificates,omitempty"`

	// Custom properties of the API Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168 will disable the cipher TLSRSAWITH3DESEDECBCSHA
	// for all TLS(1.0, 1.1 and 1.2).
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11 can be used to disable just TLS 1.1.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10 can be used to disable TLS 1.0 on an API
	// Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11 can be used to disable just TLS 1.1
	// for communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10 can be used to disable TLS 1.0 for
	// communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2 can be used to enable HTTP2 protocol on an
	// API Management service.
	// Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For
	// all the settings except Http2 the default value is True if the service was
	// created on or before April 1st 2018 and False otherwise. Http2 setting's default value is False.
	// You can disable any of next ciphers by using settings Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]:
	// TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES128CBCSHA, TLS
	// ECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES128CBCSHA, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES128CBCSHA256,
	// TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES128CBCSHA. For example,
	// Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256:false. The default value
	// is true for them. Note: next ciphers can't be disabled since they are required by
	// Azure CloudService internal components: TLSECDHEECDSAWITHAES256GCMSHA384,TLSECDHEECDSAWITHAES128GCMSHA256,TLSECDHERSAWITHAES256GCMSHA384,TLSECDHERSAWITHAES128GCMSHA256,TLSECDHEECDSAWITHAES256CBC
	// SHA384,TLSECDHEECDSAWITHAES128CBCSHA256,TLSECDHERSAWITHAES256CBCSHA384,TLSECDHERSAWITHAES128CBCSHA256,TLSRSAWITHAES256GCMSHA384
	CustomProperties map[string]*string `json:"customProperties,omitempty"`

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in master region.
	DisableGateway *bool `json:"disableGateway,omitempty"`

	// Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each
	// request to the gateway. This also enables the ability to authenticate the
	// certificate in the policy on the gateway.
	EnableClientCertificate *bool `json:"enableClientCertificate,omitempty"`

	// Custom hostname configuration of the API Management service.
	HostnameConfigurations []*HostnameConfiguration `json:"hostnameConfigurations,omitempty"`

	// Email address from which the notification will be sent.
	NotificationSenderEmail *string `json:"notificationSenderEmail,omitempty"`

	// List of Private Endpoint Connections of this service.
	PrivateEndpointConnections []*RemotePrivateEndpointConnectionWrapper `json:"privateEndpointConnections,omitempty"`

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported
	// only for Developer and Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`

	// Whether or not public endpoint access is allowed for this API Management service. Value is optional but if passed in, must
	// be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
	// exclusive access method. Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other
	// properties will be ignored.
	Restore *bool `json:"restore,omitempty"`

	// Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`

	// The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management
	// service is not part of any Virtual Network, External means the API Management
	// deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management
	// deployment is setup inside a Virtual Network having an Intranet Facing Endpoint
	// only.
	VirtualNetworkType *VirtualNetworkType `json:"virtualNetworkType,omitempty"`

	// READ-ONLY; Creation UTC date of the API Management service.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	CreatedAtUTC *time.Time `json:"createdAtUtc,omitempty" azure:"ro"`

	// READ-ONLY; DEveloper Portal endpoint URL of the API Management service.
	DeveloperPortalURL *string `json:"developerPortalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Gateway URL of the API Management service.
	GatewayURL *string `json:"gatewayUrl,omitempty" azure:"ro"`

	// READ-ONLY; Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty" azure:"ro"`

	// READ-ONLY; Compute Platform Version running the service in this location.
	PlatformVersion *PlatformVersion `json:"platformVersion,omitempty" azure:"ro"`

	// READ-ONLY; Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed
	// in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated
	// SKU.
	PrivateIPAddresses []*string `json:"privateIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for
	// Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string `json:"publicIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the API Management service, which is targeted by the long running operation started
	// on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty" azure:"ro"`
}

// ServiceResource - A single API Management service resource in List or Get response.
type ServiceResource struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the API Management service.
	Properties *ServiceProperties `json:"properties,omitempty"`

	// REQUIRED; SKU properties of the API Management service.
	SKU *ServiceSKUProperties `json:"sku,omitempty"`

	// Managed service identity of the Api Management service.
	Identity *ServiceIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; ETag of the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceSKUProperties - API Management service resource SKU properties.
type ServiceSKUProperties struct {
	// REQUIRED; Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as
	// 0.
	Capacity *int32 `json:"capacity,omitempty"`

	// REQUIRED; Name of the Sku.
	Name *SKUType `json:"name,omitempty"`
}

// ServiceSKUsClientListAvailableServiceSKUsOptions contains the optional parameters for the ServiceSKUsClient.ListAvailableServiceSKUs
// method.
type ServiceSKUsClientListAvailableServiceSKUsOptions struct {
	// placeholder for future optional parameters
}

// ServiceUpdateParameters - Parameter supplied to Update Api Management Service.
type ServiceUpdateParameters struct {
	// Managed service identity of the Api Management service.
	Identity *ServiceIdentity `json:"identity,omitempty"`

	// Properties of the API Management service.
	Properties *ServiceUpdateProperties `json:"properties,omitempty"`

	// SKU properties of the API Management service.
	SKU *ServiceSKUProperties `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; ETag of the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceUpdateProperties - Properties of an API Management service resource description.
type ServiceUpdateProperties struct {
	// Control Plane Apis version constraint for the API Management service.
	APIVersionConstraint *APIVersionConstraint `json:"apiVersionConstraint,omitempty"`

	// Additional datacenter locations of the API Management service.
	AdditionalLocations []*AdditionalLocation `json:"additionalLocations,omitempty"`

	// List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed
	// is 10.
	Certificates []*CertificateConfiguration `json:"certificates,omitempty"`

	// Custom properties of the API Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168 will disable the cipher TLSRSAWITH3DESEDECBCSHA
	// for all TLS(1.0, 1.1 and 1.2).
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11 can be used to disable just TLS 1.1.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10 can be used to disable TLS 1.0 on an API
	// Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11 can be used to disable just TLS 1.1
	// for communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10 can be used to disable TLS 1.0 for
	// communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2 can be used to enable HTTP2 protocol on an
	// API Management service.
	// Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For
	// all the settings except Http2 the default value is True if the service was
	// created on or before April 1st 2018 and False otherwise. Http2 setting's default value is False.
	// You can disable any of next ciphers by using settings Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]:
	// TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES128CBCSHA, TLS
	// ECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES128CBCSHA, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES128CBCSHA256,
	// TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES128CBCSHA. For example,
	// Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256:false. The default value
	// is true for them. Note: next ciphers can't be disabled since they are required by
	// Azure CloudService internal components: TLSECDHEECDSAWITHAES256GCMSHA384,TLSECDHEECDSAWITHAES128GCMSHA256,TLSECDHERSAWITHAES256GCMSHA384,TLSECDHERSAWITHAES128GCMSHA256,TLSECDHEECDSAWITHAES256CBC
	// SHA384,TLSECDHEECDSAWITHAES128CBCSHA256,TLSECDHERSAWITHAES256CBCSHA384,TLSECDHERSAWITHAES128CBCSHA256,TLSRSAWITHAES256GCMSHA384
	CustomProperties map[string]*string `json:"customProperties,omitempty"`

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in master region.
	DisableGateway *bool `json:"disableGateway,omitempty"`

	// Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each
	// request to the gateway. This also enables the ability to authenticate the
	// certificate in the policy on the gateway.
	EnableClientCertificate *bool `json:"enableClientCertificate,omitempty"`

	// Custom hostname configuration of the API Management service.
	HostnameConfigurations []*HostnameConfiguration `json:"hostnameConfigurations,omitempty"`

	// Email address from which the notification will be sent.
	NotificationSenderEmail *string `json:"notificationSenderEmail,omitempty"`

	// List of Private Endpoint Connections of this service.
	PrivateEndpointConnections []*RemotePrivateEndpointConnectionWrapper `json:"privateEndpointConnections,omitempty"`

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported
	// only for Developer and Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`

	// Whether or not public endpoint access is allowed for this API Management service. Value is optional but if passed in, must
	// be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
	// exclusive access method. Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Publisher email.
	PublisherEmail *string `json:"publisherEmail,omitempty"`

	// Publisher name.
	PublisherName *string `json:"publisherName,omitempty"`

	// Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other
	// properties will be ignored.
	Restore *bool `json:"restore,omitempty"`

	// Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`

	// The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management
	// service is not part of any Virtual Network, External means the API Management
	// deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management
	// deployment is setup inside a Virtual Network having an Intranet Facing Endpoint
	// only.
	VirtualNetworkType *VirtualNetworkType `json:"virtualNetworkType,omitempty"`

	// READ-ONLY; Creation UTC date of the API Management service.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	CreatedAtUTC *time.Time `json:"createdAtUtc,omitempty" azure:"ro"`

	// READ-ONLY; DEveloper Portal endpoint URL of the API Management service.
	DeveloperPortalURL *string `json:"developerPortalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Gateway URL of the API Management service.
	GatewayURL *string `json:"gatewayUrl,omitempty" azure:"ro"`

	// READ-ONLY; Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty" azure:"ro"`

	// READ-ONLY; Compute Platform Version running the service in this location.
	PlatformVersion *PlatformVersion `json:"platformVersion,omitempty" azure:"ro"`

	// READ-ONLY; Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty" azure:"ro"`

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed
	// in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated
	// SKU.
	PrivateIPAddresses []*string `json:"privateIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for
	// Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string `json:"publicIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the API Management service, which is targeted by the long running operation started
	// on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty" azure:"ro"`
}

// SignInSettingsClientCreateOrUpdateOptions contains the optional parameters for the SignInSettingsClient.CreateOrUpdate
// method.
type SignInSettingsClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// SignInSettingsClientGetEntityTagOptions contains the optional parameters for the SignInSettingsClient.GetEntityTag method.
type SignInSettingsClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// SignInSettingsClientGetOptions contains the optional parameters for the SignInSettingsClient.Get method.
type SignInSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SignInSettingsClientUpdateOptions contains the optional parameters for the SignInSettingsClient.Update method.
type SignInSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SignUpSettingsClientCreateOrUpdateOptions contains the optional parameters for the SignUpSettingsClient.CreateOrUpdate
// method.
type SignUpSettingsClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// SignUpSettingsClientGetEntityTagOptions contains the optional parameters for the SignUpSettingsClient.GetEntityTag method.
type SignUpSettingsClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// SignUpSettingsClientGetOptions contains the optional parameters for the SignUpSettingsClient.Get method.
type SignUpSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SignUpSettingsClientUpdateOptions contains the optional parameters for the SignUpSettingsClient.Update method.
type SignUpSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientCreateOrUpdateOptions contains the optional parameters for the SubscriptionClient.CreateOrUpdate method.
type SubscriptionClientCreateOrUpdateOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
	// Notify change in Subscription State.
	// * If false, do not send any email notification for change of state of subscription
	// * If true, send email notification of change of state of subscription
	Notify *bool
}

// SubscriptionClientDeleteOptions contains the optional parameters for the SubscriptionClient.Delete method.
type SubscriptionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientGetEntityTagOptions contains the optional parameters for the SubscriptionClient.GetEntityTag method.
type SubscriptionClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientGetOptions contains the optional parameters for the SubscriptionClient.Get method.
type SubscriptionClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientListOptions contains the optional parameters for the SubscriptionClient.List method.
type SubscriptionClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | stateComment | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | ownerId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | scope | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | user | expand | | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// SubscriptionClientListSecretsOptions contains the optional parameters for the SubscriptionClient.ListSecrets method.
type SubscriptionClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientRegeneratePrimaryKeyOptions contains the optional parameters for the SubscriptionClient.RegeneratePrimaryKey
// method.
type SubscriptionClientRegeneratePrimaryKeyOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientRegenerateSecondaryKeyOptions contains the optional parameters for the SubscriptionClient.RegenerateSecondaryKey
// method.
type SubscriptionClientRegenerateSecondaryKeyOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientUpdateOptions contains the optional parameters for the SubscriptionClient.Update method.
type SubscriptionClientUpdateOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType
	// Notify change in Subscription State.
	// * If false, do not send any email notification for change of state of subscription
	// * If true, send email notification of change of state of subscription
	Notify *bool
}

// SubscriptionCollection - Paged Subscriptions list representation.
type SubscriptionCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*SubscriptionContract `json:"value,omitempty"`
}

// SubscriptionContract - Subscription details.
type SubscriptionContract struct {
	// Subscription contract properties.
	Properties *SubscriptionContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubscriptionContractProperties - Subscription details.
type SubscriptionContractProperties struct {
	// REQUIRED; Scope like /products/{productId} or /apis or /apis/{apiId}.
	Scope *string `json:"scope,omitempty"`

	// REQUIRED; Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription
	// is blocked, and the subscriber cannot call any APIs of the product, * submitted – the
	// subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription
	// request has been denied by an administrator, * cancelled – the
	// subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration
	// date and was deactivated.
	State *SubscriptionState `json:"state,omitempty"`

	// Determines whether tracing is enabled
	AllowTracing *bool `json:"allowTracing,omitempty"`

	// The name of the subscription, or null if the subscription has no name.
	DisplayName *string `json:"displayName,omitempty"`

	// Date when subscription was cancelled or expired. The setting is for audit purposes only and the subscription is not automatically
	// cancelled. The subscription lifecycle can be managed by using the
	// state property. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	EndDate *time.Time `json:"endDate,omitempty"`

	// Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired.
	// The subscription lifecycle can be managed by using the state property. The date
	// conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// Upcoming subscription expiration notification date. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as
	// specified by the ISO 8601 standard.
	NotificationDate *time.Time `json:"notificationDate,omitempty"`

	// The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{userId}
	// where {userId} is a user identifier.
	OwnerID *string `json:"ownerId,omitempty"`

	// Subscription primary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Subscription secondary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	SecondaryKey *string `json:"secondaryKey,omitempty"`

	// Subscription activation date. The setting is for audit purposes only and the subscription is not automatically activated.
	// The subscription lifecycle can be managed by using the state property. The
	// date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	StartDate *time.Time `json:"startDate,omitempty"`

	// Optional subscription comment added by an administrator when the state is changed to the 'rejected'.
	StateComment *string `json:"stateComment,omitempty"`

	// READ-ONLY; Subscription creation date. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
	// the ISO 8601 standard.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`
}

// SubscriptionCreateParameterProperties - Parameters supplied to the Create subscription operation.
type SubscriptionCreateParameterProperties struct {
	// REQUIRED; Subscription name.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; Scope like /products/{productId} or /apis or /apis/{apiId}.
	Scope *string `json:"scope,omitempty"`

	// Determines whether tracing can be enabled
	AllowTracing *bool `json:"allowTracing,omitempty"`

	// User (user id path) for whom subscription is being created in form /users/{userId}
	OwnerID *string `json:"ownerId,omitempty"`

	// Primary subscription key. If not specified during request key will be generated automatically.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Secondary subscription key. If not specified during request key will be generated automatically.
	SecondaryKey *string `json:"secondaryKey,omitempty"`

	// Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are
	// * active – the subscription is active, * suspended – the subscription is
	// blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by
	// the developer, but has not yet been approved or rejected, * rejected – the
	// subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer
	// or administrator, * expired – the subscription reached its expiration date
	// and was deactivated.
	State *SubscriptionState `json:"state,omitempty"`
}

// SubscriptionCreateParameters - Subscription create details.
type SubscriptionCreateParameters struct {
	// Subscription contract properties.
	Properties *SubscriptionCreateParameterProperties `json:"properties,omitempty"`
}

// SubscriptionKeyParameterNamesContract - Subscription key parameter names details.
type SubscriptionKeyParameterNamesContract struct {
	// Subscription key header name.
	Header *string `json:"header,omitempty"`

	// Subscription key query string parameter name.
	Query *string `json:"query,omitempty"`
}

// SubscriptionKeysContract - Subscription keys.
type SubscriptionKeysContract struct {
	// Subscription primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Subscription secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// SubscriptionUpdateParameterProperties - Parameters supplied to the Update subscription operation.
type SubscriptionUpdateParameterProperties struct {
	// Determines whether tracing can be enabled
	AllowTracing *bool `json:"allowTracing,omitempty"`

	// Subscription name.
	DisplayName *string `json:"displayName,omitempty"`

	// Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired.
	// The subscription lifecycle can be managed by using the state property. The date
	// conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// User identifier path: /users/{userId}
	OwnerID *string `json:"ownerId,omitempty"`

	// Primary subscription key.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Scope like /products/{productId} or /apis or /apis/{apiId}
	Scope *string `json:"scope,omitempty"`

	// Secondary subscription key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`

	// Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked,
	// and the subscriber cannot call any APIs of the product, * submitted – the
	// subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription
	// request has been denied by an administrator, * cancelled – the
	// subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration
	// date and was deactivated.
	State *SubscriptionState `json:"state,omitempty"`

	// Comments describing subscription state change by the administrator when the state is changed to the 'rejected'.
	StateComment *string `json:"stateComment,omitempty"`
}

// SubscriptionUpdateParameters - Subscription update details.
type SubscriptionUpdateParameters struct {
	// Subscription Update contract properties.
	Properties *SubscriptionUpdateParameterProperties `json:"properties,omitempty"`
}

// SubscriptionsDelegationSettingsProperties - Subscriptions delegation settings properties.
type SubscriptionsDelegationSettingsProperties struct {
	// Enable or disable delegation for subscriptions.
	Enabled *bool `json:"enabled,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagClientAssignToAPIOptions contains the optional parameters for the TagClient.AssignToAPI method.
type TagClientAssignToAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientAssignToOperationOptions contains the optional parameters for the TagClient.AssignToOperation method.
type TagClientAssignToOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientAssignToProductOptions contains the optional parameters for the TagClient.AssignToProduct method.
type TagClientAssignToProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientCreateOrUpdateOptions contains the optional parameters for the TagClient.CreateOrUpdate method.
type TagClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// TagClientDeleteOptions contains the optional parameters for the TagClient.Delete method.
type TagClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TagClientDetachFromAPIOptions contains the optional parameters for the TagClient.DetachFromAPI method.
type TagClientDetachFromAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientDetachFromOperationOptions contains the optional parameters for the TagClient.DetachFromOperation method.
type TagClientDetachFromOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientDetachFromProductOptions contains the optional parameters for the TagClient.DetachFromProduct method.
type TagClientDetachFromProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetByAPIOptions contains the optional parameters for the TagClient.GetByAPI method.
type TagClientGetByAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetByOperationOptions contains the optional parameters for the TagClient.GetByOperation method.
type TagClientGetByOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetByProductOptions contains the optional parameters for the TagClient.GetByProduct method.
type TagClientGetByProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateByAPIOptions contains the optional parameters for the TagClient.GetEntityStateByAPI method.
type TagClientGetEntityStateByAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateByOperationOptions contains the optional parameters for the TagClient.GetEntityStateByOperation
// method.
type TagClientGetEntityStateByOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateByProductOptions contains the optional parameters for the TagClient.GetEntityStateByProduct method.
type TagClientGetEntityStateByProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateOptions contains the optional parameters for the TagClient.GetEntityState method.
type TagClientGetEntityStateOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetOptions contains the optional parameters for the TagClient.Get method.
type TagClientGetOptions struct {
	// placeholder for future optional parameters
}

// TagClientListByAPIOptions contains the optional parameters for the TagClient.ListByAPI method.
type TagClientListByAPIOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// TagClientListByOperationOptions contains the optional parameters for the TagClient.ListByOperation method.
type TagClientListByOperationOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// TagClientListByProductOptions contains the optional parameters for the TagClient.ListByProduct method.
type TagClientListByProductOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// TagClientListByServiceOptions contains the optional parameters for the TagClient.ListByService method.
type TagClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Scope like 'apis', 'products' or 'apis/{apiId}
	Scope *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// TagClientUpdateOptions contains the optional parameters for the TagClient.Update method.
type TagClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// TagCollection - Paged Tag list representation.
type TagCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*TagContract `json:"value,omitempty"`
}

// TagContract - Tag Contract details.
type TagContract struct {
	// Tag entity contract properties.
	Properties *TagContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TagContractProperties - Tag contract Properties.
type TagContractProperties struct {
	// REQUIRED; Tag name.
	DisplayName *string `json:"displayName,omitempty"`
}

// TagCreateUpdateParameters - Parameters supplied to Create/Update Tag operations.
type TagCreateUpdateParameters struct {
	// Properties supplied to Create Tag operation.
	Properties *TagContractProperties `json:"properties,omitempty"`
}

// TagDescriptionBaseProperties - Parameters supplied to the Create TagDescription operation.
type TagDescriptionBaseProperties struct {
	// Description of the Tag.
	Description *string `json:"description,omitempty"`

	// Description of the external resources describing the tag.
	ExternalDocsDescription *string `json:"externalDocsDescription,omitempty"`

	// Absolute URL of external resources describing the tag.
	ExternalDocsURL *string `json:"externalDocsUrl,omitempty"`
}

// TagDescriptionCollection - Paged TagDescription list representation.
type TagDescriptionCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*TagDescriptionContract `json:"value,omitempty"`
}

// TagDescriptionContract - Contract details.
type TagDescriptionContract struct {
	// TagDescription entity contract properties.
	Properties *TagDescriptionContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TagDescriptionContractProperties - TagDescription contract Properties.
type TagDescriptionContractProperties struct {
	// Description of the Tag.
	Description *string `json:"description,omitempty"`

	// Tag name.
	DisplayName *string `json:"displayName,omitempty"`

	// Description of the external resources describing the tag.
	ExternalDocsDescription *string `json:"externalDocsDescription,omitempty"`

	// Absolute URL of external resources describing the tag.
	ExternalDocsURL *string `json:"externalDocsUrl,omitempty"`

	// Identifier of the tag in the form of /tags/{tagId}
	TagID *string `json:"tagId,omitempty"`
}

// TagDescriptionCreateParameters - Parameters supplied to the Create TagDescription operation.
type TagDescriptionCreateParameters struct {
	// Properties supplied to Create TagDescription operation.
	Properties *TagDescriptionBaseProperties `json:"properties,omitempty"`
}

// TagResourceClientListByServiceOptions contains the optional parameters for the TagResourceClient.ListByService method.
type TagResourceClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | aid | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiRevision | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | method | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | urlTemplate | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | terms | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | isCurrent | filter | eq | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// TagResourceCollection - Paged Tag list representation.
type TagResourceCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*TagResourceContract `json:"value,omitempty"`
}

// TagResourceContract - TagResource contract properties.
type TagResourceContract struct {
	// REQUIRED; Tag associated with the resource.
	Tag *TagResourceContractProperties `json:"tag,omitempty"`

	// API associated with the tag.
	API *APITagResourceContractProperties `json:"api,omitempty"`

	// Operation associated with the tag.
	Operation *OperationTagResourceContractProperties `json:"operation,omitempty"`

	// Product associated with the tag.
	Product *ProductTagResourceContractProperties `json:"product,omitempty"`
}

// TagResourceContractProperties - Contract defining the Tag property in the Tag Resource Contract
type TagResourceContractProperties struct {
	// Tag identifier
	ID *string `json:"id,omitempty"`

	// Tag Name
	Name *string `json:"name,omitempty"`
}

// TenantAccessClientCreateOptions contains the optional parameters for the TenantAccessClient.Create method.
type TenantAccessClientCreateOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientGetEntityTagOptions contains the optional parameters for the TenantAccessClient.GetEntityTag method.
type TenantAccessClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientGetOptions contains the optional parameters for the TenantAccessClient.Get method.
type TenantAccessClientGetOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientListByServiceOptions contains the optional parameters for the TenantAccessClient.ListByService method.
type TenantAccessClientListByServiceOptions struct {
	// Not used
	Filter *string
}

// TenantAccessClientListSecretsOptions contains the optional parameters for the TenantAccessClient.ListSecrets method.
type TenantAccessClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientRegeneratePrimaryKeyOptions contains the optional parameters for the TenantAccessClient.RegeneratePrimaryKey
// method.
type TenantAccessClientRegeneratePrimaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientRegenerateSecondaryKeyOptions contains the optional parameters for the TenantAccessClient.RegenerateSecondaryKey
// method.
type TenantAccessClientRegenerateSecondaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientUpdateOptions contains the optional parameters for the TenantAccessClient.Update method.
type TenantAccessClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessGitClientRegeneratePrimaryKeyOptions contains the optional parameters for the TenantAccessGitClient.RegeneratePrimaryKey
// method.
type TenantAccessGitClientRegeneratePrimaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessGitClientRegenerateSecondaryKeyOptions contains the optional parameters for the TenantAccessGitClient.RegenerateSecondaryKey
// method.
type TenantAccessGitClientRegenerateSecondaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantConfigurationClientBeginDeployOptions contains the optional parameters for the TenantConfigurationClient.BeginDeploy
// method.
type TenantConfigurationClientBeginDeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TenantConfigurationClientBeginSaveOptions contains the optional parameters for the TenantConfigurationClient.BeginSave
// method.
type TenantConfigurationClientBeginSaveOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TenantConfigurationClientBeginValidateOptions contains the optional parameters for the TenantConfigurationClient.BeginValidate
// method.
type TenantConfigurationClientBeginValidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TenantConfigurationClientGetSyncStateOptions contains the optional parameters for the TenantConfigurationClient.GetSyncState
// method.
type TenantConfigurationClientGetSyncStateOptions struct {
	// placeholder for future optional parameters
}

// TenantConfigurationSyncStateContract - Result of Tenant Configuration Sync State.
type TenantConfigurationSyncStateContract struct {
	// Properties returned Tenant Configuration Sync State check.
	Properties *TenantConfigurationSyncStateContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TenantConfigurationSyncStateContractProperties - Tenant Configuration Synchronization State.
type TenantConfigurationSyncStateContractProperties struct {
	// The name of Git branch.
	Branch *string `json:"branch,omitempty"`

	// The latest commit Id.
	CommitID *string `json:"commitId,omitempty"`

	// The date of the latest configuration change. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	ConfigurationChangeDate *time.Time `json:"configurationChangeDate,omitempty"`

	// value indicating if last sync was save (true) or deploy (false) operation.
	IsExport *bool `json:"isExport,omitempty"`

	// value indicating whether Git configuration access is enabled.
	IsGitEnabled *bool `json:"isGitEnabled,omitempty"`

	// value indicating if last synchronization was later than the configuration change.
	IsSynced *bool `json:"isSynced,omitempty"`

	// Most recent tenant configuration operation identifier
	LastOperationID *string `json:"lastOperationId,omitempty"`

	// The date of the latest synchronization. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
	// the ISO 8601 standard.
	SyncDate *time.Time `json:"syncDate,omitempty"`
}

// TenantSettingsClientGetOptions contains the optional parameters for the TenantSettingsClient.Get method.
type TenantSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TenantSettingsClientListByServiceOptions contains the optional parameters for the TenantSettingsClient.ListByService method.
type TenantSettingsClientListByServiceOptions struct {
	// Not used
	Filter *string
}

// TenantSettingsCollection - Paged AccessInformation list representation.
type TenantSettingsCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Page values.
	Value []*TenantSettingsContract `json:"value,omitempty" azure:"ro"`
}

// TenantSettingsContract - Tenant Settings.
type TenantSettingsContract struct {
	// TenantSettings entity contract properties.
	Properties *TenantSettingsContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TenantSettingsContractProperties - Tenant access information contract of the API Management service.
type TenantSettingsContractProperties struct {
	// Tenant settings
	Settings map[string]*string `json:"settings,omitempty"`
}

// TermsOfServiceProperties - Terms of service contract properties.
type TermsOfServiceProperties struct {
	// Ask user for consent to the terms of service.
	ConsentRequired *bool `json:"consentRequired,omitempty"`

	// Display terms of service during a sign-up process.
	Enabled *bool `json:"enabled,omitempty"`

	// A terms of service text.
	Text *string `json:"text,omitempty"`
}

// TokenBodyParameterContract - OAuth acquire token request body parameter (www-url-form-encoded).
type TokenBodyParameterContract struct {
	// REQUIRED; body parameter name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; body parameter value.
	Value *string `json:"value,omitempty"`
}

// UserClientCreateOrUpdateOptions contains the optional parameters for the UserClient.CreateOrUpdate method.
type UserClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
	// Send an Email notification to the User.
	Notify *bool
}

// UserClientDeleteOptions contains the optional parameters for the UserClient.Delete method.
type UserClientDeleteOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType
	// Whether to delete user's subscription or not.
	DeleteSubscriptions *bool
	// Send an Account Closed Email notification to the User.
	Notify *bool
}

// UserClientGenerateSsoURLOptions contains the optional parameters for the UserClient.GenerateSsoURL method.
type UserClientGenerateSsoURLOptions struct {
	// placeholder for future optional parameters
}

// UserClientGetEntityTagOptions contains the optional parameters for the UserClient.GetEntityTag method.
type UserClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// UserClientGetOptions contains the optional parameters for the UserClient.Get method.
type UserClientGetOptions struct {
	// placeholder for future optional parameters
}

// UserClientGetSharedAccessTokenOptions contains the optional parameters for the UserClient.GetSharedAccessToken method.
type UserClientGetSharedAccessTokenOptions struct {
	// placeholder for future optional parameters
}

// UserClientListByServiceOptions contains the optional parameters for the UserClient.ListByService method.
type UserClientListByServiceOptions struct {
	// Detailed Group in response.
	ExpandGroups *bool
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | firstName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | lastName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | email | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | registrationDate | filter | ge, le, eq, ne, gt, lt | |
	// | note | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | groups | expand | | |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// UserClientUpdateOptions contains the optional parameters for the UserClient.Update method.
type UserClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// UserCollection - Paged Users list representation.
type UserCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Page values.
	Value []*UserContract `json:"value,omitempty"`
}

// UserConfirmationPasswordClientSendOptions contains the optional parameters for the UserConfirmationPasswordClient.Send
// method.
type UserConfirmationPasswordClientSendOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType
}

// UserContract - User details.
type UserContract struct {
	// User entity contract properties.
	Properties *UserContractProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserContractProperties - User profile.
type UserContractProperties struct {
	// Email address.
	Email *string `json:"email,omitempty"`

	// First name.
	FirstName *string `json:"firstName,omitempty"`

	// Collection of user identities.
	Identities []*UserIdentityContract `json:"identities,omitempty"`

	// Last name.
	LastName *string `json:"lastName,omitempty"`

	// Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`

	// Date of user registration. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	RegistrationDate *time.Time `json:"registrationDate,omitempty"`

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState `json:"state,omitempty"`

	// READ-ONLY; Collection of groups user is part of.
	Groups []*GroupContractProperties `json:"groups,omitempty" azure:"ro"`
}

// UserCreateParameterProperties - Parameters supplied to the Create User operation.
type UserCreateParameterProperties struct {
	// REQUIRED; Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`

	// REQUIRED; First name.
	FirstName *string `json:"firstName,omitempty"`

	// REQUIRED; Last name.
	LastName *string `json:"lastName,omitempty"`

	// Determines the type of application which send the create user request. Default is legacy portal.
	AppType *AppType `json:"appType,omitempty"`

	// Determines the type of confirmation e-mail that will be sent to the newly created user.
	Confirmation *Confirmation `json:"confirmation,omitempty"`

	// Collection of user identities.
	Identities []*UserIdentityContract `json:"identities,omitempty"`

	// Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`

	// User Password. If no value is provided, a default password is generated.
	Password *string `json:"password,omitempty"`

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState `json:"state,omitempty"`
}

// UserCreateParameters - User create details.
type UserCreateParameters struct {
	// User entity create contract properties.
	Properties *UserCreateParameterProperties `json:"properties,omitempty"`
}

// UserEntityBaseParameters - User Entity Base Parameters set.
type UserEntityBaseParameters struct {
	// Collection of user identities.
	Identities []*UserIdentityContract `json:"identities,omitempty"`

	// Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState `json:"state,omitempty"`
}

// UserGroupClientListOptions contains the optional parameters for the UserGroupClient.List method.
type UserGroupClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|------------------------|-----------------------------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// UserIdentitiesClientListOptions contains the optional parameters for the UserIdentitiesClient.List method.
type UserIdentitiesClientListOptions struct {
	// placeholder for future optional parameters
}

// UserIdentityCollection - List of Users Identity list representation.
type UserIdentityCollection struct {
	// Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`

	// Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`

	// User Identity values.
	Value []*UserIdentityContract `json:"value,omitempty"`
}

// UserIdentityContract - User identity details.
type UserIdentityContract struct {
	// Identifier value within provider.
	ID *string `json:"id,omitempty"`

	// Identity provider name.
	Provider *string `json:"provider,omitempty"`
}

type UserIdentityProperties struct {
	// The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
}

// UserSubscriptionClientGetOptions contains the optional parameters for the UserSubscriptionClient.Get method.
type UserSubscriptionClientGetOptions struct {
	// placeholder for future optional parameters
}

// UserSubscriptionClientListOptions contains the optional parameters for the UserSubscriptionClient.List method.
type UserSubscriptionClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|------------------------|-----------------------------------|
	// |name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |stateComment | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |ownerId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |scope | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string
	// Number of records to skip.
	Skip *int32
	// Number of records to return.
	Top *int32
}

// UserTokenParameterProperties - Parameters supplied to the Get User Token operation.
type UserTokenParameterProperties struct {
	// REQUIRED; The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following
	// format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	Expiry *time.Time `json:"expiry,omitempty"`

	// REQUIRED; The Key to be used to generate token for user.
	KeyType *KeyType `json:"keyType,omitempty"`
}

// UserTokenParameters - Get User Token parameters.
type UserTokenParameters struct {
	// User Token Parameter contract properties.
	Properties *UserTokenParameterProperties `json:"properties,omitempty"`
}

// UserTokenResult - Get User Token response details.
type UserTokenResult struct {
	// Shared Access Authorization token for the User.
	Value *string `json:"value,omitempty"`
}

// UserUpdateParameters - User update parameters.
type UserUpdateParameters struct {
	// User entity update contract properties.
	Properties *UserUpdateParametersProperties `json:"properties,omitempty"`
}

// UserUpdateParametersProperties - Parameters supplied to the Update User operation.
type UserUpdateParametersProperties struct {
	// Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`

	// First name.
	FirstName *string `json:"firstName,omitempty"`

	// Collection of user identities.
	Identities []*UserIdentityContract `json:"identities,omitempty"`

	// Last name.
	LastName *string `json:"lastName,omitempty"`

	// Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`

	// User Password.
	Password *string `json:"password,omitempty"`

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState `json:"state,omitempty"`
}

// VirtualNetworkConfiguration - Configuration of a virtual network to which API Management service is deployed.
type VirtualNetworkConfiguration struct {
	// The full resource ID of a subnet in a virtual network to deploy the API Management service in.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`

	// READ-ONLY; The name of the subnet.
	Subnetname *string `json:"subnetname,omitempty" azure:"ro"`

	// READ-ONLY; The virtual network ID. This is typically a GUID. Expect a null GUID by default.
	Vnetid *string `json:"vnetid,omitempty" azure:"ro"`
}

// X509CertificateName - Properties of server X509Names.
type X509CertificateName struct {
	// Thumbprint for the Issuer of the Certificate.
	IssuerCertificateThumbprint *string `json:"issuerCertificateThumbprint,omitempty"`

	// Common Name of the Certificate.
	Name *string `json:"name,omitempty"`
}
