//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ValidateClient contains the methods for the Validate group.
// Don't use this type directly, use NewValidateClient() instead.
type ValidateClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewValidateClient creates a new instance of ValidateClient with the specified values.
// subscriptionID - Azure Subscription ID.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewValidateClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ValidateClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ValidateClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Secret - Validate a Secret in the profile.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01
// validateSecretInput - The Secret source.
// options - ValidateClientSecretOptions contains the optional parameters for the ValidateClient.Secret method.
func (client *ValidateClient) Secret(ctx context.Context, validateSecretInput ValidateSecretInput, options *ValidateClientSecretOptions) (ValidateClientSecretResponse, error) {
	req, err := client.secretCreateRequest(ctx, validateSecretInput, options)
	if err != nil {
		return ValidateClientSecretResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ValidateClientSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ValidateClientSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.secretHandleResponse(resp)
}

// secretCreateRequest creates the Secret request.
func (client *ValidateClient) secretCreateRequest(ctx context.Context, validateSecretInput ValidateSecretInput, options *ValidateClientSecretOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateSecret"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, validateSecretInput)
}

// secretHandleResponse handles the Secret response.
func (client *ValidateClient) secretHandleResponse(resp *http.Response) (ValidateClientSecretResponse, error) {
	result := ValidateClientSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidateSecretOutput); err != nil {
		return ValidateClientSecretResponse{}, err
	}
	return result, nil
}
