//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevtestlabs

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ApplicableSchedule.
func (a ApplicableSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicableScheduleFragment.
func (a ApplicableScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplyArtifactsRequest.
func (a ApplyArtifactsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifacts", a.Artifacts)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplate.
func (a ArmTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplateProperties.
func (a ArmTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contents", &a.Contents)
	populateTimeRFC3339(objectMap, "createdDate", a.CreatedDate)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "icon", a.Icon)
	populate(objectMap, "parametersValueFilesInfo", a.ParametersValueFilesInfo)
	populate(objectMap, "publisher", a.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplateProperties.
func (a *ArmTemplateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contents":
			err = unpopulate(val, "Contents", &a.Contents)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &a.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &a.Icon)
			delete(rawMsg, key)
		case "parametersValueFilesInfo":
			err = unpopulate(val, "ParametersValueFilesInfo", &a.ParametersValueFilesInfo)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &a.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Artifact.
func (a Artifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactInstallProperties.
func (a ArtifactInstallProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifactId", a.ArtifactID)
	populate(objectMap, "artifactTitle", a.ArtifactTitle)
	populate(objectMap, "deploymentStatusMessage", a.DeploymentStatusMessage)
	populateTimeRFC3339(objectMap, "installTime", a.InstallTime)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "vmExtensionStatusMessage", a.VMExtensionStatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactInstallProperties.
func (a *ArtifactInstallProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactId":
			err = unpopulate(val, "ArtifactID", &a.ArtifactID)
			delete(rawMsg, key)
		case "artifactTitle":
			err = unpopulate(val, "ArtifactTitle", &a.ArtifactTitle)
			delete(rawMsg, key)
		case "deploymentStatusMessage":
			err = unpopulate(val, "DeploymentStatusMessage", &a.DeploymentStatusMessage)
			delete(rawMsg, key)
		case "installTime":
			err = unpopulateTimeRFC3339(val, "InstallTime", &a.InstallTime)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "vmExtensionStatusMessage":
			err = unpopulate(val, "VMExtensionStatusMessage", &a.VMExtensionStatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactProperties.
func (a ArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", a.CreatedDate)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "filePath", a.FilePath)
	populate(objectMap, "icon", a.Icon)
	populate(objectMap, "parameters", &a.Parameters)
	populate(objectMap, "publisher", a.Publisher)
	populate(objectMap, "targetOsType", a.TargetOsType)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactProperties.
func (a *ArtifactProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &a.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &a.FilePath)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &a.Icon)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &a.Publisher)
			delete(rawMsg, key)
		case "targetOsType":
			err = unpopulate(val, "TargetOsType", &a.TargetOsType)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSource.
func (a ArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourceFragment.
func (a ArtifactSourceFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourceProperties.
func (a ArtifactSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "armTemplateFolderPath", a.ArmTemplateFolderPath)
	populate(objectMap, "branchRef", a.BranchRef)
	populateTimeRFC3339(objectMap, "createdDate", a.CreatedDate)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "folderPath", a.FolderPath)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "securityToken", a.SecurityToken)
	populate(objectMap, "sourceType", a.SourceType)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "uri", a.URI)
	populate(objectMap, "uniqueIdentifier", a.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourceProperties.
func (a *ArtifactSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "armTemplateFolderPath":
			err = unpopulate(val, "ArmTemplateFolderPath", &a.ArmTemplateFolderPath)
			delete(rawMsg, key)
		case "branchRef":
			err = unpopulate(val, "BranchRef", &a.BranchRef)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &a.CreatedDate)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "securityToken":
			err = unpopulate(val, "SecurityToken", &a.SecurityToken)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &a.URI)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &a.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeVMProperties.
func (c ComputeVMProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDiskIds", c.DataDiskIDs)
	populate(objectMap, "dataDisks", c.DataDisks)
	populate(objectMap, "networkInterfaceId", c.NetworkInterfaceID)
	populate(objectMap, "osDiskId", c.OSDiskID)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "statuses", c.Statuses)
	populate(objectMap, "vmSize", c.VMSize)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CustomImage.
func (c CustomImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CustomImageFragment.
func (c CustomImageFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CustomImageProperties.
func (c CustomImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "author", c.Author)
	populateTimeRFC3339(objectMap, "creationDate", c.CreationDate)
	populate(objectMap, "customImagePlan", c.CustomImagePlan)
	populate(objectMap, "dataDiskStorageInfo", c.DataDiskStorageInfo)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "isPlanAuthorized", c.IsPlanAuthorized)
	populate(objectMap, "managedImageId", c.ManagedImageID)
	populate(objectMap, "managedSnapshotId", c.ManagedSnapshotID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", c.UniqueIdentifier)
	populate(objectMap, "vm", c.VM)
	populate(objectMap, "vhd", c.Vhd)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImageProperties.
func (c *CustomImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "author":
			err = unpopulate(val, "Author", &c.Author)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &c.CreationDate)
			delete(rawMsg, key)
		case "customImagePlan":
			err = unpopulate(val, "CustomImagePlan", &c.CustomImagePlan)
			delete(rawMsg, key)
		case "dataDiskStorageInfo":
			err = unpopulate(val, "DataDiskStorageInfo", &c.DataDiskStorageInfo)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "isPlanAuthorized":
			err = unpopulate(val, "IsPlanAuthorized", &c.IsPlanAuthorized)
			delete(rawMsg, key)
		case "managedImageId":
			err = unpopulate(val, "ManagedImageID", &c.ManagedImageID)
			delete(rawMsg, key)
		case "managedSnapshotId":
			err = unpopulate(val, "ManagedSnapshotID", &c.ManagedSnapshotID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &c.UniqueIdentifier)
			delete(rawMsg, key)
		case "vm":
			err = unpopulate(val, "VM", &c.VM)
			delete(rawMsg, key)
		case "vhd":
			err = unpopulate(val, "Vhd", &c.Vhd)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskFragment.
func (d DiskFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskProperties.
func (d DiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", d.CreatedDate)
	populate(objectMap, "diskBlobName", d.DiskBlobName)
	populate(objectMap, "diskSizeGiB", d.DiskSizeGiB)
	populate(objectMap, "diskType", d.DiskType)
	populate(objectMap, "diskUri", d.DiskURI)
	populate(objectMap, "hostCaching", d.HostCaching)
	populate(objectMap, "leasedByLabVmId", d.LeasedByLabVMID)
	populate(objectMap, "managedDiskId", d.ManagedDiskID)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "storageAccountId", d.StorageAccountID)
	populate(objectMap, "uniqueIdentifier", d.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskProperties.
func (d *DiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &d.CreatedDate)
			delete(rawMsg, key)
		case "diskBlobName":
			err = unpopulate(val, "DiskBlobName", &d.DiskBlobName)
			delete(rawMsg, key)
		case "diskSizeGiB":
			err = unpopulate(val, "DiskSizeGiB", &d.DiskSizeGiB)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &d.DiskType)
			delete(rawMsg, key)
		case "diskUri":
			err = unpopulate(val, "DiskURI", &d.DiskURI)
			delete(rawMsg, key)
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &d.HostCaching)
			delete(rawMsg, key)
		case "leasedByLabVmId":
			err = unpopulate(val, "LeasedByLabVMID", &d.LeasedByLabVMID)
			delete(rawMsg, key)
		case "managedDiskId":
			err = unpopulate(val, "ManagedDiskID", &d.ManagedDiskID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &d.StorageAccountID)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &d.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DtlEnvironment.
func (d DtlEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DtlEnvironmentFragment.
func (d DtlEnvironmentFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentDeploymentProperties.
func (e EnvironmentDeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "armTemplateId", e.ArmTemplateID)
	populate(objectMap, "parameters", e.Parameters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EvaluatePoliciesRequest.
func (e EvaluatePoliciesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "policies", e.Policies)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ExportResourceUsageParameters.
func (e ExportResourceUsageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobStorageAbsoluteSasUri", e.BlobStorageAbsoluteSasURI)
	populateTimeRFC3339(objectMap, "usageStartDate", e.UsageStartDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportResourceUsageParameters.
func (e *ExportResourceUsageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobStorageAbsoluteSasUri":
			err = unpopulate(val, "BlobStorageAbsoluteSasURI", &e.BlobStorageAbsoluteSasURI)
			delete(rawMsg, key)
		case "usageStartDate":
			err = unpopulateTimeRFC3339(val, "UsageStartDate", &e.UsageStartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Formula.
func (f Formula) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FormulaFragment.
func (f FormulaFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", f.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FormulaProperties.
func (f FormulaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "author", f.Author)
	populateTimeRFC3339(objectMap, "creationDate", f.CreationDate)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "formulaContent", f.FormulaContent)
	populate(objectMap, "osType", f.OSType)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", f.UniqueIdentifier)
	populate(objectMap, "vm", f.VM)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FormulaProperties.
func (f *FormulaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "author":
			err = unpopulate(val, "Author", &f.Author)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &f.CreationDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "formulaContent":
			err = unpopulate(val, "FormulaContent", &f.FormulaContent)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &f.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &f.UniqueIdentifier)
			delete(rawMsg, key)
		case "vm":
			err = unpopulate(val, "VM", &f.VM)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImage.
func (g GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageProperties.
func (g GalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "author", g.Author)
	populateTimeRFC3339(objectMap, "createdDate", g.CreatedDate)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "enabled", g.Enabled)
	populate(objectMap, "icon", g.Icon)
	populate(objectMap, "imageReference", g.ImageReference)
	populate(objectMap, "isPlanAuthorized", g.IsPlanAuthorized)
	populate(objectMap, "planId", g.PlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageProperties.
func (g *GalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "author":
			err = unpopulate(val, "Author", &g.Author)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &g.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &g.Enabled)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &g.Icon)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &g.ImageReference)
			delete(rawMsg, key)
		case "isPlanAuthorized":
			err = unpopulate(val, "IsPlanAuthorized", &g.IsPlanAuthorized)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &g.PlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateArmTemplateRequest.
func (g GenerateArmTemplateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fileUploadOptions", g.FileUploadOptions)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "parameters", g.Parameters)
	populate(objectMap, "virtualMachineName", g.VirtualMachineName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Lab.
func (l Lab) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LabAnnouncementProperties.
func (l LabAnnouncementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", l.Enabled)
	populateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "expired", l.Expired)
	populate(objectMap, "markdown", l.Markdown)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "title", l.Title)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabAnnouncementProperties.
func (l *LabAnnouncementProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &l.Enabled)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "expired":
			err = unpopulate(val, "Expired", &l.Expired)
			delete(rawMsg, key)
		case "markdown":
			err = unpopulate(val, "Markdown", &l.Markdown)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &l.Title)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabCost.
func (l LabCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LabCostDetailsProperties.
func (l LabCostDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cost", l.Cost)
	populate(objectMap, "costType", l.CostType)
	populateTimeRFC3339(objectMap, "date", l.Date)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabCostDetailsProperties.
func (l *LabCostDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cost":
			err = unpopulate(val, "Cost", &l.Cost)
			delete(rawMsg, key)
		case "costType":
			err = unpopulate(val, "CostType", &l.CostType)
			delete(rawMsg, key)
		case "date":
			err = unpopulateTimeRFC3339(val, "Date", &l.Date)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabCostProperties.
func (l LabCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "currencyCode", l.CurrencyCode)
	populateTimeRFC3339(objectMap, "endDateTime", l.EndDateTime)
	populate(objectMap, "labCostDetails", l.LabCostDetails)
	populate(objectMap, "labCostSummary", l.LabCostSummary)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceCosts", l.ResourceCosts)
	populateTimeRFC3339(objectMap, "startDateTime", l.StartDateTime)
	populate(objectMap, "targetCost", l.TargetCost)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabCostProperties.
func (l *LabCostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &l.CurrencyCode)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateTimeRFC3339(val, "EndDateTime", &l.EndDateTime)
			delete(rawMsg, key)
		case "labCostDetails":
			err = unpopulate(val, "LabCostDetails", &l.LabCostDetails)
			delete(rawMsg, key)
		case "labCostSummary":
			err = unpopulate(val, "LabCostSummary", &l.LabCostSummary)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceCosts":
			err = unpopulate(val, "ResourceCosts", &l.ResourceCosts)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateTimeRFC3339(val, "StartDateTime", &l.StartDateTime)
			delete(rawMsg, key)
		case "targetCost":
			err = unpopulate(val, "TargetCost", &l.TargetCost)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabFragment.
func (l LabFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LabProperties.
func (l LabProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "announcement", l.Announcement)
	populate(objectMap, "artifactsStorageAccount", l.ArtifactsStorageAccount)
	populateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "defaultPremiumStorageAccount", l.DefaultPremiumStorageAccount)
	populate(objectMap, "defaultStorageAccount", l.DefaultStorageAccount)
	populate(objectMap, "environmentPermission", l.EnvironmentPermission)
	populate(objectMap, "extendedProperties", l.ExtendedProperties)
	populate(objectMap, "labStorageType", l.LabStorageType)
	populate(objectMap, "loadBalancerId", l.LoadBalancerID)
	populate(objectMap, "mandatoryArtifactsResourceIdsLinux", l.MandatoryArtifactsResourceIDsLinux)
	populate(objectMap, "mandatoryArtifactsResourceIdsWindows", l.MandatoryArtifactsResourceIDsWindows)
	populate(objectMap, "networkSecurityGroupId", l.NetworkSecurityGroupID)
	populate(objectMap, "premiumDataDiskStorageAccount", l.PremiumDataDiskStorageAccount)
	populate(objectMap, "premiumDataDisks", l.PremiumDataDisks)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "publicIpId", l.PublicIPID)
	populate(objectMap, "support", l.Support)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	populate(objectMap, "vmCreationResourceGroup", l.VMCreationResourceGroup)
	populate(objectMap, "vaultName", l.VaultName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabProperties.
func (l *LabProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "announcement":
			err = unpopulate(val, "Announcement", &l.Announcement)
			delete(rawMsg, key)
		case "artifactsStorageAccount":
			err = unpopulate(val, "ArtifactsStorageAccount", &l.ArtifactsStorageAccount)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "defaultPremiumStorageAccount":
			err = unpopulate(val, "DefaultPremiumStorageAccount", &l.DefaultPremiumStorageAccount)
			delete(rawMsg, key)
		case "defaultStorageAccount":
			err = unpopulate(val, "DefaultStorageAccount", &l.DefaultStorageAccount)
			delete(rawMsg, key)
		case "environmentPermission":
			err = unpopulate(val, "EnvironmentPermission", &l.EnvironmentPermission)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &l.ExtendedProperties)
			delete(rawMsg, key)
		case "labStorageType":
			err = unpopulate(val, "LabStorageType", &l.LabStorageType)
			delete(rawMsg, key)
		case "loadBalancerId":
			err = unpopulate(val, "LoadBalancerID", &l.LoadBalancerID)
			delete(rawMsg, key)
		case "mandatoryArtifactsResourceIdsLinux":
			err = unpopulate(val, "MandatoryArtifactsResourceIDsLinux", &l.MandatoryArtifactsResourceIDsLinux)
			delete(rawMsg, key)
		case "mandatoryArtifactsResourceIdsWindows":
			err = unpopulate(val, "MandatoryArtifactsResourceIDsWindows", &l.MandatoryArtifactsResourceIDsWindows)
			delete(rawMsg, key)
		case "networkSecurityGroupId":
			err = unpopulate(val, "NetworkSecurityGroupID", &l.NetworkSecurityGroupID)
			delete(rawMsg, key)
		case "premiumDataDiskStorageAccount":
			err = unpopulate(val, "PremiumDataDiskStorageAccount", &l.PremiumDataDiskStorageAccount)
			delete(rawMsg, key)
		case "premiumDataDisks":
			err = unpopulate(val, "PremiumDataDisks", &l.PremiumDataDisks)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpId":
			err = unpopulate(val, "PublicIPID", &l.PublicIPID)
			delete(rawMsg, key)
		case "support":
			err = unpopulate(val, "Support", &l.Support)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		case "vmCreationResourceGroup":
			err = unpopulate(val, "VMCreationResourceGroup", &l.VMCreationResourceGroup)
			delete(rawMsg, key)
		case "vaultName":
			err = unpopulate(val, "VaultName", &l.VaultName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachine.
func (l LabVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineCreationParameter.
func (l LabVirtualMachineCreationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineCreationParameterProperties.
func (l LabVirtualMachineCreationParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowClaim", l.AllowClaim)
	populate(objectMap, "artifacts", l.Artifacts)
	populate(objectMap, "bulkCreationParameters", l.BulkCreationParameters)
	populateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "customImageId", l.CustomImageID)
	populate(objectMap, "dataDiskParameters", l.DataDiskParameters)
	populate(objectMap, "disallowPublicIpAddress", l.DisallowPublicIPAddress)
	populate(objectMap, "environmentId", l.EnvironmentID)
	populateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "galleryImageReference", l.GalleryImageReference)
	populate(objectMap, "isAuthenticationWithSshKey", l.IsAuthenticationWithSSHKey)
	populate(objectMap, "labSubnetName", l.LabSubnetName)
	populate(objectMap, "labVirtualNetworkId", l.LabVirtualNetworkID)
	populate(objectMap, "networkInterface", l.NetworkInterface)
	populate(objectMap, "notes", l.Notes)
	populate(objectMap, "ownerObjectId", l.OwnerObjectID)
	populate(objectMap, "ownerUserPrincipalName", l.OwnerUserPrincipalName)
	populate(objectMap, "password", l.Password)
	populate(objectMap, "planId", l.PlanID)
	populate(objectMap, "sshKey", l.SSHKey)
	populate(objectMap, "scheduleParameters", l.ScheduleParameters)
	populate(objectMap, "size", l.Size)
	populate(objectMap, "storageType", l.StorageType)
	populate(objectMap, "userName", l.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachineCreationParameterProperties.
func (l *LabVirtualMachineCreationParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowClaim":
			err = unpopulate(val, "AllowClaim", &l.AllowClaim)
			delete(rawMsg, key)
		case "artifacts":
			err = unpopulate(val, "Artifacts", &l.Artifacts)
			delete(rawMsg, key)
		case "bulkCreationParameters":
			err = unpopulate(val, "BulkCreationParameters", &l.BulkCreationParameters)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "customImageId":
			err = unpopulate(val, "CustomImageID", &l.CustomImageID)
			delete(rawMsg, key)
		case "dataDiskParameters":
			err = unpopulate(val, "DataDiskParameters", &l.DataDiskParameters)
			delete(rawMsg, key)
		case "disallowPublicIpAddress":
			err = unpopulate(val, "DisallowPublicIPAddress", &l.DisallowPublicIPAddress)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &l.EnvironmentID)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "galleryImageReference":
			err = unpopulate(val, "GalleryImageReference", &l.GalleryImageReference)
			delete(rawMsg, key)
		case "isAuthenticationWithSshKey":
			err = unpopulate(val, "IsAuthenticationWithSSHKey", &l.IsAuthenticationWithSSHKey)
			delete(rawMsg, key)
		case "labSubnetName":
			err = unpopulate(val, "LabSubnetName", &l.LabSubnetName)
			delete(rawMsg, key)
		case "labVirtualNetworkId":
			err = unpopulate(val, "LabVirtualNetworkID", &l.LabVirtualNetworkID)
			delete(rawMsg, key)
		case "networkInterface":
			err = unpopulate(val, "NetworkInterface", &l.NetworkInterface)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &l.Notes)
			delete(rawMsg, key)
		case "ownerObjectId":
			err = unpopulate(val, "OwnerObjectID", &l.OwnerObjectID)
			delete(rawMsg, key)
		case "ownerUserPrincipalName":
			err = unpopulate(val, "OwnerUserPrincipalName", &l.OwnerUserPrincipalName)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &l.Password)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &l.PlanID)
			delete(rawMsg, key)
		case "sshKey":
			err = unpopulate(val, "SSHKey", &l.SSHKey)
			delete(rawMsg, key)
		case "scheduleParameters":
			err = unpopulate(val, "ScheduleParameters", &l.ScheduleParameters)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &l.Size)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &l.StorageType)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &l.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineFragment.
func (l LabVirtualMachineFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineProperties.
func (l LabVirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowClaim", l.AllowClaim)
	populate(objectMap, "applicableSchedule", l.ApplicableSchedule)
	populate(objectMap, "artifactDeploymentStatus", l.ArtifactDeploymentStatus)
	populate(objectMap, "artifacts", l.Artifacts)
	populate(objectMap, "computeId", l.ComputeID)
	populate(objectMap, "computeVm", l.ComputeVM)
	populate(objectMap, "createdByUser", l.CreatedByUser)
	populate(objectMap, "createdByUserId", l.CreatedByUserID)
	populateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "customImageId", l.CustomImageID)
	populate(objectMap, "dataDiskParameters", l.DataDiskParameters)
	populate(objectMap, "disallowPublicIpAddress", l.DisallowPublicIPAddress)
	populate(objectMap, "environmentId", l.EnvironmentID)
	populateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "fqdn", l.Fqdn)
	populate(objectMap, "galleryImageReference", l.GalleryImageReference)
	populate(objectMap, "isAuthenticationWithSshKey", l.IsAuthenticationWithSSHKey)
	populate(objectMap, "labSubnetName", l.LabSubnetName)
	populate(objectMap, "labVirtualNetworkId", l.LabVirtualNetworkID)
	populate(objectMap, "lastKnownPowerState", l.LastKnownPowerState)
	populate(objectMap, "networkInterface", l.NetworkInterface)
	populate(objectMap, "notes", l.Notes)
	populate(objectMap, "osType", l.OSType)
	populate(objectMap, "ownerObjectId", l.OwnerObjectID)
	populate(objectMap, "ownerUserPrincipalName", l.OwnerUserPrincipalName)
	populate(objectMap, "password", l.Password)
	populate(objectMap, "planId", l.PlanID)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "sshKey", l.SSHKey)
	populate(objectMap, "scheduleParameters", l.ScheduleParameters)
	populate(objectMap, "size", l.Size)
	populate(objectMap, "storageType", l.StorageType)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	populate(objectMap, "userName", l.UserName)
	populate(objectMap, "virtualMachineCreationSource", l.VirtualMachineCreationSource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachineProperties.
func (l *LabVirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowClaim":
			err = unpopulate(val, "AllowClaim", &l.AllowClaim)
			delete(rawMsg, key)
		case "applicableSchedule":
			err = unpopulate(val, "ApplicableSchedule", &l.ApplicableSchedule)
			delete(rawMsg, key)
		case "artifactDeploymentStatus":
			err = unpopulate(val, "ArtifactDeploymentStatus", &l.ArtifactDeploymentStatus)
			delete(rawMsg, key)
		case "artifacts":
			err = unpopulate(val, "Artifacts", &l.Artifacts)
			delete(rawMsg, key)
		case "computeId":
			err = unpopulate(val, "ComputeID", &l.ComputeID)
			delete(rawMsg, key)
		case "computeVm":
			err = unpopulate(val, "ComputeVM", &l.ComputeVM)
			delete(rawMsg, key)
		case "createdByUser":
			err = unpopulate(val, "CreatedByUser", &l.CreatedByUser)
			delete(rawMsg, key)
		case "createdByUserId":
			err = unpopulate(val, "CreatedByUserID", &l.CreatedByUserID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "customImageId":
			err = unpopulate(val, "CustomImageID", &l.CustomImageID)
			delete(rawMsg, key)
		case "dataDiskParameters":
			err = unpopulate(val, "DataDiskParameters", &l.DataDiskParameters)
			delete(rawMsg, key)
		case "disallowPublicIpAddress":
			err = unpopulate(val, "DisallowPublicIPAddress", &l.DisallowPublicIPAddress)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &l.EnvironmentID)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &l.Fqdn)
			delete(rawMsg, key)
		case "galleryImageReference":
			err = unpopulate(val, "GalleryImageReference", &l.GalleryImageReference)
			delete(rawMsg, key)
		case "isAuthenticationWithSshKey":
			err = unpopulate(val, "IsAuthenticationWithSSHKey", &l.IsAuthenticationWithSSHKey)
			delete(rawMsg, key)
		case "labSubnetName":
			err = unpopulate(val, "LabSubnetName", &l.LabSubnetName)
			delete(rawMsg, key)
		case "labVirtualNetworkId":
			err = unpopulate(val, "LabVirtualNetworkID", &l.LabVirtualNetworkID)
			delete(rawMsg, key)
		case "lastKnownPowerState":
			err = unpopulate(val, "LastKnownPowerState", &l.LastKnownPowerState)
			delete(rawMsg, key)
		case "networkInterface":
			err = unpopulate(val, "NetworkInterface", &l.NetworkInterface)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &l.Notes)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &l.OSType)
			delete(rawMsg, key)
		case "ownerObjectId":
			err = unpopulate(val, "OwnerObjectID", &l.OwnerObjectID)
			delete(rawMsg, key)
		case "ownerUserPrincipalName":
			err = unpopulate(val, "OwnerUserPrincipalName", &l.OwnerUserPrincipalName)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &l.Password)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &l.PlanID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "sshKey":
			err = unpopulate(val, "SSHKey", &l.SSHKey)
			delete(rawMsg, key)
		case "scheduleParameters":
			err = unpopulate(val, "ScheduleParameters", &l.ScheduleParameters)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &l.Size)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &l.StorageType)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &l.UserName)
			delete(rawMsg, key)
		case "virtualMachineCreationSource":
			err = unpopulate(val, "VirtualMachineCreationSource", &l.VirtualMachineCreationSource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationChannel.
func (n NotificationChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NotificationChannelFragment.
func (n NotificationChannelFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NotificationChannelProperties.
func (n NotificationChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", n.CreatedDate)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "emailRecipient", n.EmailRecipient)
	populate(objectMap, "events", n.Events)
	populate(objectMap, "notificationLocale", n.NotificationLocale)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", n.UniqueIdentifier)
	populate(objectMap, "webHookUrl", n.WebHookURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationChannelProperties.
func (n *NotificationChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &n.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "emailRecipient":
			err = unpopulate(val, "EmailRecipient", &n.EmailRecipient)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &n.Events)
			delete(rawMsg, key)
		case "notificationLocale":
			err = unpopulate(val, "NotificationLocale", &n.NotificationLocale)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &n.UniqueIdentifier)
			delete(rawMsg, key)
		case "webHookUrl":
			err = unpopulate(val, "WebHookURL", &n.WebHookURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PolicyFragment.
func (p PolicyFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PolicyProperties.
func (p PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", p.CreatedDate)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "evaluatorType", p.EvaluatorType)
	populate(objectMap, "factData", p.FactData)
	populate(objectMap, "factName", p.FactName)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "threshold", p.Threshold)
	populate(objectMap, "uniqueIdentifier", p.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProperties.
func (p *PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &p.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "evaluatorType":
			err = unpopulate(val, "EvaluatorType", &p.EvaluatorType)
			delete(rawMsg, key)
		case "factData":
			err = unpopulate(val, "FactData", &p.FactData)
			delete(rawMsg, key)
		case "factName":
			err = unpopulate(val, "FactName", &p.FactName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "threshold":
			err = unpopulate(val, "Threshold", &p.Threshold)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &p.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleCreationParameter.
func (s ScheduleCreationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleFragment.
func (s ScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleProperties.
func (s ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", s.CreatedDate)
	populate(objectMap, "dailyRecurrence", s.DailyRecurrence)
	populate(objectMap, "hourlyRecurrence", s.HourlyRecurrence)
	populate(objectMap, "notificationSettings", s.NotificationSettings)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "targetResourceId", s.TargetResourceID)
	populate(objectMap, "taskType", s.TaskType)
	populate(objectMap, "timeZoneId", s.TimeZoneID)
	populate(objectMap, "uniqueIdentifier", s.UniqueIdentifier)
	populate(objectMap, "weeklyRecurrence", s.WeeklyRecurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleProperties.
func (s *ScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &s.CreatedDate)
			delete(rawMsg, key)
		case "dailyRecurrence":
			err = unpopulate(val, "DailyRecurrence", &s.DailyRecurrence)
			delete(rawMsg, key)
		case "hourlyRecurrence":
			err = unpopulate(val, "HourlyRecurrence", &s.HourlyRecurrence)
			delete(rawMsg, key)
		case "notificationSettings":
			err = unpopulate(val, "NotificationSettings", &s.NotificationSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &s.TargetResourceID)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &s.TaskType)
			delete(rawMsg, key)
		case "timeZoneId":
			err = unpopulate(val, "TimeZoneID", &s.TimeZoneID)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &s.UniqueIdentifier)
			delete(rawMsg, key)
		case "weeklyRecurrence":
			err = unpopulate(val, "WeeklyRecurrence", &s.WeeklyRecurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecretFragment.
func (s SecretFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceFabric.
func (s ServiceFabric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceFabricFragment.
func (s ServiceFabricFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceRunner.
func (s ServiceRunner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SharedPublicIPAddressConfiguration.
func (s SharedPublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inboundNatRules", s.InboundNatRules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SubnetSharedPublicIPAddressConfiguration.
func (s SubnetSharedPublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedPorts", s.AllowedPorts)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TargetCostProperties.
func (t TargetCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "costThresholds", t.CostThresholds)
	populateTimeRFC3339(objectMap, "cycleEndDateTime", t.CycleEndDateTime)
	populateTimeRFC3339(objectMap, "cycleStartDateTime", t.CycleStartDateTime)
	populate(objectMap, "cycleType", t.CycleType)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "target", t.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetCostProperties.
func (t *TargetCostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costThresholds":
			err = unpopulate(val, "CostThresholds", &t.CostThresholds)
			delete(rawMsg, key)
		case "cycleEndDateTime":
			err = unpopulateTimeRFC3339(val, "CycleEndDateTime", &t.CycleEndDateTime)
			delete(rawMsg, key)
		case "cycleStartDateTime":
			err = unpopulateTimeRFC3339(val, "CycleStartDateTime", &t.CycleStartDateTime)
			delete(rawMsg, key)
		case "cycleType":
			err = unpopulate(val, "CycleType", &t.CycleType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &t.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateResource.
func (u UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", u.ID)
	populate(objectMap, "location", u.Location)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "tags", u.Tags)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UserFragment.
func (u UserFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UserProperties.
func (u UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", u.CreatedDate)
	populate(objectMap, "identity", u.Identity)
	populate(objectMap, "provisioningState", u.ProvisioningState)
	populate(objectMap, "secretStore", u.SecretStore)
	populate(objectMap, "uniqueIdentifier", u.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserProperties.
func (u *UserProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &u.CreatedDate)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &u.Identity)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &u.ProvisioningState)
			delete(rawMsg, key)
		case "secretStore":
			err = unpopulate(val, "SecretStore", &u.SecretStore)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &u.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetwork.
func (v VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkFragment.
func (v VirtualNetworkFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProperties.
func (v VirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedSubnets", v.AllowedSubnets)
	populateTimeRFC3339(objectMap, "createdDate", v.CreatedDate)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "externalProviderResourceId", v.ExternalProviderResourceID)
	populate(objectMap, "externalSubnets", v.ExternalSubnets)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "subnetOverrides", v.SubnetOverrides)
	populate(objectMap, "uniqueIdentifier", v.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProperties.
func (v *VirtualNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedSubnets":
			err = unpopulate(val, "AllowedSubnets", &v.AllowedSubnets)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &v.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "externalProviderResourceId":
			err = unpopulate(val, "ExternalProviderResourceID", &v.ExternalProviderResourceID)
			delete(rawMsg, key)
		case "externalSubnets":
			err = unpopulate(val, "ExternalSubnets", &v.ExternalSubnets)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "subnetOverrides":
			err = unpopulate(val, "SubnetOverrides", &v.SubnetOverrides)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &v.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WeekDetails.
func (w WeekDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "time", w.Time)
	populate(objectMap, "weekdays", w.Weekdays)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
