//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventhub

import "time"

// AccessKeys - Namespace/EventHub Connection String
type AccessKeys struct {
	// READ-ONLY; Primary connection string of the alias if GEO DR is enabled
	AliasPrimaryConnectionString *string `json:"aliasPrimaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; Secondary connection string of the alias if GEO DR is enabled
	AliasSecondaryConnectionString *string `json:"aliasSecondaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A string that describes the AuthorizationRule.
	KeyName *string `json:"keyName,omitempty" azure:"ro"`

	// READ-ONLY; Primary connection string of the created namespace AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty" azure:"ro"`

	// READ-ONLY; Secondary connection string of the created namespace AuthorizationRule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty" azure:"ro"`
}

// ApplicationGroup - The Application Group object
type ApplicationGroup struct {
	Properties *ApplicationGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGroupClientCreateOrUpdateApplicationGroupOptions contains the optional parameters for the ApplicationGroupClient.CreateOrUpdateApplicationGroup
// method.
type ApplicationGroupClientCreateOrUpdateApplicationGroupOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGroupClientDeleteOptions contains the optional parameters for the ApplicationGroupClient.Delete method.
type ApplicationGroupClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGroupClientGetOptions contains the optional parameters for the ApplicationGroupClient.Get method.
type ApplicationGroupClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGroupClientListByNamespaceOptions contains the optional parameters for the ApplicationGroupClient.ListByNamespace
// method.
type ApplicationGroupClientListByNamespaceOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGroupListResult - The response from the List Application Groups operation.
type ApplicationGroupListResult struct {
	// Result of the List Application Groups operation.
	Value []*ApplicationGroup `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if Value contains an incomplete list of Authorization Rules
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ApplicationGroupPolicyClassification provides polymorphic access to related types.
// Call the interface's GetApplicationGroupPolicy() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ApplicationGroupPolicy, *ThrottlingPolicy
type ApplicationGroupPolicyClassification interface {
	// GetApplicationGroupPolicy returns the ApplicationGroupPolicy content of the underlying type.
	GetApplicationGroupPolicy() *ApplicationGroupPolicy
}

// ApplicationGroupPolicy - Properties of the Application Group policy
type ApplicationGroupPolicy struct {
	// REQUIRED; The Name of this policy
	Name *string `json:"name,omitempty"`

	// REQUIRED; Application Group Policy types
	Type *ApplicationGroupPolicyType `json:"type,omitempty"`
}

// GetApplicationGroupPolicy implements the ApplicationGroupPolicyClassification interface for type ApplicationGroupPolicy.
func (a *ApplicationGroupPolicy) GetApplicationGroupPolicy() *ApplicationGroupPolicy { return a }

type ApplicationGroupProperties struct {
	// REQUIRED; The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)
	ClientAppGroupIdentifier *string `json:"clientAppGroupIdentifier,omitempty"`

	// Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false,
	// all the existing connections of application group gets dropped and no new
	// connections will be allowed
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// List of group policies that define the behavior of application group. The policies can support resource governance scenarios
	// such as limiting ingress or egress traffic.
	Policies []ApplicationGroupPolicyClassification `json:"policies,omitempty"`
}

// ArmDisasterRecovery - Single item in List or Get Alias(Disaster Recovery configuration) operation
type ArmDisasterRecovery struct {
	// Properties required to the Create Or Update Alias(Disaster Recovery configurations)
	Properties *ArmDisasterRecoveryProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ArmDisasterRecoveryListResult - The result of the List Alias(Disaster Recovery configuration) operation.
type ArmDisasterRecoveryListResult struct {
	// List of Alias(Disaster Recovery configurations)
	Value []*ArmDisasterRecovery `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of Alias(Disaster Recovery configuration)
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ArmDisasterRecoveryProperties - Properties required to the Create Or Update Alias(Disaster Recovery configurations)
type ArmDisasterRecoveryProperties struct {
	// Alternate name specified when alias and namespace names are same.
	AlternateName *string `json:"alternateName,omitempty"`

	// ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	PartnerNamespace *string `json:"partnerNamespace,omitempty"`

	// READ-ONLY; Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64 `json:"pendingReplicationOperationsCount,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted' or 'Succeeded'
	// or 'Failed'
	ProvisioningState *ProvisioningStateDR `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or 'Secondary'
	Role *RoleDisasterRecovery `json:"role,omitempty" azure:"ro"`
}

// AuthorizationRule - Single item in a List or Get AuthorizationRule operation
type AuthorizationRule struct {
	// Properties supplied to create or update AuthorizationRule
	Properties *AuthorizationRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AuthorizationRuleListResult - The response from the List namespace operation.
type AuthorizationRuleListResult struct {
	// Link to the next set of results. Not empty if Value contains an incomplete list of Authorization Rules
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Authorization Rules operation.
	Value []*AuthorizationRule `json:"value,omitempty"`
}

// AuthorizationRuleProperties - Properties supplied to create or update AuthorizationRule
type AuthorizationRuleProperties struct {
	// REQUIRED; The rights associated with the rule.
	Rights []*AccessRights `json:"rights,omitempty"`
}

// AvailableCluster - Pre-provisioned and readily available Event Hubs Cluster count per region.
type AvailableCluster struct {
	// Location fo the Available Cluster
	Location *string `json:"location,omitempty"`
}

// AvailableClustersList - The response of the List Available Clusters operation.
type AvailableClustersList struct {
	// The count of readily available and pre-provisioned Event Hubs Clusters per region.
	Value []*AvailableCluster `json:"value,omitempty"`
}

// CaptureDescription - Properties to configure capture description for eventhub
type CaptureDescription struct {
	// Properties of Destination where capture will be stored. (Storage Account, Blob Names)
	Destination *Destination `json:"destination,omitempty"`

	// A value that indicates whether capture description is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in
	// New API Version
	Encoding *EncodingCaptureDescription `json:"encoding,omitempty"`

	// The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between
	// 60 to 900 seconds
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`

	// The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between
	// 10485760 to 524288000 bytes
	SizeLimitInBytes *int32 `json:"sizeLimitInBytes,omitempty"`

	// A value that indicates whether to Skip Empty Archives
	SkipEmptyArchives *bool `json:"skipEmptyArchives,omitempty"`
}

// CheckNameAvailabilityParameter - Parameter supplied to check Namespace name availability operation
type CheckNameAvailabilityParameter struct {
	// REQUIRED; Name to check the namespace name availability
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult - The Result of the CheckNameAvailability operation
type CheckNameAvailabilityResult struct {
	// Value indicating Namespace is availability, true if the Namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason for unavailability of a Namespace.
	Reason *UnavailableReason `json:"reason,omitempty"`

	// READ-ONLY; The detailed info regarding the reason associated with the Namespace.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// Cluster - Single Event Hubs Cluster resource in List or Get operations.
type Cluster struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Event Hubs Cluster properties supplied in responses in List or Get operations.
	Properties *ClusterProperties `json:"properties,omitempty"`

	// Properties of the cluster SKU.
	SKU *ClusterSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterListResult - The response of the List Event Hubs Clusters operation.
type ClusterListResult struct {
	// Link to the next set of results. Empty unless the value parameter contains an incomplete list of Event Hubs Clusters.
	NextLink *string `json:"nextLink,omitempty"`

	// The Event Hubs Clusters present in the List Event Hubs operation results.
	Value []*Cluster `json:"value,omitempty"`
}

// ClusterProperties - Event Hubs Cluster properties supplied in responses in List or Get operations.
type ClusterProperties struct {
	// A value that indicates whether Scaling is Supported.
	SupportsScaling *bool `json:"supportsScaling,omitempty"`

	// READ-ONLY; The UTC time when the Event Hubs Cluster was created.
	CreatedAt *string `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; The metric ID of the cluster resource. Provided by the service and not modifiable by the user.
	MetricID *string `json:"metricId,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Cluster resource
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The UTC time when the Event Hubs Cluster was last updated.
	UpdatedAt *string `json:"updatedAt,omitempty" azure:"ro"`
}

// ClusterQuotaConfigurationProperties - Contains all settings for the cluster.
type ClusterQuotaConfigurationProperties struct {
	// All possible Cluster settings - a collection of key/value paired settings which apply to quotas and configurations imposed
	// on the cluster.
	Settings map[string]*string `json:"settings,omitempty"`
}

// ClusterSKU - SKU parameters particular to a cluster instance.
type ClusterSKU struct {
	// REQUIRED; Name of this SKU.
	Name *ClusterSKUName `json:"name,omitempty"`

	// The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ClustersClient.BeginCreateOrUpdate method.
type ClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateOptions contains the optional parameters for the ClustersClient.BeginUpdate method.
type ClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListAvailableClusterRegionOptions contains the optional parameters for the ClustersClient.ListAvailableClusterRegion
// method.
type ClustersClientListAvailableClusterRegionOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.ListByResourceGroup method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListBySubscriptionOptions contains the optional parameters for the ClustersClient.ListBySubscription method.
type ClustersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListNamespacesOptions contains the optional parameters for the ClustersClient.ListNamespaces method.
type ClustersClientListNamespacesOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationClientGetOptions contains the optional parameters for the ConfigurationClient.Get method.
type ConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationClientPatchOptions contains the optional parameters for the ConfigurationClient.Patch method.
type ConfigurationClientPatchOptions struct {
	// placeholder for future optional parameters
}

// ConnectionState information.
type ConnectionState struct {
	// Description of the connection state.
	Description *string `json:"description,omitempty"`

	// Status of the connection.
	Status *PrivateLinkConnectionStatus `json:"status,omitempty"`
}

// ConsumerGroup - Single item in List or Get Consumer group operation
type ConsumerGroup struct {
	// Single item in List or Get Consumer group operation
	Properties *ConsumerGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConsumerGroupListResult - The result to the List Consumer Group operation.
type ConsumerGroupListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Consumer Group
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Consumer Group operation.
	Value []*ConsumerGroup `json:"value,omitempty"`
}

// ConsumerGroupProperties - Single item in List or Get Consumer group operation
type ConsumerGroupProperties struct {
	// User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store
	// descriptive data, such as list of teams and their contact information also
	// user-defined configuration settings can be stored.
	UserMetadata *string `json:"userMetadata,omitempty"`

	// READ-ONLY; Exact time the message was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// ConsumerGroupsClientCreateOrUpdateOptions contains the optional parameters for the ConsumerGroupsClient.CreateOrUpdate
// method.
type ConsumerGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConsumerGroupsClientDeleteOptions contains the optional parameters for the ConsumerGroupsClient.Delete method.
type ConsumerGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConsumerGroupsClientGetOptions contains the optional parameters for the ConsumerGroupsClient.Get method.
type ConsumerGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConsumerGroupsClientListByEventHubOptions contains the optional parameters for the ConsumerGroupsClient.ListByEventHub
// method.
type ConsumerGroupsClientListByEventHubOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// Destination - Capture storage details for capture description
type Destination struct {
	// Name for capture destination
	Name *string `json:"name,omitempty"`

	// Properties describing the storage account, blob container and archive name format for capture destination
	Properties *DestinationProperties `json:"properties,omitempty"`
}

// DestinationProperties - Properties describing the storage account, blob container and archive name format for capture destination
type DestinationProperties struct {
	// Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}.
	// Here all the parameters (Namespace,EventHub .. etc) are mandatory
	// irrespective of order
	ArchiveNameFormat *string `json:"archiveNameFormat,omitempty"`

	// Blob container Name
	BlobContainer *string `json:"blobContainer,omitempty"`

	// The Azure Data Lake Store name for the captured events
	DataLakeAccountName *string `json:"dataLakeAccountName,omitempty"`

	// The destination folder path for the captured events
	DataLakeFolderPath *string `json:"dataLakeFolderPath,omitempty"`

	// Subscription Id of Azure Data Lake Store
	DataLakeSubscriptionID *string `json:"dataLakeSubscriptionId,omitempty"`

	// Resource id of the storage account to be used to create the blobs
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
}

// DisasterRecoveryConfigsClientBreakPairingOptions contains the optional parameters for the DisasterRecoveryConfigsClient.BreakPairing
// method.
type DisasterRecoveryConfigsClientBreakPairingOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientCheckNameAvailabilityOptions contains the optional parameters for the DisasterRecoveryConfigsClient.CheckNameAvailability
// method.
type DisasterRecoveryConfigsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientCreateOrUpdateOptions contains the optional parameters for the DisasterRecoveryConfigsClient.CreateOrUpdate
// method.
type DisasterRecoveryConfigsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientDeleteOptions contains the optional parameters for the DisasterRecoveryConfigsClient.Delete
// method.
type DisasterRecoveryConfigsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientFailOverOptions contains the optional parameters for the DisasterRecoveryConfigsClient.FailOver
// method.
type DisasterRecoveryConfigsClientFailOverOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientGetAuthorizationRuleOptions contains the optional parameters for the DisasterRecoveryConfigsClient.GetAuthorizationRule
// method.
type DisasterRecoveryConfigsClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientGetOptions contains the optional parameters for the DisasterRecoveryConfigsClient.Get method.
type DisasterRecoveryConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListAuthorizationRulesOptions contains the optional parameters for the DisasterRecoveryConfigsClient.ListAuthorizationRules
// method.
type DisasterRecoveryConfigsClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListKeysOptions contains the optional parameters for the DisasterRecoveryConfigsClient.ListKeys
// method.
type DisasterRecoveryConfigsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListOptions contains the optional parameters for the DisasterRecoveryConfigsClient.List method.
type DisasterRecoveryConfigsClientListOptions struct {
	// placeholder for future optional parameters
}

// EHNamespace - Single Namespace item in List or Get Operation
type EHNamespace struct {
	// Properties of BYOK Identity description
	Identity *Identity `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Namespace properties supplied for create namespace operation.
	Properties *EHNamespaceProperties `json:"properties,omitempty"`

	// Properties of sku resource
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EHNamespaceIDContainer - The full ARM ID of an Event Hubs Namespace
type EHNamespaceIDContainer struct {
	// id parameter
	ID *string `json:"id,omitempty"`
}

// EHNamespaceIDListResult - The response of the List Namespace IDs operation
type EHNamespaceIDListResult struct {
	// Result of the List Namespace IDs operation
	Value []*EHNamespaceIDContainer `json:"value,omitempty"`
}

// EHNamespaceListResult - The response of the List Namespace operation
type EHNamespaceListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of namespaces.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Namespace operation
	Value []*EHNamespace `json:"value,omitempty"`
}

// EHNamespaceProperties - Namespace properties supplied for create namespace operation.
type EHNamespaceProperties struct {
	// Alternate name specified when alias and namespace names are same.
	AlternateName *string `json:"alternateName,omitempty"`

	// Cluster ARM ID of the Namespace.
	ClusterArmID *string `json:"clusterArmId,omitempty"`

	// This property disables SAS authentication for the Event Hubs namespace.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Properties of BYOK Encryption description
	Encryption *Encryption `json:"encryption,omitempty"`

	// Value that indicates whether AutoInflate is enabled for eventhub namespace.
	IsAutoInflateEnabled *bool `json:"isAutoInflateEnabled,omitempty"`

	// Value that indicates whether Kafka is enabled for eventhub namespace.
	KafkaEnabled *bool `json:"kafkaEnabled,omitempty"`

	// Upper limit of throughput units when AutoInflate is enabled, value should be within 0 to 20 throughput units. ( '0' if
	// AutoInflateEnabled = true)
	MaximumThroughputUnits *int32 `json:"maximumThroughputUnits,omitempty"`

	// The minimum TLS version for the cluster to support, e.g. '1.2'
	MinimumTLSVersion *TLSVersion `json:"minimumTlsVersion,omitempty"`

	// List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Enabling this property creates a Standard Event Hubs Namespace in regions supported availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; The time the Namespace was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for Azure Insights metrics.
	MetricID *string `json:"metricId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Namespace.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The time the Namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// Encryption - Properties to configure Encryption
type Encryption struct {
	// Enumerates the possible value of keySource for Encryption
	KeySource *string `json:"keySource,omitempty"`

	// Properties of KeyVault
	KeyVaultProperties []*KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// Enable Infrastructure Encryption (Double Encryption)
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates Event Hub service is not able to process the incoming request. The reason is provided
// in the error message.
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EventHubsClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the EventHubsClient.CreateOrUpdateAuthorizationRule
// method.
type EventHubsClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientCreateOrUpdateOptions contains the optional parameters for the EventHubsClient.CreateOrUpdate method.
type EventHubsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientDeleteAuthorizationRuleOptions contains the optional parameters for the EventHubsClient.DeleteAuthorizationRule
// method.
type EventHubsClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientDeleteOptions contains the optional parameters for the EventHubsClient.Delete method.
type EventHubsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientGetAuthorizationRuleOptions contains the optional parameters for the EventHubsClient.GetAuthorizationRule
// method.
type EventHubsClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientGetOptions contains the optional parameters for the EventHubsClient.Get method.
type EventHubsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientListAuthorizationRulesOptions contains the optional parameters for the EventHubsClient.ListAuthorizationRules
// method.
type EventHubsClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientListByNamespaceOptions contains the optional parameters for the EventHubsClient.ListByNamespace method.
type EventHubsClientListByNamespaceOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// EventHubsClientListKeysOptions contains the optional parameters for the EventHubsClient.ListKeys method.
type EventHubsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientRegenerateKeysOptions contains the optional parameters for the EventHubsClient.RegenerateKeys method.
type EventHubsClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// Eventhub - Single item in List or Get Event Hub operation
type Eventhub struct {
	// Properties supplied to the Create Or Update Event Hub operation.
	Properties *Properties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Identity - Properties to configure Identity for Bring your Own Keys
type Identity struct {
	// Type of managed service identity.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// Properties for User Assigned Identities
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; ObjectId from the KeyVault
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; TenantId from the KeyVault
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// KeyVaultProperties - Properties to configure keyVault Properties
type KeyVaultProperties struct {
	Identity *UserAssignedIdentityProperties `json:"identity,omitempty"`

	// Name of the Key from KeyVault
	KeyName *string `json:"keyName,omitempty"`

	// Uri of KeyVault
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// Key Version
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// ListResult - The result of the List EventHubs operation.
type ListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of EventHubs.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List EventHubs operation.
	Value []*Eventhub `json:"value,omitempty"`
}

// NWRuleSetIPRules - The response from the List namespace operation.
type NWRuleSetIPRules struct {
	// The IP Filter Action
	Action *NetworkRuleIPAction `json:"action,omitempty"`

	// IP Mask
	IPMask *string `json:"ipMask,omitempty"`
}

// NWRuleSetVirtualNetworkRules - The response from the List namespace operation.
type NWRuleSetVirtualNetworkRules struct {
	// Value that indicates whether to ignore missing Vnet Service Endpoint
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`

	// Subnet properties
	Subnet *Subnet `json:"subnet,omitempty"`
}

// NamespacesClientBeginCreateOrUpdateOptions contains the optional parameters for the NamespacesClient.BeginCreateOrUpdate
// method.
type NamespacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientBeginDeleteOptions contains the optional parameters for the NamespacesClient.BeginDelete method.
type NamespacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientCheckNameAvailabilityOptions contains the optional parameters for the NamespacesClient.CheckNameAvailability
// method.
type NamespacesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateAuthorizationRule
// method.
type NamespacesClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateNetworkRuleSetOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateNetworkRuleSet
// method.
type NamespacesClientCreateOrUpdateNetworkRuleSetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientDeleteAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.DeleteAuthorizationRule
// method.
type NamespacesClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.GetAuthorizationRule
// method.
type NamespacesClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetNetworkRuleSetOptions contains the optional parameters for the NamespacesClient.GetNetworkRuleSet method.
type NamespacesClientGetNetworkRuleSetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetOptions contains the optional parameters for the NamespacesClient.Get method.
type NamespacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListAuthorizationRulesOptions contains the optional parameters for the NamespacesClient.ListAuthorizationRules
// method.
type NamespacesClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListByResourceGroupOptions contains the optional parameters for the NamespacesClient.ListByResourceGroup
// method.
type NamespacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListKeysOptions contains the optional parameters for the NamespacesClient.ListKeys method.
type NamespacesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListNetworkRuleSetOptions contains the optional parameters for the NamespacesClient.ListNetworkRuleSet
// method.
type NamespacesClientListNetworkRuleSetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListOptions contains the optional parameters for the NamespacesClient.List method.
type NamespacesClientListOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientRegenerateKeysOptions contains the optional parameters for the NamespacesClient.RegenerateKeys method.
type NamespacesClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientUpdateOptions contains the optional parameters for the NamespacesClient.Update method.
type NamespacesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// NetworkRuleSet - Description of topic resource.
type NetworkRuleSet struct {
	// NetworkRuleSet properties
	Properties *NetworkRuleSetProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkRuleSetListResult - The response of the List NetworkRuleSet operation
type NetworkRuleSetListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of NetworkRuleSet.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List NetworkRuleSet operation
	Value []*NetworkRuleSet `json:"value,omitempty"`
}

// NetworkRuleSetProperties - NetworkRuleSet properties
type NetworkRuleSetProperties struct {
	// Default Action for Network Rule Set
	DefaultAction *DefaultAction `json:"defaultAction,omitempty"`

	// List of IpRules
	IPRules []*NWRuleSetIPRules `json:"ipRules,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then
	// Inbound and Outbound communication is controlled by the network security
	// perimeter and profile's access rules.
	PublicNetworkAccess *PublicNetworkAccessFlag `json:"publicNetworkAccess,omitempty"`

	// Value that indicates whether Trusted Service Access is Enabled or not.
	TrustedServiceAccessEnabled *bool `json:"trustedServiceAccessEnabled,omitempty"`

	// List VirtualNetwork Rules
	VirtualNetworkRules []*NWRuleSetVirtualNetworkRules `json:"virtualNetworkRules,omitempty"`
}

// NetworkSecurityPerimeter related information
type NetworkSecurityPerimeter struct {
	// Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`

	// Location of the resource
	Location *string `json:"location,omitempty"`

	// Guid of the resource
	PerimeterGUID *string `json:"perimeterGuid,omitempty"`
}

// NetworkSecurityPerimeterConfiguration - Network Security Perimeter related configurations of a given namespace
type NetworkSecurityPerimeterConfiguration struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Properties of the Network Security Perimeter Configuration
	Properties *NetworkSecurityPerimeterConfigurationProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkSecurityPerimeterConfigurationClientListOptions contains the optional parameters for the NetworkSecurityPerimeterConfigurationClient.List
// method.
type NetworkSecurityPerimeterConfigurationClientListOptions struct {
	// placeholder for future optional parameters
}

// NetworkSecurityPerimeterConfigurationList - Result of the List NetworkSecurityPerimeterConfiguration operation.
type NetworkSecurityPerimeterConfigurationList struct {
	// READ-ONLY; A collection of NetworkSecurityPerimeterConfigurations
	Value []*NetworkSecurityPerimeterConfiguration `json:"value,omitempty" azure:"ro"`
}

// NetworkSecurityPerimeterConfigurationProperties - Properties of NetworkSecurityPerimeterConfiguration
type NetworkSecurityPerimeterConfigurationProperties struct {
	// List of Provisioning Issues if any
	ProvisioningIssues []*ProvisioningIssue `json:"provisioningIssues,omitempty"`

	// Provisioning state of NetworkSecurityPerimeter configuration propagation
	ProvisioningState *NetworkSecurityPerimeterConfigurationProvisioningState `json:"provisioningState,omitempty"`

	// READ-ONLY; NetworkSecurityPerimeter related information
	NetworkSecurityPerimeter *NetworkSecurityPerimeter `json:"networkSecurityPerimeter,omitempty" azure:"ro"`

	// READ-ONLY; Information about current network profile
	Profile *NetworkSecurityPerimeterConfigurationPropertiesProfile `json:"profile,omitempty" azure:"ro"`

	// READ-ONLY; Information about resource association
	ResourceAssociation *NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation `json:"resourceAssociation,omitempty" azure:"ro"`
}

// NetworkSecurityPerimeterConfigurationPropertiesProfile - Information about current network profile
type NetworkSecurityPerimeterConfigurationPropertiesProfile struct {
	// List of Access Rules
	AccessRules []*NspAccessRule `json:"accessRules,omitempty"`

	// Current access rules version
	AccessRulesVersion *string `json:"accessRulesVersion,omitempty"`

	// Name of the resource
	Name *string `json:"name,omitempty"`
}

// NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation - Information about resource association
type NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation struct {
	// Access Mode of the resource association
	AccessMode *ResourceAssociationAccessMode `json:"accessMode,omitempty"`

	// Name of the resource association
	Name *string `json:"name,omitempty"`
}

// NetworkSecurityPerimeterConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the NetworkSecurityPerimeterConfigurationsClient.BeginCreateOrUpdate
// method.
type NetworkSecurityPerimeterConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NspAccessRule - Information of Access Rule in Network Profile
type NspAccessRule struct {
	// Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`

	// Name of the resource
	Name *string `json:"name,omitempty"`

	// Type of the resource
	Type *string `json:"type,omitempty"`

	// READ-ONLY; Properties of Access Rule
	Properties *NspAccessRuleProperties `json:"properties,omitempty" azure:"ro"`
}

// NspAccessRuleProperties - Properties of Access Rule
type NspAccessRuleProperties struct {
	// Address prefixes in the CIDR format for inbound rules
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`

	// Direction of Access Rule
	Direction *NspAccessRuleDirection `json:"direction,omitempty"`

	// Subscriptions for inbound rules
	Subscriptions []*NspAccessRulePropertiesSubscriptionsItem `json:"subscriptions,omitempty"`

	// READ-ONLY; FQDN for outbound rules
	FullyQualifiedDomainNames []*string `json:"fullyQualifiedDomainNames,omitempty" azure:"ro"`

	// READ-ONLY; NetworkSecurityPerimeters for inbound rules
	NetworkSecurityPerimeters []*NetworkSecurityPerimeter `json:"networkSecurityPerimeters,omitempty" azure:"ro"`
}

// NspAccessRulePropertiesSubscriptionsItem - Subscription for inbound rule
type NspAccessRulePropertiesSubscriptionsItem struct {
	// Fully qualified identifier of subscription
	ID *string `json:"id,omitempty"`
}

// Operation - A Event Hub REST API operation
type Operation struct {
	// Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Resource provider of the operation
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource of the operation
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list Event Hub operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Event Hub operations supported by the Microsoft.EventHub resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint information.
type PrivateEndpoint struct {
	// The ARM identifier for Private Endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - Properties of the PrivateEndpointConnection.
type PrivateEndpointConnection struct {
	// Properties of the PrivateEndpointConnection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - Result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	// A link for the next page of private endpoint connection resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private endpoint connection resources.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the Private Endpoint Connection.
	ProvisioningState *EndPointProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - Information of the private link resource.
type PrivateLinkResource struct {
	// Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`

	// Name of the resource
	Name *string `json:"name,omitempty"`

	// Properties of the private link resource.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// Type of the resource
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceProperties - Properties of PrivateLinkResource
type PrivateLinkResourceProperties struct {
	// The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`

	// The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - Result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	// A link for the next page of private link resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// Properties supplied to the Create Or Update Event Hub operation.
type Properties struct {
	// Properties of capture description
	CaptureDescription *CaptureDescription `json:"captureDescription,omitempty"`

	// Number of days to retain the events for this Event Hub, value should be 1 to 7 days
	MessageRetentionInDays *int64 `json:"messageRetentionInDays,omitempty"`

	// Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
	PartitionCount *int64 `json:"partitionCount,omitempty"`

	// Enumerates the possible values for the status of the Event Hub.
	Status *EntityStatus `json:"status,omitempty"`

	// READ-ONLY; Exact time the Event Hub was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Current number of shards on the Event Hub.
	PartitionIDs []*string `json:"partitionIds,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// ProvisioningIssue - Describes Provisioning issue for given NetworkSecurityPerimeterConfiguration
type ProvisioningIssue struct {
	// Name of the issue
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Properties of Provisioning Issue
	Properties *ProvisioningIssueProperties `json:"properties,omitempty" azure:"ro"`
}

// ProvisioningIssueProperties - Properties of Provisioning Issue
type ProvisioningIssueProperties struct {
	// Description of the issue
	Description *string `json:"description,omitempty"`

	// Type of Issue
	IssueType *string `json:"issueType,omitempty"`
}

// ProxyResource - Common fields that are returned in the response for all Azure Resource Manager resources
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegenerateAccessKeyParameters - Parameters supplied to the Regenerate Authorization Rule operation, specifies which key
// needs to be reset.
type RegenerateAccessKeyParameters struct {
	// REQUIRED; The access key to regenerate.
	KeyType *KeyType `json:"keyType,omitempty"`

	// Optional, if the key value provided, is set for KeyType or autogenerated Key value set for keyType
	Key *string `json:"key,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU parameters supplied to the create namespace operation
type SKU struct {
	// REQUIRED; Name of this SKU.
	Name *SKUName `json:"name,omitempty"`

	// The Event Hubs throughput units for Basic or Standard tiers, where value should be 0 to 20 throughput units. The Event
	// Hubs premium units for Premium tier, where value should be 0 to 10 premium units.
	Capacity *int32 `json:"capacity,omitempty"`

	// The billing tier of this particular SKU.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SchemaGroup - Single item in List or Get Schema Group operation
type SchemaGroup struct {
	Properties *SchemaGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SchemaGroupListResult - The result of the List SchemaGroup operation.
type SchemaGroupListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Schema Groups.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List SchemaGroups operation.
	Value []*SchemaGroup `json:"value,omitempty"`
}

type SchemaGroupProperties struct {
	// dictionary object for SchemaGroup group properties
	GroupProperties     map[string]*string   `json:"groupProperties,omitempty"`
	SchemaCompatibility *SchemaCompatibility `json:"schemaCompatibility,omitempty"`
	SchemaType          *SchemaType          `json:"schemaType,omitempty"`

	// READ-ONLY; Exact time the Schema Group was created.
	CreatedAtUTC *time.Time `json:"createdAtUtc,omitempty" azure:"ro"`

	// READ-ONLY; The ETag value.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; Exact time the Schema Group was updated
	UpdatedAtUTC *time.Time `json:"updatedAtUtc,omitempty" azure:"ro"`
}

// SchemaRegistryClientCreateOrUpdateOptions contains the optional parameters for the SchemaRegistryClient.CreateOrUpdate
// method.
type SchemaRegistryClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SchemaRegistryClientDeleteOptions contains the optional parameters for the SchemaRegistryClient.Delete method.
type SchemaRegistryClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SchemaRegistryClientGetOptions contains the optional parameters for the SchemaRegistryClient.Get method.
type SchemaRegistryClientGetOptions struct {
	// placeholder for future optional parameters
}

// SchemaRegistryClientListByNamespaceOptions contains the optional parameters for the SchemaRegistryClient.ListByNamespace
// method.
type SchemaRegistryClientListByNamespaceOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// Subnet - Properties supplied for Subnet
type Subnet struct {
	// Resource ID of Virtual Network Subnet
	ID *string `json:"id,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// ThrottlingPolicy - Properties of the throttling policy
type ThrottlingPolicy struct {
	// REQUIRED; Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the
	// Metrics section of Event Hub Namespace inside Azure Portal
	MetricID *MetricID `json:"metricId,omitempty"`

	// REQUIRED; The Name of this policy
	Name *string `json:"name,omitempty"`

	// REQUIRED; The Threshold limit above which the application group will be throttled.Rate limit is always per second.
	RateLimitThreshold *int64 `json:"rateLimitThreshold,omitempty"`

	// REQUIRED; Application Group Policy types
	Type *ApplicationGroupPolicyType `json:"type,omitempty"`
}

// GetApplicationGroupPolicy implements the ApplicationGroupPolicyClassification interface for type ThrottlingPolicy.
func (t *ThrottlingPolicy) GetApplicationGroupPolicy() *ApplicationGroupPolicy {
	return &ApplicationGroupPolicy{
		Name: t.Name,
		Type: t.Type,
	}
}

// TrackedResource - Definition of resource.
type TrackedResource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - Recognized Dictionary value.
type UserAssignedIdentity struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

type UserAssignedIdentityProperties struct {
	// ARM ID of user Identity selected for encryption
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}
