//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridcontainerservice

import "time"

// AADProfile - AAD Profile specifies attributes for Azure Active Directory integration.
type AADProfile struct {
	// The list of AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs []*string `json:"adminGroupObjectIDs,omitempty"`

	// The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`

	// Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRbac *bool `json:"enableAzureRbac,omitempty"`

	// Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`

	// The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`

	// The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`

	// The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// AADProfileResponse - AAD Profile specifies attributes for Azure Active Directory integration.
type AADProfileResponse struct {
	// The list of AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs []*string `json:"adminGroupObjectIDs,omitempty"`

	// The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`

	// Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRbac *bool `json:"enableAzureRbac,omitempty"`

	// Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`

	// The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`

	// The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// AddonProfiles - Addon configurations
type AddonProfiles struct {
	// Config - Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config,omitempty"`

	// Enabled - Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
}

// AddonStatus - Status of the addon
type AddonStatus struct {
	// ErrorMessage will be set in the event that there is a terminal problem reconciling the AddOn and will contain a more verbose
	// string suitable for logging and human consumption.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
	Phase *string `json:"phase,omitempty"`
	Ready *bool   `json:"ready,omitempty"`
}

// AgentPool - The agentPool resource definition
type AgentPool struct {
	ExtendedLocation *AgentPoolExtendedLocation `json:"extendedLocation,omitempty"`

	// The resource location
	Location   *string              `json:"location,omitempty"`
	Properties *AgentPoolProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolClientBeginCreateOrUpdateOptions contains the optional parameters for the AgentPoolClient.BeginCreateOrUpdate
// method.
type AgentPoolClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolClientDeleteOptions contains the optional parameters for the AgentPoolClient.Delete method.
type AgentPoolClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolClientGetOptions contains the optional parameters for the AgentPoolClient.Get method.
type AgentPoolClientGetOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolClientListByProvisionedClusterOptions contains the optional parameters for the AgentPoolClient.ListByProvisionedCluster
// method.
type AgentPoolClientListByProvisionedClusterOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolClientUpdateOptions contains the optional parameters for the AgentPoolClient.Update method.
type AgentPoolClientUpdateOptions struct {
	// placeholder for future optional parameters
}

type AgentPoolExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

type AgentPoolListResult struct {
	NextLink *string      `json:"nextLink,omitempty"`
	Value    []*AgentPool `json:"value,omitempty"`
}

type AgentPoolProperties struct {
	// AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// The underlying cloud infra provider properties.
	CloudProviderProfile *CloudProviderProfile `json:"cloudProviderProfile,omitempty"`

	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
	Mode *Mode `json:"mode,omitempty"`

	// The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`

	// NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include:
	// 'Linux', 'Windows'
	OSType *OsType `json:"osType,omitempty"`

	// HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
	Status *AgentPoolProvisioningStatusStatus `json:"status,omitempty"`

	// VmSize - The size of the agent pool VMs.
	VMSize *string `json:"vmSize,omitempty"`

	// READ-ONLY
	ProvisioningState *AgentPoolProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type AgentPoolProvisioningStatusError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// AgentPoolProvisioningStatusStatus - HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
type AgentPoolProvisioningStatusStatus struct {
	// ErrorMessage - Error messages during creation of cluster
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Contains Provisioning errors
	ProvisioningStatus *AgentPoolProvisioningStatusStatusProvisioningStatus `json:"provisioningStatus,omitempty"`

	// Total number of ready machines targeted by this deployment.
	ReadyReplicas *int32 `json:"readyReplicas,omitempty"`

	// Total number of non-terminated machines targeted by this deployment
	Replicas *int32 `json:"replicas,omitempty"`
}

// AgentPoolProvisioningStatusStatusProvisioningStatus - Contains Provisioning errors
type AgentPoolProvisioningStatusStatusProvisioningStatus struct {
	Error       *AgentPoolProvisioningStatusError `json:"error,omitempty"`
	OperationID *string                           `json:"operationId,omitempty"`

	// Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
	Phase  *string `json:"phase,omitempty"`
	Status *string `json:"status,omitempty"`
}

// ArcAgentProfile - Defines the Arc Agent properties for the Provisioned clusters.
type ArcAgentProfile struct {
	// Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults
	// to Enabled.
	AgentAutoUpgrade *AutoUpgradeOptions `json:"agentAutoUpgrade,omitempty"`

	// Version of the Arc agents to be installed on the provisioned Provisioned cluster resource
	AgentVersion *string `json:"agentVersion,omitempty"`
}

// ArcAgentStatus - Defines the observed Arc Agent status that is resourceSynced back to the ARM resource.
type ArcAgentStatus struct {
	// Version of the Arc agents currently running on the Provisioned cluster resource.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Number of CPU cores present in the Provisioned cluster resource
	CoreCount *int64 `json:"coreCount,omitempty"`

	// Observed deployment state of the Arc Agents on the target cluster. Possible values include: 'pending', 'provisioning',
	// 'provisioned', 'deleting', 'failed', 'upgrading'
	DeploymentState *DeploymentState `json:"deploymentState,omitempty"`

	// Error messages while onboarding/upgrading/uninstalling the Arc agents
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Last connected timestamp of the Provisioned cluster resource.
	LastConnectivityTime *time.Time `json:"lastConnectivityTime,omitempty"`

	// ManagedIdentity certificate expiration time (ValidUntil).
	ManagedIdentityCertificateExpirationTime *time.Time `json:"managedIdentityCertificateExpirationTime,omitempty"`

	// Onboarding public key for provisioning the Managed identity for the HybridAKS cluster. Will be used to create the hybridIdentityMetadata
	// proxy resource and will not be persisted.
	OnboardingPublicKey *string `json:"onboardingPublicKey,omitempty"`
}

// ClientListOrchestratorsOptions contains the optional parameters for the Client.ListOrchestrators method.
type ClientListOrchestratorsOptions struct {
	// placeholder for future optional parameters
}

// ClientListVMSKUsOptions contains the optional parameters for the Client.ListVMSKUs method.
type ClientListVMSKUsOptions struct {
	// placeholder for future optional parameters
}

// CloudProviderProfile - The underlying cloud infra provider properties.
type CloudProviderProfile struct {
	// InfraNetworkProfile - List of infra network profiles for the provisioned cluster
	InfraNetworkProfile *CloudProviderProfileInfraNetworkProfile `json:"infraNetworkProfile,omitempty"`

	// InfraStorageProfile - List of infra storage profiles for the provisioned cluster
	InfraStorageProfile *CloudProviderProfileInfraStorageProfile `json:"infraStorageProfile,omitempty"`
}

// CloudProviderProfileInfraNetworkProfile - InfraNetworkProfile - List of infra network profiles for the provisioned cluster
type CloudProviderProfileInfraNetworkProfile struct {
	// Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
	VnetSubnetIDs []*string `json:"vnetSubnetIds,omitempty"`
}

// CloudProviderProfileInfraStorageProfile - InfraStorageProfile - List of infra storage profiles for the provisioned cluster
type CloudProviderProfileInfraStorageProfile struct {
	// Reference to azure resource corresponding to the new HybridAKSStorage object e.g.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
	StorageSpaceIDs []*string `json:"storageSpaceIds,omitempty"`
}

// ControlPlaneEndpointProfileControlPlaneEndpoint - API server endpoint for the control plane
type ControlPlaneEndpointProfileControlPlaneEndpoint struct {
	// Host IP address for API server
	HostIP *string `json:"hostIP,omitempty"`

	// Port for the API server
	Port *string `json:"port,omitempty"`
}

// ControlPlaneProfile - The control plane properties for the provisioned cluster.
type ControlPlaneProfile struct {
	// AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// The underlying cloud infra provider properties.
	CloudProviderProfile *CloudProviderProfile `json:"cloudProviderProfile,omitempty"`

	// API server endpoint for the control plane
	ControlPlaneEndpoint *ControlPlaneEndpointProfileControlPlaneEndpoint `json:"controlPlaneEndpoint,omitempty"`

	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfileProperties `json:"linuxProfile,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
	Mode *Mode `json:"mode,omitempty"`

	// Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`

	// The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`

	// NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include:
	// 'Linux', 'Windows'
	OSType *OsType `json:"osType,omitempty"`

	// VmSize - The size of the agent pool VMs.
	VMSize *string `json:"vmSize,omitempty"`
}

// HTTPProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
type HTTPProxyConfig struct {
	// The HTTP proxy server endpoint to use.
	HTTPProxy *string `json:"httpProxy,omitempty"`

	// The HTTPS proxy server endpoint to use.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`

	// The endpoints that should not go through proxy.
	NoProxy []*string `json:"noProxy,omitempty"`

	// Password to use for connecting to proxy server
	Password *string `json:"password,omitempty"`

	// Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string `json:"trustedCa,omitempty"`

	// Username to use for connecting to proxy server
	Username *string `json:"username,omitempty"`
}

// HTTPProxyConfigResponse - Configurations for provisioning the cluster with HTTP proxy servers.
type HTTPProxyConfigResponse struct {
	// The HTTP proxy server endpoint to use.
	HTTPProxy *string `json:"httpProxy,omitempty"`

	// The HTTPS proxy server endpoint to use.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`

	// The endpoints that should not go through proxy.
	NoProxy []*string `json:"noProxy,omitempty"`

	// Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string `json:"trustedCa,omitempty"`

	// Username to use for connecting to proxy server
	Username *string `json:"username,omitempty"`
}

// HybridIdentityMetadata - Defines the hybridIdentityMetadata.
type HybridIdentityMetadata struct {
	// REQUIRED; Resource properties.
	Properties *HybridIdentityMetadataProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridIdentityMetadataClientDeleteOptions contains the optional parameters for the HybridIdentityMetadataClient.Delete
// method.
type HybridIdentityMetadataClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataClientGetOptions contains the optional parameters for the HybridIdentityMetadataClient.Get method.
type HybridIdentityMetadataClientGetOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataClientListByClusterOptions contains the optional parameters for the HybridIdentityMetadataClient.ListByCluster
// method.
type HybridIdentityMetadataClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataClientPutOptions contains the optional parameters for the HybridIdentityMetadataClient.Put method.
type HybridIdentityMetadataClientPutOptions struct {
	// placeholder for future optional parameters
}

// HybridIdentityMetadataList - List of hybridIdentityMetadata.
type HybridIdentityMetadataList struct {
	// REQUIRED; Array of hybridIdentityMetadata
	Value []*HybridIdentityMetadata `json:"value,omitempty"`

	// Url to follow for getting next page of hybridIdentityMetadata.
	NextLink *string `json:"nextLink,omitempty"`
}

// HybridIdentityMetadataProperties - Defines the resource properties.
type HybridIdentityMetadataProperties struct {
	// The identity of the provisioned cluster.
	Identity *ProvisionedClusterIdentity `json:"identity,omitempty"`

	// Onboarding public key for provisioning the Managed identity for the HybridAKS cluster.
	PublicKey *string `json:"publicKey,omitempty"`

	// Unique id of the parent provisioned cluster resource.
	ResourceUID *string `json:"resourceUid,omitempty"`

	// READ-ONLY; provisioning state of the hybridIdentityMetadata resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// LinuxProfileProperties - LinuxProfile - Profile for Linux VMs in the container service cluster.
type LinuxProfileProperties struct {
	// AdminUsername - The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`

	// SSH - SSH configuration for Linux-based VMs running on Azure.
	SSH *LinuxProfilePropertiesSSH `json:"ssh,omitempty"`
}

// LinuxProfilePropertiesSSH - SSH - SSH configuration for Linux-based VMs running on Azure.
type LinuxProfilePropertiesSSH struct {
	// PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
	PublicKeys []*LinuxProfilePropertiesSSHPublicKeysItem `json:"publicKeys,omitempty"`
}

type LinuxProfilePropertiesSSHPublicKeysItem struct {
	// KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with
	// or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// LoadBalancerProfile - Profile of the cluster load balancer.
type LoadBalancerProfile struct {
	// AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// The underlying cloud infra provider properties.
	CloudProviderProfile *CloudProviderProfile `json:"cloudProviderProfile,omitempty"`

	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfileProperties `json:"linuxProfile,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
	Mode *Mode `json:"mode,omitempty"`

	// Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`

	// The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`

	// NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include:
	// 'Linux', 'Windows'
	OSType *OsType `json:"osType,omitempty"`

	// VmSize - The size of the agent pool VMs.
	VMSize *string `json:"vmSize,omitempty"`
}

// NamedAgentPoolProfile - Agent pool profile along with a name parameter
type NamedAgentPoolProfile struct {
	// AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// The underlying cloud infra provider properties.
	CloudProviderProfile *CloudProviderProfile `json:"cloudProviderProfile,omitempty"`

	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
	Mode *Mode `json:"mode,omitempty"`

	// Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`

	// The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`

	// NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include:
	// 'Linux', 'Windows'
	OSType *OsType `json:"osType,omitempty"`

	// VmSize - The size of the agent pool VMs.
	VMSize *string `json:"vmSize,omitempty"`
}

// NetworkProfile - Profile of network configuration.
type NetworkProfile struct {
	// DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range
	// specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`

	// LoadBalancerProfile - Profile of the cluster load balancer.
	LoadBalancerProfile *LoadBalancerProfile `json:"loadBalancerProfile,omitempty"`

	// LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip',
	// 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
	LoadBalancerSKU *LoadBalancerSKU `json:"loadBalancerSku,omitempty"`

	// NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default
	// is 'calico'
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`

	// PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`

	// The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs,
	// one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
	PodCidrs []*string `json:"podCidrs,omitempty"`

	// ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP
	// ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`

	// The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking.
	// Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking. They must not overlap with any Subnet IP ranges.
	ServiceCidrs []*string `json:"serviceCidrs,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OrchestratorProfile - Contains information about orchestrator.
type OrchestratorProfile struct {
	// READ-ONLY; Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty" azure:"ro"`

	// READ-ONLY; Orchestrator type.
	OrchestratorType *string `json:"orchestratorType,omitempty" azure:"ro"`

	// READ-ONLY; Orchestrator version (major, minor, patch).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty" azure:"ro"`
}

// OrchestratorVersionProfile - The profile of an orchestrator and its available versions.
type OrchestratorVersionProfile struct {
	// The list of available upgrade versions.
	Upgrades []*OrchestratorProfile `json:"upgrades,omitempty"`

	// READ-ONLY; Installed by default if version is not specified.
	Default *bool `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty" azure:"ro"`

	// READ-ONLY; Orchestrator type.
	OrchestratorType *string `json:"orchestratorType,omitempty" azure:"ro"`

	// READ-ONLY; Orchestrator version major.minor.patch, for example 1.21.9
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty" azure:"ro"`
}

// OrchestratorVersionProfileListResult - The list of versions for supported orchestrators.
type OrchestratorVersionProfileListResult struct {
	// Profile of the orchestrator versions
	Orchestrators []*OrchestratorVersionProfile `json:"orchestrators,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProvisionedClusterIdentity - Identity for the Provisioned cluster.
type ProvisionedClusterIdentity struct {
	// REQUIRED; The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity.
	// The type None means no identity is assigned to the provisioned cluster.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal id of provisioned cluster identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id associated with the provisioned cluster. This property will only be provided for a system assigned
	// identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ProvisionedClusters - The provisionedClusters resource definition.
type ProvisionedClusters struct {
	// REQUIRED; The geo-location where the resource lives
	Location         *string                              `json:"location,omitempty"`
	ExtendedLocation *ProvisionedClustersExtendedLocation `json:"extendedLocation,omitempty"`

	// Identity for the Provisioned cluster.
	Identity *ProvisionedClusterIdentity `json:"identity,omitempty"`

	// All properties of the provisioned cluster
	Properties *ProvisionedClustersAllProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProvisionedClustersAllProperties - All properties of the provisioned cluster
type ProvisionedClustersAllProperties struct {
	// AAD profile for the provisioned cluster.
	AADProfile *AADProfile `json:"aadProfile,omitempty"`

	// AddonProfiles - Profile of managed cluster add-on.
	AddonProfiles map[string]*AddonProfiles `json:"addonProfiles,omitempty"`

	// The agent pools of the cluster.
	AgentPoolProfiles []*NamedAgentPoolProfile `json:"agentPoolProfiles,omitempty"`

	// The underlying cloud infra provider properties.
	CloudProviderProfile *CloudProviderProfile `json:"cloudProviderProfile,omitempty"`

	// ControlPlane - ControlPlane Configuration
	ControlPlane *ControlPlaneProfile `json:"controlPlane,omitempty"`

	// EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
	EnableRbac *bool `json:"enableRbac,omitempty"`

	// Additional features specs like Arc Agent Onboarding.
	Features *ProvisionedClustersCommonPropertiesFeatures `json:"features,omitempty"`

	// HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *HTTPProxyConfig `json:"httpProxyConfig,omitempty"`

	// KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
	LinuxProfile *LinuxProfileProperties `json:"linuxProfile,omitempty"`

	// NetworkProfile - Profile of network configuration.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// NodeResourceGroup - Name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`

	// WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
	WindowsProfile *WindowsProfile `json:"windowsProfile,omitempty"`

	// READ-ONLY
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; HybridAKSClusterStatus defines the observed state of HybridAKSCluster
	Status *ProvisionedClustersCommonPropertiesStatus `json:"status,omitempty" azure:"ro"`
}

// ProvisionedClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ProvisionedClustersClient.BeginCreateOrUpdate
// method.
type ProvisionedClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProvisionedClustersClientBeginUpdateOptions contains the optional parameters for the ProvisionedClustersClient.BeginUpdate
// method.
type ProvisionedClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProvisionedClustersClientDeleteOptions contains the optional parameters for the ProvisionedClustersClient.Delete method.
type ProvisionedClustersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProvisionedClustersClientGetOptions contains the optional parameters for the ProvisionedClustersClient.Get method.
type ProvisionedClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProvisionedClustersClientListByResourceGroupOptions contains the optional parameters for the ProvisionedClustersClient.ListByResourceGroup
// method.
type ProvisionedClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ProvisionedClustersClientListBySubscriptionOptions contains the optional parameters for the ProvisionedClustersClient.ListBySubscription
// method.
type ProvisionedClustersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ProvisionedClustersCommonPropertiesFeatures - Additional features specs like Arc Agent Onboarding.
type ProvisionedClustersCommonPropertiesFeatures struct {
	// Arc agentry configuration for the provisioned cluster.
	ArcAgentProfile *ArcAgentProfile `json:"arcAgentProfile,omitempty"`
}

// ProvisionedClustersCommonPropertiesStatus - HybridAKSClusterStatus defines the observed state of HybridAKSCluster
type ProvisionedClustersCommonPropertiesStatus struct {
	// AddonStatus - Status of Addons
	AddonStatus map[string]*AddonStatus `json:"addonStatus,omitempty"`

	// ErrorMessage - Error messages during creation of cluster
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Additional features status like Arc Agent Onboarding.
	FeaturesStatus *ProvisionedClustersCommonPropertiesStatusFeaturesStatus `json:"featuresStatus,omitempty"`

	// Contains Provisioning errors
	ProvisioningStatus *ProvisionedClustersCommonPropertiesStatusProvisioningStatus `json:"provisioningStatus,omitempty"`
}

// ProvisionedClustersCommonPropertiesStatusFeaturesStatus - Additional features status like Arc Agent Onboarding.
type ProvisionedClustersCommonPropertiesStatusFeaturesStatus struct {
	// Defines the observed Arc Agent status that is resourceSynced back to the ARM resource.
	ArcAgentStatus *ArcAgentStatus `json:"arcAgentStatus,omitempty"`
}

// ProvisionedClustersCommonPropertiesStatusProvisioningStatus - Contains Provisioning errors
type ProvisionedClustersCommonPropertiesStatusProvisioningStatus struct {
	Error       *ProvisionedClustersCommonPropertiesStatusProvisioningStatusError `json:"error,omitempty"`
	OperationID *string                                                           `json:"operationId,omitempty"`

	// Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
	Phase  *string `json:"phase,omitempty"`
	Status *string `json:"status,omitempty"`
}

type ProvisionedClustersCommonPropertiesStatusProvisioningStatusError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

type ProvisionedClustersExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

// ProvisionedClustersPatch - The provisionedClusters resource patch definition.
type ProvisionedClustersPatch struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ProvisionedClustersResponse - The provisionedClusters resource definition.
type ProvisionedClustersResponse struct {
	// REQUIRED; The geo-location where the resource lives
	Location         *string                                      `json:"location,omitempty"`
	ExtendedLocation *ProvisionedClustersResponseExtendedLocation `json:"extendedLocation,omitempty"`

	// Identity for the Provisioned cluster.
	Identity   *ProvisionedClusterIdentity            `json:"identity,omitempty"`
	Properties *ProvisionedClustersResponseProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ProvisionedClustersResponseExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

type ProvisionedClustersResponseListResult struct {
	NextLink *string                        `json:"nextLink,omitempty"`
	Value    []*ProvisionedClustersResponse `json:"value,omitempty"`
}

type ProvisionedClustersResponseProperties struct {
	// AAD profile for the provisioned cluster.
	AADProfile *AADProfileResponse `json:"aadProfile,omitempty"`

	// AddonProfiles - Profile of managed cluster add-on.
	AddonProfiles map[string]*AddonProfiles `json:"addonProfiles,omitempty"`

	// The agent pools of the cluster.
	AgentPoolProfiles []*NamedAgentPoolProfile `json:"agentPoolProfiles,omitempty"`

	// The underlying cloud infra provider properties.
	CloudProviderProfile *CloudProviderProfile `json:"cloudProviderProfile,omitempty"`

	// ControlPlane - ControlPlane Configuration
	ControlPlane *ControlPlaneProfile `json:"controlPlane,omitempty"`

	// EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
	EnableRbac *bool `json:"enableRbac,omitempty"`

	// Additional features specs like Arc Agent Onboarding.
	Features *ProvisionedClustersCommonPropertiesFeatures `json:"features,omitempty"`

	// HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *HTTPProxyConfigResponse `json:"httpProxyConfig,omitempty"`

	// KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
	LinuxProfile *LinuxProfileProperties `json:"linuxProfile,omitempty"`

	// NetworkProfile - Profile of network configuration.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// NodeResourceGroup - Name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`

	// WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
	WindowsProfile *WindowsProfileResponse `json:"windowsProfile,omitempty"`

	// READ-ONLY
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; HybridAKSClusterStatus defines the observed state of HybridAKSCluster
	Status *ProvisionedClustersCommonPropertiesStatus `json:"status,omitempty" azure:"ro"`
}

// ResourceProviderOperation - Results of the request to list operations.
type ResourceProviderOperation struct {
	// Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation applies to data-plane.
	IsDataAction *string `json:"isDataAction,omitempty"`

	// Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// ResourceProviderOperationDisplay - Display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Description of this operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// The resource provider.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// ResourceProviderOperationList - Results of the request to list operations.
type ResourceProviderOperationList struct {
	NextLink *string                      `json:"nextLink,omitempty"`
	Value    []*ResourceProviderOperation `json:"value,omitempty"`
}

// StorageSpaces - The storageSpaces resource definition.
type StorageSpaces struct {
	// REQUIRED; The geo-location where the resource lives
	Location         *string                        `json:"location,omitempty"`
	ExtendedLocation *StorageSpacesExtendedLocation `json:"extendedLocation,omitempty"`

	// HybridAKSStorageSpec defines the desired state of HybridAKSStorage
	Properties *StorageSpacesProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageSpacesClientBeginCreateOrUpdateOptions contains the optional parameters for the StorageSpacesClient.BeginCreateOrUpdate
// method.
type StorageSpacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageSpacesClientBeginUpdateOptions contains the optional parameters for the StorageSpacesClient.BeginUpdate method.
type StorageSpacesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StorageSpacesClientDeleteOptions contains the optional parameters for the StorageSpacesClient.Delete method.
type StorageSpacesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StorageSpacesClientListByResourceGroupOptions contains the optional parameters for the StorageSpacesClient.ListByResourceGroup
// method.
type StorageSpacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// StorageSpacesClientListBySubscriptionOptions contains the optional parameters for the StorageSpacesClient.ListBySubscription
// method.
type StorageSpacesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// StorageSpacesClientRetrieveOptions contains the optional parameters for the StorageSpacesClient.Retrieve method.
type StorageSpacesClientRetrieveOptions struct {
	// placeholder for future optional parameters
}

type StorageSpacesExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

type StorageSpacesListResult struct {
	NextLink *string          `json:"nextLink,omitempty"`
	Value    []*StorageSpaces `json:"value,omitempty"`
}

// StorageSpacesPatch - The storageSpaces resource patch definition.
type StorageSpacesPatch struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// StorageSpacesProperties - HybridAKSStorageSpec defines the desired state of HybridAKSStorage
type StorageSpacesProperties struct {
	HciStorageProfile *StorageSpacesPropertiesHciStorageProfile `json:"hciStorageProfile,omitempty"`

	// HybridAKSStorageStatus defines the observed state of HybridAKSStorage
	Status               *StorageSpacesPropertiesStatus               `json:"status,omitempty"`
	VmwareStorageProfile *StorageSpacesPropertiesVmwareStorageProfile `json:"vmwareStorageProfile,omitempty"`

	// READ-ONLY
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type StorageSpacesPropertiesHciStorageProfile struct {
	// Resource group in MOC(Microsoft On-premises Cloud)
	MocGroup *string `json:"mocGroup,omitempty"`

	// Location in MOC(Microsoft On-premises Cloud)
	MocLocation *string `json:"mocLocation,omitempty"`

	// Name of the storage container in MOC(Microsoft On-premises Cloud)
	MocStorageContainer *string `json:"mocStorageContainer,omitempty"`
}

// StorageSpacesPropertiesStatus - HybridAKSStorageStatus defines the observed state of HybridAKSStorage
type StorageSpacesPropertiesStatus struct {
	// Contains Provisioning errors
	ProvisioningStatus *StorageSpacesPropertiesStatusProvisioningStatus `json:"provisioningStatus,omitempty"`
}

// StorageSpacesPropertiesStatusProvisioningStatus - Contains Provisioning errors
type StorageSpacesPropertiesStatusProvisioningStatus struct {
	Error       *StorageSpacesPropertiesStatusProvisioningStatusError `json:"error,omitempty"`
	OperationID *string                                               `json:"operationId,omitempty"`

	// Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
	Phase  *string `json:"phase,omitempty"`
	Status *string `json:"status,omitempty"`
}

type StorageSpacesPropertiesStatusProvisioningStatusError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

type StorageSpacesPropertiesVmwareStorageProfile struct {
	// Name of the datacenter in VSphere
	Datacenter *string `json:"datacenter,omitempty"`

	// Name of the datastore in VSphere
	Datastore *string `json:"datastore,omitempty"`

	// Name of the folder in VSphere
	Folder *string `json:"folder,omitempty"`

	// Name of the resource pool in VSphere
	ResourcePool *string `json:"resourcePool,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// VMSKUListResult - The list of supported VM SKUs.
type VMSKUListResult struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Supported VM SKUs.
	VMSKUs []*string `json:"vmSKUs,omitempty" azure:"ro"`
}

// VirtualNetworks - The virtualNetworks resource definition.
type VirtualNetworks struct {
	// REQUIRED; The geo-location where the resource lives
	Location         *string                          `json:"location,omitempty"`
	ExtendedLocation *VirtualNetworksExtendedLocation `json:"extendedLocation,omitempty"`

	// HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
	Properties *VirtualNetworksProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworksClient.BeginCreateOrUpdate
// method.
type VirtualNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginUpdateOptions contains the optional parameters for the VirtualNetworksClient.BeginUpdate method.
type VirtualNetworksClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientDeleteOptions contains the optional parameters for the VirtualNetworksClient.Delete method.
type VirtualNetworksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListByResourceGroupOptions contains the optional parameters for the VirtualNetworksClient.ListByResourceGroup
// method.
type VirtualNetworksClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListBySubscriptionOptions contains the optional parameters for the VirtualNetworksClient.ListBySubscription
// method.
type VirtualNetworksClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientRetrieveOptions contains the optional parameters for the VirtualNetworksClient.Retrieve method.
type VirtualNetworksClientRetrieveOptions struct {
	// placeholder for future optional parameters
}

type VirtualNetworksExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

type VirtualNetworksListResult struct {
	NextLink *string            `json:"nextLink,omitempty"`
	Value    []*VirtualNetworks `json:"value,omitempty"`
}

// VirtualNetworksPatch - The virtualNetworks resource patch definition.
type VirtualNetworksPatch struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualNetworksProperties - HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
type VirtualNetworksProperties struct {
	InfraVnetProfile *VirtualNetworksPropertiesInfraVnetProfile `json:"infraVnetProfile,omitempty"`

	// Virtual IP Pool for Kubernetes
	VipPool []*VirtualNetworksPropertiesVipPoolItem `json:"vipPool,omitempty"`

	// IP Pool for Virtual Machines
	VmipPool []*VirtualNetworksPropertiesVmipPoolItem `json:"vmipPool,omitempty"`

	// READ-ONLY; Address of the DNS servers associated with the network
	DNSServers []*string `json:"dnsServers,omitempty" azure:"ro"`

	// READ-ONLY; Address of the DHCP servers associated with the network
	DhcpServers []*string `json:"dhcpServers,omitempty" azure:"ro"`

	// READ-ONLY; Address of the Gateway associated with the network
	Gateway *string `json:"gateway,omitempty" azure:"ro"`

	// READ-ONLY; IP Address Prefix of the network
	IPAddressPrefix *string `json:"ipAddressPrefix,omitempty" azure:"ro"`

	// READ-ONLY
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; HybridAKSNetworkStatus defines the observed state of HybridAKSNetwork
	Status *VirtualNetworksPropertiesStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; VLAN Id used by the network
	VlanID *string `json:"vlanID,omitempty" azure:"ro"`
}

type VirtualNetworksPropertiesInfraVnetProfile struct {
	// Infra network profile for HCI platform
	Hci *VirtualNetworksPropertiesInfraVnetProfileHci `json:"hci,omitempty"`

	// Infra network profile for KubeVirt platform
	Kubevirt *VirtualNetworksPropertiesInfraVnetProfileKubevirt `json:"kubevirt,omitempty"`

	// Infra network profile for VMware platform
	Vmware *VirtualNetworksPropertiesInfraVnetProfileVmware `json:"vmware,omitempty"`
}

// VirtualNetworksPropertiesInfraVnetProfileHci - Infra network profile for HCI platform
type VirtualNetworksPropertiesInfraVnetProfileHci struct {
	// Resource group in MOC(Microsoft On-premises Cloud)
	MocGroup *string `json:"mocGroup,omitempty"`

	// Location in MOC(Microsoft On-premises Cloud)
	MocLocation *string `json:"mocLocation,omitempty"`

	// Virtual Network name in MOC(Microsoft On-premises Cloud)
	MocVnetName *string `json:"mocVnetName,omitempty"`
}

// VirtualNetworksPropertiesInfraVnetProfileKubevirt - Infra network profile for KubeVirt platform
type VirtualNetworksPropertiesInfraVnetProfileKubevirt struct {
	// Name of the network in KubeVirt
	VnetName *string `json:"vnetName,omitempty"`
}

// VirtualNetworksPropertiesInfraVnetProfileVmware - Infra network profile for VMware platform
type VirtualNetworksPropertiesInfraVnetProfileVmware struct {
	// Name of the network segment in VSphere
	SegmentName *string `json:"segmentName,omitempty"`
}

// VirtualNetworksPropertiesStatus - HybridAKSNetworkStatus defines the observed state of HybridAKSNetwork
type VirtualNetworksPropertiesStatus struct {
	// Contains Provisioning errors
	ProvisioningStatus *VirtualNetworksPropertiesStatusProvisioningStatus `json:"provisioningStatus,omitempty"`
}

// VirtualNetworksPropertiesStatusProvisioningStatus - Contains Provisioning errors
type VirtualNetworksPropertiesStatusProvisioningStatus struct {
	Error       *VirtualNetworksPropertiesStatusProvisioningStatusError `json:"error,omitempty"`
	OperationID *string                                                 `json:"operationId,omitempty"`

	// Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
	Phase  *string `json:"phase,omitempty"`
	Status *string `json:"status,omitempty"`
}

type VirtualNetworksPropertiesStatusProvisioningStatusError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

type VirtualNetworksPropertiesVipPoolItem struct {
	// Ending IP address for the IP Pool
	EndIP *string `json:"endIP,omitempty"`

	// Starting IP address for the IP Pool
	StartIP *string `json:"startIP,omitempty"`
}

type VirtualNetworksPropertiesVmipPoolItem struct {
	// Ending IP address for the IP Pool
	EndIP *string `json:"endIP,omitempty"`

	// Starting IP address for the IP Pool
	StartIP *string `json:"startIP,omitempty"`
}

// WindowsProfile - Profile for Windows VMs in the container service cluster.
type WindowsProfile struct {
	// AdminPassword - Specifies the password of the administrator account.
	// Minimum-length: 8 characters
	// Max-length: 123 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	AdminPassword *string `json:"adminPassword,omitempty"`

	// AdminUsername - Specifies the name of the administrator account.
	// restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length: 1 character
	// Max-length: 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`

	// EnableCSIProxy - Whether to enable CSI proxy.
	EnableCsiProxy *bool `json:"enableCsiProxy,omitempty"`

	// LicenseType - The licenseType to use for Windows VMs. WindowsServer is used to enable Azure Hybrid User Benefits for Windows
	// VMs. Possible values include: 'None', 'WindowsServer'
	LicenseType *LicenseType `json:"licenseType,omitempty"`
}

// WindowsProfileResponse - Profile for Windows VMs in the container service cluster.
type WindowsProfileResponse struct {
	// AdminUsername - Specifies the name of the administrator account.
	// restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length: 1 character
	// Max-length: 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`

	// EnableCSIProxy - Whether to enable CSI proxy.
	EnableCsiProxy *bool `json:"enableCsiProxy,omitempty"`

	// LicenseType - The licenseType to use for Windows VMs. WindowsServer is used to enable Azure Hybrid User Benefits for Windows
	// VMs. Possible values include: 'None', 'WindowsServer'
	LicenseType *LicenseType `json:"licenseType,omitempty"`
}
