// Code generated by smithy-go-codegen DO NOT EDIT.

package b2bi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the details for a partnership, based on the partner and profile IDs
// specified. A partnership represents the connection between you and your trading
// partner. It ties together a profile and one or more trading capabilities.
func (c *Client) GetPartnership(ctx context.Context, params *GetPartnershipInput, optFns ...func(*Options)) (*GetPartnershipOutput, error) {
	if params == nil {
		params = &GetPartnershipInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPartnership", params, optFns, c.addOperationGetPartnershipMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPartnershipOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPartnershipInput struct {

	// Specifies the unique, system-generated identifier for a partnership.
	//
	// This member is required.
	PartnershipId *string

	noSmithyDocumentSerde
}

type GetPartnershipOutput struct {

	// Returns a timestamp for creation date and time of the partnership.
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// This member is required.
	PartnershipArn *string

	// Returns the unique, system-generated identifier for a partnership.
	//
	// This member is required.
	PartnershipId *string

	// Returns the unique, system-generated identifier for the profile connected to
	// this partnership.
	//
	// This member is required.
	ProfileId *string

	// Returns one or more capabilities associated with this partnership.
	Capabilities []string

	// Returns the email address associated with this trading partner.
	Email *string

	// Returns a timestamp that identifies the most recent date and time that the
	// partnership was modified.
	ModifiedAt *time.Time

	// Returns the display name of the partnership
	Name *string

	// Returns the phone number associated with the partnership.
	Phone *string

	// Returns the unique identifier for the partner for this partnership.
	TradingPartnerId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPartnershipMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetPartnership{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetPartnership{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPartnership"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetPartnershipValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPartnership(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetPartnership(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPartnership",
	}
}
