// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the properties associated with a model evaluation job, including the
// status of the job. For more information, see [Model evaluations].
//
// [Model evaluations]: https://docs.aws.amazon.com/bedrock/latest/userguide/latest/userguide/model-evaluation.html
func (c *Client) GetEvaluationJob(ctx context.Context, params *GetEvaluationJobInput, optFns ...func(*Options)) (*GetEvaluationJobOutput, error) {
	if params == nil {
		params = &GetEvaluationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEvaluationJob", params, optFns, c.addOperationGetEvaluationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEvaluationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEvaluationJobInput struct {

	// The Amazon Resource Name (ARN) of the model evaluation job.
	//
	// This member is required.
	JobIdentifier *string

	noSmithyDocumentSerde
}

type GetEvaluationJobOutput struct {

	// When the model evaluation job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// Contains details about the type of model evaluation job, the metrics used, the
	// task type selected, the datasets used, and any custom metrics you defined.
	//
	// This member is required.
	EvaluationConfig types.EvaluationConfig

	// Details about the models you specified in your model evaluation job.
	//
	// This member is required.
	InferenceConfig types.EvaluationInferenceConfig

	// The Amazon Resource Name (ARN) of the model evaluation job.
	//
	// This member is required.
	JobArn *string

	// The name of the model evaluation job.
	//
	// This member is required.
	JobName *string

	// The type of model evaluation job.
	//
	// This member is required.
	JobType types.EvaluationJobType

	// Amazon S3 location for where output data is saved.
	//
	// This member is required.
	OutputDataConfig *types.EvaluationOutputDataConfig

	// The Amazon Resource Name (ARN) of the IAM service role used in the model
	// evaluation job.
	//
	// This member is required.
	RoleArn *string

	// The status of the model evaluation job.
	//
	// This member is required.
	Status types.EvaluationJobStatus

	// The Amazon Resource Name (ARN) of the customer managed key specified when the
	// model evaluation job was created.
	CustomerEncryptionKeyId *string

	// An array of strings the specify why the model evaluation job has failed.
	FailureMessages []string

	// The description of the model evaluation job.
	JobDescription *string

	// When the model evaluation job was last modified.
	LastModifiedTime *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEvaluationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEvaluationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEvaluationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEvaluationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetEvaluationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEvaluationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEvaluationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEvaluationJob",
	}
}
