// Code generated by smithy-go-codegen DO NOT EDIT.

package chatbot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chatbot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all authorized MS teams for AWS Account
func (c *Client) ListMicrosoftTeamsConfiguredTeams(ctx context.Context, params *ListMicrosoftTeamsConfiguredTeamsInput, optFns ...func(*Options)) (*ListMicrosoftTeamsConfiguredTeamsOutput, error) {
	if params == nil {
		params = &ListMicrosoftTeamsConfiguredTeamsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMicrosoftTeamsConfiguredTeams", params, optFns, c.addOperationListMicrosoftTeamsConfiguredTeamsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMicrosoftTeamsConfiguredTeamsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMicrosoftTeamsConfiguredTeamsInput struct {

	// The maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so that
	// the remaining results can be retrieved.
	MaxResults *int32

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMicrosoftTeamsConfiguredTeamsOutput struct {

	// A list of teams in Microsoft Teams that have been configured with AWS Chatbot.
	ConfiguredTeams []types.ConfiguredTeam

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMicrosoftTeamsConfiguredTeamsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMicrosoftTeamsConfiguredTeams{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMicrosoftTeamsConfiguredTeams{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMicrosoftTeamsConfiguredTeams"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMicrosoftTeamsConfiguredTeams(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMicrosoftTeamsConfiguredTeamsAPIClient is a client that implements the
// ListMicrosoftTeamsConfiguredTeams operation.
type ListMicrosoftTeamsConfiguredTeamsAPIClient interface {
	ListMicrosoftTeamsConfiguredTeams(context.Context, *ListMicrosoftTeamsConfiguredTeamsInput, ...func(*Options)) (*ListMicrosoftTeamsConfiguredTeamsOutput, error)
}

var _ ListMicrosoftTeamsConfiguredTeamsAPIClient = (*Client)(nil)

// ListMicrosoftTeamsConfiguredTeamsPaginatorOptions is the paginator options for
// ListMicrosoftTeamsConfiguredTeams
type ListMicrosoftTeamsConfiguredTeamsPaginatorOptions struct {
	// The maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so that
	// the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMicrosoftTeamsConfiguredTeamsPaginator is a paginator for
// ListMicrosoftTeamsConfiguredTeams
type ListMicrosoftTeamsConfiguredTeamsPaginator struct {
	options   ListMicrosoftTeamsConfiguredTeamsPaginatorOptions
	client    ListMicrosoftTeamsConfiguredTeamsAPIClient
	params    *ListMicrosoftTeamsConfiguredTeamsInput
	nextToken *string
	firstPage bool
}

// NewListMicrosoftTeamsConfiguredTeamsPaginator returns a new
// ListMicrosoftTeamsConfiguredTeamsPaginator
func NewListMicrosoftTeamsConfiguredTeamsPaginator(client ListMicrosoftTeamsConfiguredTeamsAPIClient, params *ListMicrosoftTeamsConfiguredTeamsInput, optFns ...func(*ListMicrosoftTeamsConfiguredTeamsPaginatorOptions)) *ListMicrosoftTeamsConfiguredTeamsPaginator {
	if params == nil {
		params = &ListMicrosoftTeamsConfiguredTeamsInput{}
	}

	options := ListMicrosoftTeamsConfiguredTeamsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMicrosoftTeamsConfiguredTeamsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMicrosoftTeamsConfiguredTeamsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMicrosoftTeamsConfiguredTeams page.
func (p *ListMicrosoftTeamsConfiguredTeamsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMicrosoftTeamsConfiguredTeamsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListMicrosoftTeamsConfiguredTeams(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListMicrosoftTeamsConfiguredTeams(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMicrosoftTeamsConfiguredTeams",
	}
}
