// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/deploy/v1/cloud_deploy.proto

package deploypb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The support state of a specific Skaffold version.
type SkaffoldSupportState int32

const (
	// Default value. This value is unused.
	SkaffoldSupportState_SKAFFOLD_SUPPORT_STATE_UNSPECIFIED SkaffoldSupportState = 0
	// This Skaffold version is currently supported.
	SkaffoldSupportState_SKAFFOLD_SUPPORT_STATE_SUPPORTED SkaffoldSupportState = 1
	// This Skaffold version is in maintenance mode.
	SkaffoldSupportState_SKAFFOLD_SUPPORT_STATE_MAINTENANCE_MODE SkaffoldSupportState = 2
	// This Skaffold version is no longer supported.
	SkaffoldSupportState_SKAFFOLD_SUPPORT_STATE_UNSUPPORTED SkaffoldSupportState = 3
)

// Enum value maps for SkaffoldSupportState.
var (
	SkaffoldSupportState_name = map[int32]string{
		0: "SKAFFOLD_SUPPORT_STATE_UNSPECIFIED",
		1: "SKAFFOLD_SUPPORT_STATE_SUPPORTED",
		2: "SKAFFOLD_SUPPORT_STATE_MAINTENANCE_MODE",
		3: "SKAFFOLD_SUPPORT_STATE_UNSUPPORTED",
	}
	SkaffoldSupportState_value = map[string]int32{
		"SKAFFOLD_SUPPORT_STATE_UNSPECIFIED":      0,
		"SKAFFOLD_SUPPORT_STATE_SUPPORTED":        1,
		"SKAFFOLD_SUPPORT_STATE_MAINTENANCE_MODE": 2,
		"SKAFFOLD_SUPPORT_STATE_UNSUPPORTED":      3,
	}
)

func (x SkaffoldSupportState) Enum() *SkaffoldSupportState {
	p := new(SkaffoldSupportState)
	*p = x
	return p
}

func (x SkaffoldSupportState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SkaffoldSupportState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[0].Descriptor()
}

func (SkaffoldSupportState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[0]
}

func (x SkaffoldSupportState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SkaffoldSupportState.Descriptor instead.
func (SkaffoldSupportState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{0}
}

// The pattern of how wait time is increased.
type BackoffMode int32

const (
	// No WaitMode is specified.
	BackoffMode_BACKOFF_MODE_UNSPECIFIED BackoffMode = 0
	// Increases the wait time linearly.
	BackoffMode_BACKOFF_MODE_LINEAR BackoffMode = 1
	// Increases the wait time exponentially.
	BackoffMode_BACKOFF_MODE_EXPONENTIAL BackoffMode = 2
)

// Enum value maps for BackoffMode.
var (
	BackoffMode_name = map[int32]string{
		0: "BACKOFF_MODE_UNSPECIFIED",
		1: "BACKOFF_MODE_LINEAR",
		2: "BACKOFF_MODE_EXPONENTIAL",
	}
	BackoffMode_value = map[string]int32{
		"BACKOFF_MODE_UNSPECIFIED": 0,
		"BACKOFF_MODE_LINEAR":      1,
		"BACKOFF_MODE_EXPONENTIAL": 2,
	}
)

func (x BackoffMode) Enum() *BackoffMode {
	p := new(BackoffMode)
	*p = x
	return p
}

func (x BackoffMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackoffMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[1].Descriptor()
}

func (BackoffMode) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[1]
}

func (x BackoffMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackoffMode.Descriptor instead.
func (BackoffMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{1}
}

// Valid state of a repair attempt.
type RepairState int32

const (
	// The `repair` has an unspecified state.
	RepairState_REPAIR_STATE_UNSPECIFIED RepairState = 0
	// The `repair` action has succeeded.
	RepairState_REPAIR_STATE_SUCCEEDED RepairState = 1
	// The `repair` action was cancelled.
	RepairState_REPAIR_STATE_CANCELLED RepairState = 2
	// The `repair` action has failed.
	RepairState_REPAIR_STATE_FAILED RepairState = 3
	// The `repair` action is in progress.
	RepairState_REPAIR_STATE_IN_PROGRESS RepairState = 4
	// The `repair` action is pending.
	RepairState_REPAIR_STATE_PENDING RepairState = 5
	// The `repair` action was skipped.
	RepairState_REPAIR_STATE_SKIPPED RepairState = 6
)

// Enum value maps for RepairState.
var (
	RepairState_name = map[int32]string{
		0: "REPAIR_STATE_UNSPECIFIED",
		1: "REPAIR_STATE_SUCCEEDED",
		2: "REPAIR_STATE_CANCELLED",
		3: "REPAIR_STATE_FAILED",
		4: "REPAIR_STATE_IN_PROGRESS",
		5: "REPAIR_STATE_PENDING",
		6: "REPAIR_STATE_SKIPPED",
	}
	RepairState_value = map[string]int32{
		"REPAIR_STATE_UNSPECIFIED": 0,
		"REPAIR_STATE_SUCCEEDED":   1,
		"REPAIR_STATE_CANCELLED":   2,
		"REPAIR_STATE_FAILED":      3,
		"REPAIR_STATE_IN_PROGRESS": 4,
		"REPAIR_STATE_PENDING":     5,
		"REPAIR_STATE_SKIPPED":     6,
	}
)

func (x RepairState) Enum() *RepairState {
	p := new(RepairState)
	*p = x
	return p
}

func (x RepairState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RepairState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[2].Descriptor()
}

func (RepairState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[2]
}

func (x RepairState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RepairState.Descriptor instead.
func (RepairState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{2}
}

// Possible usages of this configuration.
type ExecutionConfig_ExecutionEnvironmentUsage int32

const (
	// Default value. This value is unused.
	ExecutionConfig_EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED ExecutionConfig_ExecutionEnvironmentUsage = 0
	// Use for rendering.
	ExecutionConfig_RENDER ExecutionConfig_ExecutionEnvironmentUsage = 1
	// Use for deploying and deployment hooks.
	ExecutionConfig_DEPLOY ExecutionConfig_ExecutionEnvironmentUsage = 2
	// Use for deployment verification.
	ExecutionConfig_VERIFY ExecutionConfig_ExecutionEnvironmentUsage = 3
	// Use for predeploy job execution.
	ExecutionConfig_PREDEPLOY ExecutionConfig_ExecutionEnvironmentUsage = 4
	// Use for postdeploy job execution.
	ExecutionConfig_POSTDEPLOY ExecutionConfig_ExecutionEnvironmentUsage = 5
)

// Enum value maps for ExecutionConfig_ExecutionEnvironmentUsage.
var (
	ExecutionConfig_ExecutionEnvironmentUsage_name = map[int32]string{
		0: "EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED",
		1: "RENDER",
		2: "DEPLOY",
		3: "VERIFY",
		4: "PREDEPLOY",
		5: "POSTDEPLOY",
	}
	ExecutionConfig_ExecutionEnvironmentUsage_value = map[string]int32{
		"EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED": 0,
		"RENDER":     1,
		"DEPLOY":     2,
		"VERIFY":     3,
		"PREDEPLOY":  4,
		"POSTDEPLOY": 5,
	}
)

func (x ExecutionConfig_ExecutionEnvironmentUsage) Enum() *ExecutionConfig_ExecutionEnvironmentUsage {
	p := new(ExecutionConfig_ExecutionEnvironmentUsage)
	*p = x
	return p
}

func (x ExecutionConfig_ExecutionEnvironmentUsage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionConfig_ExecutionEnvironmentUsage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[3].Descriptor()
}

func (ExecutionConfig_ExecutionEnvironmentUsage) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[3]
}

func (x ExecutionConfig_ExecutionEnvironmentUsage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionConfig_ExecutionEnvironmentUsage.Descriptor instead.
func (ExecutionConfig_ExecutionEnvironmentUsage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{28, 0}
}

// Valid states of the render operation.
type Release_RenderState int32

const (
	// The render state is unspecified.
	Release_RENDER_STATE_UNSPECIFIED Release_RenderState = 0
	// All rendering operations have completed successfully.
	Release_SUCCEEDED Release_RenderState = 1
	// All rendering operations have completed, and one or more have failed.
	Release_FAILED Release_RenderState = 2
	// Rendering has started and is not complete.
	Release_IN_PROGRESS Release_RenderState = 3
)

// Enum value maps for Release_RenderState.
var (
	Release_RenderState_name = map[int32]string{
		0: "RENDER_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "IN_PROGRESS",
	}
	Release_RenderState_value = map[string]int32{
		"RENDER_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":                1,
		"FAILED":                   2,
		"IN_PROGRESS":              3,
	}
)

func (x Release_RenderState) Enum() *Release_RenderState {
	p := new(Release_RenderState)
	*p = x
	return p
}

func (x Release_RenderState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Release_RenderState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[4].Descriptor()
}

func (Release_RenderState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[4]
}

func (x Release_RenderState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Release_RenderState.Descriptor instead.
func (Release_RenderState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52, 0}
}

// Valid states of the render operation.
type Release_TargetRender_TargetRenderState int32

const (
	// The render operation state is unspecified.
	Release_TargetRender_TARGET_RENDER_STATE_UNSPECIFIED Release_TargetRender_TargetRenderState = 0
	// The render operation has completed successfully.
	Release_TargetRender_SUCCEEDED Release_TargetRender_TargetRenderState = 1
	// The render operation has failed.
	Release_TargetRender_FAILED Release_TargetRender_TargetRenderState = 2
	// The render operation is in progress.
	Release_TargetRender_IN_PROGRESS Release_TargetRender_TargetRenderState = 3
)

// Enum value maps for Release_TargetRender_TargetRenderState.
var (
	Release_TargetRender_TargetRenderState_name = map[int32]string{
		0: "TARGET_RENDER_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "IN_PROGRESS",
	}
	Release_TargetRender_TargetRenderState_value = map[string]int32{
		"TARGET_RENDER_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":                       1,
		"FAILED":                          2,
		"IN_PROGRESS":                     3,
	}
)

func (x Release_TargetRender_TargetRenderState) Enum() *Release_TargetRender_TargetRenderState {
	p := new(Release_TargetRender_TargetRenderState)
	*p = x
	return p
}

func (x Release_TargetRender_TargetRenderState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Release_TargetRender_TargetRenderState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[5].Descriptor()
}

func (Release_TargetRender_TargetRenderState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[5]
}

func (x Release_TargetRender_TargetRenderState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Release_TargetRender_TargetRenderState.Descriptor instead.
func (Release_TargetRender_TargetRenderState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52, 0, 0}
}

// Well-known rendering failures.
type Release_TargetRender_FailureCause int32

const (
	// No reason for failure is specified.
	Release_TargetRender_FAILURE_CAUSE_UNSPECIFIED Release_TargetRender_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or
	// because Cloud Deploy has insufficient permissions. See [required
	// permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
	Release_TargetRender_CLOUD_BUILD_UNAVAILABLE Release_TargetRender_FailureCause = 1
	// The render operation did not complete successfully; check Cloud Build
	// logs.
	Release_TargetRender_EXECUTION_FAILED Release_TargetRender_FailureCause = 2
	// Cloud Build failed to fulfill Cloud Deploy's request. See
	// failure_message for additional details.
	Release_TargetRender_CLOUD_BUILD_REQUEST_FAILED Release_TargetRender_FailureCause = 3
	// The render operation did not complete successfully because the
	// verification stanza required for verify was not found on the Skaffold
	// configuration.
	Release_TargetRender_VERIFICATION_CONFIG_NOT_FOUND Release_TargetRender_FailureCause = 4
	// The render operation did not complete successfully because the custom
	// action required for predeploy or postdeploy was not found in the
	// Skaffold configuration. See failure_message for additional details.
	Release_TargetRender_CUSTOM_ACTION_NOT_FOUND Release_TargetRender_FailureCause = 5
	// Release failed during rendering because the release configuration is
	// not supported with the specified deployment strategy.
	Release_TargetRender_DEPLOYMENT_STRATEGY_NOT_SUPPORTED Release_TargetRender_FailureCause = 6
	// The render operation had a feature configured that is not supported.
	Release_TargetRender_RENDER_FEATURE_NOT_SUPPORTED Release_TargetRender_FailureCause = 7
)

// Enum value maps for Release_TargetRender_FailureCause.
var (
	Release_TargetRender_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "CLOUD_BUILD_REQUEST_FAILED",
		4: "VERIFICATION_CONFIG_NOT_FOUND",
		5: "CUSTOM_ACTION_NOT_FOUND",
		6: "DEPLOYMENT_STRATEGY_NOT_SUPPORTED",
		7: "RENDER_FEATURE_NOT_SUPPORTED",
	}
	Release_TargetRender_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":         0,
		"CLOUD_BUILD_UNAVAILABLE":           1,
		"EXECUTION_FAILED":                  2,
		"CLOUD_BUILD_REQUEST_FAILED":        3,
		"VERIFICATION_CONFIG_NOT_FOUND":     4,
		"CUSTOM_ACTION_NOT_FOUND":           5,
		"DEPLOYMENT_STRATEGY_NOT_SUPPORTED": 6,
		"RENDER_FEATURE_NOT_SUPPORTED":      7,
	}
)

func (x Release_TargetRender_FailureCause) Enum() *Release_TargetRender_FailureCause {
	p := new(Release_TargetRender_FailureCause)
	*p = x
	return p
}

func (x Release_TargetRender_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Release_TargetRender_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[6].Descriptor()
}

func (Release_TargetRender_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[6]
}

func (x Release_TargetRender_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Release_TargetRender_FailureCause.Descriptor instead.
func (Release_TargetRender_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52, 0, 1}
}

// Valid approval states of a `Rollout`.
type Rollout_ApprovalState int32

const (
	// The `Rollout` has an unspecified approval state.
	Rollout_APPROVAL_STATE_UNSPECIFIED Rollout_ApprovalState = 0
	// The `Rollout` requires approval.
	Rollout_NEEDS_APPROVAL Rollout_ApprovalState = 1
	// The `Rollout` does not require approval.
	Rollout_DOES_NOT_NEED_APPROVAL Rollout_ApprovalState = 2
	// The `Rollout` has been approved.
	Rollout_APPROVED Rollout_ApprovalState = 3
	// The `Rollout` has been rejected.
	Rollout_REJECTED Rollout_ApprovalState = 4
)

// Enum value maps for Rollout_ApprovalState.
var (
	Rollout_ApprovalState_name = map[int32]string{
		0: "APPROVAL_STATE_UNSPECIFIED",
		1: "NEEDS_APPROVAL",
		2: "DOES_NOT_NEED_APPROVAL",
		3: "APPROVED",
		4: "REJECTED",
	}
	Rollout_ApprovalState_value = map[string]int32{
		"APPROVAL_STATE_UNSPECIFIED": 0,
		"NEEDS_APPROVAL":             1,
		"DOES_NOT_NEED_APPROVAL":     2,
		"APPROVED":                   3,
		"REJECTED":                   4,
	}
)

func (x Rollout_ApprovalState) Enum() *Rollout_ApprovalState {
	p := new(Rollout_ApprovalState)
	*p = x
	return p
}

func (x Rollout_ApprovalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rollout_ApprovalState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[7].Descriptor()
}

func (Rollout_ApprovalState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[7]
}

func (x Rollout_ApprovalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rollout_ApprovalState.Descriptor instead.
func (Rollout_ApprovalState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{62, 0}
}

// Valid states of a `Rollout`.
type Rollout_State int32

const (
	// The `Rollout` has an unspecified state.
	Rollout_STATE_UNSPECIFIED Rollout_State = 0
	// The `Rollout` has completed successfully.
	Rollout_SUCCEEDED Rollout_State = 1
	// The `Rollout` has failed.
	Rollout_FAILED Rollout_State = 2
	// The `Rollout` is being deployed.
	Rollout_IN_PROGRESS Rollout_State = 3
	// The `Rollout` needs approval.
	Rollout_PENDING_APPROVAL Rollout_State = 4
	// An approver rejected the `Rollout`.
	Rollout_APPROVAL_REJECTED Rollout_State = 5
	// The `Rollout` is waiting for an earlier Rollout(s) to complete on this
	// `Target`.
	Rollout_PENDING Rollout_State = 6
	// The `Rollout` is waiting for the `Release` to be fully rendered.
	Rollout_PENDING_RELEASE Rollout_State = 7
	// The `Rollout` is in the process of being cancelled.
	Rollout_CANCELLING Rollout_State = 8
	// The `Rollout` has been cancelled.
	Rollout_CANCELLED Rollout_State = 9
	// The `Rollout` is halted.
	Rollout_HALTED Rollout_State = 10
)

// Enum value maps for Rollout_State.
var (
	Rollout_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "SUCCEEDED",
		2:  "FAILED",
		3:  "IN_PROGRESS",
		4:  "PENDING_APPROVAL",
		5:  "APPROVAL_REJECTED",
		6:  "PENDING",
		7:  "PENDING_RELEASE",
		8:  "CANCELLING",
		9:  "CANCELLED",
		10: "HALTED",
	}
	Rollout_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"IN_PROGRESS":       3,
		"PENDING_APPROVAL":  4,
		"APPROVAL_REJECTED": 5,
		"PENDING":           6,
		"PENDING_RELEASE":   7,
		"CANCELLING":        8,
		"CANCELLED":         9,
		"HALTED":            10,
	}
)

func (x Rollout_State) Enum() *Rollout_State {
	p := new(Rollout_State)
	*p = x
	return p
}

func (x Rollout_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rollout_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[8].Descriptor()
}

func (Rollout_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[8]
}

func (x Rollout_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rollout_State.Descriptor instead.
func (Rollout_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{62, 1}
}

// Well-known rollout failures.
type Rollout_FailureCause int32

const (
	// No reason for failure is specified.
	Rollout_FAILURE_CAUSE_UNSPECIFIED Rollout_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Cloud Deploy has insufficient permissions. See [required
	// permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
	Rollout_CLOUD_BUILD_UNAVAILABLE Rollout_FailureCause = 1
	// The deploy operation did not complete successfully; check Cloud Build
	// logs.
	Rollout_EXECUTION_FAILED Rollout_FailureCause = 2
	// Deployment did not complete within the alloted time.
	Rollout_DEADLINE_EXCEEDED Rollout_FailureCause = 3
	// Release is in a failed state.
	Rollout_RELEASE_FAILED Rollout_FailureCause = 4
	// Release is abandoned.
	Rollout_RELEASE_ABANDONED Rollout_FailureCause = 5
	// No Skaffold verify configuration was found.
	Rollout_VERIFICATION_CONFIG_NOT_FOUND Rollout_FailureCause = 6
	// Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
	// for additional details.
	Rollout_CLOUD_BUILD_REQUEST_FAILED Rollout_FailureCause = 7
	// A Rollout operation had a feature configured that is not supported.
	Rollout_OPERATION_FEATURE_NOT_SUPPORTED Rollout_FailureCause = 8
)

// Enum value maps for Rollout_FailureCause.
var (
	Rollout_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
		4: "RELEASE_FAILED",
		5: "RELEASE_ABANDONED",
		6: "VERIFICATION_CONFIG_NOT_FOUND",
		7: "CLOUD_BUILD_REQUEST_FAILED",
		8: "OPERATION_FEATURE_NOT_SUPPORTED",
	}
	Rollout_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":       0,
		"CLOUD_BUILD_UNAVAILABLE":         1,
		"EXECUTION_FAILED":                2,
		"DEADLINE_EXCEEDED":               3,
		"RELEASE_FAILED":                  4,
		"RELEASE_ABANDONED":               5,
		"VERIFICATION_CONFIG_NOT_FOUND":   6,
		"CLOUD_BUILD_REQUEST_FAILED":      7,
		"OPERATION_FEATURE_NOT_SUPPORTED": 8,
	}
)

func (x Rollout_FailureCause) Enum() *Rollout_FailureCause {
	p := new(Rollout_FailureCause)
	*p = x
	return p
}

func (x Rollout_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rollout_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[9].Descriptor()
}

func (Rollout_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[9]
}

func (x Rollout_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rollout_FailureCause.Descriptor instead.
func (Rollout_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{62, 2}
}

// Valid states of a Phase.
type Phase_State int32

const (
	// The Phase has an unspecified state.
	Phase_STATE_UNSPECIFIED Phase_State = 0
	// The Phase is waiting for an earlier Phase(s) to complete.
	Phase_PENDING Phase_State = 1
	// The Phase is in progress.
	Phase_IN_PROGRESS Phase_State = 2
	// The Phase has succeeded.
	Phase_SUCCEEDED Phase_State = 3
	// The Phase has failed.
	Phase_FAILED Phase_State = 4
	// The Phase was aborted.
	Phase_ABORTED Phase_State = 5
	// The Phase was skipped.
	Phase_SKIPPED Phase_State = 6
)

// Enum value maps for Phase_State.
var (
	Phase_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "IN_PROGRESS",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "ABORTED",
		6: "SKIPPED",
	}
	Phase_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"IN_PROGRESS":       2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"ABORTED":           5,
		"SKIPPED":           6,
	}
)

func (x Phase_State) Enum() *Phase_State {
	p := new(Phase_State)
	*p = x
	return p
}

func (x Phase_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Phase_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[10].Descriptor()
}

func (Phase_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[10]
}

func (x Phase_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Phase_State.Descriptor instead.
func (Phase_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{69, 0}
}

// Valid states of a Job.
type Job_State int32

const (
	// The Job has an unspecified state.
	Job_STATE_UNSPECIFIED Job_State = 0
	// The Job is waiting for an earlier Phase(s) or Job(s) to complete.
	Job_PENDING Job_State = 1
	// The Job is disabled.
	Job_DISABLED Job_State = 2
	// The Job is in progress.
	Job_IN_PROGRESS Job_State = 3
	// The Job succeeded.
	Job_SUCCEEDED Job_State = 4
	// The Job failed.
	Job_FAILED Job_State = 5
	// The Job was aborted.
	Job_ABORTED Job_State = 6
	// The Job was skipped.
	Job_SKIPPED Job_State = 7
	// The Job was ignored.
	Job_IGNORED Job_State = 8
)

// Enum value maps for Job_State.
var (
	Job_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "DISABLED",
		3: "IN_PROGRESS",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "ABORTED",
		7: "SKIPPED",
		8: "IGNORED",
	}
	Job_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"DISABLED":          2,
		"IN_PROGRESS":       3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"ABORTED":           6,
		"SKIPPED":           7,
		"IGNORED":           8,
	}
)

func (x Job_State) Enum() *Job_State {
	p := new(Job_State)
	*p = x
	return p
}

func (x Job_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[11].Descriptor()
}

func (Job_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[11]
}

func (x Job_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_State.Descriptor instead.
func (Job_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{72, 0}
}

// Valid states of a `JobRun`.
type JobRun_State int32

const (
	// The `JobRun` has an unspecified state.
	JobRun_STATE_UNSPECIFIED JobRun_State = 0
	// The `JobRun` is in progress.
	JobRun_IN_PROGRESS JobRun_State = 1
	// The `JobRun` has succeeded.
	JobRun_SUCCEEDED JobRun_State = 2
	// The `JobRun` has failed.
	JobRun_FAILED JobRun_State = 3
	// The `JobRun` is terminating.
	JobRun_TERMINATING JobRun_State = 4
	// The `JobRun` was terminated.
	JobRun_TERMINATED JobRun_State = 5
)

// Enum value maps for JobRun_State.
var (
	JobRun_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "TERMINATING",
		5: "TERMINATED",
	}
	JobRun_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":       1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"TERMINATING":       4,
		"TERMINATED":        5,
	}
)

func (x JobRun_State) Enum() *JobRun_State {
	p := new(JobRun_State)
	*p = x
	return p
}

func (x JobRun_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobRun_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[12].Descriptor()
}

func (JobRun_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[12]
}

func (x JobRun_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobRun_State.Descriptor instead.
func (JobRun_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{96, 0}
}

// Well-known deploy failures.
type DeployJobRun_FailureCause int32

const (
	// No reason for failure is specified.
	DeployJobRun_FAILURE_CAUSE_UNSPECIFIED DeployJobRun_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Cloud Deploy has insufficient permissions. See [Required
	// permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
	DeployJobRun_CLOUD_BUILD_UNAVAILABLE DeployJobRun_FailureCause = 1
	// The deploy operation did not complete successfully; check Cloud Build
	// logs.
	DeployJobRun_EXECUTION_FAILED DeployJobRun_FailureCause = 2
	// The deploy job run did not complete within the alloted time.
	DeployJobRun_DEADLINE_EXCEEDED DeployJobRun_FailureCause = 3
	// There were missing resources in the runtime environment required for a
	// canary deployment. Check the Cloud Build logs for more information.
	DeployJobRun_MISSING_RESOURCES_FOR_CANARY DeployJobRun_FailureCause = 4
	// Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
	// for additional details.
	DeployJobRun_CLOUD_BUILD_REQUEST_FAILED DeployJobRun_FailureCause = 5
	// The deploy operation had a feature configured that is not supported.
	DeployJobRun_DEPLOY_FEATURE_NOT_SUPPORTED DeployJobRun_FailureCause = 6
)

// Enum value maps for DeployJobRun_FailureCause.
var (
	DeployJobRun_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
		4: "MISSING_RESOURCES_FOR_CANARY",
		5: "CLOUD_BUILD_REQUEST_FAILED",
		6: "DEPLOY_FEATURE_NOT_SUPPORTED",
	}
	DeployJobRun_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":    0,
		"CLOUD_BUILD_UNAVAILABLE":      1,
		"EXECUTION_FAILED":             2,
		"DEADLINE_EXCEEDED":            3,
		"MISSING_RESOURCES_FOR_CANARY": 4,
		"CLOUD_BUILD_REQUEST_FAILED":   5,
		"DEPLOY_FEATURE_NOT_SUPPORTED": 6,
	}
)

func (x DeployJobRun_FailureCause) Enum() *DeployJobRun_FailureCause {
	p := new(DeployJobRun_FailureCause)
	*p = x
	return p
}

func (x DeployJobRun_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeployJobRun_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[13].Descriptor()
}

func (DeployJobRun_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[13]
}

func (x DeployJobRun_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeployJobRun_FailureCause.Descriptor instead.
func (DeployJobRun_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{97, 0}
}

// Well-known verify failures.
type VerifyJobRun_FailureCause int32

const (
	// No reason for failure is specified.
	VerifyJobRun_FAILURE_CAUSE_UNSPECIFIED VerifyJobRun_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Cloud Deploy has insufficient permissions. See [required
	// permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
	VerifyJobRun_CLOUD_BUILD_UNAVAILABLE VerifyJobRun_FailureCause = 1
	// The verify operation did not complete successfully; check Cloud Build
	// logs.
	VerifyJobRun_EXECUTION_FAILED VerifyJobRun_FailureCause = 2
	// The verify job run did not complete within the alloted time.
	VerifyJobRun_DEADLINE_EXCEEDED VerifyJobRun_FailureCause = 3
	// No Skaffold verify configuration was found.
	VerifyJobRun_VERIFICATION_CONFIG_NOT_FOUND VerifyJobRun_FailureCause = 4
	// Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
	// for additional details.
	VerifyJobRun_CLOUD_BUILD_REQUEST_FAILED VerifyJobRun_FailureCause = 5
)

// Enum value maps for VerifyJobRun_FailureCause.
var (
	VerifyJobRun_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
		4: "VERIFICATION_CONFIG_NOT_FOUND",
		5: "CLOUD_BUILD_REQUEST_FAILED",
	}
	VerifyJobRun_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":     0,
		"CLOUD_BUILD_UNAVAILABLE":       1,
		"EXECUTION_FAILED":              2,
		"DEADLINE_EXCEEDED":             3,
		"VERIFICATION_CONFIG_NOT_FOUND": 4,
		"CLOUD_BUILD_REQUEST_FAILED":    5,
	}
)

func (x VerifyJobRun_FailureCause) Enum() *VerifyJobRun_FailureCause {
	p := new(VerifyJobRun_FailureCause)
	*p = x
	return p
}

func (x VerifyJobRun_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VerifyJobRun_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[14].Descriptor()
}

func (VerifyJobRun_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[14]
}

func (x VerifyJobRun_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VerifyJobRun_FailureCause.Descriptor instead.
func (VerifyJobRun_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{98, 0}
}

// Well-known predeploy failures.
type PredeployJobRun_FailureCause int32

const (
	// No reason for failure is specified.
	PredeployJobRun_FAILURE_CAUSE_UNSPECIFIED PredeployJobRun_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Cloud Deploy has insufficient permissions. See [required
	// permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
	PredeployJobRun_CLOUD_BUILD_UNAVAILABLE PredeployJobRun_FailureCause = 1
	// The predeploy operation did not complete successfully; check Cloud Build
	// logs.
	PredeployJobRun_EXECUTION_FAILED PredeployJobRun_FailureCause = 2
	// The predeploy job run did not complete within the alloted time.
	PredeployJobRun_DEADLINE_EXCEEDED PredeployJobRun_FailureCause = 3
	// Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
	// for additional details.
	PredeployJobRun_CLOUD_BUILD_REQUEST_FAILED PredeployJobRun_FailureCause = 4
)

// Enum value maps for PredeployJobRun_FailureCause.
var (
	PredeployJobRun_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
		4: "CLOUD_BUILD_REQUEST_FAILED",
	}
	PredeployJobRun_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":  0,
		"CLOUD_BUILD_UNAVAILABLE":    1,
		"EXECUTION_FAILED":           2,
		"DEADLINE_EXCEEDED":          3,
		"CLOUD_BUILD_REQUEST_FAILED": 4,
	}
)

func (x PredeployJobRun_FailureCause) Enum() *PredeployJobRun_FailureCause {
	p := new(PredeployJobRun_FailureCause)
	*p = x
	return p
}

func (x PredeployJobRun_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PredeployJobRun_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[15].Descriptor()
}

func (PredeployJobRun_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[15]
}

func (x PredeployJobRun_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PredeployJobRun_FailureCause.Descriptor instead.
func (PredeployJobRun_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{99, 0}
}

// Well-known postdeploy failures.
type PostdeployJobRun_FailureCause int32

const (
	// No reason for failure is specified.
	PostdeployJobRun_FAILURE_CAUSE_UNSPECIFIED PostdeployJobRun_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Cloud Deploy has insufficient permissions. See [required
	// permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
	PostdeployJobRun_CLOUD_BUILD_UNAVAILABLE PostdeployJobRun_FailureCause = 1
	// The postdeploy operation did not complete successfully; check Cloud Build
	// logs.
	PostdeployJobRun_EXECUTION_FAILED PostdeployJobRun_FailureCause = 2
	// The postdeploy job run did not complete within the alloted time.
	PostdeployJobRun_DEADLINE_EXCEEDED PostdeployJobRun_FailureCause = 3
	// Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
	// for additional details.
	PostdeployJobRun_CLOUD_BUILD_REQUEST_FAILED PostdeployJobRun_FailureCause = 4
)

// Enum value maps for PostdeployJobRun_FailureCause.
var (
	PostdeployJobRun_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
		4: "CLOUD_BUILD_REQUEST_FAILED",
	}
	PostdeployJobRun_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":  0,
		"CLOUD_BUILD_UNAVAILABLE":    1,
		"EXECUTION_FAILED":           2,
		"DEADLINE_EXCEEDED":          3,
		"CLOUD_BUILD_REQUEST_FAILED": 4,
	}
)

func (x PostdeployJobRun_FailureCause) Enum() *PostdeployJobRun_FailureCause {
	p := new(PostdeployJobRun_FailureCause)
	*p = x
	return p
}

func (x PostdeployJobRun_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PostdeployJobRun_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[16].Descriptor()
}

func (PostdeployJobRun_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[16]
}

func (x PostdeployJobRun_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PostdeployJobRun_FailureCause.Descriptor instead.
func (PostdeployJobRun_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{100, 0}
}

// Valid state of an `AutomationRun`.
type AutomationRun_State int32

const (
	// The `AutomationRun` has an unspecified state.
	AutomationRun_STATE_UNSPECIFIED AutomationRun_State = 0
	// The `AutomationRun` has succeeded.
	AutomationRun_SUCCEEDED AutomationRun_State = 1
	// The `AutomationRun` was cancelled.
	AutomationRun_CANCELLED AutomationRun_State = 2
	// The `AutomationRun` has failed.
	AutomationRun_FAILED AutomationRun_State = 3
	// The `AutomationRun` is in progress.
	AutomationRun_IN_PROGRESS AutomationRun_State = 4
	// The `AutomationRun` is pending.
	AutomationRun_PENDING AutomationRun_State = 5
)

// Enum value maps for AutomationRun_State.
var (
	AutomationRun_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "CANCELLED",
		3: "FAILED",
		4: "IN_PROGRESS",
		5: "PENDING",
	}
	AutomationRun_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"CANCELLED":         2,
		"FAILED":            3,
		"IN_PROGRESS":       4,
		"PENDING":           5,
	}
)

func (x AutomationRun_State) Enum() *AutomationRun_State {
	p := new(AutomationRun_State)
	*p = x
	return p
}

func (x AutomationRun_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutomationRun_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[17].Descriptor()
}

func (AutomationRun_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[17]
}

func (x AutomationRun_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutomationRun_State.Descriptor instead.
func (AutomationRun_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{127, 0}
}

// A `DeliveryPipeline` resource in the Cloud Deploy API.
//
// A `DeliveryPipeline` defines a pipeline through which a Skaffold
// configuration can progress.
type DeliveryPipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `DeliveryPipeline`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9\-]{0,62}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `DeliveryPipeline`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Description of the `DeliveryPipeline`. Max length is 255 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// User annotations. These attributes can only be set and used by the
	// user, and not by Cloud Deploy.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Labels are attributes that can be set and used by both the
	// user and by Cloud Deploy. Labels must meet the following constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time at which the pipeline was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Most recent time at which the pipeline was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The ordering configuration of the `DeliveryPipeline`.
	//
	// Types that are assignable to Pipeline:
	//
	//	*DeliveryPipeline_SerialPipeline
	Pipeline isDeliveryPipeline_Pipeline `protobuf_oneof:"pipeline"`
	// Output only. Information around the state of the Delivery Pipeline.
	Condition *PipelineCondition `protobuf:"bytes,11,opt,name=condition,proto3" json:"condition,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	// When suspended, no new releases or rollouts can be created,
	// but in-progress ones will complete.
	Suspended bool `protobuf:"varint,12,opt,name=suspended,proto3" json:"suspended,omitempty"`
}

func (x *DeliveryPipeline) Reset() {
	*x = DeliveryPipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeliveryPipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeliveryPipeline) ProtoMessage() {}

func (x *DeliveryPipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeliveryPipeline.ProtoReflect.Descriptor instead.
func (*DeliveryPipeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{0}
}

func (x *DeliveryPipeline) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeliveryPipeline) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *DeliveryPipeline) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DeliveryPipeline) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *DeliveryPipeline) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DeliveryPipeline) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeliveryPipeline) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *DeliveryPipeline) GetPipeline() isDeliveryPipeline_Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (x *DeliveryPipeline) GetSerialPipeline() *SerialPipeline {
	if x, ok := x.GetPipeline().(*DeliveryPipeline_SerialPipeline); ok {
		return x.SerialPipeline
	}
	return nil
}

func (x *DeliveryPipeline) GetCondition() *PipelineCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *DeliveryPipeline) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeliveryPipeline) GetSuspended() bool {
	if x != nil {
		return x.Suspended
	}
	return false
}

type isDeliveryPipeline_Pipeline interface {
	isDeliveryPipeline_Pipeline()
}

type DeliveryPipeline_SerialPipeline struct {
	// SerialPipeline defines a sequential set of stages for a
	// `DeliveryPipeline`.
	SerialPipeline *SerialPipeline `protobuf:"bytes,8,opt,name=serial_pipeline,json=serialPipeline,proto3,oneof"`
}

func (*DeliveryPipeline_SerialPipeline) isDeliveryPipeline_Pipeline() {}

// SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
type SerialPipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each stage specifies configuration for a `Target`. The ordering
	// of this list defines the promotion flow.
	Stages []*Stage `protobuf:"bytes,1,rep,name=stages,proto3" json:"stages,omitempty"`
}

func (x *SerialPipeline) Reset() {
	*x = SerialPipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SerialPipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerialPipeline) ProtoMessage() {}

func (x *SerialPipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerialPipeline.ProtoReflect.Descriptor instead.
func (*SerialPipeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{1}
}

func (x *SerialPipeline) GetStages() []*Stage {
	if x != nil {
		return x.Stages
	}
	return nil
}

// Stage specifies a location to which to deploy.
type Stage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target_id to which this stage points. This field refers exclusively to
	// the last segment of a target name. For example, this field would just be
	// `my-target` (rather than
	// `projects/project/locations/location/targets/my-target`). The location of
	// the `Target` is inferred to be the same as the location of the
	// `DeliveryPipeline` that contains this `Stage`.
	TargetId string `protobuf:"bytes,1,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Skaffold profiles to use when rendering the manifest for this stage's
	// `Target`.
	Profiles []string `protobuf:"bytes,2,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// Optional. The strategy to use for a `Rollout` to this stage.
	Strategy *Strategy `protobuf:"bytes,5,opt,name=strategy,proto3" json:"strategy,omitempty"`
	// Optional. The deploy parameters to use for the target in this stage.
	DeployParameters []*DeployParameters `protobuf:"bytes,6,rep,name=deploy_parameters,json=deployParameters,proto3" json:"deploy_parameters,omitempty"`
}

func (x *Stage) Reset() {
	*x = Stage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stage) ProtoMessage() {}

func (x *Stage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stage.ProtoReflect.Descriptor instead.
func (*Stage) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{2}
}

func (x *Stage) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Stage) GetProfiles() []string {
	if x != nil {
		return x.Profiles
	}
	return nil
}

func (x *Stage) GetStrategy() *Strategy {
	if x != nil {
		return x.Strategy
	}
	return nil
}

func (x *Stage) GetDeployParameters() []*DeployParameters {
	if x != nil {
		return x.DeployParameters
	}
	return nil
}

// DeployParameters contains deploy parameters information.
type DeployParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Values are deploy parameters in key-value pairs.
	Values map[string]string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Deploy parameters are applied to targets with match labels.
	// If unspecified, deploy parameters are applied to all targets (including
	// child targets of a multi-target).
	MatchTargetLabels map[string]string `protobuf:"bytes,2,rep,name=match_target_labels,json=matchTargetLabels,proto3" json:"match_target_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DeployParameters) Reset() {
	*x = DeployParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployParameters) ProtoMessage() {}

func (x *DeployParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployParameters.ProtoReflect.Descriptor instead.
func (*DeployParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{3}
}

func (x *DeployParameters) GetValues() map[string]string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *DeployParameters) GetMatchTargetLabels() map[string]string {
	if x != nil {
		return x.MatchTargetLabels
	}
	return nil
}

// Strategy contains deployment strategy information.
type Strategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deployment strategy details.
	//
	// Types that are assignable to DeploymentStrategy:
	//
	//	*Strategy_Standard
	//	*Strategy_Canary
	DeploymentStrategy isStrategy_DeploymentStrategy `protobuf_oneof:"deployment_strategy"`
}

func (x *Strategy) Reset() {
	*x = Strategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Strategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Strategy) ProtoMessage() {}

func (x *Strategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Strategy.ProtoReflect.Descriptor instead.
func (*Strategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{4}
}

func (m *Strategy) GetDeploymentStrategy() isStrategy_DeploymentStrategy {
	if m != nil {
		return m.DeploymentStrategy
	}
	return nil
}

func (x *Strategy) GetStandard() *Standard {
	if x, ok := x.GetDeploymentStrategy().(*Strategy_Standard); ok {
		return x.Standard
	}
	return nil
}

func (x *Strategy) GetCanary() *Canary {
	if x, ok := x.GetDeploymentStrategy().(*Strategy_Canary); ok {
		return x.Canary
	}
	return nil
}

type isStrategy_DeploymentStrategy interface {
	isStrategy_DeploymentStrategy()
}

type Strategy_Standard struct {
	// Standard deployment strategy executes a single deploy and allows
	// verifying the deployment.
	Standard *Standard `protobuf:"bytes,1,opt,name=standard,proto3,oneof"`
}

type Strategy_Canary struct {
	// Canary deployment strategy provides progressive percentage based
	// deployments to a Target.
	Canary *Canary `protobuf:"bytes,2,opt,name=canary,proto3,oneof"`
}

func (*Strategy_Standard) isStrategy_DeploymentStrategy() {}

func (*Strategy_Canary) isStrategy_DeploymentStrategy() {}

// Predeploy contains the predeploy job configuration information.
type Predeploy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A sequence of Skaffold custom actions to invoke during execution
	// of the predeploy job.
	Actions []string `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *Predeploy) Reset() {
	*x = Predeploy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Predeploy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Predeploy) ProtoMessage() {}

func (x *Predeploy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Predeploy.ProtoReflect.Descriptor instead.
func (*Predeploy) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{5}
}

func (x *Predeploy) GetActions() []string {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Postdeploy contains the postdeploy job configuration information.
type Postdeploy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A sequence of Skaffold custom actions to invoke during execution
	// of the postdeploy job.
	Actions []string `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *Postdeploy) Reset() {
	*x = Postdeploy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Postdeploy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Postdeploy) ProtoMessage() {}

func (x *Postdeploy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Postdeploy.ProtoReflect.Descriptor instead.
func (*Postdeploy) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{6}
}

func (x *Postdeploy) GetActions() []string {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Standard represents the standard deployment strategy.
type Standard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to verify a deployment.
	Verify bool `protobuf:"varint,1,opt,name=verify,proto3" json:"verify,omitempty"`
	// Optional. Configuration for the predeploy job. If this is not configured,
	// predeploy job will not be present.
	Predeploy *Predeploy `protobuf:"bytes,2,opt,name=predeploy,proto3" json:"predeploy,omitempty"`
	// Optional. Configuration for the postdeploy job. If this is not configured,
	// postdeploy job will not be present.
	Postdeploy *Postdeploy `protobuf:"bytes,3,opt,name=postdeploy,proto3" json:"postdeploy,omitempty"`
}

func (x *Standard) Reset() {
	*x = Standard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Standard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Standard) ProtoMessage() {}

func (x *Standard) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Standard.ProtoReflect.Descriptor instead.
func (*Standard) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{7}
}

func (x *Standard) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *Standard) GetPredeploy() *Predeploy {
	if x != nil {
		return x.Predeploy
	}
	return nil
}

func (x *Standard) GetPostdeploy() *Postdeploy {
	if x != nil {
		return x.Postdeploy
	}
	return nil
}

// Canary represents the canary deployment strategy.
type Canary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Runtime specific configurations for the deployment strategy. The
	// runtime configuration is used to determine how Cloud Deploy will split
	// traffic to enable a progressive deployment.
	RuntimeConfig *RuntimeConfig `protobuf:"bytes,1,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
	// The mode to use for the canary deployment strategy.
	//
	// Types that are assignable to Mode:
	//
	//	*Canary_CanaryDeployment
	//	*Canary_CustomCanaryDeployment
	Mode isCanary_Mode `protobuf_oneof:"mode"`
}

func (x *Canary) Reset() {
	*x = Canary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Canary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Canary) ProtoMessage() {}

func (x *Canary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Canary.ProtoReflect.Descriptor instead.
func (*Canary) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{8}
}

func (x *Canary) GetRuntimeConfig() *RuntimeConfig {
	if x != nil {
		return x.RuntimeConfig
	}
	return nil
}

func (m *Canary) GetMode() isCanary_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *Canary) GetCanaryDeployment() *CanaryDeployment {
	if x, ok := x.GetMode().(*Canary_CanaryDeployment); ok {
		return x.CanaryDeployment
	}
	return nil
}

func (x *Canary) GetCustomCanaryDeployment() *CustomCanaryDeployment {
	if x, ok := x.GetMode().(*Canary_CustomCanaryDeployment); ok {
		return x.CustomCanaryDeployment
	}
	return nil
}

type isCanary_Mode interface {
	isCanary_Mode()
}

type Canary_CanaryDeployment struct {
	// Configures the progressive based deployment for a Target.
	CanaryDeployment *CanaryDeployment `protobuf:"bytes,2,opt,name=canary_deployment,json=canaryDeployment,proto3,oneof"`
}

type Canary_CustomCanaryDeployment struct {
	// Configures the progressive based deployment for a Target, but allows
	// customizing at the phase level where a phase represents each of the
	// percentage deployments.
	CustomCanaryDeployment *CustomCanaryDeployment `protobuf:"bytes,3,opt,name=custom_canary_deployment,json=customCanaryDeployment,proto3,oneof"`
}

func (*Canary_CanaryDeployment) isCanary_Mode() {}

func (*Canary_CustomCanaryDeployment) isCanary_Mode() {}

// CanaryDeployment represents the canary deployment configuration
type CanaryDeployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The percentage based deployments that will occur as a part of a
	// `Rollout`. List is expected in ascending order and each integer n is
	// 0 <= n < 100.
	Percentages []int32 `protobuf:"varint,1,rep,packed,name=percentages,proto3" json:"percentages,omitempty"`
	// Whether to run verify tests after each percentage deployment.
	Verify bool `protobuf:"varint,2,opt,name=verify,proto3" json:"verify,omitempty"`
	// Optional. Configuration for the predeploy job of the first phase. If this
	// is not configured, there will be no predeploy job for this phase.
	Predeploy *Predeploy `protobuf:"bytes,3,opt,name=predeploy,proto3" json:"predeploy,omitempty"`
	// Optional. Configuration for the postdeploy job of the last phase. If this
	// is not configured, there will be no postdeploy job for this phase.
	Postdeploy *Postdeploy `protobuf:"bytes,4,opt,name=postdeploy,proto3" json:"postdeploy,omitempty"`
}

func (x *CanaryDeployment) Reset() {
	*x = CanaryDeployment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CanaryDeployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CanaryDeployment) ProtoMessage() {}

func (x *CanaryDeployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CanaryDeployment.ProtoReflect.Descriptor instead.
func (*CanaryDeployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{9}
}

func (x *CanaryDeployment) GetPercentages() []int32 {
	if x != nil {
		return x.Percentages
	}
	return nil
}

func (x *CanaryDeployment) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *CanaryDeployment) GetPredeploy() *Predeploy {
	if x != nil {
		return x.Predeploy
	}
	return nil
}

func (x *CanaryDeployment) GetPostdeploy() *Postdeploy {
	if x != nil {
		return x.Postdeploy
	}
	return nil
}

// CustomCanaryDeployment represents the custom canary deployment
// configuration.
type CustomCanaryDeployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Configuration for each phase in the canary deployment in the
	// order executed.
	PhaseConfigs []*CustomCanaryDeployment_PhaseConfig `protobuf:"bytes,1,rep,name=phase_configs,json=phaseConfigs,proto3" json:"phase_configs,omitempty"`
}

func (x *CustomCanaryDeployment) Reset() {
	*x = CustomCanaryDeployment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomCanaryDeployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomCanaryDeployment) ProtoMessage() {}

func (x *CustomCanaryDeployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomCanaryDeployment.ProtoReflect.Descriptor instead.
func (*CustomCanaryDeployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{10}
}

func (x *CustomCanaryDeployment) GetPhaseConfigs() []*CustomCanaryDeployment_PhaseConfig {
	if x != nil {
		return x.PhaseConfigs
	}
	return nil
}

// KubernetesConfig contains the Kubernetes runtime configuration.
type KubernetesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The service definition configuration.
	//
	// Types that are assignable to ServiceDefinition:
	//
	//	*KubernetesConfig_GatewayServiceMesh_
	//	*KubernetesConfig_ServiceNetworking_
	ServiceDefinition isKubernetesConfig_ServiceDefinition `protobuf_oneof:"service_definition"`
}

func (x *KubernetesConfig) Reset() {
	*x = KubernetesConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesConfig) ProtoMessage() {}

func (x *KubernetesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesConfig.ProtoReflect.Descriptor instead.
func (*KubernetesConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{11}
}

func (m *KubernetesConfig) GetServiceDefinition() isKubernetesConfig_ServiceDefinition {
	if m != nil {
		return m.ServiceDefinition
	}
	return nil
}

func (x *KubernetesConfig) GetGatewayServiceMesh() *KubernetesConfig_GatewayServiceMesh {
	if x, ok := x.GetServiceDefinition().(*KubernetesConfig_GatewayServiceMesh_); ok {
		return x.GatewayServiceMesh
	}
	return nil
}

func (x *KubernetesConfig) GetServiceNetworking() *KubernetesConfig_ServiceNetworking {
	if x, ok := x.GetServiceDefinition().(*KubernetesConfig_ServiceNetworking_); ok {
		return x.ServiceNetworking
	}
	return nil
}

type isKubernetesConfig_ServiceDefinition interface {
	isKubernetesConfig_ServiceDefinition()
}

type KubernetesConfig_GatewayServiceMesh_ struct {
	// Kubernetes Gateway API service mesh configuration.
	GatewayServiceMesh *KubernetesConfig_GatewayServiceMesh `protobuf:"bytes,1,opt,name=gateway_service_mesh,json=gatewayServiceMesh,proto3,oneof"`
}

type KubernetesConfig_ServiceNetworking_ struct {
	// Kubernetes Service networking configuration.
	ServiceNetworking *KubernetesConfig_ServiceNetworking `protobuf:"bytes,2,opt,name=service_networking,json=serviceNetworking,proto3,oneof"`
}

func (*KubernetesConfig_GatewayServiceMesh_) isKubernetesConfig_ServiceDefinition() {}

func (*KubernetesConfig_ServiceNetworking_) isKubernetesConfig_ServiceDefinition() {}

// CloudRunConfig contains the Cloud Run runtime configuration.
type CloudRunConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Cloud Deploy should update the traffic stanza in a Cloud Run
	// Service on the user's behalf to facilitate traffic splitting. This is
	// required to be true for CanaryDeployments, but optional for
	// CustomCanaryDeployments.
	AutomaticTrafficControl bool `protobuf:"varint,1,opt,name=automatic_traffic_control,json=automaticTrafficControl,proto3" json:"automatic_traffic_control,omitempty"`
	// Optional. A list of tags that are added to the canary revision while the
	// canary phase is in progress.
	CanaryRevisionTags []string `protobuf:"bytes,2,rep,name=canary_revision_tags,json=canaryRevisionTags,proto3" json:"canary_revision_tags,omitempty"`
	// Optional. A list of tags that are added to the prior revision while the
	// canary phase is in progress.
	PriorRevisionTags []string `protobuf:"bytes,3,rep,name=prior_revision_tags,json=priorRevisionTags,proto3" json:"prior_revision_tags,omitempty"`
	// Optional. A list of tags that are added to the final stable revision when
	// the stable phase is applied.
	StableRevisionTags []string `protobuf:"bytes,4,rep,name=stable_revision_tags,json=stableRevisionTags,proto3" json:"stable_revision_tags,omitempty"`
}

func (x *CloudRunConfig) Reset() {
	*x = CloudRunConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRunConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunConfig) ProtoMessage() {}

func (x *CloudRunConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunConfig.ProtoReflect.Descriptor instead.
func (*CloudRunConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{12}
}

func (x *CloudRunConfig) GetAutomaticTrafficControl() bool {
	if x != nil {
		return x.AutomaticTrafficControl
	}
	return false
}

func (x *CloudRunConfig) GetCanaryRevisionTags() []string {
	if x != nil {
		return x.CanaryRevisionTags
	}
	return nil
}

func (x *CloudRunConfig) GetPriorRevisionTags() []string {
	if x != nil {
		return x.PriorRevisionTags
	}
	return nil
}

func (x *CloudRunConfig) GetStableRevisionTags() []string {
	if x != nil {
		return x.StableRevisionTags
	}
	return nil
}

// RuntimeConfig contains the runtime specific configurations for a deployment
// strategy.
type RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The runtime configuration details.
	//
	// Types that are assignable to RuntimeConfig:
	//
	//	*RuntimeConfig_Kubernetes
	//	*RuntimeConfig_CloudRun
	RuntimeConfig isRuntimeConfig_RuntimeConfig `protobuf_oneof:"runtime_config"`
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{13}
}

func (m *RuntimeConfig) GetRuntimeConfig() isRuntimeConfig_RuntimeConfig {
	if m != nil {
		return m.RuntimeConfig
	}
	return nil
}

func (x *RuntimeConfig) GetKubernetes() *KubernetesConfig {
	if x, ok := x.GetRuntimeConfig().(*RuntimeConfig_Kubernetes); ok {
		return x.Kubernetes
	}
	return nil
}

func (x *RuntimeConfig) GetCloudRun() *CloudRunConfig {
	if x, ok := x.GetRuntimeConfig().(*RuntimeConfig_CloudRun); ok {
		return x.CloudRun
	}
	return nil
}

type isRuntimeConfig_RuntimeConfig interface {
	isRuntimeConfig_RuntimeConfig()
}

type RuntimeConfig_Kubernetes struct {
	// Kubernetes runtime configuration.
	Kubernetes *KubernetesConfig `protobuf:"bytes,1,opt,name=kubernetes,proto3,oneof"`
}

type RuntimeConfig_CloudRun struct {
	// Cloud Run runtime configuration.
	CloudRun *CloudRunConfig `protobuf:"bytes,2,opt,name=cloud_run,json=cloudRun,proto3,oneof"`
}

func (*RuntimeConfig_Kubernetes) isRuntimeConfig_RuntimeConfig() {}

func (*RuntimeConfig_CloudRun) isRuntimeConfig_RuntimeConfig() {}

// PipelineReadyCondition contains information around the status of the
// Pipeline.
type PipelineReadyCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the Pipeline is in a valid state. Otherwise at least one condition
	// in `PipelineCondition` is in an invalid state. Iterate over those
	// conditions and see which condition(s) has status = false to find out what
	// is wrong with the Pipeline.
	Status bool `protobuf:"varint,3,opt,name=status,proto3" json:"status,omitempty"`
	// Last time the condition was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *PipelineReadyCondition) Reset() {
	*x = PipelineReadyCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineReadyCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineReadyCondition) ProtoMessage() {}

func (x *PipelineReadyCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineReadyCondition.ProtoReflect.Descriptor instead.
func (*PipelineReadyCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{14}
}

func (x *PipelineReadyCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *PipelineReadyCondition) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// `TargetsPresentCondition` contains information on any Targets referenced in
// the Delivery Pipeline that do not actually exist.
type TargetsPresentCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if there aren't any missing Targets.
	Status bool `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	// The list of Target names that do not exist. For example,
	// `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
	MissingTargets []string `protobuf:"bytes,2,rep,name=missing_targets,json=missingTargets,proto3" json:"missing_targets,omitempty"`
	// Last time the condition was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *TargetsPresentCondition) Reset() {
	*x = TargetsPresentCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetsPresentCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetsPresentCondition) ProtoMessage() {}

func (x *TargetsPresentCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetsPresentCondition.ProtoReflect.Descriptor instead.
func (*TargetsPresentCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{15}
}

func (x *TargetsPresentCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *TargetsPresentCondition) GetMissingTargets() []string {
	if x != nil {
		return x.MissingTargets
	}
	return nil
}

func (x *TargetsPresentCondition) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// TargetsTypeCondition contains information on whether the Targets defined in
// the Delivery Pipeline are of the same type.
type TargetsTypeCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the targets are all a comparable type. For example this is true if
	// all targets are GKE clusters. This is false if some targets are Cloud Run
	// targets and others are GKE clusters.
	Status bool `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	// Human readable error message.
	ErrorDetails string `protobuf:"bytes,2,opt,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
}

func (x *TargetsTypeCondition) Reset() {
	*x = TargetsTypeCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetsTypeCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetsTypeCondition) ProtoMessage() {}

func (x *TargetsTypeCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetsTypeCondition.ProtoReflect.Descriptor instead.
func (*TargetsTypeCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{16}
}

func (x *TargetsTypeCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *TargetsTypeCondition) GetErrorDetails() string {
	if x != nil {
		return x.ErrorDetails
	}
	return ""
}

// PipelineCondition contains all conditions relevant to a Delivery Pipeline.
type PipelineCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details around the Pipeline's overall status.
	PipelineReadyCondition *PipelineReadyCondition `protobuf:"bytes,1,opt,name=pipeline_ready_condition,json=pipelineReadyCondition,proto3" json:"pipeline_ready_condition,omitempty"`
	// Details around targets enumerated in the pipeline.
	TargetsPresentCondition *TargetsPresentCondition `protobuf:"bytes,3,opt,name=targets_present_condition,json=targetsPresentCondition,proto3" json:"targets_present_condition,omitempty"`
	// Details on the whether the targets enumerated in the pipeline are of the
	// same type.
	TargetsTypeCondition *TargetsTypeCondition `protobuf:"bytes,4,opt,name=targets_type_condition,json=targetsTypeCondition,proto3" json:"targets_type_condition,omitempty"`
}

func (x *PipelineCondition) Reset() {
	*x = PipelineCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineCondition) ProtoMessage() {}

func (x *PipelineCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineCondition.ProtoReflect.Descriptor instead.
func (*PipelineCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{17}
}

func (x *PipelineCondition) GetPipelineReadyCondition() *PipelineReadyCondition {
	if x != nil {
		return x.PipelineReadyCondition
	}
	return nil
}

func (x *PipelineCondition) GetTargetsPresentCondition() *TargetsPresentCondition {
	if x != nil {
		return x.TargetsPresentCondition
	}
	return nil
}

func (x *PipelineCondition) GetTargetsTypeCondition() *TargetsTypeCondition {
	if x != nil {
		return x.TargetsTypeCondition
	}
	return nil
}

// The request object for `ListDeliveryPipelines`.
type ListDeliveryPipelinesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of pipelines. Format must
	// be `projects/{project_id}/locations/{location_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of pipelines to return. The service may return
	// fewer than this value. If unspecified, at most 50 pipelines will
	// be returned. The maximum value is 1000; values above 1000 will be set
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDeliveryPipelines` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter pipelines to be returned. See https://google.aip.dev/160 for more
	// details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDeliveryPipelinesRequest) Reset() {
	*x = ListDeliveryPipelinesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeliveryPipelinesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeliveryPipelinesRequest) ProtoMessage() {}

func (x *ListDeliveryPipelinesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeliveryPipelinesRequest.ProtoReflect.Descriptor instead.
func (*ListDeliveryPipelinesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{18}
}

func (x *ListDeliveryPipelinesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeliveryPipelinesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeliveryPipelinesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDeliveryPipelinesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDeliveryPipelinesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListDeliveryPipelines`.
type ListDeliveryPipelinesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `DeliveryPipeline` objects.
	DeliveryPipelines []*DeliveryPipeline `protobuf:"bytes,1,rep,name=delivery_pipelines,json=deliveryPipelines,proto3" json:"delivery_pipelines,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDeliveryPipelinesResponse) Reset() {
	*x = ListDeliveryPipelinesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeliveryPipelinesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeliveryPipelinesResponse) ProtoMessage() {}

func (x *ListDeliveryPipelinesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeliveryPipelinesResponse.ProtoReflect.Descriptor instead.
func (*ListDeliveryPipelinesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{19}
}

func (x *ListDeliveryPipelinesResponse) GetDeliveryPipelines() []*DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipelines
	}
	return nil
}

func (x *ListDeliveryPipelinesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDeliveryPipelinesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetDeliveryPipeline`
type GetDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `DeliveryPipeline`. Format must be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeliveryPipelineRequest) Reset() {
	*x = GetDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeliveryPipelineRequest) ProtoMessage() {}

func (x *GetDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*GetDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{20}
}

func (x *GetDeliveryPipelineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object for `CreateDeliveryPipeline`.
type CreateDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `DeliveryPipeline` should be
	// created. Format should be
	// `projects/{project_id}/locations/{location_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `DeliveryPipeline`.
	DeliveryPipelineId string `protobuf:"bytes,2,opt,name=delivery_pipeline_id,json=deliveryPipelineId,proto3" json:"delivery_pipeline_id,omitempty"`
	// Required. The `DeliveryPipeline` to create.
	DeliveryPipeline *DeliveryPipeline `protobuf:"bytes,3,opt,name=delivery_pipeline,json=deliveryPipeline,proto3" json:"delivery_pipeline,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateDeliveryPipelineRequest) Reset() {
	*x = CreateDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeliveryPipelineRequest) ProtoMessage() {}

func (x *CreateDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*CreateDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{21}
}

func (x *CreateDeliveryPipelineRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeliveryPipelineRequest) GetDeliveryPipelineId() string {
	if x != nil {
		return x.DeliveryPipelineId
	}
	return ""
}

func (x *CreateDeliveryPipelineRequest) GetDeliveryPipeline() *DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipeline
	}
	return nil
}

func (x *CreateDeliveryPipelineRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateDeliveryPipelineRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `UpdateDeliveryPipeline`.
type UpdateDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `DeliveryPipeline` resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it's in the mask. If the
	// user doesn't provide a mask then all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The `DeliveryPipeline` to update.
	DeliveryPipeline *DeliveryPipeline `protobuf:"bytes,2,opt,name=delivery_pipeline,json=deliveryPipeline,proto3" json:"delivery_pipeline,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, updating a `DeliveryPipeline` that does not exist
	// will result in the creation of a new `DeliveryPipeline`.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateDeliveryPipelineRequest) Reset() {
	*x = UpdateDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeliveryPipelineRequest) ProtoMessage() {}

func (x *UpdateDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateDeliveryPipelineRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDeliveryPipelineRequest) GetDeliveryPipeline() *DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipeline
	}
	return nil
}

func (x *UpdateDeliveryPipelineRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateDeliveryPipelineRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateDeliveryPipelineRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `DeleteDeliveryPipeline`.
type DeleteDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `DeliveryPipeline` to delete. Format should be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, then deleting an already deleted or non-existing
	// `DeliveryPipeline` will succeed.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set, validate the request and preview the review, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. If set to true, all child resources under this pipeline will also
	// be deleted. Otherwise, the request will only work if the pipeline has no
	// child resources.
	Force bool `protobuf:"varint,6,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteDeliveryPipelineRequest) Reset() {
	*x = DeleteDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeliveryPipelineRequest) ProtoMessage() {}

func (x *DeleteDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{23}
}

func (x *DeleteDeliveryPipelineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDeliveryPipelineRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteDeliveryPipelineRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteDeliveryPipelineRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteDeliveryPipelineRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteDeliveryPipelineRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Configs for the Rollback rollout.
type RollbackTargetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The rollback `Rollout` to create.
	Rollout *Rollout `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Optional. The starting phase ID for the `Rollout`. If unspecified, the
	// `Rollout` will start in the stable phase.
	StartingPhaseId string `protobuf:"bytes,2,opt,name=starting_phase_id,json=startingPhaseId,proto3" json:"starting_phase_id,omitempty"`
}

func (x *RollbackTargetConfig) Reset() {
	*x = RollbackTargetConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackTargetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackTargetConfig) ProtoMessage() {}

func (x *RollbackTargetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackTargetConfig.ProtoReflect.Descriptor instead.
func (*RollbackTargetConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{24}
}

func (x *RollbackTargetConfig) GetRollout() *Rollout {
	if x != nil {
		return x.Rollout
	}
	return nil
}

func (x *RollbackTargetConfig) GetStartingPhaseId() string {
	if x != nil {
		return x.StartingPhaseId
	}
	return ""
}

// The request object for `RollbackTarget`.
type RollbackTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `DeliveryPipeline` for which the rollback `Rollout` should be
	// created. Format should be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. ID of the `Target` that is being rolled back.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Required. ID of the rollback `Rollout` to create.
	RolloutId string `protobuf:"bytes,3,opt,name=rollout_id,json=rolloutId,proto3" json:"rollout_id,omitempty"`
	// Optional. ID of the `Release` to roll back to. If this isn't specified, the
	// previous successful `Rollout` to the specified target will be used to
	// determine the `Release`.
	ReleaseId string `protobuf:"bytes,4,opt,name=release_id,json=releaseId,proto3" json:"release_id,omitempty"`
	// Optional. If provided, this must be the latest `Rollout` that is on the
	// `Target`.
	RolloutToRollBack string `protobuf:"bytes,5,opt,name=rollout_to_roll_back,json=rolloutToRollBack,proto3" json:"rollout_to_roll_back,omitempty"`
	// Optional. Configs for the rollback `Rollout`.
	RollbackConfig *RollbackTargetConfig `protobuf:"bytes,6,opt,name=rollback_config,json=rollbackConfig,proto3" json:"rollback_config,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with a `RollbackTargetResponse`.
	ValidateOnly bool `protobuf:"varint,7,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *RollbackTargetRequest) Reset() {
	*x = RollbackTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackTargetRequest) ProtoMessage() {}

func (x *RollbackTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackTargetRequest.ProtoReflect.Descriptor instead.
func (*RollbackTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{25}
}

func (x *RollbackTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RollbackTargetRequest) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *RollbackTargetRequest) GetRolloutId() string {
	if x != nil {
		return x.RolloutId
	}
	return ""
}

func (x *RollbackTargetRequest) GetReleaseId() string {
	if x != nil {
		return x.ReleaseId
	}
	return ""
}

func (x *RollbackTargetRequest) GetRolloutToRollBack() string {
	if x != nil {
		return x.RolloutToRollBack
	}
	return ""
}

func (x *RollbackTargetRequest) GetRollbackConfig() *RollbackTargetConfig {
	if x != nil {
		return x.RollbackConfig
	}
	return nil
}

func (x *RollbackTargetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The response object from `RollbackTarget`.
type RollbackTargetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The config of the rollback `Rollout` created or will be created.
	RollbackConfig *RollbackTargetConfig `protobuf:"bytes,1,opt,name=rollback_config,json=rollbackConfig,proto3" json:"rollback_config,omitempty"`
}

func (x *RollbackTargetResponse) Reset() {
	*x = RollbackTargetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackTargetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackTargetResponse) ProtoMessage() {}

func (x *RollbackTargetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackTargetResponse.ProtoReflect.Descriptor instead.
func (*RollbackTargetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{26}
}

func (x *RollbackTargetResponse) GetRollbackConfig() *RollbackTargetConfig {
	if x != nil {
		return x.RollbackConfig
	}
	return nil
}

// A `Target` resource in the Cloud Deploy API.
//
// A `Target` defines a location to which a Skaffold configuration
// can be deployed.
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `Target`. Format is
	// `projects/{project}/locations/{location}/targets/[a-z][a-z0-9\-]{0,62}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Resource id of the `Target`.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Output only. Unique identifier of the `Target`.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Description of the `Target`. Max length is 255 characters.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User annotations. These attributes can only be set and used by
	// the user, and not by Cloud Deploy. See
	// https://google.aip.dev/128#annotations for more details such as format and
	// size limitations.
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Labels are attributes that can be set and used by both the
	// user and by Cloud Deploy. Labels must meet the following constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Whether or not the `Target` requires approval.
	RequireApproval bool `protobuf:"varint,13,opt,name=require_approval,json=requireApproval,proto3" json:"require_approval,omitempty"`
	// Output only. Time at which the `Target` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Most recent time at which the `Target` was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Destination to which the Skaffold configuration is applied during a
	// rollout.
	//
	// Types that are assignable to DeploymentTarget:
	//
	//	*Target_Gke
	//	*Target_AnthosCluster
	//	*Target_Run
	//	*Target_MultiTarget
	//	*Target_CustomTarget
	DeploymentTarget isTarget_DeploymentTarget `protobuf_oneof:"deployment_target"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
	// Configurations for all execution that relates to this `Target`.
	// Each `ExecutionEnvironmentUsage` value may only be used in a single
	// configuration; using the same value multiple times is an error.
	// When one or more configurations are specified, they must include the
	// `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
	// When no configurations are specified, execution will use the default
	// specified in `DefaultPool`.
	ExecutionConfigs []*ExecutionConfig `protobuf:"bytes,16,rep,name=execution_configs,json=executionConfigs,proto3" json:"execution_configs,omitempty"`
	// Optional. The deploy parameters to use for this target.
	DeployParameters map[string]string `protobuf:"bytes,20,rep,name=deploy_parameters,json=deployParameters,proto3" json:"deploy_parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{27}
}

func (x *Target) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Target) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Target) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Target) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Target) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Target) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Target) GetRequireApproval() bool {
	if x != nil {
		return x.RequireApproval
	}
	return false
}

func (x *Target) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Target) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *Target) GetDeploymentTarget() isTarget_DeploymentTarget {
	if m != nil {
		return m.DeploymentTarget
	}
	return nil
}

func (x *Target) GetGke() *GkeCluster {
	if x, ok := x.GetDeploymentTarget().(*Target_Gke); ok {
		return x.Gke
	}
	return nil
}

func (x *Target) GetAnthosCluster() *AnthosCluster {
	if x, ok := x.GetDeploymentTarget().(*Target_AnthosCluster); ok {
		return x.AnthosCluster
	}
	return nil
}

func (x *Target) GetRun() *CloudRunLocation {
	if x, ok := x.GetDeploymentTarget().(*Target_Run); ok {
		return x.Run
	}
	return nil
}

func (x *Target) GetMultiTarget() *MultiTarget {
	if x, ok := x.GetDeploymentTarget().(*Target_MultiTarget); ok {
		return x.MultiTarget
	}
	return nil
}

func (x *Target) GetCustomTarget() *CustomTarget {
	if x, ok := x.GetDeploymentTarget().(*Target_CustomTarget); ok {
		return x.CustomTarget
	}
	return nil
}

func (x *Target) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Target) GetExecutionConfigs() []*ExecutionConfig {
	if x != nil {
		return x.ExecutionConfigs
	}
	return nil
}

func (x *Target) GetDeployParameters() map[string]string {
	if x != nil {
		return x.DeployParameters
	}
	return nil
}

type isTarget_DeploymentTarget interface {
	isTarget_DeploymentTarget()
}

type Target_Gke struct {
	// Optional. Information specifying a GKE Cluster.
	Gke *GkeCluster `protobuf:"bytes,15,opt,name=gke,proto3,oneof"`
}

type Target_AnthosCluster struct {
	// Optional. Information specifying an Anthos Cluster.
	AnthosCluster *AnthosCluster `protobuf:"bytes,17,opt,name=anthos_cluster,json=anthosCluster,proto3,oneof"`
}

type Target_Run struct {
	// Optional. Information specifying a Cloud Run deployment target.
	Run *CloudRunLocation `protobuf:"bytes,18,opt,name=run,proto3,oneof"`
}

type Target_MultiTarget struct {
	// Optional. Information specifying a multiTarget.
	MultiTarget *MultiTarget `protobuf:"bytes,19,opt,name=multi_target,json=multiTarget,proto3,oneof"`
}

type Target_CustomTarget struct {
	// Optional. Information specifying a Custom Target.
	CustomTarget *CustomTarget `protobuf:"bytes,21,opt,name=custom_target,json=customTarget,proto3,oneof"`
}

func (*Target_Gke) isTarget_DeploymentTarget() {}

func (*Target_AnthosCluster) isTarget_DeploymentTarget() {}

func (*Target_Run) isTarget_DeploymentTarget() {}

func (*Target_MultiTarget) isTarget_DeploymentTarget() {}

func (*Target_CustomTarget) isTarget_DeploymentTarget() {}

// Configuration of the environment to use when calling Skaffold.
type ExecutionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Usages when this configuration should be applied.
	Usages []ExecutionConfig_ExecutionEnvironmentUsage `protobuf:"varint,1,rep,packed,name=usages,proto3,enum=google.cloud.deploy.v1.ExecutionConfig_ExecutionEnvironmentUsage" json:"usages,omitempty"`
	// Details of the environment.
	//
	// Types that are assignable to ExecutionEnvironment:
	//
	//	*ExecutionConfig_DefaultPool
	//	*ExecutionConfig_PrivatePool
	ExecutionEnvironment isExecutionConfig_ExecutionEnvironment `protobuf_oneof:"execution_environment"`
	// Optional. The resource name of the `WorkerPool`, with the format
	// `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
	// If this optional field is unspecified, the default Cloud Build pool will be
	// used.
	WorkerPool string `protobuf:"bytes,4,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Optional. Google service account to use for execution. If unspecified,
	// the project execution service account
	// (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) is used.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Cloud Storage location in which to store execution outputs. This
	// can either be a bucket ("gs://my-bucket") or a path within a bucket
	// ("gs://my-bucket/my-dir").
	// If unspecified, a default bucket located in the same region will be used.
	ArtifactStorage string `protobuf:"bytes,6,opt,name=artifact_storage,json=artifactStorage,proto3" json:"artifact_storage,omitempty"`
	// Optional. Execution timeout for a Cloud Build Execution. This must be
	// between 10m and 24h in seconds format. If unspecified, a default timeout of
	// 1h is used.
	ExecutionTimeout *durationpb.Duration `protobuf:"bytes,7,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
}

func (x *ExecutionConfig) Reset() {
	*x = ExecutionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionConfig) ProtoMessage() {}

func (x *ExecutionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionConfig.ProtoReflect.Descriptor instead.
func (*ExecutionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{28}
}

func (x *ExecutionConfig) GetUsages() []ExecutionConfig_ExecutionEnvironmentUsage {
	if x != nil {
		return x.Usages
	}
	return nil
}

func (m *ExecutionConfig) GetExecutionEnvironment() isExecutionConfig_ExecutionEnvironment {
	if m != nil {
		return m.ExecutionEnvironment
	}
	return nil
}

func (x *ExecutionConfig) GetDefaultPool() *DefaultPool {
	if x, ok := x.GetExecutionEnvironment().(*ExecutionConfig_DefaultPool); ok {
		return x.DefaultPool
	}
	return nil
}

func (x *ExecutionConfig) GetPrivatePool() *PrivatePool {
	if x, ok := x.GetExecutionEnvironment().(*ExecutionConfig_PrivatePool); ok {
		return x.PrivatePool
	}
	return nil
}

func (x *ExecutionConfig) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *ExecutionConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *ExecutionConfig) GetArtifactStorage() string {
	if x != nil {
		return x.ArtifactStorage
	}
	return ""
}

func (x *ExecutionConfig) GetExecutionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ExecutionTimeout
	}
	return nil
}

type isExecutionConfig_ExecutionEnvironment interface {
	isExecutionConfig_ExecutionEnvironment()
}

type ExecutionConfig_DefaultPool struct {
	// Optional. Use default Cloud Build pool.
	DefaultPool *DefaultPool `protobuf:"bytes,2,opt,name=default_pool,json=defaultPool,proto3,oneof"`
}

type ExecutionConfig_PrivatePool struct {
	// Optional. Use private Cloud Build pool.
	PrivatePool *PrivatePool `protobuf:"bytes,3,opt,name=private_pool,json=privatePool,proto3,oneof"`
}

func (*ExecutionConfig_DefaultPool) isExecutionConfig_ExecutionEnvironment() {}

func (*ExecutionConfig_PrivatePool) isExecutionConfig_ExecutionEnvironment() {}

// Execution using the default Cloud Build pool.
type DefaultPool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Google service account to use for execution. If unspecified,
	// the project execution service account
	// (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) will be used.
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Cloud Storage location where execution outputs should be stored.
	// This can either be a bucket ("gs://my-bucket") or a path within a bucket
	// ("gs://my-bucket/my-dir").
	// If unspecified, a default bucket located in the same region will be used.
	ArtifactStorage string `protobuf:"bytes,2,opt,name=artifact_storage,json=artifactStorage,proto3" json:"artifact_storage,omitempty"`
}

func (x *DefaultPool) Reset() {
	*x = DefaultPool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultPool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultPool) ProtoMessage() {}

func (x *DefaultPool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultPool.ProtoReflect.Descriptor instead.
func (*DefaultPool) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{29}
}

func (x *DefaultPool) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *DefaultPool) GetArtifactStorage() string {
	if x != nil {
		return x.ArtifactStorage
	}
	return ""
}

// Execution using a private Cloud Build pool.
type PrivatePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the Cloud Build worker pool to use. The format
	// is `projects/{project}/locations/{location}/workerPools/{pool}`.
	WorkerPool string `protobuf:"bytes,1,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Optional. Google service account to use for execution. If unspecified,
	// the project execution service account
	// (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) will be used.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Cloud Storage location where execution outputs should be stored.
	// This can either be a bucket ("gs://my-bucket") or a path within a bucket
	// ("gs://my-bucket/my-dir").
	// If unspecified, a default bucket located in the same region will be used.
	ArtifactStorage string `protobuf:"bytes,3,opt,name=artifact_storage,json=artifactStorage,proto3" json:"artifact_storage,omitempty"`
}

func (x *PrivatePool) Reset() {
	*x = PrivatePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivatePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivatePool) ProtoMessage() {}

func (x *PrivatePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivatePool.ProtoReflect.Descriptor instead.
func (*PrivatePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{30}
}

func (x *PrivatePool) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *PrivatePool) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *PrivatePool) GetArtifactStorage() string {
	if x != nil {
		return x.ArtifactStorage
	}
	return ""
}

// Information specifying a GKE Cluster.
type GkeCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information specifying a GKE Cluster. Format is
	// `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. If true, `cluster` is accessed using the private IP address of
	// the control plane endpoint. Otherwise, the default IP address of the
	// control plane endpoint is used. The default IP address is the private IP
	// address for clusters with private control-plane endpoints and the public IP
	// address otherwise.
	//
	// Only specify this option when `cluster` is a [private GKE
	// cluster](https://cloud.google.com/kubernetes-engine/docs/concepts/private-cluster-concept).
	InternalIp bool `protobuf:"varint,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
}

func (x *GkeCluster) Reset() {
	*x = GkeCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeCluster) ProtoMessage() {}

func (x *GkeCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeCluster.ProtoReflect.Descriptor instead.
func (*GkeCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{31}
}

func (x *GkeCluster) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *GkeCluster) GetInternalIp() bool {
	if x != nil {
		return x.InternalIp
	}
	return false
}

// Information specifying an Anthos Cluster.
type AnthosCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Membership of the GKE Hub-registered cluster to which to apply the Skaffold
	// configuration. Format is
	// `projects/{project}/locations/{location}/memberships/{membership_name}`.
	Membership string `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *AnthosCluster) Reset() {
	*x = AnthosCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnthosCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnthosCluster) ProtoMessage() {}

func (x *AnthosCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnthosCluster.ProtoReflect.Descriptor instead.
func (*AnthosCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{32}
}

func (x *AnthosCluster) GetMembership() string {
	if x != nil {
		return x.Membership
	}
	return ""
}

// Information specifying where to deploy a Cloud Run Service.
type CloudRunLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location for the Cloud Run Service. Format must be
	// `projects/{project}/locations/{location}`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *CloudRunLocation) Reset() {
	*x = CloudRunLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRunLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunLocation) ProtoMessage() {}

func (x *CloudRunLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunLocation.ProtoReflect.Descriptor instead.
func (*CloudRunLocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{33}
}

func (x *CloudRunLocation) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Information specifying a multiTarget.
type MultiTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The target_ids of this multiTarget.
	TargetIds []string `protobuf:"bytes,1,rep,name=target_ids,json=targetIds,proto3" json:"target_ids,omitempty"`
}

func (x *MultiTarget) Reset() {
	*x = MultiTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MultiTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiTarget) ProtoMessage() {}

func (x *MultiTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiTarget.ProtoReflect.Descriptor instead.
func (*MultiTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{34}
}

func (x *MultiTarget) GetTargetIds() []string {
	if x != nil {
		return x.TargetIds
	}
	return nil
}

// Information specifying a Custom Target.
type CustomTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomTargetType. Format must be
	// `projects/{project}/locations/{location}/customTargetTypes/{custom_target_type}`.
	CustomTargetType string `protobuf:"bytes,1,opt,name=custom_target_type,json=customTargetType,proto3" json:"custom_target_type,omitempty"`
}

func (x *CustomTarget) Reset() {
	*x = CustomTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomTarget) ProtoMessage() {}

func (x *CustomTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomTarget.ProtoReflect.Descriptor instead.
func (*CustomTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{35}
}

func (x *CustomTarget) GetCustomTargetType() string {
	if x != nil {
		return x.CustomTargetType
	}
	return ""
}

// The request object for `ListTargets`.
type ListTargetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of targets. Format must be
	// `projects/{project_id}/locations/{location_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Target` objects to return. The service may
	// return fewer than this value. If unspecified, at most 50 `Target` objects
	// will be returned. The maximum value is 1000; values above 1000 will be set
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListTargets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter targets to be returned. See https://google.aip.dev/160 for
	// more details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for
	// more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTargetsRequest) Reset() {
	*x = ListTargetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetsRequest) ProtoMessage() {}

func (x *ListTargetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetsRequest.ProtoReflect.Descriptor instead.
func (*ListTargetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{36}
}

func (x *ListTargetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTargetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTargetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTargetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTargetsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListTargets`.
type ListTargetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Target` objects.
	Targets []*Target `protobuf:"bytes,1,rep,name=targets,proto3" json:"targets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTargetsResponse) Reset() {
	*x = ListTargetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetsResponse) ProtoMessage() {}

func (x *ListTargetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetsResponse.ProtoReflect.Descriptor instead.
func (*ListTargetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{37}
}

func (x *ListTargetsResponse) GetTargets() []*Target {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *ListTargetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTargetsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetTarget`.
type GetTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `Target`. Format must be
	// `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTargetRequest) Reset() {
	*x = GetTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTargetRequest) ProtoMessage() {}

func (x *GetTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTargetRequest.ProtoReflect.Descriptor instead.
func (*GetTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{38}
}

func (x *GetTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object for `CreateTarget`.
type CreateTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `Target` should be created.
	// Format should be
	// `projects/{project_id}/locations/{location_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `Target`.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Required. The `Target` to create.
	Target *Target `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateTargetRequest) Reset() {
	*x = CreateTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTargetRequest) ProtoMessage() {}

func (x *CreateTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTargetRequest.ProtoReflect.Descriptor instead.
func (*CreateTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{39}
}

func (x *CreateTargetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTargetRequest) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *CreateTargetRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *CreateTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateTargetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `UpdateTarget`.
type UpdateTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Target resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it's in the mask. If the
	// user doesn't provide a mask then all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The `Target` to update.
	Target *Target `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, updating a `Target` that does not exist will
	// result in the creation of a new `Target`.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateTargetRequest) Reset() {
	*x = UpdateTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTargetRequest) ProtoMessage() {}

func (x *UpdateTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTargetRequest.ProtoReflect.Descriptor instead.
func (*UpdateTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{40}
}

func (x *UpdateTargetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTargetRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *UpdateTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateTargetRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateTargetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `DeleteTarget`.
type DeleteTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Target` to delete. Format should be
	// `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, then deleting an already deleted or non-existing
	// `Target` will succeed.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set, validate the request and preview the review, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteTargetRequest) Reset() {
	*x = DeleteTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTargetRequest) ProtoMessage() {}

func (x *DeleteTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTargetRequest.ProtoReflect.Descriptor instead.
func (*DeleteTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{41}
}

func (x *DeleteTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteTargetRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteTargetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteTargetRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A `CustomTargetType` resource in the Cloud Deploy API.
//
// A `CustomTargetType` defines a type of custom target that can be referenced
// in a `Target` in order to facilitate deploying to other systems besides the
// supported runtimes.
type CustomTargetType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `CustomTargetType`. Format is
	// `projects/{project}/locations/{location}/customTargetTypes/[a-z][a-z0-9\-]{0,62}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Resource id of the `CustomTargetType`.
	CustomTargetTypeId string `protobuf:"bytes,2,opt,name=custom_target_type_id,json=customTargetTypeId,proto3" json:"custom_target_type_id,omitempty"`
	// Output only. Unique identifier of the `CustomTargetType`.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Description of the `CustomTargetType`. Max length is 255
	// characters.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User annotations. These attributes can only be set and used by
	// the user, and not by Cloud Deploy. See
	// https://google.aip.dev/128#annotations for more details such as format and
	// size limitations.
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Labels are attributes that can be set and used by both the
	// user and by Cloud Deploy. Labels must meet the following constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time at which the `CustomTargetType` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Most recent time at which the `CustomTargetType` was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Defines the `CustomTargetType` renderer and deployer.
	//
	// Types that are assignable to Definition:
	//
	//	*CustomTargetType_CustomActions
	Definition isCustomTargetType_Definition `protobuf_oneof:"definition"`
}

func (x *CustomTargetType) Reset() {
	*x = CustomTargetType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomTargetType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomTargetType) ProtoMessage() {}

func (x *CustomTargetType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomTargetType.ProtoReflect.Descriptor instead.
func (*CustomTargetType) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{42}
}

func (x *CustomTargetType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomTargetType) GetCustomTargetTypeId() string {
	if x != nil {
		return x.CustomTargetTypeId
	}
	return ""
}

func (x *CustomTargetType) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *CustomTargetType) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CustomTargetType) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *CustomTargetType) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CustomTargetType) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CustomTargetType) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CustomTargetType) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (m *CustomTargetType) GetDefinition() isCustomTargetType_Definition {
	if m != nil {
		return m.Definition
	}
	return nil
}

func (x *CustomTargetType) GetCustomActions() *CustomTargetSkaffoldActions {
	if x, ok := x.GetDefinition().(*CustomTargetType_CustomActions); ok {
		return x.CustomActions
	}
	return nil
}

type isCustomTargetType_Definition interface {
	isCustomTargetType_Definition()
}

type CustomTargetType_CustomActions struct {
	// Configures render and deploy for the `CustomTargetType` using Skaffold
	// custom actions.
	CustomActions *CustomTargetSkaffoldActions `protobuf:"bytes,10,opt,name=custom_actions,json=customActions,proto3,oneof"`
}

func (*CustomTargetType_CustomActions) isCustomTargetType_Definition() {}

// CustomTargetSkaffoldActions represents the `CustomTargetType` configuration
// using Skaffold custom actions.
type CustomTargetSkaffoldActions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Skaffold custom action responsible for render operations. If
	// not provided then Cloud Deploy will perform the render operations via
	// `skaffold render`.
	RenderAction string `protobuf:"bytes,1,opt,name=render_action,json=renderAction,proto3" json:"render_action,omitempty"`
	// Required. The Skaffold custom action responsible for deploy operations.
	DeployAction string `protobuf:"bytes,2,opt,name=deploy_action,json=deployAction,proto3" json:"deploy_action,omitempty"`
	// Optional. List of Skaffold modules Cloud Deploy will include in the
	// Skaffold Config as required before performing diagnose.
	IncludeSkaffoldModules []*SkaffoldModules `protobuf:"bytes,3,rep,name=include_skaffold_modules,json=includeSkaffoldModules,proto3" json:"include_skaffold_modules,omitempty"`
}

func (x *CustomTargetSkaffoldActions) Reset() {
	*x = CustomTargetSkaffoldActions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomTargetSkaffoldActions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomTargetSkaffoldActions) ProtoMessage() {}

func (x *CustomTargetSkaffoldActions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomTargetSkaffoldActions.ProtoReflect.Descriptor instead.
func (*CustomTargetSkaffoldActions) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{43}
}

func (x *CustomTargetSkaffoldActions) GetRenderAction() string {
	if x != nil {
		return x.RenderAction
	}
	return ""
}

func (x *CustomTargetSkaffoldActions) GetDeployAction() string {
	if x != nil {
		return x.DeployAction
	}
	return ""
}

func (x *CustomTargetSkaffoldActions) GetIncludeSkaffoldModules() []*SkaffoldModules {
	if x != nil {
		return x.IncludeSkaffoldModules
	}
	return nil
}

// Skaffold Config modules and their remote source.
type SkaffoldModules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Skaffold Config modules to use from the specified source.
	Configs []string `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty"`
	// The source that contains the Skaffold Config modules.
	//
	// Types that are assignable to Source:
	//
	//	*SkaffoldModules_Git
	//	*SkaffoldModules_GoogleCloudStorage
	Source isSkaffoldModules_Source `protobuf_oneof:"source"`
}

func (x *SkaffoldModules) Reset() {
	*x = SkaffoldModules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkaffoldModules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkaffoldModules) ProtoMessage() {}

func (x *SkaffoldModules) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkaffoldModules.ProtoReflect.Descriptor instead.
func (*SkaffoldModules) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{44}
}

func (x *SkaffoldModules) GetConfigs() []string {
	if x != nil {
		return x.Configs
	}
	return nil
}

func (m *SkaffoldModules) GetSource() isSkaffoldModules_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *SkaffoldModules) GetGit() *SkaffoldModules_SkaffoldGitSource {
	if x, ok := x.GetSource().(*SkaffoldModules_Git); ok {
		return x.Git
	}
	return nil
}

func (x *SkaffoldModules) GetGoogleCloudStorage() *SkaffoldModules_SkaffoldGCSSource {
	if x, ok := x.GetSource().(*SkaffoldModules_GoogleCloudStorage); ok {
		return x.GoogleCloudStorage
	}
	return nil
}

type isSkaffoldModules_Source interface {
	isSkaffoldModules_Source()
}

type SkaffoldModules_Git struct {
	// Remote git repository containing the Skaffold Config modules.
	Git *SkaffoldModules_SkaffoldGitSource `protobuf:"bytes,2,opt,name=git,proto3,oneof"`
}

type SkaffoldModules_GoogleCloudStorage struct {
	// Cloud Storage bucket containing the Skaffold Config modules.
	GoogleCloudStorage *SkaffoldModules_SkaffoldGCSSource `protobuf:"bytes,3,opt,name=google_cloud_storage,json=googleCloudStorage,proto3,oneof"`
}

func (*SkaffoldModules_Git) isSkaffoldModules_Source() {}

func (*SkaffoldModules_GoogleCloudStorage) isSkaffoldModules_Source() {}

// The request object for `ListCustomTargetTypes`.
type ListCustomTargetTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent that owns this collection of custom target types.
	// Format must be `projects/{project_id}/locations/{location_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `CustomTargetType` objects to return. The
	// service may return fewer than this value. If unspecified, at most 50
	// `CustomTargetType` objects will be returned. The maximum value is 1000;
	// values above 1000 will be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListCustomTargetTypes`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter custom target types to be returned. See
	// https://google.aip.dev/160 for more details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for
	// more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCustomTargetTypesRequest) Reset() {
	*x = ListCustomTargetTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomTargetTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomTargetTypesRequest) ProtoMessage() {}

func (x *ListCustomTargetTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomTargetTypesRequest.ProtoReflect.Descriptor instead.
func (*ListCustomTargetTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{45}
}

func (x *ListCustomTargetTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomTargetTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomTargetTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCustomTargetTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCustomTargetTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListCustomTargetTypes.`
type ListCustomTargetTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `CustomTargetType` objects.
	CustomTargetTypes []*CustomTargetType `protobuf:"bytes,1,rep,name=custom_target_types,json=customTargetTypes,proto3" json:"custom_target_types,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCustomTargetTypesResponse) Reset() {
	*x = ListCustomTargetTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomTargetTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomTargetTypesResponse) ProtoMessage() {}

func (x *ListCustomTargetTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomTargetTypesResponse.ProtoReflect.Descriptor instead.
func (*ListCustomTargetTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{46}
}

func (x *ListCustomTargetTypesResponse) GetCustomTargetTypes() []*CustomTargetType {
	if x != nil {
		return x.CustomTargetTypes
	}
	return nil
}

func (x *ListCustomTargetTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCustomTargetTypesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetCustomTargetType`.
type GetCustomTargetTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `CustomTargetType`. Format must be
	// `projects/{project_id}/locations/{location_name}/customTargetTypes/{custom_target_type}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomTargetTypeRequest) Reset() {
	*x = GetCustomTargetTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomTargetTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomTargetTypeRequest) ProtoMessage() {}

func (x *GetCustomTargetTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomTargetTypeRequest.ProtoReflect.Descriptor instead.
func (*GetCustomTargetTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{47}
}

func (x *GetCustomTargetTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object for `CreateCustomTargetType`.
type CreateCustomTargetTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `CustomTargetType` should be
	// created. Format should be
	// `projects/{project_id}/locations/{location_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `CustomTargetType`.
	CustomTargetTypeId string `protobuf:"bytes,2,opt,name=custom_target_type_id,json=customTargetTypeId,proto3" json:"custom_target_type_id,omitempty"`
	// Required. The `CustomTargetType` to create.
	CustomTargetType *CustomTargetType `protobuf:"bytes,3,opt,name=custom_target_type,json=customTargetType,proto3" json:"custom_target_type,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateCustomTargetTypeRequest) Reset() {
	*x = CreateCustomTargetTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomTargetTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomTargetTypeRequest) ProtoMessage() {}

func (x *CreateCustomTargetTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomTargetTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomTargetTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{48}
}

func (x *CreateCustomTargetTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomTargetTypeRequest) GetCustomTargetTypeId() string {
	if x != nil {
		return x.CustomTargetTypeId
	}
	return ""
}

func (x *CreateCustomTargetTypeRequest) GetCustomTargetType() *CustomTargetType {
	if x != nil {
		return x.CustomTargetType
	}
	return nil
}

func (x *CreateCustomTargetTypeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateCustomTargetTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `UpdateCustomTargetType`.
type UpdateCustomTargetTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `CustomTargetType` resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it's in the mask. If the
	// user doesn't provide a mask then all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The `CustomTargetType` to update.
	CustomTargetType *CustomTargetType `protobuf:"bytes,2,opt,name=custom_target_type,json=customTargetType,proto3" json:"custom_target_type,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, updating a `CustomTargetType` that does not exist
	// will result in the creation of a new `CustomTargetType`.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateCustomTargetTypeRequest) Reset() {
	*x = UpdateCustomTargetTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomTargetTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomTargetTypeRequest) ProtoMessage() {}

func (x *UpdateCustomTargetTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomTargetTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomTargetTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{49}
}

func (x *UpdateCustomTargetTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateCustomTargetTypeRequest) GetCustomTargetType() *CustomTargetType {
	if x != nil {
		return x.CustomTargetType
	}
	return nil
}

func (x *UpdateCustomTargetTypeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateCustomTargetTypeRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateCustomTargetTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `DeleteCustomTargetType`.
type DeleteCustomTargetTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `CustomTargetType` to delete. Format must be
	// `projects/{project_id}/locations/{location_name}/customTargetTypes/{custom_target_type}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, then deleting an already deleted or non-existing
	// `CustomTargetType` will succeed.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the request is validated but no actual change is
	// made.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteCustomTargetTypeRequest) Reset() {
	*x = DeleteCustomTargetTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCustomTargetTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCustomTargetTypeRequest) ProtoMessage() {}

func (x *DeleteCustomTargetTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCustomTargetTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteCustomTargetTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{50}
}

func (x *DeleteCustomTargetTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteCustomTargetTypeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteCustomTargetTypeRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteCustomTargetTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteCustomTargetTypeRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Contains criteria for selecting Targets.
type TargetAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the `Target`. The value of this field could be one of the
	// following:
	// * The last segment of a target name. It only needs the ID to determine
	// which target is being referred to
	// * "*", all targets in a location.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Target labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TargetAttribute) Reset() {
	*x = TargetAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetAttribute) ProtoMessage() {}

func (x *TargetAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetAttribute.ProtoReflect.Descriptor instead.
func (*TargetAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{51}
}

func (x *TargetAttribute) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *TargetAttribute) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A `Release` resource in the Cloud Deploy API.
//
// A `Release` defines a specific Skaffold configuration instance
// that can be deployed.
type Release struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `Release`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9\-]{0,62}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `Release`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Description of the `Release`. Max length is 255 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// User annotations. These attributes can only be set and used by the
	// user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
	// for more details such as format and size limitations.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Labels are attributes that can be set and used by both the
	// user and by Cloud Deploy. Labels must meet the following constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Indicates whether this is an abandoned release.
	Abandoned bool `protobuf:"varint,23,opt,name=abandoned,proto3" json:"abandoned,omitempty"`
	// Output only. Time at which the `Release` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the render began.
	RenderStartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=render_start_time,json=renderStartTime,proto3" json:"render_start_time,omitempty"`
	// Output only. Time at which the render completed.
	RenderEndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=render_end_time,json=renderEndTime,proto3" json:"render_end_time,omitempty"`
	// Cloud Storage URI of tar.gz archive containing Skaffold configuration.
	SkaffoldConfigUri string `protobuf:"bytes,17,opt,name=skaffold_config_uri,json=skaffoldConfigUri,proto3" json:"skaffold_config_uri,omitempty"`
	// Filepath of the Skaffold config inside of the config URI.
	SkaffoldConfigPath string `protobuf:"bytes,9,opt,name=skaffold_config_path,json=skaffoldConfigPath,proto3" json:"skaffold_config_path,omitempty"`
	// List of artifacts to pass through to Skaffold command.
	BuildArtifacts []*BuildArtifact `protobuf:"bytes,10,rep,name=build_artifacts,json=buildArtifacts,proto3" json:"build_artifacts,omitempty"`
	// Output only. Snapshot of the parent pipeline taken at release creation
	// time.
	DeliveryPipelineSnapshot *DeliveryPipeline `protobuf:"bytes,11,opt,name=delivery_pipeline_snapshot,json=deliveryPipelineSnapshot,proto3" json:"delivery_pipeline_snapshot,omitempty"`
	// Output only. Snapshot of the targets taken at release creation time.
	TargetSnapshots []*Target `protobuf:"bytes,12,rep,name=target_snapshots,json=targetSnapshots,proto3" json:"target_snapshots,omitempty"`
	// Output only. Snapshot of the custom target types referenced by the targets
	// taken at release creation time.
	CustomTargetTypeSnapshots []*CustomTargetType `protobuf:"bytes,27,rep,name=custom_target_type_snapshots,json=customTargetTypeSnapshots,proto3" json:"custom_target_type_snapshots,omitempty"`
	// Output only. Current state of the render operation.
	RenderState Release_RenderState `protobuf:"varint,13,opt,name=render_state,json=renderState,proto3,enum=google.cloud.deploy.v1.Release_RenderState" json:"render_state,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,16,opt,name=etag,proto3" json:"etag,omitempty"`
	// The Skaffold version to use when operating on this release, such as
	// "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
	// of versions.
	//
	// If unset, the most recent supported Skaffold version will be used.
	SkaffoldVersion string `protobuf:"bytes,19,opt,name=skaffold_version,json=skaffoldVersion,proto3" json:"skaffold_version,omitempty"`
	// Output only. Map from target ID to the target artifacts created
	// during the render operation.
	TargetArtifacts map[string]*TargetArtifact `protobuf:"bytes,20,rep,name=target_artifacts,json=targetArtifacts,proto3" json:"target_artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Map from target ID to details of the render operation for that
	// target.
	TargetRenders map[string]*Release_TargetRender `protobuf:"bytes,22,rep,name=target_renders,json=targetRenders,proto3" json:"target_renders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Information around the state of the Release.
	Condition *Release_ReleaseCondition `protobuf:"bytes,24,opt,name=condition,proto3" json:"condition,omitempty"`
	// Optional. The deploy parameters to use for all targets in this release.
	DeployParameters map[string]string `protobuf:"bytes,25,rep,name=deploy_parameters,json=deployParameters,proto3" json:"deploy_parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Release) Reset() {
	*x = Release{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Release) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Release) ProtoMessage() {}

func (x *Release) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Release.ProtoReflect.Descriptor instead.
func (*Release) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52}
}

func (x *Release) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Release) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Release) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Release) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Release) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Release) GetAbandoned() bool {
	if x != nil {
		return x.Abandoned
	}
	return false
}

func (x *Release) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Release) GetRenderStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RenderStartTime
	}
	return nil
}

func (x *Release) GetRenderEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RenderEndTime
	}
	return nil
}

func (x *Release) GetSkaffoldConfigUri() string {
	if x != nil {
		return x.SkaffoldConfigUri
	}
	return ""
}

func (x *Release) GetSkaffoldConfigPath() string {
	if x != nil {
		return x.SkaffoldConfigPath
	}
	return ""
}

func (x *Release) GetBuildArtifacts() []*BuildArtifact {
	if x != nil {
		return x.BuildArtifacts
	}
	return nil
}

func (x *Release) GetDeliveryPipelineSnapshot() *DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipelineSnapshot
	}
	return nil
}

func (x *Release) GetTargetSnapshots() []*Target {
	if x != nil {
		return x.TargetSnapshots
	}
	return nil
}

func (x *Release) GetCustomTargetTypeSnapshots() []*CustomTargetType {
	if x != nil {
		return x.CustomTargetTypeSnapshots
	}
	return nil
}

func (x *Release) GetRenderState() Release_RenderState {
	if x != nil {
		return x.RenderState
	}
	return Release_RENDER_STATE_UNSPECIFIED
}

func (x *Release) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Release) GetSkaffoldVersion() string {
	if x != nil {
		return x.SkaffoldVersion
	}
	return ""
}

func (x *Release) GetTargetArtifacts() map[string]*TargetArtifact {
	if x != nil {
		return x.TargetArtifacts
	}
	return nil
}

func (x *Release) GetTargetRenders() map[string]*Release_TargetRender {
	if x != nil {
		return x.TargetRenders
	}
	return nil
}

func (x *Release) GetCondition() *Release_ReleaseCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *Release) GetDeployParameters() map[string]string {
	if x != nil {
		return x.DeployParameters
	}
	return nil
}

// Description of an a image to use during Skaffold rendering.
type BuildArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Image name in Skaffold configuration.
	Image string `protobuf:"bytes,3,opt,name=image,proto3" json:"image,omitempty"`
	// Image tag to use. This will generally be the full path to an image, such
	// as "gcr.io/my-project/busybox:1.2.3" or
	// "gcr.io/my-project/busybox@sha256:abc123".
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *BuildArtifact) Reset() {
	*x = BuildArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildArtifact) ProtoMessage() {}

func (x *BuildArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildArtifact.ProtoReflect.Descriptor instead.
func (*BuildArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{53}
}

func (x *BuildArtifact) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *BuildArtifact) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// The artifacts produced by a target render operation.
type TargetArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Uri:
	//
	//	*TargetArtifact_ArtifactUri
	Uri isTargetArtifact_Uri `protobuf_oneof:"uri"`
	// Output only. File path of the resolved Skaffold configuration relative to
	// the URI.
	SkaffoldConfigPath string `protobuf:"bytes,2,opt,name=skaffold_config_path,json=skaffoldConfigPath,proto3" json:"skaffold_config_path,omitempty"`
	// Output only. File path of the rendered manifest relative to the URI.
	ManifestPath string `protobuf:"bytes,3,opt,name=manifest_path,json=manifestPath,proto3" json:"manifest_path,omitempty"`
	// Output only. Map from the phase ID to the phase artifacts for the `Target`.
	PhaseArtifacts map[string]*TargetArtifact_PhaseArtifact `protobuf:"bytes,5,rep,name=phase_artifacts,json=phaseArtifacts,proto3" json:"phase_artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TargetArtifact) Reset() {
	*x = TargetArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetArtifact) ProtoMessage() {}

func (x *TargetArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetArtifact.ProtoReflect.Descriptor instead.
func (*TargetArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{54}
}

func (m *TargetArtifact) GetUri() isTargetArtifact_Uri {
	if m != nil {
		return m.Uri
	}
	return nil
}

func (x *TargetArtifact) GetArtifactUri() string {
	if x, ok := x.GetUri().(*TargetArtifact_ArtifactUri); ok {
		return x.ArtifactUri
	}
	return ""
}

func (x *TargetArtifact) GetSkaffoldConfigPath() string {
	if x != nil {
		return x.SkaffoldConfigPath
	}
	return ""
}

func (x *TargetArtifact) GetManifestPath() string {
	if x != nil {
		return x.ManifestPath
	}
	return ""
}

func (x *TargetArtifact) GetPhaseArtifacts() map[string]*TargetArtifact_PhaseArtifact {
	if x != nil {
		return x.PhaseArtifacts
	}
	return nil
}

type isTargetArtifact_Uri interface {
	isTargetArtifact_Uri()
}

type TargetArtifact_ArtifactUri struct {
	// Output only. URI of a directory containing the artifacts. This contains
	// deployment configuration used by Skaffold during a rollout, and all
	// paths are relative to this location.
	ArtifactUri string `protobuf:"bytes,4,opt,name=artifact_uri,json=artifactUri,proto3,oneof"`
}

func (*TargetArtifact_ArtifactUri) isTargetArtifact_Uri() {}

// The artifacts produced by a deploy operation.
type DeployArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. URI of a directory containing the artifacts. All paths are
	// relative to this location.
	ArtifactUri string `protobuf:"bytes,1,opt,name=artifact_uri,json=artifactUri,proto3" json:"artifact_uri,omitempty"`
	// Output only. File paths of the manifests applied during the deploy
	// operation relative to the URI.
	ManifestPaths []string `protobuf:"bytes,2,rep,name=manifest_paths,json=manifestPaths,proto3" json:"manifest_paths,omitempty"`
}

func (x *DeployArtifact) Reset() {
	*x = DeployArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployArtifact) ProtoMessage() {}

func (x *DeployArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployArtifact.ProtoReflect.Descriptor instead.
func (*DeployArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{55}
}

func (x *DeployArtifact) GetArtifactUri() string {
	if x != nil {
		return x.ArtifactUri
	}
	return ""
}

func (x *DeployArtifact) GetManifestPaths() []string {
	if x != nil {
		return x.ManifestPaths
	}
	return nil
}

// CloudRunRenderMetadata contains Cloud Run information associated with a
// `Release` render.
type CloudRunRenderMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Cloud Run Service in the rendered manifest.
	// Format is `projects/{project}/locations/{location}/services/{service}`.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *CloudRunRenderMetadata) Reset() {
	*x = CloudRunRenderMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRunRenderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunRenderMetadata) ProtoMessage() {}

func (x *CloudRunRenderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunRenderMetadata.ProtoReflect.Descriptor instead.
func (*CloudRunRenderMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{56}
}

func (x *CloudRunRenderMetadata) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// RenderMetadata includes information associated with a `Release` render.
type RenderMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Metadata associated with rendering for Cloud Run.
	CloudRun *CloudRunRenderMetadata `protobuf:"bytes,1,opt,name=cloud_run,json=cloudRun,proto3" json:"cloud_run,omitempty"`
	// Output only. Custom metadata provided by user-defined render operation.
	Custom *CustomMetadata `protobuf:"bytes,2,opt,name=custom,proto3" json:"custom,omitempty"`
}

func (x *RenderMetadata) Reset() {
	*x = RenderMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenderMetadata) ProtoMessage() {}

func (x *RenderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenderMetadata.ProtoReflect.Descriptor instead.
func (*RenderMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{57}
}

func (x *RenderMetadata) GetCloudRun() *CloudRunRenderMetadata {
	if x != nil {
		return x.CloudRun
	}
	return nil
}

func (x *RenderMetadata) GetCustom() *CustomMetadata {
	if x != nil {
		return x.Custom
	}
	return nil
}

// The request object for `ListReleases`.
type ListReleasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `DeliveryPipeline` which owns this collection of `Release`
	// objects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Release` objects to return. The service
	// may return fewer than this value. If unspecified, at most 50 `Release`
	// objects will be returned. The maximum value is 1000; values above 1000 will
	// be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListReleases` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter releases to be returned. See https://google.aip.dev/160
	// for more details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for
	// more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListReleasesRequest) Reset() {
	*x = ListReleasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleasesRequest) ProtoMessage() {}

func (x *ListReleasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleasesRequest.ProtoReflect.Descriptor instead.
func (*ListReleasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{58}
}

func (x *ListReleasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReleasesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReleasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReleasesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReleasesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListReleases`.
type ListReleasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Release` objects.
	Releases []*Release `protobuf:"bytes,1,rep,name=releases,proto3" json:"releases,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReleasesResponse) Reset() {
	*x = ListReleasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleasesResponse) ProtoMessage() {}

func (x *ListReleasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleasesResponse.ProtoReflect.Descriptor instead.
func (*ListReleasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{59}
}

func (x *ListReleasesResponse) GetReleases() []*Release {
	if x != nil {
		return x.Releases
	}
	return nil
}

func (x *ListReleasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReleasesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetRelease`.
type GetReleaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `Release`. Format must be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReleaseRequest) Reset() {
	*x = GetReleaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReleaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReleaseRequest) ProtoMessage() {}

func (x *GetReleaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReleaseRequest.ProtoReflect.Descriptor instead.
func (*GetReleaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{60}
}

func (x *GetReleaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object for `CreateRelease`,
type CreateReleaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `Release` should be created.
	// Format should be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `Release`.
	ReleaseId string `protobuf:"bytes,2,opt,name=release_id,json=releaseId,proto3" json:"release_id,omitempty"`
	// Required. The `Release` to create.
	Release *Release `protobuf:"bytes,3,opt,name=release,proto3" json:"release,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateReleaseRequest) Reset() {
	*x = CreateReleaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReleaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReleaseRequest) ProtoMessage() {}

func (x *CreateReleaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReleaseRequest.ProtoReflect.Descriptor instead.
func (*CreateReleaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{61}
}

func (x *CreateReleaseRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReleaseRequest) GetReleaseId() string {
	if x != nil {
		return x.ReleaseId
	}
	return ""
}

func (x *CreateReleaseRequest) GetRelease() *Release {
	if x != nil {
		return x.Release
	}
	return nil
}

func (x *CreateReleaseRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateReleaseRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// A `Rollout` resource in the Cloud Deploy API.
//
// A `Rollout` contains information around a specific deployment to a `Target`.
type Rollout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `Rollout`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9\-]{0,62}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `Rollout`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Description of the `Rollout` for user purposes. Max length is 255
	// characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// User annotations. These attributes can only be set and used by the
	// user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
	// for more details such as format and size limitations.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Labels are attributes that can be set and used by both the
	// user and by Cloud Deploy. Labels must meet the following constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time at which the `Rollout` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the `Rollout` was approved.
	ApproveTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=approve_time,json=approveTime,proto3" json:"approve_time,omitempty"`
	// Output only. Time at which the `Rollout` was enqueued.
	EnqueueTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=enqueue_time,json=enqueueTime,proto3" json:"enqueue_time,omitempty"`
	// Output only. Time at which the `Rollout` started deploying.
	DeployStartTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=deploy_start_time,json=deployStartTime,proto3" json:"deploy_start_time,omitempty"`
	// Output only. Time at which the `Rollout` finished deploying.
	DeployEndTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=deploy_end_time,json=deployEndTime,proto3" json:"deploy_end_time,omitempty"`
	// Required. The ID of Target to which this `Rollout` is deploying.
	TargetId string `protobuf:"bytes,18,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Output only. Approval state of the `Rollout`.
	ApprovalState Rollout_ApprovalState `protobuf:"varint,12,opt,name=approval_state,json=approvalState,proto3,enum=google.cloud.deploy.v1.Rollout_ApprovalState" json:"approval_state,omitempty"`
	// Output only. Current state of the `Rollout`.
	State Rollout_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.deploy.v1.Rollout_State" json:"state,omitempty"`
	// Output only. Additional information about the rollout failure, if
	// available.
	FailureReason string `protobuf:"bytes,14,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	// Output only. The resource name of the Cloud Build `Build` object that is
	// used to deploy the Rollout. Format is
	// `projects/{project}/locations/{location}/builds/{build}`.
	DeployingBuild string `protobuf:"bytes,17,opt,name=deploying_build,json=deployingBuild,proto3" json:"deploying_build,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,16,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. The reason this rollout failed. This will always be
	// unspecified while the rollout is in progress.
	DeployFailureCause Rollout_FailureCause `protobuf:"varint,19,opt,name=deploy_failure_cause,json=deployFailureCause,proto3,enum=google.cloud.deploy.v1.Rollout_FailureCause" json:"deploy_failure_cause,omitempty"`
	// Output only. The phases that represent the workflows of this `Rollout`.
	Phases []*Phase `protobuf:"bytes,23,rep,name=phases,proto3" json:"phases,omitempty"`
	// Output only. Metadata contains information about the rollout.
	Metadata *Metadata `protobuf:"bytes,24,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. Name of the `ControllerRollout`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9\-]{0,62}`.
	ControllerRollout string `protobuf:"bytes,25,opt,name=controller_rollout,json=controllerRollout,proto3" json:"controller_rollout,omitempty"`
	// Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
	// Empty if this `Rollout` wasn't created as a rollback.
	RollbackOfRollout string `protobuf:"bytes,26,opt,name=rollback_of_rollout,json=rollbackOfRollout,proto3" json:"rollback_of_rollout,omitempty"`
	// Output only. Names of `Rollouts` that rolled back this `Rollout`.
	RolledBackByRollouts []string `protobuf:"bytes,27,rep,name=rolled_back_by_rollouts,json=rolledBackByRollouts,proto3" json:"rolled_back_by_rollouts,omitempty"`
}

func (x *Rollout) Reset() {
	*x = Rollout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rollout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rollout) ProtoMessage() {}

func (x *Rollout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rollout.ProtoReflect.Descriptor instead.
func (*Rollout) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{62}
}

func (x *Rollout) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Rollout) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Rollout) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Rollout) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Rollout) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Rollout) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Rollout) GetApproveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ApproveTime
	}
	return nil
}

func (x *Rollout) GetEnqueueTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EnqueueTime
	}
	return nil
}

func (x *Rollout) GetDeployStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeployStartTime
	}
	return nil
}

func (x *Rollout) GetDeployEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeployEndTime
	}
	return nil
}

func (x *Rollout) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Rollout) GetApprovalState() Rollout_ApprovalState {
	if x != nil {
		return x.ApprovalState
	}
	return Rollout_APPROVAL_STATE_UNSPECIFIED
}

func (x *Rollout) GetState() Rollout_State {
	if x != nil {
		return x.State
	}
	return Rollout_STATE_UNSPECIFIED
}

func (x *Rollout) GetFailureReason() string {
	if x != nil {
		return x.FailureReason
	}
	return ""
}

func (x *Rollout) GetDeployingBuild() string {
	if x != nil {
		return x.DeployingBuild
	}
	return ""
}

func (x *Rollout) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Rollout) GetDeployFailureCause() Rollout_FailureCause {
	if x != nil {
		return x.DeployFailureCause
	}
	return Rollout_FAILURE_CAUSE_UNSPECIFIED
}

func (x *Rollout) GetPhases() []*Phase {
	if x != nil {
		return x.Phases
	}
	return nil
}

func (x *Rollout) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Rollout) GetControllerRollout() string {
	if x != nil {
		return x.ControllerRollout
	}
	return ""
}

func (x *Rollout) GetRollbackOfRollout() string {
	if x != nil {
		return x.RollbackOfRollout
	}
	return ""
}

func (x *Rollout) GetRolledBackByRollouts() []string {
	if x != nil {
		return x.RolledBackByRollouts
	}
	return nil
}

// Metadata includes information associated with a `Rollout`.
type Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Cloud Run Service that is associated with a
	// `Rollout`.
	CloudRun *CloudRunMetadata `protobuf:"bytes,1,opt,name=cloud_run,json=cloudRun,proto3" json:"cloud_run,omitempty"`
	// Output only. AutomationRolloutMetadata contains the information about the
	// interactions between Automation service and this rollout.
	Automation *AutomationRolloutMetadata `protobuf:"bytes,2,opt,name=automation,proto3" json:"automation,omitempty"`
	// Output only. Custom metadata provided by user-defined `Rollout` operations.
	Custom *CustomMetadata `protobuf:"bytes,3,opt,name=custom,proto3" json:"custom,omitempty"`
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{63}
}

func (x *Metadata) GetCloudRun() *CloudRunMetadata {
	if x != nil {
		return x.CloudRun
	}
	return nil
}

func (x *Metadata) GetAutomation() *AutomationRolloutMetadata {
	if x != nil {
		return x.Automation
	}
	return nil
}

func (x *Metadata) GetCustom() *CustomMetadata {
	if x != nil {
		return x.Custom
	}
	return nil
}

// DeployJobRunMetadata surfaces information associated with a `DeployJobRun` to
// the user.
type DeployJobRunMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Cloud Run Service that is associated with a
	// `DeployJobRun`.
	CloudRun *CloudRunMetadata `protobuf:"bytes,1,opt,name=cloud_run,json=cloudRun,proto3" json:"cloud_run,omitempty"`
	// Output only. Custom Target metadata associated with a `DeployJobRun`.
	CustomTarget *CustomTargetDeployMetadata `protobuf:"bytes,2,opt,name=custom_target,json=customTarget,proto3" json:"custom_target,omitempty"`
	// Output only. Custom metadata provided by user-defined deploy operation.
	Custom *CustomMetadata `protobuf:"bytes,3,opt,name=custom,proto3" json:"custom,omitempty"`
}

func (x *DeployJobRunMetadata) Reset() {
	*x = DeployJobRunMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployJobRunMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployJobRunMetadata) ProtoMessage() {}

func (x *DeployJobRunMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployJobRunMetadata.ProtoReflect.Descriptor instead.
func (*DeployJobRunMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{64}
}

func (x *DeployJobRunMetadata) GetCloudRun() *CloudRunMetadata {
	if x != nil {
		return x.CloudRun
	}
	return nil
}

func (x *DeployJobRunMetadata) GetCustomTarget() *CustomTargetDeployMetadata {
	if x != nil {
		return x.CustomTarget
	}
	return nil
}

func (x *DeployJobRunMetadata) GetCustom() *CustomMetadata {
	if x != nil {
		return x.Custom
	}
	return nil
}

// CloudRunMetadata contains information from a Cloud Run deployment.
type CloudRunMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Cloud Run Service that is associated with a
	// `Rollout`. Format is
	// `projects/{project}/locations/{location}/services/{service}`.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Output only. The Cloud Run Service urls that are associated with a
	// `Rollout`.
	ServiceUrls []string `protobuf:"bytes,2,rep,name=service_urls,json=serviceUrls,proto3" json:"service_urls,omitempty"`
	// Output only. The Cloud Run Revision id associated with a `Rollout`.
	Revision string `protobuf:"bytes,3,opt,name=revision,proto3" json:"revision,omitempty"`
	// Output only. The name of the Cloud Run job that is associated with a
	// `Rollout`. Format is
	// `projects/{project}/locations/{location}/jobs/{job_name}`.
	Job string `protobuf:"bytes,4,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *CloudRunMetadata) Reset() {
	*x = CloudRunMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRunMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunMetadata) ProtoMessage() {}

func (x *CloudRunMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunMetadata.ProtoReflect.Descriptor instead.
func (*CloudRunMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{65}
}

func (x *CloudRunMetadata) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *CloudRunMetadata) GetServiceUrls() []string {
	if x != nil {
		return x.ServiceUrls
	}
	return nil
}

func (x *CloudRunMetadata) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *CloudRunMetadata) GetJob() string {
	if x != nil {
		return x.Job
	}
	return ""
}

// CustomTargetDeployMetadata contains information from a Custom Target
// deploy operation.
type CustomTargetDeployMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Skip message provided in the results of a custom deploy
	// operation.
	SkipMessage string `protobuf:"bytes,1,opt,name=skip_message,json=skipMessage,proto3" json:"skip_message,omitempty"`
}

func (x *CustomTargetDeployMetadata) Reset() {
	*x = CustomTargetDeployMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomTargetDeployMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomTargetDeployMetadata) ProtoMessage() {}

func (x *CustomTargetDeployMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomTargetDeployMetadata.ProtoReflect.Descriptor instead.
func (*CustomTargetDeployMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{66}
}

func (x *CustomTargetDeployMetadata) GetSkipMessage() string {
	if x != nil {
		return x.SkipMessage
	}
	return ""
}

// AutomationRolloutMetadata contains Automation-related actions that
// were performed on a rollout.
type AutomationRolloutMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the AutomationRun initiated by a promote release
	// rule.
	PromoteAutomationRun string `protobuf:"bytes,1,opt,name=promote_automation_run,json=promoteAutomationRun,proto3" json:"promote_automation_run,omitempty"`
	// Output only. The IDs of the AutomationRuns initiated by an advance rollout
	// rule.
	AdvanceAutomationRuns []string `protobuf:"bytes,2,rep,name=advance_automation_runs,json=advanceAutomationRuns,proto3" json:"advance_automation_runs,omitempty"`
	// Output only. The IDs of the AutomationRuns initiated by a repair rollout
	// rule.
	RepairAutomationRuns []string `protobuf:"bytes,3,rep,name=repair_automation_runs,json=repairAutomationRuns,proto3" json:"repair_automation_runs,omitempty"`
}

func (x *AutomationRolloutMetadata) Reset() {
	*x = AutomationRolloutMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomationRolloutMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomationRolloutMetadata) ProtoMessage() {}

func (x *AutomationRolloutMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomationRolloutMetadata.ProtoReflect.Descriptor instead.
func (*AutomationRolloutMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{67}
}

func (x *AutomationRolloutMetadata) GetPromoteAutomationRun() string {
	if x != nil {
		return x.PromoteAutomationRun
	}
	return ""
}

func (x *AutomationRolloutMetadata) GetAdvanceAutomationRuns() []string {
	if x != nil {
		return x.AdvanceAutomationRuns
	}
	return nil
}

func (x *AutomationRolloutMetadata) GetRepairAutomationRuns() []string {
	if x != nil {
		return x.RepairAutomationRuns
	}
	return nil
}

// CustomMetadata contains information from a user-defined operation.
type CustomMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Key-value pairs provided by the user-defined operation.
	Values map[string]string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CustomMetadata) Reset() {
	*x = CustomMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomMetadata) ProtoMessage() {}

func (x *CustomMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomMetadata.ProtoReflect.Descriptor instead.
func (*CustomMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{68}
}

func (x *CustomMetadata) GetValues() map[string]string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Phase represents a collection of jobs that are logically grouped together
// for a `Rollout`.
type Phase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the Phase.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. Current state of the Phase.
	State Phase_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.deploy.v1.Phase_State" json:"state,omitempty"`
	// Output only. Additional information on why the Phase was skipped, if
	// available.
	SkipMessage string `protobuf:"bytes,6,opt,name=skip_message,json=skipMessage,proto3" json:"skip_message,omitempty"`
	// The job composition of this Phase.
	//
	// Types that are assignable to Jobs:
	//
	//	*Phase_DeploymentJobs
	//	*Phase_ChildRolloutJobs
	Jobs isPhase_Jobs `protobuf_oneof:"jobs"`
}

func (x *Phase) Reset() {
	*x = Phase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Phase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Phase) ProtoMessage() {}

func (x *Phase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Phase.ProtoReflect.Descriptor instead.
func (*Phase) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{69}
}

func (x *Phase) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Phase) GetState() Phase_State {
	if x != nil {
		return x.State
	}
	return Phase_STATE_UNSPECIFIED
}

func (x *Phase) GetSkipMessage() string {
	if x != nil {
		return x.SkipMessage
	}
	return ""
}

func (m *Phase) GetJobs() isPhase_Jobs {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (x *Phase) GetDeploymentJobs() *DeploymentJobs {
	if x, ok := x.GetJobs().(*Phase_DeploymentJobs); ok {
		return x.DeploymentJobs
	}
	return nil
}

func (x *Phase) GetChildRolloutJobs() *ChildRolloutJobs {
	if x, ok := x.GetJobs().(*Phase_ChildRolloutJobs); ok {
		return x.ChildRolloutJobs
	}
	return nil
}

type isPhase_Jobs interface {
	isPhase_Jobs()
}

type Phase_DeploymentJobs struct {
	// Output only. Deployment job composition.
	DeploymentJobs *DeploymentJobs `protobuf:"bytes,4,opt,name=deployment_jobs,json=deploymentJobs,proto3,oneof"`
}

type Phase_ChildRolloutJobs struct {
	// Output only. ChildRollout job composition.
	ChildRolloutJobs *ChildRolloutJobs `protobuf:"bytes,5,opt,name=child_rollout_jobs,json=childRolloutJobs,proto3,oneof"`
}

func (*Phase_DeploymentJobs) isPhase_Jobs() {}

func (*Phase_ChildRolloutJobs) isPhase_Jobs() {}

// Deployment job composition.
type DeploymentJobs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The deploy Job. This is the deploy job in the phase.
	DeployJob *Job `protobuf:"bytes,1,opt,name=deploy_job,json=deployJob,proto3" json:"deploy_job,omitempty"`
	// Output only. The verify Job. Runs after a deploy if the deploy succeeds.
	VerifyJob *Job `protobuf:"bytes,2,opt,name=verify_job,json=verifyJob,proto3" json:"verify_job,omitempty"`
	// Output only. The predeploy Job, which is the first job on the phase.
	PredeployJob *Job `protobuf:"bytes,3,opt,name=predeploy_job,json=predeployJob,proto3" json:"predeploy_job,omitempty"`
	// Output only. The postdeploy Job, which is the last job on the phase.
	PostdeployJob *Job `protobuf:"bytes,4,opt,name=postdeploy_job,json=postdeployJob,proto3" json:"postdeploy_job,omitempty"`
}

func (x *DeploymentJobs) Reset() {
	*x = DeploymentJobs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeploymentJobs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentJobs) ProtoMessage() {}

func (x *DeploymentJobs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentJobs.ProtoReflect.Descriptor instead.
func (*DeploymentJobs) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{70}
}

func (x *DeploymentJobs) GetDeployJob() *Job {
	if x != nil {
		return x.DeployJob
	}
	return nil
}

func (x *DeploymentJobs) GetVerifyJob() *Job {
	if x != nil {
		return x.VerifyJob
	}
	return nil
}

func (x *DeploymentJobs) GetPredeployJob() *Job {
	if x != nil {
		return x.PredeployJob
	}
	return nil
}

func (x *DeploymentJobs) GetPostdeployJob() *Job {
	if x != nil {
		return x.PostdeployJob
	}
	return nil
}

// ChildRollouts job composition
type ChildRolloutJobs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of CreateChildRolloutJobs
	CreateRolloutJobs []*Job `protobuf:"bytes,1,rep,name=create_rollout_jobs,json=createRolloutJobs,proto3" json:"create_rollout_jobs,omitempty"`
	// Output only. List of AdvanceChildRolloutJobs
	AdvanceRolloutJobs []*Job `protobuf:"bytes,2,rep,name=advance_rollout_jobs,json=advanceRolloutJobs,proto3" json:"advance_rollout_jobs,omitempty"`
}

func (x *ChildRolloutJobs) Reset() {
	*x = ChildRolloutJobs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChildRolloutJobs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChildRolloutJobs) ProtoMessage() {}

func (x *ChildRolloutJobs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChildRolloutJobs.ProtoReflect.Descriptor instead.
func (*ChildRolloutJobs) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{71}
}

func (x *ChildRolloutJobs) GetCreateRolloutJobs() []*Job {
	if x != nil {
		return x.CreateRolloutJobs
	}
	return nil
}

func (x *ChildRolloutJobs) GetAdvanceRolloutJobs() []*Job {
	if x != nil {
		return x.AdvanceRolloutJobs
	}
	return nil
}

// Job represents an operation for a `Rollout`.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the Job.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The current state of the Job.
	State Job_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.deploy.v1.Job_State" json:"state,omitempty"`
	// Output only. Additional information on why the Job was skipped, if
	// available.
	SkipMessage string `protobuf:"bytes,8,opt,name=skip_message,json=skipMessage,proto3" json:"skip_message,omitempty"`
	// Output only. The name of the `JobRun` responsible for the most recent
	// invocation of this Job.
	JobRun string `protobuf:"bytes,3,opt,name=job_run,json=jobRun,proto3" json:"job_run,omitempty"`
	// The type of Job.
	//
	// Types that are assignable to JobType:
	//
	//	*Job_DeployJob
	//	*Job_VerifyJob
	//	*Job_PredeployJob
	//	*Job_PostdeployJob
	//	*Job_CreateChildRolloutJob
	//	*Job_AdvanceChildRolloutJob
	JobType isJob_JobType `protobuf_oneof:"job_type"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{72}
}

func (x *Job) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Job) GetState() Job_State {
	if x != nil {
		return x.State
	}
	return Job_STATE_UNSPECIFIED
}

func (x *Job) GetSkipMessage() string {
	if x != nil {
		return x.SkipMessage
	}
	return ""
}

func (x *Job) GetJobRun() string {
	if x != nil {
		return x.JobRun
	}
	return ""
}

func (m *Job) GetJobType() isJob_JobType {
	if m != nil {
		return m.JobType
	}
	return nil
}

func (x *Job) GetDeployJob() *DeployJob {
	if x, ok := x.GetJobType().(*Job_DeployJob); ok {
		return x.DeployJob
	}
	return nil
}

func (x *Job) GetVerifyJob() *VerifyJob {
	if x, ok := x.GetJobType().(*Job_VerifyJob); ok {
		return x.VerifyJob
	}
	return nil
}

func (x *Job) GetPredeployJob() *PredeployJob {
	if x, ok := x.GetJobType().(*Job_PredeployJob); ok {
		return x.PredeployJob
	}
	return nil
}

func (x *Job) GetPostdeployJob() *PostdeployJob {
	if x, ok := x.GetJobType().(*Job_PostdeployJob); ok {
		return x.PostdeployJob
	}
	return nil
}

func (x *Job) GetCreateChildRolloutJob() *CreateChildRolloutJob {
	if x, ok := x.GetJobType().(*Job_CreateChildRolloutJob); ok {
		return x.CreateChildRolloutJob
	}
	return nil
}

func (x *Job) GetAdvanceChildRolloutJob() *AdvanceChildRolloutJob {
	if x, ok := x.GetJobType().(*Job_AdvanceChildRolloutJob); ok {
		return x.AdvanceChildRolloutJob
	}
	return nil
}

type isJob_JobType interface {
	isJob_JobType()
}

type Job_DeployJob struct {
	// Output only. A deploy Job.
	DeployJob *DeployJob `protobuf:"bytes,4,opt,name=deploy_job,json=deployJob,proto3,oneof"`
}

type Job_VerifyJob struct {
	// Output only. A verify Job.
	VerifyJob *VerifyJob `protobuf:"bytes,5,opt,name=verify_job,json=verifyJob,proto3,oneof"`
}

type Job_PredeployJob struct {
	// Output only. A predeploy Job.
	PredeployJob *PredeployJob `protobuf:"bytes,9,opt,name=predeploy_job,json=predeployJob,proto3,oneof"`
}

type Job_PostdeployJob struct {
	// Output only. A postdeploy Job.
	PostdeployJob *PostdeployJob `protobuf:"bytes,10,opt,name=postdeploy_job,json=postdeployJob,proto3,oneof"`
}

type Job_CreateChildRolloutJob struct {
	// Output only. A createChildRollout Job.
	CreateChildRolloutJob *CreateChildRolloutJob `protobuf:"bytes,6,opt,name=create_child_rollout_job,json=createChildRolloutJob,proto3,oneof"`
}

type Job_AdvanceChildRolloutJob struct {
	// Output only. An advanceChildRollout Job.
	AdvanceChildRolloutJob *AdvanceChildRolloutJob `protobuf:"bytes,7,opt,name=advance_child_rollout_job,json=advanceChildRolloutJob,proto3,oneof"`
}

func (*Job_DeployJob) isJob_JobType() {}

func (*Job_VerifyJob) isJob_JobType() {}

func (*Job_PredeployJob) isJob_JobType() {}

func (*Job_PostdeployJob) isJob_JobType() {}

func (*Job_CreateChildRolloutJob) isJob_JobType() {}

func (*Job_AdvanceChildRolloutJob) isJob_JobType() {}

// A deploy Job.
type DeployJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployJob) Reset() {
	*x = DeployJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployJob) ProtoMessage() {}

func (x *DeployJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployJob.ProtoReflect.Descriptor instead.
func (*DeployJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{73}
}

// A verify Job.
type VerifyJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VerifyJob) Reset() {
	*x = VerifyJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyJob) ProtoMessage() {}

func (x *VerifyJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyJob.ProtoReflect.Descriptor instead.
func (*VerifyJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{74}
}

// A predeploy Job.
type PredeployJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The custom actions that the predeploy Job executes.
	Actions []string `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *PredeployJob) Reset() {
	*x = PredeployJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredeployJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredeployJob) ProtoMessage() {}

func (x *PredeployJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredeployJob.ProtoReflect.Descriptor instead.
func (*PredeployJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{75}
}

func (x *PredeployJob) GetActions() []string {
	if x != nil {
		return x.Actions
	}
	return nil
}

// A postdeploy Job.
type PostdeployJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The custom actions that the postdeploy Job executes.
	Actions []string `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *PostdeployJob) Reset() {
	*x = PostdeployJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostdeployJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostdeployJob) ProtoMessage() {}

func (x *PostdeployJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostdeployJob.ProtoReflect.Descriptor instead.
func (*PostdeployJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{76}
}

func (x *PostdeployJob) GetActions() []string {
	if x != nil {
		return x.Actions
	}
	return nil
}

// A createChildRollout Job.
type CreateChildRolloutJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateChildRolloutJob) Reset() {
	*x = CreateChildRolloutJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChildRolloutJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChildRolloutJob) ProtoMessage() {}

func (x *CreateChildRolloutJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChildRolloutJob.ProtoReflect.Descriptor instead.
func (*CreateChildRolloutJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{77}
}

// An advanceChildRollout Job.
type AdvanceChildRolloutJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AdvanceChildRolloutJob) Reset() {
	*x = AdvanceChildRolloutJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvanceChildRolloutJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvanceChildRolloutJob) ProtoMessage() {}

func (x *AdvanceChildRolloutJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvanceChildRolloutJob.ProtoReflect.Descriptor instead.
func (*AdvanceChildRolloutJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{78}
}

// ListRolloutsRequest is the request object used by `ListRollouts`.
type ListRolloutsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Release` which owns this collection of `Rollout` objects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Rollout` objects to return. The service
	// may return fewer than this value. If unspecified, at most 50 `Rollout`
	// objects will be returned. The maximum value is 1000; values above 1000 will
	// be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListRollouts` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter rollouts to be returned. See https://google.aip.dev/160
	// for more details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for
	// more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRolloutsRequest) Reset() {
	*x = ListRolloutsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRolloutsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRolloutsRequest) ProtoMessage() {}

func (x *ListRolloutsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRolloutsRequest.ProtoReflect.Descriptor instead.
func (*ListRolloutsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{79}
}

func (x *ListRolloutsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRolloutsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRolloutsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRolloutsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRolloutsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// ListRolloutsResponse is the response object reutrned by `ListRollouts`.
type ListRolloutsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Rollout` objects.
	Rollouts []*Rollout `protobuf:"bytes,1,rep,name=rollouts,proto3" json:"rollouts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRolloutsResponse) Reset() {
	*x = ListRolloutsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRolloutsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRolloutsResponse) ProtoMessage() {}

func (x *ListRolloutsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRolloutsResponse.ProtoReflect.Descriptor instead.
func (*ListRolloutsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{80}
}

func (x *ListRolloutsResponse) GetRollouts() []*Rollout {
	if x != nil {
		return x.Rollouts
	}
	return nil
}

func (x *ListRolloutsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRolloutsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// GetRolloutRequest is the request object used by `GetRollout`.
type GetRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `Rollout`. Format must be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRolloutRequest) Reset() {
	*x = GetRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRolloutRequest) ProtoMessage() {}

func (x *GetRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRolloutRequest.ProtoReflect.Descriptor instead.
func (*GetRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{81}
}

func (x *GetRolloutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// CreateRolloutRequest is the request object used by `CreateRollout`.
type CreateRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `Rollout` should be created.
	// Format should be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `Rollout`.
	RolloutId string `protobuf:"bytes,2,opt,name=rollout_id,json=rolloutId,proto3" json:"rollout_id,omitempty"`
	// Required. The `Rollout` to create.
	Rollout *Rollout `protobuf:"bytes,3,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
	// will start at the first phase.
	StartingPhaseId string `protobuf:"bytes,7,opt,name=starting_phase_id,json=startingPhaseId,proto3" json:"starting_phase_id,omitempty"`
}

func (x *CreateRolloutRequest) Reset() {
	*x = CreateRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRolloutRequest) ProtoMessage() {}

func (x *CreateRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRolloutRequest.ProtoReflect.Descriptor instead.
func (*CreateRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{82}
}

func (x *CreateRolloutRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRolloutRequest) GetRolloutId() string {
	if x != nil {
		return x.RolloutId
	}
	return ""
}

func (x *CreateRolloutRequest) GetRollout() *Rollout {
	if x != nil {
		return x.Rollout
	}
	return nil
}

func (x *CreateRolloutRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateRolloutRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *CreateRolloutRequest) GetStartingPhaseId() string {
	if x != nil {
		return x.StartingPhaseId
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{83}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// The request object used by `ApproveRollout`.
type ApproveRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Rollout. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. True = approve; false = reject
	Approved bool `protobuf:"varint,2,opt,name=approved,proto3" json:"approved,omitempty"`
}

func (x *ApproveRolloutRequest) Reset() {
	*x = ApproveRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveRolloutRequest) ProtoMessage() {}

func (x *ApproveRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveRolloutRequest.ProtoReflect.Descriptor instead.
func (*ApproveRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{84}
}

func (x *ApproveRolloutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApproveRolloutRequest) GetApproved() bool {
	if x != nil {
		return x.Approved
	}
	return false
}

// The response object from `ApproveRollout`.
type ApproveRolloutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ApproveRolloutResponse) Reset() {
	*x = ApproveRolloutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveRolloutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveRolloutResponse) ProtoMessage() {}

func (x *ApproveRolloutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveRolloutResponse.ProtoReflect.Descriptor instead.
func (*ApproveRolloutResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{85}
}

// The request object used by `AdvanceRollout`.
type AdvanceRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Rollout. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The phase ID to advance the `Rollout` to.
	PhaseId string `protobuf:"bytes,2,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
}

func (x *AdvanceRolloutRequest) Reset() {
	*x = AdvanceRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvanceRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvanceRolloutRequest) ProtoMessage() {}

func (x *AdvanceRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvanceRolloutRequest.ProtoReflect.Descriptor instead.
func (*AdvanceRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{86}
}

func (x *AdvanceRolloutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AdvanceRolloutRequest) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

// The response object from `AdvanceRollout`.
type AdvanceRolloutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AdvanceRolloutResponse) Reset() {
	*x = AdvanceRolloutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvanceRolloutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvanceRolloutResponse) ProtoMessage() {}

func (x *AdvanceRolloutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvanceRolloutResponse.ProtoReflect.Descriptor instead.
func (*AdvanceRolloutResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{87}
}

// The request object used by `CancelRollout`.
type CancelRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Rollout. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelRolloutRequest) Reset() {
	*x = CancelRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelRolloutRequest) ProtoMessage() {}

func (x *CancelRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelRolloutRequest.ProtoReflect.Descriptor instead.
func (*CancelRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{88}
}

func (x *CancelRolloutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response object from `CancelRollout`.
type CancelRolloutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelRolloutResponse) Reset() {
	*x = CancelRolloutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelRolloutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelRolloutResponse) ProtoMessage() {}

func (x *CancelRolloutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelRolloutResponse.ProtoReflect.Descriptor instead.
func (*CancelRolloutResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{89}
}

// The request object used by `IgnoreJob`.
type IgnoreJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Rollout. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
	Rollout string `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Required. The phase ID the Job to ignore belongs to.
	PhaseId string `protobuf:"bytes,2,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
	// Required. The job ID for the Job to ignore.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
}

func (x *IgnoreJobRequest) Reset() {
	*x = IgnoreJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IgnoreJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IgnoreJobRequest) ProtoMessage() {}

func (x *IgnoreJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IgnoreJobRequest.ProtoReflect.Descriptor instead.
func (*IgnoreJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{90}
}

func (x *IgnoreJobRequest) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *IgnoreJobRequest) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

func (x *IgnoreJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// The response object from `IgnoreJob`.
type IgnoreJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IgnoreJobResponse) Reset() {
	*x = IgnoreJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IgnoreJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IgnoreJobResponse) ProtoMessage() {}

func (x *IgnoreJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IgnoreJobResponse.ProtoReflect.Descriptor instead.
func (*IgnoreJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{91}
}

// RetryJobRequest is the request object used by `RetryJob`.
type RetryJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Rollout. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
	Rollout string `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Required. The phase ID the Job to retry belongs to.
	PhaseId string `protobuf:"bytes,2,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
	// Required. The job ID for the Job to retry.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
}

func (x *RetryJobRequest) Reset() {
	*x = RetryJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryJobRequest) ProtoMessage() {}

func (x *RetryJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryJobRequest.ProtoReflect.Descriptor instead.
func (*RetryJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{92}
}

func (x *RetryJobRequest) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *RetryJobRequest) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

func (x *RetryJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// The response object from 'RetryJob'.
type RetryJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RetryJobResponse) Reset() {
	*x = RetryJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryJobResponse) ProtoMessage() {}

func (x *RetryJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryJobResponse.ProtoReflect.Descriptor instead.
func (*RetryJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{93}
}

// The request object used by `AbandonRelease`.
type AbandonReleaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Release. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AbandonReleaseRequest) Reset() {
	*x = AbandonReleaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonReleaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonReleaseRequest) ProtoMessage() {}

func (x *AbandonReleaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonReleaseRequest.ProtoReflect.Descriptor instead.
func (*AbandonReleaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{94}
}

func (x *AbandonReleaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response object for `AbandonRelease`.
type AbandonReleaseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AbandonReleaseResponse) Reset() {
	*x = AbandonReleaseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonReleaseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonReleaseResponse) ProtoMessage() {}

func (x *AbandonReleaseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonReleaseResponse.ProtoReflect.Descriptor instead.
func (*AbandonReleaseResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{95}
}

// A `JobRun` resource in the Cloud Deploy API.
//
// A `JobRun` contains information of a single `Rollout` job evaluation.
type JobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `JobRun`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `JobRun`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. ID of the `Rollout` phase this `JobRun` belongs in.
	PhaseId string `protobuf:"bytes,3,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
	// Output only. ID of the `Rollout` job this `JobRun` corresponds to.
	JobId string `protobuf:"bytes,4,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Output only. Time at which the `JobRun` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the `JobRun` was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time at which the `JobRun` ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The current state of the `JobRun`.
	State JobRun_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.deploy.v1.JobRun_State" json:"state,omitempty"`
	// The `JobRun` type and the information for that type.
	//
	// Types that are assignable to JobRun:
	//
	//	*JobRun_DeployJobRun
	//	*JobRun_VerifyJobRun
	//	*JobRun_PredeployJobRun
	//	*JobRun_PostdeployJobRun
	//	*JobRun_CreateChildRolloutJobRun
	//	*JobRun_AdvanceChildRolloutJobRun
	JobRun isJobRun_JobRun `protobuf_oneof:"job_run"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *JobRun) Reset() {
	*x = JobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobRun) ProtoMessage() {}

func (x *JobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobRun.ProtoReflect.Descriptor instead.
func (*JobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{96}
}

func (x *JobRun) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JobRun) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *JobRun) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

func (x *JobRun) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *JobRun) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *JobRun) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *JobRun) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *JobRun) GetState() JobRun_State {
	if x != nil {
		return x.State
	}
	return JobRun_STATE_UNSPECIFIED
}

func (m *JobRun) GetJobRun() isJobRun_JobRun {
	if m != nil {
		return m.JobRun
	}
	return nil
}

func (x *JobRun) GetDeployJobRun() *DeployJobRun {
	if x, ok := x.GetJobRun().(*JobRun_DeployJobRun); ok {
		return x.DeployJobRun
	}
	return nil
}

func (x *JobRun) GetVerifyJobRun() *VerifyJobRun {
	if x, ok := x.GetJobRun().(*JobRun_VerifyJobRun); ok {
		return x.VerifyJobRun
	}
	return nil
}

func (x *JobRun) GetPredeployJobRun() *PredeployJobRun {
	if x, ok := x.GetJobRun().(*JobRun_PredeployJobRun); ok {
		return x.PredeployJobRun
	}
	return nil
}

func (x *JobRun) GetPostdeployJobRun() *PostdeployJobRun {
	if x, ok := x.GetJobRun().(*JobRun_PostdeployJobRun); ok {
		return x.PostdeployJobRun
	}
	return nil
}

func (x *JobRun) GetCreateChildRolloutJobRun() *CreateChildRolloutJobRun {
	if x, ok := x.GetJobRun().(*JobRun_CreateChildRolloutJobRun); ok {
		return x.CreateChildRolloutJobRun
	}
	return nil
}

func (x *JobRun) GetAdvanceChildRolloutJobRun() *AdvanceChildRolloutJobRun {
	if x, ok := x.GetJobRun().(*JobRun_AdvanceChildRolloutJobRun); ok {
		return x.AdvanceChildRolloutJobRun
	}
	return nil
}

func (x *JobRun) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

type isJobRun_JobRun interface {
	isJobRun_JobRun()
}

type JobRun_DeployJobRun struct {
	// Output only. Information specific to a deploy `JobRun`.
	DeployJobRun *DeployJobRun `protobuf:"bytes,9,opt,name=deploy_job_run,json=deployJobRun,proto3,oneof"`
}

type JobRun_VerifyJobRun struct {
	// Output only. Information specific to a verify `JobRun`.
	VerifyJobRun *VerifyJobRun `protobuf:"bytes,10,opt,name=verify_job_run,json=verifyJobRun,proto3,oneof"`
}

type JobRun_PredeployJobRun struct {
	// Output only. Information specific to a predeploy `JobRun`.
	PredeployJobRun *PredeployJobRun `protobuf:"bytes,14,opt,name=predeploy_job_run,json=predeployJobRun,proto3,oneof"`
}

type JobRun_PostdeployJobRun struct {
	// Output only. Information specific to a postdeploy `JobRun`.
	PostdeployJobRun *PostdeployJobRun `protobuf:"bytes,15,opt,name=postdeploy_job_run,json=postdeployJobRun,proto3,oneof"`
}

type JobRun_CreateChildRolloutJobRun struct {
	// Output only. Information specific to a createChildRollout `JobRun`.
	CreateChildRolloutJobRun *CreateChildRolloutJobRun `protobuf:"bytes,12,opt,name=create_child_rollout_job_run,json=createChildRolloutJobRun,proto3,oneof"`
}

type JobRun_AdvanceChildRolloutJobRun struct {
	// Output only. Information specific to an advanceChildRollout `JobRun`
	AdvanceChildRolloutJobRun *AdvanceChildRolloutJobRun `protobuf:"bytes,13,opt,name=advance_child_rollout_job_run,json=advanceChildRolloutJobRun,proto3,oneof"`
}

func (*JobRun_DeployJobRun) isJobRun_JobRun() {}

func (*JobRun_VerifyJobRun) isJobRun_JobRun() {}

func (*JobRun_PredeployJobRun) isJobRun_JobRun() {}

func (*JobRun_PostdeployJobRun) isJobRun_JobRun() {}

func (*JobRun_CreateChildRolloutJobRun) isJobRun_JobRun() {}

func (*JobRun_AdvanceChildRolloutJobRun) isJobRun_JobRun() {}

// DeployJobRun contains information specific to a deploy `JobRun`.
type DeployJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is
	// used to deploy. Format is
	// `projects/{project}/locations/{location}/builds/{build}`.
	Build string `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. The reason the deploy failed. This will always be unspecified
	// while the deploy is in progress or if it succeeded.
	FailureCause DeployJobRun_FailureCause `protobuf:"varint,2,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.DeployJobRun_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the deploy failure, if available.
	FailureMessage string `protobuf:"bytes,3,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
	// Output only. Metadata containing information about the deploy job run.
	Metadata *DeployJobRunMetadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. The artifact of a deploy job run, if available.
	Artifact *DeployArtifact `protobuf:"bytes,5,opt,name=artifact,proto3" json:"artifact,omitempty"`
}

func (x *DeployJobRun) Reset() {
	*x = DeployJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployJobRun) ProtoMessage() {}

func (x *DeployJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployJobRun.ProtoReflect.Descriptor instead.
func (*DeployJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{97}
}

func (x *DeployJobRun) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *DeployJobRun) GetFailureCause() DeployJobRun_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return DeployJobRun_FAILURE_CAUSE_UNSPECIFIED
}

func (x *DeployJobRun) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

func (x *DeployJobRun) GetMetadata() *DeployJobRunMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *DeployJobRun) GetArtifact() *DeployArtifact {
	if x != nil {
		return x.Artifact
	}
	return nil
}

// VerifyJobRun contains information specific to a verify `JobRun`.
type VerifyJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is
	// used to verify. Format is
	// `projects/{project}/locations/{location}/builds/{build}`.
	Build string `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. URI of a directory containing the verify artifacts. This
	// contains the Skaffold event log.
	ArtifactUri string `protobuf:"bytes,2,opt,name=artifact_uri,json=artifactUri,proto3" json:"artifact_uri,omitempty"`
	// Output only. File path of the Skaffold event log relative to the artifact
	// URI.
	EventLogPath string `protobuf:"bytes,3,opt,name=event_log_path,json=eventLogPath,proto3" json:"event_log_path,omitempty"`
	// Output only. The reason the verify failed. This will always be unspecified
	// while the verify is in progress or if it succeeded.
	FailureCause VerifyJobRun_FailureCause `protobuf:"varint,4,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.VerifyJobRun_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the verify failure, if available.
	FailureMessage string `protobuf:"bytes,5,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
}

func (x *VerifyJobRun) Reset() {
	*x = VerifyJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyJobRun) ProtoMessage() {}

func (x *VerifyJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyJobRun.ProtoReflect.Descriptor instead.
func (*VerifyJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{98}
}

func (x *VerifyJobRun) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *VerifyJobRun) GetArtifactUri() string {
	if x != nil {
		return x.ArtifactUri
	}
	return ""
}

func (x *VerifyJobRun) GetEventLogPath() string {
	if x != nil {
		return x.EventLogPath
	}
	return ""
}

func (x *VerifyJobRun) GetFailureCause() VerifyJobRun_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return VerifyJobRun_FAILURE_CAUSE_UNSPECIFIED
}

func (x *VerifyJobRun) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

// PredeployJobRun contains information specific to a predeploy `JobRun`.
type PredeployJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is
	// used to execute the custom actions associated with the predeploy Job.
	// Format is `projects/{project}/locations/{location}/builds/{build}`.
	Build string `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. The reason the predeploy failed. This will always be
	// unspecified while the predeploy is in progress or if it succeeded.
	FailureCause PredeployJobRun_FailureCause `protobuf:"varint,2,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.PredeployJobRun_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the predeploy failure, if
	// available.
	FailureMessage string `protobuf:"bytes,3,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
}

func (x *PredeployJobRun) Reset() {
	*x = PredeployJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredeployJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredeployJobRun) ProtoMessage() {}

func (x *PredeployJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredeployJobRun.ProtoReflect.Descriptor instead.
func (*PredeployJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{99}
}

func (x *PredeployJobRun) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *PredeployJobRun) GetFailureCause() PredeployJobRun_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return PredeployJobRun_FAILURE_CAUSE_UNSPECIFIED
}

func (x *PredeployJobRun) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

// PostdeployJobRun contains information specific to a postdeploy `JobRun`.
type PostdeployJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is
	// used to execute the custom actions associated with the postdeploy Job.
	// Format is `projects/{project}/locations/{location}/builds/{build}`.
	Build string `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. The reason the postdeploy failed. This will always be
	// unspecified while the postdeploy is in progress or if it succeeded.
	FailureCause PostdeployJobRun_FailureCause `protobuf:"varint,2,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.PostdeployJobRun_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the postdeploy failure, if
	// available.
	FailureMessage string `protobuf:"bytes,3,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
}

func (x *PostdeployJobRun) Reset() {
	*x = PostdeployJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostdeployJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostdeployJobRun) ProtoMessage() {}

func (x *PostdeployJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostdeployJobRun.ProtoReflect.Descriptor instead.
func (*PostdeployJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{100}
}

func (x *PostdeployJobRun) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *PostdeployJobRun) GetFailureCause() PostdeployJobRun_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return PostdeployJobRun_FAILURE_CAUSE_UNSPECIFIED
}

func (x *PostdeployJobRun) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

// CreateChildRolloutJobRun contains information specific to a
// createChildRollout `JobRun`.
type CreateChildRolloutJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the `ChildRollout`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9\-]{0,62}`.
	Rollout string `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Output only. The ID of the childRollout Phase initiated by this JobRun.
	RolloutPhaseId string `protobuf:"bytes,2,opt,name=rollout_phase_id,json=rolloutPhaseId,proto3" json:"rollout_phase_id,omitempty"`
}

func (x *CreateChildRolloutJobRun) Reset() {
	*x = CreateChildRolloutJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChildRolloutJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChildRolloutJobRun) ProtoMessage() {}

func (x *CreateChildRolloutJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChildRolloutJobRun.ProtoReflect.Descriptor instead.
func (*CreateChildRolloutJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{101}
}

func (x *CreateChildRolloutJobRun) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *CreateChildRolloutJobRun) GetRolloutPhaseId() string {
	if x != nil {
		return x.RolloutPhaseId
	}
	return ""
}

// AdvanceChildRolloutJobRun contains information specific to a
// advanceChildRollout `JobRun`.
type AdvanceChildRolloutJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the `ChildRollout`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9\-]{0,62}`.
	Rollout string `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Output only. the ID of the ChildRollout's Phase.
	RolloutPhaseId string `protobuf:"bytes,2,opt,name=rollout_phase_id,json=rolloutPhaseId,proto3" json:"rollout_phase_id,omitempty"`
}

func (x *AdvanceChildRolloutJobRun) Reset() {
	*x = AdvanceChildRolloutJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvanceChildRolloutJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvanceChildRolloutJobRun) ProtoMessage() {}

func (x *AdvanceChildRolloutJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvanceChildRolloutJobRun.ProtoReflect.Descriptor instead.
func (*AdvanceChildRolloutJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{102}
}

func (x *AdvanceChildRolloutJobRun) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *AdvanceChildRolloutJobRun) GetRolloutPhaseId() string {
	if x != nil {
		return x.RolloutPhaseId
	}
	return ""
}

// ListJobRunsRequest is the request object used by `ListJobRuns`.
type ListJobRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Rollout` which owns this collection of `JobRun` objects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `JobRun` objects to return. The service may
	// return fewer than this value. If unspecified, at most 50 `JobRun` objects
	// will be returned. The maximum value is 1000; values above 1000 will be set
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListJobRuns` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter results to be returned. See https://google.aip.dev/160 for
	// more details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for
	// more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListJobRunsRequest) Reset() {
	*x = ListJobRunsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobRunsRequest) ProtoMessage() {}

func (x *ListJobRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobRunsRequest.ProtoReflect.Descriptor instead.
func (*ListJobRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{103}
}

func (x *ListJobRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListJobRunsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListJobRunsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobRunsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListJobRunsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// ListJobRunsResponse is the response object returned by `ListJobRuns`.
type ListJobRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `JobRun` objects.
	JobRuns []*JobRun `protobuf:"bytes,1,rep,name=job_runs,json=jobRuns,proto3" json:"job_runs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListJobRunsResponse) Reset() {
	*x = ListJobRunsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobRunsResponse) ProtoMessage() {}

func (x *ListJobRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobRunsResponse.ProtoReflect.Descriptor instead.
func (*ListJobRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{104}
}

func (x *ListJobRunsResponse) GetJobRuns() []*JobRun {
	if x != nil {
		return x.JobRuns
	}
	return nil
}

func (x *ListJobRunsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListJobRunsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// GetJobRunRequest is the request object used by `GetJobRun`.
type GetJobRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `JobRun`. Format must be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}/jobRuns/{job_run_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetJobRunRequest) Reset() {
	*x = GetJobRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobRunRequest) ProtoMessage() {}

func (x *GetJobRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobRunRequest.ProtoReflect.Descriptor instead.
func (*GetJobRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{105}
}

func (x *GetJobRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object used by `TerminateJobRun`.
type TerminateJobRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `JobRun`. Format must be
	// `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}/jobRuns/{jobRun}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *TerminateJobRunRequest) Reset() {
	*x = TerminateJobRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerminateJobRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerminateJobRunRequest) ProtoMessage() {}

func (x *TerminateJobRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerminateJobRunRequest.ProtoReflect.Descriptor instead.
func (*TerminateJobRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{106}
}

func (x *TerminateJobRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response object from `TerminateJobRun`.
type TerminateJobRunResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TerminateJobRunResponse) Reset() {
	*x = TerminateJobRunResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerminateJobRunResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerminateJobRunResponse) ProtoMessage() {}

func (x *TerminateJobRunResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerminateJobRunResponse.ProtoReflect.Descriptor instead.
func (*TerminateJobRunResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{107}
}

// Service-wide configuration.
type Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// All supported versions of Skaffold.
	SupportedVersions []*SkaffoldVersion `protobuf:"bytes,2,rep,name=supported_versions,json=supportedVersions,proto3" json:"supported_versions,omitempty"`
	// Default Skaffold version that is assigned when a Release is created without
	// specifying a Skaffold version.
	DefaultSkaffoldVersion string `protobuf:"bytes,3,opt,name=default_skaffold_version,json=defaultSkaffoldVersion,proto3" json:"default_skaffold_version,omitempty"`
}

func (x *Config) Reset() {
	*x = Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{108}
}

func (x *Config) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Config) GetSupportedVersions() []*SkaffoldVersion {
	if x != nil {
		return x.SupportedVersions
	}
	return nil
}

func (x *Config) GetDefaultSkaffoldVersion() string {
	if x != nil {
		return x.DefaultSkaffoldVersion
	}
	return ""
}

// Details of a supported Skaffold version.
type SkaffoldVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Release version number. For example, "1.20.3".
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The time at which this version of Skaffold will enter maintenance mode.
	MaintenanceModeTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=maintenance_mode_time,json=maintenanceModeTime,proto3" json:"maintenance_mode_time,omitempty"`
	// The time at which this version of Skaffold will no longer be supported.
	SupportExpirationTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=support_expiration_time,json=supportExpirationTime,proto3" json:"support_expiration_time,omitempty"`
	// Date when this version is expected to no longer be supported.
	SupportEndDate *date.Date `protobuf:"bytes,2,opt,name=support_end_date,json=supportEndDate,proto3" json:"support_end_date,omitempty"`
}

func (x *SkaffoldVersion) Reset() {
	*x = SkaffoldVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkaffoldVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkaffoldVersion) ProtoMessage() {}

func (x *SkaffoldVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkaffoldVersion.ProtoReflect.Descriptor instead.
func (*SkaffoldVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{109}
}

func (x *SkaffoldVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SkaffoldVersion) GetMaintenanceModeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MaintenanceModeTime
	}
	return nil
}

func (x *SkaffoldVersion) GetSupportExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SupportExpirationTime
	}
	return nil
}

func (x *SkaffoldVersion) GetSupportEndDate() *date.Date {
	if x != nil {
		return x.SupportEndDate
	}
	return nil
}

// Request to get a configuration.
type GetConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of requested configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConfigRequest) Reset() {
	*x = GetConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConfigRequest) ProtoMessage() {}

func (x *GetConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConfigRequest.ProtoReflect.Descriptor instead.
func (*GetConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{110}
}

func (x *GetConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An `Automation` resource in the Cloud Deploy API.
//
// An `Automation` enables the automation of manually driven actions for
// a Delivery Pipeline, which includes Release promotion among Targets,
// Rollout repair and Rollout deployment strategy advancement. The intention
// of Automation is to reduce manual intervention in the continuous delivery
// process.
type Automation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the `Automation`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `Automation`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Description of the `Automation`. Max length is 255 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time at which the automation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the automation was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User annotations. These attributes can only be set and used by
	// the user, and not by Cloud Deploy. Annotations must meet the following
	// constraints:
	//
	// * Annotations are key/value pairs.
	// * Valid annotation keys have two segments: an optional prefix and name,
	// separated by a slash (`/`).
	// * The name segment is required and must be 63 characters or less,
	// beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
	// dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
	// * The prefix is optional. If specified, the prefix must be a DNS subdomain:
	// a series of DNS labels separated by dots(`.`), not longer than 253
	// characters in total, followed by a slash (`/`).
	//
	// See
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
	// for more details.
	Annotations map[string]string `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Labels are attributes that can be set and used by both the
	// user and by Cloud Deploy. Labels must meet the following constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 63 characters.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The weak etag of the `Automation` resource.
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. When Suspended, automation is deactivated from execution.
	Suspended bool `protobuf:"varint,9,opt,name=suspended,proto3" json:"suspended,omitempty"`
	// Required. Email address of the user-managed IAM service account that
	// creates Cloud Deploy release and rollout resources.
	ServiceAccount string `protobuf:"bytes,10,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Required. Selected resources to which the automation will be applied.
	Selector *AutomationResourceSelector `protobuf:"bytes,11,opt,name=selector,proto3" json:"selector,omitempty"`
	// Required. List of Automation rules associated with the Automation resource.
	// Must have at least one rule and limited to 250 rules per Delivery Pipeline.
	// Note: the order of the rules here is not the same as the order of
	// execution.
	Rules []*AutomationRule `protobuf:"bytes,14,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *Automation) Reset() {
	*x = Automation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Automation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Automation) ProtoMessage() {}

func (x *Automation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Automation.ProtoReflect.Descriptor instead.
func (*Automation) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{111}
}

func (x *Automation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Automation) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Automation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Automation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Automation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Automation) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Automation) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Automation) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Automation) GetSuspended() bool {
	if x != nil {
		return x.Suspended
	}
	return false
}

func (x *Automation) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Automation) GetSelector() *AutomationResourceSelector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *Automation) GetRules() []*AutomationRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// AutomationResourceSelector contains the information to select the resources
// to which an Automation is going to be applied.
type AutomationResourceSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains attributes about a target.
	Targets []*TargetAttribute `protobuf:"bytes,1,rep,name=targets,proto3" json:"targets,omitempty"`
}

func (x *AutomationResourceSelector) Reset() {
	*x = AutomationResourceSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomationResourceSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomationResourceSelector) ProtoMessage() {}

func (x *AutomationResourceSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomationResourceSelector.ProtoReflect.Descriptor instead.
func (*AutomationResourceSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{112}
}

func (x *AutomationResourceSelector) GetTargets() []*TargetAttribute {
	if x != nil {
		return x.Targets
	}
	return nil
}

// `AutomationRule` defines the automation activities.
type AutomationRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration of the Automation rule.
	//
	// Types that are assignable to Rule:
	//
	//	*AutomationRule_PromoteReleaseRule
	//	*AutomationRule_AdvanceRolloutRule
	//	*AutomationRule_RepairRolloutRule
	Rule isAutomationRule_Rule `protobuf_oneof:"rule"`
}

func (x *AutomationRule) Reset() {
	*x = AutomationRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomationRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomationRule) ProtoMessage() {}

func (x *AutomationRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomationRule.ProtoReflect.Descriptor instead.
func (*AutomationRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{113}
}

func (m *AutomationRule) GetRule() isAutomationRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (x *AutomationRule) GetPromoteReleaseRule() *PromoteReleaseRule {
	if x, ok := x.GetRule().(*AutomationRule_PromoteReleaseRule); ok {
		return x.PromoteReleaseRule
	}
	return nil
}

func (x *AutomationRule) GetAdvanceRolloutRule() *AdvanceRolloutRule {
	if x, ok := x.GetRule().(*AutomationRule_AdvanceRolloutRule); ok {
		return x.AdvanceRolloutRule
	}
	return nil
}

func (x *AutomationRule) GetRepairRolloutRule() *RepairRolloutRule {
	if x, ok := x.GetRule().(*AutomationRule_RepairRolloutRule); ok {
		return x.RepairRolloutRule
	}
	return nil
}

type isAutomationRule_Rule interface {
	isAutomationRule_Rule()
}

type AutomationRule_PromoteReleaseRule struct {
	// Optional. `PromoteReleaseRule` will automatically promote a release from
	// the current target to a specified target.
	PromoteReleaseRule *PromoteReleaseRule `protobuf:"bytes,1,opt,name=promote_release_rule,json=promoteReleaseRule,proto3,oneof"`
}

type AutomationRule_AdvanceRolloutRule struct {
	// Optional. The `AdvanceRolloutRule` will automatically advance a
	// successful Rollout.
	AdvanceRolloutRule *AdvanceRolloutRule `protobuf:"bytes,2,opt,name=advance_rollout_rule,json=advanceRolloutRule,proto3,oneof"`
}

type AutomationRule_RepairRolloutRule struct {
	// Optional. The `RepairRolloutRule` will automatically repair a failed
	// rollout.
	RepairRolloutRule *RepairRolloutRule `protobuf:"bytes,3,opt,name=repair_rollout_rule,json=repairRolloutRule,proto3,oneof"`
}

func (*AutomationRule_PromoteReleaseRule) isAutomationRule_Rule() {}

func (*AutomationRule_AdvanceRolloutRule) isAutomationRule_Rule() {}

func (*AutomationRule_RepairRolloutRule) isAutomationRule_Rule() {}

// `PromoteRelease` rule will automatically promote a release from the current
// target to a specified target.
type PromoteReleaseRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the rule. This id must be unique in the `Automation`
	// resource to which this rule belongs. The format is `[a-z][a-z0-9\-]{0,62}`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. How long the release need to be paused until being promoted to
	// the next target.
	Wait *durationpb.Duration `protobuf:"bytes,2,opt,name=wait,proto3" json:"wait,omitempty"`
	// Optional. The ID of the stage in the pipeline to which this `Release` is
	// deploying. If unspecified, default it to the next stage in the promotion
	// flow. The value of this field could be one of the following:
	//
	// * The last segment of a target name. It only needs the ID to determine
	// if the target is one of the stages in the promotion sequence defined
	// in the pipeline.
	// * "@next", the next target in the promotion sequence.
	DestinationTargetId string `protobuf:"bytes,7,opt,name=destination_target_id,json=destinationTargetId,proto3" json:"destination_target_id,omitempty"`
	// Output only. Information around the state of the Automation rule.
	Condition *AutomationRuleCondition `protobuf:"bytes,5,opt,name=condition,proto3" json:"condition,omitempty"`
	// Optional. The starting phase of the rollout created by this operation.
	// Default to the first phase.
	DestinationPhase string `protobuf:"bytes,8,opt,name=destination_phase,json=destinationPhase,proto3" json:"destination_phase,omitempty"`
}

func (x *PromoteReleaseRule) Reset() {
	*x = PromoteReleaseRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PromoteReleaseRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromoteReleaseRule) ProtoMessage() {}

func (x *PromoteReleaseRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromoteReleaseRule.ProtoReflect.Descriptor instead.
func (*PromoteReleaseRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{114}
}

func (x *PromoteReleaseRule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PromoteReleaseRule) GetWait() *durationpb.Duration {
	if x != nil {
		return x.Wait
	}
	return nil
}

func (x *PromoteReleaseRule) GetDestinationTargetId() string {
	if x != nil {
		return x.DestinationTargetId
	}
	return ""
}

func (x *PromoteReleaseRule) GetCondition() *AutomationRuleCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *PromoteReleaseRule) GetDestinationPhase() string {
	if x != nil {
		return x.DestinationPhase
	}
	return ""
}

// The `AdvanceRollout` automation rule will automatically advance a successful
// Rollout to the next phase.
type AdvanceRolloutRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the rule. This id must be unique in the `Automation`
	// resource to which this rule belongs. The format is `[a-z][a-z0-9\-]{0,62}`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. Proceeds only after phase name matched any one in the list.
	// This value must consist of lower-case letters, numbers, and hyphens,
	// start with a letter and end with a letter or a number, and have a max
	// length of 63 characters. In other words, it must match the following
	// regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
	SourcePhases []string `protobuf:"bytes,6,rep,name=source_phases,json=sourcePhases,proto3" json:"source_phases,omitempty"`
	// Optional. How long to wait after a rollout is finished.
	Wait *durationpb.Duration `protobuf:"bytes,3,opt,name=wait,proto3" json:"wait,omitempty"`
	// Output only. Information around the state of the Automation rule.
	Condition *AutomationRuleCondition `protobuf:"bytes,5,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *AdvanceRolloutRule) Reset() {
	*x = AdvanceRolloutRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvanceRolloutRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvanceRolloutRule) ProtoMessage() {}

func (x *AdvanceRolloutRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvanceRolloutRule.ProtoReflect.Descriptor instead.
func (*AdvanceRolloutRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{115}
}

func (x *AdvanceRolloutRule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AdvanceRolloutRule) GetSourcePhases() []string {
	if x != nil {
		return x.SourcePhases
	}
	return nil
}

func (x *AdvanceRolloutRule) GetWait() *durationpb.Duration {
	if x != nil {
		return x.Wait
	}
	return nil
}

func (x *AdvanceRolloutRule) GetCondition() *AutomationRuleCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

// The `RepairRolloutRule` automation rule will automatically repair a failed
// `Rollout`.
type RepairRolloutRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the rule. This id must be unique in the `Automation`
	// resource to which this rule belongs. The format is `[a-z][a-z0-9\-]{0,62}`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. Phases within which jobs are subject to automatic repair actions
	// on failure. Proceeds only after phase name matched any one in the list, or
	// for all phases if unspecified. This value must consist of lower-case
	// letters, numbers, and hyphens, start with a letter and end with a letter or
	// a number, and have a max length of 63 characters. In other words, it must
	// match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
	SourcePhases []string `protobuf:"bytes,2,rep,name=source_phases,json=sourcePhases,proto3" json:"source_phases,omitempty"`
	// Optional. Jobs to repair. Proceeds only after job name matched any one in
	// the list, or for all jobs if unspecified or empty. The phase that includes
	// the job must match the phase ID specified in `source_phase`. This value
	// must consist of lower-case letters, numbers, and hyphens, start with a
	// letter and end with a letter or a number, and have a max length of 63
	// characters. In other words, it must match the following regex:
	// `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
	Jobs []string `protobuf:"bytes,3,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Required. Defines the types of automatic repair actions for failed jobs.
	RepairModes []*RepairMode `protobuf:"bytes,4,rep,name=repair_modes,json=repairModes,proto3" json:"repair_modes,omitempty"`
	// Output only. Information around the state of the 'Automation' rule.
	Condition *AutomationRuleCondition `protobuf:"bytes,6,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *RepairRolloutRule) Reset() {
	*x = RepairRolloutRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepairRolloutRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepairRolloutRule) ProtoMessage() {}

func (x *RepairRolloutRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepairRolloutRule.ProtoReflect.Descriptor instead.
func (*RepairRolloutRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{116}
}

func (x *RepairRolloutRule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *RepairRolloutRule) GetSourcePhases() []string {
	if x != nil {
		return x.SourcePhases
	}
	return nil
}

func (x *RepairRolloutRule) GetJobs() []string {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *RepairRolloutRule) GetRepairModes() []*RepairMode {
	if x != nil {
		return x.RepairModes
	}
	return nil
}

func (x *RepairRolloutRule) GetCondition() *AutomationRuleCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

// Configuration of the repair action.
type RepairMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The repair action to perform.
	//
	// Types that are assignable to Mode:
	//
	//	*RepairMode_Retry
	//	*RepairMode_Rollback
	Mode isRepairMode_Mode `protobuf_oneof:"mode"`
}

func (x *RepairMode) Reset() {
	*x = RepairMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepairMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepairMode) ProtoMessage() {}

func (x *RepairMode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepairMode.ProtoReflect.Descriptor instead.
func (*RepairMode) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{117}
}

func (m *RepairMode) GetMode() isRepairMode_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *RepairMode) GetRetry() *Retry {
	if x, ok := x.GetMode().(*RepairMode_Retry); ok {
		return x.Retry
	}
	return nil
}

func (x *RepairMode) GetRollback() *Rollback {
	if x, ok := x.GetMode().(*RepairMode_Rollback); ok {
		return x.Rollback
	}
	return nil
}

type isRepairMode_Mode interface {
	isRepairMode_Mode()
}

type RepairMode_Retry struct {
	// Optional. Retries a failed job.
	Retry *Retry `protobuf:"bytes,1,opt,name=retry,proto3,oneof"`
}

type RepairMode_Rollback struct {
	// Optional. Rolls back a `Rollout`.
	Rollback *Rollback `protobuf:"bytes,2,opt,name=rollback,proto3,oneof"`
}

func (*RepairMode_Retry) isRepairMode_Mode() {}

func (*RepairMode_Rollback) isRepairMode_Mode() {}

// Retries the failed job.
type Retry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Total number of retries. Retry is skipped if set to 0; The
	// minimum value is 1, and the maximum value is 10.
	Attempts int64 `protobuf:"varint,1,opt,name=attempts,proto3" json:"attempts,omitempty"`
	// Optional. How long to wait for the first retry. Default is 0, and the
	// maximum value is 14d.
	Wait *durationpb.Duration `protobuf:"bytes,2,opt,name=wait,proto3" json:"wait,omitempty"`
	// Optional. The pattern of how wait time will be increased. Default is
	// linear. Backoff mode will be ignored if `wait` is 0.
	BackoffMode BackoffMode `protobuf:"varint,3,opt,name=backoff_mode,json=backoffMode,proto3,enum=google.cloud.deploy.v1.BackoffMode" json:"backoff_mode,omitempty"`
}

func (x *Retry) Reset() {
	*x = Retry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Retry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Retry) ProtoMessage() {}

func (x *Retry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Retry.ProtoReflect.Descriptor instead.
func (*Retry) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{118}
}

func (x *Retry) GetAttempts() int64 {
	if x != nil {
		return x.Attempts
	}
	return 0
}

func (x *Retry) GetWait() *durationpb.Duration {
	if x != nil {
		return x.Wait
	}
	return nil
}

func (x *Retry) GetBackoffMode() BackoffMode {
	if x != nil {
		return x.BackoffMode
	}
	return BackoffMode_BACKOFF_MODE_UNSPECIFIED
}

// Rolls back a `Rollout`.
type Rollback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The starting phase ID for the `Rollout`. If unspecified, the
	// `Rollout` will start in the stable phase.
	DestinationPhase string `protobuf:"bytes,1,opt,name=destination_phase,json=destinationPhase,proto3" json:"destination_phase,omitempty"`
}

func (x *Rollback) Reset() {
	*x = Rollback{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rollback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rollback) ProtoMessage() {}

func (x *Rollback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rollback.ProtoReflect.Descriptor instead.
func (*Rollback) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{119}
}

func (x *Rollback) GetDestinationPhase() string {
	if x != nil {
		return x.DestinationPhase
	}
	return ""
}

// `AutomationRuleCondition` contains conditions relevant to an
// `Automation` rule.
type AutomationRuleCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Details around targets enumerated in the rule.
	TargetsPresentCondition *TargetsPresentCondition `protobuf:"bytes,1,opt,name=targets_present_condition,json=targetsPresentCondition,proto3" json:"targets_present_condition,omitempty"`
}

func (x *AutomationRuleCondition) Reset() {
	*x = AutomationRuleCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomationRuleCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomationRuleCondition) ProtoMessage() {}

func (x *AutomationRuleCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomationRuleCondition.ProtoReflect.Descriptor instead.
func (*AutomationRuleCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{120}
}

func (x *AutomationRuleCondition) GetTargetsPresentCondition() *TargetsPresentCondition {
	if x != nil {
		return x.TargetsPresentCondition
	}
	return nil
}

// The request object for `CreateAutomation`.
type CreateAutomationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `Automation` should be
	// created. Format should be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `Automation`.
	AutomationId string `protobuf:"bytes,2,opt,name=automation_id,json=automationId,proto3" json:"automation_id,omitempty"`
	// Required. The `Automation` to create.
	Automation *Automation `protobuf:"bytes,3,opt,name=automation,proto3" json:"automation,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAutomationRequest) Reset() {
	*x = CreateAutomationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAutomationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAutomationRequest) ProtoMessage() {}

func (x *CreateAutomationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAutomationRequest.ProtoReflect.Descriptor instead.
func (*CreateAutomationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{121}
}

func (x *CreateAutomationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAutomationRequest) GetAutomationId() string {
	if x != nil {
		return x.AutomationId
	}
	return ""
}

func (x *CreateAutomationRequest) GetAutomation() *Automation {
	if x != nil {
		return x.Automation
	}
	return nil
}

func (x *CreateAutomationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateAutomationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `UpdateAutomation`.
type UpdateAutomationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Automation` resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it's in the mask. If the
	// user doesn't provide a mask then all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The `Automation` to update.
	Automation *Automation `protobuf:"bytes,2,opt,name=automation,proto3" json:"automation,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, updating a `Automation` that does not exist will
	// result in the creation of a new `Automation`.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided
	// with an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateAutomationRequest) Reset() {
	*x = UpdateAutomationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAutomationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAutomationRequest) ProtoMessage() {}

func (x *UpdateAutomationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAutomationRequest.ProtoReflect.Descriptor instead.
func (*UpdateAutomationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{122}
}

func (x *UpdateAutomationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAutomationRequest) GetAutomation() *Automation {
	if x != nil {
		return x.Automation
	}
	return nil
}

func (x *UpdateAutomationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateAutomationRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateAutomationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `DeleteAutomation`.
type DeleteAutomationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Automation` to delete. Format should be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/automations/{automation_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server knows to ignore the
	// request if it has already been completed. The server guarantees that for
	// at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, then deleting an already deleted or non-existing
	// `Automation` will succeed.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set, validate the request and verify whether the resource
	// exists, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. The weak etag of the request.
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAutomationRequest) Reset() {
	*x = DeleteAutomationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAutomationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAutomationRequest) ProtoMessage() {}

func (x *DeleteAutomationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAutomationRequest.ProtoReflect.Descriptor instead.
func (*DeleteAutomationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{123}
}

func (x *DeleteAutomationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAutomationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteAutomationRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAutomationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAutomationRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// The request object for `ListAutomations`.
type ListAutomationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent `Delivery Pipeline`, which owns this collection of
	// automations. Format must be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of automations to return. The service may return
	// fewer than this value. If unspecified, at most 50 automations will
	// be returned. The maximum value is 1000; values above 1000 will be set
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAutomations` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter automations to be returned. All fields can be used in the
	// filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAutomationsRequest) Reset() {
	*x = ListAutomationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAutomationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutomationsRequest) ProtoMessage() {}

func (x *ListAutomationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutomationsRequest.ProtoReflect.Descriptor instead.
func (*ListAutomationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{124}
}

func (x *ListAutomationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAutomationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAutomationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAutomationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAutomationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListAutomations`.
type ListAutomationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Automation` objects.
	Automations []*Automation `protobuf:"bytes,1,rep,name=automations,proto3" json:"automations,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListAutomationsResponse) Reset() {
	*x = ListAutomationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAutomationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutomationsResponse) ProtoMessage() {}

func (x *ListAutomationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutomationsResponse.ProtoReflect.Descriptor instead.
func (*ListAutomationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{125}
}

func (x *ListAutomationsResponse) GetAutomations() []*Automation {
	if x != nil {
		return x.Automations
	}
	return nil
}

func (x *ListAutomationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAutomationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetAutomation`
type GetAutomationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `Automation`. Format must be
	// `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/automations/{automation_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAutomationRequest) Reset() {
	*x = GetAutomationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAutomationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAutomationRequest) ProtoMessage() {}

func (x *GetAutomationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAutomationRequest.ProtoReflect.Descriptor instead.
func (*GetAutomationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{126}
}

func (x *GetAutomationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An `AutomationRun` resource in the Cloud Deploy API.
//
// An `AutomationRun` represents an execution instance of an
// automation rule.
type AutomationRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the `AutomationRun`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time at which the `AutomationRun` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the automationRun was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The weak etag of the `AutomationRun` resource.
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Email address of the user-managed IAM service account that
	// performs the operations against Cloud Deploy resources.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. Snapshot of the Automation taken at AutomationRun creation
	// time.
	AutomationSnapshot *Automation `protobuf:"bytes,6,opt,name=automation_snapshot,json=automationSnapshot,proto3" json:"automation_snapshot,omitempty"`
	// Output only. The ID of the target that represents the promotion stage that
	// initiates the `AutomationRun`. The value of this field is the last segment
	// of a target name.
	TargetId string `protobuf:"bytes,7,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Output only. Current state of the `AutomationRun`.
	State AutomationRun_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.deploy.v1.AutomationRun_State" json:"state,omitempty"`
	// Output only. Explains the current state of the `AutomationRun`. Present
	// only when an explanation is needed.
	StateDescription string `protobuf:"bytes,9,opt,name=state_description,json=stateDescription,proto3" json:"state_description,omitempty"`
	// Output only. Time the `AutomationRun` expires. An `AutomationRun` expires
	// after 14 days from its creation date.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. The ID of the automation rule that initiated the operation.
	RuleId string `protobuf:"bytes,12,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// Output only. The ID of the automation that initiated the operation.
	AutomationId string `protobuf:"bytes,15,opt,name=automation_id,json=automationId,proto3" json:"automation_id,omitempty"`
	// The operation that the `AutomationRun` will perform.
	//
	// Types that are assignable to Operation:
	//
	//	*AutomationRun_PromoteReleaseOperation
	//	*AutomationRun_AdvanceRolloutOperation
	//	*AutomationRun_RepairRolloutOperation
	Operation isAutomationRun_Operation `protobuf_oneof:"operation"`
	// Output only. Earliest time the `AutomationRun` will attempt to resume.
	// Wait-time is configured by `wait` in automation rule.
	WaitUntilTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=wait_until_time,json=waitUntilTime,proto3" json:"wait_until_time,omitempty"`
}

func (x *AutomationRun) Reset() {
	*x = AutomationRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[127]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomationRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomationRun) ProtoMessage() {}

func (x *AutomationRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[127]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomationRun.ProtoReflect.Descriptor instead.
func (*AutomationRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{127}
}

func (x *AutomationRun) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AutomationRun) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AutomationRun) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AutomationRun) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AutomationRun) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *AutomationRun) GetAutomationSnapshot() *Automation {
	if x != nil {
		return x.AutomationSnapshot
	}
	return nil
}

func (x *AutomationRun) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *AutomationRun) GetState() AutomationRun_State {
	if x != nil {
		return x.State
	}
	return AutomationRun_STATE_UNSPECIFIED
}

func (x *AutomationRun) GetStateDescription() string {
	if x != nil {
		return x.StateDescription
	}
	return ""
}

func (x *AutomationRun) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *AutomationRun) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *AutomationRun) GetAutomationId() string {
	if x != nil {
		return x.AutomationId
	}
	return ""
}

func (m *AutomationRun) GetOperation() isAutomationRun_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *AutomationRun) GetPromoteReleaseOperation() *PromoteReleaseOperation {
	if x, ok := x.GetOperation().(*AutomationRun_PromoteReleaseOperation); ok {
		return x.PromoteReleaseOperation
	}
	return nil
}

func (x *AutomationRun) GetAdvanceRolloutOperation() *AdvanceRolloutOperation {
	if x, ok := x.GetOperation().(*AutomationRun_AdvanceRolloutOperation); ok {
		return x.AdvanceRolloutOperation
	}
	return nil
}

func (x *AutomationRun) GetRepairRolloutOperation() *RepairRolloutOperation {
	if x, ok := x.GetOperation().(*AutomationRun_RepairRolloutOperation); ok {
		return x.RepairRolloutOperation
	}
	return nil
}

func (x *AutomationRun) GetWaitUntilTime() *timestamppb.Timestamp {
	if x != nil {
		return x.WaitUntilTime
	}
	return nil
}

type isAutomationRun_Operation interface {
	isAutomationRun_Operation()
}

type AutomationRun_PromoteReleaseOperation struct {
	// Output only. Promotes a release to a specified 'Target'.
	PromoteReleaseOperation *PromoteReleaseOperation `protobuf:"bytes,13,opt,name=promote_release_operation,json=promoteReleaseOperation,proto3,oneof"`
}

type AutomationRun_AdvanceRolloutOperation struct {
	// Output only. Advances a rollout to the next phase.
	AdvanceRolloutOperation *AdvanceRolloutOperation `protobuf:"bytes,14,opt,name=advance_rollout_operation,json=advanceRolloutOperation,proto3,oneof"`
}

type AutomationRun_RepairRolloutOperation struct {
	// Output only. Repairs a failed 'Rollout'.
	RepairRolloutOperation *RepairRolloutOperation `protobuf:"bytes,17,opt,name=repair_rollout_operation,json=repairRolloutOperation,proto3,oneof"`
}

func (*AutomationRun_PromoteReleaseOperation) isAutomationRun_Operation() {}

func (*AutomationRun_AdvanceRolloutOperation) isAutomationRun_Operation() {}

func (*AutomationRun_RepairRolloutOperation) isAutomationRun_Operation() {}

// Contains the information of an automated promote-release operation.
type PromoteReleaseOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the target that represents the promotion stage to
	// which the release will be promoted. The value of this field is the last
	// segment of a target name.
	TargetId string `protobuf:"bytes,1,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Output only. How long the operation will be paused.
	Wait *durationpb.Duration `protobuf:"bytes,2,opt,name=wait,proto3" json:"wait,omitempty"`
	// Output only. The name of the rollout that initiates the `AutomationRun`.
	Rollout string `protobuf:"bytes,3,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Output only. The starting phase of the rollout created by this operation.
	Phase string `protobuf:"bytes,4,opt,name=phase,proto3" json:"phase,omitempty"`
}

func (x *PromoteReleaseOperation) Reset() {
	*x = PromoteReleaseOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PromoteReleaseOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromoteReleaseOperation) ProtoMessage() {}

func (x *PromoteReleaseOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromoteReleaseOperation.ProtoReflect.Descriptor instead.
func (*PromoteReleaseOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{128}
}

func (x *PromoteReleaseOperation) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *PromoteReleaseOperation) GetWait() *durationpb.Duration {
	if x != nil {
		return x.Wait
	}
	return nil
}

func (x *PromoteReleaseOperation) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *PromoteReleaseOperation) GetPhase() string {
	if x != nil {
		return x.Phase
	}
	return ""
}

// Contains the information of an automated advance-rollout operation.
type AdvanceRolloutOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The phase of a deployment that initiated the operation.
	SourcePhase string `protobuf:"bytes,5,opt,name=source_phase,json=sourcePhase,proto3" json:"source_phase,omitempty"`
	// Output only. How long the operation will be paused.
	Wait *durationpb.Duration `protobuf:"bytes,2,opt,name=wait,proto3" json:"wait,omitempty"`
	// Output only. The name of the rollout that initiates the `AutomationRun`.
	Rollout string `protobuf:"bytes,3,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Output only. The phase the rollout will be advanced to.
	DestinationPhase string `protobuf:"bytes,4,opt,name=destination_phase,json=destinationPhase,proto3" json:"destination_phase,omitempty"`
}

func (x *AdvanceRolloutOperation) Reset() {
	*x = AdvanceRolloutOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvanceRolloutOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvanceRolloutOperation) ProtoMessage() {}

func (x *AdvanceRolloutOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvanceRolloutOperation.ProtoReflect.Descriptor instead.
func (*AdvanceRolloutOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{129}
}

func (x *AdvanceRolloutOperation) GetSourcePhase() string {
	if x != nil {
		return x.SourcePhase
	}
	return ""
}

func (x *AdvanceRolloutOperation) GetWait() *durationpb.Duration {
	if x != nil {
		return x.Wait
	}
	return nil
}

func (x *AdvanceRolloutOperation) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *AdvanceRolloutOperation) GetDestinationPhase() string {
	if x != nil {
		return x.DestinationPhase
	}
	return ""
}

// Contains the information for an automated `repair rollout` operation.
type RepairRolloutOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the rollout that initiates the `AutomationRun`.
	Rollout string `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Output only. The index of the current repair action in the repair sequence.
	CurrentRepairModeIndex int64 `protobuf:"varint,2,opt,name=current_repair_mode_index,json=currentRepairModeIndex,proto3" json:"current_repair_mode_index,omitempty"`
	// Output only. Records of the repair attempts. Each repair phase may have
	// multiple retry attempts or single rollback attempt.
	RepairPhases []*RepairPhase `protobuf:"bytes,3,rep,name=repair_phases,json=repairPhases,proto3" json:"repair_phases,omitempty"`
}

func (x *RepairRolloutOperation) Reset() {
	*x = RepairRolloutOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepairRolloutOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepairRolloutOperation) ProtoMessage() {}

func (x *RepairRolloutOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepairRolloutOperation.ProtoReflect.Descriptor instead.
func (*RepairRolloutOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{130}
}

func (x *RepairRolloutOperation) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *RepairRolloutOperation) GetCurrentRepairModeIndex() int64 {
	if x != nil {
		return x.CurrentRepairModeIndex
	}
	return 0
}

func (x *RepairRolloutOperation) GetRepairPhases() []*RepairPhase {
	if x != nil {
		return x.RepairPhases
	}
	return nil
}

// RepairPhase tracks the repair attempts that have been made for
// each `RepairMode` specified in the `Automation` resource.
type RepairPhase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RepairPhase:
	//
	//	*RepairPhase_Retry
	//	*RepairPhase_Rollback
	RepairPhase isRepairPhase_RepairPhase `protobuf_oneof:"repair_phase"`
}

func (x *RepairPhase) Reset() {
	*x = RepairPhase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepairPhase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepairPhase) ProtoMessage() {}

func (x *RepairPhase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepairPhase.ProtoReflect.Descriptor instead.
func (*RepairPhase) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{131}
}

func (m *RepairPhase) GetRepairPhase() isRepairPhase_RepairPhase {
	if m != nil {
		return m.RepairPhase
	}
	return nil
}

func (x *RepairPhase) GetRetry() *RetryPhase {
	if x, ok := x.GetRepairPhase().(*RepairPhase_Retry); ok {
		return x.Retry
	}
	return nil
}

func (x *RepairPhase) GetRollback() *RollbackAttempt {
	if x, ok := x.GetRepairPhase().(*RepairPhase_Rollback); ok {
		return x.Rollback
	}
	return nil
}

type isRepairPhase_RepairPhase interface {
	isRepairPhase_RepairPhase()
}

type RepairPhase_Retry struct {
	// Output only. Records of the retry attempts for retry repair mode.
	Retry *RetryPhase `protobuf:"bytes,1,opt,name=retry,proto3,oneof"`
}

type RepairPhase_Rollback struct {
	// Output only. Rollback attempt for rollback repair mode .
	Rollback *RollbackAttempt `protobuf:"bytes,2,opt,name=rollback,proto3,oneof"`
}

func (*RepairPhase_Retry) isRepairPhase_RepairPhase() {}

func (*RepairPhase_Rollback) isRepairPhase_RepairPhase() {}

// RetryPhase contains the retry attempts and the metadata for initiating a
// new attempt.
type RetryPhase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The number of attempts that have been made.
	TotalAttempts int64 `protobuf:"varint,1,opt,name=total_attempts,json=totalAttempts,proto3" json:"total_attempts,omitempty"`
	// Output only. The pattern of how the wait time of the retry attempt is
	// calculated.
	BackoffMode BackoffMode `protobuf:"varint,2,opt,name=backoff_mode,json=backoffMode,proto3,enum=google.cloud.deploy.v1.BackoffMode" json:"backoff_mode,omitempty"`
	// Output only. The phase ID of the phase that includes the job being retried.
	PhaseId string `protobuf:"bytes,3,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
	// Output only. The job ID for the Job to retry.
	JobId string `protobuf:"bytes,4,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Output only. Detail of a retry action.
	Attempts []*RetryAttempt `protobuf:"bytes,5,rep,name=attempts,proto3" json:"attempts,omitempty"`
}

func (x *RetryPhase) Reset() {
	*x = RetryPhase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryPhase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPhase) ProtoMessage() {}

func (x *RetryPhase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPhase.ProtoReflect.Descriptor instead.
func (*RetryPhase) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{132}
}

func (x *RetryPhase) GetTotalAttempts() int64 {
	if x != nil {
		return x.TotalAttempts
	}
	return 0
}

func (x *RetryPhase) GetBackoffMode() BackoffMode {
	if x != nil {
		return x.BackoffMode
	}
	return BackoffMode_BACKOFF_MODE_UNSPECIFIED
}

func (x *RetryPhase) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

func (x *RetryPhase) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *RetryPhase) GetAttempts() []*RetryAttempt {
	if x != nil {
		return x.Attempts
	}
	return nil
}

// RetryAttempt represents an action of retrying the failed Cloud Deploy job.
type RetryAttempt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The index of this retry attempt.
	Attempt int64 `protobuf:"varint,1,opt,name=attempt,proto3" json:"attempt,omitempty"`
	// Output only. How long the operation will be paused.
	Wait *durationpb.Duration `protobuf:"bytes,2,opt,name=wait,proto3" json:"wait,omitempty"`
	// Output only. Valid state of this retry action.
	State RepairState `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.deploy.v1.RepairState" json:"state,omitempty"`
	// Output only. Description of the state of the Retry.
	StateDesc string `protobuf:"bytes,6,opt,name=state_desc,json=stateDesc,proto3" json:"state_desc,omitempty"`
}

func (x *RetryAttempt) Reset() {
	*x = RetryAttempt{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryAttempt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryAttempt) ProtoMessage() {}

func (x *RetryAttempt) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryAttempt.ProtoReflect.Descriptor instead.
func (*RetryAttempt) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{133}
}

func (x *RetryAttempt) GetAttempt() int64 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

func (x *RetryAttempt) GetWait() *durationpb.Duration {
	if x != nil {
		return x.Wait
	}
	return nil
}

func (x *RetryAttempt) GetState() RepairState {
	if x != nil {
		return x.State
	}
	return RepairState_REPAIR_STATE_UNSPECIFIED
}

func (x *RetryAttempt) GetStateDesc() string {
	if x != nil {
		return x.StateDesc
	}
	return ""
}

// RollbackAttempt represents an action of rolling back a Cloud Deploy 'Target'.
type RollbackAttempt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The phase to which the rollout will be rolled back to.
	DestinationPhase string `protobuf:"bytes,1,opt,name=destination_phase,json=destinationPhase,proto3" json:"destination_phase,omitempty"`
	// Output only. ID of the rollback `Rollout` to create.
	RolloutId string `protobuf:"bytes,2,opt,name=rollout_id,json=rolloutId,proto3" json:"rollout_id,omitempty"`
	// Output only. Valid state of this rollback action.
	State RepairState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.deploy.v1.RepairState" json:"state,omitempty"`
	// Output only. Description of the state of the Rollback.
	StateDesc string `protobuf:"bytes,4,opt,name=state_desc,json=stateDesc,proto3" json:"state_desc,omitempty"`
}

func (x *RollbackAttempt) Reset() {
	*x = RollbackAttempt{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackAttempt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackAttempt) ProtoMessage() {}

func (x *RollbackAttempt) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackAttempt.ProtoReflect.Descriptor instead.
func (*RollbackAttempt) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{134}
}

func (x *RollbackAttempt) GetDestinationPhase() string {
	if x != nil {
		return x.DestinationPhase
	}
	return ""
}

func (x *RollbackAttempt) GetRolloutId() string {
	if x != nil {
		return x.RolloutId
	}
	return ""
}

func (x *RollbackAttempt) GetState() RepairState {
	if x != nil {
		return x.State
	}
	return RepairState_REPAIR_STATE_UNSPECIFIED
}

func (x *RollbackAttempt) GetStateDesc() string {
	if x != nil {
		return x.StateDesc
	}
	return ""
}

// The request object for `ListAutomationRuns`.
type ListAutomationRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent `Delivery Pipeline`, which owns this collection of
	// automationRuns. Format must be
	// `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of automationRuns to return. The service may return
	// fewer than this value. If unspecified, at most 50 automationRuns will
	// be returned. The maximum value is 1000; values above 1000 will be set
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAutomationRuns` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter automationRuns to be returned. All fields can be used in the
	// filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAutomationRunsRequest) Reset() {
	*x = ListAutomationRunsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAutomationRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutomationRunsRequest) ProtoMessage() {}

func (x *ListAutomationRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutomationRunsRequest.ProtoReflect.Descriptor instead.
func (*ListAutomationRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{135}
}

func (x *ListAutomationRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAutomationRunsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAutomationRunsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAutomationRunsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAutomationRunsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListAutomationRuns`.
type ListAutomationRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `AutomationRuns` objects.
	AutomationRuns []*AutomationRun `protobuf:"bytes,1,rep,name=automation_runs,json=automationRuns,proto3" json:"automation_runs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListAutomationRunsResponse) Reset() {
	*x = ListAutomationRunsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAutomationRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutomationRunsResponse) ProtoMessage() {}

func (x *ListAutomationRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutomationRunsResponse.ProtoReflect.Descriptor instead.
func (*ListAutomationRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{136}
}

func (x *ListAutomationRunsResponse) GetAutomationRuns() []*AutomationRun {
	if x != nil {
		return x.AutomationRuns
	}
	return nil
}

func (x *ListAutomationRunsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAutomationRunsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetAutomationRun`
type GetAutomationRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `AutomationRun`. Format must be
	// `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAutomationRunRequest) Reset() {
	*x = GetAutomationRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAutomationRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAutomationRunRequest) ProtoMessage() {}

func (x *GetAutomationRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAutomationRunRequest.ProtoReflect.Descriptor instead.
func (*GetAutomationRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{137}
}

func (x *GetAutomationRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object used by `CancelAutomationRun`.
type CancelAutomationRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `AutomationRun`. Format is
	// `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelAutomationRunRequest) Reset() {
	*x = CancelAutomationRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelAutomationRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelAutomationRunRequest) ProtoMessage() {}

func (x *CancelAutomationRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelAutomationRunRequest.ProtoReflect.Descriptor instead.
func (*CancelAutomationRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{138}
}

func (x *CancelAutomationRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response object from `CancelAutomationRun`.
type CancelAutomationRunResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelAutomationRunResponse) Reset() {
	*x = CancelAutomationRunResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelAutomationRunResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelAutomationRunResponse) ProtoMessage() {}

func (x *CancelAutomationRunResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelAutomationRunResponse.ProtoReflect.Descriptor instead.
func (*CancelAutomationRunResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{139}
}

// PhaseConfig represents the configuration for a phase in the custom
// canary deployment.
type CustomCanaryDeployment_PhaseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID to assign to the `Rollout` phase.
	// This value must consist of lower-case letters, numbers, and hyphens,
	// start with a letter and end with a letter or a number, and have a max
	// length of 63 characters. In other words, it must match the following
	// regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
	PhaseId string `protobuf:"bytes,1,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
	// Required. Percentage deployment for the phase.
	Percentage int32 `protobuf:"varint,2,opt,name=percentage,proto3" json:"percentage,omitempty"`
	// Skaffold profiles to use when rendering the manifest for this phase.
	// These are in addition to the profiles list specified in the
	// `DeliveryPipeline` stage.
	Profiles []string `protobuf:"bytes,3,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// Whether to run verify tests after the deployment.
	Verify bool `protobuf:"varint,4,opt,name=verify,proto3" json:"verify,omitempty"`
	// Optional. Configuration for the predeploy job of this phase. If this is
	// not configured, there will be no predeploy job for this phase.
	Predeploy *Predeploy `protobuf:"bytes,5,opt,name=predeploy,proto3" json:"predeploy,omitempty"`
	// Optional. Configuration for the postdeploy job of this phase. If this is
	// not configured, there will be no postdeploy job for this phase.
	Postdeploy *Postdeploy `protobuf:"bytes,6,opt,name=postdeploy,proto3" json:"postdeploy,omitempty"`
}

func (x *CustomCanaryDeployment_PhaseConfig) Reset() {
	*x = CustomCanaryDeployment_PhaseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomCanaryDeployment_PhaseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomCanaryDeployment_PhaseConfig) ProtoMessage() {}

func (x *CustomCanaryDeployment_PhaseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomCanaryDeployment_PhaseConfig.ProtoReflect.Descriptor instead.
func (*CustomCanaryDeployment_PhaseConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{10, 0}
}

func (x *CustomCanaryDeployment_PhaseConfig) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

func (x *CustomCanaryDeployment_PhaseConfig) GetPercentage() int32 {
	if x != nil {
		return x.Percentage
	}
	return 0
}

func (x *CustomCanaryDeployment_PhaseConfig) GetProfiles() []string {
	if x != nil {
		return x.Profiles
	}
	return nil
}

func (x *CustomCanaryDeployment_PhaseConfig) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *CustomCanaryDeployment_PhaseConfig) GetPredeploy() *Predeploy {
	if x != nil {
		return x.Predeploy
	}
	return nil
}

func (x *CustomCanaryDeployment_PhaseConfig) GetPostdeploy() *Postdeploy {
	if x != nil {
		return x.Postdeploy
	}
	return nil
}

// Information about the Kubernetes Gateway API service mesh configuration.
type KubernetesConfig_GatewayServiceMesh struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Gateway API HTTPRoute.
	HttpRoute string `protobuf:"bytes,1,opt,name=http_route,json=httpRoute,proto3" json:"http_route,omitempty"`
	// Required. Name of the Kubernetes Service.
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// Required. Name of the Kubernetes Deployment whose traffic is managed by
	// the specified HTTPRoute and Service.
	Deployment string `protobuf:"bytes,3,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Optional. The time to wait for route updates to propagate. The maximum
	// configurable time is 3 hours, in seconds format. If unspecified, there is
	// no wait time.
	RouteUpdateWaitTime *durationpb.Duration `protobuf:"bytes,4,opt,name=route_update_wait_time,json=routeUpdateWaitTime,proto3" json:"route_update_wait_time,omitempty"`
	// Optional. The amount of time to migrate traffic back from the canary
	// Service to the original Service during the stable phase deployment. If
	// specified, must be between 15s and 3600s. If unspecified, there is no
	// cutback time.
	StableCutbackDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=stable_cutback_duration,json=stableCutbackDuration,proto3" json:"stable_cutback_duration,omitempty"`
}

func (x *KubernetesConfig_GatewayServiceMesh) Reset() {
	*x = KubernetesConfig_GatewayServiceMesh{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesConfig_GatewayServiceMesh) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesConfig_GatewayServiceMesh) ProtoMessage() {}

func (x *KubernetesConfig_GatewayServiceMesh) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesConfig_GatewayServiceMesh.ProtoReflect.Descriptor instead.
func (*KubernetesConfig_GatewayServiceMesh) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{11, 0}
}

func (x *KubernetesConfig_GatewayServiceMesh) GetHttpRoute() string {
	if x != nil {
		return x.HttpRoute
	}
	return ""
}

func (x *KubernetesConfig_GatewayServiceMesh) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *KubernetesConfig_GatewayServiceMesh) GetDeployment() string {
	if x != nil {
		return x.Deployment
	}
	return ""
}

func (x *KubernetesConfig_GatewayServiceMesh) GetRouteUpdateWaitTime() *durationpb.Duration {
	if x != nil {
		return x.RouteUpdateWaitTime
	}
	return nil
}

func (x *KubernetesConfig_GatewayServiceMesh) GetStableCutbackDuration() *durationpb.Duration {
	if x != nil {
		return x.StableCutbackDuration
	}
	return nil
}

// Information about the Kubernetes Service networking configuration.
type KubernetesConfig_ServiceNetworking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Kubernetes Service.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Required. Name of the Kubernetes Deployment whose traffic is managed by
	// the specified Service.
	Deployment string `protobuf:"bytes,2,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Optional. Whether to disable Pod overprovisioning. If Pod
	// overprovisioning is disabled then Cloud Deploy will limit the number of
	// total Pods used for the deployment strategy to the number of Pods the
	// Deployment has on the cluster.
	DisablePodOverprovisioning bool `protobuf:"varint,3,opt,name=disable_pod_overprovisioning,json=disablePodOverprovisioning,proto3" json:"disable_pod_overprovisioning,omitempty"`
}

func (x *KubernetesConfig_ServiceNetworking) Reset() {
	*x = KubernetesConfig_ServiceNetworking{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesConfig_ServiceNetworking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesConfig_ServiceNetworking) ProtoMessage() {}

func (x *KubernetesConfig_ServiceNetworking) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesConfig_ServiceNetworking.ProtoReflect.Descriptor instead.
func (*KubernetesConfig_ServiceNetworking) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{11, 1}
}

func (x *KubernetesConfig_ServiceNetworking) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *KubernetesConfig_ServiceNetworking) GetDeployment() string {
	if x != nil {
		return x.Deployment
	}
	return ""
}

func (x *KubernetesConfig_ServiceNetworking) GetDisablePodOverprovisioning() bool {
	if x != nil {
		return x.DisablePodOverprovisioning
	}
	return false
}

// Git repository containing Skaffold Config modules.
type SkaffoldModules_SkaffoldGitSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Git repository the package should be cloned from.
	Repo string `protobuf:"bytes,1,opt,name=repo,proto3" json:"repo,omitempty"`
	// Optional. Relative path from the repository root to the Skaffold file.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. Git ref the package should be cloned from.
	Ref string `protobuf:"bytes,3,opt,name=ref,proto3" json:"ref,omitempty"`
}

func (x *SkaffoldModules_SkaffoldGitSource) Reset() {
	*x = SkaffoldModules_SkaffoldGitSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[152]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkaffoldModules_SkaffoldGitSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkaffoldModules_SkaffoldGitSource) ProtoMessage() {}

func (x *SkaffoldModules_SkaffoldGitSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[152]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkaffoldModules_SkaffoldGitSource.ProtoReflect.Descriptor instead.
func (*SkaffoldModules_SkaffoldGitSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{44, 0}
}

func (x *SkaffoldModules_SkaffoldGitSource) GetRepo() string {
	if x != nil {
		return x.Repo
	}
	return ""
}

func (x *SkaffoldModules_SkaffoldGitSource) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *SkaffoldModules_SkaffoldGitSource) GetRef() string {
	if x != nil {
		return x.Ref
	}
	return ""
}

// Cloud Storage bucket containing Skaffold Config modules.
type SkaffoldModules_SkaffoldGCSSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage source paths to copy recursively. For example,
	// providing "gs://my-bucket/dir/configs/*" will result in Skaffold copying
	// all files within the "dir/configs" directory in the bucket "my-bucket".
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Optional. Relative path from the source to the Skaffold file.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *SkaffoldModules_SkaffoldGCSSource) Reset() {
	*x = SkaffoldModules_SkaffoldGCSSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[153]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkaffoldModules_SkaffoldGCSSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkaffoldModules_SkaffoldGCSSource) ProtoMessage() {}

func (x *SkaffoldModules_SkaffoldGCSSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[153]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkaffoldModules_SkaffoldGCSSource.ProtoReflect.Descriptor instead.
func (*SkaffoldModules_SkaffoldGCSSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{44, 1}
}

func (x *SkaffoldModules_SkaffoldGCSSource) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *SkaffoldModules_SkaffoldGCSSource) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Details of rendering for a single target.
type Release_TargetRender struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is
	// used to render the manifest for this target. Format is
	// `projects/{project}/locations/{location}/builds/{build}`.
	RenderingBuild string `protobuf:"bytes,1,opt,name=rendering_build,json=renderingBuild,proto3" json:"rendering_build,omitempty"`
	// Output only. Current state of the render operation for this Target.
	RenderingState Release_TargetRender_TargetRenderState `protobuf:"varint,2,opt,name=rendering_state,json=renderingState,proto3,enum=google.cloud.deploy.v1.Release_TargetRender_TargetRenderState" json:"rendering_state,omitempty"`
	// Output only. Metadata related to the `Release` render for this Target.
	Metadata *RenderMetadata `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. Reason this render failed. This will always be unspecified
	// while the render in progress.
	FailureCause Release_TargetRender_FailureCause `protobuf:"varint,4,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.Release_TargetRender_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the render failure, if
	// available.
	FailureMessage string `protobuf:"bytes,5,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
}

func (x *Release_TargetRender) Reset() {
	*x = Release_TargetRender{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Release_TargetRender) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Release_TargetRender) ProtoMessage() {}

func (x *Release_TargetRender) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Release_TargetRender.ProtoReflect.Descriptor instead.
func (*Release_TargetRender) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52, 0}
}

func (x *Release_TargetRender) GetRenderingBuild() string {
	if x != nil {
		return x.RenderingBuild
	}
	return ""
}

func (x *Release_TargetRender) GetRenderingState() Release_TargetRender_TargetRenderState {
	if x != nil {
		return x.RenderingState
	}
	return Release_TargetRender_TARGET_RENDER_STATE_UNSPECIFIED
}

func (x *Release_TargetRender) GetMetadata() *RenderMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Release_TargetRender) GetFailureCause() Release_TargetRender_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return Release_TargetRender_FAILURE_CAUSE_UNSPECIFIED
}

func (x *Release_TargetRender) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

// ReleaseReadyCondition contains information around the status of the
// Release. If a release is not ready, you cannot create a rollout with the
// release.
type Release_ReleaseReadyCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the Release is in a valid state. Otherwise at least one condition
	// in `ReleaseCondition` is in an invalid state. Iterate over those
	// conditions and see which condition(s) has status = false to find out what
	// is wrong with the Release.
	Status bool `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *Release_ReleaseReadyCondition) Reset() {
	*x = Release_ReleaseReadyCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[156]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Release_ReleaseReadyCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Release_ReleaseReadyCondition) ProtoMessage() {}

func (x *Release_ReleaseReadyCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[156]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Release_ReleaseReadyCondition.ProtoReflect.Descriptor instead.
func (*Release_ReleaseReadyCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52, 1}
}

func (x *Release_ReleaseReadyCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

// SkaffoldSupportedCondition contains information about when support for the
// release's version of Skaffold ends.
type Release_SkaffoldSupportedCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the version of Skaffold used by this release is supported.
	Status bool `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	// The Skaffold support state for this release's version of Skaffold.
	SkaffoldSupportState SkaffoldSupportState `protobuf:"varint,2,opt,name=skaffold_support_state,json=skaffoldSupportState,proto3,enum=google.cloud.deploy.v1.SkaffoldSupportState" json:"skaffold_support_state,omitempty"`
	// The time at which this release's version of Skaffold will enter
	// maintenance mode.
	MaintenanceModeTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=maintenance_mode_time,json=maintenanceModeTime,proto3" json:"maintenance_mode_time,omitempty"`
	// The time at which this release's version of Skaffold will no longer be
	// supported.
	SupportExpirationTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=support_expiration_time,json=supportExpirationTime,proto3" json:"support_expiration_time,omitempty"`
}

func (x *Release_SkaffoldSupportedCondition) Reset() {
	*x = Release_SkaffoldSupportedCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[157]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Release_SkaffoldSupportedCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Release_SkaffoldSupportedCondition) ProtoMessage() {}

func (x *Release_SkaffoldSupportedCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[157]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Release_SkaffoldSupportedCondition.ProtoReflect.Descriptor instead.
func (*Release_SkaffoldSupportedCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52, 2}
}

func (x *Release_SkaffoldSupportedCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *Release_SkaffoldSupportedCondition) GetSkaffoldSupportState() SkaffoldSupportState {
	if x != nil {
		return x.SkaffoldSupportState
	}
	return SkaffoldSupportState_SKAFFOLD_SUPPORT_STATE_UNSPECIFIED
}

func (x *Release_SkaffoldSupportedCondition) GetMaintenanceModeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MaintenanceModeTime
	}
	return nil
}

func (x *Release_SkaffoldSupportedCondition) GetSupportExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SupportExpirationTime
	}
	return nil
}

// ReleaseCondition contains all conditions relevant to a Release.
type Release_ReleaseCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details around the Releases's overall status.
	ReleaseReadyCondition *Release_ReleaseReadyCondition `protobuf:"bytes,1,opt,name=release_ready_condition,json=releaseReadyCondition,proto3" json:"release_ready_condition,omitempty"`
	// Details around the support state of the release's Skaffold
	// version.
	SkaffoldSupportedCondition *Release_SkaffoldSupportedCondition `protobuf:"bytes,2,opt,name=skaffold_supported_condition,json=skaffoldSupportedCondition,proto3" json:"skaffold_supported_condition,omitempty"`
}

func (x *Release_ReleaseCondition) Reset() {
	*x = Release_ReleaseCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[158]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Release_ReleaseCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Release_ReleaseCondition) ProtoMessage() {}

func (x *Release_ReleaseCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[158]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Release_ReleaseCondition.ProtoReflect.Descriptor instead.
func (*Release_ReleaseCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52, 3}
}

func (x *Release_ReleaseCondition) GetReleaseReadyCondition() *Release_ReleaseReadyCondition {
	if x != nil {
		return x.ReleaseReadyCondition
	}
	return nil
}

func (x *Release_ReleaseCondition) GetSkaffoldSupportedCondition() *Release_SkaffoldSupportedCondition {
	if x != nil {
		return x.SkaffoldSupportedCondition
	}
	return nil
}

// Contains the paths to the artifacts, relative to the URI, for a phase.
type TargetArtifact_PhaseArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. File path of the resolved Skaffold configuration relative to
	// the URI.
	SkaffoldConfigPath string `protobuf:"bytes,1,opt,name=skaffold_config_path,json=skaffoldConfigPath,proto3" json:"skaffold_config_path,omitempty"`
	// Output only. File path of the rendered manifest relative to the URI.
	ManifestPath string `protobuf:"bytes,3,opt,name=manifest_path,json=manifestPath,proto3" json:"manifest_path,omitempty"`
	// Output only. File path of the directory of rendered job manifests
	// relative to the URI. This is only set if it is applicable.
	JobManifestsPath string `protobuf:"bytes,4,opt,name=job_manifests_path,json=jobManifestsPath,proto3" json:"job_manifests_path,omitempty"`
}

func (x *TargetArtifact_PhaseArtifact) Reset() {
	*x = TargetArtifact_PhaseArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[164]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetArtifact_PhaseArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetArtifact_PhaseArtifact) ProtoMessage() {}

func (x *TargetArtifact_PhaseArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[164]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetArtifact_PhaseArtifact.ProtoReflect.Descriptor instead.
func (*TargetArtifact_PhaseArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{54, 0}
}

func (x *TargetArtifact_PhaseArtifact) GetSkaffoldConfigPath() string {
	if x != nil {
		return x.SkaffoldConfigPath
	}
	return ""
}

func (x *TargetArtifact_PhaseArtifact) GetManifestPath() string {
	if x != nil {
		return x.ManifestPath
	}
	return ""
}

func (x *TargetArtifact_PhaseArtifact) GetJobManifestsPath() string {
	if x != nil {
		return x.JobManifestsPath
	}
	return ""
}

var File_google_cloud_deploy_v1_cloud_deploy_proto protoreflect.FileDescriptor

var file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xee, 0x06, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x69, 0x61, 0x6c, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x4c, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x1c,
	0x0a, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x1a, 0x3e, 0x0a, 0x10,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x2b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x42, 0x0a, 0x0a, 0x08, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x22, 0x47, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x67, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x22, 0xdf, 0x01,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x12, 0x41, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x12, 0x5a, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22,
	0xdc, 0x02, 0x0a, 0x10, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x74, 0x0a, 0x13, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a,
	0x0b, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x44, 0x0a, 0x16, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9b,
	0x01, 0x0a, 0x08, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x3e, 0x0a, 0x08, 0x73,
	0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x48,
	0x00, 0x52, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x12, 0x38, 0x0a, 0x06, 0x63,
	0x61, 0x6e, 0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x06, 0x63,
	0x61, 0x6e, 0x61, 0x72, 0x79, 0x42, 0x15, 0x0a, 0x13, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x2a, 0x0a, 0x09,
	0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x2b, 0x0a, 0x0a, 0x50, 0x6f, 0x73, 0x74,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb1, 0x01, 0x0a, 0x08, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61,
	0x72, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x44, 0x0a, 0x09, 0x70, 0x72,
	0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x12, 0x47, 0x0a, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70,
	0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x22, 0xa8, 0x02, 0x0a, 0x06, 0x43, 0x61,
	0x6e, 0x61, 0x72, 0x79, 0x12, 0x51, 0x0a, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x11, 0x63, 0x61, 0x6e, 0x61, 0x72,
	0x79, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x61,
	0x72, 0x79, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x10,
	0x63, 0x61, 0x6e, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x6a, 0x0a, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6e, 0x61, 0x72,
	0x79, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x48, 0x00, 0x52, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6e, 0x61,
	0x72, 0x79, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x06, 0x0a, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x22, 0xe0, 0x01, 0x0a, 0x10, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x79, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x44, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x47,
	0x0a, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x6f, 0x73,
	0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x22, 0x96, 0x03, 0x0a, 0x16, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x64, 0x0a, 0x0d, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x79, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x70, 0x68, 0x61, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x95, 0x02, 0x0a, 0x0b, 0x50, 0x68, 0x61,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x70, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x12, 0x44, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x72,
	0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x22, 0xd3, 0x05, 0x0a, 0x10, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x14, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x68,
	0x48, 0x00, 0x52, 0x12, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4d, 0x65, 0x73, 0x68, 0x12, 0x6b, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x48, 0x00,
	0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x1a, 0xa9, 0x02, 0x0a, 0x12, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x68, 0x12, 0x22, 0x0a, 0x0a, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x68, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x1d,
	0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x23, 0x0a,
	0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x53, 0x0a, 0x16, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57,
	0x61, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x17, 0x73, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x75, 0x74, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x75, 0x74, 0x62, 0x61, 0x63, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x9e, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x1c, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x6f, 0x64,
	0x4f, 0x76, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x42, 0x14, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xef, 0x01, 0x0a, 0x0e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x19, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x35, 0x0a, 0x14, 0x63, 0x61, 0x6e, 0x61, 0x72, 0x79, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x61, 0x6e, 0x61, 0x72, 0x79,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73, 0x12, 0x33, 0x0a, 0x13,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67,
	0x73, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73, 0x22, 0xb4, 0x01, 0x0a, 0x0d, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x0a, 0x6b, 0x75,
	0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0a, 0x6b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x09, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x72, 0x75, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x42, 0x10, 0x0a,
	0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x6d, 0x0a, 0x16, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x61, 0x64, 0x79,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xbf,
	0x01, 0x0a, 0x17, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x4f, 0x0a, 0x0f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x0e, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x53, 0x0a, 0x14, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x54, 0x79, 0x70, 0x65, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xce, 0x02, 0x0a, 0x11, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x18, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x61, 0x64, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x61, 0x64, 0x79, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x19, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x16, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xda, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xc2, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x11, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xcd, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35,
	0x0a, 0x14, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x5a, 0x0a, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22,
	0xb5, 0x02, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x94, 0x02, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x87,
	0x01, 0x0a, 0x14, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x22, 0x86, 0x03, 0x0a, 0x15, 0x52, 0x6f, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x14, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x5f, 0x74, 0x6f, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x54, 0x6f, 0x52, 0x6f, 0x6c, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x12, 0x5a, 0x0a, 0x0f, 0x72,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c,
	0x79, 0x22, 0x6f, 0x0a, 0x16, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0f, 0x72,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0e, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0xda, 0x0a, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x03, 0x67,
	0x6b, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x03, 0x67, 0x6b, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x61, 0x6e, 0x74, 0x68,
	0x6f, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x74, 0x68, 0x6f, 0x73,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d,
	0x61, 0x6e, 0x74, 0x68, 0x6f, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x41, 0x0a,
	0x03, 0x72, 0x75, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x03, 0x72, 0x75, 0x6e,
	0x12, 0x4d, 0x0a, 0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x0b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x50, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x54, 0x0a, 0x11, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18,
	0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0x66, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x43, 0x0a, 0x15, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x60, 0xea, 0x41, 0x5d, 0x0a, 0x21, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22,
	0xb0, 0x05, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x06, 0x75, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x4d, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x4d, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c,
	0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e,
	0x0a, 0x10, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x4b,
	0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x8b, 0x01, 0x0a, 0x19,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2b, 0x0a, 0x27, 0x45, 0x58, 0x45,
	0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4e, 0x44, 0x45, 0x52,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52,
	0x45, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x53,
	0x54, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x10, 0x05, 0x42, 0x17, 0x0a, 0x15, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x6b, 0x0a, 0x0b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x2e, 0x0a, 0x10, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x22,
	0xba, 0x01, 0x0a, 0x0b, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x4d, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2c,
	0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x22, 0x73, 0x0a, 0x0a,
	0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x07, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49,
	0x70, 0x22, 0x56, 0x0a, 0x0d, 0x41, 0x6e, 0x74, 0x68, 0x6f, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x45, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x0a, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x22, 0x59, 0x0a, 0x10, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x52, 0x75, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x31, 0x0a, 0x0b, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x73, 0x22, 0x71, 0x0a, 0x0c, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x61, 0x0a, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x99, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x38, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x8c,
	0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xe5, 0x01,
	0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x17, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xdd, 0x06, 0x0a, 0x10, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x51, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x5c, 0x0a, 0x0e, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c,
	0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x42, 0x0c, 0x0a, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd9, 0x01, 0x0a, 0x1b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x28, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x18, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x22, 0xa1, 0x03, 0x0a, 0x0f, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x12, 0x4d, 0x0a, 0x03, 0x67, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66,
	0x6f, 0x6c, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66,
	0x6f, 0x6c, 0x64, 0x47, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x03,
	0x67, 0x69, 0x74, 0x12, 0x6d, 0x0a, 0x14, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66,
	0x6f, 0x6c, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66,
	0x6f, 0x6c, 0x64, 0x47, 0x43, 0x53, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x12,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x1a, 0x5c, 0x0a, 0x11, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x47, 0x69,
	0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x72, 0x65, 0x70, 0x6f, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x72, 0x65, 0x70, 0x6f,
	0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x15, 0x0a, 0x03, 0x72, 0x65, 0x66,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x72, 0x65, 0x66,
	0x1a, 0x49, 0x0a, 0x11, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x47, 0x43, 0x53, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xee, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc3, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x13, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x65, 0x0a, 0x1a,
	0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xcf, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x36, 0x0a, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x12, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xb6, 0x02, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5b, 0x0a, 0x12, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xf9,
	0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c,
	0x79, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xa9, 0x01, 0x0a, 0x0f, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x4b,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf9, 0x1b, 0x0a, 0x07, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a,
	0x09, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x64,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f,
	0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x47, 0x0a, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x6b, 0x61, 0x66,
	0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x55, 0x72, 0x69, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x6b, 0x61, 0x66,
	0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x4e, 0x0a, 0x0f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x0e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x6b, 0x0a, 0x1a, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x4e, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0x6e, 0x0a, 0x1c, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0x53, 0x0a, 0x0c, 0x72, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x52,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x12, 0x29, 0x0a, 0x10, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6b, 0x61, 0x66,
	0x66, 0x6f, 0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x10, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18,
	0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x12, 0x5e, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x53, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x18,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a,
	0x9c, 0x06, 0x0a, 0x0c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x12, 0x50, 0x0a, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x52, 0x0e, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x12, 0x6c, 0x0a, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x47, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x63, 0x0a, 0x0d, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x64, 0x0a, 0x11,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x23, 0x0a, 0x1f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x52, 0x45, 0x4e, 0x44,
	0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x10, 0x03, 0x22, 0x89, 0x02, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61,
	0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x43,
	0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c,
	0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42,
	0x55, 0x49, 0x4c, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f,
	0x55, 0x4e, 0x44, 0x10, 0x05, 0x12, 0x25, 0x0a, 0x21, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x20, 0x0a, 0x1c,
	0x52, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x07, 0x1a, 0x2f,
	0x0a, 0x15, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x61, 0x64, 0x79, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a,
	0xbc, 0x02, 0x0a, 0x1a, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x62, 0x0a, 0x16, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f,
	0x6c, 0x64, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x14, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x15, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x13, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x17, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xff,
	0x01, 0x0a, 0x10, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x17, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x72,
	0x65, 0x61, 0x64, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x61,
	0x64, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x61, 0x64, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x7c, 0x0a, 0x1c, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f,
	0x6c, 0x64, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6a, 0x0a, 0x14, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6e, 0x0a, 0x12, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x43, 0x0a, 0x15, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x57, 0x0a, 0x0b,
	0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x52,
	0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x10, 0x03, 0x3a, 0x8a, 0x01, 0xea, 0x41, 0x86, 0x01, 0x0a, 0x22, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x12, 0x60, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x2f,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x7d, 0x22, 0x37, 0x0a, 0x0d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67, 0x22, 0xab, 0x04, 0x0a, 0x0e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x28,
	0x0a, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6b, 0x61, 0x66,
	0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x6b, 0x61,
	0x66, 0x66, 0x6f, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x28, 0x0a, 0x0d, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x68, 0x0a, 0x0f, 0x70, 0x68, 0x61,
	0x73, 0x65, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x50, 0x68, 0x61, 0x73, 0x65,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x68, 0x61, 0x73, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x73, 0x1a, 0xa3, 0x01, 0x0a, 0x0d, 0x50, 0x68, 0x61, 0x73, 0x65, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f,
	0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x28, 0x0a, 0x0d,
	0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x31, 0x0a, 0x12, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6a, 0x6f, 0x62, 0x4d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x73, 0x50, 0x61, 0x74, 0x68, 0x1a, 0x77, 0x0a, 0x13, 0x50, 0x68, 0x61,
	0x73, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x4a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0x05, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x22, 0x64, 0x0a, 0x0e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x2a, 0x0a, 0x0e, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x73, 0x22,
	0x56, 0x0a, 0x16, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3c, 0x0a, 0x07, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x03, 0xfa,
	0x41, 0x1c, 0x0a, 0x1a, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x50, 0x0a, 0x09, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x12, 0x43, 0x0a, 0x06,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x22, 0xe5, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9d, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95,
	0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x07, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x9a, 0x11, 0x0a, 0x07, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x42, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x65, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x6e, 0x71, 0x75,
	0x65, 0x75, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a,
	0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x59, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0e,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x0e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x63,
	0x0a, 0x14, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x12, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61,
	0x75, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x68, 0x61, 0x73, 0x65, 0x73, 0x18, 0x17, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x61,
	0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x70, 0x68, 0x61, 0x73, 0x65, 0x73, 0x12,
	0x41, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x18, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x5f, 0x6f, 0x66, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x1a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x4f, 0x66, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x3a, 0x0a, 0x17, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x62, 0x79, 0x5f, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x14, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x42, 0x79, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x7b, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x45, 0x45, 0x44, 0x53, 0x5f, 0x41, 0x50, 0x50,
	0x52, 0x4f, 0x56, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x4f, 0x45, 0x53, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x4e, 0x45, 0x45, 0x44, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41,
	0x4c, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22,
	0xc4, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c,
	0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x52,
	0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x41,
	0x4c, 0x54, 0x45, 0x44, 0x10, 0x0a, 0x22, 0x8a, 0x02, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55,
	0x52, 0x45, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f,
	0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x41,
	0x44, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f,
	0x41, 0x42, 0x41, 0x4e, 0x44, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x05, 0x12, 0x21, 0x0a, 0x1d, 0x56,
	0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46,
	0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x06, 0x12, 0x1e,
	0x0a, 0x1a, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x23,
	0x0a, 0x1f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x45, 0x41, 0x54,
	0x55, 0x52, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x08, 0x3a, 0x9d, 0x01, 0xea, 0x41, 0x99, 0x01, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x73,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x7d,
	0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x7d, 0x22, 0xf3, 0x01, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x4a, 0x0a, 0x09, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x12, 0x56, 0x0a, 0x0a,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x22, 0x85, 0x02, 0x0a, 0x14, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x4a, 0x0a, 0x09, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x12, 0x5c,
	0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x43, 0x0a, 0x06,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x22, 0xcb, 0x01, 0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3c, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1c, 0x0a,
	0x1a, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x75, 0x72, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x08,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a,
	0x03, 0x6a, 0x6f, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xe0, 0x41, 0x03, 0xfa,
	0x41, 0x18, 0x0a, 0x16, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22,
	0x44, 0x0a, 0x1a, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x26, 0x0a,
	0x0c, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x6b, 0x69, 0x70, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x19, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x12, 0x3b,
	0x0a, 0x17, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x39, 0x0a, 0x16, 0x72,
	0x65, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x14, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x0e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4f, 0x0a, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb6, 0x03, 0x0a, 0x05, 0x50, 0x68, 0x61, 0x73, 0x65, 0x12,
	0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x61,
	0x73, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x73, 0x6b, 0x69, 0x70, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x56, 0x0a, 0x0f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x4a, 0x6f, 0x62, 0x73, 0x12, 0x5d, 0x0a, 0x12, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x10, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a,
	0x6f, 0x62, 0x73, 0x22, 0x71, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07,
	0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x42, 0x06, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x22, 0xa2,
	0x02, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4a, 0x6f, 0x62,
	0x73, 0x12, 0x3f, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a,
	0x6f, 0x62, 0x12, 0x3f, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x6a, 0x6f, 0x62,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x4a, 0x6f, 0x62, 0x12, 0x45, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x70, 0x72,
	0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x47, 0x0a, 0x0e, 0x70, 0x6f,
	0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x4a, 0x6f, 0x62, 0x22, 0xb8, 0x01, 0x0a, 0x10, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x50, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x52, 0x0a, 0x14, 0x61, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6a, 0x6f,
	0x62, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x22, 0xf9,
	0x06, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3c, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x6b, 0x69,
	0x70, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x6b, 0x69, 0x70, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x42, 0x0a, 0x07, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x6a,
	0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f,
	0x6a, 0x6f, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x00, 0x52, 0x09, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x47,
	0x0a, 0x0a, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x09, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x50, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x72, 0x65,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x53, 0x0a, 0x0e, 0x70, 0x6f, 0x73,
	0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x0d, 0x70, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x6d,
	0x0a, 0x18, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x72,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x70, 0x0a,
	0x19, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x72,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x16, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x22,
	0x8c, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x42, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x07, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x08, 0x42, 0x0a,
	0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x0b, 0x0a, 0x09, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x22, 0x0b, 0x0a, 0x09, 0x56, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x4a, 0x6f, 0x62, 0x22, 0x2d, 0x0a, 0x0c, 0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x2e, 0x0a, 0x0d, 0x50, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x17, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x22, 0x18, 0x0a, 0x16,
	0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x22, 0xdc, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9d, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b,
	0x0a, 0x08, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x52, 0x08, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x02, 0x0a, 0x14, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x07, 0x72,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x50, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76,
	0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b,
	0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x78, 0x0a, 0x15, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x22, 0x18, 0x0a, 0x16,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x77, 0x0a, 0x15, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1e, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x22,
	0x18, 0x0a, 0x16, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x0a, 0x14, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x17, 0x0a, 0x15, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x10, 0x49,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x07, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x68,
	0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49,
	0x64, 0x22, 0x13, 0x0a, 0x11, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x72, 0x79,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x12, 0x1e, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64,
	0x12, 0x1a, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0x12, 0x0a, 0x10,
	0x52, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x57, 0x0a, 0x15, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x18, 0x0a, 0x16, 0x41, 0x62, 0x61,
	0x6e, 0x64, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x8c, 0x0a, 0x0a, 0x06, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x1e,
	0x0a, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x1a,
	0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x51, 0x0a, 0x0e,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x0c, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12,
	0x5a, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62,
	0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x5d, 0x0a, 0x12, 0x70,
	0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75,
	0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x77, 0x0a, 0x1c, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x52,
	0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x18, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x12, 0x7a, 0x0a, 0x1d, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x68, 0x69, 0x6c, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6a, 0x6f, 0x62,
	0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x69, 0x6c, 0x64,
	0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x19, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12,
	0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x6b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50,
	0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x05, 0x3a, 0xaf, 0x01, 0xea, 0x41, 0xab, 0x01, 0x0a, 0x21, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12,
	0x85, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x2f,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x7d, 0x42, 0x09, 0x0a, 0x07, 0x6a, 0x6f, 0x62, 0x5f, 0x72,
	0x75, 0x6e, 0x22, 0xce, 0x04, 0x0a, 0x0c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x12, 0x3d, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x05, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x12, 0x5b, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61,
	0x75, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x2e,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12,
	0x2c, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x4d, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a,
	0x6f, 0x62, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x47, 0x0a, 0x08,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0xdb, 0x01, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52,
	0x45, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42,
	0x55, 0x49, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x41, 0x44,
	0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x20, 0x0a, 0x1c, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x53, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x43, 0x41, 0x4e, 0x41, 0x52, 0x59, 0x10,
	0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44,
	0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x05, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x5f, 0x46, 0x45, 0x41, 0x54,
	0x55, 0x52, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x06, 0x22, 0xe8, 0x03, 0x0a, 0x0c, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f,
	0x62, 0x52, 0x75, 0x6e, 0x12, 0x3d, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x05, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x0e, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4c,
	0x6f, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x5b, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61,
	0x75, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0xba, 0x01, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75,
	0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x43, 0x41,
	0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44,
	0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x14,
	0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x41, 0x44, 0x4c, 0x49, 0x4e, 0x45,
	0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x56,
	0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46,
	0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x1e,
	0x0a, 0x1a, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0xf8,
	0x02, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52,
	0x75, 0x6e, 0x12, 0x3d, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x12, 0x5e, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x75,
	0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75,
	0x6e, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73,
	0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x97, 0x01, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65,
	0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x43, 0x41, 0x55, 0x53,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x55,
	0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10,
	0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x41, 0x44, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x45,
	0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4c, 0x4f,
	0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0xfa, 0x02, 0x0a, 0x10, 0x50, 0x6f,
	0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x3d,
	0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x5f, 0x0a,
	0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x73, 0x74, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x2e, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x97, 0x01, 0x0a,
	0x0c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a,
	0x19, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56,
	0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x45,
	0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x15, 0x0a, 0x11, 0x44, 0x45, 0x41, 0x44, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f,
	0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0x68, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x69, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x52,
	0x75, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x12, 0x2d, 0x0a, 0x10, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x68, 0x61,
	0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x50, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64,
	0x22, 0x69, 0x0a, 0x19, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x69, 0x6c, 0x64,
	0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x1d, 0x0a,
	0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x2d, 0x0a, 0x10,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x50, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x22, 0xdb, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9a, 0x01, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x39, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x57, 0x0a, 0x16, 0x54, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x19, 0x0a, 0x17, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x86, 0x02,
	0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x12,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53,
	0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x56,
	0xea, 0x41, 0x53, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8c, 0x02, 0x0a, 0x0f, 0x53, 0x6b, 0x61, 0x66, 0x66,
	0x6f, 0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x15, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x13, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x17, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e,
	0x64, 0x44, 0x61, 0x74, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x07, 0x0a, 0x0a, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x21, 0x0a, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x75,
	0x73, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x41, 0x0a, 0x05, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x1a, 0x3e, 0x0a,
	0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x96, 0x01, 0xea, 0x41, 0x92, 0x01, 0x0a,
	0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x52, 0x01,
	0x01, 0x22, 0x5f, 0x0a, 0x1a, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12,
	0x41, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x22, 0xc4, 0x02, 0x0a, 0x0e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x63, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65,
	0x5f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x63, 0x0a, 0x14, 0x61, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x60, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x52, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11,
	0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x42, 0x06, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x22, 0x9c, 0x02, 0x0a, 0x12, 0x50, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x32, 0x0a, 0x04, 0x77, 0x61, 0x69, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x77, 0x61, 0x69, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x49, 0x64, 0x12, 0x52, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x12, 0x41, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x68, 0x61, 0x73, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x68, 0x61, 0x73, 0x65, 0x73, 0x12, 0x32,
	0x0a, 0x04, 0x77, 0x61, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x77, 0x61,
	0x69, 0x74, 0x12, 0x52, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8b, 0x02, 0x0a, 0x11, 0x52, 0x65, 0x70, 0x61, 0x69,
	0x72, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x13, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x68, 0x61, 0x73,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x68, 0x61, 0x73, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6a,
	0x6f, 0x62, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x6a, 0x6f, 0x62, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x73,
	0x12, 0x52, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x95, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x72, 0x65, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x74, 0x72, 0x79, 0x12,
	0x43, 0x0a, 0x08, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x72, 0x6f, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x42, 0x06, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xa9, 0x01, 0x0a,
	0x05, 0x52, 0x65, 0x74, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x32, 0x0a, 0x04, 0x77, 0x61, 0x69, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x77, 0x61, 0x69, 0x74, 0x12, 0x4b, 0x0a, 0x0c, 0x62,
	0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x6f,
	0x66, 0x66, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x62, 0x61, 0x63,
	0x6b, 0x6f, 0x66, 0x66, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x3c, 0x0a, 0x08, 0x52, 0x6f, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x12, 0x30, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x22, 0x8b, 0x01, 0x0a, 0x17, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x19, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x47, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28,
	0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x9c, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x47, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xed, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x17,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xce, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa9, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x59, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xaa, 0x0a, 0x0a, 0x0d, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75,
	0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a,
	0x07, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x72, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65,
	0x5f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00,
	0x52, 0x17, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x19, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x17, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a,
	0x18, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x16, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47,
	0x0a, 0x0f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x77, 0x61, 0x69, 0x74, 0x55, 0x6e,
	0x74, 0x69, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x3a,
	0x9d, 0x01, 0xea, 0x41, 0x99, 0x01, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e,
	0x12, 0x6d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x7b,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6e, 0x7d, 0x42,
	0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa9, 0x01, 0x0a,
	0x17, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x04, 0x77, 0x61,
	0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x77, 0x61, 0x69, 0x74, 0x12, 0x1d,
	0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x19, 0x0a,
	0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x17, 0x41, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x68, 0x61, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x68, 0x61, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x04,
	0x77, 0x61, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x77, 0x61, 0x69, 0x74,
	0x12, 0x1d, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12,
	0x30, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x68, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x61, 0x73,
	0x65, 0x22, 0xc6, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x52, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x3e, 0x0a, 0x19, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x16, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x61,
	0x69, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x4d, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x61,
	0x69, 0x72, 0x50, 0x68, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72, 0x65,
	0x70, 0x61, 0x69, 0x72, 0x50, 0x68, 0x61, 0x73, 0x65, 0x73, 0x22, 0xaa, 0x01, 0x0a, 0x0b, 0x52,
	0x65, 0x70, 0x61, 0x69, 0x72, 0x50, 0x68, 0x61, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x72, 0x65,
	0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x68, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x74, 0x72, 0x79, 0x12, 0x4a, 0x0a, 0x08, 0x72,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x41,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x08, 0x72,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x42, 0x0e, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x61, 0x69,
	0x72, 0x5f, 0x70, 0x68, 0x61, 0x73, 0x65, 0x22, 0x88, 0x02, 0x0a, 0x0a, 0x52, 0x65, 0x74, 0x72,
	0x79, 0x50, 0x68, 0x61, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x73, 0x12, 0x4b, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x1e, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12,
	0x1a, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x08, 0x61,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x41, 0x74, 0x74, 0x65,
	0x6d, 0x70, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x73, 0x22, 0xc5, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x74, 0x72, 0x79, 0x41, 0x74, 0x74, 0x65,
	0x6d, 0x70, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x12, 0x32, 0x0a, 0x04, 0x77, 0x61, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x77, 0x61, 0x69, 0x74, 0x12, 0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x61, 0x69, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x22, 0xcb, 0x01, 0x0a, 0x0f, 0x52,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x12, 0x30,
	0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x68,
	0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x61, 0x73, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x61, 0x69, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x22, 0xd4, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xb6, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e,
	0x0a, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x52, 0x0e,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x5f, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x1a, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1d, 0x0a,
	0x1b, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0xb9, 0x01, 0x0a,
	0x14, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x4b, 0x41, 0x46, 0x46, 0x4f, 0x4c,
	0x44, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a,
	0x20, 0x53, 0x4b, 0x41, 0x46, 0x46, 0x4f, 0x4c, 0x44, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x2b, 0x0a, 0x27, 0x53, 0x4b, 0x41, 0x46, 0x46, 0x4f, 0x4c, 0x44, 0x5f,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x41,
	0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x02,
	0x12, 0x26, 0x0a, 0x22, 0x53, 0x4b, 0x41, 0x46, 0x46, 0x4f, 0x4c, 0x44, 0x5f, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x62, 0x0a, 0x0b, 0x42, 0x61, 0x63, 0x6b,
	0x6f, 0x66, 0x66, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x41, 0x43, 0x4b, 0x4f,
	0x46, 0x46, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x42, 0x41, 0x43, 0x4b, 0x4f, 0x46, 0x46,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x10, 0x01, 0x12, 0x1c,
	0x0a, 0x18, 0x42, 0x41, 0x43, 0x4b, 0x4f, 0x46, 0x46, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x45,
	0x58, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x02, 0x2a, 0xce, 0x01, 0x0a,
	0x0b, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45,
	0x50, 0x41, 0x49, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x52,
	0x45, 0x50, 0x41, 0x49, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x50,
	0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x50,
	0x41, 0x49, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x32, 0xa2, 0x44,
	0x0a, 0x0b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xcc, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0xb9, 0x01, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x99, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0xca, 0x41, 0x25, 0x0a,
	0x10, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2c,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x11, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x35, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x12, 0x9b, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x1d, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x3a, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x32, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x71, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a,
	0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa4, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d,
	0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0xdc, 0x01,
	0x0a, 0x0e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x6b, 0xda, 0x41, 0x19, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x2c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x49, 0x3a, 0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x6f,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x91, 0x01, 0x0a,
	0x09, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xcf, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca,
	0x41, 0x1b, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2c, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x12, 0xd1, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x75, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x67, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a,
	0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37,
	0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9c, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xab, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x12, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22,
	0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x9e, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x1e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x3a, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x32, 0x48, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbc, 0x01, 0x0a, 0x0c,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0xa9, 0x01, 0x0a, 0x0a, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xeb, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x07, 0x72, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x73, 0x12, 0xcb, 0x01, 0x0a, 0x0e, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x01, 0x2a, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x62, 0x61, 0x6e, 0x64,
	0x6f, 0x6e, 0x12, 0xd6, 0x01, 0x0a, 0x0e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x12, 0xdf, 0x01, 0x0a, 0x0e,
	0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6e, 0xda,
	0x41, 0x0d, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0xd2, 0x01,
	0x0a, 0x0d, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x64, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x12, 0xc7, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12,
	0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x12, 0xb4, 0x01, 0x0a,
	0x0a, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x22, 0x5a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xf6, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x97, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x22,
	0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x12, 0xdf, 0x01, 0x0a,
	0x09, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x67,
	0x6e, 0x6f, 0x72, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x7d, 0xda, 0x41, 0x17, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2c, 0x70, 0x68, 0x61, 0x73,
	0x65, 0x5f, 0x69, 0x64, 0x2c, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x5d, 0x3a, 0x01, 0x2a, 0x22, 0x58, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0xdb,
	0x01, 0x0a, 0x08, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7c,
	0xda, 0x41, 0x17, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2c, 0x70, 0x68, 0x61, 0x73, 0x65,
	0x5f, 0x69, 0x64, 0x2c, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c,
	0x3a, 0x01, 0x2a, 0x22, 0x57, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0xce, 0x01, 0x0a,
	0x0b, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x12, 0x55, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x12, 0xbb, 0x01,
	0x0a, 0x09, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x52, 0x75, 0x6e, 0x22, 0x64, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x57, 0x12, 0x55, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x0f,
	0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x71, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x3a,
	0x01, 0x2a, 0x22, 0x5f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a,
	0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x12, 0x8e, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x37, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x7d, 0x12, 0x80, 0x02, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x1f, 0x0a,
	0x0a, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x82, 0x02, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9d, 0x01, 0xca,
	0x41, 0x1f, 0x0a, 0x0a, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c,
	0x3a, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x4e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x01, 0x0a,
	0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7f, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x2a, 0x43, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xb5, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x54, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45,
	0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x75, 0x6e, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73,
	0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73,
	0x12, 0xdf, 0x01, 0x0a, 0x13, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x5f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52,
	0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x87, 0x06, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x7d, 0xea, 0x41, 0x5e, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x7d, 0xea, 0x41, 0x66, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x69, 0x0a, 0x24,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0xea, 0x41, 0x64, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x68,
	0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x40, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x7d, 0xea, 0x41,
	0x58, 0x0a, 0x1a, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0xea, 0x41, 0x4c, 0x0a, 0x16, 0x72, 0x75,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x70, 0x62, 0x3b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescOnce sync.Once
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData = file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc
)

func file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP() []byte {
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescOnce.Do(func() {
		file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData)
	})
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData
}

var file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes = make([]protoimpl.EnumInfo, 18)
var file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes = make([]protoimpl.MessageInfo, 171)
var file_google_cloud_deploy_v1_cloud_deploy_proto_goTypes = []interface{}{
	(SkaffoldSupportState)(0),                      // 0: google.cloud.deploy.v1.SkaffoldSupportState
	(BackoffMode)(0),                               // 1: google.cloud.deploy.v1.BackoffMode
	(RepairState)(0),                               // 2: google.cloud.deploy.v1.RepairState
	(ExecutionConfig_ExecutionEnvironmentUsage)(0), // 3: google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage
	(Release_RenderState)(0),                       // 4: google.cloud.deploy.v1.Release.RenderState
	(Release_TargetRender_TargetRenderState)(0),    // 5: google.cloud.deploy.v1.Release.TargetRender.TargetRenderState
	(Release_TargetRender_FailureCause)(0),         // 6: google.cloud.deploy.v1.Release.TargetRender.FailureCause
	(Rollout_ApprovalState)(0),                     // 7: google.cloud.deploy.v1.Rollout.ApprovalState
	(Rollout_State)(0),                             // 8: google.cloud.deploy.v1.Rollout.State
	(Rollout_FailureCause)(0),                      // 9: google.cloud.deploy.v1.Rollout.FailureCause
	(Phase_State)(0),                               // 10: google.cloud.deploy.v1.Phase.State
	(Job_State)(0),                                 // 11: google.cloud.deploy.v1.Job.State
	(JobRun_State)(0),                              // 12: google.cloud.deploy.v1.JobRun.State
	(DeployJobRun_FailureCause)(0),                 // 13: google.cloud.deploy.v1.DeployJobRun.FailureCause
	(VerifyJobRun_FailureCause)(0),                 // 14: google.cloud.deploy.v1.VerifyJobRun.FailureCause
	(PredeployJobRun_FailureCause)(0),              // 15: google.cloud.deploy.v1.PredeployJobRun.FailureCause
	(PostdeployJobRun_FailureCause)(0),             // 16: google.cloud.deploy.v1.PostdeployJobRun.FailureCause
	(AutomationRun_State)(0),                       // 17: google.cloud.deploy.v1.AutomationRun.State
	(*DeliveryPipeline)(nil),                       // 18: google.cloud.deploy.v1.DeliveryPipeline
	(*SerialPipeline)(nil),                         // 19: google.cloud.deploy.v1.SerialPipeline
	(*Stage)(nil),                                  // 20: google.cloud.deploy.v1.Stage
	(*DeployParameters)(nil),                       // 21: google.cloud.deploy.v1.DeployParameters
	(*Strategy)(nil),                               // 22: google.cloud.deploy.v1.Strategy
	(*Predeploy)(nil),                              // 23: google.cloud.deploy.v1.Predeploy
	(*Postdeploy)(nil),                             // 24: google.cloud.deploy.v1.Postdeploy
	(*Standard)(nil),                               // 25: google.cloud.deploy.v1.Standard
	(*Canary)(nil),                                 // 26: google.cloud.deploy.v1.Canary
	(*CanaryDeployment)(nil),                       // 27: google.cloud.deploy.v1.CanaryDeployment
	(*CustomCanaryDeployment)(nil),                 // 28: google.cloud.deploy.v1.CustomCanaryDeployment
	(*KubernetesConfig)(nil),                       // 29: google.cloud.deploy.v1.KubernetesConfig
	(*CloudRunConfig)(nil),                         // 30: google.cloud.deploy.v1.CloudRunConfig
	(*RuntimeConfig)(nil),                          // 31: google.cloud.deploy.v1.RuntimeConfig
	(*PipelineReadyCondition)(nil),                 // 32: google.cloud.deploy.v1.PipelineReadyCondition
	(*TargetsPresentCondition)(nil),                // 33: google.cloud.deploy.v1.TargetsPresentCondition
	(*TargetsTypeCondition)(nil),                   // 34: google.cloud.deploy.v1.TargetsTypeCondition
	(*PipelineCondition)(nil),                      // 35: google.cloud.deploy.v1.PipelineCondition
	(*ListDeliveryPipelinesRequest)(nil),           // 36: google.cloud.deploy.v1.ListDeliveryPipelinesRequest
	(*ListDeliveryPipelinesResponse)(nil),          // 37: google.cloud.deploy.v1.ListDeliveryPipelinesResponse
	(*GetDeliveryPipelineRequest)(nil),             // 38: google.cloud.deploy.v1.GetDeliveryPipelineRequest
	(*CreateDeliveryPipelineRequest)(nil),          // 39: google.cloud.deploy.v1.CreateDeliveryPipelineRequest
	(*UpdateDeliveryPipelineRequest)(nil),          // 40: google.cloud.deploy.v1.UpdateDeliveryPipelineRequest
	(*DeleteDeliveryPipelineRequest)(nil),          // 41: google.cloud.deploy.v1.DeleteDeliveryPipelineRequest
	(*RollbackTargetConfig)(nil),                   // 42: google.cloud.deploy.v1.RollbackTargetConfig
	(*RollbackTargetRequest)(nil),                  // 43: google.cloud.deploy.v1.RollbackTargetRequest
	(*RollbackTargetResponse)(nil),                 // 44: google.cloud.deploy.v1.RollbackTargetResponse
	(*Target)(nil),                                 // 45: google.cloud.deploy.v1.Target
	(*ExecutionConfig)(nil),                        // 46: google.cloud.deploy.v1.ExecutionConfig
	(*DefaultPool)(nil),                            // 47: google.cloud.deploy.v1.DefaultPool
	(*PrivatePool)(nil),                            // 48: google.cloud.deploy.v1.PrivatePool
	(*GkeCluster)(nil),                             // 49: google.cloud.deploy.v1.GkeCluster
	(*AnthosCluster)(nil),                          // 50: google.cloud.deploy.v1.AnthosCluster
	(*CloudRunLocation)(nil),                       // 51: google.cloud.deploy.v1.CloudRunLocation
	(*MultiTarget)(nil),                            // 52: google.cloud.deploy.v1.MultiTarget
	(*CustomTarget)(nil),                           // 53: google.cloud.deploy.v1.CustomTarget
	(*ListTargetsRequest)(nil),                     // 54: google.cloud.deploy.v1.ListTargetsRequest
	(*ListTargetsResponse)(nil),                    // 55: google.cloud.deploy.v1.ListTargetsResponse
	(*GetTargetRequest)(nil),                       // 56: google.cloud.deploy.v1.GetTargetRequest
	(*CreateTargetRequest)(nil),                    // 57: google.cloud.deploy.v1.CreateTargetRequest
	(*UpdateTargetRequest)(nil),                    // 58: google.cloud.deploy.v1.UpdateTargetRequest
	(*DeleteTargetRequest)(nil),                    // 59: google.cloud.deploy.v1.DeleteTargetRequest
	(*CustomTargetType)(nil),                       // 60: google.cloud.deploy.v1.CustomTargetType
	(*CustomTargetSkaffoldActions)(nil),            // 61: google.cloud.deploy.v1.CustomTargetSkaffoldActions
	(*SkaffoldModules)(nil),                        // 62: google.cloud.deploy.v1.SkaffoldModules
	(*ListCustomTargetTypesRequest)(nil),           // 63: google.cloud.deploy.v1.ListCustomTargetTypesRequest
	(*ListCustomTargetTypesResponse)(nil),          // 64: google.cloud.deploy.v1.ListCustomTargetTypesResponse
	(*GetCustomTargetTypeRequest)(nil),             // 65: google.cloud.deploy.v1.GetCustomTargetTypeRequest
	(*CreateCustomTargetTypeRequest)(nil),          // 66: google.cloud.deploy.v1.CreateCustomTargetTypeRequest
	(*UpdateCustomTargetTypeRequest)(nil),          // 67: google.cloud.deploy.v1.UpdateCustomTargetTypeRequest
	(*DeleteCustomTargetTypeRequest)(nil),          // 68: google.cloud.deploy.v1.DeleteCustomTargetTypeRequest
	(*TargetAttribute)(nil),                        // 69: google.cloud.deploy.v1.TargetAttribute
	(*Release)(nil),                                // 70: google.cloud.deploy.v1.Release
	(*BuildArtifact)(nil),                          // 71: google.cloud.deploy.v1.BuildArtifact
	(*TargetArtifact)(nil),                         // 72: google.cloud.deploy.v1.TargetArtifact
	(*DeployArtifact)(nil),                         // 73: google.cloud.deploy.v1.DeployArtifact
	(*CloudRunRenderMetadata)(nil),                 // 74: google.cloud.deploy.v1.CloudRunRenderMetadata
	(*RenderMetadata)(nil),                         // 75: google.cloud.deploy.v1.RenderMetadata
	(*ListReleasesRequest)(nil),                    // 76: google.cloud.deploy.v1.ListReleasesRequest
	(*ListReleasesResponse)(nil),                   // 77: google.cloud.deploy.v1.ListReleasesResponse
	(*GetReleaseRequest)(nil),                      // 78: google.cloud.deploy.v1.GetReleaseRequest
	(*CreateReleaseRequest)(nil),                   // 79: google.cloud.deploy.v1.CreateReleaseRequest
	(*Rollout)(nil),                                // 80: google.cloud.deploy.v1.Rollout
	(*Metadata)(nil),                               // 81: google.cloud.deploy.v1.Metadata
	(*DeployJobRunMetadata)(nil),                   // 82: google.cloud.deploy.v1.DeployJobRunMetadata
	(*CloudRunMetadata)(nil),                       // 83: google.cloud.deploy.v1.CloudRunMetadata
	(*CustomTargetDeployMetadata)(nil),             // 84: google.cloud.deploy.v1.CustomTargetDeployMetadata
	(*AutomationRolloutMetadata)(nil),              // 85: google.cloud.deploy.v1.AutomationRolloutMetadata
	(*CustomMetadata)(nil),                         // 86: google.cloud.deploy.v1.CustomMetadata
	(*Phase)(nil),                                  // 87: google.cloud.deploy.v1.Phase
	(*DeploymentJobs)(nil),                         // 88: google.cloud.deploy.v1.DeploymentJobs
	(*ChildRolloutJobs)(nil),                       // 89: google.cloud.deploy.v1.ChildRolloutJobs
	(*Job)(nil),                                    // 90: google.cloud.deploy.v1.Job
	(*DeployJob)(nil),                              // 91: google.cloud.deploy.v1.DeployJob
	(*VerifyJob)(nil),                              // 92: google.cloud.deploy.v1.VerifyJob
	(*PredeployJob)(nil),                           // 93: google.cloud.deploy.v1.PredeployJob
	(*PostdeployJob)(nil),                          // 94: google.cloud.deploy.v1.PostdeployJob
	(*CreateChildRolloutJob)(nil),                  // 95: google.cloud.deploy.v1.CreateChildRolloutJob
	(*AdvanceChildRolloutJob)(nil),                 // 96: google.cloud.deploy.v1.AdvanceChildRolloutJob
	(*ListRolloutsRequest)(nil),                    // 97: google.cloud.deploy.v1.ListRolloutsRequest
	(*ListRolloutsResponse)(nil),                   // 98: google.cloud.deploy.v1.ListRolloutsResponse
	(*GetRolloutRequest)(nil),                      // 99: google.cloud.deploy.v1.GetRolloutRequest
	(*CreateRolloutRequest)(nil),                   // 100: google.cloud.deploy.v1.CreateRolloutRequest
	(*OperationMetadata)(nil),                      // 101: google.cloud.deploy.v1.OperationMetadata
	(*ApproveRolloutRequest)(nil),                  // 102: google.cloud.deploy.v1.ApproveRolloutRequest
	(*ApproveRolloutResponse)(nil),                 // 103: google.cloud.deploy.v1.ApproveRolloutResponse
	(*AdvanceRolloutRequest)(nil),                  // 104: google.cloud.deploy.v1.AdvanceRolloutRequest
	(*AdvanceRolloutResponse)(nil),                 // 105: google.cloud.deploy.v1.AdvanceRolloutResponse
	(*CancelRolloutRequest)(nil),                   // 106: google.cloud.deploy.v1.CancelRolloutRequest
	(*CancelRolloutResponse)(nil),                  // 107: google.cloud.deploy.v1.CancelRolloutResponse
	(*IgnoreJobRequest)(nil),                       // 108: google.cloud.deploy.v1.IgnoreJobRequest
	(*IgnoreJobResponse)(nil),                      // 109: google.cloud.deploy.v1.IgnoreJobResponse
	(*RetryJobRequest)(nil),                        // 110: google.cloud.deploy.v1.RetryJobRequest
	(*RetryJobResponse)(nil),                       // 111: google.cloud.deploy.v1.RetryJobResponse
	(*AbandonReleaseRequest)(nil),                  // 112: google.cloud.deploy.v1.AbandonReleaseRequest
	(*AbandonReleaseResponse)(nil),                 // 113: google.cloud.deploy.v1.AbandonReleaseResponse
	(*JobRun)(nil),                                 // 114: google.cloud.deploy.v1.JobRun
	(*DeployJobRun)(nil),                           // 115: google.cloud.deploy.v1.DeployJobRun
	(*VerifyJobRun)(nil),                           // 116: google.cloud.deploy.v1.VerifyJobRun
	(*PredeployJobRun)(nil),                        // 117: google.cloud.deploy.v1.PredeployJobRun
	(*PostdeployJobRun)(nil),                       // 118: google.cloud.deploy.v1.PostdeployJobRun
	(*CreateChildRolloutJobRun)(nil),               // 119: google.cloud.deploy.v1.CreateChildRolloutJobRun
	(*AdvanceChildRolloutJobRun)(nil),              // 120: google.cloud.deploy.v1.AdvanceChildRolloutJobRun
	(*ListJobRunsRequest)(nil),                     // 121: google.cloud.deploy.v1.ListJobRunsRequest
	(*ListJobRunsResponse)(nil),                    // 122: google.cloud.deploy.v1.ListJobRunsResponse
	(*GetJobRunRequest)(nil),                       // 123: google.cloud.deploy.v1.GetJobRunRequest
	(*TerminateJobRunRequest)(nil),                 // 124: google.cloud.deploy.v1.TerminateJobRunRequest
	(*TerminateJobRunResponse)(nil),                // 125: google.cloud.deploy.v1.TerminateJobRunResponse
	(*Config)(nil),                                 // 126: google.cloud.deploy.v1.Config
	(*SkaffoldVersion)(nil),                        // 127: google.cloud.deploy.v1.SkaffoldVersion
	(*GetConfigRequest)(nil),                       // 128: google.cloud.deploy.v1.GetConfigRequest
	(*Automation)(nil),                             // 129: google.cloud.deploy.v1.Automation
	(*AutomationResourceSelector)(nil),             // 130: google.cloud.deploy.v1.AutomationResourceSelector
	(*AutomationRule)(nil),                         // 131: google.cloud.deploy.v1.AutomationRule
	(*PromoteReleaseRule)(nil),                     // 132: google.cloud.deploy.v1.PromoteReleaseRule
	(*AdvanceRolloutRule)(nil),                     // 133: google.cloud.deploy.v1.AdvanceRolloutRule
	(*RepairRolloutRule)(nil),                      // 134: google.cloud.deploy.v1.RepairRolloutRule
	(*RepairMode)(nil),                             // 135: google.cloud.deploy.v1.RepairMode
	(*Retry)(nil),                                  // 136: google.cloud.deploy.v1.Retry
	(*Rollback)(nil),                               // 137: google.cloud.deploy.v1.Rollback
	(*AutomationRuleCondition)(nil),                // 138: google.cloud.deploy.v1.AutomationRuleCondition
	(*CreateAutomationRequest)(nil),                // 139: google.cloud.deploy.v1.CreateAutomationRequest
	(*UpdateAutomationRequest)(nil),                // 140: google.cloud.deploy.v1.UpdateAutomationRequest
	(*DeleteAutomationRequest)(nil),                // 141: google.cloud.deploy.v1.DeleteAutomationRequest
	(*ListAutomationsRequest)(nil),                 // 142: google.cloud.deploy.v1.ListAutomationsRequest
	(*ListAutomationsResponse)(nil),                // 143: google.cloud.deploy.v1.ListAutomationsResponse
	(*GetAutomationRequest)(nil),                   // 144: google.cloud.deploy.v1.GetAutomationRequest
	(*AutomationRun)(nil),                          // 145: google.cloud.deploy.v1.AutomationRun
	(*PromoteReleaseOperation)(nil),                // 146: google.cloud.deploy.v1.PromoteReleaseOperation
	(*AdvanceRolloutOperation)(nil),                // 147: google.cloud.deploy.v1.AdvanceRolloutOperation
	(*RepairRolloutOperation)(nil),                 // 148: google.cloud.deploy.v1.RepairRolloutOperation
	(*RepairPhase)(nil),                            // 149: google.cloud.deploy.v1.RepairPhase
	(*RetryPhase)(nil),                             // 150: google.cloud.deploy.v1.RetryPhase
	(*RetryAttempt)(nil),                           // 151: google.cloud.deploy.v1.RetryAttempt
	(*RollbackAttempt)(nil),                        // 152: google.cloud.deploy.v1.RollbackAttempt
	(*ListAutomationRunsRequest)(nil),              // 153: google.cloud.deploy.v1.ListAutomationRunsRequest
	(*ListAutomationRunsResponse)(nil),             // 154: google.cloud.deploy.v1.ListAutomationRunsResponse
	(*GetAutomationRunRequest)(nil),                // 155: google.cloud.deploy.v1.GetAutomationRunRequest
	(*CancelAutomationRunRequest)(nil),             // 156: google.cloud.deploy.v1.CancelAutomationRunRequest
	(*CancelAutomationRunResponse)(nil),            // 157: google.cloud.deploy.v1.CancelAutomationRunResponse
	nil,                                            // 158: google.cloud.deploy.v1.DeliveryPipeline.AnnotationsEntry
	nil,                                            // 159: google.cloud.deploy.v1.DeliveryPipeline.LabelsEntry
	nil,                                            // 160: google.cloud.deploy.v1.DeployParameters.ValuesEntry
	nil,                                            // 161: google.cloud.deploy.v1.DeployParameters.MatchTargetLabelsEntry
	(*CustomCanaryDeployment_PhaseConfig)(nil),     // 162: google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig
	(*KubernetesConfig_GatewayServiceMesh)(nil),    // 163: google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh
	(*KubernetesConfig_ServiceNetworking)(nil),     // 164: google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking
	nil, // 165: google.cloud.deploy.v1.Target.AnnotationsEntry
	nil, // 166: google.cloud.deploy.v1.Target.LabelsEntry
	nil, // 167: google.cloud.deploy.v1.Target.DeployParametersEntry
	nil, // 168: google.cloud.deploy.v1.CustomTargetType.AnnotationsEntry
	nil, // 169: google.cloud.deploy.v1.CustomTargetType.LabelsEntry
	(*SkaffoldModules_SkaffoldGitSource)(nil), // 170: google.cloud.deploy.v1.SkaffoldModules.SkaffoldGitSource
	(*SkaffoldModules_SkaffoldGCSSource)(nil), // 171: google.cloud.deploy.v1.SkaffoldModules.SkaffoldGCSSource
	nil,                                   // 172: google.cloud.deploy.v1.TargetAttribute.LabelsEntry
	(*Release_TargetRender)(nil),          // 173: google.cloud.deploy.v1.Release.TargetRender
	(*Release_ReleaseReadyCondition)(nil), // 174: google.cloud.deploy.v1.Release.ReleaseReadyCondition
	(*Release_SkaffoldSupportedCondition)(nil), // 175: google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
	(*Release_ReleaseCondition)(nil),           // 176: google.cloud.deploy.v1.Release.ReleaseCondition
	nil,                                        // 177: google.cloud.deploy.v1.Release.AnnotationsEntry
	nil,                                        // 178: google.cloud.deploy.v1.Release.LabelsEntry
	nil,                                        // 179: google.cloud.deploy.v1.Release.TargetArtifactsEntry
	nil,                                        // 180: google.cloud.deploy.v1.Release.TargetRendersEntry
	nil,                                        // 181: google.cloud.deploy.v1.Release.DeployParametersEntry
	(*TargetArtifact_PhaseArtifact)(nil),       // 182: google.cloud.deploy.v1.TargetArtifact.PhaseArtifact
	nil,                                        // 183: google.cloud.deploy.v1.TargetArtifact.PhaseArtifactsEntry
	nil,                                        // 184: google.cloud.deploy.v1.Rollout.AnnotationsEntry
	nil,                                        // 185: google.cloud.deploy.v1.Rollout.LabelsEntry
	nil,                                        // 186: google.cloud.deploy.v1.CustomMetadata.ValuesEntry
	nil,                                        // 187: google.cloud.deploy.v1.Automation.AnnotationsEntry
	nil,                                        // 188: google.cloud.deploy.v1.Automation.LabelsEntry
	(*timestamppb.Timestamp)(nil),              // 189: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),              // 190: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),                // 191: google.protobuf.Duration
	(*date.Date)(nil),                          // 192: google.type.Date
	(*longrunningpb.Operation)(nil),            // 193: google.longrunning.Operation
}
var file_google_cloud_deploy_v1_cloud_deploy_proto_depIdxs = []int32{
	158, // 0: google.cloud.deploy.v1.DeliveryPipeline.annotations:type_name -> google.cloud.deploy.v1.DeliveryPipeline.AnnotationsEntry
	159, // 1: google.cloud.deploy.v1.DeliveryPipeline.labels:type_name -> google.cloud.deploy.v1.DeliveryPipeline.LabelsEntry
	189, // 2: google.cloud.deploy.v1.DeliveryPipeline.create_time:type_name -> google.protobuf.Timestamp
	189, // 3: google.cloud.deploy.v1.DeliveryPipeline.update_time:type_name -> google.protobuf.Timestamp
	19,  // 4: google.cloud.deploy.v1.DeliveryPipeline.serial_pipeline:type_name -> google.cloud.deploy.v1.SerialPipeline
	35,  // 5: google.cloud.deploy.v1.DeliveryPipeline.condition:type_name -> google.cloud.deploy.v1.PipelineCondition
	20,  // 6: google.cloud.deploy.v1.SerialPipeline.stages:type_name -> google.cloud.deploy.v1.Stage
	22,  // 7: google.cloud.deploy.v1.Stage.strategy:type_name -> google.cloud.deploy.v1.Strategy
	21,  // 8: google.cloud.deploy.v1.Stage.deploy_parameters:type_name -> google.cloud.deploy.v1.DeployParameters
	160, // 9: google.cloud.deploy.v1.DeployParameters.values:type_name -> google.cloud.deploy.v1.DeployParameters.ValuesEntry
	161, // 10: google.cloud.deploy.v1.DeployParameters.match_target_labels:type_name -> google.cloud.deploy.v1.DeployParameters.MatchTargetLabelsEntry
	25,  // 11: google.cloud.deploy.v1.Strategy.standard:type_name -> google.cloud.deploy.v1.Standard
	26,  // 12: google.cloud.deploy.v1.Strategy.canary:type_name -> google.cloud.deploy.v1.Canary
	23,  // 13: google.cloud.deploy.v1.Standard.predeploy:type_name -> google.cloud.deploy.v1.Predeploy
	24,  // 14: google.cloud.deploy.v1.Standard.postdeploy:type_name -> google.cloud.deploy.v1.Postdeploy
	31,  // 15: google.cloud.deploy.v1.Canary.runtime_config:type_name -> google.cloud.deploy.v1.RuntimeConfig
	27,  // 16: google.cloud.deploy.v1.Canary.canary_deployment:type_name -> google.cloud.deploy.v1.CanaryDeployment
	28,  // 17: google.cloud.deploy.v1.Canary.custom_canary_deployment:type_name -> google.cloud.deploy.v1.CustomCanaryDeployment
	23,  // 18: google.cloud.deploy.v1.CanaryDeployment.predeploy:type_name -> google.cloud.deploy.v1.Predeploy
	24,  // 19: google.cloud.deploy.v1.CanaryDeployment.postdeploy:type_name -> google.cloud.deploy.v1.Postdeploy
	162, // 20: google.cloud.deploy.v1.CustomCanaryDeployment.phase_configs:type_name -> google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig
	163, // 21: google.cloud.deploy.v1.KubernetesConfig.gateway_service_mesh:type_name -> google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh
	164, // 22: google.cloud.deploy.v1.KubernetesConfig.service_networking:type_name -> google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking
	29,  // 23: google.cloud.deploy.v1.RuntimeConfig.kubernetes:type_name -> google.cloud.deploy.v1.KubernetesConfig
	30,  // 24: google.cloud.deploy.v1.RuntimeConfig.cloud_run:type_name -> google.cloud.deploy.v1.CloudRunConfig
	189, // 25: google.cloud.deploy.v1.PipelineReadyCondition.update_time:type_name -> google.protobuf.Timestamp
	189, // 26: google.cloud.deploy.v1.TargetsPresentCondition.update_time:type_name -> google.protobuf.Timestamp
	32,  // 27: google.cloud.deploy.v1.PipelineCondition.pipeline_ready_condition:type_name -> google.cloud.deploy.v1.PipelineReadyCondition
	33,  // 28: google.cloud.deploy.v1.PipelineCondition.targets_present_condition:type_name -> google.cloud.deploy.v1.TargetsPresentCondition
	34,  // 29: google.cloud.deploy.v1.PipelineCondition.targets_type_condition:type_name -> google.cloud.deploy.v1.TargetsTypeCondition
	18,  // 30: google.cloud.deploy.v1.ListDeliveryPipelinesResponse.delivery_pipelines:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	18,  // 31: google.cloud.deploy.v1.CreateDeliveryPipelineRequest.delivery_pipeline:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	190, // 32: google.cloud.deploy.v1.UpdateDeliveryPipelineRequest.update_mask:type_name -> google.protobuf.FieldMask
	18,  // 33: google.cloud.deploy.v1.UpdateDeliveryPipelineRequest.delivery_pipeline:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	80,  // 34: google.cloud.deploy.v1.RollbackTargetConfig.rollout:type_name -> google.cloud.deploy.v1.Rollout
	42,  // 35: google.cloud.deploy.v1.RollbackTargetRequest.rollback_config:type_name -> google.cloud.deploy.v1.RollbackTargetConfig
	42,  // 36: google.cloud.deploy.v1.RollbackTargetResponse.rollback_config:type_name -> google.cloud.deploy.v1.RollbackTargetConfig
	165, // 37: google.cloud.deploy.v1.Target.annotations:type_name -> google.cloud.deploy.v1.Target.AnnotationsEntry
	166, // 38: google.cloud.deploy.v1.Target.labels:type_name -> google.cloud.deploy.v1.Target.LabelsEntry
	189, // 39: google.cloud.deploy.v1.Target.create_time:type_name -> google.protobuf.Timestamp
	189, // 40: google.cloud.deploy.v1.Target.update_time:type_name -> google.protobuf.Timestamp
	49,  // 41: google.cloud.deploy.v1.Target.gke:type_name -> google.cloud.deploy.v1.GkeCluster
	50,  // 42: google.cloud.deploy.v1.Target.anthos_cluster:type_name -> google.cloud.deploy.v1.AnthosCluster
	51,  // 43: google.cloud.deploy.v1.Target.run:type_name -> google.cloud.deploy.v1.CloudRunLocation
	52,  // 44: google.cloud.deploy.v1.Target.multi_target:type_name -> google.cloud.deploy.v1.MultiTarget
	53,  // 45: google.cloud.deploy.v1.Target.custom_target:type_name -> google.cloud.deploy.v1.CustomTarget
	46,  // 46: google.cloud.deploy.v1.Target.execution_configs:type_name -> google.cloud.deploy.v1.ExecutionConfig
	167, // 47: google.cloud.deploy.v1.Target.deploy_parameters:type_name -> google.cloud.deploy.v1.Target.DeployParametersEntry
	3,   // 48: google.cloud.deploy.v1.ExecutionConfig.usages:type_name -> google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage
	47,  // 49: google.cloud.deploy.v1.ExecutionConfig.default_pool:type_name -> google.cloud.deploy.v1.DefaultPool
	48,  // 50: google.cloud.deploy.v1.ExecutionConfig.private_pool:type_name -> google.cloud.deploy.v1.PrivatePool
	191, // 51: google.cloud.deploy.v1.ExecutionConfig.execution_timeout:type_name -> google.protobuf.Duration
	45,  // 52: google.cloud.deploy.v1.ListTargetsResponse.targets:type_name -> google.cloud.deploy.v1.Target
	45,  // 53: google.cloud.deploy.v1.CreateTargetRequest.target:type_name -> google.cloud.deploy.v1.Target
	190, // 54: google.cloud.deploy.v1.UpdateTargetRequest.update_mask:type_name -> google.protobuf.FieldMask
	45,  // 55: google.cloud.deploy.v1.UpdateTargetRequest.target:type_name -> google.cloud.deploy.v1.Target
	168, // 56: google.cloud.deploy.v1.CustomTargetType.annotations:type_name -> google.cloud.deploy.v1.CustomTargetType.AnnotationsEntry
	169, // 57: google.cloud.deploy.v1.CustomTargetType.labels:type_name -> google.cloud.deploy.v1.CustomTargetType.LabelsEntry
	189, // 58: google.cloud.deploy.v1.CustomTargetType.create_time:type_name -> google.protobuf.Timestamp
	189, // 59: google.cloud.deploy.v1.CustomTargetType.update_time:type_name -> google.protobuf.Timestamp
	61,  // 60: google.cloud.deploy.v1.CustomTargetType.custom_actions:type_name -> google.cloud.deploy.v1.CustomTargetSkaffoldActions
	62,  // 61: google.cloud.deploy.v1.CustomTargetSkaffoldActions.include_skaffold_modules:type_name -> google.cloud.deploy.v1.SkaffoldModules
	170, // 62: google.cloud.deploy.v1.SkaffoldModules.git:type_name -> google.cloud.deploy.v1.SkaffoldModules.SkaffoldGitSource
	171, // 63: google.cloud.deploy.v1.SkaffoldModules.google_cloud_storage:type_name -> google.cloud.deploy.v1.SkaffoldModules.SkaffoldGCSSource
	60,  // 64: google.cloud.deploy.v1.ListCustomTargetTypesResponse.custom_target_types:type_name -> google.cloud.deploy.v1.CustomTargetType
	60,  // 65: google.cloud.deploy.v1.CreateCustomTargetTypeRequest.custom_target_type:type_name -> google.cloud.deploy.v1.CustomTargetType
	190, // 66: google.cloud.deploy.v1.UpdateCustomTargetTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	60,  // 67: google.cloud.deploy.v1.UpdateCustomTargetTypeRequest.custom_target_type:type_name -> google.cloud.deploy.v1.CustomTargetType
	172, // 68: google.cloud.deploy.v1.TargetAttribute.labels:type_name -> google.cloud.deploy.v1.TargetAttribute.LabelsEntry
	177, // 69: google.cloud.deploy.v1.Release.annotations:type_name -> google.cloud.deploy.v1.Release.AnnotationsEntry
	178, // 70: google.cloud.deploy.v1.Release.labels:type_name -> google.cloud.deploy.v1.Release.LabelsEntry
	189, // 71: google.cloud.deploy.v1.Release.create_time:type_name -> google.protobuf.Timestamp
	189, // 72: google.cloud.deploy.v1.Release.render_start_time:type_name -> google.protobuf.Timestamp
	189, // 73: google.cloud.deploy.v1.Release.render_end_time:type_name -> google.protobuf.Timestamp
	71,  // 74: google.cloud.deploy.v1.Release.build_artifacts:type_name -> google.cloud.deploy.v1.BuildArtifact
	18,  // 75: google.cloud.deploy.v1.Release.delivery_pipeline_snapshot:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	45,  // 76: google.cloud.deploy.v1.Release.target_snapshots:type_name -> google.cloud.deploy.v1.Target
	60,  // 77: google.cloud.deploy.v1.Release.custom_target_type_snapshots:type_name -> google.cloud.deploy.v1.CustomTargetType
	4,   // 78: google.cloud.deploy.v1.Release.render_state:type_name -> google.cloud.deploy.v1.Release.RenderState
	179, // 79: google.cloud.deploy.v1.Release.target_artifacts:type_name -> google.cloud.deploy.v1.Release.TargetArtifactsEntry
	180, // 80: google.cloud.deploy.v1.Release.target_renders:type_name -> google.cloud.deploy.v1.Release.TargetRendersEntry
	176, // 81: google.cloud.deploy.v1.Release.condition:type_name -> google.cloud.deploy.v1.Release.ReleaseCondition
	181, // 82: google.cloud.deploy.v1.Release.deploy_parameters:type_name -> google.cloud.deploy.v1.Release.DeployParametersEntry
	183, // 83: google.cloud.deploy.v1.TargetArtifact.phase_artifacts:type_name -> google.cloud.deploy.v1.TargetArtifact.PhaseArtifactsEntry
	74,  // 84: google.cloud.deploy.v1.RenderMetadata.cloud_run:type_name -> google.cloud.deploy.v1.CloudRunRenderMetadata
	86,  // 85: google.cloud.deploy.v1.RenderMetadata.custom:type_name -> google.cloud.deploy.v1.CustomMetadata
	70,  // 86: google.cloud.deploy.v1.ListReleasesResponse.releases:type_name -> google.cloud.deploy.v1.Release
	70,  // 87: google.cloud.deploy.v1.CreateReleaseRequest.release:type_name -> google.cloud.deploy.v1.Release
	184, // 88: google.cloud.deploy.v1.Rollout.annotations:type_name -> google.cloud.deploy.v1.Rollout.AnnotationsEntry
	185, // 89: google.cloud.deploy.v1.Rollout.labels:type_name -> google.cloud.deploy.v1.Rollout.LabelsEntry
	189, // 90: google.cloud.deploy.v1.Rollout.create_time:type_name -> google.protobuf.Timestamp
	189, // 91: google.cloud.deploy.v1.Rollout.approve_time:type_name -> google.protobuf.Timestamp
	189, // 92: google.cloud.deploy.v1.Rollout.enqueue_time:type_name -> google.protobuf.Timestamp
	189, // 93: google.cloud.deploy.v1.Rollout.deploy_start_time:type_name -> google.protobuf.Timestamp
	189, // 94: google.cloud.deploy.v1.Rollout.deploy_end_time:type_name -> google.protobuf.Timestamp
	7,   // 95: google.cloud.deploy.v1.Rollout.approval_state:type_name -> google.cloud.deploy.v1.Rollout.ApprovalState
	8,   // 96: google.cloud.deploy.v1.Rollout.state:type_name -> google.cloud.deploy.v1.Rollout.State
	9,   // 97: google.cloud.deploy.v1.Rollout.deploy_failure_cause:type_name -> google.cloud.deploy.v1.Rollout.FailureCause
	87,  // 98: google.cloud.deploy.v1.Rollout.phases:type_name -> google.cloud.deploy.v1.Phase
	81,  // 99: google.cloud.deploy.v1.Rollout.metadata:type_name -> google.cloud.deploy.v1.Metadata
	83,  // 100: google.cloud.deploy.v1.Metadata.cloud_run:type_name -> google.cloud.deploy.v1.CloudRunMetadata
	85,  // 101: google.cloud.deploy.v1.Metadata.automation:type_name -> google.cloud.deploy.v1.AutomationRolloutMetadata
	86,  // 102: google.cloud.deploy.v1.Metadata.custom:type_name -> google.cloud.deploy.v1.CustomMetadata
	83,  // 103: google.cloud.deploy.v1.DeployJobRunMetadata.cloud_run:type_name -> google.cloud.deploy.v1.CloudRunMetadata
	84,  // 104: google.cloud.deploy.v1.DeployJobRunMetadata.custom_target:type_name -> google.cloud.deploy.v1.CustomTargetDeployMetadata
	86,  // 105: google.cloud.deploy.v1.DeployJobRunMetadata.custom:type_name -> google.cloud.deploy.v1.CustomMetadata
	186, // 106: google.cloud.deploy.v1.CustomMetadata.values:type_name -> google.cloud.deploy.v1.CustomMetadata.ValuesEntry
	10,  // 107: google.cloud.deploy.v1.Phase.state:type_name -> google.cloud.deploy.v1.Phase.State
	88,  // 108: google.cloud.deploy.v1.Phase.deployment_jobs:type_name -> google.cloud.deploy.v1.DeploymentJobs
	89,  // 109: google.cloud.deploy.v1.Phase.child_rollout_jobs:type_name -> google.cloud.deploy.v1.ChildRolloutJobs
	90,  // 110: google.cloud.deploy.v1.DeploymentJobs.deploy_job:type_name -> google.cloud.deploy.v1.Job
	90,  // 111: google.cloud.deploy.v1.DeploymentJobs.verify_job:type_name -> google.cloud.deploy.v1.Job
	90,  // 112: google.cloud.deploy.v1.DeploymentJobs.predeploy_job:type_name -> google.cloud.deploy.v1.Job
	90,  // 113: google.cloud.deploy.v1.DeploymentJobs.postdeploy_job:type_name -> google.cloud.deploy.v1.Job
	90,  // 114: google.cloud.deploy.v1.ChildRolloutJobs.create_rollout_jobs:type_name -> google.cloud.deploy.v1.Job
	90,  // 115: google.cloud.deploy.v1.ChildRolloutJobs.advance_rollout_jobs:type_name -> google.cloud.deploy.v1.Job
	11,  // 116: google.cloud.deploy.v1.Job.state:type_name -> google.cloud.deploy.v1.Job.State
	91,  // 117: google.cloud.deploy.v1.Job.deploy_job:type_name -> google.cloud.deploy.v1.DeployJob
	92,  // 118: google.cloud.deploy.v1.Job.verify_job:type_name -> google.cloud.deploy.v1.VerifyJob
	93,  // 119: google.cloud.deploy.v1.Job.predeploy_job:type_name -> google.cloud.deploy.v1.PredeployJob
	94,  // 120: google.cloud.deploy.v1.Job.postdeploy_job:type_name -> google.cloud.deploy.v1.PostdeployJob
	95,  // 121: google.cloud.deploy.v1.Job.create_child_rollout_job:type_name -> google.cloud.deploy.v1.CreateChildRolloutJob
	96,  // 122: google.cloud.deploy.v1.Job.advance_child_rollout_job:type_name -> google.cloud.deploy.v1.AdvanceChildRolloutJob
	80,  // 123: google.cloud.deploy.v1.ListRolloutsResponse.rollouts:type_name -> google.cloud.deploy.v1.Rollout
	80,  // 124: google.cloud.deploy.v1.CreateRolloutRequest.rollout:type_name -> google.cloud.deploy.v1.Rollout
	189, // 125: google.cloud.deploy.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	189, // 126: google.cloud.deploy.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	189, // 127: google.cloud.deploy.v1.JobRun.create_time:type_name -> google.protobuf.Timestamp
	189, // 128: google.cloud.deploy.v1.JobRun.start_time:type_name -> google.protobuf.Timestamp
	189, // 129: google.cloud.deploy.v1.JobRun.end_time:type_name -> google.protobuf.Timestamp
	12,  // 130: google.cloud.deploy.v1.JobRun.state:type_name -> google.cloud.deploy.v1.JobRun.State
	115, // 131: google.cloud.deploy.v1.JobRun.deploy_job_run:type_name -> google.cloud.deploy.v1.DeployJobRun
	116, // 132: google.cloud.deploy.v1.JobRun.verify_job_run:type_name -> google.cloud.deploy.v1.VerifyJobRun
	117, // 133: google.cloud.deploy.v1.JobRun.predeploy_job_run:type_name -> google.cloud.deploy.v1.PredeployJobRun
	118, // 134: google.cloud.deploy.v1.JobRun.postdeploy_job_run:type_name -> google.cloud.deploy.v1.PostdeployJobRun
	119, // 135: google.cloud.deploy.v1.JobRun.create_child_rollout_job_run:type_name -> google.cloud.deploy.v1.CreateChildRolloutJobRun
	120, // 136: google.cloud.deploy.v1.JobRun.advance_child_rollout_job_run:type_name -> google.cloud.deploy.v1.AdvanceChildRolloutJobRun
	13,  // 137: google.cloud.deploy.v1.DeployJobRun.failure_cause:type_name -> google.cloud.deploy.v1.DeployJobRun.FailureCause
	82,  // 138: google.cloud.deploy.v1.DeployJobRun.metadata:type_name -> google.cloud.deploy.v1.DeployJobRunMetadata
	73,  // 139: google.cloud.deploy.v1.DeployJobRun.artifact:type_name -> google.cloud.deploy.v1.DeployArtifact
	14,  // 140: google.cloud.deploy.v1.VerifyJobRun.failure_cause:type_name -> google.cloud.deploy.v1.VerifyJobRun.FailureCause
	15,  // 141: google.cloud.deploy.v1.PredeployJobRun.failure_cause:type_name -> google.cloud.deploy.v1.PredeployJobRun.FailureCause
	16,  // 142: google.cloud.deploy.v1.PostdeployJobRun.failure_cause:type_name -> google.cloud.deploy.v1.PostdeployJobRun.FailureCause
	114, // 143: google.cloud.deploy.v1.ListJobRunsResponse.job_runs:type_name -> google.cloud.deploy.v1.JobRun
	127, // 144: google.cloud.deploy.v1.Config.supported_versions:type_name -> google.cloud.deploy.v1.SkaffoldVersion
	189, // 145: google.cloud.deploy.v1.SkaffoldVersion.maintenance_mode_time:type_name -> google.protobuf.Timestamp
	189, // 146: google.cloud.deploy.v1.SkaffoldVersion.support_expiration_time:type_name -> google.protobuf.Timestamp
	192, // 147: google.cloud.deploy.v1.SkaffoldVersion.support_end_date:type_name -> google.type.Date
	189, // 148: google.cloud.deploy.v1.Automation.create_time:type_name -> google.protobuf.Timestamp
	189, // 149: google.cloud.deploy.v1.Automation.update_time:type_name -> google.protobuf.Timestamp
	187, // 150: google.cloud.deploy.v1.Automation.annotations:type_name -> google.cloud.deploy.v1.Automation.AnnotationsEntry
	188, // 151: google.cloud.deploy.v1.Automation.labels:type_name -> google.cloud.deploy.v1.Automation.LabelsEntry
	130, // 152: google.cloud.deploy.v1.Automation.selector:type_name -> google.cloud.deploy.v1.AutomationResourceSelector
	131, // 153: google.cloud.deploy.v1.Automation.rules:type_name -> google.cloud.deploy.v1.AutomationRule
	69,  // 154: google.cloud.deploy.v1.AutomationResourceSelector.targets:type_name -> google.cloud.deploy.v1.TargetAttribute
	132, // 155: google.cloud.deploy.v1.AutomationRule.promote_release_rule:type_name -> google.cloud.deploy.v1.PromoteReleaseRule
	133, // 156: google.cloud.deploy.v1.AutomationRule.advance_rollout_rule:type_name -> google.cloud.deploy.v1.AdvanceRolloutRule
	134, // 157: google.cloud.deploy.v1.AutomationRule.repair_rollout_rule:type_name -> google.cloud.deploy.v1.RepairRolloutRule
	191, // 158: google.cloud.deploy.v1.PromoteReleaseRule.wait:type_name -> google.protobuf.Duration
	138, // 159: google.cloud.deploy.v1.PromoteReleaseRule.condition:type_name -> google.cloud.deploy.v1.AutomationRuleCondition
	191, // 160: google.cloud.deploy.v1.AdvanceRolloutRule.wait:type_name -> google.protobuf.Duration
	138, // 161: google.cloud.deploy.v1.AdvanceRolloutRule.condition:type_name -> google.cloud.deploy.v1.AutomationRuleCondition
	135, // 162: google.cloud.deploy.v1.RepairRolloutRule.repair_modes:type_name -> google.cloud.deploy.v1.RepairMode
	138, // 163: google.cloud.deploy.v1.RepairRolloutRule.condition:type_name -> google.cloud.deploy.v1.AutomationRuleCondition
	136, // 164: google.cloud.deploy.v1.RepairMode.retry:type_name -> google.cloud.deploy.v1.Retry
	137, // 165: google.cloud.deploy.v1.RepairMode.rollback:type_name -> google.cloud.deploy.v1.Rollback
	191, // 166: google.cloud.deploy.v1.Retry.wait:type_name -> google.protobuf.Duration
	1,   // 167: google.cloud.deploy.v1.Retry.backoff_mode:type_name -> google.cloud.deploy.v1.BackoffMode
	33,  // 168: google.cloud.deploy.v1.AutomationRuleCondition.targets_present_condition:type_name -> google.cloud.deploy.v1.TargetsPresentCondition
	129, // 169: google.cloud.deploy.v1.CreateAutomationRequest.automation:type_name -> google.cloud.deploy.v1.Automation
	190, // 170: google.cloud.deploy.v1.UpdateAutomationRequest.update_mask:type_name -> google.protobuf.FieldMask
	129, // 171: google.cloud.deploy.v1.UpdateAutomationRequest.automation:type_name -> google.cloud.deploy.v1.Automation
	129, // 172: google.cloud.deploy.v1.ListAutomationsResponse.automations:type_name -> google.cloud.deploy.v1.Automation
	189, // 173: google.cloud.deploy.v1.AutomationRun.create_time:type_name -> google.protobuf.Timestamp
	189, // 174: google.cloud.deploy.v1.AutomationRun.update_time:type_name -> google.protobuf.Timestamp
	129, // 175: google.cloud.deploy.v1.AutomationRun.automation_snapshot:type_name -> google.cloud.deploy.v1.Automation
	17,  // 176: google.cloud.deploy.v1.AutomationRun.state:type_name -> google.cloud.deploy.v1.AutomationRun.State
	189, // 177: google.cloud.deploy.v1.AutomationRun.expire_time:type_name -> google.protobuf.Timestamp
	146, // 178: google.cloud.deploy.v1.AutomationRun.promote_release_operation:type_name -> google.cloud.deploy.v1.PromoteReleaseOperation
	147, // 179: google.cloud.deploy.v1.AutomationRun.advance_rollout_operation:type_name -> google.cloud.deploy.v1.AdvanceRolloutOperation
	148, // 180: google.cloud.deploy.v1.AutomationRun.repair_rollout_operation:type_name -> google.cloud.deploy.v1.RepairRolloutOperation
	189, // 181: google.cloud.deploy.v1.AutomationRun.wait_until_time:type_name -> google.protobuf.Timestamp
	191, // 182: google.cloud.deploy.v1.PromoteReleaseOperation.wait:type_name -> google.protobuf.Duration
	191, // 183: google.cloud.deploy.v1.AdvanceRolloutOperation.wait:type_name -> google.protobuf.Duration
	149, // 184: google.cloud.deploy.v1.RepairRolloutOperation.repair_phases:type_name -> google.cloud.deploy.v1.RepairPhase
	150, // 185: google.cloud.deploy.v1.RepairPhase.retry:type_name -> google.cloud.deploy.v1.RetryPhase
	152, // 186: google.cloud.deploy.v1.RepairPhase.rollback:type_name -> google.cloud.deploy.v1.RollbackAttempt
	1,   // 187: google.cloud.deploy.v1.RetryPhase.backoff_mode:type_name -> google.cloud.deploy.v1.BackoffMode
	151, // 188: google.cloud.deploy.v1.RetryPhase.attempts:type_name -> google.cloud.deploy.v1.RetryAttempt
	191, // 189: google.cloud.deploy.v1.RetryAttempt.wait:type_name -> google.protobuf.Duration
	2,   // 190: google.cloud.deploy.v1.RetryAttempt.state:type_name -> google.cloud.deploy.v1.RepairState
	2,   // 191: google.cloud.deploy.v1.RollbackAttempt.state:type_name -> google.cloud.deploy.v1.RepairState
	145, // 192: google.cloud.deploy.v1.ListAutomationRunsResponse.automation_runs:type_name -> google.cloud.deploy.v1.AutomationRun
	23,  // 193: google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.predeploy:type_name -> google.cloud.deploy.v1.Predeploy
	24,  // 194: google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.postdeploy:type_name -> google.cloud.deploy.v1.Postdeploy
	191, // 195: google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.route_update_wait_time:type_name -> google.protobuf.Duration
	191, // 196: google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.stable_cutback_duration:type_name -> google.protobuf.Duration
	5,   // 197: google.cloud.deploy.v1.Release.TargetRender.rendering_state:type_name -> google.cloud.deploy.v1.Release.TargetRender.TargetRenderState
	75,  // 198: google.cloud.deploy.v1.Release.TargetRender.metadata:type_name -> google.cloud.deploy.v1.RenderMetadata
	6,   // 199: google.cloud.deploy.v1.Release.TargetRender.failure_cause:type_name -> google.cloud.deploy.v1.Release.TargetRender.FailureCause
	0,   // 200: google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.skaffold_support_state:type_name -> google.cloud.deploy.v1.SkaffoldSupportState
	189, // 201: google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.maintenance_mode_time:type_name -> google.protobuf.Timestamp
	189, // 202: google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.support_expiration_time:type_name -> google.protobuf.Timestamp
	174, // 203: google.cloud.deploy.v1.Release.ReleaseCondition.release_ready_condition:type_name -> google.cloud.deploy.v1.Release.ReleaseReadyCondition
	175, // 204: google.cloud.deploy.v1.Release.ReleaseCondition.skaffold_supported_condition:type_name -> google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
	72,  // 205: google.cloud.deploy.v1.Release.TargetArtifactsEntry.value:type_name -> google.cloud.deploy.v1.TargetArtifact
	173, // 206: google.cloud.deploy.v1.Release.TargetRendersEntry.value:type_name -> google.cloud.deploy.v1.Release.TargetRender
	182, // 207: google.cloud.deploy.v1.TargetArtifact.PhaseArtifactsEntry.value:type_name -> google.cloud.deploy.v1.TargetArtifact.PhaseArtifact
	36,  // 208: google.cloud.deploy.v1.CloudDeploy.ListDeliveryPipelines:input_type -> google.cloud.deploy.v1.ListDeliveryPipelinesRequest
	38,  // 209: google.cloud.deploy.v1.CloudDeploy.GetDeliveryPipeline:input_type -> google.cloud.deploy.v1.GetDeliveryPipelineRequest
	39,  // 210: google.cloud.deploy.v1.CloudDeploy.CreateDeliveryPipeline:input_type -> google.cloud.deploy.v1.CreateDeliveryPipelineRequest
	40,  // 211: google.cloud.deploy.v1.CloudDeploy.UpdateDeliveryPipeline:input_type -> google.cloud.deploy.v1.UpdateDeliveryPipelineRequest
	41,  // 212: google.cloud.deploy.v1.CloudDeploy.DeleteDeliveryPipeline:input_type -> google.cloud.deploy.v1.DeleteDeliveryPipelineRequest
	54,  // 213: google.cloud.deploy.v1.CloudDeploy.ListTargets:input_type -> google.cloud.deploy.v1.ListTargetsRequest
	43,  // 214: google.cloud.deploy.v1.CloudDeploy.RollbackTarget:input_type -> google.cloud.deploy.v1.RollbackTargetRequest
	56,  // 215: google.cloud.deploy.v1.CloudDeploy.GetTarget:input_type -> google.cloud.deploy.v1.GetTargetRequest
	57,  // 216: google.cloud.deploy.v1.CloudDeploy.CreateTarget:input_type -> google.cloud.deploy.v1.CreateTargetRequest
	58,  // 217: google.cloud.deploy.v1.CloudDeploy.UpdateTarget:input_type -> google.cloud.deploy.v1.UpdateTargetRequest
	59,  // 218: google.cloud.deploy.v1.CloudDeploy.DeleteTarget:input_type -> google.cloud.deploy.v1.DeleteTargetRequest
	63,  // 219: google.cloud.deploy.v1.CloudDeploy.ListCustomTargetTypes:input_type -> google.cloud.deploy.v1.ListCustomTargetTypesRequest
	65,  // 220: google.cloud.deploy.v1.CloudDeploy.GetCustomTargetType:input_type -> google.cloud.deploy.v1.GetCustomTargetTypeRequest
	66,  // 221: google.cloud.deploy.v1.CloudDeploy.CreateCustomTargetType:input_type -> google.cloud.deploy.v1.CreateCustomTargetTypeRequest
	67,  // 222: google.cloud.deploy.v1.CloudDeploy.UpdateCustomTargetType:input_type -> google.cloud.deploy.v1.UpdateCustomTargetTypeRequest
	68,  // 223: google.cloud.deploy.v1.CloudDeploy.DeleteCustomTargetType:input_type -> google.cloud.deploy.v1.DeleteCustomTargetTypeRequest
	76,  // 224: google.cloud.deploy.v1.CloudDeploy.ListReleases:input_type -> google.cloud.deploy.v1.ListReleasesRequest
	78,  // 225: google.cloud.deploy.v1.CloudDeploy.GetRelease:input_type -> google.cloud.deploy.v1.GetReleaseRequest
	79,  // 226: google.cloud.deploy.v1.CloudDeploy.CreateRelease:input_type -> google.cloud.deploy.v1.CreateReleaseRequest
	112, // 227: google.cloud.deploy.v1.CloudDeploy.AbandonRelease:input_type -> google.cloud.deploy.v1.AbandonReleaseRequest
	102, // 228: google.cloud.deploy.v1.CloudDeploy.ApproveRollout:input_type -> google.cloud.deploy.v1.ApproveRolloutRequest
	104, // 229: google.cloud.deploy.v1.CloudDeploy.AdvanceRollout:input_type -> google.cloud.deploy.v1.AdvanceRolloutRequest
	106, // 230: google.cloud.deploy.v1.CloudDeploy.CancelRollout:input_type -> google.cloud.deploy.v1.CancelRolloutRequest
	97,  // 231: google.cloud.deploy.v1.CloudDeploy.ListRollouts:input_type -> google.cloud.deploy.v1.ListRolloutsRequest
	99,  // 232: google.cloud.deploy.v1.CloudDeploy.GetRollout:input_type -> google.cloud.deploy.v1.GetRolloutRequest
	100, // 233: google.cloud.deploy.v1.CloudDeploy.CreateRollout:input_type -> google.cloud.deploy.v1.CreateRolloutRequest
	108, // 234: google.cloud.deploy.v1.CloudDeploy.IgnoreJob:input_type -> google.cloud.deploy.v1.IgnoreJobRequest
	110, // 235: google.cloud.deploy.v1.CloudDeploy.RetryJob:input_type -> google.cloud.deploy.v1.RetryJobRequest
	121, // 236: google.cloud.deploy.v1.CloudDeploy.ListJobRuns:input_type -> google.cloud.deploy.v1.ListJobRunsRequest
	123, // 237: google.cloud.deploy.v1.CloudDeploy.GetJobRun:input_type -> google.cloud.deploy.v1.GetJobRunRequest
	124, // 238: google.cloud.deploy.v1.CloudDeploy.TerminateJobRun:input_type -> google.cloud.deploy.v1.TerminateJobRunRequest
	128, // 239: google.cloud.deploy.v1.CloudDeploy.GetConfig:input_type -> google.cloud.deploy.v1.GetConfigRequest
	139, // 240: google.cloud.deploy.v1.CloudDeploy.CreateAutomation:input_type -> google.cloud.deploy.v1.CreateAutomationRequest
	140, // 241: google.cloud.deploy.v1.CloudDeploy.UpdateAutomation:input_type -> google.cloud.deploy.v1.UpdateAutomationRequest
	141, // 242: google.cloud.deploy.v1.CloudDeploy.DeleteAutomation:input_type -> google.cloud.deploy.v1.DeleteAutomationRequest
	144, // 243: google.cloud.deploy.v1.CloudDeploy.GetAutomation:input_type -> google.cloud.deploy.v1.GetAutomationRequest
	142, // 244: google.cloud.deploy.v1.CloudDeploy.ListAutomations:input_type -> google.cloud.deploy.v1.ListAutomationsRequest
	155, // 245: google.cloud.deploy.v1.CloudDeploy.GetAutomationRun:input_type -> google.cloud.deploy.v1.GetAutomationRunRequest
	153, // 246: google.cloud.deploy.v1.CloudDeploy.ListAutomationRuns:input_type -> google.cloud.deploy.v1.ListAutomationRunsRequest
	156, // 247: google.cloud.deploy.v1.CloudDeploy.CancelAutomationRun:input_type -> google.cloud.deploy.v1.CancelAutomationRunRequest
	37,  // 248: google.cloud.deploy.v1.CloudDeploy.ListDeliveryPipelines:output_type -> google.cloud.deploy.v1.ListDeliveryPipelinesResponse
	18,  // 249: google.cloud.deploy.v1.CloudDeploy.GetDeliveryPipeline:output_type -> google.cloud.deploy.v1.DeliveryPipeline
	193, // 250: google.cloud.deploy.v1.CloudDeploy.CreateDeliveryPipeline:output_type -> google.longrunning.Operation
	193, // 251: google.cloud.deploy.v1.CloudDeploy.UpdateDeliveryPipeline:output_type -> google.longrunning.Operation
	193, // 252: google.cloud.deploy.v1.CloudDeploy.DeleteDeliveryPipeline:output_type -> google.longrunning.Operation
	55,  // 253: google.cloud.deploy.v1.CloudDeploy.ListTargets:output_type -> google.cloud.deploy.v1.ListTargetsResponse
	44,  // 254: google.cloud.deploy.v1.CloudDeploy.RollbackTarget:output_type -> google.cloud.deploy.v1.RollbackTargetResponse
	45,  // 255: google.cloud.deploy.v1.CloudDeploy.GetTarget:output_type -> google.cloud.deploy.v1.Target
	193, // 256: google.cloud.deploy.v1.CloudDeploy.CreateTarget:output_type -> google.longrunning.Operation
	193, // 257: google.cloud.deploy.v1.CloudDeploy.UpdateTarget:output_type -> google.longrunning.Operation
	193, // 258: google.cloud.deploy.v1.CloudDeploy.DeleteTarget:output_type -> google.longrunning.Operation
	64,  // 259: google.cloud.deploy.v1.CloudDeploy.ListCustomTargetTypes:output_type -> google.cloud.deploy.v1.ListCustomTargetTypesResponse
	60,  // 260: google.cloud.deploy.v1.CloudDeploy.GetCustomTargetType:output_type -> google.cloud.deploy.v1.CustomTargetType
	193, // 261: google.cloud.deploy.v1.CloudDeploy.CreateCustomTargetType:output_type -> google.longrunning.Operation
	193, // 262: google.cloud.deploy.v1.CloudDeploy.UpdateCustomTargetType:output_type -> google.longrunning.Operation
	193, // 263: google.cloud.deploy.v1.CloudDeploy.DeleteCustomTargetType:output_type -> google.longrunning.Operation
	77,  // 264: google.cloud.deploy.v1.CloudDeploy.ListReleases:output_type -> google.cloud.deploy.v1.ListReleasesResponse
	70,  // 265: google.cloud.deploy.v1.CloudDeploy.GetRelease:output_type -> google.cloud.deploy.v1.Release
	193, // 266: google.cloud.deploy.v1.CloudDeploy.CreateRelease:output_type -> google.longrunning.Operation
	113, // 267: google.cloud.deploy.v1.CloudDeploy.AbandonRelease:output_type -> google.cloud.deploy.v1.AbandonReleaseResponse
	103, // 268: google.cloud.deploy.v1.CloudDeploy.ApproveRollout:output_type -> google.cloud.deploy.v1.ApproveRolloutResponse
	105, // 269: google.cloud.deploy.v1.CloudDeploy.AdvanceRollout:output_type -> google.cloud.deploy.v1.AdvanceRolloutResponse
	107, // 270: google.cloud.deploy.v1.CloudDeploy.CancelRollout:output_type -> google.cloud.deploy.v1.CancelRolloutResponse
	98,  // 271: google.cloud.deploy.v1.CloudDeploy.ListRollouts:output_type -> google.cloud.deploy.v1.ListRolloutsResponse
	80,  // 272: google.cloud.deploy.v1.CloudDeploy.GetRollout:output_type -> google.cloud.deploy.v1.Rollout
	193, // 273: google.cloud.deploy.v1.CloudDeploy.CreateRollout:output_type -> google.longrunning.Operation
	109, // 274: google.cloud.deploy.v1.CloudDeploy.IgnoreJob:output_type -> google.cloud.deploy.v1.IgnoreJobResponse
	111, // 275: google.cloud.deploy.v1.CloudDeploy.RetryJob:output_type -> google.cloud.deploy.v1.RetryJobResponse
	122, // 276: google.cloud.deploy.v1.CloudDeploy.ListJobRuns:output_type -> google.cloud.deploy.v1.ListJobRunsResponse
	114, // 277: google.cloud.deploy.v1.CloudDeploy.GetJobRun:output_type -> google.cloud.deploy.v1.JobRun
	125, // 278: google.cloud.deploy.v1.CloudDeploy.TerminateJobRun:output_type -> google.cloud.deploy.v1.TerminateJobRunResponse
	126, // 279: google.cloud.deploy.v1.CloudDeploy.GetConfig:output_type -> google.cloud.deploy.v1.Config
	193, // 280: google.cloud.deploy.v1.CloudDeploy.CreateAutomation:output_type -> google.longrunning.Operation
	193, // 281: google.cloud.deploy.v1.CloudDeploy.UpdateAutomation:output_type -> google.longrunning.Operation
	193, // 282: google.cloud.deploy.v1.CloudDeploy.DeleteAutomation:output_type -> google.longrunning.Operation
	129, // 283: google.cloud.deploy.v1.CloudDeploy.GetAutomation:output_type -> google.cloud.deploy.v1.Automation
	143, // 284: google.cloud.deploy.v1.CloudDeploy.ListAutomations:output_type -> google.cloud.deploy.v1.ListAutomationsResponse
	145, // 285: google.cloud.deploy.v1.CloudDeploy.GetAutomationRun:output_type -> google.cloud.deploy.v1.AutomationRun
	154, // 286: google.cloud.deploy.v1.CloudDeploy.ListAutomationRuns:output_type -> google.cloud.deploy.v1.ListAutomationRunsResponse
	157, // 287: google.cloud.deploy.v1.CloudDeploy.CancelAutomationRun:output_type -> google.cloud.deploy.v1.CancelAutomationRunResponse
	248, // [248:288] is the sub-list for method output_type
	208, // [208:248] is the sub-list for method input_type
	208, // [208:208] is the sub-list for extension type_name
	208, // [208:208] is the sub-list for extension extendee
	0,   // [0:208] is the sub-list for field type_name
}

func init() { file_google_cloud_deploy_v1_cloud_deploy_proto_init() }
func file_google_cloud_deploy_v1_cloud_deploy_proto_init() {
	if File_google_cloud_deploy_v1_cloud_deploy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeliveryPipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SerialPipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Strategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Predeploy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Postdeploy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Standard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Canary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CanaryDeployment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomCanaryDeployment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRunConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineReadyCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetsPresentCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetsTypeCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeliveryPipelinesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeliveryPipelinesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackTargetConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackTargetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultPool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivatePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnthosCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRunLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MultiTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomTargetType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomTargetSkaffoldActions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkaffoldModules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomTargetTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomTargetTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomTargetTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomTargetTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomTargetTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCustomTargetTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Release); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRunRenderMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenderMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReleaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReleaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rollout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployJobRunMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRunMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomTargetDeployMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutomationRolloutMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Phase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeploymentJobs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChildRolloutJobs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredeployJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostdeployJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChildRolloutJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdvanceChildRolloutJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRolloutsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRolloutsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveRolloutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdvanceRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdvanceRolloutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelRolloutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IgnoreJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IgnoreJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbandonReleaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbandonReleaseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredeployJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostdeployJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChildRolloutJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdvanceChildRolloutJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobRunsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobRunsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerminateJobRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerminateJobRunResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkaffoldVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Automation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutomationResourceSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutomationRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PromoteReleaseRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[115].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdvanceRolloutRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepairRolloutRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepairMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Retry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rollback); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[120].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutomationRuleCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[121].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAutomationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[122].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAutomationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[123].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAutomationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[124].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAutomationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[125].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAutomationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[126].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAutomationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[127].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutomationRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[128].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PromoteReleaseOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[129].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdvanceRolloutOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[130].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepairRolloutOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[131].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepairPhase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[132].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryPhase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[133].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryAttempt); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[134].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackAttempt); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[135].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAutomationRunsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[136].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAutomationRunsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[137].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAutomationRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[138].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelAutomationRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[139].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelAutomationRunResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[144].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomCanaryDeployment_PhaseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[145].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesConfig_GatewayServiceMesh); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[146].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesConfig_ServiceNetworking); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[152].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkaffoldModules_SkaffoldGitSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[153].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkaffoldModules_SkaffoldGCSSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[155].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Release_TargetRender); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[156].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Release_ReleaseReadyCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[157].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Release_SkaffoldSupportedCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[158].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Release_ReleaseCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[164].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetArtifact_PhaseArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*DeliveryPipeline_SerialPipeline)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Strategy_Standard)(nil),
		(*Strategy_Canary)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*Canary_CanaryDeployment)(nil),
		(*Canary_CustomCanaryDeployment)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*KubernetesConfig_GatewayServiceMesh_)(nil),
		(*KubernetesConfig_ServiceNetworking_)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*RuntimeConfig_Kubernetes)(nil),
		(*RuntimeConfig_CloudRun)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*Target_Gke)(nil),
		(*Target_AnthosCluster)(nil),
		(*Target_Run)(nil),
		(*Target_MultiTarget)(nil),
		(*Target_CustomTarget)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[28].OneofWrappers = []interface{}{
		(*ExecutionConfig_DefaultPool)(nil),
		(*ExecutionConfig_PrivatePool)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[42].OneofWrappers = []interface{}{
		(*CustomTargetType_CustomActions)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[44].OneofWrappers = []interface{}{
		(*SkaffoldModules_Git)(nil),
		(*SkaffoldModules_GoogleCloudStorage)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54].OneofWrappers = []interface{}{
		(*TargetArtifact_ArtifactUri)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[69].OneofWrappers = []interface{}{
		(*Phase_DeploymentJobs)(nil),
		(*Phase_ChildRolloutJobs)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[72].OneofWrappers = []interface{}{
		(*Job_DeployJob)(nil),
		(*Job_VerifyJob)(nil),
		(*Job_PredeployJob)(nil),
		(*Job_PostdeployJob)(nil),
		(*Job_CreateChildRolloutJob)(nil),
		(*Job_AdvanceChildRolloutJob)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[96].OneofWrappers = []interface{}{
		(*JobRun_DeployJobRun)(nil),
		(*JobRun_VerifyJobRun)(nil),
		(*JobRun_PredeployJobRun)(nil),
		(*JobRun_PostdeployJobRun)(nil),
		(*JobRun_CreateChildRolloutJobRun)(nil),
		(*JobRun_AdvanceChildRolloutJobRun)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[113].OneofWrappers = []interface{}{
		(*AutomationRule_PromoteReleaseRule)(nil),
		(*AutomationRule_AdvanceRolloutRule)(nil),
		(*AutomationRule_RepairRolloutRule)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[117].OneofWrappers = []interface{}{
		(*RepairMode_Retry)(nil),
		(*RepairMode_Rollback)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[127].OneofWrappers = []interface{}{
		(*AutomationRun_PromoteReleaseOperation)(nil),
		(*AutomationRun_AdvanceRolloutOperation)(nil),
		(*AutomationRun_RepairRolloutOperation)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[131].OneofWrappers = []interface{}{
		(*RepairPhase_Retry)(nil),
		(*RepairPhase_Rollback)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc,
			NumEnums:      18,
			NumMessages:   171,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_deploy_v1_cloud_deploy_proto_goTypes,
		DependencyIndexes: file_google_cloud_deploy_v1_cloud_deploy_proto_depIdxs,
		EnumInfos:         file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes,
		MessageInfos:      file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes,
	}.Build()
	File_google_cloud_deploy_v1_cloud_deploy_proto = out.File
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc = nil
	file_google_cloud_deploy_v1_cloud_deploy_proto_goTypes = nil
	file_google_cloud_deploy_v1_cloud_deploy_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudDeployClient is the client API for CloudDeploy service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudDeployClient interface {
	// Lists DeliveryPipelines in a given project and location.
	ListDeliveryPipelines(ctx context.Context, in *ListDeliveryPipelinesRequest, opts ...grpc.CallOption) (*ListDeliveryPipelinesResponse, error)
	// Gets details of a single DeliveryPipeline.
	GetDeliveryPipeline(ctx context.Context, in *GetDeliveryPipelineRequest, opts ...grpc.CallOption) (*DeliveryPipeline, error)
	// Creates a new DeliveryPipeline in a given project and location.
	CreateDeliveryPipeline(ctx context.Context, in *CreateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single DeliveryPipeline.
	UpdateDeliveryPipeline(ctx context.Context, in *UpdateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single DeliveryPipeline.
	DeleteDeliveryPipeline(ctx context.Context, in *DeleteDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Targets in a given project and location.
	ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error)
	// Creates a `Rollout` to roll back the specified target.
	RollbackTarget(ctx context.Context, in *RollbackTargetRequest, opts ...grpc.CallOption) (*RollbackTargetResponse, error)
	// Gets details of a single Target.
	GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Creates a new Target in a given project and location.
	CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Target.
	UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Target.
	DeleteTarget(ctx context.Context, in *DeleteTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CustomTargetTypes in a given project and location.
	ListCustomTargetTypes(ctx context.Context, in *ListCustomTargetTypesRequest, opts ...grpc.CallOption) (*ListCustomTargetTypesResponse, error)
	// Gets details of a single CustomTargetType.
	GetCustomTargetType(ctx context.Context, in *GetCustomTargetTypeRequest, opts ...grpc.CallOption) (*CustomTargetType, error)
	// Creates a new CustomTargetType in a given project and location.
	CreateCustomTargetType(ctx context.Context, in *CreateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a single CustomTargetType.
	UpdateCustomTargetType(ctx context.Context, in *UpdateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single CustomTargetType.
	DeleteCustomTargetType(ctx context.Context, in *DeleteCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Releases in a given project and location.
	ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error)
	// Gets details of a single Release.
	GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error)
	// Creates a new Release in a given project and location.
	CreateRelease(ctx context.Context, in *CreateReleaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Abandons a Release in the Delivery Pipeline.
	AbandonRelease(ctx context.Context, in *AbandonReleaseRequest, opts ...grpc.CallOption) (*AbandonReleaseResponse, error)
	// Approves a Rollout.
	ApproveRollout(ctx context.Context, in *ApproveRolloutRequest, opts ...grpc.CallOption) (*ApproveRolloutResponse, error)
	// Advances a Rollout in a given project and location.
	AdvanceRollout(ctx context.Context, in *AdvanceRolloutRequest, opts ...grpc.CallOption) (*AdvanceRolloutResponse, error)
	// Cancels a Rollout in a given project and location.
	CancelRollout(ctx context.Context, in *CancelRolloutRequest, opts ...grpc.CallOption) (*CancelRolloutResponse, error)
	// Lists Rollouts in a given project and location.
	ListRollouts(ctx context.Context, in *ListRolloutsRequest, opts ...grpc.CallOption) (*ListRolloutsResponse, error)
	// Gets details of a single Rollout.
	GetRollout(ctx context.Context, in *GetRolloutRequest, opts ...grpc.CallOption) (*Rollout, error)
	// Creates a new Rollout in a given project and location.
	CreateRollout(ctx context.Context, in *CreateRolloutRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Ignores the specified Job in a Rollout.
	IgnoreJob(ctx context.Context, in *IgnoreJobRequest, opts ...grpc.CallOption) (*IgnoreJobResponse, error)
	// Retries the specified Job in a Rollout.
	RetryJob(ctx context.Context, in *RetryJobRequest, opts ...grpc.CallOption) (*RetryJobResponse, error)
	// Lists JobRuns in a given project and location.
	ListJobRuns(ctx context.Context, in *ListJobRunsRequest, opts ...grpc.CallOption) (*ListJobRunsResponse, error)
	// Gets details of a single JobRun.
	GetJobRun(ctx context.Context, in *GetJobRunRequest, opts ...grpc.CallOption) (*JobRun, error)
	// Terminates a Job Run in a given project and location.
	TerminateJobRun(ctx context.Context, in *TerminateJobRunRequest, opts ...grpc.CallOption) (*TerminateJobRunResponse, error)
	// Gets the configuration for a location.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error)
	// Creates a new Automation in a given project and location.
	CreateAutomation(ctx context.Context, in *CreateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Automation resource.
	UpdateAutomation(ctx context.Context, in *UpdateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Automation resource.
	DeleteAutomation(ctx context.Context, in *DeleteAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Automation.
	GetAutomation(ctx context.Context, in *GetAutomationRequest, opts ...grpc.CallOption) (*Automation, error)
	// Lists Automations in a given project and location.
	ListAutomations(ctx context.Context, in *ListAutomationsRequest, opts ...grpc.CallOption) (*ListAutomationsResponse, error)
	// Gets details of a single AutomationRun.
	GetAutomationRun(ctx context.Context, in *GetAutomationRunRequest, opts ...grpc.CallOption) (*AutomationRun, error)
	// Lists AutomationRuns in a given project and location.
	ListAutomationRuns(ctx context.Context, in *ListAutomationRunsRequest, opts ...grpc.CallOption) (*ListAutomationRunsResponse, error)
	// Cancels an AutomationRun. The `state` of the `AutomationRun` after
	// cancelling is `CANCELLED`. `CancelAutomationRun` can be called on
	// AutomationRun in the state `IN_PROGRESS` and `PENDING`; AutomationRun
	// in a different state returns an `FAILED_PRECONDITION` error.
	CancelAutomationRun(ctx context.Context, in *CancelAutomationRunRequest, opts ...grpc.CallOption) (*CancelAutomationRunResponse, error)
}

type cloudDeployClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudDeployClient(cc grpc.ClientConnInterface) CloudDeployClient {
	return &cloudDeployClient{cc}
}

func (c *cloudDeployClient) ListDeliveryPipelines(ctx context.Context, in *ListDeliveryPipelinesRequest, opts ...grpc.CallOption) (*ListDeliveryPipelinesResponse, error) {
	out := new(ListDeliveryPipelinesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListDeliveryPipelines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetDeliveryPipeline(ctx context.Context, in *GetDeliveryPipelineRequest, opts ...grpc.CallOption) (*DeliveryPipeline, error) {
	out := new(DeliveryPipeline)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateDeliveryPipeline(ctx context.Context, in *CreateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateDeliveryPipeline(ctx context.Context, in *UpdateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/UpdateDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteDeliveryPipeline(ctx context.Context, in *DeleteDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/DeleteDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error) {
	out := new(ListTargetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) RollbackTarget(ctx context.Context, in *RollbackTargetRequest, opts ...grpc.CallOption) (*RollbackTargetResponse, error) {
	out := new(RollbackTargetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/RollbackTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/UpdateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteTarget(ctx context.Context, in *DeleteTargetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/DeleteTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListCustomTargetTypes(ctx context.Context, in *ListCustomTargetTypesRequest, opts ...grpc.CallOption) (*ListCustomTargetTypesResponse, error) {
	out := new(ListCustomTargetTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListCustomTargetTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetCustomTargetType(ctx context.Context, in *GetCustomTargetTypeRequest, opts ...grpc.CallOption) (*CustomTargetType, error) {
	out := new(CustomTargetType)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetCustomTargetType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateCustomTargetType(ctx context.Context, in *CreateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateCustomTargetType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateCustomTargetType(ctx context.Context, in *UpdateCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/UpdateCustomTargetType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteCustomTargetType(ctx context.Context, in *DeleteCustomTargetTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/DeleteCustomTargetType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error) {
	out := new(ListReleasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListReleases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error) {
	out := new(Release)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateRelease(ctx context.Context, in *CreateReleaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) AbandonRelease(ctx context.Context, in *AbandonReleaseRequest, opts ...grpc.CallOption) (*AbandonReleaseResponse, error) {
	out := new(AbandonReleaseResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/AbandonRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ApproveRollout(ctx context.Context, in *ApproveRolloutRequest, opts ...grpc.CallOption) (*ApproveRolloutResponse, error) {
	out := new(ApproveRolloutResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ApproveRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) AdvanceRollout(ctx context.Context, in *AdvanceRolloutRequest, opts ...grpc.CallOption) (*AdvanceRolloutResponse, error) {
	out := new(AdvanceRolloutResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/AdvanceRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CancelRollout(ctx context.Context, in *CancelRolloutRequest, opts ...grpc.CallOption) (*CancelRolloutResponse, error) {
	out := new(CancelRolloutResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CancelRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListRollouts(ctx context.Context, in *ListRolloutsRequest, opts ...grpc.CallOption) (*ListRolloutsResponse, error) {
	out := new(ListRolloutsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListRollouts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetRollout(ctx context.Context, in *GetRolloutRequest, opts ...grpc.CallOption) (*Rollout, error) {
	out := new(Rollout)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateRollout(ctx context.Context, in *CreateRolloutRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) IgnoreJob(ctx context.Context, in *IgnoreJobRequest, opts ...grpc.CallOption) (*IgnoreJobResponse, error) {
	out := new(IgnoreJobResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/IgnoreJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) RetryJob(ctx context.Context, in *RetryJobRequest, opts ...grpc.CallOption) (*RetryJobResponse, error) {
	out := new(RetryJobResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/RetryJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListJobRuns(ctx context.Context, in *ListJobRunsRequest, opts ...grpc.CallOption) (*ListJobRunsResponse, error) {
	out := new(ListJobRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListJobRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetJobRun(ctx context.Context, in *GetJobRunRequest, opts ...grpc.CallOption) (*JobRun, error) {
	out := new(JobRun)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetJobRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) TerminateJobRun(ctx context.Context, in *TerminateJobRunRequest, opts ...grpc.CallOption) (*TerminateJobRunResponse, error) {
	out := new(TerminateJobRunResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/TerminateJobRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error) {
	out := new(Config)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateAutomation(ctx context.Context, in *CreateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateAutomation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateAutomation(ctx context.Context, in *UpdateAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/UpdateAutomation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteAutomation(ctx context.Context, in *DeleteAutomationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/DeleteAutomation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetAutomation(ctx context.Context, in *GetAutomationRequest, opts ...grpc.CallOption) (*Automation, error) {
	out := new(Automation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetAutomation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListAutomations(ctx context.Context, in *ListAutomationsRequest, opts ...grpc.CallOption) (*ListAutomationsResponse, error) {
	out := new(ListAutomationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListAutomations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetAutomationRun(ctx context.Context, in *GetAutomationRunRequest, opts ...grpc.CallOption) (*AutomationRun, error) {
	out := new(AutomationRun)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetAutomationRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListAutomationRuns(ctx context.Context, in *ListAutomationRunsRequest, opts ...grpc.CallOption) (*ListAutomationRunsResponse, error) {
	out := new(ListAutomationRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListAutomationRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CancelAutomationRun(ctx context.Context, in *CancelAutomationRunRequest, opts ...grpc.CallOption) (*CancelAutomationRunResponse, error) {
	out := new(CancelAutomationRunResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CancelAutomationRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudDeployServer is the server API for CloudDeploy service.
type CloudDeployServer interface {
	// Lists DeliveryPipelines in a given project and location.
	ListDeliveryPipelines(context.Context, *ListDeliveryPipelinesRequest) (*ListDeliveryPipelinesResponse, error)
	// Gets details of a single DeliveryPipeline.
	GetDeliveryPipeline(context.Context, *GetDeliveryPipelineRequest) (*DeliveryPipeline, error)
	// Creates a new DeliveryPipeline in a given project and location.
	CreateDeliveryPipeline(context.Context, *CreateDeliveryPipelineRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single DeliveryPipeline.
	UpdateDeliveryPipeline(context.Context, *UpdateDeliveryPipelineRequest) (*longrunningpb.Operation, error)
	// Deletes a single DeliveryPipeline.
	DeleteDeliveryPipeline(context.Context, *DeleteDeliveryPipelineRequest) (*longrunningpb.Operation, error)
	// Lists Targets in a given project and location.
	ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error)
	// Creates a `Rollout` to roll back the specified target.
	RollbackTarget(context.Context, *RollbackTargetRequest) (*RollbackTargetResponse, error)
	// Gets details of a single Target.
	GetTarget(context.Context, *GetTargetRequest) (*Target, error)
	// Creates a new Target in a given project and location.
	CreateTarget(context.Context, *CreateTargetRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Target.
	UpdateTarget(context.Context, *UpdateTargetRequest) (*longrunningpb.Operation, error)
	// Deletes a single Target.
	DeleteTarget(context.Context, *DeleteTargetRequest) (*longrunningpb.Operation, error)
	// Lists CustomTargetTypes in a given project and location.
	ListCustomTargetTypes(context.Context, *ListCustomTargetTypesRequest) (*ListCustomTargetTypesResponse, error)
	// Gets details of a single CustomTargetType.
	GetCustomTargetType(context.Context, *GetCustomTargetTypeRequest) (*CustomTargetType, error)
	// Creates a new CustomTargetType in a given project and location.
	CreateCustomTargetType(context.Context, *CreateCustomTargetTypeRequest) (*longrunningpb.Operation, error)
	// Updates a single CustomTargetType.
	UpdateCustomTargetType(context.Context, *UpdateCustomTargetTypeRequest) (*longrunningpb.Operation, error)
	// Deletes a single CustomTargetType.
	DeleteCustomTargetType(context.Context, *DeleteCustomTargetTypeRequest) (*longrunningpb.Operation, error)
	// Lists Releases in a given project and location.
	ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error)
	// Gets details of a single Release.
	GetRelease(context.Context, *GetReleaseRequest) (*Release, error)
	// Creates a new Release in a given project and location.
	CreateRelease(context.Context, *CreateReleaseRequest) (*longrunningpb.Operation, error)
	// Abandons a Release in the Delivery Pipeline.
	AbandonRelease(context.Context, *AbandonReleaseRequest) (*AbandonReleaseResponse, error)
	// Approves a Rollout.
	ApproveRollout(context.Context, *ApproveRolloutRequest) (*ApproveRolloutResponse, error)
	// Advances a Rollout in a given project and location.
	AdvanceRollout(context.Context, *AdvanceRolloutRequest) (*AdvanceRolloutResponse, error)
	// Cancels a Rollout in a given project and location.
	CancelRollout(context.Context, *CancelRolloutRequest) (*CancelRolloutResponse, error)
	// Lists Rollouts in a given project and location.
	ListRollouts(context.Context, *ListRolloutsRequest) (*ListRolloutsResponse, error)
	// Gets details of a single Rollout.
	GetRollout(context.Context, *GetRolloutRequest) (*Rollout, error)
	// Creates a new Rollout in a given project and location.
	CreateRollout(context.Context, *CreateRolloutRequest) (*longrunningpb.Operation, error)
	// Ignores the specified Job in a Rollout.
	IgnoreJob(context.Context, *IgnoreJobRequest) (*IgnoreJobResponse, error)
	// Retries the specified Job in a Rollout.
	RetryJob(context.Context, *RetryJobRequest) (*RetryJobResponse, error)
	// Lists JobRuns in a given project and location.
	ListJobRuns(context.Context, *ListJobRunsRequest) (*ListJobRunsResponse, error)
	// Gets details of a single JobRun.
	GetJobRun(context.Context, *GetJobRunRequest) (*JobRun, error)
	// Terminates a Job Run in a given project and location.
	TerminateJobRun(context.Context, *TerminateJobRunRequest) (*TerminateJobRunResponse, error)
	// Gets the configuration for a location.
	GetConfig(context.Context, *GetConfigRequest) (*Config, error)
	// Creates a new Automation in a given project and location.
	CreateAutomation(context.Context, *CreateAutomationRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Automation resource.
	UpdateAutomation(context.Context, *UpdateAutomationRequest) (*longrunningpb.Operation, error)
	// Deletes a single Automation resource.
	DeleteAutomation(context.Context, *DeleteAutomationRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Automation.
	GetAutomation(context.Context, *GetAutomationRequest) (*Automation, error)
	// Lists Automations in a given project and location.
	ListAutomations(context.Context, *ListAutomationsRequest) (*ListAutomationsResponse, error)
	// Gets details of a single AutomationRun.
	GetAutomationRun(context.Context, *GetAutomationRunRequest) (*AutomationRun, error)
	// Lists AutomationRuns in a given project and location.
	ListAutomationRuns(context.Context, *ListAutomationRunsRequest) (*ListAutomationRunsResponse, error)
	// Cancels an AutomationRun. The `state` of the `AutomationRun` after
	// cancelling is `CANCELLED`. `CancelAutomationRun` can be called on
	// AutomationRun in the state `IN_PROGRESS` and `PENDING`; AutomationRun
	// in a different state returns an `FAILED_PRECONDITION` error.
	CancelAutomationRun(context.Context, *CancelAutomationRunRequest) (*CancelAutomationRunResponse, error)
}

// UnimplementedCloudDeployServer can be embedded to have forward compatible implementations.
type UnimplementedCloudDeployServer struct {
}

func (*UnimplementedCloudDeployServer) ListDeliveryPipelines(context.Context, *ListDeliveryPipelinesRequest) (*ListDeliveryPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeliveryPipelines not implemented")
}
func (*UnimplementedCloudDeployServer) GetDeliveryPipeline(context.Context, *GetDeliveryPipelineRequest) (*DeliveryPipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) CreateDeliveryPipeline(context.Context, *CreateDeliveryPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) UpdateDeliveryPipeline(context.Context, *UpdateDeliveryPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) DeleteDeliveryPipeline(context.Context, *DeleteDeliveryPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargets not implemented")
}
func (*UnimplementedCloudDeployServer) RollbackTarget(context.Context, *RollbackTargetRequest) (*RollbackTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackTarget not implemented")
}
func (*UnimplementedCloudDeployServer) GetTarget(context.Context, *GetTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTarget not implemented")
}
func (*UnimplementedCloudDeployServer) CreateTarget(context.Context, *CreateTargetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTarget not implemented")
}
func (*UnimplementedCloudDeployServer) UpdateTarget(context.Context, *UpdateTargetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTarget not implemented")
}
func (*UnimplementedCloudDeployServer) DeleteTarget(context.Context, *DeleteTargetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTarget not implemented")
}
func (*UnimplementedCloudDeployServer) ListCustomTargetTypes(context.Context, *ListCustomTargetTypesRequest) (*ListCustomTargetTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomTargetTypes not implemented")
}
func (*UnimplementedCloudDeployServer) GetCustomTargetType(context.Context, *GetCustomTargetTypeRequest) (*CustomTargetType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomTargetType not implemented")
}
func (*UnimplementedCloudDeployServer) CreateCustomTargetType(context.Context, *CreateCustomTargetTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomTargetType not implemented")
}
func (*UnimplementedCloudDeployServer) UpdateCustomTargetType(context.Context, *UpdateCustomTargetTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomTargetType not implemented")
}
func (*UnimplementedCloudDeployServer) DeleteCustomTargetType(context.Context, *DeleteCustomTargetTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomTargetType not implemented")
}
func (*UnimplementedCloudDeployServer) ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReleases not implemented")
}
func (*UnimplementedCloudDeployServer) GetRelease(context.Context, *GetReleaseRequest) (*Release, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRelease not implemented")
}
func (*UnimplementedCloudDeployServer) CreateRelease(context.Context, *CreateReleaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRelease not implemented")
}
func (*UnimplementedCloudDeployServer) AbandonRelease(context.Context, *AbandonReleaseRequest) (*AbandonReleaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AbandonRelease not implemented")
}
func (*UnimplementedCloudDeployServer) ApproveRollout(context.Context, *ApproveRolloutRequest) (*ApproveRolloutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveRollout not implemented")
}
func (*UnimplementedCloudDeployServer) AdvanceRollout(context.Context, *AdvanceRolloutRequest) (*AdvanceRolloutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AdvanceRollout not implemented")
}
func (*UnimplementedCloudDeployServer) CancelRollout(context.Context, *CancelRolloutRequest) (*CancelRolloutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelRollout not implemented")
}
func (*UnimplementedCloudDeployServer) ListRollouts(context.Context, *ListRolloutsRequest) (*ListRolloutsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRollouts not implemented")
}
func (*UnimplementedCloudDeployServer) GetRollout(context.Context, *GetRolloutRequest) (*Rollout, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRollout not implemented")
}
func (*UnimplementedCloudDeployServer) CreateRollout(context.Context, *CreateRolloutRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRollout not implemented")
}
func (*UnimplementedCloudDeployServer) IgnoreJob(context.Context, *IgnoreJobRequest) (*IgnoreJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IgnoreJob not implemented")
}
func (*UnimplementedCloudDeployServer) RetryJob(context.Context, *RetryJobRequest) (*RetryJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetryJob not implemented")
}
func (*UnimplementedCloudDeployServer) ListJobRuns(context.Context, *ListJobRunsRequest) (*ListJobRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobRuns not implemented")
}
func (*UnimplementedCloudDeployServer) GetJobRun(context.Context, *GetJobRunRequest) (*JobRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobRun not implemented")
}
func (*UnimplementedCloudDeployServer) TerminateJobRun(context.Context, *TerminateJobRunRequest) (*TerminateJobRunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TerminateJobRun not implemented")
}
func (*UnimplementedCloudDeployServer) GetConfig(context.Context, *GetConfigRequest) (*Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (*UnimplementedCloudDeployServer) CreateAutomation(context.Context, *CreateAutomationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAutomation not implemented")
}
func (*UnimplementedCloudDeployServer) UpdateAutomation(context.Context, *UpdateAutomationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutomation not implemented")
}
func (*UnimplementedCloudDeployServer) DeleteAutomation(context.Context, *DeleteAutomationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAutomation not implemented")
}
func (*UnimplementedCloudDeployServer) GetAutomation(context.Context, *GetAutomationRequest) (*Automation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutomation not implemented")
}
func (*UnimplementedCloudDeployServer) ListAutomations(context.Context, *ListAutomationsRequest) (*ListAutomationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutomations not implemented")
}
func (*UnimplementedCloudDeployServer) GetAutomationRun(context.Context, *GetAutomationRunRequest) (*AutomationRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutomationRun not implemented")
}
func (*UnimplementedCloudDeployServer) ListAutomationRuns(context.Context, *ListAutomationRunsRequest) (*ListAutomationRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutomationRuns not implemented")
}
func (*UnimplementedCloudDeployServer) CancelAutomationRun(context.Context, *CancelAutomationRunRequest) (*CancelAutomationRunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelAutomationRun not implemented")
}

func RegisterCloudDeployServer(s *grpc.Server, srv CloudDeployServer) {
	s.RegisterService(&_CloudDeploy_serviceDesc, srv)
}

func _CloudDeploy_ListDeliveryPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeliveryPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListDeliveryPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListDeliveryPipelines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListDeliveryPipelines(ctx, req.(*ListDeliveryPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetDeliveryPipeline(ctx, req.(*GetDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateDeliveryPipeline(ctx, req.(*CreateDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/UpdateDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateDeliveryPipeline(ctx, req.(*UpdateDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/DeleteDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteDeliveryPipeline(ctx, req.(*DeleteDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListTargets(ctx, req.(*ListTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_RollbackTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).RollbackTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/RollbackTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).RollbackTarget(ctx, req.(*RollbackTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetTarget(ctx, req.(*GetTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateTarget(ctx, req.(*CreateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/UpdateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateTarget(ctx, req.(*UpdateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/DeleteTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteTarget(ctx, req.(*DeleteTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListCustomTargetTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomTargetTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListCustomTargetTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListCustomTargetTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListCustomTargetTypes(ctx, req.(*ListCustomTargetTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetCustomTargetType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetCustomTargetType(ctx, req.(*GetCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateCustomTargetType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateCustomTargetType(ctx, req.(*CreateCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/UpdateCustomTargetType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateCustomTargetType(ctx, req.(*UpdateCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteCustomTargetType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomTargetTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteCustomTargetType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/DeleteCustomTargetType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteCustomTargetType(ctx, req.(*DeleteCustomTargetTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListReleases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReleasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListReleases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListReleases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListReleases(ctx, req.(*ListReleasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetRelease(ctx, req.(*GetReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateRelease(ctx, req.(*CreateReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_AbandonRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AbandonReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).AbandonRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/AbandonRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).AbandonRelease(ctx, req.(*AbandonReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ApproveRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ApproveRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ApproveRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ApproveRollout(ctx, req.(*ApproveRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_AdvanceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AdvanceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).AdvanceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/AdvanceRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).AdvanceRollout(ctx, req.(*AdvanceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CancelRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CancelRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CancelRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CancelRollout(ctx, req.(*CancelRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListRollouts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRolloutsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListRollouts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListRollouts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListRollouts(ctx, req.(*ListRolloutsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetRollout(ctx, req.(*GetRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateRollout(ctx, req.(*CreateRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_IgnoreJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IgnoreJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).IgnoreJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/IgnoreJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).IgnoreJob(ctx, req.(*IgnoreJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_RetryJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetryJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).RetryJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/RetryJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).RetryJob(ctx, req.(*RetryJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListJobRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListJobRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListJobRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListJobRuns(ctx, req.(*ListJobRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetJobRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetJobRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetJobRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetJobRun(ctx, req.(*GetJobRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_TerminateJobRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TerminateJobRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).TerminateJobRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/TerminateJobRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).TerminateJobRun(ctx, req.(*TerminateJobRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateAutomation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateAutomation(ctx, req.(*CreateAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/UpdateAutomation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateAutomation(ctx, req.(*UpdateAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/DeleteAutomation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteAutomation(ctx, req.(*DeleteAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetAutomation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutomationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetAutomation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetAutomation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetAutomation(ctx, req.(*GetAutomationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListAutomations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutomationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListAutomations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListAutomations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListAutomations(ctx, req.(*ListAutomationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetAutomationRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutomationRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetAutomationRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetAutomationRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetAutomationRun(ctx, req.(*GetAutomationRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListAutomationRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutomationRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListAutomationRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListAutomationRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListAutomationRuns(ctx, req.(*ListAutomationRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CancelAutomationRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelAutomationRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CancelAutomationRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CancelAutomationRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CancelAutomationRun(ctx, req.(*CancelAutomationRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudDeploy_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.deploy.v1.CloudDeploy",
	HandlerType: (*CloudDeployServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDeliveryPipelines",
			Handler:    _CloudDeploy_ListDeliveryPipelines_Handler,
		},
		{
			MethodName: "GetDeliveryPipeline",
			Handler:    _CloudDeploy_GetDeliveryPipeline_Handler,
		},
		{
			MethodName: "CreateDeliveryPipeline",
			Handler:    _CloudDeploy_CreateDeliveryPipeline_Handler,
		},
		{
			MethodName: "UpdateDeliveryPipeline",
			Handler:    _CloudDeploy_UpdateDeliveryPipeline_Handler,
		},
		{
			MethodName: "DeleteDeliveryPipeline",
			Handler:    _CloudDeploy_DeleteDeliveryPipeline_Handler,
		},
		{
			MethodName: "ListTargets",
			Handler:    _CloudDeploy_ListTargets_Handler,
		},
		{
			MethodName: "RollbackTarget",
			Handler:    _CloudDeploy_RollbackTarget_Handler,
		},
		{
			MethodName: "GetTarget",
			Handler:    _CloudDeploy_GetTarget_Handler,
		},
		{
			MethodName: "CreateTarget",
			Handler:    _CloudDeploy_CreateTarget_Handler,
		},
		{
			MethodName: "UpdateTarget",
			Handler:    _CloudDeploy_UpdateTarget_Handler,
		},
		{
			MethodName: "DeleteTarget",
			Handler:    _CloudDeploy_DeleteTarget_Handler,
		},
		{
			MethodName: "ListCustomTargetTypes",
			Handler:    _CloudDeploy_ListCustomTargetTypes_Handler,
		},
		{
			MethodName: "GetCustomTargetType",
			Handler:    _CloudDeploy_GetCustomTargetType_Handler,
		},
		{
			MethodName: "CreateCustomTargetType",
			Handler:    _CloudDeploy_CreateCustomTargetType_Handler,
		},
		{
			MethodName: "UpdateCustomTargetType",
			Handler:    _CloudDeploy_UpdateCustomTargetType_Handler,
		},
		{
			MethodName: "DeleteCustomTargetType",
			Handler:    _CloudDeploy_DeleteCustomTargetType_Handler,
		},
		{
			MethodName: "ListReleases",
			Handler:    _CloudDeploy_ListReleases_Handler,
		},
		{
			MethodName: "GetRelease",
			Handler:    _CloudDeploy_GetRelease_Handler,
		},
		{
			MethodName: "CreateRelease",
			Handler:    _CloudDeploy_CreateRelease_Handler,
		},
		{
			MethodName: "AbandonRelease",
			Handler:    _CloudDeploy_AbandonRelease_Handler,
		},
		{
			MethodName: "ApproveRollout",
			Handler:    _CloudDeploy_ApproveRollout_Handler,
		},
		{
			MethodName: "AdvanceRollout",
			Handler:    _CloudDeploy_AdvanceRollout_Handler,
		},
		{
			MethodName: "CancelRollout",
			Handler:    _CloudDeploy_CancelRollout_Handler,
		},
		{
			MethodName: "ListRollouts",
			Handler:    _CloudDeploy_ListRollouts_Handler,
		},
		{
			MethodName: "GetRollout",
			Handler:    _CloudDeploy_GetRollout_Handler,
		},
		{
			MethodName: "CreateRollout",
			Handler:    _CloudDeploy_CreateRollout_Handler,
		},
		{
			MethodName: "IgnoreJob",
			Handler:    _CloudDeploy_IgnoreJob_Handler,
		},
		{
			MethodName: "RetryJob",
			Handler:    _CloudDeploy_RetryJob_Handler,
		},
		{
			MethodName: "ListJobRuns",
			Handler:    _CloudDeploy_ListJobRuns_Handler,
		},
		{
			MethodName: "GetJobRun",
			Handler:    _CloudDeploy_GetJobRun_Handler,
		},
		{
			MethodName: "TerminateJobRun",
			Handler:    _CloudDeploy_TerminateJobRun_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _CloudDeploy_GetConfig_Handler,
		},
		{
			MethodName: "CreateAutomation",
			Handler:    _CloudDeploy_CreateAutomation_Handler,
		},
		{
			MethodName: "UpdateAutomation",
			Handler:    _CloudDeploy_UpdateAutomation_Handler,
		},
		{
			MethodName: "DeleteAutomation",
			Handler:    _CloudDeploy_DeleteAutomation_Handler,
		},
		{
			MethodName: "GetAutomation",
			Handler:    _CloudDeploy_GetAutomation_Handler,
		},
		{
			MethodName: "ListAutomations",
			Handler:    _CloudDeploy_ListAutomations_Handler,
		},
		{
			MethodName: "GetAutomationRun",
			Handler:    _CloudDeploy_GetAutomationRun_Handler,
		},
		{
			MethodName: "ListAutomationRuns",
			Handler:    _CloudDeploy_ListAutomationRuns_Handler,
		},
		{
			MethodName: "CancelAutomationRun",
			Handler:    _CloudDeploy_CancelAutomationRun_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/deploy/v1/cloud_deploy.proto",
}
