// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/osconfig/agentendpoint/v1beta/guest_policies.proto

package agentendpointpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The desired state that the OS Config agent will maintain on the VM.
type DesiredState int32

const (
	// The default is to ensure the package is installed.
	DesiredState_DESIRED_STATE_UNSPECIFIED DesiredState = 0
	// The agent ensures that the package is installed.
	DesiredState_INSTALLED DesiredState = 1
	// The agent ensures that the package is installed and
	// periodically checks for and install any updates.
	DesiredState_UPDATED DesiredState = 2
	// The agent ensures that the package is not installed and uninstall it
	// if detected.
	DesiredState_REMOVED DesiredState = 3
)

// Enum value maps for DesiredState.
var (
	DesiredState_name = map[int32]string{
		0: "DESIRED_STATE_UNSPECIFIED",
		1: "INSTALLED",
		2: "UPDATED",
		3: "REMOVED",
	}
	DesiredState_value = map[string]int32{
		"DESIRED_STATE_UNSPECIFIED": 0,
		"INSTALLED":                 1,
		"UPDATED":                   2,
		"REMOVED":                   3,
	}
)

func (x DesiredState) Enum() *DesiredState {
	p := new(DesiredState)
	*p = x
	return p
}

func (x DesiredState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DesiredState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[0].Descriptor()
}

func (DesiredState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[0]
}

func (x DesiredState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DesiredState.Descriptor instead.
func (DesiredState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{0}
}

// Types of package managers that may be used to manage this package.
type Package_Manager int32

const (
	// The default behavior is ANY.
	Package_MANAGER_UNSPECIFIED Package_Manager = 0
	// Apply this package config using the default system package manager.
	Package_ANY Package_Manager = 1
	// Apply this package config only if Apt is available on the system.
	Package_APT Package_Manager = 2
	// Apply this package config only if Yum is available on the system.
	Package_YUM Package_Manager = 3
	// Apply this package config only if Zypper is available on the system.
	Package_ZYPPER Package_Manager = 4
	// Apply this package config only if GooGet is available on the system.
	Package_GOO Package_Manager = 5
)

// Enum value maps for Package_Manager.
var (
	Package_Manager_name = map[int32]string{
		0: "MANAGER_UNSPECIFIED",
		1: "ANY",
		2: "APT",
		3: "YUM",
		4: "ZYPPER",
		5: "GOO",
	}
	Package_Manager_value = map[string]int32{
		"MANAGER_UNSPECIFIED": 0,
		"ANY":                 1,
		"APT":                 2,
		"YUM":                 3,
		"ZYPPER":              4,
		"GOO":                 5,
	}
)

func (x Package_Manager) Enum() *Package_Manager {
	p := new(Package_Manager)
	*p = x
	return p
}

func (x Package_Manager) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Package_Manager) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[1].Descriptor()
}

func (Package_Manager) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[1]
}

func (x Package_Manager) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Package_Manager.Descriptor instead.
func (Package_Manager) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{0, 0}
}

// Type of archive.
type AptRepository_ArchiveType int32

const (
	// Unspecified.
	AptRepository_ARCHIVE_TYPE_UNSPECIFIED AptRepository_ArchiveType = 0
	// DEB indicates that the archive contains binary files.
	AptRepository_DEB AptRepository_ArchiveType = 1
	// DEB_SRC indicates that the archive contains source files.
	AptRepository_DEB_SRC AptRepository_ArchiveType = 2
)

// Enum value maps for AptRepository_ArchiveType.
var (
	AptRepository_ArchiveType_name = map[int32]string{
		0: "ARCHIVE_TYPE_UNSPECIFIED",
		1: "DEB",
		2: "DEB_SRC",
	}
	AptRepository_ArchiveType_value = map[string]int32{
		"ARCHIVE_TYPE_UNSPECIFIED": 0,
		"DEB":                      1,
		"DEB_SRC":                  2,
	}
)

func (x AptRepository_ArchiveType) Enum() *AptRepository_ArchiveType {
	p := new(AptRepository_ArchiveType)
	*p = x
	return p
}

func (x AptRepository_ArchiveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AptRepository_ArchiveType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[2].Descriptor()
}

func (AptRepository_ArchiveType) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[2]
}

func (x AptRepository_ArchiveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AptRepository_ArchiveType.Descriptor instead.
func (AptRepository_ArchiveType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{1, 0}
}

// Specifying the type of archive.
type SoftwareRecipe_Step_ExtractArchive_ArchiveType int32

const (
	// Indicates that the archive type isn't specified.
	SoftwareRecipe_Step_ExtractArchive_ARCHIVE_TYPE_UNSPECIFIED SoftwareRecipe_Step_ExtractArchive_ArchiveType = 0
	// Indicates that the archive is a tar archive with no encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR SoftwareRecipe_Step_ExtractArchive_ArchiveType = 1
	// Indicates that the archive is a tar archive with gzip encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_GZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 2
	// Indicates that the archive is a tar archive with bzip encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_BZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 3
	// Indicates that the archive is a tar archive with lzma encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_LZMA SoftwareRecipe_Step_ExtractArchive_ArchiveType = 4
	// Indicates that the archive is a tar archive with xz encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_XZ SoftwareRecipe_Step_ExtractArchive_ArchiveType = 5
	// Indicates that the archive is a zip archive.
	SoftwareRecipe_Step_ExtractArchive_ZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 11
)

// Enum value maps for SoftwareRecipe_Step_ExtractArchive_ArchiveType.
var (
	SoftwareRecipe_Step_ExtractArchive_ArchiveType_name = map[int32]string{
		0:  "ARCHIVE_TYPE_UNSPECIFIED",
		1:  "TAR",
		2:  "TAR_GZIP",
		3:  "TAR_BZIP",
		4:  "TAR_LZMA",
		5:  "TAR_XZ",
		11: "ZIP",
	}
	SoftwareRecipe_Step_ExtractArchive_ArchiveType_value = map[string]int32{
		"ARCHIVE_TYPE_UNSPECIFIED": 0,
		"TAR":                      1,
		"TAR_GZIP":                 2,
		"TAR_BZIP":                 3,
		"TAR_LZMA":                 4,
		"TAR_XZ":                   5,
		"ZIP":                      11,
	}
)

func (x SoftwareRecipe_Step_ExtractArchive_ArchiveType) Enum() *SoftwareRecipe_Step_ExtractArchive_ArchiveType {
	p := new(SoftwareRecipe_Step_ExtractArchive_ArchiveType)
	*p = x
	return p
}

func (x SoftwareRecipe_Step_ExtractArchive_ArchiveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SoftwareRecipe_Step_ExtractArchive_ArchiveType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[3].Descriptor()
}

func (SoftwareRecipe_Step_ExtractArchive_ArchiveType) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[3]
}

func (x SoftwareRecipe_Step_ExtractArchive_ArchiveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SoftwareRecipe_Step_ExtractArchive_ArchiveType.Descriptor instead.
func (SoftwareRecipe_Step_ExtractArchive_ArchiveType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 1, 0}
}

// The interpreter used to execute a script.
type SoftwareRecipe_Step_RunScript_Interpreter int32

const (
	// Default value for ScriptType.
	SoftwareRecipe_Step_RunScript_INTERPRETER_UNSPECIFIED SoftwareRecipe_Step_RunScript_Interpreter = 0
	// Indicates that the script is run with `/bin/sh` on Linux and `cmd`
	// on windows.
	SoftwareRecipe_Step_RunScript_SHELL SoftwareRecipe_Step_RunScript_Interpreter = 1
	// Indicates that the script is run with powershell.
	SoftwareRecipe_Step_RunScript_POWERSHELL SoftwareRecipe_Step_RunScript_Interpreter = 3
)

// Enum value maps for SoftwareRecipe_Step_RunScript_Interpreter.
var (
	SoftwareRecipe_Step_RunScript_Interpreter_name = map[int32]string{
		0: "INTERPRETER_UNSPECIFIED",
		1: "SHELL",
		3: "POWERSHELL",
	}
	SoftwareRecipe_Step_RunScript_Interpreter_value = map[string]int32{
		"INTERPRETER_UNSPECIFIED": 0,
		"SHELL":                   1,
		"POWERSHELL":              3,
	}
)

func (x SoftwareRecipe_Step_RunScript_Interpreter) Enum() *SoftwareRecipe_Step_RunScript_Interpreter {
	p := new(SoftwareRecipe_Step_RunScript_Interpreter)
	*p = x
	return p
}

func (x SoftwareRecipe_Step_RunScript_Interpreter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SoftwareRecipe_Step_RunScript_Interpreter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[4].Descriptor()
}

func (SoftwareRecipe_Step_RunScript_Interpreter) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes[4]
}

func (x SoftwareRecipe_Step_RunScript_Interpreter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SoftwareRecipe_Step_RunScript_Interpreter.Descriptor instead.
func (SoftwareRecipe_Step_RunScript_Interpreter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 6, 0}
}

// Package is a reference to the software package to be installed or removed.
// The agent on the VM instance uses the system package manager to apply the
// config.
//
// These are the commands that the agent uses to install or remove
// packages.
//
// Apt
// install: `apt-get update && apt-get -y install package1 package2 package3`
// remove: `apt-get -y remove package1 package2 package3`
//
// Yum
// install: `yum -y install package1 package2 package3`
// remove: `yum -y remove package1 package2 package3`
//
// Zypper
// install: `zypper install package1 package2 package3`
// remove: `zypper rm package1 package2`
//
// Googet
// install: `googet -noconfirm install package1 package2 package3`
// remove: `googet -noconfirm remove package1 package2 package3`
type Package struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package. A package is uniquely identified for conflict
	// validation by checking the package name and the manager(s) that the
	// package targets.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The desired_state the agent should maintain for this package. The
	// default is to ensure the package is installed.
	DesiredState DesiredState `protobuf:"varint,2,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.DesiredState" json:"desired_state,omitempty"`
	// Type of package manager that can be used to install this package.
	// If a system does not have the package manager, the package is not
	// installed or removed no error message is returned. By default,
	// or if you specify `ANY`,
	// the agent attempts to install and remove this package using the default
	// package manager. This is useful when creating a policy that applies to
	// different types of systems.
	//
	// The default behavior is ANY.
	Manager Package_Manager `protobuf:"varint,3,opt,name=manager,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.Package_Manager" json:"manager,omitempty"`
}

func (x *Package) Reset() {
	*x = Package{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{0}
}

func (x *Package) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Package) GetDesiredState() DesiredState {
	if x != nil {
		return x.DesiredState
	}
	return DesiredState_DESIRED_STATE_UNSPECIFIED
}

func (x *Package) GetManager() Package_Manager {
	if x != nil {
		return x.Manager
	}
	return Package_MANAGER_UNSPECIFIED
}

// Represents a single Apt package repository. This repository is added to
// a repo file that is stored at
// `/etc/apt/sources.list.d/google_osconfig.list`.
type AptRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of archive files in this repository. The default behavior is DEB.
	ArchiveType AptRepository_ArchiveType `protobuf:"varint,1,opt,name=archive_type,json=archiveType,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.AptRepository_ArchiveType" json:"archive_type,omitempty"`
	// URI for this repository.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Distribution of this repository.
	Distribution string `protobuf:"bytes,3,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// List of components for this repository. Must contain at least one item.
	Components []string `protobuf:"bytes,4,rep,name=components,proto3" json:"components,omitempty"`
	// URI of the key file for this repository. The agent maintains
	// a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg` containing
	// all the keys in any applied guest policy.
	GpgKey string `protobuf:"bytes,5,opt,name=gpg_key,json=gpgKey,proto3" json:"gpg_key,omitempty"`
}

func (x *AptRepository) Reset() {
	*x = AptRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AptRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AptRepository) ProtoMessage() {}

func (x *AptRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AptRepository.ProtoReflect.Descriptor instead.
func (*AptRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{1}
}

func (x *AptRepository) GetArchiveType() AptRepository_ArchiveType {
	if x != nil {
		return x.ArchiveType
	}
	return AptRepository_ARCHIVE_TYPE_UNSPECIFIED
}

func (x *AptRepository) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *AptRepository) GetDistribution() string {
	if x != nil {
		return x.Distribution
	}
	return ""
}

func (x *AptRepository) GetComponents() []string {
	if x != nil {
		return x.Components
	}
	return nil
}

func (x *AptRepository) GetGpgKey() string {
	if x != nil {
		return x.GpgKey
	}
	return ""
}

// Represents a single Yum package repository. This repository is added to a
// repo file that is stored at `/etc/yum.repos.d/google_osconfig.repo`.
type YumRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A one word, unique name for this repository. This is
	// the `repo id` in the Yum config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique identifier
	// when checking for guest policy conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
}

func (x *YumRepository) Reset() {
	*x = YumRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *YumRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*YumRepository) ProtoMessage() {}

func (x *YumRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use YumRepository.ProtoReflect.Descriptor instead.
func (*YumRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{2}
}

func (x *YumRepository) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *YumRepository) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *YumRepository) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *YumRepository) GetGpgKeys() []string {
	if x != nil {
		return x.GpgKeys
	}
	return nil
}

// Represents a single Zypper package repository. This repository is added to a
// repo file that is stored at `/etc/zypp/repos.d/google_osconfig.repo`.
type ZypperRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A one word, unique name for this repository. This is
	// the `repo id` in the zypper config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique identifier
	// when checking for guest policy conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
}

func (x *ZypperRepository) Reset() {
	*x = ZypperRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZypperRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZypperRepository) ProtoMessage() {}

func (x *ZypperRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZypperRepository.ProtoReflect.Descriptor instead.
func (*ZypperRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{3}
}

func (x *ZypperRepository) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ZypperRepository) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ZypperRepository) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *ZypperRepository) GetGpgKeys() []string {
	if x != nil {
		return x.GpgKeys
	}
	return nil
}

// Represents a Goo package repository. These is added to a repo file
// that is stored at C:/ProgramData/GooGet/repos/google_osconfig.repo.
type GooRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the repository.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The url of the repository.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *GooRepository) Reset() {
	*x = GooRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GooRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GooRepository) ProtoMessage() {}

func (x *GooRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GooRepository.ProtoReflect.Descriptor instead.
func (*GooRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{4}
}

func (x *GooRepository) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GooRepository) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// A package repository.
type PackageRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A specific type of repository.
	//
	// Types that are assignable to Repository:
	//
	//	*PackageRepository_Apt
	//	*PackageRepository_Yum
	//	*PackageRepository_Zypper
	//	*PackageRepository_Goo
	Repository isPackageRepository_Repository `protobuf_oneof:"repository"`
}

func (x *PackageRepository) Reset() {
	*x = PackageRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageRepository) ProtoMessage() {}

func (x *PackageRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageRepository.ProtoReflect.Descriptor instead.
func (*PackageRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{5}
}

func (m *PackageRepository) GetRepository() isPackageRepository_Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (x *PackageRepository) GetApt() *AptRepository {
	if x, ok := x.GetRepository().(*PackageRepository_Apt); ok {
		return x.Apt
	}
	return nil
}

func (x *PackageRepository) GetYum() *YumRepository {
	if x, ok := x.GetRepository().(*PackageRepository_Yum); ok {
		return x.Yum
	}
	return nil
}

func (x *PackageRepository) GetZypper() *ZypperRepository {
	if x, ok := x.GetRepository().(*PackageRepository_Zypper); ok {
		return x.Zypper
	}
	return nil
}

func (x *PackageRepository) GetGoo() *GooRepository {
	if x, ok := x.GetRepository().(*PackageRepository_Goo); ok {
		return x.Goo
	}
	return nil
}

type isPackageRepository_Repository interface {
	isPackageRepository_Repository()
}

type PackageRepository_Apt struct {
	// An Apt Repository.
	Apt *AptRepository `protobuf:"bytes,1,opt,name=apt,proto3,oneof"`
}

type PackageRepository_Yum struct {
	// A Yum Repository.
	Yum *YumRepository `protobuf:"bytes,2,opt,name=yum,proto3,oneof"`
}

type PackageRepository_Zypper struct {
	// A Zypper Repository.
	Zypper *ZypperRepository `protobuf:"bytes,3,opt,name=zypper,proto3,oneof"`
}

type PackageRepository_Goo struct {
	// A Goo Repository.
	Goo *GooRepository `protobuf:"bytes,4,opt,name=goo,proto3,oneof"`
}

func (*PackageRepository_Apt) isPackageRepository_Repository() {}

func (*PackageRepository_Yum) isPackageRepository_Repository() {}

func (*PackageRepository_Zypper) isPackageRepository_Repository() {}

func (*PackageRepository_Goo) isPackageRepository_Repository() {}

// A software recipe is a set of instructions for installing and configuring a
// piece of software. It consists of a set of artifacts that are
// downloaded, and a set of steps that install, configure, and/or update the
// software.
//
// Recipes support installing and updating software from artifacts in the
// following formats:
// Zip archive, Tar archive, Windows MSI, Debian package, and RPM package.
//
// Additionally, recipes support executing a script (either defined in a file or
// directly in this api) in bash, sh, cmd, and powershell.
//
// # Updating a software recipe
//
// If a recipe is assigned to an instance and there is a recipe with the same
// name but a lower version already installed and the assigned state
// of the recipe is `INSTALLED_KEEP_UPDATED`, then the recipe is updated to
// the new version.
//
// # Script Working Directories
//
// Each script or execution step is run in its own temporary directory which
// is deleted after completing the step.
type SoftwareRecipe struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for the recipe. Only one recipe with a given name is
	// installed on an instance.
	//
	// Names are also used to identify resources which helps to determine whether
	// guest policies have conflicts. This means that requests to create multiple
	// recipes with the same name and version are rejected since they
	// could potentially have conflicting assignments.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version of this software recipe. Version can be up to 4 period
	// separated numbers (e.g. 12.34.56.78).
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Resources available to be used in the steps in the recipe.
	Artifacts []*SoftwareRecipe_Artifact `protobuf:"bytes,3,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Actions to be taken for installing this recipe. On failure it stops
	// executing steps and does not attempt another installation. Any steps taken
	// (including partially completed steps) are not rolled back.  Install steps
	// must be specified and are used on first installation.
	InstallSteps []*SoftwareRecipe_Step `protobuf:"bytes,4,rep,name=install_steps,json=installSteps,proto3" json:"install_steps,omitempty"`
	// Actions to be taken for updating this recipe. On failure it stops
	// executing steps and  does not attempt another update for this recipe. Any
	// steps taken (including partially completed steps) are not rolled back.
	// Upgrade steps are not mandatory and are only used when upgrading.
	UpdateSteps []*SoftwareRecipe_Step `protobuf:"bytes,5,rep,name=update_steps,json=updateSteps,proto3" json:"update_steps,omitempty"`
	// Default is INSTALLED. The desired state the agent should maintain for this
	// recipe.
	//
	// INSTALLED: The software recipe is installed on the instance but won't be
	//
	//	updated to new versions.
	//
	// UPDATED: The software recipe is installed on the instance. The recipe is
	//
	//	updated to a higher version, if a higher version of
	//	the recipe is assigned to this instance.
	//
	// REMOVE: Remove is unsupported for software recipes and attempts to
	//
	//	create or update a recipe to the REMOVE state is rejected.
	DesiredState DesiredState `protobuf:"varint,6,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.DesiredState" json:"desired_state,omitempty"`
}

func (x *SoftwareRecipe) Reset() {
	*x = SoftwareRecipe{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe) ProtoMessage() {}

func (x *SoftwareRecipe) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6}
}

func (x *SoftwareRecipe) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SoftwareRecipe) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SoftwareRecipe) GetArtifacts() []*SoftwareRecipe_Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *SoftwareRecipe) GetInstallSteps() []*SoftwareRecipe_Step {
	if x != nil {
		return x.InstallSteps
	}
	return nil
}

func (x *SoftwareRecipe) GetUpdateSteps() []*SoftwareRecipe_Step {
	if x != nil {
		return x.UpdateSteps
	}
	return nil
}

func (x *SoftwareRecipe) GetDesiredState() DesiredState {
	if x != nil {
		return x.DesiredState
	}
	return DesiredState_DESIRED_STATE_UNSPECIFIED
}

// A request message for getting effective policy assigned to the instance.
type LookupEffectiveGuestPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Short name of the OS running on the instance. The OS Config agent only
	// provideS this field for targeting if OS Inventory is enabled for that
	// instance.
	OsShortName string `protobuf:"bytes,2,opt,name=os_short_name,json=osShortName,proto3" json:"os_short_name,omitempty"`
	// Version of the OS running on the instance. The OS Config agent only
	// provide this field for targeting if OS Inventory is enabled for that
	// VM instance.
	OsVersion string `protobuf:"bytes,3,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
	// Architecture of OS running on the instance. The OS Config agent only
	// provide this field for targeting if OS Inventory is enabled for that
	// instance.
	OsArchitecture string `protobuf:"bytes,4,opt,name=os_architecture,json=osArchitecture,proto3" json:"os_architecture,omitempty"`
}

func (x *LookupEffectiveGuestPolicyRequest) Reset() {
	*x = LookupEffectiveGuestPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupEffectiveGuestPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupEffectiveGuestPolicyRequest) ProtoMessage() {}

func (x *LookupEffectiveGuestPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupEffectiveGuestPolicyRequest.ProtoReflect.Descriptor instead.
func (*LookupEffectiveGuestPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{7}
}

func (x *LookupEffectiveGuestPolicyRequest) GetInstanceIdToken() string {
	if x != nil {
		return x.InstanceIdToken
	}
	return ""
}

func (x *LookupEffectiveGuestPolicyRequest) GetOsShortName() string {
	if x != nil {
		return x.OsShortName
	}
	return ""
}

func (x *LookupEffectiveGuestPolicyRequest) GetOsVersion() string {
	if x != nil {
		return x.OsVersion
	}
	return ""
}

func (x *LookupEffectiveGuestPolicyRequest) GetOsArchitecture() string {
	if x != nil {
		return x.OsArchitecture
	}
	return ""
}

// The effective guest policy assigned to the instance.
type EffectiveGuestPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of package configurations assigned to the VM instance.
	Packages []*EffectiveGuestPolicy_SourcedPackage `protobuf:"bytes,1,rep,name=packages,proto3" json:"packages,omitempty"`
	// List of package repository configurations assigned to the VM instance.
	PackageRepositories []*EffectiveGuestPolicy_SourcedPackageRepository `protobuf:"bytes,2,rep,name=package_repositories,json=packageRepositories,proto3" json:"package_repositories,omitempty"`
	// List of recipes assigned to the VM instance.
	SoftwareRecipes []*EffectiveGuestPolicy_SourcedSoftwareRecipe `protobuf:"bytes,3,rep,name=software_recipes,json=softwareRecipes,proto3" json:"software_recipes,omitempty"`
}

func (x *EffectiveGuestPolicy) Reset() {
	*x = EffectiveGuestPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EffectiveGuestPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveGuestPolicy) ProtoMessage() {}

func (x *EffectiveGuestPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveGuestPolicy.ProtoReflect.Descriptor instead.
func (*EffectiveGuestPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{8}
}

func (x *EffectiveGuestPolicy) GetPackages() []*EffectiveGuestPolicy_SourcedPackage {
	if x != nil {
		return x.Packages
	}
	return nil
}

func (x *EffectiveGuestPolicy) GetPackageRepositories() []*EffectiveGuestPolicy_SourcedPackageRepository {
	if x != nil {
		return x.PackageRepositories
	}
	return nil
}

func (x *EffectiveGuestPolicy) GetSoftwareRecipes() []*EffectiveGuestPolicy_SourcedSoftwareRecipe {
	if x != nil {
		return x.SoftwareRecipes
	}
	return nil
}

// Specifies a resource to be used in the recipe.
type SoftwareRecipe_Artifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Id of the artifact, which the installation and update steps of this
	// recipe can reference. Artifacts in a recipe cannot have the same id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A specific type of artifact.
	//
	// Types that are assignable to Artifact:
	//
	//	*SoftwareRecipe_Artifact_Remote_
	//	*SoftwareRecipe_Artifact_Gcs_
	Artifact isSoftwareRecipe_Artifact_Artifact `protobuf_oneof:"artifact"`
	// Defaults to false. When false, recipes are subject to validations
	// based on the artifact type:
	//
	// Remote: A checksum must be specified, and only protocols with
	//
	//	transport-layer security are permitted.
	//
	// GCS:    An object generation number must be specified.
	AllowInsecure bool `protobuf:"varint,4,opt,name=allow_insecure,json=allowInsecure,proto3" json:"allow_insecure,omitempty"`
}

func (x *SoftwareRecipe_Artifact) Reset() {
	*x = SoftwareRecipe_Artifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Artifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Artifact) ProtoMessage() {}

func (x *SoftwareRecipe_Artifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Artifact.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Artifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 0}
}

func (x *SoftwareRecipe_Artifact) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (m *SoftwareRecipe_Artifact) GetArtifact() isSoftwareRecipe_Artifact_Artifact {
	if m != nil {
		return m.Artifact
	}
	return nil
}

func (x *SoftwareRecipe_Artifact) GetRemote() *SoftwareRecipe_Artifact_Remote {
	if x, ok := x.GetArtifact().(*SoftwareRecipe_Artifact_Remote_); ok {
		return x.Remote
	}
	return nil
}

func (x *SoftwareRecipe_Artifact) GetGcs() *SoftwareRecipe_Artifact_Gcs {
	if x, ok := x.GetArtifact().(*SoftwareRecipe_Artifact_Gcs_); ok {
		return x.Gcs
	}
	return nil
}

func (x *SoftwareRecipe_Artifact) GetAllowInsecure() bool {
	if x != nil {
		return x.AllowInsecure
	}
	return false
}

type isSoftwareRecipe_Artifact_Artifact interface {
	isSoftwareRecipe_Artifact_Artifact()
}

type SoftwareRecipe_Artifact_Remote_ struct {
	// A generic remote artifact.
	Remote *SoftwareRecipe_Artifact_Remote `protobuf:"bytes,2,opt,name=remote,proto3,oneof"`
}

type SoftwareRecipe_Artifact_Gcs_ struct {
	// A Cloud Storage artifact.
	Gcs *SoftwareRecipe_Artifact_Gcs `protobuf:"bytes,3,opt,name=gcs,proto3,oneof"`
}

func (*SoftwareRecipe_Artifact_Remote_) isSoftwareRecipe_Artifact_Artifact() {}

func (*SoftwareRecipe_Artifact_Gcs_) isSoftwareRecipe_Artifact_Artifact() {}

// An action that can be taken as part of installing or updating a recipe.
type SoftwareRecipe_Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A specific type of step.
	//
	// Types that are assignable to Step:
	//
	//	*SoftwareRecipe_Step_FileCopy
	//	*SoftwareRecipe_Step_ArchiveExtraction
	//	*SoftwareRecipe_Step_MsiInstallation
	//	*SoftwareRecipe_Step_DpkgInstallation
	//	*SoftwareRecipe_Step_RpmInstallation
	//	*SoftwareRecipe_Step_FileExec
	//	*SoftwareRecipe_Step_ScriptRun
	Step isSoftwareRecipe_Step_Step `protobuf_oneof:"step"`
}

func (x *SoftwareRecipe_Step) Reset() {
	*x = SoftwareRecipe_Step{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step) ProtoMessage() {}

func (x *SoftwareRecipe_Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1}
}

func (m *SoftwareRecipe_Step) GetStep() isSoftwareRecipe_Step_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *SoftwareRecipe_Step) GetFileCopy() *SoftwareRecipe_Step_CopyFile {
	if x, ok := x.GetStep().(*SoftwareRecipe_Step_FileCopy); ok {
		return x.FileCopy
	}
	return nil
}

func (x *SoftwareRecipe_Step) GetArchiveExtraction() *SoftwareRecipe_Step_ExtractArchive {
	if x, ok := x.GetStep().(*SoftwareRecipe_Step_ArchiveExtraction); ok {
		return x.ArchiveExtraction
	}
	return nil
}

func (x *SoftwareRecipe_Step) GetMsiInstallation() *SoftwareRecipe_Step_InstallMsi {
	if x, ok := x.GetStep().(*SoftwareRecipe_Step_MsiInstallation); ok {
		return x.MsiInstallation
	}
	return nil
}

func (x *SoftwareRecipe_Step) GetDpkgInstallation() *SoftwareRecipe_Step_InstallDpkg {
	if x, ok := x.GetStep().(*SoftwareRecipe_Step_DpkgInstallation); ok {
		return x.DpkgInstallation
	}
	return nil
}

func (x *SoftwareRecipe_Step) GetRpmInstallation() *SoftwareRecipe_Step_InstallRpm {
	if x, ok := x.GetStep().(*SoftwareRecipe_Step_RpmInstallation); ok {
		return x.RpmInstallation
	}
	return nil
}

func (x *SoftwareRecipe_Step) GetFileExec() *SoftwareRecipe_Step_ExecFile {
	if x, ok := x.GetStep().(*SoftwareRecipe_Step_FileExec); ok {
		return x.FileExec
	}
	return nil
}

func (x *SoftwareRecipe_Step) GetScriptRun() *SoftwareRecipe_Step_RunScript {
	if x, ok := x.GetStep().(*SoftwareRecipe_Step_ScriptRun); ok {
		return x.ScriptRun
	}
	return nil
}

type isSoftwareRecipe_Step_Step interface {
	isSoftwareRecipe_Step_Step()
}

type SoftwareRecipe_Step_FileCopy struct {
	// Copies a file onto the instance.
	FileCopy *SoftwareRecipe_Step_CopyFile `protobuf:"bytes,1,opt,name=file_copy,json=fileCopy,proto3,oneof"`
}

type SoftwareRecipe_Step_ArchiveExtraction struct {
	// Extracts an archive into the specified directory.
	ArchiveExtraction *SoftwareRecipe_Step_ExtractArchive `protobuf:"bytes,2,opt,name=archive_extraction,json=archiveExtraction,proto3,oneof"`
}

type SoftwareRecipe_Step_MsiInstallation struct {
	// Installs an MSI file.
	MsiInstallation *SoftwareRecipe_Step_InstallMsi `protobuf:"bytes,3,opt,name=msi_installation,json=msiInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_DpkgInstallation struct {
	// Installs a deb file via dpkg.
	DpkgInstallation *SoftwareRecipe_Step_InstallDpkg `protobuf:"bytes,4,opt,name=dpkg_installation,json=dpkgInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_RpmInstallation struct {
	// Installs an rpm file via the rpm utility.
	RpmInstallation *SoftwareRecipe_Step_InstallRpm `protobuf:"bytes,5,opt,name=rpm_installation,json=rpmInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_FileExec struct {
	// Executes an artifact or local file.
	FileExec *SoftwareRecipe_Step_ExecFile `protobuf:"bytes,6,opt,name=file_exec,json=fileExec,proto3,oneof"`
}

type SoftwareRecipe_Step_ScriptRun struct {
	// Runs commands in a shell.
	ScriptRun *SoftwareRecipe_Step_RunScript `protobuf:"bytes,7,opt,name=script_run,json=scriptRun,proto3,oneof"`
}

func (*SoftwareRecipe_Step_FileCopy) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_ArchiveExtraction) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_MsiInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_DpkgInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_RpmInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_FileExec) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_ScriptRun) isSoftwareRecipe_Step_Step() {}

// Specifies an artifact available via some URI.
type SoftwareRecipe_Artifact_Remote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI from which to fetch the object. It should contain both the protocol
	// and path following the format {protocol}://{location}.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Must be provided if `allow_insecure` is `false`.
	// SHA256 checksum in hex format, to compare to the checksum of the
	// artifact. If the checksum is not empty and it doesn't match the
	// artifact then the recipe installation fails before running any of the
	// steps.
	Checksum string `protobuf:"bytes,2,opt,name=checksum,proto3" json:"checksum,omitempty"`
}

func (x *SoftwareRecipe_Artifact_Remote) Reset() {
	*x = SoftwareRecipe_Artifact_Remote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Artifact_Remote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Artifact_Remote) ProtoMessage() {}

func (x *SoftwareRecipe_Artifact_Remote) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Artifact_Remote.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Artifact_Remote) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 0, 0}
}

func (x *SoftwareRecipe_Artifact_Remote) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *SoftwareRecipe_Artifact_Remote) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

// Specifies an artifact available as a Cloud Storage object.
type SoftwareRecipe_Artifact_Gcs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bucket of the Cloud Storage object.
	// Given an example URL:
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `my-bucket`.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Name of the Cloud Storage object.
	// As specified [here]
	// (https://cloud.google.com/storage/docs/naming#objectnames)
	// Given an example URL:
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `foo/bar`.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Must be provided if allow_insecure is false.
	// Generation number of the Cloud Storage object.
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `1234567`.
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *SoftwareRecipe_Artifact_Gcs) Reset() {
	*x = SoftwareRecipe_Artifact_Gcs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Artifact_Gcs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Artifact_Gcs) ProtoMessage() {}

func (x *SoftwareRecipe_Artifact_Gcs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Artifact_Gcs.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Artifact_Gcs) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 0, 1}
}

func (x *SoftwareRecipe_Artifact_Gcs) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *SoftwareRecipe_Artifact_Gcs) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *SoftwareRecipe_Artifact_Gcs) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

// Copies the artifact to the specified path on the instance.
type SoftwareRecipe_Step_CopyFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// The absolute path on the instance to put the file.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Whether to allow this step to overwrite existing files. If this is
	// false and the file already exists the file is not overwritten
	// and the step is considered a success. Defaults to false.
	Overwrite bool `protobuf:"varint,3,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
	// Consists of three octal digits which represent, in
	// order, the permissions of the owner, group, and other users for the
	// file (similarly to the numeric mode used in the linux chmod utility).
	// Each digit represents a three bit number with the 4 bit
	// corresponding to the read permissions, the 2 bit corresponds to the
	// write bit, and the one bit corresponds to the execute permission.
	// Default behavior is 755.
	//
	// Below are some examples of permissions and their associated values:
	// read, write, and execute: 7
	// read and execute: 5
	// read and write: 6
	// read only: 4
	Permissions string `protobuf:"bytes,4,opt,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *SoftwareRecipe_Step_CopyFile) Reset() {
	*x = SoftwareRecipe_Step_CopyFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step_CopyFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step_CopyFile) ProtoMessage() {}

func (x *SoftwareRecipe_Step_CopyFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step_CopyFile.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step_CopyFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 0}
}

func (x *SoftwareRecipe_Step_CopyFile) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

func (x *SoftwareRecipe_Step_CopyFile) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *SoftwareRecipe_Step_CopyFile) GetOverwrite() bool {
	if x != nil {
		return x.Overwrite
	}
	return false
}

func (x *SoftwareRecipe_Step_CopyFile) GetPermissions() string {
	if x != nil {
		return x.Permissions
	}
	return ""
}

// Extracts an archive of the type specified in the specified directory.
type SoftwareRecipe_Step_ExtractArchive struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// Directory to extract archive to.
	// Defaults to `/` on Linux or `C:\` on Windows.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// The type of the archive to extract.
	Type SoftwareRecipe_Step_ExtractArchive_ArchiveType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe_Step_ExtractArchive_ArchiveType" json:"type,omitempty"`
}

func (x *SoftwareRecipe_Step_ExtractArchive) Reset() {
	*x = SoftwareRecipe_Step_ExtractArchive{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step_ExtractArchive) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step_ExtractArchive) ProtoMessage() {}

func (x *SoftwareRecipe_Step_ExtractArchive) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step_ExtractArchive.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step_ExtractArchive) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 1}
}

func (x *SoftwareRecipe_Step_ExtractArchive) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

func (x *SoftwareRecipe_Step_ExtractArchive) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *SoftwareRecipe_Step_ExtractArchive) GetType() SoftwareRecipe_Step_ExtractArchive_ArchiveType {
	if x != nil {
		return x.Type
	}
	return SoftwareRecipe_Step_ExtractArchive_ARCHIVE_TYPE_UNSPECIFIED
}

// Installs an MSI file.
type SoftwareRecipe_Step_InstallMsi struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// The flags to use when installing the MSI
	// defaults to ["/i"] (i.e. the install flag).
	Flags []string `protobuf:"bytes,2,rep,name=flags,proto3" json:"flags,omitempty"`
	// Return codes that indicate that the software installed or updated
	// successfully. Behaviour defaults to [0]
	AllowedExitCodes []int32 `protobuf:"varint,3,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
}

func (x *SoftwareRecipe_Step_InstallMsi) Reset() {
	*x = SoftwareRecipe_Step_InstallMsi{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step_InstallMsi) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step_InstallMsi) ProtoMessage() {}

func (x *SoftwareRecipe_Step_InstallMsi) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step_InstallMsi.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step_InstallMsi) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 2}
}

func (x *SoftwareRecipe_Step_InstallMsi) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

func (x *SoftwareRecipe_Step_InstallMsi) GetFlags() []string {
	if x != nil {
		return x.Flags
	}
	return nil
}

func (x *SoftwareRecipe_Step_InstallMsi) GetAllowedExitCodes() []int32 {
	if x != nil {
		return x.AllowedExitCodes
	}
	return nil
}

// Installs a deb via dpkg.
type SoftwareRecipe_Step_InstallDpkg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
}

func (x *SoftwareRecipe_Step_InstallDpkg) Reset() {
	*x = SoftwareRecipe_Step_InstallDpkg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step_InstallDpkg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step_InstallDpkg) ProtoMessage() {}

func (x *SoftwareRecipe_Step_InstallDpkg) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step_InstallDpkg.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step_InstallDpkg) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 3}
}

func (x *SoftwareRecipe_Step_InstallDpkg) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

// Installs an rpm file via the rpm utility.
type SoftwareRecipe_Step_InstallRpm struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
}

func (x *SoftwareRecipe_Step_InstallRpm) Reset() {
	*x = SoftwareRecipe_Step_InstallRpm{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step_InstallRpm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step_InstallRpm) ProtoMessage() {}

func (x *SoftwareRecipe_Step_InstallRpm) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step_InstallRpm.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step_InstallRpm) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 4}
}

func (x *SoftwareRecipe_Step_InstallRpm) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

// Executes an artifact or local file.
type SoftwareRecipe_Step_ExecFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the file to execute.
	//
	// Types that are assignable to LocationType:
	//
	//	*SoftwareRecipe_Step_ExecFile_ArtifactId
	//	*SoftwareRecipe_Step_ExecFile_LocalPath
	LocationType isSoftwareRecipe_Step_ExecFile_LocationType `protobuf_oneof:"location_type"`
	// Arguments to be passed to the provided executable.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Defaults to [0]. A list of possible return values that the program
	// can return to indicate a success.
	AllowedExitCodes []int32 `protobuf:"varint,4,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
}

func (x *SoftwareRecipe_Step_ExecFile) Reset() {
	*x = SoftwareRecipe_Step_ExecFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step_ExecFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step_ExecFile) ProtoMessage() {}

func (x *SoftwareRecipe_Step_ExecFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step_ExecFile.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step_ExecFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 5}
}

func (m *SoftwareRecipe_Step_ExecFile) GetLocationType() isSoftwareRecipe_Step_ExecFile_LocationType {
	if m != nil {
		return m.LocationType
	}
	return nil
}

func (x *SoftwareRecipe_Step_ExecFile) GetArtifactId() string {
	if x, ok := x.GetLocationType().(*SoftwareRecipe_Step_ExecFile_ArtifactId); ok {
		return x.ArtifactId
	}
	return ""
}

func (x *SoftwareRecipe_Step_ExecFile) GetLocalPath() string {
	if x, ok := x.GetLocationType().(*SoftwareRecipe_Step_ExecFile_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (x *SoftwareRecipe_Step_ExecFile) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *SoftwareRecipe_Step_ExecFile) GetAllowedExitCodes() []int32 {
	if x != nil {
		return x.AllowedExitCodes
	}
	return nil
}

type isSoftwareRecipe_Step_ExecFile_LocationType interface {
	isSoftwareRecipe_Step_ExecFile_LocationType()
}

type SoftwareRecipe_Step_ExecFile_ArtifactId struct {
	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3,oneof"`
}

type SoftwareRecipe_Step_ExecFile_LocalPath struct {
	// The absolute path of the file on the local filesystem.
	LocalPath string `protobuf:"bytes,2,opt,name=local_path,json=localPath,proto3,oneof"`
}

func (*SoftwareRecipe_Step_ExecFile_ArtifactId) isSoftwareRecipe_Step_ExecFile_LocationType() {}

func (*SoftwareRecipe_Step_ExecFile_LocalPath) isSoftwareRecipe_Step_ExecFile_LocationType() {}

// Runs a script through an interpreter.
type SoftwareRecipe_Step_RunScript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The shell script to be executed.
	Script string `protobuf:"bytes,1,opt,name=script,proto3" json:"script,omitempty"`
	// Return codes that indicate that the software installed or updated
	// successfully. Behaviour defaults to [0]
	AllowedExitCodes []int32 `protobuf:"varint,2,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
	// The script interpreter to use to run the script. If no interpreter is
	// specified the script is executed directly, which likely
	// only succeed for scripts with
	// [shebang lines](https://en.wikipedia.org/wiki/Shebang_(Unix)).
	Interpreter SoftwareRecipe_Step_RunScript_Interpreter `protobuf:"varint,3,opt,name=interpreter,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe_Step_RunScript_Interpreter" json:"interpreter,omitempty"`
}

func (x *SoftwareRecipe_Step_RunScript) Reset() {
	*x = SoftwareRecipe_Step_RunScript{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareRecipe_Step_RunScript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareRecipe_Step_RunScript) ProtoMessage() {}

func (x *SoftwareRecipe_Step_RunScript) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareRecipe_Step_RunScript.ProtoReflect.Descriptor instead.
func (*SoftwareRecipe_Step_RunScript) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{6, 1, 6}
}

func (x *SoftwareRecipe_Step_RunScript) GetScript() string {
	if x != nil {
		return x.Script
	}
	return ""
}

func (x *SoftwareRecipe_Step_RunScript) GetAllowedExitCodes() []int32 {
	if x != nil {
		return x.AllowedExitCodes
	}
	return nil
}

func (x *SoftwareRecipe_Step_RunScript) GetInterpreter() SoftwareRecipe_Step_RunScript_Interpreter {
	if x != nil {
		return x.Interpreter
	}
	return SoftwareRecipe_Step_RunScript_INTERPRETER_UNSPECIFIED
}

// A guest policy package including its source.
type EffectiveGuestPolicy_SourcedPackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software package to configure on the VM instance.
	Package *Package `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
}

func (x *EffectiveGuestPolicy_SourcedPackage) Reset() {
	*x = EffectiveGuestPolicy_SourcedPackage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EffectiveGuestPolicy_SourcedPackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveGuestPolicy_SourcedPackage) ProtoMessage() {}

func (x *EffectiveGuestPolicy_SourcedPackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveGuestPolicy_SourcedPackage.ProtoReflect.Descriptor instead.
func (*EffectiveGuestPolicy_SourcedPackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{8, 0}
}

func (x *EffectiveGuestPolicy_SourcedPackage) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *EffectiveGuestPolicy_SourcedPackage) GetPackage() *Package {
	if x != nil {
		return x.Package
	}
	return nil
}

// A guest policy package repository including its source.
type EffectiveGuestPolicy_SourcedPackageRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software package repository to configure on the VM instance.
	PackageRepository *PackageRepository `protobuf:"bytes,2,opt,name=package_repository,json=packageRepository,proto3" json:"package_repository,omitempty"`
}

func (x *EffectiveGuestPolicy_SourcedPackageRepository) Reset() {
	*x = EffectiveGuestPolicy_SourcedPackageRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EffectiveGuestPolicy_SourcedPackageRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveGuestPolicy_SourcedPackageRepository) ProtoMessage() {}

func (x *EffectiveGuestPolicy_SourcedPackageRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveGuestPolicy_SourcedPackageRepository.ProtoReflect.Descriptor instead.
func (*EffectiveGuestPolicy_SourcedPackageRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{8, 1}
}

func (x *EffectiveGuestPolicy_SourcedPackageRepository) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *EffectiveGuestPolicy_SourcedPackageRepository) GetPackageRepository() *PackageRepository {
	if x != nil {
		return x.PackageRepository
	}
	return nil
}

// A guest policy recipe including its source.
type EffectiveGuestPolicy_SourcedSoftwareRecipe struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software recipe to configure on the VM instance.
	SoftwareRecipe *SoftwareRecipe `protobuf:"bytes,2,opt,name=software_recipe,json=softwareRecipe,proto3" json:"software_recipe,omitempty"`
}

func (x *EffectiveGuestPolicy_SourcedSoftwareRecipe) Reset() {
	*x = EffectiveGuestPolicy_SourcedSoftwareRecipe{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EffectiveGuestPolicy_SourcedSoftwareRecipe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveGuestPolicy_SourcedSoftwareRecipe) ProtoMessage() {}

func (x *EffectiveGuestPolicy_SourcedSoftwareRecipe) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveGuestPolicy_SourcedSoftwareRecipe.ProtoReflect.Descriptor instead.
func (*EffectiveGuestPolicy_SourcedSoftwareRecipe) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP(), []int{8, 2}
}

func (x *EffectiveGuestPolicy_SourcedSoftwareRecipe) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *EffectiveGuestPolicy_SourcedSoftwareRecipe) GetSoftwareRecipe() *SoftwareRecipe {
	if x != nil {
		return x.SoftwareRecipe
	}
	return nil
}

var File_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa7,
	0x02, 0x0a, 0x07, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5d,
	0x0a, 0x0d, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x0c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x55, 0x0a,
	0x07, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x52, 0x07, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x22, 0x52, 0x0a, 0x07, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12,
	0x17, 0x0a, 0x13, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10,
	0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x50, 0x54, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x59, 0x55,
	0x4d, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x5a, 0x59, 0x50, 0x50, 0x45, 0x52, 0x10, 0x04, 0x12,
	0x07, 0x0a, 0x03, 0x47, 0x4f, 0x4f, 0x10, 0x05, 0x22, 0xab, 0x02, 0x0a, 0x0d, 0x41, 0x70, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x68, 0x0a, 0x0c, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x70,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x41, 0x72, 0x63, 0x68,
	0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x70,
	0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x67, 0x70, 0x67,
	0x4b, 0x65, 0x79, 0x22, 0x41, 0x0a, 0x0b, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x44, 0x45, 0x42, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x42,
	0x5f, 0x53, 0x52, 0x43, 0x10, 0x02, 0x22, 0x78, 0x0a, 0x0d, 0x59, 0x75, 0x6d, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x61,
	0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x61,
	0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x70, 0x67, 0x5f, 0x6b, 0x65, 0x79,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x67, 0x70, 0x67, 0x4b, 0x65, 0x79, 0x73,
	0x22, 0x7b, 0x0a, 0x10, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x61, 0x73, 0x65, 0x55,
	0x72, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x70, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x67, 0x70, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x35, 0x0a,
	0x0d, 0x47, 0x6f, 0x6f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x75, 0x72, 0x6c, 0x22, 0xe6, 0x02, 0x0a, 0x11, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x4d, 0x0a, 0x03, 0x61, 0x70,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x48, 0x00, 0x52, 0x03, 0x61, 0x70, 0x74, 0x12, 0x4d, 0x0a, 0x03, 0x79, 0x75, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x59, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x48, 0x00, 0x52, 0x03, 0x79, 0x75, 0x6d, 0x12, 0x56, 0x0a, 0x06, 0x7a, 0x79, 0x70, 0x70,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x06, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72,
	0x12, 0x4d, 0x0a, 0x03, 0x67, 0x6f, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x03, 0x67, 0x6f, 0x6f, 0x42,
	0x0c, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0xff, 0x15,
	0x0a, 0x0e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x61,
	0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x12, 0x64, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x74, 0x65,
	0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65,
	0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0x62, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0x5d, 0x0a, 0x0d, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x9f, 0x03, 0x0a, 0x08, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x64, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63,
	0x69, 0x70, 0x65, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x5b, 0x0a,
	0x03, 0x67, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e,
	0x47, 0x63, 0x73, 0x48, 0x00, 0x52, 0x03, 0x67, 0x63, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x65, 0x1a, 0x36, 0x0a, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x1a, 0x55, 0x0a, 0x03, 0x47, 0x63, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x0a, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x1a, 0x90, 0x0f, 0x0a,
	0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x67, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x70, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65,
	0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x43, 0x6f, 0x70, 0x79, 0x46, 0x69,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x70, 0x79, 0x12, 0x7f,
	0x0a, 0x12, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x48, 0x00, 0x52, 0x11, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x77, 0x0a, 0x10, 0x6d, 0x73, 0x69, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52,
	0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x4d, 0x73, 0x69, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x73, 0x69, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x11, 0x64, 0x70, 0x6b, 0x67,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e,
	0x53, 0x74, 0x65, 0x70, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x70, 0x6b, 0x67,
	0x48, 0x00, 0x52, 0x10, 0x64, 0x70, 0x6b, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a, 0x10, 0x72, 0x70, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x70, 0x6d, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x70,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f,
	0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65,
	0x70, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x08, 0x66, 0x69,
	0x6c, 0x65, 0x45, 0x78, 0x65, 0x63, 0x12, 0x6a, 0x0a, 0x0a, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x5f, 0x72, 0x75, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x52, 0x75, 0x6e, 0x53,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x48, 0x00, 0x52, 0x09, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52,
	0x75, 0x6e, 0x1a, 0x8d, 0x01, 0x0a, 0x08, 0x43, 0x6f, 0x70, 0x79, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xb8, 0x02, 0x0a, 0x0e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69,
	0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x73, 0x0a, 0x0b, 0x41, 0x72, 0x63, 0x68,
	0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x56, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x41, 0x52, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x54, 0x41, 0x52, 0x5f, 0x47, 0x5a, 0x49, 0x50, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x54, 0x41, 0x52, 0x5f, 0x42, 0x5a, 0x49, 0x50, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x41,
	0x52, 0x5f, 0x4c, 0x5a, 0x4d, 0x41, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x41, 0x52, 0x5f,
	0x58, 0x5a, 0x10, 0x05, 0x12, 0x07, 0x0a, 0x03, 0x5a, 0x49, 0x50, 0x10, 0x0b, 0x1a, 0x71, 0x0a,
	0x0a, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4d, 0x73, 0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x78,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x10,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x73,
	0x1a, 0x2e, 0x0a, 0x0b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x70, 0x6b, 0x67, 0x12,
	0x1f, 0x0a, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64,
	0x1a, 0x2d, 0x0a, 0x0a, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x70, 0x6d, 0x12, 0x1f,
	0x0a, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x1a,
	0xa1, 0x01, 0x0a, 0x08, 0x45, 0x78, 0x65, 0x63, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0b,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04,
	0x61, 0x72, 0x67, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x05,
	0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64,
	0x65, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x1a, 0x91, 0x02, 0x0a, 0x09, 0x52, 0x75, 0x6e, 0x53, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x78,
	0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x77, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x52, 0x75,
	0x6e, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72,
	0x22, 0x45, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x12,
	0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x57, 0x45, 0x52,
	0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x03, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x22,
	0xc0, 0x01, 0x0a, 0x21, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x47, 0x75, 0x65, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x73, 0x5f, 0x73, 0x68, 0x6f,
	0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f,
	0x73, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x73,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6f, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x73, 0x5f,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x6f, 0x73, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x22, 0xc9, 0x06, 0x0a, 0x14, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x47, 0x75, 0x65, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6b, 0x0a, 0x08, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x47, 0x75, 0x65, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x08,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x8c, 0x01, 0x0a, 0x14, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x47, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x13, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x10, 0x73, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x69, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x47, 0x75, 0x65, 0x73, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x64, 0x53, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x52, 0x0f, 0x73, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x73, 0x1a, 0x77, 0x0a, 0x0e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x07, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x1a, 0xa0, 0x01, 0x0a, 0x18, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x64,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x6c, 0x0a, 0x12, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x11, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x1a, 0x94, 0x01, 0x0a, 0x15, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x64, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x63, 0x0a, 0x0f, 0x73, 0x6f, 0x66,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x69, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x52, 0x0e,
	0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2a, 0x56,
	0x0a, 0x0c, 0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d,
	0x0a, 0x19, 0x44, 0x45, 0x53, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a,
	0x09, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d,
	0x4f, 0x56, 0x45, 0x44, 0x10, 0x03, 0x42, 0xb4, 0x01, 0x0a, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0d, 0x47, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x5a, 0x54, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0xca, 0x02,
	0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescData = file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDesc
)

func file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescData)
	})
	return file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDescData
}

var file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_goTypes = []interface{}{
	(DesiredState)(0),                                     // 0: google.cloud.osconfig.agentendpoint.v1beta.DesiredState
	(Package_Manager)(0),                                  // 1: google.cloud.osconfig.agentendpoint.v1beta.Package.Manager
	(AptRepository_ArchiveType)(0),                        // 2: google.cloud.osconfig.agentendpoint.v1beta.AptRepository.ArchiveType
	(SoftwareRecipe_Step_ExtractArchive_ArchiveType)(0),   // 3: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExtractArchive.ArchiveType
	(SoftwareRecipe_Step_RunScript_Interpreter)(0),        // 4: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.RunScript.Interpreter
	(*Package)(nil),                                       // 5: google.cloud.osconfig.agentendpoint.v1beta.Package
	(*AptRepository)(nil),                                 // 6: google.cloud.osconfig.agentendpoint.v1beta.AptRepository
	(*YumRepository)(nil),                                 // 7: google.cloud.osconfig.agentendpoint.v1beta.YumRepository
	(*ZypperRepository)(nil),                              // 8: google.cloud.osconfig.agentendpoint.v1beta.ZypperRepository
	(*GooRepository)(nil),                                 // 9: google.cloud.osconfig.agentendpoint.v1beta.GooRepository
	(*PackageRepository)(nil),                             // 10: google.cloud.osconfig.agentendpoint.v1beta.PackageRepository
	(*SoftwareRecipe)(nil),                                // 11: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe
	(*LookupEffectiveGuestPolicyRequest)(nil),             // 12: google.cloud.osconfig.agentendpoint.v1beta.LookupEffectiveGuestPolicyRequest
	(*EffectiveGuestPolicy)(nil),                          // 13: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy
	(*SoftwareRecipe_Artifact)(nil),                       // 14: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact
	(*SoftwareRecipe_Step)(nil),                           // 15: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step
	(*SoftwareRecipe_Artifact_Remote)(nil),                // 16: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.Remote
	(*SoftwareRecipe_Artifact_Gcs)(nil),                   // 17: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.Gcs
	(*SoftwareRecipe_Step_CopyFile)(nil),                  // 18: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.CopyFile
	(*SoftwareRecipe_Step_ExtractArchive)(nil),            // 19: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExtractArchive
	(*SoftwareRecipe_Step_InstallMsi)(nil),                // 20: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallMsi
	(*SoftwareRecipe_Step_InstallDpkg)(nil),               // 21: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallDpkg
	(*SoftwareRecipe_Step_InstallRpm)(nil),                // 22: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallRpm
	(*SoftwareRecipe_Step_ExecFile)(nil),                  // 23: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExecFile
	(*SoftwareRecipe_Step_RunScript)(nil),                 // 24: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.RunScript
	(*EffectiveGuestPolicy_SourcedPackage)(nil),           // 25: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackage
	(*EffectiveGuestPolicy_SourcedPackageRepository)(nil), // 26: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackageRepository
	(*EffectiveGuestPolicy_SourcedSoftwareRecipe)(nil),    // 27: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedSoftwareRecipe
}
var file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_depIdxs = []int32{
	0,  // 0: google.cloud.osconfig.agentendpoint.v1beta.Package.desired_state:type_name -> google.cloud.osconfig.agentendpoint.v1beta.DesiredState
	1,  // 1: google.cloud.osconfig.agentendpoint.v1beta.Package.manager:type_name -> google.cloud.osconfig.agentendpoint.v1beta.Package.Manager
	2,  // 2: google.cloud.osconfig.agentendpoint.v1beta.AptRepository.archive_type:type_name -> google.cloud.osconfig.agentendpoint.v1beta.AptRepository.ArchiveType
	6,  // 3: google.cloud.osconfig.agentendpoint.v1beta.PackageRepository.apt:type_name -> google.cloud.osconfig.agentendpoint.v1beta.AptRepository
	7,  // 4: google.cloud.osconfig.agentendpoint.v1beta.PackageRepository.yum:type_name -> google.cloud.osconfig.agentendpoint.v1beta.YumRepository
	8,  // 5: google.cloud.osconfig.agentendpoint.v1beta.PackageRepository.zypper:type_name -> google.cloud.osconfig.agentendpoint.v1beta.ZypperRepository
	9,  // 6: google.cloud.osconfig.agentendpoint.v1beta.PackageRepository.goo:type_name -> google.cloud.osconfig.agentendpoint.v1beta.GooRepository
	14, // 7: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.artifacts:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact
	15, // 8: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.install_steps:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step
	15, // 9: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.update_steps:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step
	0,  // 10: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.desired_state:type_name -> google.cloud.osconfig.agentendpoint.v1beta.DesiredState
	25, // 11: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.packages:type_name -> google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackage
	26, // 12: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.package_repositories:type_name -> google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackageRepository
	27, // 13: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.software_recipes:type_name -> google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedSoftwareRecipe
	16, // 14: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.remote:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.Remote
	17, // 15: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.gcs:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.Gcs
	18, // 16: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.file_copy:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.CopyFile
	19, // 17: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.archive_extraction:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExtractArchive
	20, // 18: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.msi_installation:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallMsi
	21, // 19: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.dpkg_installation:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallDpkg
	22, // 20: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.rpm_installation:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallRpm
	23, // 21: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.file_exec:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExecFile
	24, // 22: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.script_run:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.RunScript
	3,  // 23: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExtractArchive.type:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExtractArchive.ArchiveType
	4,  // 24: google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.RunScript.interpreter:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.RunScript.Interpreter
	5,  // 25: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackage.package:type_name -> google.cloud.osconfig.agentendpoint.v1beta.Package
	10, // 26: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackageRepository.package_repository:type_name -> google.cloud.osconfig.agentendpoint.v1beta.PackageRepository
	11, // 27: google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedSoftwareRecipe.software_recipe:type_name -> google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_init() }
func file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_init() {
	if File_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Package); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AptRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*YumRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ZypperRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GooRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupEffectiveGuestPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EffectiveGuestPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Artifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Artifact_Remote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Artifact_Gcs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step_CopyFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step_ExtractArchive); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step_InstallMsi); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step_InstallDpkg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step_InstallRpm); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step_ExecFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareRecipe_Step_RunScript); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EffectiveGuestPolicy_SourcedPackage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EffectiveGuestPolicy_SourcedPackageRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EffectiveGuestPolicy_SourcedSoftwareRecipe); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*PackageRepository_Apt)(nil),
		(*PackageRepository_Yum)(nil),
		(*PackageRepository_Zypper)(nil),
		(*PackageRepository_Goo)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*SoftwareRecipe_Artifact_Remote_)(nil),
		(*SoftwareRecipe_Artifact_Gcs_)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*SoftwareRecipe_Step_FileCopy)(nil),
		(*SoftwareRecipe_Step_ArchiveExtraction)(nil),
		(*SoftwareRecipe_Step_MsiInstallation)(nil),
		(*SoftwareRecipe_Step_DpkgInstallation)(nil),
		(*SoftwareRecipe_Step_RpmInstallation)(nil),
		(*SoftwareRecipe_Step_FileExec)(nil),
		(*SoftwareRecipe_Step_ScriptRun)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*SoftwareRecipe_Step_ExecFile_ArtifactId)(nil),
		(*SoftwareRecipe_Step_ExecFile_LocalPath)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto = out.File
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_rawDesc = nil
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_goTypes = nil
	file_google_cloud_osconfig_agentendpoint_v1beta_guest_policies_proto_depIdxs = nil
}
