# frozen_string_literal: true

class DropIndexVulnerabilityOccurrencesOnProjectFingerprint < Gitlab::Database::Migration[2.2]
  INDEX_NAME = 'index_vulnerability_occurrences_on_project_fingerprint'

  disable_ddl_transaction!
  milestone '17.1'

  def up
    remove_concurrent_index_by_name :vulnerability_occurrences, INDEX_NAME
  end

  def down
    add_concurrent_index :vulnerability_occurrences, :project_fingerprint, name: INDEX_NAME
  end
end
