/* gmpc-song-list.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-song-list.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <metadata.h>
#include <gmpc-metaimage.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <libmpd/libmpd-internal.h>

typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _mpd_data_free0(var) ((var == NULL) ? NULL : (var = (mpd_data_free (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	GmpcWidgetsSonglist * self;
	mpd_Song* song_file;
};

struct _Block2Data {
	int _ref_count_;
	GmpcWidgetsSonglist * self;
	mpd_Song* song_file;
};

struct _Block3Data {
	int _ref_count_;
	GmpcWidgetsSonglist * self;
	GtkImage* image;
	mpd_Song* song_file;
};


static gpointer gmpc_widgets_songlist_parent_class = NULL;

#define use_transition_gsl TRUE
#define some_unique_name_gsl VERSION
enum  {
	GMPC_WIDGETS_SONGLIST_DUMMY_PROPERTY
};
#define GMPC_WIDGETS_SONGLIST_MAX_RESULTS 125
static void gmpc_widgets_songlist_add_artist_entry (GmpcWidgetsSonglist* self, const mpd_Song* song, gint level);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda11_ (GmpcClicklabel* source, gboolean event, Block1Data* _data1_);
static void __lambda11__gmpc_clicklabel_clicked (GmpcClicklabel* _sender, gboolean alt, gpointer self);
static void gmpc_widgets_songlist_add_album_entry (GmpcWidgetsSonglist* self, const mpd_Song* song, gint level);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda12_ (gboolean source, Block2Data* _data2_);
static void __lambda12__gmpc_clicklabel_clicked (GmpcClicklabel* _sender, gboolean alt, gpointer self);
static void gmpc_widgets_songlist_add_disc_entry (GmpcWidgetsSonglist* self, const gchar* entry, gint level);
static void gmpc_widgets_songlist_add_song_entry (GmpcWidgetsSonglist* self, const mpd_Song* song, gint level);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _lambda13_ (GtkWidget* source, GdkEventCrossing* event, Block3Data* _data3_);
static gboolean __lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda14_ (GtkWidget* source, GdkEventCrossing* event, Block3Data* _data3_);
static gboolean __lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda15_ (GtkWidget* source, GdkEventButton* event, Block3Data* _data3_);
static gboolean __lambda15__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _lambda16_ (GmpcClicklabel* source, gboolean alt, Block3Data* _data3_);
static void __lambda16__gmpc_clicklabel_clicked (GmpcClicklabel* _sender, gboolean alt, gpointer self);


GmpcWidgetsSonglist* gmpc_widgets_songlist_construct (GType object_type) {
	GmpcWidgetsSonglist * self = NULL;
	self = (GmpcWidgetsSonglist*) gmpc_widgets_qtable_construct (object_type);
	gmpc_widgets_qtable_set_spacing ((GmpcWidgetsQtable*) self, 6);
	gmpc_widgets_qtable_set_max_columns ((GmpcWidgetsQtable*) self, 3);
	return self;
}


GmpcWidgetsSonglist* gmpc_widgets_songlist_new (void) {
	return gmpc_widgets_songlist_construct (GMPC_WIDGETS_TYPE_SONGLIST);
}


/**
     * Add a artist entry
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_mpd_freeSong0 (_data1_->song_file);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _lambda11_ (GmpcClicklabel* source, gboolean event, Block1Data* _data1_) {
	GmpcWidgetsSonglist * self;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	g_signal_emit_by_name (self, "artist-song-clicked", _data1_->song_file);
}


static void __lambda11__gmpc_clicklabel_clicked (GmpcClicklabel* _sender, gboolean alt, gpointer self) {
	_lambda11_ (_sender, alt, self);
}


static void gmpc_widgets_songlist_add_artist_entry (GmpcWidgetsSonglist* self, const mpd_Song* song, gint level) {
	Block1Data* _data1_;
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* event;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* box;
	GtkAlignment* _tmp2_ = NULL;
	GtkAlignment* ali;
	GmpcMetaImage* _tmp3_ = NULL;
	GmpcMetaImage* image;
	gchar* label;
	gboolean _tmp4_ = FALSE;
	GmpcClicklabel* _tmp10_ = NULL;
	GmpcClicklabel* wlabel;
	mpd_Song* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (song != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	event = g_object_ref_sink (_tmp0_);
	gtk_event_box_set_visible_window (event, FALSE);
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	box = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp2_);
	gtk_alignment_set_padding (ali, (guint) 0, (guint) 0, (guint) (level * 32), (guint) 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp3_ = gmpc_metaimage_new_size (META_ARTIST_ART, 32);
	image = g_object_ref_sink (_tmp3_);
	gmpc_metaimage_set_no_cover_icon (image, "no-artist");
	gmpc_metaimage_set_loading_cover_icon (image, "fetching-artist");
	gmpc_metaimage_set_squared (image, FALSE);
	gmpc_metaimage_update_cover_from_song (image, song);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) image);
	label = NULL;
	if (song->albumartist != NULL) {
		gint _tmp5_;
		_tmp5_ = strlen (song->albumartist);
		_tmp4_ = _tmp5_ > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = _ ("Artist");
		_tmp7_ = g_strdup_printf ("%s: %s", _tmp6_, song->albumartist);
		_g_free0 (label);
		label = _tmp7_;
	} else {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = _ ("Artist");
		_tmp9_ = g_strdup_printf ("%s: %s", _tmp8_, song->artist);
		_g_free0 (label);
		label = _tmp9_;
	}
	_tmp10_ = gmpc_clicklabel_new (label);
	wlabel = g_object_ref_sink (_tmp10_);
	gmpc_clicklabel_set_do_bold (wlabel, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) wlabel, TRUE);
	_tmp11_ = _mpd_songDup0 (song);
	_data1_->song_file = _tmp11_;
	g_signal_connect_data (wlabel, "clicked", (GCallback) __lambda11__gmpc_clicklabel_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) wlabel, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) event, (GtkWidget*) box);
	gmpc_widgets_qtable_add_header ((GmpcWidgetsQtable*) self, (GtkWidget*) event);
	_g_object_unref0 (wlabel);
	_g_free0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (ali);
	_g_object_unref0 (box);
	_g_object_unref0 (event);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


/**
     * Add a album entry
     */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_mpd_freeSong0 (_data2_->song_file);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda12_ (gboolean source, Block2Data* _data2_) {
	GmpcWidgetsSonglist * self;
	self = _data2_->self;
	g_signal_emit_by_name (self, "album-song-clicked", _data2_->song_file);
}


static void __lambda12__gmpc_clicklabel_clicked (GmpcClicklabel* _sender, gboolean alt, gpointer self) {
	_lambda12_ (alt, self);
}


static void gmpc_widgets_songlist_add_album_entry (GmpcWidgetsSonglist* self, const mpd_Song* song, gint level) {
	Block2Data* _data2_;
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* event;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* box;
	GtkAlignment* _tmp2_ = NULL;
	GtkAlignment* ali;
	GmpcMetaImage* _tmp3_ = NULL;
	GmpcMetaImage* image;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* label;
	GmpcClicklabel* _tmp6_ = NULL;
	GmpcClicklabel* wlabel;
	mpd_Song* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (song != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	event = g_object_ref_sink (_tmp0_);
	gtk_event_box_set_visible_window (event, FALSE);
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	box = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp2_);
	gtk_alignment_set_padding (ali, (guint) 0, (guint) 0, (guint) (level * 32), (guint) 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp3_ = gmpc_metaimage_new_size (META_ALBUM_ART, 32);
	image = g_object_ref_sink (_tmp3_);
	gmpc_metaimage_set_squared (image, FALSE);
	gmpc_metaimage_update_cover_from_song (image, song);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) image);
	_tmp4_ = _ ("Album");
	_tmp5_ = g_strdup_printf ("%s: %s", _tmp4_, song->album);
	label = _tmp5_;
	_tmp6_ = gmpc_clicklabel_new (label);
	wlabel = g_object_ref_sink (_tmp6_);
	gmpc_clicklabel_set_do_bold (wlabel, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) wlabel, TRUE);
	_tmp7_ = _mpd_songDup0 (song);
	_data2_->song_file = _tmp7_;
	g_signal_connect_data (wlabel, "clicked", (GCallback) __lambda12__gmpc_clicklabel_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) wlabel, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) event, (GtkWidget*) box);
	gmpc_widgets_qtable_add_header ((GmpcWidgetsQtable*) self, (GtkWidget*) event);
	_g_object_unref0 (wlabel);
	_g_free0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (ali);
	_g_object_unref0 (box);
	_g_object_unref0 (event);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


/**
     * Add a disc entry
     */
static void gmpc_widgets_songlist_add_disc_entry (GmpcWidgetsSonglist* self, const gchar* entry, gint level) {
	GtkHBox* _tmp0_ = NULL;
	GtkHBox* box;
	GtkAlignment* _tmp1_ = NULL;
	GtkAlignment* ali;
	GtkImage* _tmp2_ = NULL;
	GtkImage* image;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* label;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* wlabel;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	g_debug ("gmpc-song-list.vala:134: Disc entry add: %s", entry);
	_tmp0_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	box = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp1_);
	gtk_alignment_set_padding (ali, (guint) 0, (guint) 0, (guint) (level * 32), (guint) 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_BUTTON);
	image = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) image);
	_tmp3_ = _ ("Disc");
	_tmp4_ = g_strdup_printf ("<b>%s: %s</b>", _tmp3_, entry);
	label = _tmp4_;
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	wlabel = g_object_ref_sink (_tmp5_);
	gtk_label_set_markup (wlabel, label);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) wlabel, FALSE, FALSE, (guint) 0);
	gmpc_widgets_qtable_add_header ((GmpcWidgetsQtable*) self, (GtkWidget*) box);
	_g_object_unref0 (wlabel);
	_g_free0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (ali);
	_g_object_unref0 (box);
}


/**
     * Add a song entry
     */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_mpd_freeSong0 (_data3_->song_file);
		_g_object_unref0 (_data3_->image);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _lambda13_ (GtkWidget* source, GdkEventCrossing* event, Block3Data* _data3_) {
	GmpcWidgetsSonglist * self;
	gboolean result = FALSE;
	self = _data3_->self;
	g_return_val_if_fail (source != NULL, FALSE);
	gtk_image_set_from_stock (_data3_->image, "gtk-media-play", GTK_ICON_SIZE_MENU);
	result = FALSE;
	return result;
}


static gboolean __lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda13_ (_sender, event, self);
	return result;
}


static gboolean _lambda14_ (GtkWidget* source, GdkEventCrossing* event, Block3Data* _data3_) {
	GmpcWidgetsSonglist * self;
	gboolean result = FALSE;
	self = _data3_->self;
	g_return_val_if_fail (source != NULL, FALSE);
	gtk_image_set_from_icon_name (_data3_->image, "media-audiofile", GTK_ICON_SIZE_MENU);
	result = FALSE;
	return result;
}


static gboolean __lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda14_ (_sender, event, self);
	return result;
}


static gboolean _lambda15_ (GtkWidget* source, GdkEventButton* event, Block3Data* _data3_) {
	GmpcWidgetsSonglist * self;
	gboolean result = FALSE;
	self = _data3_->self;
	g_return_val_if_fail (source != NULL, FALSE);
	if ((*event).button == 1) {
		g_signal_emit_by_name (self, "play-song-clicked", _data3_->song_file);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean __lambda15__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda15_ (_sender, event, self);
	return result;
}


static void _lambda16_ (GmpcClicklabel* source, gboolean alt, Block3Data* _data3_) {
	GmpcWidgetsSonglist * self;
	self = _data3_->self;
	g_return_if_fail (source != NULL);
	if (alt) {
		g_signal_emit_by_name (self, "play-song-clicked", _data3_->song_file);
	} else {
		g_signal_emit_by_name (self, "song-clicked", _data3_->song_file);
	}
}


static void __lambda16__gmpc_clicklabel_clicked (GmpcClicklabel* _sender, gboolean alt, gpointer self) {
	_lambda16_ (_sender, alt, self);
}


static void gmpc_widgets_songlist_add_song_entry (GmpcWidgetsSonglist* self, const mpd_Song* song, gint level) {
	Block3Data* _data3_;
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* event;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* box;
	GtkAlignment* _tmp2_ = NULL;
	GtkAlignment* ali;
	GtkImage* _tmp3_ = NULL;
	mpd_Song* _tmp4_;
	gchar* label;
	gboolean _tmp5_ = FALSE;
	GmpcClicklabel* _tmp9_ = NULL;
	GmpcClicklabel* wlabel;
	g_return_if_fail (self != NULL);
	g_return_if_fail (song != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	event = g_object_ref_sink (_tmp0_);
	gtk_event_box_set_visible_window (event, FALSE);
	g_debug ("gmpc-song-list.vala:171: Song entry add: %s", song->file);
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	box = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp2_);
	gtk_alignment_set_padding (ali, (guint) 0, (guint) 0, (guint) (level * 32), (guint) 0);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("media-audiofile", GTK_ICON_SIZE_MENU);
	_data3_->image = g_object_ref_sink (_tmp3_);
	g_signal_connect_data ((GtkWidget*) event, "enter-notify-event", (GCallback) __lambda13__gtk_widget_enter_notify_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) event, "leave-notify-event", (GCallback) __lambda14__gtk_widget_leave_notify_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_container_add ((GtkContainer*) event, (GtkWidget*) _data3_->image);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) event);
	_tmp4_ = _mpd_songDup0 (song);
	_data3_->song_file = _tmp4_;
	g_signal_connect_data ((GtkWidget*) event, "button-release-event", (GCallback) __lambda15__gtk_widget_button_release_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	label = NULL;
	if (song->track != NULL) {
		_tmp5_ = song->title != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_strdup_printf ("%02s. %s", song->track, song->title);
		_g_free0 (label);
		label = _tmp6_;
	} else {
		if (song->title != NULL) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup (song->title);
			_g_free0 (label);
			label = _tmp7_;
		} else {
			gchar* _tmp8_ = NULL;
			_tmp8_ = g_path_get_basename (song->file);
			_g_free0 (label);
			label = _tmp8_;
		}
	}
	_tmp9_ = gmpc_clicklabel_new (label);
	wlabel = g_object_ref_sink (_tmp9_);
	gtk_widget_set_can_focus ((GtkWidget*) wlabel, TRUE);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) wlabel, FALSE, FALSE, (guint) 0);
	g_signal_connect_data (wlabel, "clicked", (GCallback) __lambda16__gmpc_clicklabel_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_g_object_unref0 (wlabel);
	_g_free0 (label);
	_g_object_unref0 (ali);
	_g_object_unref0 (box);
	_g_object_unref0 (event);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


/**
      * Fill the widget from a song list
      */
void gmpc_widgets_songlist_set_from_data (GmpcWidgetsSonglist* self, MpdData* list, gboolean show_album, gboolean show_artist) {
	gint results;
	GList* _tmp0_ = NULL;
	MpdData* iter;
	gchar* disc;
	gchar* album;
	gchar* artist;
	gint level;
	g_return_if_fail (self != NULL);
	results = 0;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child;
			child = (GtkWidget*) child_it->data;
			{
				gtk_object_destroy ((GtkObject*) child);
			}
		}
		_g_list_free0 (child_collection);
	}
	if (list == NULL) {
		_mpd_data_free0 (list);
		return;
	}
	list = misc_sort_mpddata_by_album_disc_track (list);
	iter = list;
	disc = NULL;
	album = NULL;
	artist = NULL;
	level = -1;
	{
		gboolean _tmp1_;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp21_ = FALSE;
			if (!_tmp1_) {
				iter = mpd_data_get_next_real (iter, FALSE);
			}
			_tmp1_ = FALSE;
			if (!(iter != NULL)) {
				break;
			}
			if (iter->song == NULL) {
				continue;
			}
			if (results > GMPC_WIDGETS_SONGLIST_MAX_RESULTS) {
				GtkInfoBar* _tmp2_ = NULL;
				GtkInfoBar* bar;
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				const gchar* _tmp5_ = NULL;
				GtkLabel* _tmp6_ = NULL;
				GtkLabel* _tmp7_;
				GtkLabel* label;
				GtkWidget* _tmp8_ = NULL;
				GtkWidget* _tmp9_;
				_tmp2_ = (GtkInfoBar*) gtk_info_bar_new ();
				bar = g_object_ref_sink (_tmp2_);
				_tmp3_ = g_strdup_printf ("Only the first %i results are shown. Please refine your search.", GMPC_WIDGETS_SONGLIST_MAX_RESULTS);
				_tmp4_ = _tmp3_;
				_tmp5_ = _ (_tmp4_);
				_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
				_tmp7_ = g_object_ref_sink (_tmp6_);
				_g_free0 (_tmp4_);
				label = _tmp7_;
				gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
				gtk_info_bar_set_message_type (bar, GTK_MESSAGE_WARNING);
				_tmp8_ = gtk_info_bar_get_content_area (bar);
				_tmp9_ = _tmp8_;
				gtk_container_add (GTK_IS_CONTAINER (_tmp9_) ? ((GtkContainer*) _tmp9_) : NULL, (GtkWidget*) label);
				gmpc_widgets_qtable_add_header ((GmpcWidgetsQtable*) self, (GtkWidget*) bar);
				_g_object_unref0 (label);
				_g_object_unref0 (bar);
				break;
			}
			results++;
			if (show_artist) {
				gboolean _tmp10_ = FALSE;
				if (iter->song->albumartist != NULL) {
					gint _tmp11_;
					_tmp11_ = strlen (iter->song->albumartist);
					_tmp10_ = _tmp11_ > 0;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gboolean _tmp12_ = FALSE;
					if (artist == NULL) {
						_tmp12_ = TRUE;
					} else {
						_tmp12_ = g_strcmp0 (artist, iter->song->albumartist) != 0;
					}
					if (_tmp12_) {
						gchar* _tmp13_;
						gmpc_widgets_songlist_add_artist_entry (self, iter->song, 0);
						_tmp13_ = g_strdup (iter->song->albumartist);
						_g_free0 (artist);
						artist = _tmp13_;
						_g_free0 (disc);
						disc = NULL;
						_g_free0 (album);
						album = NULL;
					}
				} else {
					gboolean _tmp14_ = FALSE;
					if (iter->song->artist != NULL) {
						gboolean _tmp15_ = FALSE;
						if (artist == NULL) {
							_tmp15_ = TRUE;
						} else {
							_tmp15_ = g_strcmp0 (artist, iter->song->artist) != 0;
						}
						_tmp14_ = _tmp15_;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						gchar* _tmp16_;
						gmpc_widgets_songlist_add_artist_entry (self, iter->song, 0);
						_tmp16_ = g_strdup (iter->song->artist);
						_g_free0 (artist);
						artist = _tmp16_;
						_g_free0 (disc);
						disc = NULL;
						_g_free0 (album);
						album = NULL;
					}
				}
			}
			if (show_album) {
				gboolean _tmp17_ = FALSE;
				if (iter->song->album != NULL) {
					gboolean _tmp18_ = FALSE;
					if (album == NULL) {
						_tmp18_ = TRUE;
					} else {
						_tmp18_ = g_strcmp0 (album, iter->song->album) != 0;
					}
					_tmp17_ = _tmp18_;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					gint _tmp19_ = 0;
					gchar* _tmp20_;
					if (artist != NULL) {
						_tmp19_ = 1;
					} else {
						_tmp19_ = 0;
					}
					gmpc_widgets_songlist_add_album_entry (self, iter->song, _tmp19_);
					_tmp20_ = g_strdup (iter->song->album);
					_g_free0 (album);
					album = _tmp20_;
					_g_free0 (disc);
					disc = NULL;
				}
			}
			if (iter->song->disc != NULL) {
				gboolean _tmp22_ = FALSE;
				if (disc == NULL) {
					_tmp22_ = TRUE;
				} else {
					_tmp22_ = g_strcmp0 (disc, iter->song->disc) != 0;
				}
				_tmp21_ = _tmp22_;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gchar* _tmp25_;
				if (artist != NULL) {
					_tmp23_ = 1;
				} else {
					_tmp23_ = 0;
				}
				if (album != NULL) {
					_tmp24_ = 1;
				} else {
					_tmp24_ = 0;
				}
				gmpc_widgets_songlist_add_disc_entry (self, iter->song->disc, _tmp23_ + _tmp24_);
				_tmp25_ = g_strdup (iter->song->disc);
				_g_free0 (disc);
				disc = _tmp25_;
			}
			level = 0;
			if (disc != NULL) {
				level++;
			}
			if (artist != NULL) {
				level++;
			}
			if (album != NULL) {
				level++;
			}
			gmpc_widgets_songlist_add_song_entry (self, iter->song, level);
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_g_free0 (artist);
	_g_free0 (album);
	_g_free0 (disc);
	_mpd_data_free0 (list);
}


static void gmpc_widgets_songlist_class_init (GmpcWidgetsSonglistClass * klass) {
	gmpc_widgets_songlist_parent_class = g_type_class_peek_parent (klass);
	g_signal_new ("song_clicked", GMPC_WIDGETS_TYPE_SONGLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("play_song_clicked", GMPC_WIDGETS_TYPE_SONGLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("album_song_clicked", GMPC_WIDGETS_TYPE_SONGLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("artist_song_clicked", GMPC_WIDGETS_TYPE_SONGLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}


static void gmpc_widgets_songlist_instance_init (GmpcWidgetsSonglist * self) {
}


GType gmpc_widgets_songlist_get_type (void) {
	static volatile gsize gmpc_widgets_songlist_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_widgets_songlist_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcWidgetsSonglistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_widgets_songlist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcWidgetsSonglist), 0, (GInstanceInitFunc) gmpc_widgets_songlist_instance_init, NULL };
		GType gmpc_widgets_songlist_type_id;
		gmpc_widgets_songlist_type_id = g_type_register_static (GMPC_WIDGETS_TYPE_QTABLE, "GmpcWidgetsSonglist", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_widgets_songlist_type_id__volatile, gmpc_widgets_songlist_type_id);
	}
	return gmpc_widgets_songlist_type_id__volatile;
}



