// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a dynamic thing group. Requires permission to access the
// CreateDynamicThingGroup
// (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
func (c *Client) CreateDynamicThingGroup(ctx context.Context, params *CreateDynamicThingGroupInput, optFns ...func(*Options)) (*CreateDynamicThingGroupOutput, error) {
	if params == nil {
		params = &CreateDynamicThingGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDynamicThingGroup", params, optFns, c.addOperationCreateDynamicThingGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDynamicThingGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDynamicThingGroupInput struct {

	// The dynamic thing group search query string. See Query Syntax
	// (https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html) for
	// information about query string syntax.
	//
	// This member is required.
	QueryString *string

	// The dynamic thing group name to create.
	//
	// This member is required.
	ThingGroupName *string

	// The dynamic thing group index name. Currently one index is supported:
	// AWS_Things.
	IndexName *string

	// The dynamic thing group query version. Currently one query version is supported:
	// "2017-09-30". If not specified, the query version defaults to this value.
	QueryVersion *string

	// Metadata which can be used to manage the dynamic thing group.
	Tags []types.Tag

	// The dynamic thing group properties.
	ThingGroupProperties *types.ThingGroupProperties

	noSmithyDocumentSerde
}

type CreateDynamicThingGroupOutput struct {

	// The dynamic thing group index name.
	IndexName *string

	// The dynamic thing group search query string.
	QueryString *string

	// The dynamic thing group query version.
	QueryVersion *string

	// The dynamic thing group ARN.
	ThingGroupArn *string

	// The dynamic thing group ID.
	ThingGroupId *string

	// The dynamic thing group name.
	ThingGroupName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDynamicThingGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDynamicThingGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDynamicThingGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateDynamicThingGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDynamicThingGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDynamicThingGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "execute-api",
		OperationName: "CreateDynamicThingGroup",
	}
}
