// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisvideoarchivedmedia

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves a list of Images corresponding to each timestamp for a given time
// range, sampling interval, and image format configuration.
func (c *Client) GetImages(ctx context.Context, params *GetImagesInput, optFns ...func(*Options)) (*GetImagesOutput, error) {
	if params == nil {
		params = &GetImagesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetImages", params, optFns, c.addOperationGetImagesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetImagesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetImagesInput struct {

	// The end timestamp for the range of images to be generated.
	//
	// This member is required.
	EndTimestamp *time.Time

	// The format that will be used to encode the image.
	//
	// This member is required.
	Format types.Format

	// The origin of the Server or Producer timestamps to use to generate the images.
	//
	// This member is required.
	ImageSelectorType types.ImageSelectorType

	// The time interval in milliseconds (ms) at which the images need to be generated
	// from the stream. The minimum value that can be provided is 3000 ms. If the
	// timestamp range is less than the sampling interval, the Image from the
	// startTimestamp will be returned if available. The minimum value of 3000 ms is a
	// soft limit. If needed, a lower sampling frequency can be requested.
	//
	// This member is required.
	SamplingInterval *int32

	// The starting point from which the images should be generated. This
	// StartTimestamp must be within an inclusive range of timestamps for an image to
	// be returned.
	//
	// This member is required.
	StartTimestamp *time.Time

	// The list of a key-value pair structure that contains extra parameters that can
	// be applied when the image is generated. The FormatConfig key is the JPEGQuality,
	// which indicates the JPEG quality key to be used to generate the image. The
	// FormatConfig value accepts ints from 1 to 100. If the value is 1, the image will
	// be generated with less quality and the best compression. If the value is 100,
	// the image will be generated with the best quality and less compression. If no
	// value is provided, the default value of the JPEGQuality key will be set to 80.
	FormatConfig map[string]string

	// The height of the output image that is used in conjunction with the WidthPixels
	// parameter. When both HeightPixels and WidthPixels parameters are provided, the
	// image will be stretched to fit the specified aspect ratio. If only the
	// HeightPixels parameter is provided, its original aspect ratio will be used to
	// calculate the WidthPixels ratio. If neither parameter is provided, the original
	// image size will be returned.
	HeightPixels *int32

	// The maximum number of images to be returned by the API. The default limit is 100
	// images per API response. The additional results will be paginated.
	MaxResults *int64

	// A token that specifies where to start paginating the next set of Images. This is
	// the GetImages:NextToken from a previously truncated response.
	NextToken *string

	// The Amazon Resource Name (ARN) of the stream from which to retrieve the images.
	// You must specify either the StreamName or the StreamARN.
	StreamARN *string

	// The name of the stream from which to retrieve the images. You must specify
	// either the StreamName or the StreamARN.
	StreamName *string

	// The width of the output image that is used in conjunction with the HeightPixels
	// parameter. When both WidthPixels and HeightPixels parameters are provided, the
	// image will be stretched to fit the specified aspect ratio. If only the
	// WidthPixels parameter is provided or if only the HeightPixels is provided, a
	// ValidationException will be thrown. If neither parameter is provided, the
	// original image size from the stream will be returned.
	WidthPixels *int32

	noSmithyDocumentSerde
}

type GetImagesOutput struct {

	// The list of images generated from the video stream. If there is no media
	// available for the given timestamp, the NO_MEDIA error will be listed in the
	// output. If an error occurs while the image is being generated, the MEDIA_ERROR
	// will be listed in the output as the cause of the missing image.
	Images []types.Image

	// The encrypted token that was used in the request to get more images.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetImagesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetImages{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetImages{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetImagesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetImages(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetImages(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "kinesisvideo",
		OperationName: "GetImages",
	}
}
