// Code generated by smithy-go-codegen DO NOT EDIT.

package organizations

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Closes an Amazon Web Services member account within an organization. You can't
// close the management account with this API. This is an asynchronous request that
// Amazon Web Services performs in the background. Because CloseAccount operates
// asynchronously, it can return a successful completion message even though
// account closure might still be in progress. You need to wait a few minutes
// before the account is fully closed. To check the status of the request, do one
// of the following:
//
// * Use the AccountId that you sent in the CloseAccount request
// to provide as a parameter to the DescribeAccount operation. While the close
// account request is in progress, Account status will indicate PENDING_CLOSURE.
// When the close account request completes, the status will change to
// SUSPENDED.
//
// * Check the CloudTrail log for the CloseAccountResult event that
// gets published after the account closes successfully. For information on using
// CloudTrail with Organizations, see Logging and monitoring in Organizations
// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration)
// in the Organizations User Guide.
//
// * You can only close 10% of active member
// accounts within a rolling 30 day period. This quota is not bound by a calendar
// month, but starts when you close an account. Within 30 days of that initial
// account closure, you can't exceed the 10% account closure limit.
//
// * To reinstate
// a closed account, contact Amazon Web Services Support within the 90-day grace
// period while the account is in SUSPENDED status.
//
// * If the Amazon Web Services
// account you attempt to close is linked to an Amazon Web Services GovCloud (US)
// account, the CloseAccount request will close both accounts. To learn important
// pre-closure details, see  Closing an Amazon Web Services GovCloud (US) account
// (https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/Closing-govcloud-account.html)
// in the Amazon Web Services GovCloud User Guide.
//
// For more information about
// closing accounts, see Closing an Amazon Web Services account
// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html)
// in the Organizations User Guide.
func (c *Client) CloseAccount(ctx context.Context, params *CloseAccountInput, optFns ...func(*Options)) (*CloseAccountOutput, error) {
	if params == nil {
		params = &CloseAccountInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CloseAccount", params, optFns, c.addOperationCloseAccountMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CloseAccountOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CloseAccountInput struct {

	// Retrieves the Amazon Web Services account Id for the current CloseAccount API
	// request.
	//
	// This member is required.
	AccountId *string

	noSmithyDocumentSerde
}

type CloseAccountOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCloseAccountMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCloseAccount{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCloseAccount{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCloseAccountValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCloseAccount(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCloseAccount(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "organizations",
		OperationName: "CloseAccount",
	}
}
