// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/iam/v1beta/workload_identity_pool.proto

package iam

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the pool.
type WorkloadIdentityPool_State int32

const (
	// State unspecified.
	WorkloadIdentityPool_STATE_UNSPECIFIED WorkloadIdentityPool_State = 0
	// The pool is active, and may be used in Google Cloud policies.
	WorkloadIdentityPool_ACTIVE WorkloadIdentityPool_State = 1
	// The pool is soft-deleted. Soft-deleted pools are permanently deleted
	// after approximately 30 days. You can restore a soft-deleted pool using
	// [UndeleteWorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPools.UndeleteWorkloadIdentityPool].
	//
	// You cannot reuse the ID of a soft-deleted pool until it is permanently
	// deleted.
	//
	// While a pool is deleted, you cannot use it to exchange tokens, or use
	// existing tokens to access resources. If the pool is undeleted, existing
	// tokens grant access again.
	WorkloadIdentityPool_DELETED WorkloadIdentityPool_State = 2
)

// Enum value maps for WorkloadIdentityPool_State.
var (
	WorkloadIdentityPool_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "DELETED",
	}
	WorkloadIdentityPool_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"DELETED":           2,
	}
)

func (x WorkloadIdentityPool_State) Enum() *WorkloadIdentityPool_State {
	p := new(WorkloadIdentityPool_State)
	*p = x
	return p
}

func (x WorkloadIdentityPool_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadIdentityPool_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_v1beta_workload_identity_pool_proto_enumTypes[0].Descriptor()
}

func (WorkloadIdentityPool_State) Type() protoreflect.EnumType {
	return &file_google_iam_v1beta_workload_identity_pool_proto_enumTypes[0]
}

func (x WorkloadIdentityPool_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadIdentityPool_State.Descriptor instead.
func (WorkloadIdentityPool_State) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{0, 0}
}

// The current state of the provider.
type WorkloadIdentityPoolProvider_State int32

const (
	// State unspecified.
	WorkloadIdentityPoolProvider_STATE_UNSPECIFIED WorkloadIdentityPoolProvider_State = 0
	// The provider is active, and may be used to validate authentication
	// credentials.
	WorkloadIdentityPoolProvider_ACTIVE WorkloadIdentityPoolProvider_State = 1
	// The provider is soft-deleted. Soft-deleted providers are permanently
	// deleted after approximately 30 days. You can restore a soft-deleted
	// provider using
	// [UndeleteWorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityPools.UndeleteWorkloadIdentityPoolProvider].
	//
	// You cannot reuse the ID of a soft-deleted provider until it is
	// permanently deleted.
	WorkloadIdentityPoolProvider_DELETED WorkloadIdentityPoolProvider_State = 2
)

// Enum value maps for WorkloadIdentityPoolProvider_State.
var (
	WorkloadIdentityPoolProvider_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "DELETED",
	}
	WorkloadIdentityPoolProvider_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"DELETED":           2,
	}
)

func (x WorkloadIdentityPoolProvider_State) Enum() *WorkloadIdentityPoolProvider_State {
	p := new(WorkloadIdentityPoolProvider_State)
	*p = x
	return p
}

func (x WorkloadIdentityPoolProvider_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadIdentityPoolProvider_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_v1beta_workload_identity_pool_proto_enumTypes[1].Descriptor()
}

func (WorkloadIdentityPoolProvider_State) Type() protoreflect.EnumType {
	return &file_google_iam_v1beta_workload_identity_pool_proto_enumTypes[1]
}

func (x WorkloadIdentityPoolProvider_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadIdentityPoolProvider_State.Descriptor instead.
func (WorkloadIdentityPoolProvider_State) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{1, 0}
}

// Represents a collection of external workload identities. You can define IAM
// policies to grant these identities access to Google Cloud resources.
type WorkloadIdentityPool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the pool.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A display name for the pool. Cannot exceed 32 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description of the pool. Cannot exceed 256 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The state of the pool.
	State WorkloadIdentityPool_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.iam.v1beta.WorkloadIdentityPool_State" json:"state,omitempty"`
	// Whether the pool is disabled. You cannot use a disabled pool to exchange
	// tokens, or use existing tokens to access resources. If
	// the pool is re-enabled, existing tokens grant access again.
	Disabled bool `protobuf:"varint,5,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *WorkloadIdentityPool) Reset() {
	*x = WorkloadIdentityPool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityPool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityPool) ProtoMessage() {}

func (x *WorkloadIdentityPool) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityPool.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityPool) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{0}
}

func (x *WorkloadIdentityPool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkloadIdentityPool) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *WorkloadIdentityPool) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *WorkloadIdentityPool) GetState() WorkloadIdentityPool_State {
	if x != nil {
		return x.State
	}
	return WorkloadIdentityPool_STATE_UNSPECIFIED
}

func (x *WorkloadIdentityPool) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// A configuration for an external identity provider.
type WorkloadIdentityPoolProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the provider.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A display name for the provider. Cannot exceed 32 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description for the provider. Cannot exceed 256 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The state of the provider.
	State WorkloadIdentityPoolProvider_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.iam.v1beta.WorkloadIdentityPoolProvider_State" json:"state,omitempty"`
	// Whether the provider is disabled. You cannot use a disabled provider to
	// exchange tokens. However, existing tokens still grant access.
	Disabled bool `protobuf:"varint,5,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Maps attributes from authentication credentials issued by an external
	// identity provider to Google Cloud attributes, such as `subject` and
	// `segment`.
	//
	// Each key must be a string specifying the Google Cloud IAM attribute to
	// map to.
	//
	// The following keys are supported:
	//
	// * `google.subject`: The principal IAM is authenticating. You can reference
	//                     this value in IAM bindings. This is also the
	//                     subject that appears in Cloud Logging logs.
	//                     Cannot exceed 127 characters.
	//
	// * `google.groups`: Groups the external identity belongs to. You can grant
	//                    groups access to resources using an IAM `principalSet`
	//                    binding; access applies to all members of the group.
	//
	// You can also provide custom attributes by specifying
	// `attribute.{custom_attribute}`, where `{custom_attribute}` is the name of
	// the custom attribute to be mapped. You can define a maximum of 50 custom
	// attributes. The maximum length of a mapped attribute key is
	// 100 characters, and the key may only contain the characters [a-z0-9_].
	//
	// You can reference these attributes in IAM policies to define fine-grained
	// access for a workload to Google Cloud resources. For example:
	//
	// * `google.subject`:
	// `principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}`
	//
	// * `google.groups`:
	// `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}`
	//
	// * `attribute.{custom_attribute}`:
	// `principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}`
	//
	// Each value must be a [Common Expression Language]
	// (https://opensource.google/projects/cel) function that maps an
	// identity provider credential to the normalized attribute specified by the
	// corresponding map key.
	//
	// You can use the `assertion` keyword in the expression to access a JSON
	// representation of the authentication credential issued by the provider.
	//
	// The maximum length of an attribute mapping expression is 2048 characters.
	// When evaluated, the total size of all mapped attributes must not exceed
	// 8KB.
	//
	// For AWS providers, the following rules apply:
	//
	// - If no attribute mapping is defined, the following default mapping
	//   applies:
	//
	//   ```
	//   {
	//     "google.subject":"assertion.arn",
	//     "attribute.aws_role":
	//         "assertion.arn.contains('assumed-role')"
	//         " ? assertion.arn.extract('{account_arn}assumed-role/')"
	//         "   + 'assumed-role/'"
	//         "   + assertion.arn.extract('assumed-role/{role_name}/')"
	//         " : assertion.arn",
	//   }
	//   ```
	//
	// - If any custom attribute mappings are defined, they must include a mapping
	//   to the `google.subject` attribute.
	//
	//
	// For OIDC providers, the following rules apply:
	//
	// - Custom attribute mappings must be defined, and must include a mapping to
	//   the `google.subject` attribute. For example, the following maps the
	//   `sub` claim of the incoming credential to the `subject` attribute on
	//   a Google token.
	//
	//   ```
	//   {"google.subject": "assertion.sub"}
	//   ```
	AttributeMapping map[string]string `protobuf:"bytes,6,rep,name=attribute_mapping,json=attributeMapping,proto3" json:"attribute_mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [A Common Expression Language](https://opensource.google/projects/cel)
	// expression, in plain text, to restrict what otherwise valid authentication
	// credentials issued by the provider should not be accepted.
	//
	// The expression must output a boolean representing whether to allow the
	// federation.
	//
	// The following keywords may be referenced in the expressions:
	//
	// * `assertion`: JSON representing the authentication credential issued by
	//                the provider.
	// * `google`: The Google attributes mapped from the assertion in the
	//             `attribute_mappings`.
	// * `attribute`: The custom attributes mapped from the assertion in the
	//                `attribute_mappings`.
	//
	// The maximum length of the attribute condition expression is 4096
	// characters. If unspecified, all valid authentication credential are
	// accepted.
	//
	// The following example shows how to only allow credentials with a mapped
	// `google.groups` value of `admins`:
	//
	// ```
	// "'admins' in google.groups"
	// ```
	AttributeCondition string `protobuf:"bytes,7,opt,name=attribute_condition,json=attributeCondition,proto3" json:"attribute_condition,omitempty"`
	// Identity provider configuration types.
	//
	// Types that are assignable to ProviderConfig:
	//	*WorkloadIdentityPoolProvider_Aws_
	//	*WorkloadIdentityPoolProvider_Oidc_
	ProviderConfig isWorkloadIdentityPoolProvider_ProviderConfig `protobuf_oneof:"provider_config"`
}

func (x *WorkloadIdentityPoolProvider) Reset() {
	*x = WorkloadIdentityPoolProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityPoolProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityPoolProvider) ProtoMessage() {}

func (x *WorkloadIdentityPoolProvider) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityPoolProvider.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityPoolProvider) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{1}
}

func (x *WorkloadIdentityPoolProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkloadIdentityPoolProvider) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *WorkloadIdentityPoolProvider) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *WorkloadIdentityPoolProvider) GetState() WorkloadIdentityPoolProvider_State {
	if x != nil {
		return x.State
	}
	return WorkloadIdentityPoolProvider_STATE_UNSPECIFIED
}

func (x *WorkloadIdentityPoolProvider) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *WorkloadIdentityPoolProvider) GetAttributeMapping() map[string]string {
	if x != nil {
		return x.AttributeMapping
	}
	return nil
}

func (x *WorkloadIdentityPoolProvider) GetAttributeCondition() string {
	if x != nil {
		return x.AttributeCondition
	}
	return ""
}

func (m *WorkloadIdentityPoolProvider) GetProviderConfig() isWorkloadIdentityPoolProvider_ProviderConfig {
	if m != nil {
		return m.ProviderConfig
	}
	return nil
}

func (x *WorkloadIdentityPoolProvider) GetAws() *WorkloadIdentityPoolProvider_Aws {
	if x, ok := x.GetProviderConfig().(*WorkloadIdentityPoolProvider_Aws_); ok {
		return x.Aws
	}
	return nil
}

func (x *WorkloadIdentityPoolProvider) GetOidc() *WorkloadIdentityPoolProvider_Oidc {
	if x, ok := x.GetProviderConfig().(*WorkloadIdentityPoolProvider_Oidc_); ok {
		return x.Oidc
	}
	return nil
}

type isWorkloadIdentityPoolProvider_ProviderConfig interface {
	isWorkloadIdentityPoolProvider_ProviderConfig()
}

type WorkloadIdentityPoolProvider_Aws_ struct {
	// An Amazon Web Services identity provider.
	Aws *WorkloadIdentityPoolProvider_Aws `protobuf:"bytes,8,opt,name=aws,proto3,oneof"`
}

type WorkloadIdentityPoolProvider_Oidc_ struct {
	// An OpenId Connect 1.0 identity provider.
	Oidc *WorkloadIdentityPoolProvider_Oidc `protobuf:"bytes,9,opt,name=oidc,proto3,oneof"`
}

func (*WorkloadIdentityPoolProvider_Aws_) isWorkloadIdentityPoolProvider_ProviderConfig() {}

func (*WorkloadIdentityPoolProvider_Oidc_) isWorkloadIdentityPoolProvider_ProviderConfig() {}

// Request message for ListWorkloadIdentityPools.
type ListWorkloadIdentityPoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to list pools for.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of pools to return.
	// If unspecified, at most 50 pools are returned.
	// The maximum value is 1000; values above are 1000 truncated to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListWorkloadIdentityPools`
	// call. Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to return soft-deleted pools.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListWorkloadIdentityPoolsRequest) Reset() {
	*x = ListWorkloadIdentityPoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadIdentityPoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadIdentityPoolsRequest) ProtoMessage() {}

func (x *ListWorkloadIdentityPoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadIdentityPoolsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkloadIdentityPoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{2}
}

func (x *ListWorkloadIdentityPoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkloadIdentityPoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkloadIdentityPoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListWorkloadIdentityPoolsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for ListWorkloadIdentityPools.
type ListWorkloadIdentityPoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of pools.
	WorkloadIdentityPools []*WorkloadIdentityPool `protobuf:"bytes,1,rep,name=workload_identity_pools,json=workloadIdentityPools,proto3" json:"workload_identity_pools,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWorkloadIdentityPoolsResponse) Reset() {
	*x = ListWorkloadIdentityPoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadIdentityPoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadIdentityPoolsResponse) ProtoMessage() {}

func (x *ListWorkloadIdentityPoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadIdentityPoolsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkloadIdentityPoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{3}
}

func (x *ListWorkloadIdentityPoolsResponse) GetWorkloadIdentityPools() []*WorkloadIdentityPool {
	if x != nil {
		return x.WorkloadIdentityPools
	}
	return nil
}

func (x *ListWorkloadIdentityPoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetWorkloadIdentityPool.
type GetWorkloadIdentityPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the pool to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkloadIdentityPoolRequest) Reset() {
	*x = GetWorkloadIdentityPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkloadIdentityPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkloadIdentityPoolRequest) ProtoMessage() {}

func (x *GetWorkloadIdentityPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkloadIdentityPoolRequest.ProtoReflect.Descriptor instead.
func (*GetWorkloadIdentityPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{4}
}

func (x *GetWorkloadIdentityPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateWorkloadIdentityPool.
type CreateWorkloadIdentityPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to create the pool in. The only supported
	// location is `global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The pool to create.
	WorkloadIdentityPool *WorkloadIdentityPool `protobuf:"bytes,2,opt,name=workload_identity_pool,json=workloadIdentityPool,proto3" json:"workload_identity_pool,omitempty"`
	// Required. The ID to use for the pool, which becomes the
	// final component of the resource name. This value should be 4-32 characters,
	// and may contain the characters [a-z0-9-]. The prefix `gcp-` is
	// reserved for use by Google, and may not be specified.
	WorkloadIdentityPoolId string `protobuf:"bytes,3,opt,name=workload_identity_pool_id,json=workloadIdentityPoolId,proto3" json:"workload_identity_pool_id,omitempty"`
}

func (x *CreateWorkloadIdentityPoolRequest) Reset() {
	*x = CreateWorkloadIdentityPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkloadIdentityPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkloadIdentityPoolRequest) ProtoMessage() {}

func (x *CreateWorkloadIdentityPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkloadIdentityPoolRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkloadIdentityPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{5}
}

func (x *CreateWorkloadIdentityPoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkloadIdentityPoolRequest) GetWorkloadIdentityPool() *WorkloadIdentityPool {
	if x != nil {
		return x.WorkloadIdentityPool
	}
	return nil
}

func (x *CreateWorkloadIdentityPoolRequest) GetWorkloadIdentityPoolId() string {
	if x != nil {
		return x.WorkloadIdentityPoolId
	}
	return ""
}

// Request message for UpdateWorkloadIdentityPool.
type UpdateWorkloadIdentityPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The pool to update. The `name` field is used to identify the pool.
	WorkloadIdentityPool *WorkloadIdentityPool `protobuf:"bytes,1,opt,name=workload_identity_pool,json=workloadIdentityPool,proto3" json:"workload_identity_pool,omitempty"`
	// Required. The list of fields update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateWorkloadIdentityPoolRequest) Reset() {
	*x = UpdateWorkloadIdentityPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkloadIdentityPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkloadIdentityPoolRequest) ProtoMessage() {}

func (x *UpdateWorkloadIdentityPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkloadIdentityPoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkloadIdentityPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateWorkloadIdentityPoolRequest) GetWorkloadIdentityPool() *WorkloadIdentityPool {
	if x != nil {
		return x.WorkloadIdentityPool
	}
	return nil
}

func (x *UpdateWorkloadIdentityPoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteWorkloadIdentityPool.
type DeleteWorkloadIdentityPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the pool to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWorkloadIdentityPoolRequest) Reset() {
	*x = DeleteWorkloadIdentityPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkloadIdentityPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkloadIdentityPoolRequest) ProtoMessage() {}

func (x *DeleteWorkloadIdentityPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkloadIdentityPoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkloadIdentityPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteWorkloadIdentityPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UndeleteWorkloadIdentityPool.
type UndeleteWorkloadIdentityPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the pool to undelete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeleteWorkloadIdentityPoolRequest) Reset() {
	*x = UndeleteWorkloadIdentityPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeleteWorkloadIdentityPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteWorkloadIdentityPoolRequest) ProtoMessage() {}

func (x *UndeleteWorkloadIdentityPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteWorkloadIdentityPoolRequest.ProtoReflect.Descriptor instead.
func (*UndeleteWorkloadIdentityPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{8}
}

func (x *UndeleteWorkloadIdentityPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListWorkloadIdentityPoolProviders.
type ListWorkloadIdentityPoolProvidersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The pool to list providers for.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of providers to return.
	// If unspecified, at most 50 providers are returned.
	// The maximum value is 100; values above 100 are truncated to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// `ListWorkloadIdentityPoolProviders` call. Provide this to retrieve the
	// subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to return soft-deleted providers.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListWorkloadIdentityPoolProvidersRequest) Reset() {
	*x = ListWorkloadIdentityPoolProvidersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadIdentityPoolProvidersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadIdentityPoolProvidersRequest) ProtoMessage() {}

func (x *ListWorkloadIdentityPoolProvidersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadIdentityPoolProvidersRequest.ProtoReflect.Descriptor instead.
func (*ListWorkloadIdentityPoolProvidersRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{9}
}

func (x *ListWorkloadIdentityPoolProvidersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkloadIdentityPoolProvidersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkloadIdentityPoolProvidersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListWorkloadIdentityPoolProvidersRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for ListWorkloadIdentityPoolProviders.
type ListWorkloadIdentityPoolProvidersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of providers.
	WorkloadIdentityPoolProviders []*WorkloadIdentityPoolProvider `protobuf:"bytes,1,rep,name=workload_identity_pool_providers,json=workloadIdentityPoolProviders,proto3" json:"workload_identity_pool_providers,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWorkloadIdentityPoolProvidersResponse) Reset() {
	*x = ListWorkloadIdentityPoolProvidersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadIdentityPoolProvidersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadIdentityPoolProvidersResponse) ProtoMessage() {}

func (x *ListWorkloadIdentityPoolProvidersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadIdentityPoolProvidersResponse.ProtoReflect.Descriptor instead.
func (*ListWorkloadIdentityPoolProvidersResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{10}
}

func (x *ListWorkloadIdentityPoolProvidersResponse) GetWorkloadIdentityPoolProviders() []*WorkloadIdentityPoolProvider {
	if x != nil {
		return x.WorkloadIdentityPoolProviders
	}
	return nil
}

func (x *ListWorkloadIdentityPoolProvidersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetWorkloadIdentityPoolProvider.
type GetWorkloadIdentityPoolProviderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the provider to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkloadIdentityPoolProviderRequest) Reset() {
	*x = GetWorkloadIdentityPoolProviderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkloadIdentityPoolProviderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkloadIdentityPoolProviderRequest) ProtoMessage() {}

func (x *GetWorkloadIdentityPoolProviderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkloadIdentityPoolProviderRequest.ProtoReflect.Descriptor instead.
func (*GetWorkloadIdentityPoolProviderRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{11}
}

func (x *GetWorkloadIdentityPoolProviderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateWorkloadIdentityPoolProvider.
type CreateWorkloadIdentityPoolProviderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The pool to create this provider in.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The provider to create.
	WorkloadIdentityPoolProvider *WorkloadIdentityPoolProvider `protobuf:"bytes,2,opt,name=workload_identity_pool_provider,json=workloadIdentityPoolProvider,proto3" json:"workload_identity_pool_provider,omitempty"`
	// Required. The ID for the provider, which becomes the
	// final component of the resource name. This value must be 4-32 characters,
	// and may contain the characters [a-z0-9-]. The prefix `gcp-` is
	// reserved for use by Google, and may not be specified.
	WorkloadIdentityPoolProviderId string `protobuf:"bytes,3,opt,name=workload_identity_pool_provider_id,json=workloadIdentityPoolProviderId,proto3" json:"workload_identity_pool_provider_id,omitempty"`
}

func (x *CreateWorkloadIdentityPoolProviderRequest) Reset() {
	*x = CreateWorkloadIdentityPoolProviderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkloadIdentityPoolProviderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkloadIdentityPoolProviderRequest) ProtoMessage() {}

func (x *CreateWorkloadIdentityPoolProviderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkloadIdentityPoolProviderRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkloadIdentityPoolProviderRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{12}
}

func (x *CreateWorkloadIdentityPoolProviderRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkloadIdentityPoolProviderRequest) GetWorkloadIdentityPoolProvider() *WorkloadIdentityPoolProvider {
	if x != nil {
		return x.WorkloadIdentityPoolProvider
	}
	return nil
}

func (x *CreateWorkloadIdentityPoolProviderRequest) GetWorkloadIdentityPoolProviderId() string {
	if x != nil {
		return x.WorkloadIdentityPoolProviderId
	}
	return ""
}

// Request message for UpdateWorkloadIdentityPoolProvider.
type UpdateWorkloadIdentityPoolProviderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The provider to update.
	WorkloadIdentityPoolProvider *WorkloadIdentityPoolProvider `protobuf:"bytes,1,opt,name=workload_identity_pool_provider,json=workloadIdentityPoolProvider,proto3" json:"workload_identity_pool_provider,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateWorkloadIdentityPoolProviderRequest) Reset() {
	*x = UpdateWorkloadIdentityPoolProviderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkloadIdentityPoolProviderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkloadIdentityPoolProviderRequest) ProtoMessage() {}

func (x *UpdateWorkloadIdentityPoolProviderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkloadIdentityPoolProviderRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkloadIdentityPoolProviderRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateWorkloadIdentityPoolProviderRequest) GetWorkloadIdentityPoolProvider() *WorkloadIdentityPoolProvider {
	if x != nil {
		return x.WorkloadIdentityPoolProvider
	}
	return nil
}

func (x *UpdateWorkloadIdentityPoolProviderRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteWorkloadIdentityPoolProvider.
type DeleteWorkloadIdentityPoolProviderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the provider to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWorkloadIdentityPoolProviderRequest) Reset() {
	*x = DeleteWorkloadIdentityPoolProviderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkloadIdentityPoolProviderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkloadIdentityPoolProviderRequest) ProtoMessage() {}

func (x *DeleteWorkloadIdentityPoolProviderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkloadIdentityPoolProviderRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkloadIdentityPoolProviderRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteWorkloadIdentityPoolProviderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UndeleteWorkloadIdentityPoolProvider.
type UndeleteWorkloadIdentityPoolProviderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the provider to undelete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeleteWorkloadIdentityPoolProviderRequest) Reset() {
	*x = UndeleteWorkloadIdentityPoolProviderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeleteWorkloadIdentityPoolProviderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteWorkloadIdentityPoolProviderRequest) ProtoMessage() {}

func (x *UndeleteWorkloadIdentityPoolProviderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteWorkloadIdentityPoolProviderRequest.ProtoReflect.Descriptor instead.
func (*UndeleteWorkloadIdentityPoolProviderRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{15}
}

func (x *UndeleteWorkloadIdentityPoolProviderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata for long-running WorkloadIdentityPool operations.
type WorkloadIdentityPoolOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WorkloadIdentityPoolOperationMetadata) Reset() {
	*x = WorkloadIdentityPoolOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityPoolOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityPoolOperationMetadata) ProtoMessage() {}

func (x *WorkloadIdentityPoolOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityPoolOperationMetadata.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityPoolOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{16}
}

// Metadata for long-running WorkloadIdentityPoolProvider operations.
type WorkloadIdentityPoolProviderOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WorkloadIdentityPoolProviderOperationMetadata) Reset() {
	*x = WorkloadIdentityPoolProviderOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityPoolProviderOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityPoolProviderOperationMetadata) ProtoMessage() {}

func (x *WorkloadIdentityPoolProviderOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityPoolProviderOperationMetadata.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityPoolProviderOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{17}
}

// Represents an Amazon Web Services identity provider.
type WorkloadIdentityPoolProvider_Aws struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The AWS account ID.
	AccountId string `protobuf:"bytes,1,opt,name=account_id,json=accountId,proto3" json:"account_id,omitempty"`
}

func (x *WorkloadIdentityPoolProvider_Aws) Reset() {
	*x = WorkloadIdentityPoolProvider_Aws{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityPoolProvider_Aws) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityPoolProvider_Aws) ProtoMessage() {}

func (x *WorkloadIdentityPoolProvider_Aws) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityPoolProvider_Aws.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityPoolProvider_Aws) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{1, 0}
}

func (x *WorkloadIdentityPoolProvider_Aws) GetAccountId() string {
	if x != nil {
		return x.AccountId
	}
	return ""
}

// Represents an OpenId Connect 1.0 identity provider.
type WorkloadIdentityPoolProvider_Oidc struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The OIDC issuer URL.
	IssuerUri string `protobuf:"bytes,1,opt,name=issuer_uri,json=issuerUri,proto3" json:"issuer_uri,omitempty"`
	// Acceptable values for the `aud` field (audience) in the OIDC token. Token
	// exchange requests are rejected if the token audience does not match one
	// of the configured values. Each audience may be at most 256 characters. A
	// maximum of 10 audiences may be configured.
	//
	// If this list is empty, the OIDC token audience must be equal to
	// the full canonical resource name of the WorkloadIdentityPoolProvider,
	// with or without the HTTPS prefix. For example:
	//
	// ```
	// //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
	// https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
	// ```
	AllowedAudiences []string `protobuf:"bytes,2,rep,name=allowed_audiences,json=allowedAudiences,proto3" json:"allowed_audiences,omitempty"`
}

func (x *WorkloadIdentityPoolProvider_Oidc) Reset() {
	*x = WorkloadIdentityPoolProvider_Oidc{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityPoolProvider_Oidc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityPoolProvider_Oidc) ProtoMessage() {}

func (x *WorkloadIdentityPoolProvider_Oidc) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityPoolProvider_Oidc.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityPoolProvider_Oidc) Descriptor() ([]byte, []int) {
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP(), []int{1, 1}
}

func (x *WorkloadIdentityPoolProvider_Oidc) GetIssuerUri() string {
	if x != nil {
		return x.IssuerUri
	}
	return ""
}

func (x *WorkloadIdentityPoolProvider_Oidc) GetAllowedAudiences() []string {
	if x != nil {
		return x.AllowedAudiences
	}
	return nil
}

var File_google_iam_v1beta_workload_identity_pool_proto protoreflect.FileDescriptor

var file_google_iam_v1beta_workload_identity_pool_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9b, 0x03,
	0x0a, 0x14, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x44, 0x10, 0x02, 0x3a, 0x85, 0x01, 0xea, 0x41, 0x81, 0x01, 0x0a, 0x27, 0x69, 0x61, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50,
	0x6f, 0x6f, 0x6c, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x22, 0xf6, 0x07, 0x0a, 0x1c,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x72, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x2f, 0x0a, 0x13,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a,
	0x03, 0x61, 0x77, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50,
	0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x41, 0x77, 0x73, 0x48,
	0x00, 0x52, 0x03, 0x61, 0x77, 0x73, 0x12, 0x4a, 0x0a, 0x04, 0x6f, 0x69, 0x64, 0x63, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x48, 0x00, 0x52, 0x04, 0x6f, 0x69,
	0x64, 0x63, 0x1a, 0x29, 0x0a, 0x03, 0x41, 0x77, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x1a, 0x57, 0x0a,
	0x04, 0x4f, 0x69, 0x64, 0x63, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x41, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x1a, 0x43, 0x0a, 0x15, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x3a, 0xba, 0x01, 0xea, 0x41, 0xb6, 0x01, 0x0a, 0x2f, 0x69, 0x61, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x82, 0x01, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x7d, 0x42, 0x11, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xce, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0xac, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x17, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x15, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x69, 0x61,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x94, 0x02, 0x0a, 0x21,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x62,
	0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x3e, 0x0a, 0x19, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c,
	0x49, 0x64, 0x22, 0xc9, 0x01, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x68,
	0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x69, 0x61, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x23, 0x55, 0x6e, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x28, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x69, 0x61, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68,
	0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0xcd, 0x01, 0x0a, 0x29, 0x4c, 0x69,
	0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x78, 0x0a, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x52, 0x1d, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x75, 0x0a, 0x26, 0x47, 0x65, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x69, 0x61, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xc2, 0x02, 0x0a, 0x29, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x7b, 0x0a, 0x1f, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x22, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0xea, 0x01, 0x0a, 0x29, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x7b, 0x0a, 0x1f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x1c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x78, 0x0a, 0x29, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x2b,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x27, 0x0a, 0x25, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x2f, 0x0a, 0x2d, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x32, 0xb4, 0x1c, 0x0a, 0x15, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xd6, 0x01, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc3, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x4c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcb, 0x02, 0x0a, 0x1a,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xd7, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x3a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xda,
	0x41, 0x37, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x3d, 0x0a, 0x14, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x25, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xcd, 0x02, 0x0a, 0x1a, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd9, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6e, 0x32, 0x54, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x16, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0xda, 0x41, 0x22, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x3d, 0x0a, 0x14, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x25, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x80, 0x02, 0x0a, 0x1a, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x3d, 0x0a,
	0x14, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x25, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x90, 0x02, 0x0a,
	0x1c, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x46, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca,
	0x41, 0x3d, 0x0a, 0x14, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x25, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xfa, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xe7, 0x01, 0x0a,
	0x1f, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0x58, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x92, 0x03, 0x0a, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8e, 0x02, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x6c, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x3a, 0x1f,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0xda,
	0x41, 0x49, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x4d, 0x0a, 0x1c,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x2d, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x95, 0x03, 0x0a, 0x22,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f,
	0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x91, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8c, 0x01, 0x32, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x1f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0xda, 0x41, 0x2b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0xca, 0x41, 0x4d, 0x0a, 0x1c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x12, 0x2d, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xac, 0x02, 0x0a, 0x22, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b,
	0x2a, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0xca, 0x41, 0x4d, 0x0a, 0x1c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x12, 0x2d, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xbc, 0x02, 0x0a, 0x24, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50,
	0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x57, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75,
	0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0xca, 0x41, 0x4d, 0x0a, 0x1c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x12, 0x2d, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6a, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x42, 0x19, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x3b, 0x69, 0x61, 0x6d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_iam_v1beta_workload_identity_pool_proto_rawDescOnce sync.Once
	file_google_iam_v1beta_workload_identity_pool_proto_rawDescData = file_google_iam_v1beta_workload_identity_pool_proto_rawDesc
)

func file_google_iam_v1beta_workload_identity_pool_proto_rawDescGZIP() []byte {
	file_google_iam_v1beta_workload_identity_pool_proto_rawDescOnce.Do(func() {
		file_google_iam_v1beta_workload_identity_pool_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_iam_v1beta_workload_identity_pool_proto_rawDescData)
	})
	return file_google_iam_v1beta_workload_identity_pool_proto_rawDescData
}

var file_google_iam_v1beta_workload_identity_pool_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_iam_v1beta_workload_identity_pool_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_iam_v1beta_workload_identity_pool_proto_goTypes = []interface{}{
	(WorkloadIdentityPool_State)(0),                       // 0: google.iam.v1beta.WorkloadIdentityPool.State
	(WorkloadIdentityPoolProvider_State)(0),               // 1: google.iam.v1beta.WorkloadIdentityPoolProvider.State
	(*WorkloadIdentityPool)(nil),                          // 2: google.iam.v1beta.WorkloadIdentityPool
	(*WorkloadIdentityPoolProvider)(nil),                  // 3: google.iam.v1beta.WorkloadIdentityPoolProvider
	(*ListWorkloadIdentityPoolsRequest)(nil),              // 4: google.iam.v1beta.ListWorkloadIdentityPoolsRequest
	(*ListWorkloadIdentityPoolsResponse)(nil),             // 5: google.iam.v1beta.ListWorkloadIdentityPoolsResponse
	(*GetWorkloadIdentityPoolRequest)(nil),                // 6: google.iam.v1beta.GetWorkloadIdentityPoolRequest
	(*CreateWorkloadIdentityPoolRequest)(nil),             // 7: google.iam.v1beta.CreateWorkloadIdentityPoolRequest
	(*UpdateWorkloadIdentityPoolRequest)(nil),             // 8: google.iam.v1beta.UpdateWorkloadIdentityPoolRequest
	(*DeleteWorkloadIdentityPoolRequest)(nil),             // 9: google.iam.v1beta.DeleteWorkloadIdentityPoolRequest
	(*UndeleteWorkloadIdentityPoolRequest)(nil),           // 10: google.iam.v1beta.UndeleteWorkloadIdentityPoolRequest
	(*ListWorkloadIdentityPoolProvidersRequest)(nil),      // 11: google.iam.v1beta.ListWorkloadIdentityPoolProvidersRequest
	(*ListWorkloadIdentityPoolProvidersResponse)(nil),     // 12: google.iam.v1beta.ListWorkloadIdentityPoolProvidersResponse
	(*GetWorkloadIdentityPoolProviderRequest)(nil),        // 13: google.iam.v1beta.GetWorkloadIdentityPoolProviderRequest
	(*CreateWorkloadIdentityPoolProviderRequest)(nil),     // 14: google.iam.v1beta.CreateWorkloadIdentityPoolProviderRequest
	(*UpdateWorkloadIdentityPoolProviderRequest)(nil),     // 15: google.iam.v1beta.UpdateWorkloadIdentityPoolProviderRequest
	(*DeleteWorkloadIdentityPoolProviderRequest)(nil),     // 16: google.iam.v1beta.DeleteWorkloadIdentityPoolProviderRequest
	(*UndeleteWorkloadIdentityPoolProviderRequest)(nil),   // 17: google.iam.v1beta.UndeleteWorkloadIdentityPoolProviderRequest
	(*WorkloadIdentityPoolOperationMetadata)(nil),         // 18: google.iam.v1beta.WorkloadIdentityPoolOperationMetadata
	(*WorkloadIdentityPoolProviderOperationMetadata)(nil), // 19: google.iam.v1beta.WorkloadIdentityPoolProviderOperationMetadata
	(*WorkloadIdentityPoolProvider_Aws)(nil),              // 20: google.iam.v1beta.WorkloadIdentityPoolProvider.Aws
	(*WorkloadIdentityPoolProvider_Oidc)(nil),             // 21: google.iam.v1beta.WorkloadIdentityPoolProvider.Oidc
	nil,                           // 22: google.iam.v1beta.WorkloadIdentityPoolProvider.AttributeMappingEntry
	(*fieldmaskpb.FieldMask)(nil), // 23: google.protobuf.FieldMask
	(*longrunning.Operation)(nil), // 24: google.longrunning.Operation
}
var file_google_iam_v1beta_workload_identity_pool_proto_depIdxs = []int32{
	0,  // 0: google.iam.v1beta.WorkloadIdentityPool.state:type_name -> google.iam.v1beta.WorkloadIdentityPool.State
	1,  // 1: google.iam.v1beta.WorkloadIdentityPoolProvider.state:type_name -> google.iam.v1beta.WorkloadIdentityPoolProvider.State
	22, // 2: google.iam.v1beta.WorkloadIdentityPoolProvider.attribute_mapping:type_name -> google.iam.v1beta.WorkloadIdentityPoolProvider.AttributeMappingEntry
	20, // 3: google.iam.v1beta.WorkloadIdentityPoolProvider.aws:type_name -> google.iam.v1beta.WorkloadIdentityPoolProvider.Aws
	21, // 4: google.iam.v1beta.WorkloadIdentityPoolProvider.oidc:type_name -> google.iam.v1beta.WorkloadIdentityPoolProvider.Oidc
	2,  // 5: google.iam.v1beta.ListWorkloadIdentityPoolsResponse.workload_identity_pools:type_name -> google.iam.v1beta.WorkloadIdentityPool
	2,  // 6: google.iam.v1beta.CreateWorkloadIdentityPoolRequest.workload_identity_pool:type_name -> google.iam.v1beta.WorkloadIdentityPool
	2,  // 7: google.iam.v1beta.UpdateWorkloadIdentityPoolRequest.workload_identity_pool:type_name -> google.iam.v1beta.WorkloadIdentityPool
	23, // 8: google.iam.v1beta.UpdateWorkloadIdentityPoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 9: google.iam.v1beta.ListWorkloadIdentityPoolProvidersResponse.workload_identity_pool_providers:type_name -> google.iam.v1beta.WorkloadIdentityPoolProvider
	3,  // 10: google.iam.v1beta.CreateWorkloadIdentityPoolProviderRequest.workload_identity_pool_provider:type_name -> google.iam.v1beta.WorkloadIdentityPoolProvider
	3,  // 11: google.iam.v1beta.UpdateWorkloadIdentityPoolProviderRequest.workload_identity_pool_provider:type_name -> google.iam.v1beta.WorkloadIdentityPoolProvider
	23, // 12: google.iam.v1beta.UpdateWorkloadIdentityPoolProviderRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 13: google.iam.v1beta.WorkloadIdentityPools.ListWorkloadIdentityPools:input_type -> google.iam.v1beta.ListWorkloadIdentityPoolsRequest
	6,  // 14: google.iam.v1beta.WorkloadIdentityPools.GetWorkloadIdentityPool:input_type -> google.iam.v1beta.GetWorkloadIdentityPoolRequest
	7,  // 15: google.iam.v1beta.WorkloadIdentityPools.CreateWorkloadIdentityPool:input_type -> google.iam.v1beta.CreateWorkloadIdentityPoolRequest
	8,  // 16: google.iam.v1beta.WorkloadIdentityPools.UpdateWorkloadIdentityPool:input_type -> google.iam.v1beta.UpdateWorkloadIdentityPoolRequest
	9,  // 17: google.iam.v1beta.WorkloadIdentityPools.DeleteWorkloadIdentityPool:input_type -> google.iam.v1beta.DeleteWorkloadIdentityPoolRequest
	10, // 18: google.iam.v1beta.WorkloadIdentityPools.UndeleteWorkloadIdentityPool:input_type -> google.iam.v1beta.UndeleteWorkloadIdentityPoolRequest
	11, // 19: google.iam.v1beta.WorkloadIdentityPools.ListWorkloadIdentityPoolProviders:input_type -> google.iam.v1beta.ListWorkloadIdentityPoolProvidersRequest
	13, // 20: google.iam.v1beta.WorkloadIdentityPools.GetWorkloadIdentityPoolProvider:input_type -> google.iam.v1beta.GetWorkloadIdentityPoolProviderRequest
	14, // 21: google.iam.v1beta.WorkloadIdentityPools.CreateWorkloadIdentityPoolProvider:input_type -> google.iam.v1beta.CreateWorkloadIdentityPoolProviderRequest
	15, // 22: google.iam.v1beta.WorkloadIdentityPools.UpdateWorkloadIdentityPoolProvider:input_type -> google.iam.v1beta.UpdateWorkloadIdentityPoolProviderRequest
	16, // 23: google.iam.v1beta.WorkloadIdentityPools.DeleteWorkloadIdentityPoolProvider:input_type -> google.iam.v1beta.DeleteWorkloadIdentityPoolProviderRequest
	17, // 24: google.iam.v1beta.WorkloadIdentityPools.UndeleteWorkloadIdentityPoolProvider:input_type -> google.iam.v1beta.UndeleteWorkloadIdentityPoolProviderRequest
	5,  // 25: google.iam.v1beta.WorkloadIdentityPools.ListWorkloadIdentityPools:output_type -> google.iam.v1beta.ListWorkloadIdentityPoolsResponse
	2,  // 26: google.iam.v1beta.WorkloadIdentityPools.GetWorkloadIdentityPool:output_type -> google.iam.v1beta.WorkloadIdentityPool
	24, // 27: google.iam.v1beta.WorkloadIdentityPools.CreateWorkloadIdentityPool:output_type -> google.longrunning.Operation
	24, // 28: google.iam.v1beta.WorkloadIdentityPools.UpdateWorkloadIdentityPool:output_type -> google.longrunning.Operation
	24, // 29: google.iam.v1beta.WorkloadIdentityPools.DeleteWorkloadIdentityPool:output_type -> google.longrunning.Operation
	24, // 30: google.iam.v1beta.WorkloadIdentityPools.UndeleteWorkloadIdentityPool:output_type -> google.longrunning.Operation
	12, // 31: google.iam.v1beta.WorkloadIdentityPools.ListWorkloadIdentityPoolProviders:output_type -> google.iam.v1beta.ListWorkloadIdentityPoolProvidersResponse
	3,  // 32: google.iam.v1beta.WorkloadIdentityPools.GetWorkloadIdentityPoolProvider:output_type -> google.iam.v1beta.WorkloadIdentityPoolProvider
	24, // 33: google.iam.v1beta.WorkloadIdentityPools.CreateWorkloadIdentityPoolProvider:output_type -> google.longrunning.Operation
	24, // 34: google.iam.v1beta.WorkloadIdentityPools.UpdateWorkloadIdentityPoolProvider:output_type -> google.longrunning.Operation
	24, // 35: google.iam.v1beta.WorkloadIdentityPools.DeleteWorkloadIdentityPoolProvider:output_type -> google.longrunning.Operation
	24, // 36: google.iam.v1beta.WorkloadIdentityPools.UndeleteWorkloadIdentityPoolProvider:output_type -> google.longrunning.Operation
	25, // [25:37] is the sub-list for method output_type
	13, // [13:25] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_iam_v1beta_workload_identity_pool_proto_init() }
func file_google_iam_v1beta_workload_identity_pool_proto_init() {
	if File_google_iam_v1beta_workload_identity_pool_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityPool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityPoolProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadIdentityPoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadIdentityPoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkloadIdentityPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkloadIdentityPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkloadIdentityPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkloadIdentityPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeleteWorkloadIdentityPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadIdentityPoolProvidersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadIdentityPoolProvidersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkloadIdentityPoolProviderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkloadIdentityPoolProviderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkloadIdentityPoolProviderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkloadIdentityPoolProviderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeleteWorkloadIdentityPoolProviderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityPoolOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityPoolProviderOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityPoolProvider_Aws); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityPoolProvider_Oidc); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_iam_v1beta_workload_identity_pool_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*WorkloadIdentityPoolProvider_Aws_)(nil),
		(*WorkloadIdentityPoolProvider_Oidc_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_iam_v1beta_workload_identity_pool_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_iam_v1beta_workload_identity_pool_proto_goTypes,
		DependencyIndexes: file_google_iam_v1beta_workload_identity_pool_proto_depIdxs,
		EnumInfos:         file_google_iam_v1beta_workload_identity_pool_proto_enumTypes,
		MessageInfos:      file_google_iam_v1beta_workload_identity_pool_proto_msgTypes,
	}.Build()
	File_google_iam_v1beta_workload_identity_pool_proto = out.File
	file_google_iam_v1beta_workload_identity_pool_proto_rawDesc = nil
	file_google_iam_v1beta_workload_identity_pool_proto_goTypes = nil
	file_google_iam_v1beta_workload_identity_pool_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// WorkloadIdentityPoolsClient is the client API for WorkloadIdentityPools service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WorkloadIdentityPoolsClient interface {
	// Lists all non-deleted
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool]s in a
	// project. If `show_deleted` is set to `true`, then deleted pools are also
	// listed.
	ListWorkloadIdentityPools(ctx context.Context, in *ListWorkloadIdentityPoolsRequest, opts ...grpc.CallOption) (*ListWorkloadIdentityPoolsResponse, error)
	// Gets an individual
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	GetWorkloadIdentityPool(ctx context.Context, in *GetWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*WorkloadIdentityPool, error)
	// Creates a new
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	//
	// You cannot reuse the name of a deleted pool until 30 days after deletion.
	CreateWorkloadIdentityPool(ctx context.Context, in *CreateWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an existing
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	UpdateWorkloadIdentityPool(ctx context.Context, in *UpdateWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	//
	// You cannot use a deleted pool to exchange external
	// credentials for Google Cloud credentials. However, deletion does
	// not revoke credentials that have already been issued.
	// Credentials issued for a deleted pool do not grant access to resources.
	// If the pool is undeleted, and the credentials are not expired, they
	// grant access again.
	// You can undelete a pool for 30 days. After 30 days, deletion is
	// permanent.
	// You cannot update deleted pools. However, you can view and list them.
	DeleteWorkloadIdentityPool(ctx context.Context, in *DeleteWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeletes a [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool],
	// as long as it was deleted fewer than 30 days ago.
	UndeleteWorkloadIdentityPool(ctx context.Context, in *UndeleteWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists all non-deleted
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityPoolProvider]s
	// in a [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	// If `show_deleted` is set to `true`, then deleted providers are also listed.
	ListWorkloadIdentityPoolProviders(ctx context.Context, in *ListWorkloadIdentityPoolProvidersRequest, opts ...grpc.CallOption) (*ListWorkloadIdentityPoolProvidersResponse, error)
	// Gets an individual
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityPoolProvider].
	GetWorkloadIdentityPoolProvider(ctx context.Context, in *GetWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*WorkloadIdentityPoolProvider, error)
	// Creates a new
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider]
	// in a [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	//
	// You cannot reuse the name of a deleted provider until 30 days after
	// deletion.
	CreateWorkloadIdentityPoolProvider(ctx context.Context, in *CreateWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an existing
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider].
	UpdateWorkloadIdentityPoolProvider(ctx context.Context, in *UpdateWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider].
	// Deleting a provider does not revoke credentials that have already been
	// issued; they continue to grant access.
	// You can undelete a provider for 30 days. After 30 days, deletion is
	// permanent.
	// You cannot update deleted providers. However, you can view and list them.
	DeleteWorkloadIdentityPoolProvider(ctx context.Context, in *DeleteWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeletes a
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider],
	// as long as it was deleted fewer than 30 days ago.
	UndeleteWorkloadIdentityPoolProvider(ctx context.Context, in *UndeleteWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type workloadIdentityPoolsClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkloadIdentityPoolsClient(cc grpc.ClientConnInterface) WorkloadIdentityPoolsClient {
	return &workloadIdentityPoolsClient{cc}
}

func (c *workloadIdentityPoolsClient) ListWorkloadIdentityPools(ctx context.Context, in *ListWorkloadIdentityPoolsRequest, opts ...grpc.CallOption) (*ListWorkloadIdentityPoolsResponse, error) {
	out := new(ListWorkloadIdentityPoolsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/ListWorkloadIdentityPools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) GetWorkloadIdentityPool(ctx context.Context, in *GetWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*WorkloadIdentityPool, error) {
	out := new(WorkloadIdentityPool)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/GetWorkloadIdentityPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) CreateWorkloadIdentityPool(ctx context.Context, in *CreateWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/CreateWorkloadIdentityPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) UpdateWorkloadIdentityPool(ctx context.Context, in *UpdateWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/UpdateWorkloadIdentityPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) DeleteWorkloadIdentityPool(ctx context.Context, in *DeleteWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/DeleteWorkloadIdentityPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) UndeleteWorkloadIdentityPool(ctx context.Context, in *UndeleteWorkloadIdentityPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/UndeleteWorkloadIdentityPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) ListWorkloadIdentityPoolProviders(ctx context.Context, in *ListWorkloadIdentityPoolProvidersRequest, opts ...grpc.CallOption) (*ListWorkloadIdentityPoolProvidersResponse, error) {
	out := new(ListWorkloadIdentityPoolProvidersResponse)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/ListWorkloadIdentityPoolProviders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) GetWorkloadIdentityPoolProvider(ctx context.Context, in *GetWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*WorkloadIdentityPoolProvider, error) {
	out := new(WorkloadIdentityPoolProvider)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/GetWorkloadIdentityPoolProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) CreateWorkloadIdentityPoolProvider(ctx context.Context, in *CreateWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/CreateWorkloadIdentityPoolProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) UpdateWorkloadIdentityPoolProvider(ctx context.Context, in *UpdateWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/UpdateWorkloadIdentityPoolProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) DeleteWorkloadIdentityPoolProvider(ctx context.Context, in *DeleteWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/DeleteWorkloadIdentityPoolProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workloadIdentityPoolsClient) UndeleteWorkloadIdentityPoolProvider(ctx context.Context, in *UndeleteWorkloadIdentityPoolProviderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v1beta.WorkloadIdentityPools/UndeleteWorkloadIdentityPoolProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkloadIdentityPoolsServer is the server API for WorkloadIdentityPools service.
type WorkloadIdentityPoolsServer interface {
	// Lists all non-deleted
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool]s in a
	// project. If `show_deleted` is set to `true`, then deleted pools are also
	// listed.
	ListWorkloadIdentityPools(context.Context, *ListWorkloadIdentityPoolsRequest) (*ListWorkloadIdentityPoolsResponse, error)
	// Gets an individual
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	GetWorkloadIdentityPool(context.Context, *GetWorkloadIdentityPoolRequest) (*WorkloadIdentityPool, error)
	// Creates a new
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	//
	// You cannot reuse the name of a deleted pool until 30 days after deletion.
	CreateWorkloadIdentityPool(context.Context, *CreateWorkloadIdentityPoolRequest) (*longrunning.Operation, error)
	// Updates an existing
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	UpdateWorkloadIdentityPool(context.Context, *UpdateWorkloadIdentityPoolRequest) (*longrunning.Operation, error)
	// Deletes a
	// [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	//
	// You cannot use a deleted pool to exchange external
	// credentials for Google Cloud credentials. However, deletion does
	// not revoke credentials that have already been issued.
	// Credentials issued for a deleted pool do not grant access to resources.
	// If the pool is undeleted, and the credentials are not expired, they
	// grant access again.
	// You can undelete a pool for 30 days. After 30 days, deletion is
	// permanent.
	// You cannot update deleted pools. However, you can view and list them.
	DeleteWorkloadIdentityPool(context.Context, *DeleteWorkloadIdentityPoolRequest) (*longrunning.Operation, error)
	// Undeletes a [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool],
	// as long as it was deleted fewer than 30 days ago.
	UndeleteWorkloadIdentityPool(context.Context, *UndeleteWorkloadIdentityPoolRequest) (*longrunning.Operation, error)
	// Lists all non-deleted
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityPoolProvider]s
	// in a [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	// If `show_deleted` is set to `true`, then deleted providers are also listed.
	ListWorkloadIdentityPoolProviders(context.Context, *ListWorkloadIdentityPoolProvidersRequest) (*ListWorkloadIdentityPoolProvidersResponse, error)
	// Gets an individual
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityPoolProvider].
	GetWorkloadIdentityPoolProvider(context.Context, *GetWorkloadIdentityPoolProviderRequest) (*WorkloadIdentityPoolProvider, error)
	// Creates a new
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider]
	// in a [WorkloadIdentityPool][google.iam.v1beta.WorkloadIdentityPool].
	//
	// You cannot reuse the name of a deleted provider until 30 days after
	// deletion.
	CreateWorkloadIdentityPoolProvider(context.Context, *CreateWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error)
	// Updates an existing
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider].
	UpdateWorkloadIdentityPoolProvider(context.Context, *UpdateWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error)
	// Deletes a
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider].
	// Deleting a provider does not revoke credentials that have already been
	// issued; they continue to grant access.
	// You can undelete a provider for 30 days. After 30 days, deletion is
	// permanent.
	// You cannot update deleted providers. However, you can view and list them.
	DeleteWorkloadIdentityPoolProvider(context.Context, *DeleteWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error)
	// Undeletes a
	// [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider],
	// as long as it was deleted fewer than 30 days ago.
	UndeleteWorkloadIdentityPoolProvider(context.Context, *UndeleteWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error)
}

// UnimplementedWorkloadIdentityPoolsServer can be embedded to have forward compatible implementations.
type UnimplementedWorkloadIdentityPoolsServer struct {
}

func (*UnimplementedWorkloadIdentityPoolsServer) ListWorkloadIdentityPools(context.Context, *ListWorkloadIdentityPoolsRequest) (*ListWorkloadIdentityPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkloadIdentityPools not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) GetWorkloadIdentityPool(context.Context, *GetWorkloadIdentityPoolRequest) (*WorkloadIdentityPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkloadIdentityPool not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) CreateWorkloadIdentityPool(context.Context, *CreateWorkloadIdentityPoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkloadIdentityPool not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) UpdateWorkloadIdentityPool(context.Context, *UpdateWorkloadIdentityPoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkloadIdentityPool not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) DeleteWorkloadIdentityPool(context.Context, *DeleteWorkloadIdentityPoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkloadIdentityPool not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) UndeleteWorkloadIdentityPool(context.Context, *UndeleteWorkloadIdentityPoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteWorkloadIdentityPool not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) ListWorkloadIdentityPoolProviders(context.Context, *ListWorkloadIdentityPoolProvidersRequest) (*ListWorkloadIdentityPoolProvidersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkloadIdentityPoolProviders not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) GetWorkloadIdentityPoolProvider(context.Context, *GetWorkloadIdentityPoolProviderRequest) (*WorkloadIdentityPoolProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkloadIdentityPoolProvider not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) CreateWorkloadIdentityPoolProvider(context.Context, *CreateWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkloadIdentityPoolProvider not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) UpdateWorkloadIdentityPoolProvider(context.Context, *UpdateWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkloadIdentityPoolProvider not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) DeleteWorkloadIdentityPoolProvider(context.Context, *DeleteWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkloadIdentityPoolProvider not implemented")
}
func (*UnimplementedWorkloadIdentityPoolsServer) UndeleteWorkloadIdentityPoolProvider(context.Context, *UndeleteWorkloadIdentityPoolProviderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteWorkloadIdentityPoolProvider not implemented")
}

func RegisterWorkloadIdentityPoolsServer(s *grpc.Server, srv WorkloadIdentityPoolsServer) {
	s.RegisterService(&_WorkloadIdentityPools_serviceDesc, srv)
}

func _WorkloadIdentityPools_ListWorkloadIdentityPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkloadIdentityPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).ListWorkloadIdentityPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/ListWorkloadIdentityPools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).ListWorkloadIdentityPools(ctx, req.(*ListWorkloadIdentityPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_GetWorkloadIdentityPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadIdentityPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).GetWorkloadIdentityPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/GetWorkloadIdentityPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).GetWorkloadIdentityPool(ctx, req.(*GetWorkloadIdentityPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_CreateWorkloadIdentityPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkloadIdentityPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).CreateWorkloadIdentityPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/CreateWorkloadIdentityPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).CreateWorkloadIdentityPool(ctx, req.(*CreateWorkloadIdentityPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_UpdateWorkloadIdentityPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkloadIdentityPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).UpdateWorkloadIdentityPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/UpdateWorkloadIdentityPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).UpdateWorkloadIdentityPool(ctx, req.(*UpdateWorkloadIdentityPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_DeleteWorkloadIdentityPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkloadIdentityPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).DeleteWorkloadIdentityPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/DeleteWorkloadIdentityPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).DeleteWorkloadIdentityPool(ctx, req.(*DeleteWorkloadIdentityPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_UndeleteWorkloadIdentityPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteWorkloadIdentityPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).UndeleteWorkloadIdentityPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/UndeleteWorkloadIdentityPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).UndeleteWorkloadIdentityPool(ctx, req.(*UndeleteWorkloadIdentityPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_ListWorkloadIdentityPoolProviders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkloadIdentityPoolProvidersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).ListWorkloadIdentityPoolProviders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/ListWorkloadIdentityPoolProviders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).ListWorkloadIdentityPoolProviders(ctx, req.(*ListWorkloadIdentityPoolProvidersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_GetWorkloadIdentityPoolProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadIdentityPoolProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).GetWorkloadIdentityPoolProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/GetWorkloadIdentityPoolProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).GetWorkloadIdentityPoolProvider(ctx, req.(*GetWorkloadIdentityPoolProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_CreateWorkloadIdentityPoolProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkloadIdentityPoolProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).CreateWorkloadIdentityPoolProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/CreateWorkloadIdentityPoolProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).CreateWorkloadIdentityPoolProvider(ctx, req.(*CreateWorkloadIdentityPoolProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_UpdateWorkloadIdentityPoolProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkloadIdentityPoolProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).UpdateWorkloadIdentityPoolProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/UpdateWorkloadIdentityPoolProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).UpdateWorkloadIdentityPoolProvider(ctx, req.(*UpdateWorkloadIdentityPoolProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_DeleteWorkloadIdentityPoolProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkloadIdentityPoolProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).DeleteWorkloadIdentityPoolProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/DeleteWorkloadIdentityPoolProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).DeleteWorkloadIdentityPoolProvider(ctx, req.(*DeleteWorkloadIdentityPoolProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkloadIdentityPools_UndeleteWorkloadIdentityPoolProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteWorkloadIdentityPoolProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkloadIdentityPoolsServer).UndeleteWorkloadIdentityPoolProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1beta.WorkloadIdentityPools/UndeleteWorkloadIdentityPoolProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkloadIdentityPoolsServer).UndeleteWorkloadIdentityPoolProvider(ctx, req.(*UndeleteWorkloadIdentityPoolProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WorkloadIdentityPools_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.v1beta.WorkloadIdentityPools",
	HandlerType: (*WorkloadIdentityPoolsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListWorkloadIdentityPools",
			Handler:    _WorkloadIdentityPools_ListWorkloadIdentityPools_Handler,
		},
		{
			MethodName: "GetWorkloadIdentityPool",
			Handler:    _WorkloadIdentityPools_GetWorkloadIdentityPool_Handler,
		},
		{
			MethodName: "CreateWorkloadIdentityPool",
			Handler:    _WorkloadIdentityPools_CreateWorkloadIdentityPool_Handler,
		},
		{
			MethodName: "UpdateWorkloadIdentityPool",
			Handler:    _WorkloadIdentityPools_UpdateWorkloadIdentityPool_Handler,
		},
		{
			MethodName: "DeleteWorkloadIdentityPool",
			Handler:    _WorkloadIdentityPools_DeleteWorkloadIdentityPool_Handler,
		},
		{
			MethodName: "UndeleteWorkloadIdentityPool",
			Handler:    _WorkloadIdentityPools_UndeleteWorkloadIdentityPool_Handler,
		},
		{
			MethodName: "ListWorkloadIdentityPoolProviders",
			Handler:    _WorkloadIdentityPools_ListWorkloadIdentityPoolProviders_Handler,
		},
		{
			MethodName: "GetWorkloadIdentityPoolProvider",
			Handler:    _WorkloadIdentityPools_GetWorkloadIdentityPoolProvider_Handler,
		},
		{
			MethodName: "CreateWorkloadIdentityPoolProvider",
			Handler:    _WorkloadIdentityPools_CreateWorkloadIdentityPoolProvider_Handler,
		},
		{
			MethodName: "UpdateWorkloadIdentityPoolProvider",
			Handler:    _WorkloadIdentityPools_UpdateWorkloadIdentityPoolProvider_Handler,
		},
		{
			MethodName: "DeleteWorkloadIdentityPoolProvider",
			Handler:    _WorkloadIdentityPools_DeleteWorkloadIdentityPoolProvider_Handler,
		},
		{
			MethodName: "UndeleteWorkloadIdentityPoolProvider",
			Handler:    _WorkloadIdentityPools_UndeleteWorkloadIdentityPoolProvider_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/v1beta/workload_identity_pool.proto",
}
