// Generated by gmmproc 2.46.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <goocanvasmm/item.h>
#include <goocanvasmm/private/item_p.h>


/* Copyright (C) 1998-2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <goocanvasutils.h>
#include <goocanvasenumtypes.h>
#include <goocanvasmm/canvas.h>

namespace Goocanvas
{

Bounds Item::get_bounds() const
{
  Goocanvas::Bounds result;
  goo_canvas_item_get_bounds(const_cast<GooCanvasItem*>(gobj()), result.gobj());
  return result;
}

void Item::raise()
{
  goo_canvas_item_raise(gobj(), 0); 
}

void Item::lower()
{
  goo_canvas_item_lower(gobj(), 0); 
}

void Item::add_child(const Glib::RefPtr<Item>& child)
{
  goo_canvas_item_add_child(gobj(), Glib::unwrap(child), -1); 
}

// We need to hand-code this vfunc to write the result back into the
// bounds variable. The C++ wrapper cannot ref the existing variable, but only
// make a copy.
void Item_Class::get_bounds_vfunc_callback(GooCanvasItem* item, GooCanvasBounds* bounds)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)item));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      // Call the virtual member method, which derived classes might override.
      Bounds cpp_bounds;
      obj->get_bounds_vfunc(cpp_bounds);
      *bounds = *cpp_bounds.gobj();
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(item), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->get_bounds)
      return (*base->get_bounds)(item, bounds);
  }
}

void Item::get_bounds_vfunc(Bounds& bounds) const
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->get_bounds)
    (*base->get_bounds)(const_cast<GooCanvasItem*>(gobj()), bounds.gobj());
}

// We need to hand-code this vfunc because of the semantics of the GList
// parameter and return value. In C, this function is supposed to prepend
// new entries to the given list and return the new list head. In C++, we
// cannot emulate this behaviour since it is not possible to prepend items to
// a std::vector<>. Thus, we always create a new vector to return, and
// free the one passed in.
GList* Item_Class::get_items_at_vfunc_callback(GooCanvasItem* self, gdouble x, gdouble y, cairo_t* cr, gboolean is_pointer_event, gboolean parent_is_visible, GList* found_items)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      // Call the virtual member method, which derived classes might override.
      Bounds cpp_bounds;
      
      const auto vec_found_items = 
        Glib::ListHandler<Glib::RefPtr<Item> >::list_to_vector(found_items, Glib::OWNERSHIP_NONE);
      std::vector<Glib::RefPtr<Item> > retval(obj->get_items_at_vfunc(x, y, Cairo::RefPtr<Cairo::Context>(new Cairo::Context(cr, false /* has_reference */)), is_pointer_event == TRUE, parent_is_visible == TRUE, vec_found_items));
      // retval will free the list on destruction, and we can't change the
      // ownership here, so we have to copy the list.
      return g_list_copy( Glib::ListHandler<Glib::RefPtr<Item> >::vector_to_list(retval).data() );
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->get_items_at)
      return (*base->get_items_at)(self, x, y, cr, is_pointer_event, parent_is_visible, found_items);
  }
  
  return 0;
}

std::vector<Glib::RefPtr<Item> > Item::get_items_at_vfunc(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool is_parent_visible, const std::vector<Glib::RefPtr<Item> >& found_items)
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  // We rely on found_items having ownership NONE here, otherwise we would have
  // to do an extra copy. Note that we cannot return a OWNERSHIP_NONE list
  // since overriders of the C++ vfunc might return a vector or list or
  // something which, when converting to ListHandle, has always shallow
  // ownership.
  if(base && base->get_items_at)
  {

    GList* cresult = (*base->get_items_at)(const_cast<GooCanvasItem*>(gobj()), x, y, context->cobj(), static_cast<int>(is_pointer_event), static_cast<int>(is_parent_visible), 
      Glib::ListHandler<Glib::RefPtr<Item> >::vector_to_list(found_items).data());

    return Glib::ListHandler<Glib::RefPtr<Item> >::list_to_vector(cresult, Glib::OWNERSHIP_SHALLOW);
  }
  
  return std::vector<Glib::RefPtr<Item> >();
}

std::vector< Glib::RefPtr<Item> > Item::get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible)
{
  return Glib::ListHandler<Glib::RefPtr<Item> >::list_to_vector(goo_canvas_item_get_items_at(gobj(), x, y, (context)->cobj(), static_cast<int>(is_pointer_event), static_cast<int>(parent_is_visible), 0), Glib::OWNERSHIP_SHALLOW);
}

std::vector< Glib::RefPtr<const Item> > Item::get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible) const
{
  return Glib::ListHandler<Glib::RefPtr<const Item> >::list_to_vector(goo_canvas_item_get_items_at(const_cast<GooCanvasItem*>(gobj()), x, y, (context)->cobj(), static_cast<int>(is_pointer_event), static_cast<int>(parent_is_visible), 0), Glib::OWNERSHIP_SHALLOW);
}

} //namespace Goocanvas


namespace
{


static gboolean Item_signal_enter_notify_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventCrossing* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_enter_notify_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventCrossing* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventCrossing* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_enter_notify_event_info =
{
  "enter_notify_event",
  (GCallback) &Item_signal_enter_notify_event_callback,
  (GCallback) &Item_signal_enter_notify_event_notify_callback
};


static gboolean Item_signal_leave_notify_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventCrossing* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_leave_notify_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventCrossing* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventCrossing* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_leave_notify_event_info =
{
  "leave_notify_event",
  (GCallback) &Item_signal_leave_notify_event_callback,
  (GCallback) &Item_signal_leave_notify_event_notify_callback
};


static gboolean Item_signal_motion_notify_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventMotion* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventMotion* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_motion_notify_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventMotion* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventMotion* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_motion_notify_event_info =
{
  "motion_notify_event",
  (GCallback) &Item_signal_motion_notify_event_callback,
  (GCallback) &Item_signal_motion_notify_event_notify_callback
};


static gboolean Item_signal_button_press_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventButton* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventButton* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_button_press_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventButton* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventButton* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_button_press_event_info =
{
  "button_press_event",
  (GCallback) &Item_signal_button_press_event_callback,
  (GCallback) &Item_signal_button_press_event_notify_callback
};


static gboolean Item_signal_button_release_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventButton* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventButton* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_button_release_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventButton* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventButton* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_button_release_event_info =
{
  "button_release_event",
  (GCallback) &Item_signal_button_release_event_callback,
  (GCallback) &Item_signal_button_release_event_notify_callback
};


static gboolean Item_signal_focus_in_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventFocus* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_focus_in_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventFocus* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventFocus* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_focus_in_event_info =
{
  "focus_in_event",
  (GCallback) &Item_signal_focus_in_event_callback,
  (GCallback) &Item_signal_focus_in_event_notify_callback
};


static gboolean Item_signal_focus_out_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventFocus* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_focus_out_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventFocus* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventFocus* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_focus_out_event_info =
{
  "focus_out_event",
  (GCallback) &Item_signal_focus_out_event_callback,
  (GCallback) &Item_signal_focus_out_event_notify_callback
};


static gboolean Item_signal_key_press_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventKey* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventKey* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_key_press_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventKey* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventKey* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_key_press_event_info =
{
  "key_press_event",
  (GCallback) &Item_signal_key_press_event_callback,
  (GCallback) &Item_signal_key_press_event_notify_callback
};


static gboolean Item_signal_key_release_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventKey* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventKey* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_key_release_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventKey* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventKey* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_key_release_event_info =
{
  "key_release_event",
  (GCallback) &Item_signal_key_release_event_callback,
  (GCallback) &Item_signal_key_release_event_notify_callback
};


static gboolean Item_signal_grab_broken_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventGrabBroken* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventGrabBroken* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_grab_broken_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventGrabBroken* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventGrabBroken* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_grab_broken_event_info =
{
  "grab_broken_event",
  (GCallback) &Item_signal_grab_broken_event_callback,
  (GCallback) &Item_signal_grab_broken_event_notify_callback
};


static void Item_signal_child_notify_callback(GooCanvasItem* self, GParamSpec* p0,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,GParamSpec* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Item_signal_child_notify_info =
{
  "child_notify",
  (GCallback) &Item_signal_child_notify_callback,
  (GCallback) &Item_signal_child_notify_callback
};


static void Item_signal_animation_finished_callback(GooCanvasItem* self, gboolean p0,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,bool > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Item_signal_animation_finished_info =
{
  "animation_finished",
  (GCallback) &Item_signal_animation_finished_callback,
  (GCallback) &Item_signal_animation_finished_callback
};


static gboolean Item_signal_scroll_event_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventScroll* p1,void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< bool,const Glib::RefPtr<Item>&,GdkEventScroll* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Item_signal_scroll_event_notify_callback(GooCanvasItem* self, GooCanvasItem* p0,GdkEventScroll* p1, void* data)
{
  using namespace Goocanvas;
  typedef sigc::slot< void,const Glib::RefPtr<Item>&,GdkEventScroll* > SlotType;

  auto obj = dynamic_cast<Item*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Item_signal_scroll_event_info =
{
  "scroll_event",
  (GCallback) &Item_signal_scroll_event_callback,
  (GCallback) &Item_signal_scroll_event_notify_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Goocanvas::Item> wrap(GooCanvasItem* object, bool take_copy)
{
  return Glib::RefPtr<Goocanvas::Item>( dynamic_cast<Goocanvas::Item*> (Glib::wrap_auto_interface<Goocanvas::Item> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Goocanvas
{


/* The *_Class implementation: */

const Glib::Interface_Class& Item_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &Item_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = goo_canvas_item_get_type();
  }

  return *this;
}

void Item_Class::iface_init_function(void* g_iface, void*)
{
  const auto klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != nullptr); 

  klass->get_n_children = &get_n_children_vfunc_callback;
  klass->get_child = &get_child_vfunc_callback;
  klass->request_update = &request_update_vfunc_callback;
  klass->get_canvas = &get_canvas_vfunc_callback;
  klass->set_canvas = &set_canvas_vfunc_callback;
  klass->add_child = &add_child_vfunc_callback;
  klass->move_child = &move_child_vfunc_callback;
  klass->remove_child = &remove_child_vfunc_callback;
  klass->get_child_property = &get_child_property_vfunc_callback;
  klass->set_child_property = &set_child_property_vfunc_callback;
  klass->get_transform_for_child = &get_transform_for_child_vfunc_callback;
  klass->get_parent = &get_parent_vfunc_callback;
  klass->set_parent = &set_parent_vfunc_callback;
  klass->get_bounds = &get_bounds_vfunc_callback;
  klass->get_items_at = &get_items_at_vfunc_callback;
    klass->update = &update_vfunc_callback;
  klass->paint = &paint_vfunc_callback;
  klass->get_requested_area = &get_requested_area_vfunc_callback;
  klass->allocate_area = &allocate_area_vfunc_callback;
  klass->get_transform = &get_transform_vfunc_callback;
  klass->set_transform = &set_transform_vfunc_callback;
  klass->get_style = &get_style_vfunc_callback;
  klass->set_style = &set_style_vfunc_callback;
  klass->is_visible = &is_visible_vfunc_callback;
  klass->get_requested_height = &get_requested_height_vfunc_callback;
  klass->get_is_static = &get_is_static_vfunc_callback;
  klass->set_is_static = &set_is_static_vfunc_callback;
  klass->get_model = &get_model_vfunc_callback;
  klass->set_model = &set_model_vfunc_callback;

  klass->enter_notify_event = &enter_notify_event_callback;
  klass->leave_notify_event = &leave_notify_event_callback;
  klass->motion_notify_event = &motion_notify_event_callback;
  klass->button_press_event = &button_press_event_callback;
  klass->button_release_event = &button_release_event_callback;
  klass->focus_in_event = &focus_in_event_callback;
  klass->focus_out_event = &focus_out_event_callback;
  klass->key_press_event = &key_press_event_callback;
  klass->key_release_event = &key_release_event_callback;
  klass->grab_broken_event = &grab_broken_event_callback;
  klass->child_notify = &child_notify_callback;
  klass->animation_finished = &animation_finished_callback;
  klass->scroll_event = &scroll_event_callback;
}

gint Item_Class::get_n_children_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return obj->get_n_children_vfunc();
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_n_children)
  {
    gint retval = (*base->get_n_children)(self);
    return retval;
  }

  typedef gint RType;
  return RType();
}
GooCanvasItem* Item_Class::get_child_vfunc_callback(GooCanvasItem* self, gint child_num)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((obj->get_child_vfunc(child_num
)) ? (obj->get_child_vfunc(child_num
))->gobj() : 0);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_child)
  {
    GooCanvasItem* retval = (*base->get_child)(self, child_num);
    return retval;
  }

  typedef GooCanvasItem* RType;
  return RType();
}
void Item_Class::request_update_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->request_update_vfunc();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->request_update)
  {
    (*base->request_update)(self);
  }

}
GooCanvas* Item_Class::get_canvas_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->get_canvas_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_canvas)
  {
    GooCanvas* retval = (*base->get_canvas)(self);
    return retval;
  }

  typedef GooCanvas* RType;
  return RType();
}
void Item_Class::set_canvas_vfunc_callback(GooCanvasItem* self, GooCanvas* canvas)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_canvas_vfunc(Glib::wrap(canvas)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_canvas)
  {
    (*base->set_canvas)(self, canvas);
  }

}
void Item_Class::add_child_vfunc_callback(GooCanvasItem* self, GooCanvasItem* item, gint position)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->add_child_vfunc(Glib::wrap(item, true)
, position
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->add_child)
  {
    (*base->add_child)(self, item, position);
  }

}
void Item_Class::move_child_vfunc_callback(GooCanvasItem* self, gint old_position, gint new_position)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->move_child_vfunc(old_position
, new_position
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->move_child)
  {
    (*base->move_child)(self, old_position, new_position);
  }

}
void Item_Class::remove_child_vfunc_callback(GooCanvasItem* self, gint position)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->remove_child_vfunc(position
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->remove_child)
  {
    (*base->remove_child)(self, position);
  }

}
void Item_Class::get_child_property_vfunc_callback(GooCanvasItem* self, GooCanvasItem* child, guint property_id, GValue* value, GParamSpec* pspec)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->get_child_property_vfunc(Glib::wrap(child, true)
, property_id, *reinterpret_cast<Glib::ValueBase*>(value)
, pspec);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_child_property)
  {
    (*base->get_child_property)(self, child, property_id, value, pspec);
  }

}
void Item_Class::set_child_property_vfunc_callback(GooCanvasItem* self, GooCanvasItem* child, guint property_id, const GValue* value, GParamSpec* pspec)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_child_property_vfunc(Glib::wrap(child, true)
, property_id, *reinterpret_cast<const Glib::ValueBase*>(value)
, pspec);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_child_property)
  {
    (*base->set_child_property)(self, child, property_id, value, pspec);
  }

}
gboolean Item_Class::get_transform_for_child_vfunc_callback(GooCanvasItem* self, GooCanvasItem* item, cairo_matrix_t* transform)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->get_transform_for_child_vfunc(Glib::wrap(item, true)
, ((Cairo::Matrix*)(transform))
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_transform_for_child)
  {
    gboolean retval = (*base->get_transform_for_child)(self, item, transform);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
GooCanvasItem* Item_Class::get_parent_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((obj->get_parent_vfunc()) ? (obj->get_parent_vfunc())->gobj() : 0);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_parent)
  {
    GooCanvasItem* retval = (*base->get_parent)(self);
    return retval;
  }

  typedef GooCanvasItem* RType;
  return RType();
}
void Item_Class::set_parent_vfunc_callback(GooCanvasItem* self, GooCanvasItem* parent)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_parent_vfunc(Glib::wrap(parent, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_parent)
  {
    (*base->set_parent)(self, parent);
  }

}
void Item_Class::update_vfunc_callback(GooCanvasItem* self, gboolean entire_tree, cairo_t* cr, GooCanvasBounds* bounds)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->update_vfunc(entire_tree
, Cairo::RefPtr<Cairo::Context>(new Cairo::Context(cr, false /* has_reference */))
, Glib::wrap(bounds)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->update)
  {
    (*base->update)(self, entire_tree, cr, bounds);
  }

}
void Item_Class::paint_vfunc_callback(GooCanvasItem* self, cairo_t* cr, const GooCanvasBounds* bounds, gdouble scale)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->paint_vfunc(Cairo::RefPtr<Cairo::Context>(new Cairo::Context(cr, false /* has_reference */))
, Glib::wrap(bounds)
, scale
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->paint)
  {
    (*base->paint)(self, cr, bounds, scale);
  }

}
gboolean Item_Class::get_requested_area_vfunc_callback(GooCanvasItem* self, cairo_t* cr, GooCanvasBounds* requested_area)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->get_requested_area_vfunc(Cairo::RefPtr<Cairo::Context>(new Cairo::Context(cr, false /* has_reference */))
, requested_area));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_requested_area)
  {
    gboolean retval = (*base->get_requested_area)(self, cr, requested_area);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
void Item_Class::allocate_area_vfunc_callback(GooCanvasItem* self, cairo_t* cr, const GooCanvasBounds* requested_area, const GooCanvasBounds* allocated_area, gdouble x_offset, gdouble y_offset)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->allocate_area_vfunc(Cairo::RefPtr<Cairo::Context>(new Cairo::Context(cr, false /* has_reference */))
, Glib::wrap(requested_area)
, Glib::wrap(allocated_area)
, x_offset
, y_offset
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->allocate_area)
  {
    (*base->allocate_area)(self, cr, requested_area, allocated_area, x_offset, y_offset);
  }

}
gboolean Item_Class::get_transform_vfunc_callback(GooCanvasItem* self, cairo_matrix_t* transform)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->get_transform_vfunc(((Cairo::Matrix*)(transform))
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_transform)
  {
    gboolean retval = (*base->get_transform)(self, transform);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
void Item_Class::set_transform_vfunc_callback(GooCanvasItem* self, const cairo_matrix_t* matrix)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_transform_vfunc(((const Cairo::Matrix*)(matrix))
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_transform)
  {
    (*base->set_transform)(self, matrix);
  }

}
GooCanvasStyle* Item_Class::get_style_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((obj->get_style_vfunc()) ? (obj->get_style_vfunc())->gobj() : 0);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_style)
  {
    GooCanvasStyle* retval = (*base->get_style)(self);
    return retval;
  }

  typedef GooCanvasStyle* RType;
  return RType();
}
void Item_Class::set_style_vfunc_callback(GooCanvasItem* self, GooCanvasStyle* style)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_style_vfunc(Glib::wrap(style, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_style)
  {
    (*base->set_style)(self, style);
  }

}
gboolean Item_Class::is_visible_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->is_visible_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->is_visible)
  {
    gboolean retval = (*base->is_visible)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
gdouble Item_Class::get_requested_height_vfunc_callback(GooCanvasItem* self, cairo_t* cr, gdouble width)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return obj->get_requested_height_vfunc(Cairo::RefPtr<Cairo::Context>(new Cairo::Context(cr, false /* has_reference */))
, width
);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_requested_height)
  {
    gdouble retval = (*base->get_requested_height)(self, cr, width);
    return retval;
  }

  typedef gdouble RType;
  return RType();
}
gboolean Item_Class::get_is_static_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->get_is_static_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_is_static)
  {
    gboolean retval = (*base->get_is_static)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
void Item_Class::set_is_static_vfunc_callback(GooCanvasItem* self, gboolean is_static)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_is_static_vfunc(is_static
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_is_static)
  {
    (*base->set_is_static)(self, is_static);
  }

}
GooCanvasItemModel* Item_Class::get_model_vfunc_callback(GooCanvasItem* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((obj->get_model_vfunc()) ? (obj->get_model_vfunc())->gobj() : 0);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_model)
  {
    GooCanvasItemModel* retval = (*base->get_model)(self);
    return retval;
  }

  typedef GooCanvasItemModel* RType;
  return RType();
}
void Item_Class::set_model_vfunc_callback(GooCanvasItem* self, GooCanvasItemModel* model)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_model_vfunc(Glib::wrap(model, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_model)
  {
    (*base->set_model)(self, model);
  }

}

gboolean Item_Class::enter_notify_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventCrossing* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_enter_notify_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->enter_notify_event)
    return (*base->enter_notify_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::leave_notify_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventCrossing* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_leave_notify_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->leave_notify_event)
    return (*base->leave_notify_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::motion_notify_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventMotion* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_motion_notify_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->motion_notify_event)
    return (*base->motion_notify_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::button_press_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventButton* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_press_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->button_press_event)
    return (*base->button_press_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::button_release_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventButton* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_release_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->button_release_event)
    return (*base->button_release_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::focus_in_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventFocus* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus_in_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->focus_in_event)
    return (*base->focus_in_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::focus_out_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventFocus* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus_out_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->focus_out_event)
    return (*base->focus_out_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::key_press_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventKey* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_press_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->key_press_event)
    return (*base->key_press_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::key_release_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventKey* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_release_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->key_release_event)
    return (*base->key_release_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean Item_Class::grab_broken_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventGrabBroken* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_grab_broken_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->grab_broken_event)
    return (*base->grab_broken_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
void Item_Class::child_notify_callback(GooCanvasItem* self, GParamSpec* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_child_notify(p0);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->child_notify)
    (*base->child_notify)(self, p0);
}
void Item_Class::animation_finished_callback(GooCanvasItem* self, gboolean p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_animation_finished(p0
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->animation_finished)
    (*base->animation_finished)(self, p0);
}
gboolean Item_Class::scroll_event_callback(GooCanvasItem* self, GooCanvasItem* p0, GdkEventScroll* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_scroll_event(Glib::wrap(p0, true)
, p1));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->scroll_event)
    return (*base->scroll_event)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* Item_Class::wrap_new(GObject* object)
{
  return new Item((GooCanvasItem*)(object));
}


/* The implementation: */

Item::Item()
:
  Glib::Interface(item_class_.init())
{}

Item::Item(GooCanvasItem* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

Item::Item(const Glib::Interface_Class& interface_class)
: Glib::Interface(interface_class)
{
}

Item::Item(Item&& src) noexcept
: Glib::Interface(std::move(src))
{}

Item& Item::operator=(Item&& src) noexcept
{
  Glib::Interface::operator=(std::move(src));
  return *this;
}

Item::~Item() noexcept
{}

// static
void Item::add_interface(GType gtype_implementer)
{
  item_class_.init().add_interface(gtype_implementer);
}

Item::CppClassType Item::item_class_; // initialize static member

GType Item::get_type()
{
  return item_class_.init().get_type();
}


GType Item::get_base_type()
{
  return goo_canvas_item_get_type();
}


Canvas* Item::get_canvas()
{
  return Glib::wrap(goo_canvas_item_get_canvas(gobj()));
}

const Canvas* Item::get_canvas() const
{
  return const_cast<Item*>(this)->get_canvas();
}

void Item::set_canvas(Canvas* canvas)
{
  goo_canvas_item_set_canvas(gobj(), Glib::unwrap(canvas));
}

bool Item::is_visible() const
{
  return goo_canvas_item_is_visible(const_cast<GooCanvasItem*>(gobj()));
}

Glib::RefPtr<ItemModel> Item::get_model()
{
  Glib::RefPtr<ItemModel> retvalue = Glib::wrap(goo_canvas_item_get_model(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const ItemModel> Item::get_model() const
{
  return const_cast<Item*>(this)->get_model();
}

void Item::set_model(const Glib::RefPtr<ItemModel>& model)
{
  goo_canvas_item_set_model(gobj(), Glib::unwrap(model));
}

Glib::RefPtr<Item> Item::get_parent()
{
  Glib::RefPtr<Item> retvalue = Glib::wrap(goo_canvas_item_get_parent(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Item> Item::get_parent() const
{
  return const_cast<Item*>(this)->get_parent();
}

void Item::set_parent(const Glib::RefPtr<Item>& parent)
{
  goo_canvas_item_set_parent(gobj(), Glib::unwrap(parent));
}

void Item::remove()
{
  goo_canvas_item_remove(gobj());
}

bool Item::is_container() const
{
  return goo_canvas_item_is_container(const_cast<GooCanvasItem*>(gobj()));
}

int Item::get_n_children() const
{
  return goo_canvas_item_get_n_children(const_cast<GooCanvasItem*>(gobj()));
}

Glib::RefPtr<Item> Item::get_child(int child_num)
{
  Glib::RefPtr<Item> retvalue = Glib::wrap(goo_canvas_item_get_child(gobj(), child_num));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Item> Item::get_child(int child_num) const
{
  return const_cast<Item*>(this)->get_child(child_num);
}

int Item::find_child(const Glib::RefPtr<Item>& child)
{
  return goo_canvas_item_find_child(gobj(), Glib::unwrap(child));
}

void Item::add_child(const Glib::RefPtr<Item>& child, int pos)
{
  goo_canvas_item_add_child(gobj(), Glib::unwrap(child), pos);
}

void Item::get_child_property_value(const Glib::RefPtr<Item>& child, const Glib::ustring& property_name, Glib::ValueBase& value) const
{
  goo_canvas_item_get_child_property(const_cast<GooCanvasItem*>(gobj()), Glib::unwrap(child), property_name.c_str(), (value).gobj());
}

void Item::set_child_property_value(const Glib::RefPtr<Item>& child, const Glib::ustring& property_name, const Glib::ValueBase& value)
{
  goo_canvas_item_set_child_property(gobj(), Glib::unwrap(child), property_name.c_str(), (value).gobj());
}

void Item::move_child(int old_position, int new_position)
{
  goo_canvas_item_move_child(gobj(), old_position, new_position);
}

void Item::remove_child(int child_num)
{
  goo_canvas_item_remove_child(gobj(), child_num);
}

void Item::raise(const Glib::RefPtr<Item>& above)
{
  goo_canvas_item_raise(gobj(), Glib::unwrap(above));
}

void Item::lower(const Glib::RefPtr<Item>& below)
{
  goo_canvas_item_lower(gobj(), Glib::unwrap(below));
}

void Item::request_update()
{
  goo_canvas_item_request_update(gobj());
}

void Item::ensure_updated()
{
  goo_canvas_item_ensure_updated(gobj());
}

void Item::update(bool entire_tree, const Cairo::RefPtr<Cairo::Context>& context, Bounds& bounds)
{
  goo_canvas_item_update(gobj(), static_cast<int>(entire_tree), (context)->cobj(), (bounds).gobj());
}

void Item::paint(const Cairo::RefPtr<Cairo::Context>& context, const Bounds& bounds, double scale)
{
  goo_canvas_item_paint(gobj(), (context)->cobj(), (bounds).gobj(), scale);
}

bool Item::get_requested_area(const Cairo::RefPtr<Cairo::Context>& context, Bounds& bounds) const
{
  return goo_canvas_item_get_requested_area(const_cast<GooCanvasItem*>(gobj()), (context)->cobj(), (bounds).gobj());
}

double Item::get_requested_height(const Cairo::RefPtr<Cairo::Context>& context, double width) const
{
  return goo_canvas_item_get_requested_height(const_cast<GooCanvasItem*>(gobj()), (context)->cobj(), width);
}

void Item::allocate_area(const Cairo::RefPtr<Cairo::Context>& context, const Bounds& requested_area, const Bounds& allocated_area, double x_offset, double y_offset)
{
  goo_canvas_item_allocate_area(gobj(), (context)->cobj(), (requested_area).gobj(), (allocated_area).gobj(), x_offset, y_offset);
}

std::vector< Glib::RefPtr<Item> > Item::get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible, const std::vector< Glib::RefPtr<Item> >& found_items)
{
  return Glib::ListHandler<Glib::RefPtr<Item> >::list_to_vector(goo_canvas_item_get_items_at(gobj(), x, y, (context)->cobj(), static_cast<int>(is_pointer_event), static_cast<int>(parent_is_visible), g_list_copy(Glib::ListHandler<Glib::RefPtr<Item> >::vector_to_list(found_items).data())), Glib::OWNERSHIP_SHALLOW);
}

std::vector< Glib::RefPtr<const Item> > Item::get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible, const std::vector< Glib::RefPtr<const Item> >& found_items) const
{
  return Glib::ListHandler<Glib::RefPtr<const Item> >::list_to_vector(goo_canvas_item_get_items_at(const_cast<GooCanvasItem*>(gobj()), x, y, (context)->cobj(), static_cast<int>(is_pointer_event), static_cast<int>(parent_is_visible), g_list_copy(Glib::ListHandler<Glib::RefPtr<const Item> >::vector_to_list(found_items).data())), Glib::OWNERSHIP_SHALLOW);
}

bool Item::get_transform(Cairo::Matrix* matrix)
{
  return goo_canvas_item_get_transform(gobj(), ((cairo_matrix_t*)(matrix)));
}

void Item::set_transform(const Cairo::Matrix* matrix)
{
  goo_canvas_item_set_transform(gobj(), ((const cairo_matrix_t*)(matrix)));
}

void Item::set_simple_transform(double x, double y, double scale, double rotation)
{
  goo_canvas_item_set_simple_transform(gobj(), x, y, scale, rotation);
}

bool Item::get_simple_transform(double& x, double& y, double& scale, double& rotation) const
{
  return goo_canvas_item_get_simple_transform(const_cast<GooCanvasItem*>(gobj()), &(x), &(y), &(scale), &(rotation));
}

void Item::translate(double tx, double ty)
{
  goo_canvas_item_translate(gobj(), tx, ty);
}

void Item::scale(double sx, double sy)
{
  goo_canvas_item_scale(gobj(), sx, sy);
}

void Item::rotate(double degrees, double cx, double cy)
{
  goo_canvas_item_rotate(gobj(), degrees, cx, cy);
}

void Item::skew_x(double degrees, double cx, double cy)
{
  goo_canvas_item_skew_x(gobj(), degrees, cx, cy);
}

void Item::skew_y(double degrees, double cx, double cy)
{
  goo_canvas_item_skew_y(gobj(), degrees, cx, cy);
}

bool Item::get_transform_for_child(const Glib::RefPtr<Item>& child, Cairo::Matrix* transform)
{
  return goo_canvas_item_get_transform_for_child(gobj(), Glib::unwrap(child), ((cairo_matrix_t*)(transform)));
}

Glib::RefPtr<Style> Item::get_style()
{
  Glib::RefPtr<Style> retvalue = Glib::wrap(goo_canvas_item_get_style(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Style> Item::get_style() const
{
  return const_cast<Item*>(this)->get_style();
}

void Item::set_style(const Glib::RefPtr<Style>& style)
{
  goo_canvas_item_set_style(gobj(), Glib::unwrap(style));
}

void Item::animate(double x, double y, double scale, double degrees, bool absolute, int duration, int step_time, GooCanvasAnimateType type)
{
  goo_canvas_item_animate(gobj(), x, y, scale, degrees, static_cast<int>(absolute), duration, step_time, type);
}

void Item::stop_animation()
{
  goo_canvas_item_stop_animation(gobj());
}

bool Item::get_is_static() const
{
  return goo_canvas_item_get_is_static(const_cast<GooCanvasItem*>(gobj()));
}

void Item::set_is_static(bool is_static)
{
  goo_canvas_item_set_is_static(gobj(), static_cast<int>(is_static));
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > Item::signal_enter_notify_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* >(this, &Item_signal_enter_notify_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > Item::signal_leave_notify_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* >(this, &Item_signal_leave_notify_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventMotion* > Item::signal_motion_notify_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventMotion* >(this, &Item_signal_motion_notify_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* > Item::signal_button_press_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* >(this, &Item_signal_button_press_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* > Item::signal_button_release_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* >(this, &Item_signal_button_release_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > Item::signal_focus_in_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* >(this, &Item_signal_focus_in_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > Item::signal_focus_out_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* >(this, &Item_signal_focus_out_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* > Item::signal_key_press_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* >(this, &Item_signal_key_press_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* > Item::signal_key_release_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* >(this, &Item_signal_key_release_event_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventGrabBroken* > Item::signal_grab_broken_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventGrabBroken* >(this, &Item_signal_grab_broken_event_info);
}


Glib::SignalProxy1< void,GParamSpec* > Item::signal_child_notify()
{
  return Glib::SignalProxy1< void,GParamSpec* >(this, &Item_signal_child_notify_info);
}


Glib::SignalProxy1< void,bool > Item::signal_animation_finished()
{
  return Glib::SignalProxy1< void,bool >(this, &Item_signal_animation_finished_info);
}


Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventScroll* > Item::signal_scroll_event()
{
  return Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventScroll* >(this, &Item_signal_scroll_event_info);
}


Glib::PropertyProxy< Glib::RefPtr<Item> > Item::property_parent() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Item> >(this, "parent");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Item> > Item::property_parent() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Item> >(this, "parent");
}

Glib::PropertyProxy< ItemVisibility > Item::property_visibility() 
{
  return Glib::PropertyProxy< ItemVisibility >(this, "visibility");
}

Glib::PropertyProxy_ReadOnly< ItemVisibility > Item::property_visibility() const
{
  return Glib::PropertyProxy_ReadOnly< ItemVisibility >(this, "visibility");
}

Glib::PropertyProxy< double > Item::property_visibility_threshold() 
{
  return Glib::PropertyProxy< double >(this, "visibility-threshold");
}

Glib::PropertyProxy_ReadOnly< double > Item::property_visibility_threshold() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "visibility-threshold");
}

Glib::PropertyProxy< Cairo::Matrix* > Item::property_transform() 
{
  return Glib::PropertyProxy< Cairo::Matrix* >(this, "transform");
}

Glib::PropertyProxy_ReadOnly< Cairo::Matrix* > Item::property_transform() const
{
  return Glib::PropertyProxy_ReadOnly< Cairo::Matrix* >(this, "transform");
}

Glib::PropertyProxy< PointerEvents > Item::property_pointer_events() 
{
  return Glib::PropertyProxy< PointerEvents >(this, "pointer-events");
}

Glib::PropertyProxy_ReadOnly< PointerEvents > Item::property_pointer_events() const
{
  return Glib::PropertyProxy_ReadOnly< PointerEvents >(this, "pointer-events");
}

Glib::PropertyProxy< Glib::ustring > Item::property_title() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "title");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Item::property_title() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "title");
}

Glib::PropertyProxy< Glib::ustring > Item::property_description() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "description");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Item::property_description() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "description");
}

Glib::PropertyProxy< bool > Item::property_can_focus() 
{
  return Glib::PropertyProxy< bool >(this, "can-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Item::property_can_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-focus");
}

Glib::PropertyProxy< double > Item::property_x() 
{
  return Glib::PropertyProxy< double >(this, "x");
}

Glib::PropertyProxy_ReadOnly< double > Item::property_x() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "x");
}

Glib::PropertyProxy< double > Item::property_y() 
{
  return Glib::PropertyProxy< double >(this, "y");
}

Glib::PropertyProxy_ReadOnly< double > Item::property_y() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "y");
}

Glib::PropertyProxy< double > Item::property_width() 
{
  return Glib::PropertyProxy< double >(this, "width");
}

Glib::PropertyProxy_ReadOnly< double > Item::property_width() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "width");
}

Glib::PropertyProxy< double > Item::property_height() 
{
  return Glib::PropertyProxy< double >(this, "height");
}

Glib::PropertyProxy_ReadOnly< double > Item::property_height() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "height");
}


bool Goocanvas::Item::on_enter_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->enter_notify_event)
    return (*base->enter_notify_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_leave_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->leave_notify_event)
    return (*base->leave_notify_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_motion_notify_event(const Glib::RefPtr<Item>& target, GdkEventMotion* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->motion_notify_event)
    return (*base->motion_notify_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_button_press_event(const Glib::RefPtr<Item>& target, GdkEventButton* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->button_press_event)
    return (*base->button_press_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_button_release_event(const Glib::RefPtr<Item>& target, GdkEventButton* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->button_release_event)
    return (*base->button_release_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_focus_in_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->focus_in_event)
    return (*base->focus_in_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_focus_out_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->focus_out_event)
    return (*base->focus_out_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_key_press_event(const Glib::RefPtr<Item>& target, GdkEventKey* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->key_press_event)
    return (*base->key_press_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_key_release_event(const Glib::RefPtr<Item>& target, GdkEventKey* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->key_release_event)
    return (*base->key_release_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
bool Goocanvas::Item::on_grab_broken_event(const Glib::RefPtr<Item>& target, GdkEventGrabBroken* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->grab_broken_event)
    return (*base->grab_broken_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}
void Goocanvas::Item::on_child_notify(GParamSpec* pspec)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->child_notify)
    (*base->child_notify)(gobj(),pspec);
}
void Goocanvas::Item::on_animation_finished(bool stopped)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->animation_finished)
    (*base->animation_finished)(gobj(),static_cast<int>(stopped));
}
bool Goocanvas::Item::on_scroll_event(const Glib::RefPtr<Item>& target, GdkEventScroll* event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->scroll_event)
    return (*base->scroll_event)(gobj(),Glib::unwrap(target),event);

  typedef bool RType;
  return RType();
}

int Goocanvas::Item::get_n_children_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_n_children)
  {
    int retval((*base->get_n_children)(const_cast<GooCanvasItem*>(gobj())));
    return retval;
  }

  typedef int RType;
  return RType();
}
Glib::RefPtr<Item> Goocanvas::Item::get_child_vfunc(int child_num) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_child)
  {
    Glib::RefPtr<Item> retval(Glib::wrap((*base->get_child)(const_cast<GooCanvasItem*>(gobj()),child_num), true));
    return retval;
  }

  typedef Glib::RefPtr<Item> RType;
  return RType();
}
void Goocanvas::Item::request_update_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->request_update)
  {
    (*base->request_update)(gobj());
  }
}
Canvas* Goocanvas::Item::get_canvas_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_canvas)
  {
    Canvas* retval(Glib::wrap((*base->get_canvas)(const_cast<GooCanvasItem*>(gobj()))));
    return retval;
  }

  typedef Canvas* RType;
  return RType();
}
void Goocanvas::Item::set_canvas_vfunc(Canvas* canvas) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_canvas)
  {
    (*base->set_canvas)(gobj(),Glib::unwrap(canvas));
  }
}
void Goocanvas::Item::add_child_vfunc(const Glib::RefPtr<Item>& child, int position) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->add_child)
  {
    (*base->add_child)(gobj(),Glib::unwrap(child),position);
  }
}
void Goocanvas::Item::move_child_vfunc(int old_position, int new_position) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->move_child)
  {
    (*base->move_child)(gobj(),old_position,new_position);
  }
}
void Goocanvas::Item::remove_child_vfunc(int child_num) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->remove_child)
  {
    (*base->remove_child)(gobj(),child_num);
  }
}
void Goocanvas::Item::get_child_property_vfunc(const Glib::RefPtr<Item>& child, guint property_id, Glib::ValueBase& value, GParamSpec* pspec) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_child_property)
  {
    (*base->get_child_property)(const_cast<GooCanvasItem*>(gobj()),Glib::unwrap(child),property_id,(value).gobj(),pspec);
  }
}
void Goocanvas::Item::set_child_property_vfunc(const Glib::RefPtr<Item>& child, guint property_id, const Glib::ValueBase& value, GParamSpec* pspec) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_child_property)
  {
    (*base->set_child_property)(gobj(),Glib::unwrap(child),property_id,(value).gobj(),pspec);
  }
}
bool Goocanvas::Item::get_transform_for_child_vfunc(const Glib::RefPtr<Item>& child, Cairo::Matrix* transform) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_transform_for_child)
  {
    bool retval((*base->get_transform_for_child)(const_cast<GooCanvasItem*>(gobj()),Glib::unwrap(child),((cairo_matrix_t*)(transform))));
    return retval;
  }

  typedef bool RType;
  return RType();
}
Glib::RefPtr<Item> Goocanvas::Item::get_parent_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_parent)
  {
    Glib::RefPtr<Item> retval(Glib::wrap((*base->get_parent)(const_cast<GooCanvasItem*>(gobj())), true));
    return retval;
  }

  typedef Glib::RefPtr<Item> RType;
  return RType();
}
void Goocanvas::Item::set_parent_vfunc(const Glib::RefPtr<Item>& parent) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_parent)
  {
    (*base->set_parent)(gobj(),Glib::unwrap(parent));
  }
}
void Goocanvas::Item::update_vfunc(bool entire_tree, const Cairo::RefPtr<Cairo::Context>& cr, Bounds& bounds) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->update)
  {
    (*base->update)(gobj(),static_cast<int>(entire_tree),(cr)->cobj(),(bounds).gobj());
  }
}
void Goocanvas::Item::paint_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Bounds& bounds, double scale) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->paint)
  {
    (*base->paint)(gobj(),(cr)->cobj(),(bounds).gobj(),scale);
  }
}
bool Goocanvas::Item::get_requested_area_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, GooCanvasBounds* requested_area) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_requested_area)
  {
    bool retval((*base->get_requested_area)(const_cast<GooCanvasItem*>(gobj()),(cr)->cobj(),requested_area));
    return retval;
  }

  typedef bool RType;
  return RType();
}
void Goocanvas::Item::allocate_area_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Bounds& requested_area, const Bounds& allocated_area, double x_offset, double y_offset) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->allocate_area)
  {
    (*base->allocate_area)(gobj(),(cr)->cobj(),(requested_area).gobj(),(allocated_area).gobj(),x_offset,y_offset);
  }
}
bool Goocanvas::Item::get_transform_vfunc(Cairo::Matrix* transform) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_transform)
  {
    bool retval((*base->get_transform)(const_cast<GooCanvasItem*>(gobj()),((cairo_matrix_t*)(transform))));
    return retval;
  }

  typedef bool RType;
  return RType();
}
void Goocanvas::Item::set_transform_vfunc(const Cairo::Matrix* transform) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_transform)
  {
    (*base->set_transform)(gobj(),((const cairo_matrix_t*)(transform)));
  }
}
Glib::RefPtr<Style> Goocanvas::Item::get_style_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_style)
  {
    Glib::RefPtr<Style> retval(Glib::wrap((*base->get_style)(const_cast<GooCanvasItem*>(gobj())), true));
    return retval;
  }

  typedef Glib::RefPtr<Style> RType;
  return RType();
}
void Goocanvas::Item::set_style_vfunc(const Glib::RefPtr<Style>& style) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_style)
  {
    (*base->set_style)(gobj(),Glib::unwrap(style));
  }
}
bool Goocanvas::Item::is_visible_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->is_visible)
  {
    bool retval((*base->is_visible)(const_cast<GooCanvasItem*>(gobj())));
    return retval;
  }

  typedef bool RType;
  return RType();
}
double Goocanvas::Item::get_requested_height_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, double width) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_requested_height)
  {
    double retval((*base->get_requested_height)(gobj(),(cr)->cobj(),width));
    return retval;
  }

  typedef double RType;
  return RType();
}
bool Goocanvas::Item::get_is_static_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_is_static)
  {
    bool retval((*base->get_is_static)(const_cast<GooCanvasItem*>(gobj())));
    return retval;
  }

  typedef bool RType;
  return RType();
}
void Goocanvas::Item::set_is_static_vfunc(bool is_static) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_is_static)
  {
    (*base->set_is_static)(gobj(),static_cast<int>(is_static));
  }
}
Glib::RefPtr<ItemModel> Goocanvas::Item::get_model_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_model)
  {
    Glib::RefPtr<ItemModel> retval(Glib::wrap((*base->get_model)(const_cast<GooCanvasItem*>(gobj())), true));
    return retval;
  }

  typedef Glib::RefPtr<ItemModel> RType;
  return RType();
}
void Goocanvas::Item::set_model_vfunc(const Glib::RefPtr<ItemModel>& model) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_model)
  {
    (*base->set_model)(gobj(),Glib::unwrap(model));
  }
}


} // namespace Goocanvas


