
# Clear all conditional flags
setenv MACINTEL_COMP_FLAG "-mmacosx-version-min=10.5 -isysroot /Developer/SDKs/MacOSX10.5.sdk -fPIC"
set MAC_BRAND=macintel64	        # set MACINTEL for -64 mode
#setenv LNX_COMP_FLAG "-m32"
#set LINUX_BRAND=linux32		# set LINUX for -32 mode
setenv HDFEOS_HOME  /net/origin/devdata1/ataaheri/TK2.20_dev_2017_new/TOOLKIT/hdfeos
setenv HDFEOS5_HOME /net/origin/devdata1/ataaheri/TK2.20_dev_2017_new/TOOLKIT/hdfeos5
setenv HDFHOME  /net/origin/devdata1/ataaheri/TK2.20_dev_2017_new/TOOLKIT/hdf/$BRAND/hdf-4.2.13
setenv HDF5HOME /net/origin/devdata1/ataaheri/TK2.20_dev_2017_new/TOOLKIT/hdf5/$BRAND/hdf5-1.8.19
setenv SZIPHOME /net/origin/devdata1/ataaheri/TK2.20_dev_2017_new/TOOLKIT/szip/$BRAND/szip-2.1.1
setenv JPEGHOME /net/origin/devdata1/ataaheri/TK2.20_dev_2017_new/TOOLKIT/jpeg/$BRAND/jpeg-9b
setenv ZLIBHOME /net/origin/devdata1/ataaheri/TK2.20_dev_2017_new/TOOLKIT/zlib/$BRAND/zlib-1.2.11
#-----------------------------------------------------------------------------
# file:	
# 	hdfeos2_env.csh
#
# description:
# 	This file defines environment variables used for hdfeos2 testdrivers.
# 	This version is for use under the C shell (csh).
#
# usage:
# 	This file should before soutced after setting correct 
#       HDFEOS_HOME, HDFHOME, and SZIPHOME above
#
# 	    source <HDFEOS2_TST_DIR>/Common/hdfeos2_env.csh
#	
# 	where <HDFEOS2_TST_DIR> is the full path of the  HDF-EOS2
#       testdriver home directory, set before running test scripts.
#
# author:
#	Abe Taaheri / Raytheon IIS
#
# notes:
# 	   
#
#
#-----------------------------------------------------------------------------
set pgs_path  = ( $path )       # add SZIPBIN to pgs  path
set user_path = ( $path )	# save user path

# set path to a base subset of directories, allowing startup on unknown host
# note: once the host has been determined the path is appropriately customized

set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/ucb /usr/bin/X11)


# get operating system type, login
# special cases: SCO and Cray  - uname works differently,

setenv MACHINE `uname -m | awk '{print $1}'`	# needed on Cray & SCO

switch ( "$MACHINE" )

    case "i386":        			# SCO box
        breaksw

    case "CRAY":    				# CRAY
        breaksw

    default:					# everybody else
	setenv OSTYPE `uname`
        breaksw

endsw

# Intel Macintosh is also i386 or i686 (?) machine

    if ( "$MACHINE" == "i386" ) then
	if ( "$temp_ostype" == "Darwin" ) then 
	    setenv OSTYPE DarwinIntel
	endif
    endif
    if ( "$MACHINE" == "i686" ) then
	if ( "$temp_ostype" == "Darwin" ) then 
	    setenv OSTYPE DarwinIntel
	endif
    endif


set user=`id | cut -d\( -f2 | cut -d\) -f1`
if ($?LOGNAME == 0) setenv LOGNAME $user	# make sure $LOGNAME is defined
setenv USER $LOGNAME				# make sure $USER is defined


# set machine-dependent environment variables:
# 	HOST  the host name of this machine
# 	BRAND used by other achitecture-specific code
# 	path  the execution search path exported to PATH

switch ( "$OSTYPE" )

    case "AIX": 
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/ucb /usr/bin/X11 /usr/ccs/bin /usr/sbin)
	setenv HOST `hostname`
        breaksw

    case "HP-UX": 
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/bin/X11)
	setenv HOST `hostname`
        breaksw

    case "IRIX":  
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/bsd /usr/bin/X11 /usr/sbin)
	setenv HOST `hostname`
        breaksw

    case "IRIX64":  
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/bsd /usr/bin/X11 /usr/sbin)
	setenv HOST `hostname`
        breaksw

    case "Linux": 
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/X11/bin)
	setenv HOST `hostname`
        breaksw

    case "Linux32": 
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/X11/bin)
	setenv HOST `hostname`
        breaksw

    case "Linux64": 
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/X11/bin)
	setenv HOST `hostname`
        breaksw

    case "DarwinIntel":
        set path=(/bin /sbin /usr/bin /usr/sbin)
        setenv HOST `hostname -s`
         breaksw

    case "SunOS": 
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/etc /usr/bin/X11)
        breaksw

    case "UNICOS": 
	set path=(/usr/local/bin /bin /usr/bin /etc /usr/ucb /usr/bin/X11)
	setenv HOST `hostname`
        breaksw

    default:
	echo "Operating system: $OSTYPE not supported"
        breaksw

endsw

# set machine-dependent compilers and compilation switches:
#
#

switch ($BRAND)

    case cray:
	setenv CC cc 			# C compiler
	setenv CFLAGS "" 		# default C flags (optimize, ansi)
	setenv C_CFH "-DCRAYFortran"    # C/cfortran.h called from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 cf77			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main 
	setenv HDFSYS UNICOS		# system type as defined by HDF
	breaksw

    case dec:
	setenv CC cc 			# C compiler
	setenv CFLAGS "-std"		# default C flags (optimize, ansi)
	setenv C_CFH "-DDECFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 f77 			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""             # calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS DEC_ALPHA		# system type as defined by HDF
	breaksw

    case hp:
	setenv CC cc 			# C compiler
	setenv CFLAGS "-Ae" 		# default C flags (optimize, ansi)
	setenv C_CFH "" 		# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 fort77		# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS HP9000		# system type as defined by HDF
	breaksw

    case ibm:
	setenv CC cc 			# C compiler
	setenv CFLAGS "-qlanglvl=ansi" # default C flags (optimize, ansi)
	setenv C_CFH "" 		# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 xlf 			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS IBM6000		# system type as defined by HDF
	breaksw

    case linux:
    case linux32:
	echo " Setting 32-bit LINUX environment variables"
	setenv CC "gcc -m32" 			# C compiler
	setenv CFLAGS ""	# default C flags (optimize, ansi)
	setenv C_CFH "-Df2cFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 "g77 -m32"			# FORTRAN compiler
	setenv F77FLAGS "-fno-second-underscore" # common FORTRAN flags
        setenv F77_CFH "-fno-second-underscore"          # FORTRAN callable from C w/ cfortran.h
	setenv F77 "g77 -m32"		# FORTRAN compiler - default
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS LINUX		# system type as defined by HDF
	breaksw

    case linux64:
	echo " Setting 64-bit LINUX environment variables"
	setenv CC "gcc -fPIC" 			# C compiler
	setenv CFLAGS ""	# default C flags (optimize, ansi)
	setenv C_CFH "-Df2cFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 "g77 -fPIC"			# FORTRAN compiler
	setenv F77FLAGS "-fno-second-underscore" # common FORTRAN flags
        setenv F77_CFH "-fno-second-underscore"          # FORTRAN callable from C w/ cfortran.h
	setenv F77 "g77 -fPIC"		# FORTRAN compiler - default
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS LINUX		# system type as defined by HDF
	breaksw

    case macintosh:
        setenv CC gcc                   # C compiler
        setenv CFLAGS "-O2 -DMACINTOSH" # default C flags (optimize, ansi)
        setenv C_CFH "-Df2cFortran"     # C w/ cfortran.h callable from FORTRAN
        setenv CFHFLAGS "$CFLAGS $C_CFH"# CFLAGS + C_CFH
        setenv F77 gfortran                  # FORTRAN compiler - default
        setenv F77FLAGS "-O2 -fno-second-underscore" # common FORTRAN flags  
        setenv F77_CFH "-fno-second-underscore"      # FORTRAN callable from C w/cfortran.h
        setenv F77_C_CFH ""             # calling C w/ cfortran.h
        setenv F77_C_LIB ""             # C lib called by FORTRAN main
        setenv HDFSYS MACINTOSH         # system type as defined by HDF
        breaksw

    case macintel:
    case macintel32:
    case macintel64:
        setenv CC "gcc $MACINTEL_COMP_FLAG"                 # C compiler
        setenv CFLAGS "$opt_flag $ext_cc_flags -ansi" # default C flags (optimize, ansi)
        setenv C_CFH "-Df2cFortran"     # C w/ cfortran.h callable from FORTRAN
        setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
        setenv C_F77_CFH "$C_CFH"       # calling FORTRAN
        setenv C_F77_LIB ""             # FORTRAN lib called by C main
        setenv F77 "gfortran $MACINTEL_COMP_FLAG"                # FORTRAN compiler
        setenv F77FLAGS " $ext_fc_flags "              # common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
        setenv F77_C_CFH "$F77_CFH"     # calling C w/ cfortran.h
        setenv CFH_F77 "$F77_C_CFH"     # old version of F77_C_CFH
        setenv F77_C_LIB ""             # C lib called by FORTRAN main
        setenv HDFSYS MACINTEL         # system type as defined by HDF
        setenv MACHINE MACINTEL        # system type as defined by HDFEOS
        breaksw

    case sco:
	setenv CC cc 			# C compiler
	setenv CFLAGS " -posix"	# default C flags (optimize, ansi)
	setenv C_CFH "-Df2cFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 ""			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS SCO		# system type as defined by HDF
	breaksw

    case sgi:
	if ($OSTYPE == "IRIX64") then
		setenv CC "cc -32"	# C compiler (32 bit)
		setenv F77 "f77 -32"	# FORTRAN compiler (32 bit)
	else
                setenv CC cc		# C compiler
                setenv F77 f77		# FORTRAN compiler
	endif
	setenv CFLAGS "-xansi -D_POSIX_SOURCE"	# default C flags (optimize, ansi)
	setenv C_CFH ""	 		# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS IRIX		# system type as defined by HDF
	breaksw

    case sgi32:
	setenv CC "cc -n32"		# C compiler (new-style 32 bit)
	setenv F77 "f77 -n32"		# FORTRAN compiler (new-style 32 bit)
	setenv CFLAGS "-xansi -D_POSIX_SOURCE"	# default C flags (optimize, ansi)
	setenv C_CFH ""	 		# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS IRIX		# system type as defined by HDF
	breaksw

    case sgi64:
        if (`hinv | fgrep CPU | cut -d' ' -f3 | cut -b2` == "4") then
                setenv CC "cc -64 -mips3"       # C compiler (R4?00 chip)
                setenv F77 "f77 -64 -mips3"     # FORTRAN compiler (R4?00 chip)
        else
                setenv CC "cc -64"      # C compiler
                setenv F77 "f77 -64"    # FORTRAN compiler
        endif
	setenv CFLAGS "xansi -D_POSIX_SOURCE"	# default C flags (optimize, ansi)
	setenv C_CFH ""	 		# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS IRIX		# system type as defined by HDF
	breaksw

    case irix65:
	setenv CC "cc -n32"		# C compiler (new-style 32 bit)
	setenv F77 "f77 -n32"		# FORTRAN compiler (new-style 32 bit)
	setenv CFLAGS "-xansi -D_POSIX_SOURCE"	# default C flags (optimize, ansi)
	setenv C_CFH ""	 		# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""          	# calling C w/ cfortran.h
	setenv F77_C_LIB ""		# C lib called by FORTRAN main
	setenv HDFSYS IRIX		# system type as defined by HDF
	breaksw

	
    case sun4:
	setenv CC acc			# C compiler
	setenv CFLAGS "-Xa" 		# default C flags (optimize, ansi)
	setenv C_CFH "-DsunFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 f77 			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""           	# calling C w/ cfortran.h
	setenv F77_C_LIB "-lm" 		# C lib called by FORTRAN main
	setenv HDFSYS SUN		# system type as defined by HDF
	breaksw

    case sun5:
	setenv CC cc			# C compiler
	setenv CFLAGS "-Xa" 		# default C flags (optimize, ansi)
	setenv C_CFH "-DsunFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 f77 			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""           	# calling C w/ cfortran.h
	setenv F77_C_LIB "-lm" 		# C lib called by FORTRAN main
	setenv HDFSYS SUN		# system type as defined by HDF
	breaksw

     case sun5.8:
	setenv CC cc			# C compiler
	setenv CFLAGS "-Xa" 		# default C flags (optimize, ansi)
	setenv C_CFH "-DsunFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 f77 			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""           	# calling C w/ cfortran.h
	setenv F77_C_LIB "-lm" 		# C lib called by FORTRAN main
	setenv HDFSYS SUN		# system type as defined by HDF
	breaksw

     case sun5.9:
	setenv CC cc			# C compiler
	setenv CFLAGS "-Xa" 		# default C flags (optimize, ansi)
	setenv C_CFH "-DsunFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 f77 			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""           	# calling C w/ cfortran.h
	setenv F77_C_LIB "-lm" 		# C lib called by FORTRAN main
	setenv HDFSYS SUN		# system type as defined by HDF
	breaksw

     case sun5.10:
	setenv CC cc			# C compiler
	setenv CFLAGS "-Xa" 		# default C flags (optimize, ansi)
	setenv C_CFH "-DsunFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 f77 			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""           	# calling C w/ cfortran.h
	setenv F77_C_LIB "-lm" 		# C lib called by FORTRAN main
	setenv HDFSYS SUN		# system type as defined by HDF
	breaksw
     case sun5.11:
	setenv CC "gcc -m32"  		# C compiler
	setenv CFLAGS "-Xa" 		# default C flags (optimize, ansi)
	setenv C_CFH "-DsunFortran"	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 "gfortran -m32 "			# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""           	# calling C w/ cfortran.h
	setenv F77_C_LIB "-lm" 		# C lib called by FORTRAN main
	setenv HDFSYS SUN		# system type as defined by HDF
	breaksw
    default:
	setenv CC cc 			# C compiler
	setenv CFLAGS "" 		# default C flags (optimize)
	setenv C_CFH ""	        	# C w/ cfortran.h callable from FORTRAN
	setenv CFHFLAGS "$CFLAGS $C_CFH" # CFLAGS + C_CFH
	setenv F77 f77  		# FORTRAN compiler
	setenv F77FLAGS "" 		# common FORTRAN flags
        setenv F77_CFH ""               # FORTRAN callable from C w/ cfortran.h
	setenv F77_C_CFH ""           	# calling C w/ cfortran.h
	setenv F77_C_LIB "-lm" 		# C lib called by FORTRAN main
	setenv HDFSYS unknown		# system type as defined by HDF
	breaksw
endsw


# set HDF-related environment variables
# these may be referred to in makefiles and on compiler command lines

#
# Set HDF directories:
#
# - first look in $HDFHOME
# - if not found, default to $HDFHOME/hdf
#

if ($?HDFHOME) then

    if ( -d $HDFHOME/bin ) then		# HDF utilities
        setenv HDFBIN $HDFHOME/bin
    else
        setenv HDFBIN $HDFHOME/hdf/bin
    endif

    if ( -d $HDFHOME/include ) then	# HDF header files
        setenv HDFINC $HDFHOME/include
	setenv JPEGINC $HDFHOME/include
	setenv ZLIBINC $HDFHOME/include
    else
	if ( -d $HDFHOME/hdf/include ) then	# HDF header files
	    setenv HDFINC $HDFHOME/hdf/include
	    setenv JPEGINC $HDFHOME/hdf/include
	    setenv ZLIBINC $HDFHOME/hdf/include
	else
	    setenv HDFINC $HDFHOME/hdf4/include
	    setenv JPEGINC $HDFHOME/hdf4/include
	    setenv ZLIBINC $HDFHOME/hdf4/include
	endif
    endif

    if ( -d $HDFHOME/lib ) then		# HDF libraries
        setenv HDFLIB $HDFHOME/lib
        setenv JPEGLIB $HDFHOME/lib
        setenv ZLIBLIB $HDFHOME/lib
    else
	if ( -d $HDFHOME/hdf/lib ) then		# HDF libraries
	    setenv HDFLIB $HDFHOME/hdf/lib
	    setenv JPEGLIB $HDFHOME/hdf/lib
	    setenv ZLIBLIB $HDFHOME/hdf/lib
	else
	    setenv HDFLIB $HDFHOME/hdf4/lib
	    setenv JPEGLIB $HDFHOME/hdf4/lib
	    setenv ZLIBLIB $HDFHOME/hdf4/lib
	endif
    endif


    set pgs_path  = ($pgs_path  $HDFBIN)	# add HDFBIN to pgs  path
    set user_path = ($user_path $HDFBIN)	# add HDFBIN to user path

endif

#
# Set HDF5 directories:
#
# - first look in $HDF5HOME
# - if not found, default to $HDF5HOME/hdf5
#

if ($?HDF5HOME) then

    if ( -d $HDF5HOME/bin ) then                # HDF5 utilities
        setenv HDF5BIN $HDF5HOME/bin
    else
        setenv HDF5BIN $HDF5HOME/hdf5/bin
    endif

    if ( -d $HDF5HOME/include ) then    	# HDF5 header files
        setenv HDF5INC $HDF5HOME/include
    else
        setenv HDF5INC $HDF5HOME/hdf5/include
    endif

    if ( -d $HDF5HOME/lib ) then                # HDF5 libraries
        setenv HDF5LIB $HDF5HOME/lib
    else
        setenv HDF5LIB $HDF5HOME/hdf5/lib
    endif



    set pgs_path  = ($pgs_path  $HDF5BIN)       # add HDF5BIN to pgs  path
    set user_path = ($user_path $HDF5BIN)       # add HDF5BIN to user path

endif

#
# Set SZIP directories:
#
# - first look in $SZIPHOME
# - if not found, default to $SZIPHOME/szip
#

if ($?SZIPHOME) then

if ( -d $SZIPHOME/bin ) then         # SZIP utilities
        setenv SZIPBIN $SZIPHOME/bin
    else
        setenv SZIPBIN $HDFHOME/szip/bin
    endif

if ( -d $SZIPHOME/include ) then     # SZIP header files
        setenv SZIPINC $SZIPHOME/include
    else
        setenv SZIPINC $SZIPHOME/szip/include
    endif

    if ( -d $SZIPHOME/lib ) then         # SZIP libraries
        setenv SZIPLIB $SZIPHOME/lib
    else
        setenv SZIPLIB $SZIPHOME/szip/lib
    endif


    set pgs_path  = ($pgs_path  $SZIPBIN)        # add SZIPBIN to pgs  path
    set user_path = ($user_path $SZIPBIN)        # add SZIPBIN to user path

endif
  
#
# Set HDF-EOS directories:
#

if ($?HDFEOS_HOME) then

    setenv HDFEOS_INC $HDFEOS_HOME/include
    setenv HDFEOS_LIB $HDFEOS_HOME/lib/$BRAND
    setenv HDFEOS_BIN $HDFEOS_HOME/bin/$BRAND
    setenv HDFEOS_OBJ $HDFEOS_HOME/obj/$BRAND
endif


#
# restore augmented user path
#
set path = ( $user_path )

if ( ! -f $HDFEOS_LIB/libGctp.a ) then
    switch ($BRAND)

	case linux:
	case linux32:
	    /bin/cp $HDFEOS_HOME/lib/tmp/geolibLINUX.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw
	case linux64:
	    /bin/cp $HDFEOS_HOME/lib/tmp/geolibLINUX64.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw
	case macintosh:
	    /usr/bin/cp $HDFEOS_HOME/lib/tmp/geolibMAC.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw

	case macintel:
	case macintel32:
	    /usr/bin/cp $HDFEOS_HOME/lib/tmp/geolibMAC.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw

	case macintel64:
	    /usr/bin/cp $HDFEOS_HOME/lib/tmp/geolibMAC64.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw

	case sgi32:
	    /usr/bin/cp $HDFEOS_HOME/lib/tmp/geolibIRIX65-n32.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw

	case sun5.8:
	    /usr/bin/cp $HDFEOS_HOME/lib/tmp/geolibSOL28.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw

	case sun5.10:
	    /usr/bin/cp $HDFEOS_HOME/lib/tmp/geolibSOL210.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw

	case sun5.11:
	    /usr/bin/cp $HDFEOS_HOME/lib/tmp/geolibSOL211.a $HDFEOS_LIB/libGctp.a
	    echo "libGctp.a library does not exist. It is created."
	breaksw

	default:
	    echo " Platform not supported"
	breaksw
    endsw
endif
