c
 
      program testpoint
 
      integer*4       ptfid, ptid1, ptid2, ptid3, ptdetach, ptclose
      integer*4       ptopen, ptcreate
      integer         status
      integer*4       ptid, fldsz, nlevels, nflds, fldlevels(16)
      integer*4		npoint
      integer*4       fieldtype(8), fieldorder(8)
      character*72	fldlist, attrlist, ptlist
 
      integer*4       ptattach, ptinqpoint
      integer         ptdeflev, ptdeflink, ptwrattr
      integer         ptrdattr, ptattrinfo
      integer         i, j, k, pntr, strbufsize
      integer*2       wgt
      integer*4       n, date, nt, sz
 
      real*4          rain, temp, conc(4), f32, b32 
      real*8          lon, lat, time
 
      character       buffer*10000, id*2, desc*16, spc*8
      character       linkfield*8
      character       ctime*4, cconc*16, clon*8, clat*8
      character       cdate*4, crain*4, ctemp*4, cwgt*2

      integer         ptwrlev

      integer*4       recs(32)
      integer*4       fldtype(32), fldorder(32)
 
      integer         ptrdlev
      integer         ptlevinfo, ptblinkinfo, ptflinkinfo
      integer*4       ptnrecs, ptnlevs, ptsizeof, ptnflds
      integer*4		ptlevidx, ptinqattrs

      integer         ptuplev, ptgetrecnums
      integer*4       inlevel, outlevel, levndx
      integer*4       outrecs(32), outnrec
      real*8          f64
 
      character       datbuf*256, c8*8

      integer         ptextreg, ptreginfo
      integer         ptextper, ptperinfo
 
      integer*4       size, ptdefboxreg, ptdeftmeper
      integer*4       regionid, periodid
 
      real*8          cornerlon(2), cornerlat(2)
      real*8          dtbuf(128), starttime, stoptime
 
 
      integer DFACC_CREATE
      parameter (DFACC_CREATE=4)
 
      integer  DFACC_RDWR
      parameter (DFACC_RDWR=3)

      integer  DFNT_CHAR8, DFNT_INT16, DFNT_INT32
      parameter (DFNT_CHAR8=4)
      parameter (DFNT_INT16=22)
      parameter (DFNT_INT32=24)
 
      integer  DFNT_FLOAT32, DFNT_FLOAT64
      parameter (DFNT_FLOAT32=5)
      parameter (DFNT_FLOAT64=6)

      integer DFACC_READ
      parameter (DFACC_READ=1)


      open(unit=3, file='testpointf.txt')
 
      write(*,*)'Testing Point FORTRAN 77 interface'
      write(*,*)'=================================='
      write(3,*)'Testing Point FORTRAN 77 interface'
      write(3,*)'=================================='
      write(*,*)' '
      write(3,*)' '
 
c Test Case -- ptopen
c
      write(*,*)'Testing ptopen '
      write(*,*)'================='
      write(3,*)'Testing ptopen '
      write(3,*)'================='

      ptfid = ptopen("Pointf_Test.hdf", DFACC_CREATE)
      write(*,*)'       ptfid = ptopen("Pointf_Test.hdf", DFACC_CREATE)'
      write(*,*)'       File id  returned by ptopen ', ptfid
      write(3,*)'       ptfid = ptopen("Pointf_Test.hdf", DFACC_CREATE)'
      write(3,*)'       File id returned by ptopen ', ptfid
      write(*,*)' '
      write(3,*)' '


 
c Test Case -- ptcreate
c
      write(*,*)'Testing ptcreate '
      write(*,*)'================='
      write(3,*)'Testing ptcreate '
      write(3,*)'================='

      ptid1 = ptcreate(ptfid, "Simple Point")
      write(*,*)'      ptid1 = ptcreate(ptfid, "Simple Point")'
      write(*,*)'      Point id returned by ptcreate ',ptid1
      write(3,*)'      ptid1 = ptcreate(ptfid, "Simple Point")'
      write(3,*)'      Point id returned by ptcreate ',ptid1

      ptid2 = ptcreate(ptfid, "FixedBuoy Point")
      write(*,*)'      ptid2 = ptcreate(ptfid, "FixedBuoy Point")'
      write(*,*)'      Point id returned by ptcreate ',ptid2
      write(3,*)'      ptid2 = ptcreate(ptfid, "FixedBuoy Point")'
      write(3,*)'      Point id returned by ptcreate ',ptid2

      ptid3 = ptcreate(ptfid, "FloatBuoy Point")
      write(*,*)'      ptid3 = ptcreate(ptfid, "FloatBuoy Point")'
      write(*,*)'      Point id returned by ptcreate ',ptid3
      write(3,*)'      ptid3 = ptcreate(ptfid, "FloatBuoy Point")'
      write(3,*)'      Point id returned by ptcreate ',ptid3
 
 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptdetach
c  
      write(3,27)
      write(*,*)'Testing ptdetach '
      write(*,*)'================='
      write(3,*)'Testing ptdetach '
      write(3,*)'================='

      status = ptdetach(ptid1)
      write(*,*)'      status = ptdetach(ptid1)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'      status = ptdetach(ptid1)'
      write(3,*)'      Status returned by ptdetach ',status

      status = ptdetach(ptid2)
      write(*,*)'      status = ptdetach(ptid2)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'      status = ptdetach(ptid2)'
      write(3,*)'      Status returned by ptdetach ',status

      status = ptdetach(ptid3)
      write(*,*)'      status = ptdetach(ptid3)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'      status = ptdetach(ptid3)'
      write(3,*)'      Status returned by ptdetach ',status

 
 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptclose
c  
      write(3,27)
      write(*,*)'Testing ptclose '
      write(*,*)'================='
      write(3,*)'Testing ptclose '
      write(3,*)'================='

      status = ptclose(ptfid)
      write(*,*)'      status = ptclose(ptfid)'
      write(*,*)'      Status returned by ptclose ',status
      write(3,*)'      status = ptclose(ptfid)'
      write(3,*)'      Status returned by ptclose ',status

      ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)
      write(*,*)'      ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)'
      write(*,*)'      Point file id returned by ptopen ',ptfid
      write(3,*)'      ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)'
      write(3,*)'      Point file id returned by ptopen ',ptfid

 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptattach
c  
      write(3,27)
      write(*,*)'Testing ptattach '
      write(*,*)'================='
      write(3,*)'Testing ptattach '
      write(3,*)'================='

      ptid = ptattach(ptfid, "Simple Point")
      write(*,*)'      ptid = ptattach(ptfid, "Simple Point")'
      write(*,*)'      Point id returned by ptattach ',ptid
      write(3,*)'      ptid = ptattach(ptfid, "Simple Point")'
      write(3,*)'      Point id returned by ptattach ',ptid

      fldlist = "Time,Concentration,Species"
 
 
      fieldtype(1) = DFNT_FLOAT64
      fieldtype(2) = DFNT_FLOAT32
      fieldtype(3) = DFNT_CHAR8
 
      fieldorder(1) = 1
      fieldorder(2) = 4
      fieldorder(3) = 4
 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptdeflev
c  
      write(3,27)
      write(*,*)'Testing ptdeflev '
      write(*,*)'================='
      write(3,*)'Testing ptdeflev '
      write(3,*)'================='

      status = ptdeflev(ptid, "Sensor", fldlist, fieldtype,
     1fieldorder)
      write(*,*)'      status = ptdeflev(ptid, "Sensor", fldlist, 
     1fieldtype,fieldorder)'
      write(*,*)'      Status returned by ptdeflev ',status
      write(3,*)'      status = ptdeflev(ptid, "Sensor", fldlist, 
     1fieldtype,fieldorder)'
      write(3,*)'      Status returned by ptdeflev ',status
 
      status = ptdetach(ptid)
      write(*,*)'      status = ptdetach(ptid)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'      status = ptdetach(ptid)'
      write(3,*)'      Status returned by ptdetach ',status
 
 
      ptid = ptattach(ptfid, "FixedBuoy Point")
      write(*,*)'      ptid = ptattach(ptfid, "FixedBuoy Point")'
      write(*,*)'      Point id returned by ptattach ',ptid
      write(3,*)'      ptid = ptattach(ptfid, "FixedBuoy Point")'
      write(3,*)'      Point id returned by ptattach ',ptid
 
 
 
      fldlist = "Label,Longitude,Latitude,DeployDate,ID"
 
      fieldtype(1) = DFNT_CHAR8
      fieldtype(2) = DFNT_FLOAT64
      fieldtype(3) = DFNT_FLOAT64
      fieldtype(4) = DFNT_INT32
      fieldtype(5) = DFNT_CHAR8
 
 
      fieldorder(1) = 8
      fieldorder(2) = 0
      fieldorder(3) = 0
      fieldorder(4) = 0
      fieldorder(5) = 1

      status = ptdeflev(ptid, "Desc-Loc", fldlist, fieldtype,
     1fieldorder)
      write(*,*)'      status = ptdeflev(ptid, "Desc-Loc", 
     1fldlist, fieldtype,fieldorder)'
      write(*,*)'      Status returned by ptdeflev ',status
      write(3,*)'      status = ptdeflev(ptid, "Desc-Loc", 
     1fldlist, fieldtype,fieldorder)'
      write(3,*)'      Status returned by ptdeflev ',status
 
 
 
      fldlist = "Time,Rainfall,Temperature,ID"
 
      fieldtype(1) = DFNT_FLOAT64
      fieldtype(2) = DFNT_FLOAT32
      fieldtype(3) = DFNT_FLOAT32
      fieldtype(4) = DFNT_CHAR8
 
      fieldorder(1) = 0
      fieldorder(2) = 0
      fieldorder(3) = 0
      fieldorder(4) = 1
 
      status = ptdeflev(ptid, "Observations", fldlist,
     1fieldtype, fieldorder)
      write(*,*)'       status = ptdeflev(ptid, "Observations", 
     1fldlist,fieldtype, fieldorder)'
      write(*,*)'       Status returned by ptdeflev ',status
      write(3,*)'       status = ptdeflev(ptid, "Observations", 
     1fldlist,fieldtype, fieldorder)'
      write(3,*)'       Status returned by ptdeflev ',status
 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptdeflink
c
      write(3,27)
      write(*,*)'Testing ptdeflink '
      write(*,*)'================='
      write(3,*)'Testing ptdeflink '
      write(3,*)'================='

      status = ptdeflink(ptid, "Desc-Loc", "Observations", "ID")
      write(*,*)'       status = ptdeflink(ptid, "Desc-Loc", 
     1"Observations", "ID")'
      write(*,*)'       Status returned by ptdeflink ',status
      write(3,*)'       status = ptdeflink(ptid, "Desc-Loc", 
     1"Observations", "ID")'
      write(3,*)'       Status returned by ptdeflink ',status

 
      status = ptdetach(ptid)
      write(*,*)'       status = ptdetach(ptid)'
      write(*,*)'       Status returned by ptdetach ',status
      write(3,*)'       status = ptdetach(ptid)'
      write(3,*)'       Status returned by ptdetach ',status
 

      ptid = ptattach(ptfid, "FloatBuoy Point")
      write(*,*)'       ptid = ptattach(ptfid, "FloatBuoy Point")'
      write(*,*)'       Point id returned by ptattach ',ptid
      write(3,*)'       ptid = ptattach(ptfid, "FloatBuoy Point")'
      write(3,*)'       Point id returned by ptattach ',ptid
 
 
c      Define Description Level */
 
      fldlist = "Label,DeployDate,Weight,ID"

      fieldtype(1) = DFNT_CHAR8
      fieldtype(2) = DFNT_INT32
      fieldtype(3) = DFNT_INT16
      fieldtype(4) = DFNT_CHAR8

      fieldorder(1) = 8
      fieldorder(2) = 0
      fieldorder(3) = 0
      fieldorder(4) = 1

 
      status = ptdeflev(ptid, "Description", fldlist,
     1fieldtype, fieldorder)
      write(*,*)'       status = ptdeflev(ptid, "Description", 
     1fldlist,fieldtype, fieldorder)'
      write(*,*)'       Status returned by ptdeflev ',status
      write(3,*)'       status = ptdeflev(ptid, "Description", 
     1fldlist,fieldtype, fieldorder)'
      write(3,*)'       Status returned by ptdeflev ',status
 
 
c       Define Data Level
 
      fldlist = "Time,Longitude,Latitude,Rainfall,Temperature,ID"
 
      fieldtype(1) = DFNT_FLOAT64
      fieldtype(2) = DFNT_FLOAT64
      fieldtype(3) = DFNT_FLOAT64
      fieldtype(4) = DFNT_FLOAT32
      fieldtype(5) = DFNT_FLOAT32
      fieldtype(6) = DFNT_CHAR8
 
      fieldorder(1) = 0
      fieldorder(2) = 0
      fieldorder(3) = 0
      fieldorder(4) = 0
      fieldorder(5) = 0
      fieldorder(6) = 1
 
      status = ptdeflev(ptid, "Measurements", fldlist,
     1fieldtype, fieldorder)
      write(*,*)'       status = ptdeflev(ptid, "Measurements", 
     1fldlist,fieldtype, fieldorder)'
      write(*,*)'       Status returned by ptdeflev ',status
      write(3,*)'       status = ptdeflev(ptid, "Measurements", 
     1fldlist,fieldtype, fieldorder)'
      write(3,*)'       Status returned by ptdeflev ',status
 

      status = ptdeflink(ptid, "Description", "Measurements", "ID")
      write(*,*)'       status = ptdeflink(ptid, "Description", 
     1"Measurements", "ID")'
      write(*,*)'       Status returned by ptdeflink ',status
      write(3,*)'       status = ptdeflink(ptid, "Description", 
     1"Measurements", "ID")'
      write(3,*)'       Status returned by ptdeflink ',status
 
      status = ptdetach(ptid)
      write(*,*)'       status = ptdetach(ptid)'
      write(*,*)'       Status returned by ptdetach ',status
      write(3,*)'       status = ptdetach(ptid)'
      write(3,*)'       Status returned by ptdetach ',status
 
 
      write(*,*)' '
      status = ptclose(ptfid)
      write(*,*)'       status = ptclose(ptfid)'
      write(*,*)'       Status returned by ptclose ',status
      write(3,*)'       status = ptclose(ptfid)'
      write(3,*)'       Status returned by ptclose ',status
 

 
      write(*,*)' '
      ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)
      write(*,*)'       ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)'
      write(*,*)'       Point file id returned by ptopen ',ptfid
      write(3,*)'       ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)'
      write(3,*)'       Point file id returned by ptopen ',ptfid
 
      write(*,*)' '
      ptid = ptattach(ptfid, "Simple Point")
      write(*,*)'       ptid = ptattach(ptfid, "Simple Point")'
      write(*,*)'       Point id returned by ptattach ',ptid
      write(3,*)'       ptid = ptattach(ptfid, "Simple Point")'
      write(3,*)'       Point id returned by ptattach ',ptid

      open(unit=1, file='simple.txt',STATUS='OLD')

      n = 0
      pntr = 1

      do 10 i=1,1000
 
           read(1, *, end=100)  time, conc(1), conc(2), conc(3),
     1                            conc(4), spc
           n = n + 1

           ctime = transfer(time, ctime)
           cconc = transfer(conc, cconc)

 
           buffer(pntr:pntr+8) = ctime
           pntr = pntr + 8
           buffer(pntr:pntr+4*4) = cconc
           pntr = pntr + 4*4
           buffer(pntr:pntr+4) = spc
           pntr = pntr + 4
10      continue
 
100     close(unit=1)
 

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptwrlev
c
      write(3,27)
      write(*,*)'Testing ptwrlev '
      write(*,*)'================='
      write(3,*)'Testing ptwrlev '
      write(3,*)'================='

      status = ptwrlev(ptid, 0, n, buffer)
      write(*,*)'         status = ptwrlev(ptid, 0, n, buffer)'
      write(*,*)'         Status returned by ptwrlev ',status
      write(3,*)'         status = ptwrlev(ptid, 0, n, buffer)'
      write(3,*)'         Status returned by ptwrlev ',status

      status = ptdetach(ptid)
      write(*,*)'         status = ptdetach(ptid)'
      write(*,*)'         Status returned by ptdetach ',status
      write(3,*)'         status = ptdetach(ptid)'
      write(3,*)'         Status returned by ptdetach ',status
   
 
      ptid = ptattach(ptfid, "FixedBuoy Point")
      write(*,*)'        ptid = ptattach(ptfid, "FixedBuoy Point")'
      write(*,*)'        Point id returned by ptattach ',ptid
      write(3,*)'        ptid = ptattach(ptfid, "FixedBuoy Point")'
      write(3,*)'        Point id returned by ptattach ',ptid

      open(unit=1, file='fixedBuoy0.txt', STATUS='OLD')
 
      n = 0
      pntr = 1
      do 20 i=1,1000
 
           read(1, *, end=200)  desc, lon, lat, date, id
 
           n = n + 1

           clon = transfer(lon, clon)
           clat = transfer(lat, clat)
           cdate = transfer(date, cdate)

 
           buffer(pntr:pntr+8) = desc
           pntr = pntr + 8
           buffer(pntr:pntr+8) = clon
           pntr = pntr + 8
           buffer(pntr:pntr+8) = clat
           pntr = pntr + 8
           buffer(pntr:pntr+4) = cdate
           pntr = pntr + 4
           buffer(pntr:pntr+1) = id
           pntr = pntr + 1
 20   continue
 
 200  close(unit=1)
 
   
      status = ptwrlev(ptid, 0, n, buffer)
      write(*,*)'        status = ptwrlev(ptid, 0, n, buffer)'
      write(*,*)'        Status returned by ptwrlev ',status
      write(3,*)'        status = ptwrlev(ptid, 0, n, buffer)'
      write(3,*)'        Status returned by ptwrlev ',status
 
 
      open(unit=1, file='fixedBuoy1.txt', STATUS='OLD')
 
      n = 0
      pntr = 1
      do 30 i=1,1000
 
           read(1, *, end=300) time, rain, temp, id
 
           n = n + 1

           ctime = transfer(time, ctime)
           crain = transfer(rain, crain)
           ctemp = transfer(temp, ctemp)

 
           buffer(pntr:pntr+8) = ctime
           pntr = pntr + 8
           buffer(pntr:pntr+4) = crain
           pntr = pntr + 4
           buffer(pntr:pntr+4) = ctemp
           pntr = pntr + 4
           buffer(pntr:pntr+1) = id
           pntr = pntr + 1
 30   continue
 
 300  close(unit=1)
 
      status = ptwrlev(ptid, 1, n, buffer)
      write(*,*)'          status = ptwrlev(ptid, 1, n, buffer)'
      write(*,*)'          Status returned by ptwrlev ',status
      write(3,*)'          status = ptwrlev(ptid, 1, n, buffer)'
      write(3,*)'          Status returned by ptwrlev ',status

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptwrattr
c
      write(3,27)
      write(*,*)'Testing ptwrattr '
      write(*,*)'================='
      write(3,*)'Testing ptwrattr '
      write(3,*)'================='

      f32 = -7.5
      status = ptwrattr(ptid, "float32", 5, 1, f32)
      write(*,*)'         status = ptwrattr(ptid, "float32", 5, 1, f32)'
      write(*,*)'         Status returned by ptwrattr ', status
      write(3,*)'         status = ptwrattr(ptid, "float32", 5, 1, f32)'
      write(3,*)'         Status returned by ptwrattr ', status
 
      status = ptdetach(ptid)
      write(*,*)'       status = ptdetach(ptid)'
      write(*,*)'       Status returned by ptdetach ',status
      write(3,*)'       status = ptdetach(ptid)'
      write(3,*)'       Status returned by ptdetach ',status
 
 
      ptid = ptattach(ptfid, "FloatBuoy Point")
      write(*,*)'      ptid = ptattach(ptfid, "FloatBuoy Point")'
      write(*,*)'      Point id returned by ptattach ',ptid
      write(3,*)'      ptid = ptattach(ptfid, "FloatBuoy Point")'
      write(3,*)'      Point id returned by ptattach ',ptid
 
      open(unit=1, file='floatBuoy0.txt', STATUS='OLD')
 
      n = 0
      pntr = 1
      do 40 i=1,1000
 
         read(1, *, end=400)  desc, date, wgt, id
           write(*,*) desc,date,wgt,id
           n = n + 1

           cdate = transfer(date, cdate)
           cwgt = transfer(wgt, cwgt)

 
           buffer(pntr:pntr+8) = desc
           pntr = pntr + 8
           buffer(pntr:pntr+4) = cdate
           pntr = pntr + 4
           buffer(pntr:pntr+2) = cwgt
           pntr = pntr + 2
           buffer(pntr:pntr+1) = id
           pntr = pntr + 1
 40   continue
 
 400  close(unit=1)
 
   
      status = ptwrlev(ptid, 0, n, buffer)
      write(*,*)'      status = ptwrlev(ptid, 0, n, buffer)'
      write(*,*)'      Status returned by ptwrlev ',status
      write(3,*)'      status = ptwrlev(ptid, 0, n, buffer)'
      write(3,*)'      Status returned by ptwrlev ',status
 
      open(unit=1, file='floatBuoy1.txt', STATUS='OLD')
 
      n = 0
      pntr = 1
      do 50 i=1,1000
 
           read(1, *, end=500) time, lon, lat, rain, temp, id
 
           n = n + 1

           ctime = transfer(time, ctime)
           clon = transfer(lon, clon)
           clat = transfer(lat, clat)
           crain = transfer(rain, crain)
           ctemp = transfer(temp, ctemp)

 
           buffer(pntr:pntr+8) = ctime
           pntr = pntr + 8
           buffer(pntr:pntr+8) = clon
           pntr = pntr + 8
           buffer(pntr:pntr+8) = clat
           pntr = pntr + 8
           buffer(pntr:pntr+4) = crain
           pntr = pntr + 4
           buffer(pntr:pntr+4) = ctemp
           pntr = pntr + 4
           buffer(pntr:pntr+1) = id
           pntr = pntr + 1
 50   continue
 
 500  close(unit=1)
 
      status = ptwrlev(ptid, 1, n, buffer)
      write(*,*)'        status = ptwrlev(ptid, 1, n, buffer)'
      write(*,*)'        Status returned by ptwrlev ',status
      write(3,*)'        status = ptwrlev(ptid, 1, n, buffer)'
      write(3,*)'        Status returned by ptwrlev ',status

      status = ptdetach(ptid)
      write(*,*)'       status = ptdetach(ptid)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'       status = ptdetach(ptid)'
      write(3,*)'      Status returned by ptdetach ',status
 
 
      status = ptclose(ptfid)
      write(*,*)'      status = ptclose(ptfid)'
      write(*,*)'      Status returned by ptclose ',status
      write(3,*)'      status = ptclose(ptfid)'
      write(3,*)'      Status returned by ptclose ',status

 
      ptfid = ptopen("Pointf_Test.hdf", DFACC_READ)
      write(*,*)'        ptfid = ptopen("Pointf_Test.hdf", DFACC_READ)'
      write(*,*)'        Point id returned by ptopen ',ptfid
      write(3,*)'        ptfid = ptopen("Pointf_Test.hdf", DFACC_READ)'
      write(3,*)'        Point id returned by ptopen ',ptfid

      ptid = ptattach(ptfid, "Simple Point")
      write(*,*)'       ptid = ptattach(ptfid, "Simple Point")'
      write(*,*)'       Point id returned by ptattach ',ptid
      write(3,*)'       ptid = ptattach(ptfid, "Simple Point")'
      write(3,*)'       Point id returned by ptattach ',ptid
 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptlevidx
c
      write(3,27)
      write(*,*)'Testing ptlevidx '
      write(*,*)'================='
      write(3,*)'Testing ptlevidx '
      write(3,*)'================='

      levndx = ptlevidx(ptid, "Sensor")
      write(*,*)'     levndx = ptlevidx(ptid, "Sensor")'
      write(*,*)'     Level index of Sensor ',levndx
      write(3,*)'     levndx = ptlevidx(ptid, "Sensor")'
      write(3,*)'     Level index of Sensor ',levndx

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptlevinfo
c
      write(3,27)
      write(*,*)'Testing ptlevinfo '
      write(*,*)'================='
      write(3,*)'Testing ptlevinfo '
      write(3,*)'================='

      nlevels = ptlevinfo(ptid, 0, fldlist, fldtype, fldorder)
      write(*,*)'      nlevels = ptlevinfo(ptid, 0, fldlist, 
     1fldtype, fldorder)'
      write(*,*)'      Number of fields in level 0 ',status
      write(*,*)'      List of fields in level 0 ',fldlist
      write(3,*)'      Number of fields in level 0 ',status
      write(3,*)'      List of fields in level 0 ',fldlist
      do 7 i=1,nlevels
         write(*,*)' Number type of field ',fldtype(i)
         write(*,*)' Order of field ', fldorder(i)
         write(3,*)' Number type of field ',fldtype(i)
         write(3,*)' Order of field ', fldorder(i)
 7    continue

      write(3,*)'      status = ptlevinfo(ptid, 0, fldlist, 
     1fldtype, fldorder)'
      write(3,*)'      Status returned by ptlevinfo ',status

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptnrecs
c
      write(3,27)
      write(*,*)'Testing ptnrecs '
      write(*,*)'================='
      write(3,*)'Testing ptnrecs '
      write(3,*)'================='

      n = ptnrecs(ptid, 0)
      write(*,*)'     n = ptnrecs(ptid, 0)'
      write(*,*)'     Number of records in level ',n
      write(3,*)'     n = ptnrecs(ptid, 0)'
      write(3,*)'     Number of records in level ',n
 
      do 5 i=1,n
         recs(i) = i - 1
 5    continue
 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptrdlev
c
      write(3,27)
      write(*,*)'Testing ptrdlev '
      write(*,*)'================='
      write(3,*)'Testing ptrdlev '
      write(3,*)'================='

      status = ptrdlev(ptid, 0, fldlist, n, recs, buffer)
      write(*,*)'      status = ptrdlev(ptid, 0, 
     1fldlist, n, recs, buffer)'
      write(*,*)'      Status returned by ptrdlev ',status
      write(3,*)'      status = ptrdlev(ptid, 0, 
     1fldlist, n, recs, buffer)'
      write(3,*)'      Status returned by ptrdlev ',status

      pntr = 1
      do 11 i=1,n
           ctime = buffer(pntr:pntr+8)
           pntr = pntr + 8
           cconc = buffer(pntr:pntr+4*4)
           pntr = pntr + 4*4
           spc = buffer(pntr:pntr+4)
           pntr = pntr + 4

           time = transfer(ctime, time)
           conc = transfer(cconc, conc)

           write(*,*) time, conc(1), conc(2), conc(3), conc(4), spc
           write(3,*) time, conc(1), conc(2), conc(3), conc(4), spc
11    continue
 
      status = ptdetach(ptid)
      write(*,*)'       status = ptdetach(ptid)'
      write(*,*)'       Status returned by ptdetach ',status
      write(3,*)'       status = ptdetach(ptid)'
      write(3,*)'       Status returned by ptdetach ',status
 
      ptid = ptattach(ptfid, "FixedBuoy Point")
      write(*,*)'       ptid = ptattach(ptfid, "FixedBuoy Point")'
      write(*,*)'       Point id returned by ptattach ',ptid
      write(3,*)'       ptid = ptattach(ptfid, "FixedBuoy Point")'
      write(3,*)'       Point id returned by ptattach ',ptid
 
      status = ptlevinfo(ptid, 0, fldlist, fldtype, fldorder)
      write(*,*)'    status = ptlevinfo(ptid, 0, fldlist, 
     1fldtype, fldorder)'
      write(*,*)'    Status returned by ptlevinfo ',status
      write(3,*)'    status = ptlevinfo(ptid, 0, fldlist, 
     1fldtype, fldorder)'
      write(3,*)'    Status returned by ptlevinfo ',status

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptsizeof
c
      write(3,27)
      write(*,*)'Testing ptsizeof '
      write(*,*)'================='
      write(3,*)'Testing ptsizeof '
      write(3,*)'================='

      fldsz = ptsizeof(ptid, fldlist, fldlevels)
      write(*,*)'       fldsz = ptsizeof(ptid, fldlist, fldlevels)'
      write(*,*)'       fieldsize ', fldsz
      write(*,*)'       Field list ',fldlist
      write(*,*)'       Field levels ',fldlevels
      write(3,*)'       fldsz = ptsizeof(ptid, fldlist, fldlevels)'
      write(3,*)'       fieldsize ', fldsz
      write(3,*)'       Field list ',fldlist
      write(3,*)'       Field levels ',fldlevels

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptflinkinfo
c
      write(3,27)
      write(*,*)'Testing ptflinkinfo '
      write(*,*)'================='
      write(3,*)'Testing ptflinkinfo '
      write(3,*)'================='

      status = ptflinkinfo(ptid, 0, linkfield)
      write(*,*)'       status = ptflinkinfo(ptid, 0, linkfield)'
      write(*,*)'       Status returned by ptflinkinfo ', status
      write(*,*)'The link field to the following level ',linkfield
      write(3,*)'       status = ptflinkinfo(ptid, 0, linkfield)'
      write(3,*)'       Status returned by ptflinkinfo ', status
      write(3,*)'The link field to the following level ',linkfield

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptblinkinfo
c
      write(3,27)
      write(*,*)'Testing ptblinkinfo '
      write(*,*)'================='
      write(3,*)'Testing ptblinkinfo '
      write(3,*)'================='

      status = ptblinkinfo(ptid, 1, linkfield)
      write(*,*)'       status = ptblinkinfo(ptid, 1, linkfield)'
      write(*,*)'       Status returned by ptblinkinfo ', status
      write(*,*)'The link field to the previous level ',linkfield
      write(3,*)'       status = ptblinkinfo(ptid, 1, linkfield)'
      write(3,*)'       Status returned by ptblinkinfo ', status
      write(3,*)'The link field to the previous level ',linkfield

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptnlevs
c
      write(3,27)
      write(*,*)'Testing ptnlevs '
      write(*,*)'================='
      write(3,*)'Testing ptnlevs '
      write(3,*)'================='

      nlevels = ptnlevs(ptid)
      write(*,*)'       nlevels = ptnlevs(ptid)'
      write(*,*)'       Number of levels ',nlevels
      write(3,*)'       nlevels = ptnlevs(ptid)'
      write(3,*)'       Number of levels ',nlevels

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptnflds
c
      write(3,27)
      write(*,*)'Testing ptnflds '
      write(*,*)'================='
      write(3,*)'Testing ptnflds '
      write(3,*)'================='

      nflds = ptnflds(ptid,1, strbufsize)
      write(*,*)'       nflds = ptnflds(ptid,1, strbufsize)'
      write(*,*)'       Number of fields ',nflds
      write(*,*)'       Size in bytes of field list ',strbufsize
      write(3,*)'       nflds = ptnflds(ptid,1, strbufsize)'
      write(3,*)'       Number of fields ',nflds
      write(3,*)'       Size in bytes of field list ',strbufsize
  
      n = 2
      recs(1) = 0
      recs(2) = 2
 
      write(*,*)' '
      write(3,*)' '
c Test Case -- ptrdlev
c
      write(3,27)
      write(*,*)'Testing ptrdlev '
      write(*,*)'================='
      write(3,*)'Testing ptrdlev '
      write(3,*)'================='

      pntr = 1
      status = ptrdlev(ptid, 0, fldlist, n, recs, buffer)
      write(*,*)'     status = ptrdlev(ptid, 0, fldlist, 
     1n, recs, buffer)'
      write(*,*)'     Status returned by ptrdlev ',status
      write(3,*)'     status = ptrdlev(ptid, 0, fldlist, 
     1n, recs, buffer)'
      write(3,*)'     Status returned by ptrdlev ',status
 
      do 21 i=1,n
           desc = buffer(pntr:pntr+8)
           pntr = pntr + 8
           clon = buffer(pntr:pntr+8)
           pntr = pntr + 8
           clat = buffer(pntr:pntr+8)
           pntr = pntr + 8
           cdate = buffer(pntr:pntr+4)
           pntr = pntr + 4
           id = buffer(pntr:pntr+1)
           pntr = pntr + 1

           lon = transfer(clon, lon)
           lat = transfer(clat, lat)
           date = transfer(cdate, date)

           write(*,*) desc, lon, lat, date, id(1:1)
           write(3,*) desc, lon, lat, date, id(1:1)
 21   continue

      status = ptlevinfo(ptid, 1, fldlist, fldtype, fldorder)
      write(*,*)'      status = ptlevinfo(ptid, 1, fldlist, 
     1fldtype, fldorder)'
      write(*,*)'      Status returned by ptlevinfo ',status
      write(3,*)'      status = ptlevinfo(ptid, 1, fldlist, 
     1fldtype, fldorder)'
      write(3,*)'      Status returned by ptlevinfo ',status

      n = ptnrecs(ptid, 1)
      write(*,*)'      n = ptnrecs(ptid, 1)'
      write(*,*)'      Number of records ',n
      write(3,*)'      n = ptnrecs(ptid, 1)'
      write(3,*)'      Number of records ',n
 
 
      do 31 i=1,n
 
           recs(1) = i - 1
           status = ptrdlev(ptid, 1, fldlist, 1, recs, buffer)
 
           pntr = 1
 
           ctime = buffer(pntr:pntr+8)
           pntr = pntr + 8
           crain = buffer(pntr:pntr+4)
           pntr = pntr + 4
           ctemp = buffer(pntr:pntr+4)
           pntr = pntr + 4
           id = buffer(pntr:pntr+1)
           pntr = pntr + 1

           time = transfer(ctime, time)
           rain = transfer(crain, rain)
           temp = transfer(ctemp, temp)

           write(*,*) time, rain, temp, '  ', id(1:1)
           write(3,*) time, rain, temp, '  ', id(1:1)
 31   continue

      write(*,*)' '
      write(3,*)' '
c Test Case -- ptinqattrs
c
      write(3,27)
      write(*,*)'Testing ptinqattrs '
      write(*,*)'================='
      write(3,*)'Testing ptinqattrs '
      write(3,*)'================='

      nmattrs = ptinqattrs(ptid, attrlist,strbufsize)
      write(*,*)'   nmattrs = ptinqattrs(ptid, attrlist,strbufsize)'
      write(*,*)'   Number of attributes ',nmattrs
      write(*,*)'   Attribute list ',attrlist
      write(3,*)'   nmattrs = ptinqattrs(ptid, attrlist,strbufsize)'
      write(3,*)'   Number of attributes ',nmattrs
      write(3,*)'   Attribute list ',attrlist

c Test Case -- ptrdattr
c
      write(3,27)
      write(*,*)'Testing ptrdattr '
      write(*,*)'================='
      write(3,*)'Testing ptrdattr '
      write(3,*)'================='

      status = ptrdattr(ptid, "float32", b32)
      write(*,*)'      status = ptrdattr(ptid, "float32", b32)'
      write(*,*)'      Status returned by ptrdattr ',status
      write(*,*) 'b32 = ', b32
      write(3,*)'      status = ptrdattr(ptid, "float32", b32)'
      write(3,*)'      Status returned by ptrdattr ',status
      write(3,*) 'b32 = ', b32

c Test Case -- ptattrinfo
c
      write(3,27)
      write(*,*)'Testing ptattrinfo '
      write(*,*)'================='
      write(3,*)'Testing ptattrinfo '
      write(3,*)'================='

      status = ptattrinfo(ptid, "float32", nt, sz)
      write(*,*)'      status = ptattrinfo(ptid, "float32", nt, sz)'
      write(*,*)'      Status returned by ptattrinfo ',status
      write(*,*) 'nt = ', nt
      write(*,*) 'sz = ', sz
      write(3,*)'      status = ptattrinfo(ptid, "float32", nt, sz)'
      write(3,*)'      Status returned by ptattrinfo ',status
      write(3,*) 'nt = ', nt
      write(3,*) 'sz = ', sz
 
      status = ptdetach(ptid)
      write(*,*)'       status = ptdetach(ptid)'
      write(*,*)'       Status returned by ptdetach ',status
      write(3,*)'       status = ptdetach(ptid)'
      write(3,*)'       Status returned by ptdetach ',status

      status = ptclose(ptfid)
      write(*,*)'       status = ptclose(ptfid)'
      write(*,*)'       Status returned by ptclose ',status
      write(3,*)'       status = ptclose(ptfid)'
      write(3,*)'       Status returned by ptclose ',status


      ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)
      write(*,*)'     ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)'
      write(*,*)'     Point id returned by ptopen ',ptfid
      write(3,*)'     ptfid = ptopen("Pointf_Test.hdf", DFACC_RDWR)'
      write(3,*)'     Point id returned by ptopen ',ptfid

      ptid1 = ptattach(ptfid, "Simple Point")
      write(*,*)'      ptid1 = ptattach(ptfid, "Simple Point")'
      write(*,*)'      Point id returned by ptattach ',ptid1
      write(3,*)'      ptid1 = ptattach(ptfid, "Simple Point")'
      write(3,*)'      Point id returned by ptattach ',ptid1

      ptid2 = ptattach(ptfid, "FixedBuoy Point")
      write(*,*)'      ptid2 = ptattach(ptfid, "FixedBuoy Point")'
      write(*,*)'      Point id returned by ptattach ',ptid2
      write(3,*)'      ptid2 = ptattach(ptfid, "FixedBuoy Point")'
      write(3,*)'      Point id returned by ptattach ',ptid2

      f64 = 43.2
      c8 = transfer(f64, c8)
      datbuf(1:8) = c8
      recs(1) = 1

c Test Case -- ptuplev
c
      write(3,27)
      write(*,*)'Testing ptuplev '
      write(*,*)'================='
      write(3,*)'Testing ptuplev '
      write(3,*)'================='

      status = ptuplev(ptid2, 0, "Longitude", 1, recs, datbuf)
      write(*,*)'      status = ptuplev(ptid2, 0, "Longitude", 
     11, recs, datbuf)'
      write(*,*)'      Status returned by ptuplev ',status
      write(3,*)'      status = ptuplev(ptid2, 0, "Longitude", 
     11, recs, datbuf)'
      write(3,*)'      Status returned by ptuplev ',status

      datbuf(1:1) = 'F'
      recs(1) = 0
      status = ptuplev(ptid2, 0, "ID", 1, recs, datbuf)
      write(*,*)'     status = ptuplev(ptid2, 0, "ID", 1, 
     1recs, datbuf)'
      write(*,*)'     Status returned by ptuplev ',status
      write(3,*)'     status = ptuplev(ptid2, 0, "ID", 1, 
     1recs, datbuf)'
      write(3,*)'     Status returned by ptuplev ',status

c Test Case -- ptgetrecnums
c
      write(3,27)
      write(*,*)'Testing ptgetrecnums '
      write(*,*)'================='
      write(3,*)'Testing ptgetrecnums '
      write(3,*)'================='

      inlevel = 0
      outlevel = 1
      nrec = 1
      status = ptgetrecnums(ptid2, inlevel, outlevel, nrec, recs, 
     1outnrec, outrecs)
      write(*,*)'      status = ptgetrecnums(ptid2, inlevel, outlevel, 
     1nrec, recs,outnrec, outrecs)'
      write(*,*)'      Status returned by ptgetrecnums ',status
      write(3,*)'      status = ptgetrecnums(ptid2, inlevel, outlevel, 
     1nrec, recs,outnrec, outrecs)'
      write(3,*)'      Status returned by ptgetrecnums ',status

      write(*,*) outnrec
      write(3,*) outnrec

      do 71 i=1,outnrec
         datbuf(i:i) = 'F'
 71   continue

      status = ptuplev(ptid2, outlevel, "ID", outnrec, outrecs, 
     1datbuf)
      write(*,*)'       status = ptuplev(ptid2, outlevel, "ID", 
     1outnrec, outrecs,datbuf)'
      write(*,*)'       Status returned by ptuplev ',status
      write(3,*)'       status = ptuplev(ptid2, outlevel, "ID", 
     1outnrec, outrecs,datbuf)'
      write(3,*)'       Status returned by ptuplev ',status

      status = ptdetach(ptid1)
      write(*,*)'      status = ptdetach(ptid1)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'      status = ptdetach(ptid1)'
      write(3,*)'      Status returned by ptdetach ',status

      status = ptdetach(ptid2)
      write(*,*)'      status = ptdetach(ptid2)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'      status = ptdetach(ptid2)'
      write(3,*)'      Status returned by ptdetach ',status


      status = ptclose(ptfid)
      write(*,*)'      status = ptclose(ptfid)'
      write(*,*)'      Status returned by ptclose ',status
      write(3,*)'      status = ptclose(ptfid)'
      write(3,*)'      Status returned by ptclose ',status


      ptfid = ptopen("Pointf_Test.hdf", DFACC_READ)
      write(*,*)'    ptfid = ptopen("Pointf_Test.hdf", DFACC_READ)'
      write(*,*)'    Point id returned by ptopen ',ptfid
      write(3,*)'    ptfid = ptopen("Pointf_Test.hdf", DFACC_READ)'
      write(3,*)'    Point id returned by ptopen ',ptfid

c Test Case -- ptinqpoint
c
      write(3,27)
      write(*,*)'Testing ptinqpoint '
      write(*,*)'================='
      write(3,*)'Testing ptinqpoint '
      write(3,*)'================='

      npoint = ptinqpoint("Pointf_Test.hdf",ptlist,strbufsize)
      write(*,*)'  Number of points in file ',npoint
      write(*,*)'  List of points in file ',ptlist
      write(3,*)'  Number of points in file ',npoint
      write(3,*)'  List of points in file ',ptlist

      ptid = ptattach(ptfid, "FloatBuoy Point")
      write(*,*)'     ptid = ptattach(ptfid, "FloatBuoy Point")'
      write(*,*)'     Point id returned by ptattach ',ptid
      write(3,*)'     ptid = ptattach(ptfid, "FloatBuoy Point")'
      write(3,*)'     Point id returned by ptattach ',ptid

c Test Case -- ptdefboxreg
c
      write(3,27)
      write(*,*)'Testing ptdefboxreg '
      write(*,*)'================='
      write(3,*)'Testing ptdefboxreg '
      write(3,*)'================='

      cornerlon(1) = -145.
      cornerlat(1) = -15.
      cornerlon(2) = -135.
      cornerlat(2) = 8.

      regionid = ptdefboxreg(ptid, cornerlon, cornerlat)
      write(*,*)'      regionid = ptdefboxreg(ptid, 
     1cornerlon, cornerlat)'
      write(*,*)'      Region id returned by ptdefboxreg ',regionid
      write(3,*)'      regionid = ptdefboxreg(ptid, 
     1cornerlon, cornerlat)'
      write(3,*)'      Region id returned by ptdefboxreg ',regionid

c Test Case -- ptreginfo
c
      write(3,27)
      write(*,*)'Testing ptreginfo '
      write(*,*)'================='
      write(3,*)'Testing ptreginfo '
      write(3,*)'================='

      level = 1
      status = ptreginfo(ptid, regionid, level, 
     1"Longitude,Latitude", size)
      write(*,*)'       status = ptreginfo(ptid, regionid, level,
     1"Longitude,Latitude", size)'
      write(*,*)'       Status returned by ptreginfo ',status
      write(3,*)'       status = ptreginfo(ptid, regionid, level,
     1"Longitude,Latitude", size)'
      write(3,*)'       Status returned by ptreginfo ',status

c Test Case -- ptextreg
c
      write(3,27)
      write(*,*)'Testing ptextreg '
      write(*,*)'================='
      write(3,*)'Testing ptextreg '
      write(3,*)'================='

      status = ptextreg(ptid, regionid, level, 
     1"Longitude,Latitude", dtbuf)
      write(*,*)'    status = ptextreg(ptid, regionid, level,
     1"Longitude,Latitude", dtbuf)'
      write(*,*)'    Status returned by ptextreg ',status
      write(3,*)'    status = ptextreg(ptid, regionid, level,
     1"Longitude,Latitude", dtbuf)'
      write(3,*)'    Status returned by ptextreg ',status

      do 81 j = 1,size/16
         write(*,*) j, dtbuf(2*j-1),dtbuf(2*j)
         write(3,*) j, dtbuf(2*j-1),dtbuf(2*j)
 81   continue
      

c Test Case -- ptdeftmeper
c
      write(3,27)
      write(*,*)'Testing ptdeftmeper '
      write(*,*)'================='
      write(3,*)'Testing ptdeftmeper '
      write(3,*)'================='

      starttime = 35208757.6d0
      stoptime = 35984639.2d0
    
      periodid = ptdeftmeper(ptid, starttime, stoptime)
      write(*,*)'    periodid = ptdeftmeper(ptid, starttime, stoptime)'
      write(*,*)'    Period id returned by ptdeftmeper ',periodid
      write(3,*)'    periodid = ptdeftmeper(ptid, starttime, stoptime)'
      write(3,*)'    Period id returned by ptdeftmeper ',periodid

c Test Case -- ptperinfo
c
      write(3,27)
      write(*,*)'Testing ptperinfo '
      write(*,*)'================='
      write(3,*)'Testing ptperinfo '
      write(3,*)'================='

      level = 1
      status = ptperinfo(ptid, periodid, level, "Time", size)
      write(*,*)'    status = ptperinfo(ptid, periodid, level, 
     1"Time", size)'
      write(*,*)'    Status returned by ptperinfo ',status
      write(*,*)'    Size of region in bytes ',size
      write(3,*)'    status = ptperinfo(ptid, periodid, level, 
     1"Time", size)'
      write(3,*)'    Status returned by ptperinfo ',status
      write(3,*)'    Size of region in bytes ',size

c Test Case -- ptextper
c
      write(3,27)
      write(*,*)'Testing ptextper '
      write(*,*)'================='
      write(3,*)'Testing ptextper '
      write(3,*)'================='

      status = ptextper(ptid, periodid, level, "Time", dtbuf)
      write(*,*)'    status = ptextper(ptid, periodid, level, 
     1"Time", dtbuf)'
      write(*,*)'    Status returned by ptextper ',status
      write(3,*)'    status = ptextper(ptid, periodid, level, 
     1"Time", dtbuf)'
      write(3,*)'    Status returned by ptextper ',status
     
      do 91 k=1,size/8
         write(*,*) k, dtbuf(k)
         write(3,*) k, dtbuf(k)
 91   continue
     
 

      status = ptdetach(ptid)
      write(*,*)'      status = ptdetach(ptid)'
      write(*,*)'      Status returned by ptdetach ',status
      write(3,*)'      status = ptdetach(ptid)'
      write(3,*)'      Status returned by ptdetach ',status

      status = ptclose(ptfid)
      write(*,*)'      status = ptclose(ptfid)'
      write(*,*)'      Status returned by ptclose ',status
      write(3,*)'      status = ptclose(ptfid)'
      write(3,*)'      Status returned by ptclose ',status


      close(unit=3)
   27 format('')
      stop
      end
