/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive;

public class Rowspan {

    public static final Rowspan RS_1 = new Rowspan(1);
    public static final Rowspan RS_2 = new Rowspan(2);
    public static final Rowspan RS_3 = new Rowspan(3);
    public static final Rowspan RS_4 = new Rowspan(4);
    public static final Rowspan RS_5 = new Rowspan(5);
    
    private int value = 1;

    public Rowspan() {
        this(1);
    }
    
    public Rowspan(int value) {
        
        if (value < 1) {
            value = 1;
        }
        
        this.value = value;
    }
    
    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }
    
}
