#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-sauna@example.com"
SENDER="mailto:paul.boddie@example.com"
RIVALSENDER="mailto:vincent.vole@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"
echo 'schedule_corrected_in_freebusy' > "$PREFS/$USER/scheduling_function"
echo '10,12,14,16,18:0,15,30,45' > "$PREFS/$USER/permitted_times"
echo 'PT60S' > "$PREFS/$USER/freebusy_offers"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-sauna-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-bad.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out0f.tmp \
|  grep -q "^20141126T151000Z${TAB}20141126T154500Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-bad.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:COUNTER' out1.tmp \
&& grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T161500' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out1f.tmp

   ! grep -q "^20141126T151500Z${TAB}20141126T154500Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
|  tee out1o.tmp \
|  grep -q "^20141126T151500Z${TAB}20141126T154500Z" \
&& echo "Success" \
|| echo "Failed"

# Present the response to the organiser.

  "$PERSON_SCRIPT" $ARGS < out1r.tmp 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER" \
>  out2f.tmp

   ! grep -q "^20141126T151000Z${TAB}20141126T154500Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event13@example.com" \
|  tee out2O.tmp \
|  grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T161000' \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "countered_object" "event13@example.com" "$USER" \
|  tee out2C.tmp \
|  grep -q 'DTSTART;TZID=Europe/Oslo.*:20141126T161500' \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "requests" \
|  tee out2r.tmp \
|  grep -q 'event13@example.com' \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event in the proposed period.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-rival.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$RIVALSENDER" "freebusy" \
>  out2R.tmp

   ! grep -q "^20141126T151000Z${TAB}20141126T154500Z" "out2R.tmp" \
&& grep -q "^20141126T153000Z${TAB}20141126T154500Z" "out2R.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-rival.txt" 2>> $ERROR \
| tee out3r.tmp \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out3.tmp \
&& echo "Success" \
|| echo "Failed"

# Present the response to the organiser.

  "$PERSON_SCRIPT" $ARGS < out3r.tmp 2>> $ERROR \
| tee out4r.tmp \
| "$SHOWMAIL" \
> out4.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$RIVALSENDER" "freebusy" \
>  out4R.tmp

   ! grep -q "^20141126T151000Z${TAB}20141126T154500Z" "out4R.tmp" \
&& grep -q "^20141126T153000Z${TAB}20141126T154500Z" "out4R.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$RIVALSENDER" "object" "event18@example.com" \
|  tee out4O.tmp \
|  grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' \
&& echo "Success" \
|| echo "Failed"

# Check the free/busy state of the resource so far.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-sauna-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151000Z/20141126T154500Z' out5.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T154500Z' out5.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T154500Z' out5.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule again in response to the counter-proposal.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-good.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out5f.tmp

   ! grep -q "^20141126T151000Z${TAB}20141126T154500Z" "out5f.tmp" \
&& ! grep -q "^20141126T151500Z${TAB}20141126T154500Z" "out5f.tmp" \
&& ! grep -q "^20141126T153000Z${TAB}20141126T154500Z" "out5f.tmp" \
&& echo "Success" \
|| echo "Failed"

   [ ! -e "$STORE/$SENDER/counters/objects/event13@example.com/$USER" ] \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "requests" \
>  out5r.tmp

   ! grep -q 'event13@example.com' "out5r.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-sauna-good.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REPLY' out6.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out6.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
|  tee out6f.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T154500Z" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_offers" \
>  out6o.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out6o.tmp" \
&& ! grep -q "^20141126T151500Z${TAB}20141126T154500Z" "out6o.tmp" \
&& ! grep -q "^20141126T153000Z${TAB}20141126T154500Z" "out6o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the response to the organiser.

  "$PERSON_SCRIPT" $ARGS < out6.tmp 2>> $ERROR \
| tee out7r.tmp \
| "$SHOWMAIL" \
> out7.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out7f.tmp

   grep -q "^20141126T150000Z${TAB}20141126T154500Z" "out7f.tmp" \
&& ! grep -q "^20141126T151000Z${TAB}20141126T154500Z" "out7f.tmp" \
&& ! grep -q "^20141126T151500Z${TAB}20141126T154500Z" "out7f.tmp" \
&& ! grep -q "^20141126T153000Z${TAB}20141126T154500Z" "out7f.tmp" \
&& echo "Success" \
|| echo "Failed"

   [ ! -e "$STORE/$SENDER/counters/objects/event13@example.com/$USER" ] \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "requests" \
>  out7r.tmp

   ! grep -q 'event13@example.com' "out7r.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the free/busy state of the resource again.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-sauna-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REPLY' out6.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T154500Z' out6.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151000Z/20141126T154500Z' out6.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T154500Z' out6.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T154500Z' out6.tmp \
&& echo "Success" \
|| echo "Failed"
