/*****************************************************************************
 Copyright (c) 2022, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* Vectors from https://github.com/google/wycheproof */
/* AES-CCM, 0.8r12 */
#include "aead_test.h"
const struct aead_test aes_ccm_test_json[] = {
        { 96, 128, 128, 1,
          "\xbe\xdc\xfb\x5a\x01\x1e\xbc\x84\x60\x0f\xcb\x29\x6c\x15\xaf\x0d",
          "\x43\x8a\x54\x7a\x94\xea\x88\xdc\xe4\x6c\x6c\x85", "", "", "",
          "\x25\xd1\xa3\x84\x95\xa7\xde\xa4\x5b\xda\x04\x97\x05\x62\x7d\x10", 1,
          0, 0 },
        { 96, 128, 128, 2,
          "\x38\x4e\xa4\x16\xac\x3c\x2f\x51\xa7\x6e\x7d\x82\x26\x34\x6d\x4e",
          "\xb3\x0c\x08\x47\x27\xad\x1c\x59\x2a\xc2\x1d\x12", "", "\x35",
          "\xd7",
          "\x6b\xe3\xfd\x13\xb7\x06\x5a\xfc\x19\xe3\xb8\xa3\xb9\x6b\x39\xfb", 1,
          0, 8 },
        { 96, 128, 128, 3,
          "\xca\xe3\x1c\xd9\xf5\x55\x26\xeb\x03\x82\x41\xfc\x44\xca\xc1\xe5",
          "\xb5\xe0\x06\xde\xd5\x53\x11\x0e\x6d\xc5\x65\x29", "",
          "\xd1\x09\x89\xf2\xc5\x2e\x94\xad",
          "\xe6\x4d\x0b\x64\xeb\xb3\x81\xec",
          "\x25\x40\x9c\x79\x5d\x49\x1d\x80\x4e\x58\x39\x17\x22\x7b\x73\xc7", 1,
          0, 64 },
        { 96, 128, 128, 4,
          "\xff\xdf\x42\x28\x36\x1e\xa1\xf8\x16\x58\x52\x13\x6b\x34\x80\xf7",
          "\x0e\x16\x66\xf2\xdc\x65\x2f\x77\x08\xfb\x8f\x0d", "",
          "\x25\xb1\x2e\x28\xac\x0e\xf6\xea\xd0\x22\x6a\x3b\x22\x88\xc8\x00",
          "\xaa\xf5\x96\xfa\x5b\x00\xaa\xac\x27\x70\x01\x46\xae\xc9\x32\xa9",
          "\x84\x8b\x67\x35\xd3\x2c\x96\xe4\xa0\x53\x2b\xcd\xfa\xf3\x35\x82", 1,
          0, 128 },
        { 96, 128, 128, 5,
          "\xc1\x5e\xd2\x27\xdd\x2e\x23\x7e\xcd\x08\x7e\xaa\xaa\xd1\x9e\xa4",
          "\x96\x5f\xf6\x64\x31\x16\xac\x14\x43\xa2\xde\xc7", "",
          "\xfe\xe6\x2f\xde\x97\x3f\xe0\x25\xad\x6b\x32\x2d\xcd\xf3\xc6\x3f"
          "\xc7",
          "\x03\x33\xdf\x2a\x86\xd7\xf0\x94\xdd\x8b\xce\x75\xda\x6c\x38\xc5"
          "\xc1",
          "\x41\x7d\xa2\x9d\xf8\x5a\x1d\x13\x4f\xee\xe8\xaa\x35\x56\x90\x81", 1,
          0, 136 },
        { 96, 128, 128, 6,
          "\xa8\xee\x11\xb2\x6d\x7c\xeb\x7f\x17\xea\xa1\xe4\xb8\x3a\x2c\xf6",
          "\xfb\xbc\x04\xfd\x6e\x02\x5b\x71\x93\xeb\x57\xf6", "",
          "\xc0\x8f\x08\x5e\x6a\x9e\x0e\xf3\x63\x62\x80\xc1\x1e\xcf\xad\xf0\xc1"
          "\xe7\x29\x19\xff\xc1\x7e\xaf",
          "\xfc\xaa\xa3\x8f\xed\xa3\xac\xa9\x75\xac\x76\x55\x3c\x3e\x7e\xf3\x6b"
          "\x88\x7a\x8c\x4d\x82\x41\xf9",
          "\xc2\xc6\xdc\xae\xae\xb9\xf3\x8a\x3a\x42\xd2\xf4\xe8\xa1\x7d\xe4", 1,
          0, 192 },
        { 96, 128, 128, 7,
          "\x16\x55\xbf\x66\x2f\x7e\xe6\x85\x61\x57\x01\xfd\x37\x79\xd6\x28",
          "\x42\xb5\x13\x88\xf6\xf9\x04\x7a\x2a\x99\x45\x75", "",
          "\x85\x7b\x2f\x6c\xd6\x08\xc9\xce\xa0\x24\x6c\x74\x0c\xaa\x4c\xa1\x9c"
          "\x5f\x1c\x7d\x71\xcb\x92\x73\xf0\xd8\xc8\xbb\x65\xb7\x0a",
          "\xb3\xfb\x66\xd3\xf2\xcb\x75\x90\xad\x5e\xf5\x60\x48\x13\xc1\x25\x02"
          "\x0e\xe3\xd7\x91\xcb\x0e\xc6\x7e\xb5\xeb\x86\x70\x9b\x6b",
          "\x15\x55\x77\xb9\x8a\x81\x1e\x45\x32\x46\x16\x04\x39\x97\xbc\x03", 1,
          0, 248 },
        { 96, 128, 128, 8,
          "\x3f\xd5\x07\x41\xec\x47\xdd\xbf\xc2\xfc\x09\x09\x75\xd1\x54\xf0",
          "\xee\xf1\xa6\xe6\x51\x32\x18\x52\xf0\xb2\x5a\x31", "",
          "\xd6\xf6\xa9\xa2\x4d\xb6\xa7\xa6\x17\x6d\x43\x62\x63\x9c\x4f\xd7\x7f"
          "\x70\xf3\xe0\x89\xdd\x94\x00\x86\xe1\x2a\x9b\xec\xba\xf9\x7f\x82",
          "\x53\x26\x94\xbb\x28\x51\xea\x7f\x3b\xdd\x37\xc4\xe8\x06\xbe\x5b\x95"
          "\x3e\xa7\x9d\x08\x10\x0e\x74\xaf\x3f\xa6\x7e\xca\x88\x90\xdb\x28",
          "\x9e\x1a\xce\xe6\x88\x84\x8b\xca\x45\x4c\x6d\x04\x75\x3d\x3c\x7d", 1,
          0, 264 },
        { 96, 128, 128, 9,
          "\x42\xe3\x8a\xbe\xf2\xdd\x75\x73\x24\x8c\x5a\xef\xb3\xec\xca\x54",
          "\x06\x4b\x3c\xfb\xe0\x4d\x94\xd4\xd5\xc1\x9b\x30", "",
          "\x2c\x76\x3b\x9e\xc8\x49\x03\xbc\xbb\x8a\xec\x15\xe6\x78\xa3\xa9\x55"
          "\xe4\x87\x0e\xdb\xf6\x2d\x9d\x3c\x81\xc4\xf9\xed\x61\x54\x87\x78\x75"
          "\x77\x9c\xa3\x3c\xce\x8f\x73\xa5\x5c\xa7\xaf\x1d\x8d\x81\x7f\xc6\xba"
          "\xac\x00\xef\x96\x2c\x5a\x0d\xa3\x39\xce\x81\x42\x7a\x3d\x59",
          "\x4c\xa0\x1b\x5b\x2a\x5e\x57\xbc\xc1\xa4\xb7\xf6\x3f\x04\x9d\xc4\x77"
          "\xe3\xee\x2e\x5c\x26\x8e\xfb\x34\x6f\xf9\x5b\x7d\xcd\x67\xf8\x6e\xd0"
          "\xf1\x1b\xb1\x7c\x1d\xd7\xfb\x51\x1d\x2f\x37\xb9\x68\x45\x50\xc0\xd8"
          "\x4b\xe0\xf1\x00\x30\xcc\xc4\xe0\xde\x5b\x74\xef\x92\xea\x54",
          "\xc5\xa5\x7d\xd6\xfa\x16\xaa\x9d\xe8\xde\x20\xe6\xbd\x32\x13\x96", 1,
          0, 528 },
        { 96, 128, 128, 10,
          "\x59\xab\x7e\xc1\xc0\x2b\xb2\x06\xaf\x5a\x91\x31\xf1\x13\x43\x11",
          "\x55\x08\xf5\xce\xa1\x97\x38\x69\x86\xd9\x2d\xbe",
          "\xa4\x3d\x39\xf7\x8a\x2e\x9a\x8a", "", "",
          "\x09\xec\x70\xfa\xae\x33\x35\x37\xa7\x31\x49\x29\xdd\xfb\x52\x5b", 1,
          64, 0 },
        { 96, 128, 128, 11,
          "\x94\x15\xf9\x25\xbc\xb4\x1d\xc2\x5e\x86\xc8\x26\xdb\xc8\xbf\x68",
          "\xbd\xff\xaa\x76\x3b\x91\x6f\xf0\xee\x3f\x3c\xe4",
          "\x70\x5d\x67\x6c\xd8\xa9\x44\x51",
          "\xfe\xb3\x61\x67\xea\xfc\x02\xc8\xe2\xbd\x6e\x13\x81\x76\x86\xba",
          "\x08\xdb\x32\x7a\x88\xbe\x7b\x48\xf4\x30\xfd\x7b\xfc\xcd\xf5\x02",
          "\xb7\xc2\x49\xf8\x10\xad\xac\xf9\x9a\xbd\xed\x1f\x3b\x91\x30\xf2", 1,
          64, 128 },
        { 96, 128, 128, 12,
          "\xd9\x7c\x9b\x04\x3b\xdc\xcf\xd5\x94\x91\xa9\x95\xe7\x8f\x16\x96",
          "\xef\x42\x32\x40\x35\x88\x30\xdf\x91\x55\x06\xa3",
          "\x3d\xdb\xa7\xb3\xab\x69\xc8\xb2",
          "\xf0\x47\x59\x4a\x5c\xff\xda\x64\x30\x3a\x80\xb2\xfa\x6a\x95\x71"
          "\x69",
          "\xe0\xca\xf2\xa9\xd5\x0f\x70\xec\xaa\x43\xb4\xa2\x87\xc3\xb3\x4a"
          "\x99",
          "\xcf\xf4\xc6\x18\x82\xb4\x13\xb6\x86\xff\x35\xb6\x3a\x3a\x73\xde", 1,
          64, 136 },
        { 96, 128, 128, 13,
          "\x16\xbe\x38\xc0\x5c\x7b\xc5\xc6\x8e\xe6\x20\x38\x71\x79\x92\x40",
          "\xac\xca\x8a\xe9\x16\x11\x9e\x49\xd8\x7c\x33\xa7", "\x28", "", "",
          "\x21\x7d\x40\xef\xd9\x72\x70\x1f\xcc\x33\xdf\x53\x62\xe1\xea\x9c", 1,
          8, 0 },
        { 96, 128, 128, 14,
          "\x7c\x89\x68\x0b\x4b\xca\x11\xa6\x43\x14\xf4\xca\xc5\x7a\x95\xdf",
          "\x07\xc8\xef\x98\x1b\xea\x99\x52\x57\xd3\xd6\x5a", "\xb8\xe8", "",
          "",
          "\xde\xa6\x36\xde\xd8\xb9\xef\x2a\x08\xff\xdf\x58\xa0\x5b\x78\x71", 1,
          16, 0 },
        { 96, 128, 128, 15,
          "\x43\x9f\xd5\xc3\xb7\x65\x87\xd5\xa6\x01\xba\x6e\xf8\xfa\xd2\x14",
          "\xed\x1d\x31\x6d\x08\x34\xd1\x74\xc1\xb5\xb4\x38",
          "\xea\xe2\x52\xf4\x2d\x2c\x71", "", "",
          "\xe8\x53\x04\x26\xcb\xab\xf6\x36\x33\xff\x37\x31\x59\x24\x7e\x38", 1,
          56, 0 },
        { 96, 128, 128, 16,
          "\x1a\x44\xf3\x55\x06\x88\xfd\xdb\xc1\xe5\x04\x1d\xc9\x89\x52\xc0",
          "\x5d\x29\x04\x29\x8f\x66\x8b\xa9\x5e\xaa\x17\x97",
          "\xd5\x59\x08\x95\x8b\x70\xab\xee\x81\x05\x4c\xdf\x3d\x3d\xf5", "",
          "",
          "\x5c\x71\xb4\xf0\x69\xcf\xa1\x3b\x76\x34\xdb\x4b\x13\xe7\xbe\x7d", 1,
          120, 0 },
        { 96, 128, 128, 17,
          "\x7d\xb6\xd8\xe5\x8e\x3c\x55\x2a\x64\x45\x20\xaa\x80\x5e\x2f\x48",
          "\xe9\x86\x93\xe9\xf6\x63\x2d\x11\x5b\x5d\x5a\x74",
          "\x6f\xc1\xca\x24\xe6\x97\x86\xaa\x26\xbf\xb5\xd4\x6e\xf8\xcb\x56",
          "", "",
          "\xb9\xa8\xa6\xd4\x61\xa4\x41\xfb\xd5\xbb\x6a\x8a\xc0\xd4\x7e\x9d", 1,
          128, 0 },
        { 96, 128, 128, 18,
          "\xde\x6e\xd1\x69\xd3\x96\xcf\xb7\x37\x8e\x89\x2c\x7f\xaf\x1d\x5d",
          "\xef\xc1\x87\x02\x82\xe7\x7c\xa8\x06\x3f\x1b\xeb",
          "\xee\xdf\x6e\x77\x6a\xd3\x7d\xc6\x10\x82\x5a\x61\x68\xe2\x13\x56"
          "\xc2",
          "", "",
          "\x0d\x65\x0a\x97\x4e\xbe\xa2\x2f\xed\x07\x7d\x22\x9e\x0c\x9e\x65", 1,
          136, 0 },
        { 96, 128, 128, 19,
          "\x6c\xf0\x95\x99\x18\x1c\x07\xae\xb2\x1d\x78\x20\xbf\x70\x65\x95",
          "\x4c\x4c\x52\x5a\x8c\x7e\xe6\x87\x9a\xef\xa7\x9e",
          "\xbd\x91\x39\x67\xdb\x07\xb9\xeb\x59\x07\xf0\xbe\x71\xce\x88\x6c\x41"
          "\xff\x92\x3c\x29\x6c\x0e\xf3\xf7\x04\xe9\x8f\x64\x9e\x59",
          "", "",
          "\x80\x6e\x48\xe7\xd4\x52\xb6\x3b\x61\x26\xf5\x76\xef\xbd\xf4\xc4", 1,
          248, 0 },
        { 96, 128, 128, 20,
          "\xef\x35\xb5\xc7\x97\xbb\x6b\xee\xdb\x51\x3b\xa3\xd8\xae\xbd\x25",
          "\x05\x76\xa1\x01\x7a\xc0\x0e\x49\x11\x0c\x4c\xac",
          "\xa3\x86\xd5\xc4\x4d\xe8\xc6\xa5\x06\x3a\xdf\x5b\xa9\xf0\xb7\x5e\x9a"
          "\xd1\xf2\x39\xa5\x30\xdd\x76\xd7\x97\x55\x4d\x7b\x03\x7d\x7d",
          "", "",
          "\x69\x66\xa1\xcf\x57\x29\x33\x2b\x26\xfd\x3e\x38\x50\xb7\x48\x65", 1,
          256, 0 },
        { 96, 128, 128, 21,
          "\x64\x9f\x3d\xfd\xdb\xf1\xaf\x60\x87\x67\x45\x68\xe2\xe6\xd7\xc3",
          "\x6c\xa6\xf8\x7b\x7a\x85\x84\xdf\x4f\x46\x87\xb9",
          "\x35\x31\x2c\xa2\x3e\x4e\xb3\x6c\xb0\xa6\x6c\x6f\x38\x6b\x8e\xc2\x9f"
          "\x6d\x11\xe8\x2f\xbf\xca\xad\xfd\x6c\xbc\x9b\x59\xd5\x1a\x6c\x02\x70"
          "\x86\x82\x74\xd9\x1f\x60\x97\x8d\x1f\x0f\x37\x28\x09\x30\xd3\xfd\xcb"
          "\x3e\x90\xea\x46\x1e\xcc\xc8\x3f\xa0\xd9\x75\x54\x88\x16",
          "", "",
          "\x3d\xaa\x00\x03\xde\x38\x4d\x78\x44\x3f\xfd\x3a\x5e\xa4\x81\x79", 1,
          520, 0 },
        { 96, 128, 128, 22,
          "\xa5\xb5\xb6\xba\xe4\x5b\x74\x1f\xe4\x66\x38\x90\x09\x8f\x32\x6a",
          "\x4b\xad\x10\xc6\xd8\x4f\xd4\x3f\xd1\x3a\xd3\x6f", "\x30",
          "\x12\x7b\x15\x00\x80\xec\x0b\xc7\x70\x4e\x26\xf4\xab\x11\xab\xb6",
          "\x75\xe6\xff\xcb\x61\x14\x83\x3b\x67\xcd\x93\xbd\xf2\xc2\x2b\x55",
          "\xc9\x0e\x18\xea\xf8\x10\xb7\xbc\xef\xe7\xa5\x26\xb1\x78\x3b\x20", 1,
          8, 128 },
        { 96, 128, 128, 23,
          "\x0c\xec\xb9\xf5\x12\x93\x2d\x68\xe2\xc7\xc0\xbc\x4b\xd6\x21\xc8",
          "\x21\x86\xa3\x09\x12\x37\xad\xae\x83\x54\x0e\x24", "\x74\x3e",
          "\x43\x7a\xeb\x94\xd8\x42\x28\x3b\xa5\x7b\xb7\x58\xe3\xd2\x29\xf0",
          "\x64\x6c\xef\x72\x90\x6e\x2b\x8f\x69\xac\x31\x34\xb4\x96\x59\x8e",
          "\x9d\xab\x1e\xe9\x31\x4a\x04\x30\xab\xf5\x4c\x37\xc8\x8c\x79\x0f", 1,
          16, 128 },
        { 96, 128, 128, 24,
          "\xa3\xfd\x2f\xdc\xce\x8a\x63\xbf\xe4\xeb\x2d\xb7\xe4\x2a\xdb\xe1",
          "\x69\x0e\x7a\xd1\xe0\x5d\x0d\x4a\xb4\x55\x2c\xf7",
          "\xab\x91\xec\x8c\xc7\x33\x73",
          "\xbe\x02\x31\xb5\xc7\x86\x1f\x0a\xf7\xb6\x38\x14\x79\xd2\x5b\x77",
          "\xa8\x84\xf7\x69\xfc\xc7\x27\x83\x9d\x59\x71\x1f\xa3\xcb\x5e\xe0",
          "\xf2\x01\x7e\x3b\xd1\x0b\xb1\xb4\x3f\xdc\xc0\xfe\xef\xfc\x9c\x68", 1,
          56, 128 },
        { 96, 128, 128, 25,
          "\x55\xe0\x4c\x12\x27\x80\xbe\x52\xed\x93\x28\x92\x80\x39\x00\x8c",
          "\x0c\x90\x8e\x58\xcd\xda\xd6\x9d\xea\x1a\x32\xc3",
          "\x25\x59\x17\x07\xc0\x04\xf5\x06\xf4\xb5\x1e\x85\xe2\x9f\x6a",
          "\x26\xeb\x70\x67\x2e\xef\x03\x66\x7b\x34\xcc\x7d\x0d\xf0\x58\x72",
          "\x89\x16\x6d\xcd\x7d\x74\xa4\x45\xdf\xd3\x52\x6c\x51\x80\xd8\x25",
          "\x8b\x8e\xd5\xf9\x7a\x16\x88\x81\xc3\xb6\xef\xe9\x1c\xfe\x70\x43", 1,
          120, 128 },
        { 96, 128, 128, 26,
          "\x5f\x0a\x1b\x5f\x8f\x86\x73\xd5\x66\xec\x7f\x54\xe7\xdc\xa4\xf2",
          "\xc3\x09\x68\xc9\x67\xe5\x35\x05\x62\x16\x28\xdb",
          "\xc0\x70\x92\xd7\x99\xda\xc2\xb4\xc0\x5f\xbd\xdd\x04\x74\x3c\x34",
          "\xf6\x53\x84\x76\xda\xf0\x45\x24\xcf\x13\x43\x09\xdd\x84\xe1\x87",
          "\x23\x15\x11\x0f\x7e\xc6\x4e\x7a\x23\xe5\xa7\x62\x82\x2f\x71\xab",
          "\xdc\x7b\x12\xfa\x2d\xbf\xbd\xc6\xd8\x5f\xaa\x77\xa2\xeb\x76\x7e", 1,
          128, 128 },
        { 96, 128, 128, 27,
          "\x67\x1a\x70\xe8\x83\xfb\x06\x11\xdf\xfd\x0b\x1d\xd9\xb8\xcc\xa2",
          "\xa5\x1c\x37\xf4\x67\x89\x3c\x16\x08\xe5\x62\x74",
          "\x3e\xa1\x2d\x80\xf4\x0f\x34\xf8\x12\x47\x9d\x2e\xcc\x13\xd2\xd6"
          "\xdf",
          "\x3b\xaf\x3e\xdf\x04\xdc\x0c\x97\xaa\xe0\x81\xcd\xeb\x08\x02\x1d",
          "\x5d\x56\x30\xfc\x72\x8f\xfb\x08\xce\x69\x3f\x72\x99\xe6\x72\x8b",
          "\x00\x02\x3f\x11\xa0\x23\xc0\x78\x6c\x10\x5f\xe4\xc0\x03\xaf\x6e", 1,
          136, 128 },
        { 96, 128, 128, 28,
          "\x20\xbb\xf7\x4c\x1e\x63\x98\x2c\x47\x2c\x47\x43\x56\x9e\x4c\x84",
          "\x45\x9f\xc7\xc0\x04\xbf\x46\x32\x3a\x02\xd8\x46",
          "\x4f\x22\x85\xce\x3d\xaf\xa5\x28\xc6\x94\xa5\x27\x2d\x3b\x7b\x92\x90"
          "\x97\xdb\x39\x87\x72\x65\x3b\xd9\xbb\xbd\xb3\xb2\xc8\xe1",
          "\x6d\xb5\x09\x92\xe8\xfb\xbe\xe1\x5d\x49\x79\xd3\xe3\x22\xda\xcd",
          "\x87\x03\xe4\x46\x97\x13\x8c\x58\x53\x2d\x97\xee\x99\x23\x1d\x94",
          "\xf1\x4c\x2f\x39\xa4\x87\x1a\x4a\x16\xc4\x2f\x6f\xe8\x78\xde\xef", 1,
          248, 128 },
        { 96, 128, 128, 29,
          "\x63\xf0\x31\x72\x50\x5d\x90\xe9\x49\x00\x12\x5c\xb8\xa4\xb0\xdd",
          "\x52\xc2\x09\x79\xcd\xaa\xad\xe5\x73\xdb\xa6\x50",
          "\x51\x89\xea\x6f\x39\xb2\xa7\x8c\x02\x02\xfd\xff\x14\x6c\x5c\xc6\xbd"
          "\xc7\x49\x1d\x47\x86\xf8\x0c\x6c\x6a\xef\x65\x63\x4c\x05\xda",
          "\x60\x2c\x98\x99\x7e\xe0\x3f\xd1\x1c\xe0\x0e\x92\xde\x19\x39\x77",
          "\x55\x90\x15\x5f\x3e\x70\x1b\x4a\x96\x09\x89\xd0\x25\x1b\xac\x65",
          "\xfd\x6a\x2c\x92\x73\xd1\x24\xb5\x55\x3b\xe4\x2e\x78\x93\x14\x65", 1,
          256, 128 },
        { 96, 128, 128, 30,
          "\x5b\xf0\x08\xf6\xf2\x7c\xc2\x1f\x5a\xe8\x2f\xb7\x90\x7b\x1d\x92",
          "\x58\x0a\xf4\x8b\xc1\x10\x86\x04\xd5\x55\x13\x43",
          "\x48\x2d\xa2\x4b\xb4\xfb\x9e\xaa\x0d\xbf\x40\x37\x33\x59\x7f\x5b\x3e"
          "\xe8\x33\x8b\x5d\x09\xa1\xd6\xf9\x07\x0b\xb0\x69\x26\x4a\xbb\xca\xcc"
          "\x56\x57\xaa\x63\x53\xf1\x79\xd1\xbb\x4c\x7f\xa0\x05\x26\x78\x9e\xaf"
          "\x08\xe0\xda\x25\x8c\xbd\xb3\x9e\x98\x77\xc6\x8b\x4a\x75",
          "\xca\x89\xd6\xae\x28\x4a\xfb\x67\x92\xcd\x89\x4e\x07\xaa\x83\x36",
          "\x1b\x89\xc6\xbc\xdd\xef\xbe\x92\x33\xee\x40\x93\x46\x8a\x5f\x61",
          "\xa4\x9c\x77\x47\xda\xd4\x2d\xf6\xd7\x29\xa0\x1f\x4c\x50\xcf\x34", 1,
          520, 128 },
        { 96, 128, 128, 31,
          "\x30\xd8\x69\x2e\xb3\xb6\x2d\xb6\x14\x4f\x74\xee\x9d\xec\x52\x96",
          "\xfe\x9f\x6f\xb4\x41\x5c\xfb\x41\x89\xf9\xc7\x6d", "", "", "",
          "\x80\x4f\x91\x5f\xc7\xfe\xa2\xca\x7d\x8b\xaf\x13\x50\xc5\x22\x7b", 1,
          0, 0 },
        { 96, 128, 128, 32,
          "\x21\x51\x7f\xd9\xeb\xfd\x38\x7d\xff\x2a\x0c\x05\x18\xab\x82\x67",
          "\x61\xf6\xc4\xec\x9e\x20\x91\xd4\xa0\x31\x80\x4a",
          "\x76\xd3\x32\xba\x08\x1b\x3d\x3c\xfb\xa2\x71\x16\x7b\xa1\x08\xcd",
          "", "",
          "\x2c\xc4\xb9\x05\xa4\xd3\x9e\x35\xd4\xbe\xae\xbd\xed\x9b\x59\x66", 1,
          128, 0 },
        { 96, 128, 128, 33,
          "\xa7\x16\xf9\x31\xc8\xf9\xd9\x77\xf7\xda\x85\x73\xbc\x65\xf2\xbf",
          "\x91\x77\x36\x59\xad\xac\x8f\x12\xe5\x52\x63\x16", "",
          "\x9c\x98\x03\x8c\x5e\x8d\x1a\xf5\x97\xb3\xb9\x18\x8b\x36\x24\xfb",
          "\x99\xae\x76\xcf\xff\x55\x2c\xe3\x7b\x21\x0e\x26\xe8\x10\x78\x7c",
          "\x2b\xda\xb5\xe6\xf0\x08\xb0\xcc\x75\x1d\x5b\x06\x74\x87\xeb\x2b", 1,
          0, 128 },
        { 96, 128, 128, 34,
          "\x87\x5b\x0b\x4a\x84\x15\x05\x24\xeb\x1f\x50\xf9\xd8\xde\x13\x88",
          "\xfd\xc5\x01\x4e\xd1\xad\x70\x61\x29\xd5\x73\x22",
          "\x35\xa6\xd9\x82\x9c\x84\x49\xc4\x40\x2e\x38\x5c\xc5\xc6\xfe\x98",
          "\x2f\x57\x5d\xfb\x2d\xbe\x9d\x23\x8d\xe5\x76\xfc\x63\xe4\xac\x32",
          "\x34\x69\xc3\xff\x73\x8a\xa3\x2a\xac\xc1\xac\x48\xd8\x9b\x1d\x75",
          "\xfa\x68\x72\x0a\x31\x71\xa5\x4c\x4b\x36\x90\xbf\xfd\xe7\xb6\x10", 1,
          128, 128 },
        { 96, 128, 128, 35,
          "\xd6\x29\x8f\xff\x67\xdb\xa1\xec\x25\x03\x08\xe0\xbc\x5f\x4f\xae",
          "\xd9\x6f\x9b\xbb\xfa\x14\xe9\x61\x6c\x45\x8d\xf5", "",
          "\x8e\xeb\x44\x45\xa3\x4c\x81\xfd\xbc\x47\x8b\x83\xdf\x71\x11\x6c"
          "\xe6",
          "\x47\x68\x69\xa3\xdd\xb3\x86\xbf\x42\x47\x8d\x0c\x84\x17\x90\x45"
          "\xbe",
          "\x91\x36\xd9\x94\xda\xa2\x2e\xad\x4d\x08\x27\xe5\x82\x50\x01\xac", 1,
          0, 136 },
        { 96, 128, 128, 36,
          "\xe3\xd3\xec\x41\xf2\x8e\xb3\x5f\xb5\x3f\x5f\xa9\x18\x04\xe0\x51",
          "\x89\xd2\x70\xfc\x8b\x58\x3b\xc6\x31\xce\xfd\x39",
          "\x3d\x2f\x45\x8c\x67\xc5\xb6\xc7\x94\xb1\xf1\x2d\xad\x40\x9e\x0f",
          "\x84\x7a\xcf\x52\x19\x95\xb3\x3f\x8b\xc4\x74\xc8\xbe\xfb\xca\x3b"
          "\xb2",
          "\x28\xaa\xec\x53\x49\x3c\xd6\x25\x2c\xf6\x41\x0e\xd1\x41\xbd\xaf"
          "\xb7",
          "\x47\xbf\x3e\x16\xc2\x27\xca\x11\xfd\x68\xa1\x6d\x40\x7c\x2c\xc3", 1,
          128, 136 },
        { 96, 128, 128, 37,
          "\xfa\xf3\x6a\x66\xf8\xe5\x4f\x2f\xb2\xa0\x2f\x3a\x30\xf0\x18\x0b",
          "\x2f\xfa\x98\x2a\x47\x84\x79\x7c\xf4\x6b\x07\xab", "",
          "\x50\xa5\x9e\xdc\x01\xb7\xbd\x0d\xb6\xec\x43\xfe\x23\xf7\x2e\x70\xed"
          "\x4d\x42\x33\x7a\xb1\x92\x6c\xc6\x95\x6a\xa4\x4d\xbe\xbf",
          "\xa7\x89\x90\x7a\xeb\x23\x44\xf0\x25\xb1\xb4\x26\xc9\xde\xe5\x2b\x10"
          "\x6f\xf2\x11\x0c\xb2\x00\xcf\xb8\x5a\xea\x60\xfd\xdf\x6a",
          "\x72\x2e\x5c\x45\x0c\x5e\xd9\x49\x28\x59\xa3\x23\x6a\x22\x0f\x76", 1,
          0, 248 },
        { 96, 128, 128, 38,
          "\x2c\x9b\x9f\xf4\x7d\x74\x2c\x4a\xb2\x24\xe9\xca\x1e\xd5\x7c\x4c",
          "\x91\x79\x62\xca\xf3\x93\x24\x41\xc2\x59\x28\x2f",
          "\x72\x17\x5b\xdf\xdb\x4a\x23\xe9\x7f\xdc\xbd\x26\x3b\xaf\x43\x16",
          "\xb5\x42\xc2\xf3\xf8\x16\x70\xdd\xf7\x4f\x15\x18\x4a\xb7\xde\x17\xe0"
          "\x57\xcd\xe9\xee\xf9\x2b\xab\xdb\x83\x75\x00\x77\x4c\x19",
          "\x32\x0a\xe0\xc1\x1e\x92\xd1\x0d\x5b\xf5\x48\x5c\x85\x4b\x2d\x8f\x63"
          "\x18\xe3\x3f\x16\xb5\x20\xcf\xfd\x35\xad\xa3\x81\xc9\x67",
          "\xa4\x86\x69\x08\xe6\x64\xee\x14\x0c\x6a\xe2\xb9\xd2\xab\x84\x16", 1,
          128, 248 },
        { 96, 128, 128, 39,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3d\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 40,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3e\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 41,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\xbc\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 42,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6c\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 43,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\xe6\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 44,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x42\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 45,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x41\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 46,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\xdb\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 47,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb1\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 48,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\x30\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 49,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x14\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 50,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x06\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 51,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x96\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 52,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x95\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 53,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x17\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 54,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x9b", 0,
          0, 128 },
        { 96, 128, 128, 55,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x98", 0,
          0, 128 },
        { 96, 128, 128, 56,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\xda", 0,
          0, 128 },
        { 96, 128, 128, 57,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\x5b\xb0\x34\x07\x72\x97\xf0\x92\x1a", 0,
          0, 128 },
        { 96, 128, 128, 58,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3d\x6d\x5f\x66\x43\x0a\xd6\x5b\xb1\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 59,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\xe6\x43\x0a\xd6\xdb\xb0\x34\x07\x72\x97\xf0\x92\x9a", 0,
          0, 128 },
        { 96, 128, 128, 60,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3c\x6d\x5f\x66\x43\x0a\xd6\xdb\xb0\x34\x07\x72\x97\xf0\x92\x1a", 0,
          0, 128 },
        { 96, 128, 128, 61,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\xc3\x92\xa0\x99\xbc\xf5\x29\xa4\x4f\xcb\xf8\x8d\x68\x0f\x6d\x65", 0,
          0, 128 },
        { 96, 128, 128, 62,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          0, 128 },
        { 96, 128, 128, 63,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          0, 128 },
        { 96, 128, 128, 64,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\xbc\xed\xdf\xe6\xc3\x8a\x56\xdb\x30\xb4\x87\xf2\x17\x70\x12\x1a", 0,
          0, 128 },
        { 96, 128, 128, 65,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3e\xe9\xf3\x43\x0f\x3e\x80\x3c\x0a\x46\xb7\xa8\x4c\xd8\x03\xde",
          "\x3d\x6c\x5e\x67\x42\x0b\xd7\x5a\xb1\x35\x06\x73\x96\xf1\x93\x9b", 0,
          0, 128 },
        { 96, 192, 128, 66,
          "\x50\x19\xeb\x9f\xef\x82\xe5\x75\x0b\x63\x17\x58\xf0\x21\x3e\x3e\x5f"
          "\xcc\xa1\x27\x48\xb4\x0e\xb4",
          "\xff\x0d\xdb\x0a\x0d\x7b\x36\xd2\x19\xda\x12\xb5", "", "", "",
          "\x2d\x03\xf5\xe8\xc2\xe5\xa1\xb4\x3c\x77\x08\xdd\x0c\xbf\x0a\xcd", 1,
          0, 0 },
        { 96, 192, 128, 67,
          "\x21\x21\x8a\xf7\x90\x42\x8f\x80\x24\xd3\xe7\xe1\x42\x8c\x9f\xcf\x57"
          "\x8c\x21\x66\x36\xd6\x0e\x73",
          "\x34\x04\x7b\xc3\x9b\x9c\x60\x83\x84\xdf\xf5\xb8", "", "\xe3",
          "\x39",
          "\x74\x50\xf5\x5a\x21\xe7\x17\xa1\x10\x6e\xa0\xc1\x18\x71\xf5\xff", 1,
          0, 8 },
        { 96, 192, 128, 68,
          "\x3a\x8b\xf5\x43\xc4\x80\x92\x56\x32\x11\x82\x45\xbc\xbf\x5d\x01\x52"
          "\x2b\x98\x7a\x31\xa3\x3d\xa3",
          "\x4e\xbc\x13\xcf\x46\x36\xcc\x7c\x45\xe5\x60\xa7", "",
          "\x53\xfc\x72\xe7\x1b\x59\xee\xb3",
          "\x5d\x24\xd0\xe1\xa2\xee\x9f\xce",
          "\xe7\x70\xf9\x1a\x51\xf5\xb5\x87\xa4\x4c\xd9\xd3\x63\x4b\x97\x06", 1,
          0, 64 },
        { 96, 192, 128, 69,
          "\xbc\xb6\xbc\x5e\xe6\x74\x3d\xf1\x39\x6a\x34\x63\x93\x27\xb2\x58\x09"
          "\xec\x9c\x81\xdd\x6a\x0c\x0e",
          "\xbe\x03\x26\xd2\x3b\xdc\x2c\x64\x64\x8d\x13\xf4", "",
          "\x80\x47\x4a\x3a\x3b\x80\x95\x60\xee\xe2\xce\x7a\x7a\x33\xea\x07",
          "\xdb\x58\x93\xdc\x8d\xa3\x36\x61\x4a\xa0\xff\x76\x8d\x46\x95\x35",
          "\x90\x2c\x2a\x83\x25\xcb\x55\xbc\x95\xf0\xe1\x3c\xaf\xe9\xaa\x8d", 1,
          0, 128 },
        { 96, 192, 128, 70,
          "\x5e\x1d\x28\x21\x3e\x09\x25\x36\x52\x5b\xba\xe0\x9e\x21\x4a\xf4\xc8"
          "\x91\xe2\x02\xb2\xb4\xfa\x4f",
          "\xb6\xbe\x6c\xd0\x68\x12\x35\xd8\x26\xaa\x28\xea", "",
          "\x53\xd5\x94\x33\xa7\xdb\x7f\x41\xb3\x1c\xcb\x6d\x4a\x2d\x78\x99"
          "\x65",
          "\x20\xeb\xc1\xf5\xa2\xc9\xf8\x8d\x1c\xdb\x18\x2e\x81\x32\x9c\xc0"
          "\x3e",
          "\xbc\x54\x5e\x91\xc9\x74\xa7\x44\xba\xea\xb2\xdd\x8c\xe6\x09\x60", 1,
          0, 136 },
        { 96, 192, 128, 71,
          "\x7f\x67\x2d\x85\xe1\x51\xaa\x49\x0b\xc0\xee\xc8\xf6\x6b\x5e\x5b\xee"
          "\x74\xaf\x11\x64\x2b\xe3\xff",
          "\xb0\x22\x06\x70\x48\x50\x5b\x20\x94\x62\x16\xef", "",
          "\xef\x64\x12\xc7\x2b\x03\xc6\x43\xfa\x02\x56\x5a\x0a\xe2\x37\x8a\x93"
          "\x11\xc1\x1a\x84\x06\x5f\x80",
          "\x1b\xc9\x90\x29\xa0\x9c\x08\x01\x40\x60\x8a\x62\xc3\x3b\xc7\xae\x69"
          "\xff\x81\x1f\xef\xb2\x0b\x2d",
          "\x80\xf0\x91\x03\x48\x5f\x95\xf8\x6a\xd1\xf0\x72\xa2\x14\xc5\x5e", 1,
          0, 192 },
        { 96, 192, 128, 72,
          "\xf7\xac\xe6\xc3\xc1\x0c\x3f\xf9\x77\xfe\xbe\x7d\xc8\x82\xb8\xe7\x79"
          "\xef\x3a\x17\xef\x93\x24\xa8",
          "\x6e\x2b\xa2\x83\x3c\x5d\xce\x6b\xec\xc4\xf6\xd8", "",
          "\x2e\x11\xe4\x19\x51\xc2\x04\x60\xc7\x68\xb0\xd7\x1a\xd5\x6e\x77\xbe"
          "\xc0\x5e\x04\x78\xf9\x9d\x5b\x62\xe7\x99\xf7\x32\xe4\x67",
          "\xb3\xce\xc7\x77\xf8\x07\xd1\x6b\x69\x71\x63\xd0\xc6\xa4\x5d\x00\x29"
          "\x36\x71\x4d\x60\x0a\x15\x6d\x7e\x53\x65\xd1\xaa\xca\xd0",
          "\x11\xa5\x6e\xdb\xe2\xfb\xbb\xb2\xb0\x11\xc4\x3a\x62\x00\x08\x30", 1,
          0, 248 },
        { 96, 192, 128, 73,
          "\xa9\x54\x1a\x96\xb8\x6d\x32\xb4\x52\x09\x2e\x8b\x92\x09\x9e\xa3\xf4"
          "\x5f\x98\xca\x05\xce\x69\x2b",
          "\x90\x15\xb4\xbc\xd6\x98\x90\x83\x04\x6b\xe8\x6d", "",
          "\x9d\x35\x9a\xad\x3f\xf5\xce\x37\x35\xa8\xcf\xfe\x4f\x08\x71\x14\xd4"
          "\xd6\xc5\xe0\x1d\xce\xb1\x96\x9f\x40\xc8\xe0\xdb\x6b\xb9\x02\x81",
          "\x0a\x6b\x84\xde\x44\xcc\xe1\x42\x55\xa9\xcb\x19\x16\x96\x95\xcf\x46"
          "\x60\x48\x9f\x1e\x3f\x60\x53\x34\x35\x58\x28\xc5\xc0\x9f\xb3\x0e",
          "\xa1\x9a\x60\x10\x5f\xc7\xa0\x3b\xe1\x78\x3f\x55\x8e\xa2\x3e\x9c", 1,
          0, 264 },
        { 96, 192, 128, 74,
          "\x23\x91\x95\xb5\x86\x68\xeb\x89\x63\x6b\x1e\xc2\xb3\x31\x33\x69\x46"
          "\x36\x9f\xc6\xc8\x7b\x88\x49",
          "\x14\xa6\x28\x1a\x43\xb4\xeb\x05\x6a\x67\xb9\xe6", "",
          "\x39\xd8\x73\xd4\xca\xd7\x1c\xb2\x52\x78\x4b\xd1\x46\x48\xa4\x94\xce"
          "\xb5\x17\xeb\x9e\x3e\x6f\x32\xd1\x9b\xd1\x8d\xfa\xf8\x77\xc7\xae\xc2"
          "\x21\x03\xd2\x42\x99\x3e\xd7\xba\xb1\x23\x32\x61\x10\xdf\xdb\x72\x29"
          "\x14\x3a\x0c\x60\x1e\x16\xaa\x4e\xcd\xde\x80\x8c\xd8\x3b\xb2",
          "\x8f\xce\xa9\xe2\xfa\xa5\x23\x29\x84\x72\xb5\x58\x3e\x35\x6d\x18\x75"
          "\x39\x3e\xa3\xbc\x1b\x4f\x8e\xa4\xaa\xd5\x97\x14\x7a\x7c\xa9\x4e\x26"
          "\x09\xfe\x6b\xf0\xab\x86\x1e\x06\x31\xa3\x12\x4e\xb1\x5d\x0d\xe2\x65"
          "\xef\x11\xa3\x3e\x45\x07\xe3\x07\x70\xce\x37\xbb\xb4\xb6\xc3",
          "\xa4\x45\x68\x28\xb4\x9c\xdb\xf8\xf3\xc2\x00\x42\x9c\x33\x9a\x89", 1,
          0, 528 },
        { 96, 192, 128, 75,
          "\x03\xb4\x67\x58\x51\xb7\x8b\x69\xfb\x7b\x55\x89\x88\x2e\x71\x8b\x07"
          "\x5e\x9a\x54\x02\xb5\x20\xfb",
          "\xc4\xca\x2d\x67\x8e\x51\x74\x2e\xc5\xe5\x60\xab",
          "\x91\xe1\x0a\xc5\x63\x6f\xe9\x9b", "", "",
          "\x93\x7f\x15\xff\xd1\xcc\xd6\x45\xd9\xc7\xcd\xd6\x67\x73\x11\xcd", 1,
          64, 0 },
        { 96, 192, 128, 76,
          "\x40\x0e\xec\x9b\x06\xa8\x0a\x84\x03\xd4\x5d\xae\x5d\x58\xcc\x91\x7b"
          "\xc8\x54\xf5\x1c\xd3\xce\x0d",
          "\x44\x7d\xd0\x9a\x23\x70\x8f\x3b\x66\x64\xe1\x5b",
          "\x73\x20\x36\x7d\x5b\x07\x05\x59",
          "\xb7\x84\x92\x5a\x69\x5f\x0e\xd1\x4c\xa4\x02\x49\xc1\xfd\x5d\x1a",
          "\x91\x2d\x05\xc4\x02\x38\x39\x50\xe1\xc5\xa5\x18\x8e\x62\x41\xd8",
          "\xab\x30\x9b\xe2\xc0\x5c\x94\x1f\xbf\xb3\x38\xba\x06\x4b\x19\xa1", 1,
          64, 128 },
        { 96, 192, 128, 77,
          "\xe2\x58\xb1\x17\xc2\xfd\xd7\x55\x87\xf0\x7b\x40\x0a\xe4\xaf\x3e\x67"
          "\x3a\x51\xdc\xf7\x61\xe4\xca",
          "\x5e\xad\x03\xaa\x8c\x72\x0d\x21\xb7\x70\x75\xdb",
          "\x27\x70\x29\x50\x96\x0b\x9c\x79",
          "\xaf\xe9\x61\x13\xa6\x84\xbc\x52\xa6\xd9\x62\xcf\x27\x24\xf6\x79"
          "\x1d",
          "\x78\x30\x44\x6f\x33\x30\x57\xd9\x96\xa1\xa7\x9b\x21\xc6\x8d\x8b"
          "\x43",
          "\x72\xac\x47\x8a\x66\xf5\x63\x75\x63\xf1\xf1\x2c\x1d\x02\x67\xca", 1,
          64, 136 },
        { 96, 192, 128, 78,
          "\x6c\x2a\x03\xe9\xed\x8e\x42\x1e\x07\xdf\xc3\x6b\x99\xc0\xd0\xdc\x9b"
          "\xb8\x74\xea\x3a\xf8\xa8\xb7",
          "\x8f\x01\x5e\xce\x4e\x03\x38\xe7\x82\xfa\x3a\x2f", "\xf1", "", "",
          "\x92\x26\xc4\xc3\x91\x66\xdf\x5a\xf4\xe0\xc9\x1b\x64\xb4\x63\xa2", 1,
          8, 0 },
        { 96, 192, 128, 79,
          "\x14\x86\xb5\xf1\x50\x52\x4c\xc6\x01\xb2\xea\x7d\xa4\x7d\x7c\x8a\xfb"
          "\x06\xd6\x42\x0d\xd3\x3f\x8d",
          "\x93\x07\x31\x7d\x2f\x42\x3b\x57\xb3\x72\x0f\x8f", "\x3c\x09", "",
          "",
          "\x36\x00\xe0\x6d\xef\x58\x5e\x20\x12\x35\x0e\xfe\x04\x78\x26\xe9", 1,
          16, 0 },
        { 96, 192, 128, 80,
          "\xe0\x9c\x83\xff\x0f\xc0\xb6\xa3\x0f\x93\x8e\x50\xe2\x66\x85\x24\x7e"
          "\x9d\xed\x2e\x7d\x6d\xbc\x7c",
          "\x3e\xc6\x1e\x9c\x16\x6d\x67\x83\x99\x23\x91\x52",
          "\xc1\xa1\x3c\x74\xc1\x1c\xb8", "", "",
          "\x9f\x5b\x3e\x48\xdd\xda\x9a\xf3\x75\x15\x01\x50\x9c\x94\x0a\xc1", 1,
          56, 0 },
        { 96, 192, 128, 81,
          "\xd0\xc6\x88\xc5\x25\x80\xd8\xf8\x00\xac\xa3\x4f\xa7\x4c\xec\x48\x7b"
          "\x67\x1a\xaf\x85\x02\x7b\x9b",
          "\x9c\x46\x0a\xbf\x56\x29\x2d\xcb\x1b\x35\xb3\xb4",
          "\x35\x96\xce\x98\x9f\xf9\x75\xf3\x25\x0e\x6c\x9e\xce\xd2\x5b", "",
          "",
          "\xcd\xa4\x34\xc2\x29\xe5\x4b\xf9\xbf\xd5\x4c\x8d\x8c\xe4\x73\x0c", 1,
          120, 0 },
        { 96, 192, 128, 82,
          "\x18\x92\xdb\xd7\xe6\xb3\xfe\x18\xeb\xdc\x81\xbb\x27\x1a\xb0\x3a\x8f"
          "\x32\xaf\x04\xf1\x33\x00\xd2",
          "\x0e\x87\x2d\xe5\x8a\xd1\x0d\xa2\x48\x40\x3f\x21",
          "\xe8\xb1\xc6\xcc\x6c\x45\x10\x5e\x0c\x32\x58\x7a\x0d\xe3\x69\xe3",
          "", "",
          "\x0c\x7e\x14\xdc\x49\xa8\x1e\x6b\xe1\x23\xb9\xcf\xbb\x28\x17\x87", 1,
          128, 0 },
        { 96, 192, 128, 83,
          "\xef\x79\x92\xb0\xf8\xec\x7a\x10\x1d\x34\x00\x01\x00\xeb\x7d\x9b\x2e"
          "\xae\xe3\x33\xd0\xaa\x2f\xf8",
          "\x31\x6d\x38\xa9\x00\x19\xb9\xa3\x7a\xd0\x80\xb7",
          "\x10\x14\xed\x78\x89\x69\x4c\xff\x76\x78\x76\xc0\x69\xae\x1f\x91"
          "\x85",
          "", "",
          "\x17\xff\x8e\x79\x97\x60\x55\x8f\x1d\x4c\xf8\x92\x7d\x5e\xc6\x99", 1,
          136, 0 },
        { 96, 192, 128, 84,
          "\xe4\x57\x08\x15\xa1\x49\x59\x9d\x13\xbd\x8d\xca\xad\xbe\xc9\x3c\xf0"
          "\x90\x19\xba\xa2\xd4\x07\x0b",
          "\x5a\x31\xa3\xa0\x26\x78\x6c\x49\xdb\x9d\x09\x58",
          "\x90\xa7\x35\x75\x19\xe3\x5e\x8d\xbd\x89\x76\xd4\xb3\x67\x10\xff\xc1"
          "\xeb\x0d\x9a\x4a\xe7\xd5\x31\x5a\xe7\x32\x4e\xb1\xd1\x8c",
          "", "",
          "\x06\xcc\xbf\x76\x7e\x0a\x63\xc8\x9d\x50\xb8\x14\x11\x87\xa5\x55", 1,
          248, 0 },
        { 96, 192, 128, 85,
          "\x9f\x0c\x07\x6b\x06\x30\xca\xa1\x0e\x7b\xdc\x07\xdc\xdc\x89\xa2\x70"
          "\xf0\x39\x30\x99\x7a\xde\x0b",
          "\x3f\x5d\xef\x08\x80\xb8\x89\xdb\x0b\x3f\x2b\xf0",
          "\xf5\x36\x8b\x9d\x8f\xdc\x1e\xfa\xb2\xb1\x7a\x45\xf4\x60\x42\x45\x98"
          "\x35\x72\xf8\xc1\x67\xaa\x31\xfa\x3f\x53\x0f\x1c\x5e\x17\x81",
          "", "",
          "\x33\x4c\x13\x25\xfa\x96\x9a\x07\x17\x90\x11\xd2\xf8\x61\x36\x36", 1,
          256, 0 },
        { 96, 192, 128, 86,
          "\x80\x3f\x4e\xbb\xed\x8b\x1a\x4f\x34\x87\x13\x46\x1c\x0e\xb0\xbd\x30"
          "\xca\xec\x55\xa1\xe7\x16\x28",
          "\xb0\x5e\xc4\x9b\xc4\x05\xeb\x7e\x97\x29\x4f\x19",
          "\xdf\xb7\x1f\x25\xe7\xf1\x1c\xca\x17\x70\x2e\xb8\x9a\x18\x4e\x57\xf2"
          "\x2e\x4e\xa4\x74\x1f\xf6\x03\xab\xc9\x01\xfa\x02\x6b\xde\x7c\xe1\x10"
          "\x7e\x2f\xfb\xa0\xa0\xa0\xf2\x4f\x47\xee\x62\x78\x32\xee\x5b\xc2\x19"
          "\x2c\x18\x84\x56\x30\x00\x99\x10\xc0\x7f\x8d\x0a\xb4\x51",
          "", "",
          "\x2b\x71\xd2\xa8\x1f\x4c\x6e\xa2\x67\xa9\x86\x50\x94\xfe\x20\xe9", 1,
          520, 0 },
        { 96, 192, 128, 87,
          "\xda\x6e\x3d\xf6\x73\x5f\x63\x2e\x03\x5a\xb8\xf1\x0c\x37\xb5\xf0\x0a"
          "\x40\xe1\x8b\x17\x77\x8a\x85",
          "\x80\x76\x5e\xac\x22\x81\x96\x9c\xba\x56\x9c\xe7", "\x6d",
          "\x3d\x87\x65\xdf\x3a\x06\xf5\x24\x8b\x1a\xaa\x54\x12\x3b\x86\xbd",
          "\xa4\x28\x63\xb9\x5a\xbe\xa3\x91\x94\x0a\xda\xc7\xfe\x0c\x41\x43",
          "\x12\x2b\x46\xf8\x1a\x0b\x6e\x92\xcd\xa1\x95\x0c\xe6\xfe\x02\x6e", 1,
          8, 128 },
        { 96, 192, 128, 88,
          "\x54\xe1\x71\xcf\x90\x72\x9c\x77\xd5\x00\xe1\xd2\x53\x33\x60\xe8\x41"
          "\xe2\x60\x89\x45\x76\xb1\x29",
          "\x8b\x1e\x57\xf9\x8e\xa4\xe7\x7d\xea\xe4\x57\x6c", "\x27\xff",
          "\x2d\x71\x63\x66\xf2\x87\x38\x60\xd5\x04\x37\x00\xf1\xe9\xa9\xd8",
          "\x34\x18\x15\x4a\xfc\x95\xd0\x55\x69\xee\x6f\xe4\xdb\x82\xeb\x6e",
          "\x0a\x73\x4b\xac\x17\x84\x3b\x85\x73\xfb\xfe\xba\x4a\x5f\xc5\xd4", 1,
          16, 128 },
        { 96, 192, 128, 89,
          "\x99\x2c\xab\xb6\x4f\x12\x21\x0c\x8b\x0b\x14\xd7\x3d\x39\x31\x7d\xdb"
          "\x2b\x8a\x62\x8a\xc3\x51\x06",
          "\x57\xc8\x78\x6e\x66\xd8\xb0\xbe\xc3\x36\x04\xb0",
          "\x06\x8d\x94\x0e\x26\xb6\x78",
          "\x9e\x76\x92\xf1\x21\x32\xcd\xd5\x3f\x50\x53\x16\x51\x41\x7b\xd2",
          "\xba\x34\x09\x26\xde\x50\x0d\x01\xae\x3d\xff\x2e\x90\x56\x08\x16",
          "\xdb\x9d\xba\x31\xa0\x30\x19\xce\x88\xce\x74\x1c\x03\x94\x06\x60", 1,
          56, 128 },
        { 96, 192, 128, 90,
          "\x89\xbe\x64\x95\xc9\x17\xbd\x7a\xf0\xa3\xb7\xa6\xc8\xa4\xc6\xb5\xca"
          "\xde\x76\x6d\x32\xde\x36\x04",
          "\xf4\x7f\x6b\x65\xd6\x60\xf1\x0c\x04\x3e\xa6\x41",
          "\xf6\xa2\x8d\x27\x68\x6a\xdc\xbf\x9f\xf8\xab\x80\xec\xc1\xc1",
          "\xc3\xc5\x0f\x4b\x38\xaa\x37\x51\xf4\x91\x0a\x44\x67\x5d\x37\xe5",
          "\xb1\x9b\xe8\xba\x6e\xbc\xdb\x74\xd3\x3c\x2d\xbd\xfd\xc0\x20\x74",
          "\x93\xbb\x71\x70\x61\x33\x0a\xcc\xc7\x18\xb4\xa8\xef\x05\xab\x20", 1,
          120, 128 },
        { 96, 192, 128, 91,
          "\x8e\xa9\x54\x55\x24\x17\x51\x6c\x97\x2e\x43\x11\x69\x2d\x65\x8d\xd7"
          "\xac\x9a\x7f\xd6\xf3\xd0\x2c",
          "\xea\x16\xc1\x04\xbc\xe5\xb7\xed\xd5\xa2\x5a\x46",
          "\x7d\x4d\x7c\x27\x3a\x9a\xa0\xf3\x5d\x1f\x91\x57\x01\x41\xdb\x54",
          "\x0f\xc6\xcc\x80\x0a\x57\x86\xe6\x3a\x45\x46\xfb\x33\x88\x7a\xf9",
          "\xeb\x45\xae\x29\x80\xd9\x96\xf5\x02\x35\x93\xf7\x62\xd3\x70\x51",
          "\x4a\xcc\x06\x24\x2c\xc4\xec\x4b\xa3\x6e\x8b\xfb\xe8\x4f\x3d\x5d", 1,
          128, 128 },
        { 96, 192, 128, 92,
          "\xdf\xa7\xef\x72\x30\x2d\xfb\xcd\x26\x48\xb8\x89\x58\xfe\x0f\x04\x9f"
          "\x1d\x60\x14\x3d\x86\xe3\x95",
          "\xf3\x72\x3b\x9a\xb7\x28\xc9\x9b\xbd\x6f\x23\x04",
          "\xcf\x75\xdd\x45\x36\xd0\x0f\x11\xed\xa4\x0d\xb4\xd2\x52\xe1\x72"
          "\xe3",
          "\x20\xb3\x88\x32\x44\x30\x0a\x82\x09\x4d\xdb\x9b\x3d\x1e\xfb\x81",
          "\x5a\x83\x74\x39\x1a\xdc\x22\xe8\xc0\x66\x55\x7d\x9f\xf5\x86\xcf",
          "\xd4\xa1\x11\xd6\x11\xef\xa6\x3f\x0c\x3f\x08\xb2\xfb\xb3\xb0\xac", 1,
          136, 128 },
        { 96, 192, 128, 93,
          "\xb6\x3b\x52\xd1\xd1\x59\xa1\x75\x96\xdf\xbd\x9b\xe5\xc5\x08\x86\x99"
          "\xd9\x4b\x9c\x5d\x95\xc2\x2d",
          "\xb1\xbe\xee\x8a\xfb\x00\xe0\x1a\x9c\xbf\x59\x73",
          "\x90\x20\xb5\x62\x56\xbc\xb0\x2c\x69\x07\x20\xe3\x23\x9d\x32\x5d\x25"
          "\x9f\x18\x98\xea\x05\x17\x0e\x31\x5c\x14\x49\x60\xd2\x63",
          "\xdf\xb4\x17\x90\x3c\x6d\x48\x27\x50\x0a\x3e\xca\x21\x84\xfe\x1c",
          "\xe8\x44\x71\x60\x1f\xb8\xb4\xdb\xbd\xc8\x0d\x56\xe3\x7f\x69\xb8",
          "\x52\x08\x9c\xb4\xe6\xc1\x1b\xd7\x64\xae\x7d\x44\x38\xcf\xd1\xf8", 1,
          248, 128 },
        { 96, 192, 128, 94,
          "\xaa\xf6\x40\x23\xf5\x76\x2c\x4a\x54\xc3\xeb\x0e\xf3\xbb\x2e\xbd\x23"
          "\xce\xaf\x38\xb3\xe0\x28\x5f",
          "\x2a\x56\x23\x5f\x07\x9d\x53\xa3\x10\x07\x02\xd4",
          "\x2d\x68\x8b\x3b\x33\x11\x77\x05\x79\xdd\x06\x46\x14\xa7\xd1\x1b\x17"
          "\xa1\x69\x53\xbd\x97\x00\x75\x9b\x35\xa5\x03\x1a\x2d\x8b\xd0",
          "\x34\xae\xc5\xa6\x57\x95\xcb\xee\xda\xc2\xee\x6f\xd7\x76\x5c\x6f",
          "\xd1\x3c\xce\xb8\x37\x6e\xb4\x23\xf5\xb2\xea\x25\x7c\x11\x8f\xb5",
          "\x7b\x6a\x3c\x76\xfd\x52\x93\x0a\x98\x9f\x03\x4e\x5d\xfe\x07\x4b", 1,
          256, 128 },
        { 96, 192, 128, 95,
          "\xb5\x21\xe4\xfa\x92\xeb\x46\xfd\x49\x16\xc7\x1e\x3f\x99\x90\x27\xaa"
          "\xf2\x14\x66\xfa\xd5\xf9\x6e",
          "\xb2\xb4\x2f\xa6\x0a\x2a\x80\x41\x2e\xec\xc7\xfc",
          "\xb4\x97\x22\x1c\x7f\xad\x55\xa0\x6e\xa9\xf5\x6f\x39\xb3\x60\x93\x30"
          "\xed\xc4\x67\xb7\x9c\xbf\x33\x53\x63\x6b\xce\xb7\x84\xb6\x0e\xc6\x3a"
          "\x83\x60\x74\xce\xb4\x86\x24\xa4\xa4\x1a\xc0\x49\x6d\x5a\xdf\xe2\x98"
          "\x93\x13\xd7\x41\x2b\x9c\x2d\x89\xca\xfd\x9c\xd5\xa7\x34",
          "\xa3\xa8\x0a\xc0\xf5\xb4\x65\x97\xa7\xf4\xa5\x83\xdd\xa0\x21\x24",
          "\x99\x4b\xb3\x44\x70\xd4\xdd\xb7\xbb\x7a\x3c\x3a\xbb\x5d\xa3\xc5",
          "\x02\x55\x0e\x2b\x27\x8c\x72\x36\x72\xa0\x1e\x4b\x6a\x46\xaf\xc7", 1,
          520, 128 },
        { 96, 192, 128, 96,
          "\x77\x57\x75\x4a\xec\xcf\x85\xc9\x1e\x48\xe4\xd4\x97\x0d\x4d\x62\xda"
          "\xe9\x4c\xf4\x4f\x9f\xf0\x26",
          "\x3d\x92\x81\xc4\xac\xfc\x72\x38\x73\x46\xfd\x92", "", "", "",
          "\xda\x9a\xe6\x0a\x12\xaa\x6f\x92\x6c\xf4\x6d\x2a\x33\x5f\xaa\xc7", 1,
          0, 0 },
        { 96, 192, 128, 97,
          "\xa0\xca\xc7\xe8\x3c\x7e\xba\x22\x36\x52\x56\xcb\x8f\x23\x70\x39\xb9"
          "\x4f\x1a\x26\x92\x63\x64\x8e",
          "\x2d\x2a\x5c\x8b\x17\x21\x2d\x4c\x44\xce\xd4\x59",
          "\x8b\x38\x8e\x2e\x72\x25\xc0\x87\x30\x00\x42\xf6\x02\x4a\x11\x1f",
          "", "",
          "\x84\x04\x34\x98\xce\x07\xd8\x74\x23\x30\xc6\x05\xd9\x6d\x96\x6c", 1,
          128, 0 },
        { 96, 192, 128, 98,
          "\xfa\x07\xaa\x39\x32\xb9\x01\x69\x62\x69\xc8\xf8\xbf\x56\x66\x2f\x82"
          "\xdf\xf2\x95\x7a\x4a\xca\x35",
          "\xec\x1b\x6d\x7f\x09\x7a\x2c\xad\x8c\xbc\x9f\xe9", "",
          "\xd9\xa6\x89\x79\x3c\x94\x79\x68\xf0\x7d\x4b\xa2\xeb\x1c\x25\xeb",
          "\xa3\x22\xf7\x58\x00\xfc\xaf\xf6\x91\x25\x17\x62\xed\x39\xfb\x39",
          "\x8a\x73\x48\x92\x21\x33\x83\xac\x54\xdc\x2c\x1f\x48\x84\x19\x38", 1,
          0, 128 },
        { 96, 192, 128, 99,
          "\xf9\x97\xa7\x9b\x63\xb1\xcf\x64\x14\x83\x70\x60\x97\xff\x4a\xbe\xeb"
          "\xa1\x39\x62\xdb\x05\x62\x06",
          "\xba\x95\x38\xad\x15\x75\xa1\xdf\x78\x79\x78\x2b",
          "\xaa\x13\xc1\x09\xb2\xf5\x7f\x70\x0a\x89\x93\x1d\xe7\x5b\x70\x80",
          "\xf3\x76\x94\x34\x59\xb6\x04\x1e\xd5\x23\x2d\x7b\x9f\xb5\xe9\xe6",
          "\x98\x2b\x14\xf6\x64\x82\xd0\xc9\x83\x71\xe0\x80\x78\xef\xa0\x12",
          "\x14\xf1\xb2\xb2\x45\x75\xa1\xa3\x32\x06\xac\xdf\x50\x0e\x9d\x46", 1,
          128, 128 },
        { 96, 192, 128, 100,
          "\xd7\xc6\xea\x0a\x28\x5a\x5d\x8c\x59\x64\x77\x30\x80\x48\x89\x67\xe7"
          "\xe6\x59\x35\x89\x0c\x32\x65",
          "\xf5\x11\xd1\x6e\x97\x2e\x13\x8d\x5a\xe8\xdd\xac", "",
          "\x50\x34\xfa\x6d\xa3\xa9\xee\x38\x0b\xe7\xe8\xd0\x26\x05\xac\x20"
          "\x23",
          "\x34\x50\xa9\x92\xa6\xfb\xce\x9c\xe2\x9f\x6c\x4f\x9f\x41\xc3\x6e"
          "\xf6",
          "\xed\x6c\xa1\xff\x3e\xa1\xa7\xca\x88\x19\x50\x11\x39\xf8\xa0\xb8", 1,
          0, 136 },
        { 96, 192, 128, 101,
          "\xb2\x93\x46\xa9\x5c\x3b\x65\x3c\x9b\xed\x02\x3d\xf2\xe0\x3b\x6d\xe4"
          "\x5b\x8d\xe1\xa4\x06\x7d\x86",
          "\xc5\xb4\x5d\xf3\xa5\xbf\x4e\xf5\x39\xc3\xdb\xd8",
          "\x40\x40\x59\x18\x9f\x1e\xaf\x31\xb2\xe5\x05\xfe\xc0\x8c\x70\x53",
          "\x22\xe6\x28\x1f\xba\x3e\x5b\x05\x68\x71\xa9\x8d\xd2\xef\x0e\x16"
          "\x4d",
          "\x6c\x26\x39\x28\x99\xe3\x65\x45\x00\x54\xbf\x0a\xb3\x3f\x98\x3f"
          "\x27",
          "\xc4\x72\x40\xbb\x8d\x1d\xbb\x68\x7f\xab\x77\x7f\x72\xad\xbd\x2a", 1,
          128, 136 },
        { 96, 192, 128, 102,
          "\xa6\x1e\xd3\xb8\x1d\x78\x56\x06\x02\x77\x74\x07\x75\x9b\x1f\x2c\xa3"
          "\x4c\xd7\x0c\x6b\x57\x79\x1b",
          "\x07\xb8\x24\x97\xb8\x15\xd1\x61\x82\x48\x10\x45", "",
          "\xdd\xc1\x86\x2e\x35\x31\x62\x2e\x69\x83\x22\xf0\xb1\xca\x6d\x22\x22"
          "\x31\xef\x14\xdb\xee\xa3\x36\x79\xd3\x1c\x48\x77\x7c\x88",
          "\xa0\xc1\x52\x6c\x88\xdc\xc2\x65\xf7\x5d\x4e\xf9\xb2\xa0\x00\xfb\x3c"
          "\xce\x9e\x5d\x99\x4c\x47\x2c\x46\xbf\xac\x38\x21\xd6\x11",
          "\x9a\xa6\xcd\xb8\x5b\x12\x6e\x1f\x21\xd0\x66\xa3\xc0\x5e\x82\xf6", 1,
          0, 248 },
        { 96, 192, 128, 103,
          "\x49\xf3\x3b\xc3\xc1\xa4\x0e\x1c\xa3\xb5\x6a\x49\x9e\x4c\x91\x37\xc1"
          "\x48\xd1\x25\x61\x55\xfd\xb6",
          "\x47\xbc\x33\xd9\x13\x49\x05\x68\x38\xb6\x24\x74",
          "\x44\x9c\x8c\xbb\x9a\x67\xad\xb0\x3f\x60\x64\x6e\x5b\x90\x46\x20",
          "\xa9\x20\xb4\xfe\xa9\x08\xb1\x77\x1d\x58\xd4\xc1\x08\x83\x8f\x3a\xf7"
          "\xb8\x41\x54\x97\x06\x3d\xd9\x69\x1a\x55\x23\x44\xd6\x42",
          "\x67\xad\xef\x99\x61\x1f\x34\x1d\x14\xea\x27\xe7\x2d\xa9\xb6\x58\xc9"
          "\xa7\x9e\x3b\x32\x8e\x79\x75\x8c\x9d\x34\xdb\x0b\xed\x06",
          "\xb2\xa4\x4d\x0f\xc9\x46\x06\xc4\xe2\xb6\xc3\x9b\x24\x2b\x3a\xca", 1,
          128, 248 },
        { 96, 192, 128, 104,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x74\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 105,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x77\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 106,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\xf5\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 107,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x54\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 108,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\x65\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 109,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb4\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 110,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb7\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 111,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\x36\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 112,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7b\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 113,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\xfa\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 114,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\x9e\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 115,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x94\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 116,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbf\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 117,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbc\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 118,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\x3e\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 119,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x85", 0,
          0, 128 },
        { 96, 192, 128, 120,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x86", 0,
          0, 128 },
        { 96, 192, 128, 121,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\xc4", 0,
          0, 128 },
        { 96, 192, 128, 122,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7a\xbe\x95\x75\xbe\x8e\x47\x04", 0,
          0, 128 },
        { 96, 192, 128, 123,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x74\x55\xdf\xe5\xb5\xe6\xf2\xb6\x7b\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 124,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\x65\xb5\xe6\xf2\x36\x7a\xbe\x95\x75\xbe\x8e\x47\x84", 0,
          0, 128 },
        { 96, 192, 128, 125,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x75\x55\xdf\xe5\xb5\xe6\xf2\x36\x7a\xbe\x95\x75\xbe\x8e\x47\x04", 0,
          0, 128 },
        { 96, 192, 128, 126,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x8a\xaa\x20\x1a\x4a\x19\x0d\x49\x85\x41\x6a\x8a\x41\x71\xb8\x7b", 0,
          0, 128 },
        { 96, 192, 128, 127,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          0, 128 },
        { 96, 192, 128, 128,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          0, 128 },
        { 96, 192, 128, 129,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\xf5\xd5\x5f\x65\x35\x66\x72\x36\xfa\x3e\x15\xf5\x3e\x0e\xc7\x04", 0,
          0, 128 },
        { 96, 192, 128, 130,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xef\x67\x20\x50\x90\x35\x75\x0e\xca\xfa\xc4\xb3\xe4\xfa\xc3\x56",
          "\x74\x54\xde\xe4\xb4\xe7\xf3\xb7\x7b\xbf\x94\x74\xbf\x8f\x46\x85", 0,
          0, 128 },
        { 96, 256, 128, 131,
          "\x80\xba\x31\x92\xc8\x03\xce\x96\x5e\xa3\x71\xd5\xff\x07\x3c\xf0\xf4"
          "\x3b\x6a\x2a\xb5\x76\xb2\x08\x42\x6e\x11\x40\x9c\x09\xb9\xb0",
          "\x4d\xa5\xbf\x8d\xfd\x58\x52\xc1\xea\x12\x37\x9d", "", "", "",
          "\x6d\xc4\xef\x59\xa7\x3e\xbc\xab\xb5\xe3\x4c\x0d\x34\xd9\xf2\xd7", 1,
          0, 0 },
        { 96, 256, 128, 132,
          "\xcc\x56\xb6\x80\x55\x2e\xb7\x50\x08\xf5\x48\x4b\x4c\xb8\x03\xfa\x50"
          "\x63\xeb\xd6\xea\xb9\x1f\x6a\xb6\xae\xf4\x91\x6a\x76\x62\x73",
          "\x99\xe2\x3e\xc4\x89\x85\xbc\xcd\xee\xab\x60\xf1", "", "\x2a",
          "\x06",
          "\x85\xca\x1f\x6c\x46\x28\x3c\xb5\xdd\x59\x60\xbd\x34\xa8\xdc\x36", 1,
          0, 8 },
        { 96, 256, 128, 133,
          "\x51\xe4\xbf\x2b\xad\x92\xb7\xaf\xf1\xa4\xbc\x05\x55\x0b\xa8\x1d\xf4"
          "\xb9\x6f\xab\xf4\x1c\x12\xc7\xb0\x0e\x60\xe4\x8d\xb7\xe1\x52",
          "\x4f\x07\xaf\xed\xfd\xc3\xb6\xc2\x36\x18\x23\xd3", "",
          "\xbe\x33\x08\xf7\x2a\x2c\x6a\xed",
          "\x7f\xd4\xb5\xd3\x09\x52\x35\xa3",
          "\xf6\x4d\x10\xb4\x1e\x3d\x69\x28\x74\x19\x47\xc5\x0c\xa0\x39\x1f", 1,
          0, 64 },
        { 96, 256, 128, 134,
          "\x59\xd4\xea\xfb\x4d\xe0\xcf\xc7\xd3\xdb\x99\xa8\xf5\x4b\x15\xd7\xb3"
          "\x9f\x0a\xcc\x8d\xa6\x97\x63\xb0\x19\xc1\x69\x9f\x87\x67\x4a",
          "\x2f\xcb\x1b\x38\xa9\x9e\x71\xb8\x47\x40\xad\x9b", "",
          "\x54\x9b\x36\x5a\xf9\x13\xf3\xb0\x81\x13\x1c\xcb\x6b\x82\x55\x88",
          "\x48\xdd\x95\x89\xa4\x7e\x63\x8b\xbb\xc2\xaa\x3e\x23\x2f\xa5\x29",
          "\xdf\x69\xfb\xe1\xf0\x99\xf0\x13\x4f\xe2\x86\x91\x56\xab\x07\xdb", 1,
          0, 128 },
        { 96, 256, 128, 135,
          "\x3b\x24\x58\xd8\x17\x6e\x16\x21\xc0\xcc\x24\xc0\xc0\xe2\x4c\x1e\x80"
          "\xd7\x2f\x7e\xe9\x14\x9a\x4b\x16\x61\x76\x62\x96\x16\xd0\x11",
          "\x45\xaa\xa3\xe5\xd1\x6d\x2d\x42\xdc\x03\x44\x5d", "",
          "\x3f\xf1\x51\x4b\x1c\x50\x39\x15\x91\x8f\x0c\x0c\x31\x09\x4a\x6e"
          "\x1f",
          "\x20\x22\x97\xd3\x6c\xa6\x2c\x5a\x1d\x44\x37\xfa\xfc\x7b\x50\xe7"
          "\x64",
          "\x66\x5f\x05\xa9\x6b\xf8\xde\x45\x36\x1d\xbf\x33\xc9\x8b\x09\x05", 1,
          0, 136 },
        { 96, 256, 128, 136,
          "\x02\x12\xa8\xde\x50\x07\xed\x87\xb3\x3f\x1a\x70\x90\xb6\x11\x4f\x9e"
          "\x08\xce\xfd\x96\x07\xf2\xc2\x76\xbd\xcf\xdb\xc5\xce\x9c\xd7",
          "\xe6\xb1\xad\xf2\xfd\x58\xa8\x76\x2c\x65\xf3\x1b", "",
          "\x10\xf1\xec\xf9\xc6\x05\x84\x66\x5d\x9a\xe5\xef\xe2\x79\xe7\xf7\x37"
          "\x7e\xea\x69\x16\xd2\xb1\x11",
          "\x3c\x0a\x0b\x34\x94\xd7\x5c\xcb\xcf\xfa\xa9\x17\xd6\x15\x92\x94\xfd"
          "\x93\xe8\xa2\xee\x66\x44\x7a",
          "\xb0\xb0\x7b\xa0\x51\x67\xe8\x8c\x24\xe5\x48\x24\xa0\x70\x61\xb9", 1,
          0, 192 },
        { 96, 256, 128, 137,
          "\x2e\xb5\x1c\x46\x9a\xa8\xeb\x9e\x6c\x54\xa8\x34\x9b\xae\x50\xa2\x0f"
          "\x0e\x38\x27\x11\xbb\xa1\x15\x2c\x42\x4f\x03\xb6\x67\x1d\x71",
          "\x04\xa9\xbe\x03\x50\x8a\x5f\x31\x37\x1a\x6f\xd2", "",
          "\xb0\x53\x99\x92\x86\xa2\x82\x4f\x42\xcc\x8c\x20\x3a\xb2\x4e\x2c\x97"
          "\xa6\x85\xad\xcc\x2a\xd3\x26\x62\x55\x8e\x55\xa5\xc7\x29",
          "\x0e\x29\xb2\x33\x5b\x90\x07\x58\xfa\xd2\x78\xae\xfb\x9b\x3a\xfa\x07"
          "\xfd\x42\xb5\xd2\xf7\xd3\x87\xe3\xea\x0e\x0c\xa4\x16\xe0",
          "\x6e\xd7\xe1\xe1\x27\x8c\x40\xce\x2e\x78\x1d\x10\x05\xde\x88\xdd", 1,
          0, 248 },
        { 96, 256, 128, 138,
          "\x51\x55\xde\xe9\xaa\xde\x1c\xc6\x1e\xe7\xe3\xf9\x26\x60\xf7\x59\x0f"
          "\x5e\x5b\xa8\x2f\x1b\x59\xb8\x50\xe3\xfa\x45\x3d\x2f\xa6\xb3",
          "\xc2\x6c\x4b\x3b\xfd\xb9\x7e\xe6\xb0\xf6\x3c\xa1", "",
          "\x27\x34\xe0\x8e\xff\x8f\x5c\x4f\x84\xfa\x0c\x20\x7f\x49\xc7\xfd\x78"
          "\xaf\x1a\xd5\x12\x3f\xf8\x1f\x83\xf5\x00\xed\xf4\xed\xa0\x9e\xdf",
          "\xae\xd2\x4e\x00\x82\xe1\x3e\xe1\x5b\xa0\x50\x6a\x83\x6c\x78\xb9\x7e"
          "\xf2\xfa\xa3\xc6\xe8\xeb\x37\x8d\xc6\x4d\xd4\xad\xc9\x98\xad\x68",
          "\x5b\xa1\xb4\x8a\x70\x16\x84\xd9\x40\xbe\x24\x4c\x3d\xe9\x38\xd2", 1,
          0, 264 },
        { 96, 256, 128, 139,
          "\x95\xe8\x7e\xda\x64\xd0\xdc\x2d\x4e\x85\x10\x30\xc3\xe1\xb2\x7c\xca"
          "\x22\x65\xb3\x46\x4c\x2c\x57\x2b\xd8\xfc\x8c\xfb\x28\x2d\x1b",
          "\xce\x03\xbb\xb5\x67\x78\xf2\x5d\x45\x28\x35\x0b", "",
          "\x2e\x5a\xcc\x19\xac\xb9\x94\x0b\xb7\x4d\x41\x4b\x45\xe7\x13\x86\xa4"
          "\x09\xb6\x41\x49\x0b\x13\x94\x93\xd7\xd6\x32\xcb\xf1\x67\x4f\xdf\x25"
          "\x11\xc3\xfa\xd6\xc2\x73\x59\xe6\x13\x7b\x4c\xd5\x2e\xfc\x4b\xf8\x71"
          "\xe6\x62\x34\x51\x51\x7d\x6a\x3c\x68\x24\x0f\x2a\x79\x91\x6a",
          "\x2f\xa0\xbd\x2c\xdf\xe9\xe8\xd7\x91\x9b\x97\xba\x05\xd5\x9e\x33\x89"
          "\xfd\xcb\xa7\x28\xec\x12\x4d\x0f\x28\x49\x48\x4f\x63\x5a\x00\x0e\x73"
          "\x4c\x8c\x80\x94\x1b\x3d\xa3\x2d\x23\xee\xa5\x1e\xdc\xe8\xd6\x61\x7b"
          "\x16\xeb\xb4\x3a\xc8\x11\x3a\x09\x2e\x9d\xda\xa3\x72\x1a\xe9",
          "\xa9\x25\x2a\x50\xdd\xbb\xf1\x8c\xd3\xe4\x3a\xdc\x0b\xa1\xa4\x81", 1,
          0, 528 },
        { 96, 256, 128, 140,
          "\x7a\x4c\xd7\x59\x17\x2e\x02\xeb\x20\x4d\xb2\xc3\xf5\xc7\x46\x22\x7d"
          "\xf5\x84\xfc\x13\x45\x19\x63\x91\xdb\xb9\x57\x7a\x25\x07\x42",
          "\xa9\x2e\xf0\xac\x99\x1d\xd5\x16\xa3\xc6\xf6\x89",
          "\xbd\x50\x67\x64\xf2\xd2\xc4\x10", "", "",
          "\x56\x9d\x82\x69\x18\x92\xe1\x03\xe6\x27\x40\x7c\x95\xf0\x8a\x0e", 1,
          64, 0 },
        { 96, 256, 128, 141,
          "\xb9\x07\xa4\x50\x75\x51\x3f\xe8\xa8\x01\x9e\xde\xe3\xf2\x59\x14\x87"
          "\xb2\xa0\x30\xb0\x3c\x6e\x1d\x77\x1c\x86\x25\x71\xd2\xea\x1e",
          "\x11\x8a\x69\x64\xc2\xd3\xe3\x80\x07\x1f\x52\x66",
          "\x03\x45\x85\x62\x1a\xf8\xd7\xff",
          "\x55\xa4\x65\x64\x4f\x5b\x65\x09\x28\xcb\xee\x7c\x06\x32\x14\xd6",
          "\xab\x01\xf9\x2d\xb4\xf2\x10\xbd\xb5\xed\xaf\x0a\x1b\xd1\x9e\xba",
          "\x62\x16\x30\xc5\x05\xd2\x4e\x3b\x29\x29\x49\x77\xd8\xff\xa4\xb4", 1,
          64, 128 },
        { 96, 256, 128, 142,
          "\xf6\x0c\x6a\x1b\x62\x57\x25\xf7\x6c\x70\x37\xb4\x8f\xe3\x57\x7f\xa7"
          "\xf7\xb8\x7b\x1b\xd5\xa9\x82\x17\x6d\x18\x23\x06\xff\xb8\x70",
          "\xf0\x38\x4f\xb8\x76\x12\x14\x10\x63\x3d\x99\x3d",
          "\x9a\xaf\x29\x9e\xee\xa7\x8f\x79",
          "\x63\x85\x8c\xa3\xe2\xce\x69\x88\x7b\x57\x8a\x3c\x16\x7b\x42\x1c"
          "\x9c",
          "\xf0\x5e\x29\x0b\xbb\xc6\x19\x27\xfa\x65\x76\x06\x48\xdc\xca\x88"
          "\xb0",
          "\xb7\x21\xbe\x96\xa6\xb9\x5c\x09\x31\xfb\x24\x3d\xd1\x28\x7c\x70", 1,
          64, 136 },
        { 96, 256, 128, 143,
          "\xaf\x1a\xc1\x9b\x3b\x84\xea\xaf\x26\x03\x37\x9c\xdd\x1d\xc1\xae\xe4"
          "\xa4\x84\xfd\xc2\xc1\x90\x69\x1a\xfc\xc5\xb7\x62\xf9\xb5\x26",
          "\xda\xf9\x8f\x1b\xd4\xc0\x71\xc6\xb1\x00\xf9\xc4", "\x14", "", "",
          "\xe7\x72\xcc\x77\x14\xef\xce\xfb\xd1\x15\x08\xde\x48\x9f\x7c\x61", 1,
          8, 0 },
        { 96, 256, 128, 144,
          "\x95\xfb\x78\x61\xf8\xc7\x5e\x14\x24\xd8\x40\x1c\xa3\xb3\x45\x2c\x56"
          "\x3b\x99\xb0\x02\xc2\x4a\xfa\xd4\xcf\x5e\x82\x8f\x23\x53\xed",
          "\xc1\xac\x60\x8d\x1f\xda\x28\xeb\x40\x34\x07\x9c", "\xfb\xc8", "",
          "",
          "\x54\xf2\xd2\xa5\x4c\xbe\x6e\x95\x9d\x51\xba\x4f\xfa\x8e\x0e\x9e", 1,
          16, 0 },
        { 96, 256, 128, 145,
          "\xd3\x0e\x68\x2b\x58\x4d\x41\x60\x88\xa8\x1b\xd6\xf8\x55\x51\xec\x1f"
          "\x2e\x11\x89\x38\x8a\x7a\x9c\x05\x21\xe2\x5b\x72\x5f\x7d\xbe",
          "\x92\x72\x14\xf6\x43\x36\x70\x1a\x3b\x4d\xb6\x03",
          "\x5c\xdb\x70\x70\x08\xb0\x65", "", "",
          "\x2c\x6b\x6b\xef\x6b\xa0\x82\xba\xa7\x24\x15\xaa\xaa\x88\x3c\x75", 1,
          56, 0 },
        { 96, 256, 128, 146,
          "\xac\x5a\x03\x8c\xae\xa8\x47\x5e\x71\xca\x41\x03\x93\x88\xb8\x61\xf0"
          "\x08\xb6\x0c\x62\xff\x2e\x91\x4f\xf0\x83\x39\x86\x2f\xb8\x50",
          "\xac\x38\x11\x7b\x39\x6a\xa0\x68\x43\x31\xfe\x74",
          "\x02\xd1\xd0\x0a\x8f\x1f\x05\x2c\x08\x35\x75\xeb\x0c\x2a\x09", "",
          "",
          "\xd2\xe3\xaa\xdf\x9e\xd6\x0d\x91\xda\x5a\x1d\xc1\x21\xdb\xfd\x24", 1,
          120, 0 },
        { 96, 256, 128, 147,
          "\xef\xa5\xc5\x05\x3b\x45\x20\x02\xfc\x34\x53\x12\xa3\xbe\x65\x0e\x9f"
          "\xf4\x24\x4a\x1e\x44\x55\x7d\x8a\x41\x55\x70\xd2\xdb\xe9\x02",
          "\x1a\xbf\xb6\xe3\x18\x99\x5e\xa0\x22\xb1\xd3\x69",
          "\x01\xa1\x0b\xc7\x1a\x88\xc9\x4a\x3f\xf9\x24\xfe\x74\xcc\xa2\x29",
          "", "",
          "\x8e\x97\x80\xcc\xa8\x6d\x3c\xa4\x02\xe1\xdf\xaa\x03\xa7\x2d\x77", 1,
          128, 0 },
        { 96, 256, 128, 148,
          "\xbd\xf2\x99\x4d\xd0\xfe\xb3\xc8\x70\xb3\x9f\x52\xbc\xc7\x6d\x28\xee"
          "\xd7\x12\xd9\x11\xd9\x56\xc0\x42\xe4\x70\x1c\x4b\x20\xe5\xd5",
          "\x0a\x82\x3c\x80\x1d\x05\x7e\x84\x3a\xf7\xca\x55",
          "\x03\xf3\xd0\xfc\x23\xdd\x8f\x3e\x20\x88\x4d\x3c\x6f\xff\x26\x08"
          "\xb1",
          "", "",
          "\x36\x88\x6d\x89\xcd\xcc\xe1\x57\x49\x7f\xd0\x9d\xcd\x67\xf3\x29", 1,
          136, 0 },
        { 96, 256, 128, 149,
          "\x5a\xe3\xc3\xff\x78\xce\xdc\x19\x2c\xa7\x04\x4b\x3f\x41\xa2\x42\x43"
          "\x2b\x0e\xa7\xd3\x48\x8c\x68\x0c\xd4\x22\x51\x5b\x09\x3b\x5b",
          "\x7c\x62\x04\x28\x69\xa2\xe5\x97\x01\x48\x16\x14",
          "\x7b\xa3\xf3\xbb\xba\x5d\xff\x63\x74\x88\x06\x4b\x6a\x52\x49\xd2\xad"
          "\x46\x17\x17\x27\x87\x19\xfe\x71\xfe\xbf\x71\x00\x82\x8e",
          "", "",
          "\x3f\x8b\x8f\x90\x4c\xeb\x30\x45\x05\xf9\x42\xf3\x6c\xca\xc5\xf8", 1,
          248, 0 },
        { 96, 256, 128, 150,
          "\xa8\x10\x8c\x33\xda\x05\x9f\xed\xf6\x02\x2a\x6e\xc4\x95\x27\xbe\x0a"
          "\xb6\x40\x02\x47\x2c\xb2\xf7\x03\xb9\x7e\x01\x79\xa3\x43\x12",
          "\xbc\xe6\x36\xca\x40\x1a\x88\xfa\xc2\x36\x1e\xd1",
          "\x35\xea\xc1\x65\x26\xc2\xf1\x0a\x12\x71\xb3\xa8\xf8\x10\xbb\xf2\x39"
          "\xee\xb9\x61\xe1\xa7\xe9\x20\x5b\xea\xe6\x00\x45\xf0\x08\xe6",
          "", "",
          "\x43\x0c\xcb\xb1\xf7\x5d\xe0\x6b\x71\x63\x7d\x1a\x76\xb3\x5c\xf5", 1,
          256, 0 },
        { 96, 256, 128, 151,
          "\x4c\x8e\x95\xa7\x36\x1b\xb3\x78\x49\xb1\x6f\x0e\x5f\x9a\x6e\xab\x87"
          "\x39\x13\x39\xd9\x51\xd7\x40\x4f\xf5\xcd\x82\x9c\x08\x7a\x6b",
          "\xb4\xa8\xde\x71\xfb\x0f\xe1\x72\xff\x6d\x89\xb6",
          "\x94\xd0\x6e\xdc\xfa\x5a\xe3\xd2\x7b\x99\x53\xfe\x5d\xf0\xcc\xa6\x19"
          "\x4f\xf6\xdf\xa9\x4d\x82\xb7\x35\x9c\xb3\x87\xdd\x5e\x80\xc6\x18\x6f"
          "\xbf\x17\x48\xc1\x92\xbb\x0c\x68\x8e\xbb\x47\x1b\x90\x20\xfe\x8f\xbf"
          "\xae\xe3\xde\xe8\x78\x7a\xce\x3c\x20\xdd\x50\xbe\x08\x3e",
          "", "",
          "\xda\x7f\xe2\xa4\x46\x9e\x39\x1c\x20\x5b\x6d\xe8\xe1\x82\xa9\x14", 1,
          520, 0 },
        { 96, 256, 128, 152,
          "\x7d\x00\xb4\x80\x95\xad\xfa\x32\x72\x05\x06\x07\xb2\x64\x18\x50\x02"
          "\xba\x99\x95\x7c\x49\x8b\xe0\x22\x77\x0f\x2c\xe2\xf3\x14\x3c",
          "\x87\x34\x5f\x10\x55\xfd\x9e\x21\x02\xd5\x06\x56", "\x02",
          "\xe5\xcc\xaa\x44\x1b\xc8\x14\x68\x8f\x8f\x6e\x8f\x28\xb5\x00\xb2",
          "\x6f\xe8\x78\x84\xb9\x4e\xac\x04\x1c\xb4\xc7\x8c\x23\xf2\x83\xa3",
          "\x7e\xeb\x30\x08\x25\x49\x63\x72\x24\xe9\x26\xe5\x27\xb6\x9a\xea", 1,
          8, 128 },
        { 96, 256, 128, 153,
          "\x64\x32\x71\x7f\x1d\xb8\x5e\x41\xac\x78\x36\xbc\xe2\x51\x85\xa0\x80"
          "\xd5\x76\x2b\x9e\x2b\x18\x44\x4b\x6e\xc7\x2c\x3b\xd8\xe4\xdc",
          "\x87\xa3\x16\x3e\xc0\x59\x8a\xd9\x5b\x3a\xa7\x13", "\xb6\x48",
          "\x02\xcd\xe1\x68\xfb\xa3\xf5\x44\xbb\xd0\x33\x2f\x7a\xde\xad\xa8",
          "\xe0\x17\xbf\x1d\xdd\x27\x98\x86\xf7\x54\x53\x65\xf1\x46\x5c\xc7",
          "\x6d\xca\xb7\x9d\x1d\xda\xb4\xf3\xad\x8b\x4a\xf7\x23\x18\xeb\x1b", 1,
          16, 128 },
        { 96, 256, 128, 154,
          "\xda\xcd\x51\xa8\xa8\xe4\xd5\x90\x5b\x4c\xbb\x94\x7e\xf4\x01\x3e\xb2"
          "\x96\x88\x93\x53\xf3\xc9\xee\x35\xf5\x57\x7b\x26\x73\x7a\x51",
          "\x3f\xa3\x78\xa1\xbe\xfd\xdd\xd6\x1a\xe6\x8c\xf4",
          "\xbb\x5a\x38\x12\xf0\xae\xfd",
          "\xe1\x48\x31\x38\x83\xa7\x7d\xa1\x21\x12\x4d\x06\xb1\xc7\x7d\xca",
          "\xdd\xf8\xad\xe1\x3d\x69\xf3\x64\x9e\x36\xc6\x69\xd2\x5b\x4d\x81",
          "\x01\x86\x15\x57\xd4\x3a\xb0\x14\xc4\xed\xe1\x9f\xcd\x75\x48\xea", 1,
          56, 128 },
        { 96, 256, 128, 155,
          "\x8e\x34\xcf\x73\xd2\x45\xa1\x08\x2a\x92\x0b\x86\x36\x4e\xb8\x96\xc4"
          "\x94\x64\x67\xbc\xb3\xd5\x89\x29\xfc\xb3\x66\x90\xe6\x39\x4f",
          "\x6f\x57\x3a\xa8\x6b\xaa\x49\x2b\xa4\x65\x96\xdf",
          "\xbd\x4c\xd0\x2f\xc7\x50\x2b\xbd\xbd\xf6\xc9\xa3\xcb\xe8\xf0",
          "\x16\xdd\xd2\x3f\xf5\x3f\x3d\x23\xc0\x63\x34\x48\x70\x40\xeb\x47",
          "\xc6\x0d\x2a\x92\xe6\x0a\x1a\x73\xa9\xce\x4b\x22\x69\xe1\x3a\x45",
          "\x71\xfa\x66\x5b\x61\x1f\xed\x6e\xf5\xe6\x7e\xe8\x27\xac\x20\x6d", 1,
          120, 128 },
        { 96, 256, 128, 156,
          "\xcb\x55\x75\xf5\xc7\xc4\x5c\x91\xcf\x32\x0b\x13\x9f\xb5\x94\x23\x75"
          "\x60\xd0\xa3\xe6\xf8\x65\xa6\x7d\x4f\x63\x3f\x2c\x08\xf0\x16",
          "\x1a\x65\x18\xf0\x2e\xde\x1d\xa6\x80\x92\x66\xd9",
          "\x89\xcc\xe9\xfb\x47\x44\x1d\x07\xe0\x24\x5a\x66\xfe\x8b\x77\x8b",
          "\x62\x3b\x78\x50\xc3\x21\xe2\xcf\x0c\x6f\xbc\xc8\xdf\xd1\xaf\xf2",
          "\x72\x2a\xc6\xa2\x26\xf4\x9c\x90\xab\x22\x52\x7a\x51\x38\xb4\x01",
          "\x2e\x4e\xe9\x97\xc7\x52\x78\x3e\x74\x3b\x36\x6b\xb6\xb3\x50\xa5", 1,
          128, 128 },
        { 96, 256, 128, 157,
          "\xa5\x56\x9e\x72\x9a\x69\xb2\x4b\xa6\xe0\xff\x15\xc4\x62\x78\x97\x43"
          "\x68\x24\xc9\x41\xe9\xd0\x0b\x2e\x93\xfd\xdc\x4b\xa7\x76\x57",
          "\x56\x4d\xee\x49\xab\x00\xd2\x40\xfc\x10\x68\xc3",
          "\xd1\x9f\x2d\x98\x90\x95\xf7\xab\x03\xa5\xfd\xe8\x44\x16\xe0\x0c"
          "\x0e",
          "\x87\xb3\xa4\xd7\xb2\x6d\x8d\x32\x03\xa0\xde\x1d\x64\xef\x82\xe3",
          "\x2f\xad\xf1\x6a\xd1\x6a\x21\xc3\x17\xaf\x9d\x0b\xc1\x87\xf1\x36",
          "\x88\xca\xf7\x0f\x6b\x5d\x8f\x3e\xf6\xa3\x9d\x1a\xe4\x13\x77\x2b", 1,
          136, 128 },
        { 96, 256, 128, 158,
          "\x07\x74\x33\x02\x2a\xb3\x4d\x38\x0f\xc1\x92\xfc\x24\xc2\xed\xc6\x30"
          "\x1f\xec\x6f\x24\x44\x2f\x57\x2a\x10\x87\xff\x2e\x05\xb3\x9a",
          "\x28\xad\xcb\xc7\x43\x64\xf2\x6d\xd4\xb3\x10\x8b",
          "\xe0\x10\x0e\xb1\x16\xcd\xc5\xe2\x2a\x3b\x9f\x9b\x41\x26\xc1\x49\x59"
          "\x5e\x75\x10\x7f\x6e\x23\x7c\x69\xe8\x29\x60\x05\x22\x70",
          "\x03\xc8\x74\xee\xaa\xa6\xfa\x9f\x0d\xa6\x2c\x75\x8f\xb0\xad\x04",
          "\x13\x6f\x04\x9e\xa8\x51\xc6\xdf\xd2\xe8\x73\x12\xd8\x2f\x08\x82",
          "\xfd\xf9\xbc\x04\x12\xcf\xca\x2b\x03\x5c\x5a\xe6\x8a\xc6\xda\x79", 1,
          248, 128 },
        { 96, 256, 128, 159,
          "\x39\x37\x98\x6a\xf8\x6d\xaf\xc1\xba\x0c\x46\x72\xd8\xab\xc4\x6c\x20"
          "\x70\x62\x68\x2d\x9c\x26\x4a\xb0\x6d\x6c\x58\x07\x20\x51\x30",
          "\x8d\xf4\xb1\x5a\x88\x8c\x33\x28\x6a\x7b\x76\x51",
          "\xba\x44\x6f\x6f\x9a\x0c\xed\x22\x45\x0f\xeb\x10\x73\x7d\x90\x07\xfd"
          "\x69\xab\xc1\x9b\x1d\x4d\x90\x49\xa5\x55\x1e\x86\xec\x2b\x37",
          "\xdc\x9e\x9e\xaf\x11\xe3\x14\x18\x2d\xf6\xa4\xeb\xa1\x7a\xec\x9c",
          "\x2c\xed\x0d\x04\x32\x3d\xb2\x0a\xa8\xb8\xb9\x00\x0d\x2c\x33\xa5",
          "\x48\xb8\x1c\xb7\x0d\x55\x5b\x7c\x38\x49\x2b\xa2\xc0\xa3\xb1\xb8", 1,
          256, 128 },
        { 96, 256, 128, 160,
          "\x3f\x49\x4f\xd8\xf1\xb5\x06\x92\xde\x9c\xe3\x3f\x6d\x45\x1e\xf0\xc5"
          "\x8c\x6b\x2c\x6f\xfb\xa3\xb4\x17\x10\xff\x63\xe6\x7e\xda\x68",
          "\x9e\x62\x8e\x58\x03\x51\x92\x90\xe6\xb2\xc6\x8a",
          "\xd0\x2e\xc8\x92\xd3\xb0\x3e\xac\xb2\xf1\xd8\xa6\x0a\x02\x84\x85\x77"
          "\x6a\xf0\xfd\x66\x65\xcb\x6f\x74\xfb\xa5\xef\x89\x7e\x2c\xf5\x4b\x32"
          "\xe8\x0b\xdd\xee\xc9\x38\xab\x53\x0b\x45\xed\x97\x12\x34\x80\x4f\xa8"
          "\x4a\x19\x1d\xc1\x1a\xe6\x60\xf5\xa8\x66\x2a\x46\x51\xe9",
          "\xf2\xc4\x1a\x26\xa4\x38\xe9\xff\x73\x3b\x78\x28\xf2\x4a\x24\x49",
          "\x1d\x9f\x42\x56\xe0\x84\x66\x56\x0a\xb2\x71\xde\x36\x21\xa0\x3f",
          "\x81\xdb\xe3\x8a\xc7\x51\x12\x7e\xfc\x11\xca\xed\xec\xa9\xc9\x3b", 1,
          520, 128 },
        { 96, 256, 128, 161,
          "\xc1\x80\xc1\x2e\x6a\xf8\xcc\x07\x19\x04\x9e\xfe\x99\xd4\xdf\x2d\xe2"
          "\x41\xef\xec\x5a\x01\x31\x45\xb2\xb7\x5e\x15\xdb\xa1\x6f\xe5",
          "\x12\x6f\xbb\xd6\x99\xbe\xb3\x74\xf6\x7b\xaa\x7b", "", "", "",
          "\x15\xdc\x4b\x81\x22\xb0\xe5\xad\x13\xdb\xea\x70\x96\xe8\x18\x68", 1,
          0, 0 },
        { 96, 256, 128, 162,
          "\x80\x03\xe6\x54\x7a\x96\x4c\xd5\xc2\x84\x41\xc9\xb1\xa3\xc0\x83\xcc"
          "\xb9\x6c\x7e\x13\x83\x85\xa5\x29\x4a\x1c\x30\x6b\x05\xf9\xf4",
          "\xf2\x51\xc4\xa2\x62\x5c\x61\x2f\x86\xec\x16\x50",
          "\x8c\x6e\xea\x97\x56\x15\x5d\x6e\xa9\x59\x5c\xc4\x9e\x8a\x74\xe1",
          "", "",
          "\xe6\xe9\x1b\xfe\x55\x18\xb7\x6e\x0a\x2d\xca\x79\xc6\x4d\x23\x2b", 1,
          128, 0 },
        { 96, 256, 128, 163,
          "\xa4\x20\xe4\xf9\xa6\x16\xbf\x63\x1a\x94\x9b\x32\x4a\xe9\x01\x6a\x77"
          "\xd9\x43\xa0\xfd\x1d\xa2\xb3\xe9\x74\x2e\x2e\xe5\x0f\xa0\x97",
          "\x77\xf6\x71\x99\xab\x7b\x96\xf6\xf4\x83\x2c\x01", "",
          "\xfc\xaf\x04\xe3\x33\xd8\x76\xae\x34\xfc\xab\x93\xaf\xd7\xba\xa7",
          "\x13\x55\xcd\x0e\x1b\x42\xb1\x78\x81\x83\x00\x9a\x11\xca\xd5\x38",
          "\x59\xd3\x5f\x9a\x12\xbe\xd5\xb5\xca\x87\x0b\x28\xba\xdb\x27\xf4", 1,
          0, 128 },
        { 96, 256, 128, 164,
          "\x69\x05\xf2\xc4\xd6\x3a\x7b\xa7\xe9\x36\x6b\xa6\xc3\xbb\xf6\xe3\x55"
          "\x2d\x56\x9e\xb5\x53\x21\xbe\xba\x3f\x8d\x98\xa1\x82\xb9\x7d",
          "\x49\xe0\x8c\x06\xdb\xae\x3f\xf5\xcb\x7d\x9e\xcd",
          "\xab\xa0\xc4\x4e\x9f\x93\x99\x74\x8f\x4a\x7e\x91\x9c\xeb\x8a\x62",
          "\xb5\x62\x54\xe2\x21\xcf\x55\x8e\xa7\xd9\x19\x4e\xec\xd6\x3e\xd5",
          "\x68\xe6\x6f\x43\x3c\x3c\xf9\xe4\x24\x72\x25\x68\x2f\x4c\x73\xa4",
          "\x07\xf5\x3a\x76\xb8\x44\x60\xec\xf4\xaa\x18\x13\xe5\x17\x0b\x2f", 1,
          128, 128 },
        { 96, 256, 128, 165,
          "\x77\x0b\x39\x74\x1c\x56\xd4\x67\x00\xa9\xf3\xcc\x23\x1d\x1a\xcb\x17"
          "\x44\x98\x70\x2c\x0f\x2d\x0e\xec\x20\xdb\x57\x49\x4b\xb4\x9e",
          "\x93\x84\xa1\xec\xbe\xe1\xde\x2b\x5a\xe7\x06\x84", "",
          "\xea\x0b\x32\x28\xb8\x3c\xa6\x61\x50\xa7\x9a\xba\x15\x9e\x50\x6b"
          "\x75",
          "\x40\x52\xc0\xfc\x81\x63\x46\xc8\x69\x21\xdb\x57\x64\x6f\xeb\x29"
          "\x43",
          "\xa1\x9a\x58\x53\x10\xce\xb2\xdf\x76\x7e\xc1\x72\x4d\x52\xe3\x9d", 1,
          0, 136 },
        { 96, 256, 128, 166,
          "\x41\xd6\xc6\xba\xbb\x72\x41\x53\x9a\xc1\x66\x47\x48\xdd\x1c\xf2\x9c"
          "\xe7\x94\x0e\x29\x15\x3c\xd8\x18\x0e\xd1\x97\xda\xb5\xc7\x3f",
          "\x00\x05\xde\xa1\x2e\xb6\x98\x50\x64\x7c\x7a\xd9",
          "\x67\x5f\x31\xd7\x6b\xf4\x83\xd2\xd2\xab\x57\xcb\xe9\x3c\xf2\xf1",
          "\xe5\xc4\x44\xa0\x45\x8d\xca\xf7\x89\xc8\xf3\x56\x66\xf1\x5b\xcc"
          "\xb4",
          "\x99\xa4\x9b\xde\x03\x72\x8c\x47\x9d\xaf\x4c\x67\xd3\x07\xf1\x28"
          "\x5e",
          "\xf0\xf3\x85\x9d\x12\xcd\x41\x48\xb9\xe8\x4d\x22\xba\x7a\xd9\x66", 1,
          128, 136 },
        { 96, 256, 128, 167,
          "\xbc\x53\x6d\x8d\x9b\x43\x40\xcd\x14\x14\x7f\xca\x7c\xa3\x65\x73\xba"
          "\x45\xbf\xf5\xb0\xa7\xcb\x80\x91\xa5\x50\xcf\x2b\x4b\xb9\x45",
          "\x17\x86\x94\xeb\x62\xd7\x77\x3b\x0f\x0f\xbe\x8b", "",
          "\xfb\x82\x20\x33\xc4\x43\x76\x80\x30\x1f\x72\xff\xc7\x4b\xa3\xbd\x46"
          "\x7a\x9a\xb7\x46\x5a\xe4\x5e\xc8\x7a\xb4\xbe\xfd\x7c\xc9",
          "\xb6\xce\x6d\x86\xab\x7e\xee\x1f\xdd\x7d\xcb\x95\x5b\x83\x24\x36\x08"
          "\x39\xeb\x2b\xdd\xd8\x21\xec\xc1\xef\xe1\x29\x18\x26\x89",
          "\x72\xfd\x99\x7b\xf0\x58\x9a\xa2\xd6\x07\x21\x65\x4f\x55\x2e\x3a", 1,
          0, 248 },
        { 96, 256, 128, 168,
          "\xf5\x9a\xbc\xbf\x42\x18\xbd\x5c\x76\x01\xf0\x80\xb5\xfb\xd3\xae\x08"
          "\x87\x33\x70\x2c\x8f\xbe\xf0\xc5\x29\x6a\x40\x6f\x56\x38\x27",
          "\xa5\xeb\x0e\x6f\xe6\x69\xe6\x82\x39\xac\xe5\x50",
          "\xd6\x03\x49\x1f\xbf\x09\x50\xd3\x64\x89\xab\xb4\x0d\xd8\xd4\x2b",
          "\x97\xdc\xba\xcd\x70\xa6\x78\xcf\xae\xd1\x3c\x94\x2c\xf9\x20\xe8\x51"
          "\xec\x3e\x6f\xb1\xf6\xc6\xeb\x95\xf1\xc9\x65\xfb\x1a\x13",
          "\xc0\xb2\x7e\xdd\x65\x33\xcf\xba\x81\x32\x3a\xc7\x8d\x0a\xeb\x03\x71"
          "\xb1\xd7\xb8\x99\x38\xe0\x4c\x31\x91\x48\x96\x15\x13\xfb",
          "\x56\xaa\xbb\xde\x47\xab\x2c\x53\xdb\x48\x70\x30\x33\xf8\xca\x68", 1,
          128, 248 },
        { 96, 256, 128, 169,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8a\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 170,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x89\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 171,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x0b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 172,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc3\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 173,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\xf7\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 174,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0c\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 175,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0f\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 176,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x8b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 177,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x93\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 178,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x12\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 179,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\xa0\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 180,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2e\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 181,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb8\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 182,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xbb\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 183,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\x39\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 184,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x11", 0,
          0, 128 },
        { 96, 256, 128, 185,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x12", 0,
          0, 128 },
        { 96, 256, 128, 186,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x50", 0,
          0, 128 },
        { 96, 256, 128, 187,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x0b\x92\x80\x2f\xdc\xb9\xd7\xd4\x90", 0,
          0, 128 },
        { 96, 256, 128, 188,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8a\xc2\xdd\x77\x0d\xe5\x8f\x0b\x93\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 189,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\xf7\x0d\xe5\x8f\x8b\x92\x80\x2f\xdc\xb9\xd7\xd4\x10", 0,
          0, 128 },
        { 96, 256, 128, 190,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8b\xc2\xdd\x77\x0d\xe5\x8f\x8b\x92\x80\x2f\xdc\xb9\xd7\xd4\x90", 0,
          0, 128 },
        { 96, 256, 128, 191,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x74\x3d\x22\x88\xf2\x1a\x70\xf4\x6d\x7f\xd0\x23\x46\x28\x2b\xef", 0,
          0, 128 },
        { 96, 256, 128, 192,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 0,
          0, 128 },
        { 96, 256, 128, 193,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff", 0,
          0, 128 },
        { 96, 256, 128, 194,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x0b\x42\x5d\xf7\x8d\x65\x0f\x8b\x12\x00\xaf\x5c\x39\x57\x54\x90", 0,
          0, 128 },
        { 96, 256, 128, 195,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x9d\x2a\x30\xab\xc5\xe1\x78\xf7\xc6\x31\x7e\xc9\x49\x8d\xac\x39",
          "\x8a\xc3\xdc\x76\x0c\xe4\x8e\x0a\x93\x81\x2e\xdd\xb8\xd6\xd5\x11", 0,
          0, 128 },
        { 56, 128, 128, 196,
          "\x19\xd5\x32\xdb\xcc\x93\x4a\x00\x9c\xe1\xb9\x4a\x0b\x31\xdd\xc7",
          "\xf0\xbf\x6a\x9b\xcf\x6c\x0d", "", "", "",
          "\x7b\x12\x26\x3a\xaf\x1e\x4c\xb6\xe4\xb4\x06\xe0\x26\x69\x82\x09", 1,
          0, 0 },
        { 56, 128, 128, 197,
          "\x8c\xdb\x7f\x67\x89\x27\x1a\x6e\xf3\xe0\x64\x61\xe9\x0e\xaa\x0e",
          "\x7c\x0d\x6b\xce\xba\x28\x2e", "\xfb\xc4\xf4\xa5\x2e\xcb\x4c\xaa",
          "", "",
          "\x50\xb1\x2c\x1f\xa4\xdc\x4b\x2d\xc4\xdd\x0e\xb1\x52\xdb\x41\x9e", 1,
          64, 0 },
        { 56, 128, 128, 198,
          "\x6b\xd7\x36\x3b\xe8\x1b\x3f\x80\x3c\x7f\xae\xe6\x07\x05\x02\x74",
          "\x30\x3d\xa6\x78\xd1\x67\x9e", "",
          "\x53\x9c\x7d\x6f\xcc\x0a\x69\x1b\xd3\x9b\xc4\x34\x22\xd4\xe1\x3c",
          "\x38\x33\x8e\x92\x4b\xf2\xec\xc3\xae\x0f\x5f\x75\xf2\xaf\x2d\x30",
          "\xe4\x0b\xbb\xa6\x73\x49\x55\x22\x3f\xab\x6d\xdb\x3c\x7b\xba\x83", 1,
          0, 128 },
        { 56, 128, 128, 199,
          "\x5b\x49\xd6\x7b\x0a\x74\xe3\xf3\x9e\x8d\x0b\xac\x6a\x00\x50\x40",
          "\xb9\xbb\xb9\xae\x00\x3b\x08", "\xaa\xdc\xed\xa4\x4e\x5d\x23\x23",
          "\xfe\x66\xe3\x59\xd3\x40\xec\x00\x24\x17\x36\xc2\xa6\x78\x90\x02",
          "\xa4\x41\xe2\xeb\x45\x8f\x8a\x6f\x2a\xc7\x56\x27\xab\x10\x85\xef",
          "\x5c\x54\x51\x81\x68\x52\x79\x65\x21\x87\x81\x9a\xa6\xd1\x5b\x86", 1,
          64, 128 },
        { 56, 128, 128, 200,
          "\x6a\x5b\x3b\x57\xf8\x3c\xac\x23\xeb\xbb\x97\xa6\x0f\x9c\x13\xc3",
          "\x64\xc0\x18\x42\xe7\x3e\x74", "",
          "\x7d\xab\x0c\x47\x34\x73\xdf\x8d\x30\x12\xc3\xfd\xf0\x93\xf0\x07"
          "\x09",
          "\xfb\x8f\x96\x40\x65\x71\x8f\x93\x90\x10\xea\x5e\x5d\xa3\x27\xcd"
          "\xdb",
          "\xed\xd3\x49\xc3\x74\xc3\xd0\xdb\x1a\xc3\x6f\x11\xb1\x50\x6d\x2c", 1,
          0, 136 },
        { 56, 128, 128, 201,
          "\xeb\x26\x3b\x3a\x87\xfc\xf2\x32\x32\x7a\x05\xb2\x07\x92\x92\xab",
          "\x95\x54\x02\x3b\xad\xf3\xe2", "\xbe\x0d\xd7\x00\x2e\x2f\xe3\x58",
          "\x0c\xac\x1a\xfd\x57\x08\xab\x03\xc8\xd3\xfe\x1d\x7c\xc8\x3b\x26"
          "\xff",
          "\x81\x86\x0e\x45\xcb\x00\x9f\x57\x28\xf8\x0f\xd1\xdf\x21\x4f\x84"
          "\x49",
          "\xa2\xcb\x64\x54\xa2\xa4\x9e\x96\xed\xca\x89\xb9\x4e\x49\xc5\x0c", 1,
          64, 136 },
        { 64, 128, 128, 202,
          "\xf3\x43\x47\x25\xc8\x2a\x7f\x8b\xb0\x7d\xf1\xf8\x12\x2f\xb6\xc9",
          "\x28\xe9\xb7\x85\x17\x24\xba\xe3", "", "", "",
          "\x1c\x64\x58\x30\xe6\xee\x05\x58\x9b\x70\xf0\x23\x47\xe1\x1c\x93", 1,
          0, 0 },
        { 64, 128, 128, 203,
          "\xea\xf5\xc7\xe3\x5b\x61\xc6\x4f\xd8\x99\xbf\x26\x50\x6c\xb8\x3c",
          "\x07\x1f\xfe\xd7\x58\x5e\xb0\xb7",
          "\xf0\xaf\x44\x31\xf3\x3e\x7e\x15", "", "",
          "\xe5\xe1\x54\xd4\x3f\x32\x98\x89\x6b\x34\xbb\x4f\x76\xb7\x39\x9f", 1,
          64, 0 },
        { 64, 128, 128, 204,
          "\xde\xb6\x22\x33\x55\x9b\x57\x47\x66\x02\xb5\xad\xac\x57\xc7\x7f",
          "\xd0\x84\x54\x7d\xe5\x5b\xbc\x15", "",
          "\xd8\x98\x6d\xf0\x24\x1e\xd3\x29\x75\x82\xc0\xc2\x39\xc7\x24\xcb",
          "\x97\xbc\x3c\x09\xd5\xe3\x71\x78\xe7\xfd\xd3\x5d\x53\x23\x91\x80",
          "\x3a\x2d\xc0\xbf\xde\x10\x24\x70\x29\xf5\xc4\x89\xe3\x06\xa3\x96", 1,
          0, 128 },
        { 64, 128, 128, 205,
          "\x9e\xbe\x10\xef\x15\xeb\xcc\x60\x00\xed\x72\xd9\x74\x21\x9b\x97",
          "\x28\xa8\x40\x39\xf2\xda\xe6\x51",
          "\x1b\xab\x91\x6d\x21\xbc\xbb\x35",
          "\xd0\x73\xa8\x8d\x45\x36\x41\x51\x40\x87\x18\x78\x69\x30\xed\xfb",
          "\x6a\xdf\x7f\x96\xa3\x20\x22\x71\xb0\x37\x87\x37\x2f\x4c\xf3\xce",
          "\x50\xbc\xdd\x15\x2a\xe3\x31\x55\x48\x78\xf9\xa2\xb8\x14\x0e\x72", 1,
          64, 128 },
        { 64, 128, 128, 206,
          "\x74\xdf\xd2\x96\x3b\xc8\x14\x83\x38\x09\x44\x14\xe3\xfc\x2b\x8d",
          "\xd1\xef\x66\xef\x2e\xb7\x65\xb8", "",
          "\x17\x9c\x18\x65\xe2\xbc\x0f\x70\x24\x87\xc4\xe5\x4f\x83\x74\x45"
          "\x7e",
          "\xa4\xb7\xb9\xc9\xc9\x02\xed\xdb\x02\xfb\x64\x87\x31\x40\x25\x6e"
          "\x94",
          "\x4b\xc1\xe9\x91\x48\xf6\xa4\x72\x2d\x4b\x92\x73\x4b\x08\x8d\x43", 1,
          0, 136 },
        { 64, 128, 128, 207,
          "\x5b\xf0\x96\x5f\x14\x39\xed\x83\xee\xde\xaa\xd9\x46\x7f\x5f\x60",
          "\xb9\x26\x8f\xec\xa7\x29\x68\x0f",
          "\x31\xfb\x02\xa7\xf4\xeb\xe9\xaa",
          "\xc8\x44\xb6\xc4\x57\xe1\xe5\xf4\x3f\x82\xb4\xe4\x84\xb4\x70\x9e"
          "\xf1",
          "\x61\x1e\xe7\xdf\x91\xb0\x62\xb7\x5d\xf8\x6b\x10\xa4\xce\xeb\x01"
          "\x34",
          "\x9a\x56\x7c\x20\x65\xd7\x83\x2c\x35\xf6\x14\x3a\x41\x41\x46\x62", 1,
          64, 136 },
        { 72, 128, 128, 208,
          "\x2e\xc7\xa4\x68\xe3\x64\x91\x86\xe1\xf9\xde\xcc\xdf\x95\xa2\x29",
          "\x99\xfd\xb1\x58\xfb\x8e\xbc\xce\x64", "", "", "",
          "\x65\x8f\x01\xf9\x0c\x35\x33\x1c\xdd\x69\x86\xf7\x36\xcc\x37\xda", 1,
          0, 0 },
        { 72, 128, 128, 209,
          "\xc6\xbc\x09\x87\xb5\xdc\x94\x32\xda\x66\xbd\xb1\x53\x85\x9f\xda",
          "\xd7\x68\xd1\xb8\x0a\x09\x45\x06\xb4",
          "\x47\x13\xf8\x6a\x53\xce\xdd\x50", "", "",
          "\x4e\xc3\x1d\xfe\xbf\xf4\xa9\x0d\x5e\xfb\xdb\x85\x04\xcd\x8c\x79", 1,
          64, 0 },
        { 72, 128, 128, 210,
          "\x6a\x1c\x98\xe4\xd2\x0b\xc6\xad\x59\x48\x33\xd6\xe9\xaa\x47\x94",
          "\x3d\xe2\x9d\x92\xd3\x01\x8e\xaa\xfc", "",
          "\xf6\x23\x32\x2f\xef\x6d\x49\xcf\x7a\xbf\xa1\x6b\x5f\xd8\x39\x51",
          "\xaf\xcb\xf0\x38\x5f\x26\x89\x5b\xcd\x61\x26\x60\x06\xdc\x1d\x98",
          "\x79\x14\xe3\x2d\x18\x10\x43\x32\x12\x34\xdc\x16\xd7\x9b\x35\x76", 1,
          0, 128 },
        { 72, 128, 128, 211,
          "\x02\x2b\x66\x9b\x7d\x39\x1f\x0f\xf5\xfa\xb1\x23\xc2\xba\x88\x17",
          "\x2e\x02\xb0\x4c\xe6\xb3\x48\xef\x86",
          "\xf9\xc8\x62\x29\x17\x05\x51\x9b",
          "\xab\xb1\x8f\x46\x62\xc1\xbf\xa7\x98\x45\x60\xde\xac\x4a\x41\x5a",
          "\x45\xc3\xab\x70\xb1\xc8\x83\xc9\x8b\x53\xfc\x9c\x0b\xe7\x7e\xcb",
          "\x2e\xce\xd5\xeb\x7d\x60\x43\x1c\x09\xd3\xba\x49\x23\x0b\x23\xd0", 1,
          64, 128 },
        { 72, 128, 128, 212,
          "\x89\x65\xe6\x41\xf4\x6d\xbb\xb1\x6a\xa8\x3f\x94\x59\x37\x0d\xc9",
          "\x31\x0c\x4e\xe0\x82\xc4\x87\x0f\xc2", "",
          "\x5d\x22\x78\xc8\xb4\xed\x8a\x37\xc9\x54\x88\x93\x5c\x1d\xb0\x6e"
          "\x68",
          "\xdb\x91\xb9\x8d\xa5\x78\xd8\xe4\xeb\xf1\x8f\x65\xf2\x44\x57\x9e"
          "\xb7",
          "\x21\x25\xef\x21\xfc\xba\x47\x10\x39\xc1\x31\x78\x6c\x99\xe7\x4e", 1,
          0, 136 },
        { 72, 128, 128, 213,
          "\x22\xc9\x42\xb1\x21\x2a\x3c\xfa\x19\x6e\x9a\xd0\x6b\x03\xfb\x2b",
          "\x71\xa2\xb8\x75\x40\xb1\x1d\x76\xa6",
          "\xc0\xe0\x59\x60\xb8\x31\xe8\x75",
          "\x4e\x3b\x6e\x3e\x2b\xa5\x66\x3e\xeb\xc5\xd8\x3d\xc2\x49\xea\xbc"
          "\xe1",
          "\x6f\xfa\x87\x5b\x85\x3c\xc4\xf6\xa4\x1a\xfd\x43\x0b\xd7\xc3\xce"
          "\xee",
          "\x0b\x49\x64\x85\x6b\xb2\xb2\x7e\xda\x38\x26\xae\x12\x8f\x67\xb3", 1,
          64, 136 },
        { 80, 128, 128, 214,
          "\x1e\x6c\x62\x14\xa6\xa5\xdd\x5b\x62\x8c\x71\xde\x07\x78\x81\x37",
          "\x40\xbc\xc3\x15\xde\xc8\x8b\xf3\x26\xcc", "", "", "",
          "\xdf\xd7\x0e\x3e\x5a\x13\x16\x6b\x46\x06\x13\xab\xab\x92\x8f\x26", 1,
          0, 0 },
        { 80, 128, 128, 215,
          "\xe4\x13\x43\xe5\xff\xe2\x0f\xe4\x8f\xf0\x10\xb1\x46\xce\xae\xad",
          "\x5f\x17\x2f\xbe\x9f\x8e\xec\x0f\xbf\x79",
          "\x9b\x46\x67\x59\x01\xa4\xbe\x0f", "", "",
          "\x21\x04\xbc\x9e\xcb\x79\xb7\x1f\x32\xf2\x7c\x9e\xe4\xfe\xc6\x40", 1,
          64, 0 },
        { 80, 128, 128, 216,
          "\xfc\x93\x58\x2f\xa1\xf8\xb5\x8c\xc9\xe8\x0d\xd5\x83\xe9\xbf\x8b",
          "\x5d\x4b\xf5\x87\x98\xfa\xc3\x51\xa3\x99", "",
          "\x86\x6d\x5e\x1b\x0a\xa2\x90\x04\xe5\x1e\xa8\x7d\xe8\x6e\x3c\x05",
          "\xb6\x46\x50\xb6\x93\x5f\xb0\x4b\x97\x42\xf5\x72\x9f\x28\x6e\x03",
          "\xb9\xd3\x94\x7c\x16\x05\xa2\xd5\x8e\xc3\xf3\x22\x18\x46\xc7\xda", 1,
          0, 128 },
        { 80, 128, 128, 217,
          "\xdf\x2d\xb4\x8b\x19\x44\xfd\x9e\x24\x58\x9d\x14\x35\x7d\x0f\x80",
          "\xf9\xa1\xbb\x32\xf5\x79\xb5\xf0\x27\x28",
          "\x03\x92\x26\x00\xd7\xd0\x33\xdd",
          "\xea\xfb\x69\xe4\x02\x38\xa3\x4e\x39\x85\x23\xfb\x35\xbd\x66\x12",
          "\x9d\xe6\xac\x37\xf5\x2b\x81\x35\x04\x7a\xf8\xd5\xe5\x7f\xb3\x6e",
          "\x05\x43\x35\x1a\xa8\x6f\xf8\xca\x58\x25\xbd\x7b\xb7\xc0\x25\x4e", 1,
          64, 128 },
        { 80, 128, 128, 218,
          "\x3b\xf8\xc3\xc3\x01\x19\x0d\x23\xf7\x1a\xc8\x2c\x0c\x5b\x0f\x9b",
          "\xd5\x27\x44\x06\xa4\xf5\xa2\xe2\xd1\x01", "",
          "\x03\xca\x74\xe5\x8b\x8b\x38\x50\x0e\x1e\x65\xb8\x33\x2f\x41\xf0"
          "\x6c",
          "\x99\x9f\x47\x6b\x51\xce\x68\x6a\xf5\x9b\x0b\xbe\x22\x1c\xe4\xe8"
          "\xa4",
          "\x2a\xc4\x83\x77\xd2\x39\xfa\x7f\xfb\xe3\xc5\x03\xe0\x27\x8f\x98", 1,
          0, 136 },
        { 80, 128, 128, 219,
          "\x16\x94\x2e\xb8\x9d\x4f\x7f\xe6\x5b\xf9\xb4\x9c\x16\xf8\x30\xab",
          "\x2b\xa7\x6d\x03\x99\x5c\x62\xdc\x7e\xd2",
          "\x32\xc7\xc6\x07\x2d\xbd\x73\x5f",
          "\xb2\x38\x0e\x9e\xb5\x96\xd5\xaf\x69\x7c\x0b\xa1\xd3\x01\xa8\x33"
          "\xd9",
          "\xf5\x63\xca\xb1\xf5\xe5\x6f\x23\x7a\x60\xc2\xc2\x95\x0a\xb7\xa5"
          "\xc2",
          "\x25\xc8\x9e\x41\x0c\x0a\x53\x5b\x94\xa3\x83\xad\x3c\x01\x44\x64", 1,
          64, 136 },
        { 88, 128, 128, 220,
          "\x9d\x2f\xa7\x59\x29\x61\x2e\x12\x13\x46\x0f\x99\x89\x46\xdc\xec",
          "\x0e\x94\x8a\x03\xdb\xfa\x10\x81\x7e\x88\x26", "", "", "",
          "\x2f\x1f\xa3\x58\x5b\x9a\x11\xff\x47\xbd\x48\x6f\x95\x57\x22\x46", 1,
          0, 0 },
        { 88, 128, 128, 221,
          "\x7a\x97\x04\x06\xa7\x47\xc2\x32\x7e\xcb\xc8\xb1\x07\xa1\x90\xcd",
          "\x99\xb0\x79\xde\x95\x2d\x60\xda\x0d\x03\x4b",
          "\x2f\x08\x0b\x2d\xeb\x66\x44\xef", "", "",
          "\x9d\xca\x9b\xa4\x41\x01\x3c\xe9\xfc\x0a\xc3\xdb\xf4\x14\x62\x6d", 1,
          64, 0 },
        { 88, 128, 128, 222,
          "\xac\xab\x31\x48\x3d\x9d\xe4\xad\x77\xf4\xe6\x3f\xe4\x1b\x57\xae",
          "\x5c\x09\x39\xe7\x1b\xae\x1a\x9d\xe1\x67\xd4", "",
          "\xe4\xd7\x2b\x2f\x7c\xb6\x9b\xc5\x4a\x49\xf4\xd5\xce\xa4\xf2\x3a",
          "\x0c\x50\x68\x43\xba\x7b\xd2\xdc\x45\x78\xe6\xbb\x83\xfd\x0c\x8d",
          "\xc2\x75\x37\x30\x37\x63\x5b\xae\x29\x4f\x99\xc8\xe4\x69\x64\xb3", 1,
          0, 128 },
        { 88, 128, 128, 223,
          "\x82\x84\x1e\xf7\xfb\xae\x35\x54\x65\x25\xfb\xbe\xbf\x47\x18\xfb",
          "\xb5\xcd\x81\x8f\x73\xa3\x6e\xd0\x25\xb6\xcf",
          "\x44\xf4\x8c\x2a\x20\x45\x63\x58",
          "\x8c\x2c\x82\x3b\xb3\x99\x41\xb1\xc6\xb7\x5b\xbc\x82\xf0\x5b\xa4",
          "\xb2\x87\xc6\x37\xa7\x55\x43\x62\xc8\x0d\x6b\x24\xd5\x0d\xdf\xb3",
          "\x39\x67\x27\x7d\xa0\xf8\x56\xf8\xf0\xad\x49\x28\x28\x94\xd2\xbb", 1,
          64, 128 },
        { 88, 128, 128, 224,
          "\xf9\xc6\xd9\x62\x7f\xd2\xe7\x31\xe2\xf1\x15\xb3\xd0\xa5\x3b\xfd",
          "\x08\x45\x58\xeb\xfb\x65\x82\xf3\xd1\x87\x9a", "",
          "\x74\x63\xaf\x94\x62\x62\x79\xce\x01\x12\xf6\x70\xc3\x11\x50\x99"
          "\xfd",
          "\xd4\x6b\x6e\x96\x2b\x6b\x7a\x23\x52\xfc\x43\x79\x14\xd9\xc0\xd9"
          "\xc0",
          "\xeb\xe3\x36\x17\x6e\x27\x04\x1a\xe7\x87\x91\xac\xa3\x45\x48\xc8", 1,
          0, 136 },
        { 88, 128, 128, 225,
          "\x1d\x28\x6e\x52\x5e\xc2\x86\x4d\x9e\xa6\xe7\xad\xfb\xdc\x49\x70",
          "\x1a\xd4\x48\x79\xf1\x94\x7a\xbd\x50\x3d\xce",
          "\x1d\xb0\xea\xaa\xa1\xe2\xc8\x48",
          "\x7b\x40\xe6\xc9\x87\x69\x2d\x02\x02\xcb\x6f\x44\xb4\x23\xc2\x67"
          "\xdd",
          "\x84\xf9\x1f\x9d\x35\xb9\x98\x59\x8e\x50\xfe\xb3\x4d\xca\xa0\xd2"
          "\x60",
          "\xae\x4e\x38\xcc\x4b\x73\x09\x44\xbc\x45\x9d\xf8\x5a\x53\x6f\x4e", 1,
          64, 136 },
        { 104, 128, 128, 226,
          "\x69\x4a\x2a\xe9\x4c\xc2\xfc\x6c\x82\xdc\xd1\x6c\x58\xa3\x41\x95",
          "\x8b\x4d\xe9\x49\x7e\x78\xd9\xc7\x3b\xdc\xb3\x74\xde", "", "", "",
          "\x36\xb2\x0b\xcb\x06\x46\x09\xcb\xc0\x3a\xe3\x27\x86\xf7\x2e\xb5", 1,
          0, 0 },
        { 104, 128, 128, 227,
          "\x26\x8c\x96\x1a\x4f\xa5\x4c\x21\x4a\x2a\xf8\xfe\x76\xa2\x77\xcc",
          "\xf1\x34\x43\xda\x0e\x41\x2f\x1c\xc7\xa9\x01\x65\xc6",
          "\x4f\xad\x12\xb4\x02\xc5\x80\x29", "", "",
          "\xbe\x58\x07\x13\x42\xc9\x34\x8b\xaf\x78\x10\x4e\x22\x58\xe6\x16", 1,
          64, 0 },
        { 104, 128, 128, 228,
          "\x7c\x5a\xa1\xcd\x2f\xc1\x71\xd5\xbb\x91\xee\x74\xf3\x1e\x1a\x63",
          "\x70\xa2\xa5\x30\x37\x34\x51\x78\x27\xfa\xa7\xee\x78", "",
          "\x4b\xd1\xd3\x42\x7e\x07\x35\xa0\x8f\x47\x5b\xc7\x3e\xc3\x64\x8c",
          "\x9a\xb6\x12\x14\xea\x66\x11\x51\x07\x06\x31\x5f\x0f\xc9\xbd\x65",
          "\xa2\xb3\xfc\x3c\x13\x49\xcb\xfd\x9d\xed\x7c\xc3\x2e\xff\xb3\x89", 1,
          0, 128 },
        { 104, 128, 128, 229,
          "\xe7\x4b\x73\xc2\xad\x93\xd3\x8d\xd4\x43\x2d\x6e\x51\xd3\xe3\xec",
          "\x06\xee\x28\xea\x53\x2f\xf5\xaa\xe6\xb0\xf6\xa2\x8a",
          "\x10\xbc\x98\x64\xf1\x33\x2e\x41",
          "\xaa\xd5\xd7\x58\x04\x1e\x54\x43\xed\xe7\xe9\xbb\xac\x1d\xb4\x90",
          "\xd3\xed\x6b\xb5\x5d\x98\xb0\x0e\x1b\x76\x93\x8a\x1c\x6b\xd5\xed",
          "\x22\x20\x1e\x4e\xb2\xa4\x22\x91\xa7\xd5\x7e\x35\x70\x82\xd7\x7e", 1,
          64, 128 },
        { 104, 128, 128, 230,
          "\xbe\x70\x77\x74\xd9\xea\xb3\x70\xdb\x4e\x82\x50\x29\x7a\x74\x37",
          "\x79\x44\xb4\x87\xd5\x9b\x6f\xfc\xc9\x6c\x9d\xf6\x2d", "",
          "\x28\xea\xb5\x68\x85\xe1\xe1\x2b\xd7\x2d\xef\x11\x38\x23\x7f\x0d"
          "\xbc",
          "\xee\x05\xff\xea\xab\x17\xbb\x4d\xe9\x45\x27\xe0\x29\x70\x58\xc4"
          "\x8b",
          "\xff\x89\x9f\x92\x9b\x37\x16\x39\xd4\x8c\x3c\x44\x7f\x51\xc5\x77", 1,
          0, 136 },
        { 104, 128, 128, 231,
          "\x30\x82\x94\x16\xd8\x0d\x4b\x6d\xd9\x1a\x16\xc4\x69\x4c\x5a\xcd",
          "\x8b\xc7\xec\xd5\xbd\xe1\x96\xb7\x23\x19\xde\x6b\x77",
          "\x97\x0f\xe6\x5b\x77\x89\xa5\x55",
          "\x4a\x31\x22\xf8\x01\xd6\x63\x82\x28\xfa\x0e\x30\xaf\x3f\x36\x62"
          "\x7a",
          "\x51\x25\xed\x68\xaf\xbd\x34\xbc\x00\xc7\x31\x71\xad\xa3\x1e\xe8"
          "\x4a",
          "\x1d\xa3\x20\xc8\xba\xb5\x25\xe3\x75\xf3\x7a\x3b\xba\x3e\x0e\xb9", 1,
          64, 136 },
        { 56, 192, 128, 232,
          "\xb4\x54\x4c\xae\x6b\x60\xb7\x72\x0f\x3a\xde\x71\xe9\x0e\x58\xc2\x1d"
          "\x6e\x48\x71\x83\xd4\x66\x6a",
          "\x2b\xa3\xda\x11\x2c\xf5\xe6", "", "", "",
          "\x34\x15\x51\xf2\xc0\x5e\xe9\x31\x4f\x0e\xb5\x52\x93\x9e\x54\x86", 1,
          0, 0 },
        { 56, 192, 128, 233,
          "\x26\xbd\xdb\x2e\xb2\xa7\x27\xe2\x91\x0d\xf9\x4a\xd3\xe1\x2a\xc1\x30"
          "\xa4\x9a\x8f\x7f\x41\x95\x1c",
          "\xc6\xc0\xef\x48\x15\x1b\x32", "\x74\x43\xb9\x1e\x73\x47\x5d\xe1",
          "", "",
          "\xfd\x7a\xab\x59\x5d\xfe\xb3\xc8\xa1\x66\x0e\xab\x04\x3b\x3d\x01", 1,
          64, 0 },
        { 56, 192, 128, 234,
          "\x80\x6e\xd9\xcf\x33\xa1\xc2\xfa\x6a\x8b\xff\xad\x79\x37\xc3\xea\x22"
          "\x64\x08\xeb\xf2\x48\xd1\x76",
          "\x2b\xeb\xcc\x0a\xf6\x72\xbf", "",
          "\xbe\x17\x02\x41\x48\x68\xc9\x4a\xeb\x99\xc1\xa0\x88\xba\x8c\x48",
          "\x6e\x6f\x3d\x3b\x36\x48\x2c\x39\xa9\x9d\x59\x7e\xa5\x82\xf4\x30",
          "\x7d\x11\xf5\x54\x9d\x87\xdd\xa7\xb0\x76\x22\x02\x27\x0a\x7e\x28", 1,
          0, 128 },
        { 56, 192, 128, 235,
          "\x09\x5f\xa6\x78\xa1\x04\xe9\xc3\xd2\x46\x30\x4c\x5d\xdd\xee\x04\x5d"
          "\xda\xb3\xd7\x9e\xa8\xa7\x26",
          "\xfe\xbf\x6b\xf7\xdd\x16\xa7", "\x6a\x44\x90\xba\x9f\x61\xdb\x88",
          "\xd2\x5e\xcf\xa8\x77\x89\x60\x30\x05\x8d\xca\xca\xb3\x15\x9c\xb3",
          "\xf3\x57\x8a\xca\x6d\x3c\xcb\xc9\x16\xf5\xc1\xd7\x1a\x45\x87\x8e",
          "\x8c\x73\x2f\x4a\x57\x1b\xf1\x05\xc6\xed\x1c\xef\x6f\xab\x28\x76", 1,
          64, 128 },
        { 56, 192, 128, 236,
          "\x98\x98\x8d\xa4\x62\xa4\x6a\xb3\xdd\x61\x3b\xd3\x70\x69\xf4\xf4\x29"
          "\xa9\xa8\x18\x41\xe7\x6d\xd3",
          "\xeb\xad\x9a\xf5\xf8\x69\xf5", "",
          "\xaa\x3f\xc0\x55\x74\xee\x10\x1e\xd7\x52\x7d\xe5\xda\x4a\xc3\x78"
          "\x60",
          "\x9b\x7b\xb3\x5d\xb7\x23\x71\x8c\x7f\x9f\xd8\xcd\x5c\x83\x12\x4e"
          "\x78",
          "\xa5\x95\x67\x30\x75\x77\xc8\xe8\x31\xc2\x3a\xc0\x9a\x92\xc6\xa1", 1,
          0, 136 },
        { 56, 192, 128, 237,
          "\x71\xde\x00\x8c\xd8\x20\xfc\x03\x39\x74\xb6\xb1\x30\x8f\x66\x28\x74"
          "\x25\x9b\x19\x56\x2e\x70\xf3",
          "\xe7\x25\xd3\x1d\xbf\x5b\x99", "\xd7\x67\xf4\x0e\x91\xc4\xf1\x5c",
          "\x83\x1a\x38\xcb\xea\xa9\xf2\x2e\xdf\x91\x8e\x97\x19\x56\xc1\x5f"
          "\xa3",
          "\xc8\xea\xf9\x54\x6a\xf7\x22\x61\x72\x3c\xeb\x3a\xe3\xbb\xb7\x30"
          "\x3c",
          "\x68\xd7\x28\x74\x4e\x59\x77\x34\x2d\x93\xaf\x81\x44\x58\x57\xed", 1,
          64, 136 },
        { 64, 192, 128, 238,
          "\xd7\x45\x99\xb3\xd2\xdb\x81\x65\x3d\xe4\x3b\x52\xfc\x99\x4c\x50\xd0"
          "\xbe\x75\x9f\xab\x87\xc3\x3a",
          "\xd1\xc6\x1c\xf8\x53\x25\x31\xb5", "", "", "",
          "\xbd\x78\xdf\xc8\x04\xa4\x20\xc1\x9f\xb1\x3b\x2f\x58\xd8\x2c\x5c", 1,
          0, 0 },
        { 64, 192, 128, 239,
          "\x8f\xc2\x69\xef\x34\xd2\xc2\x12\x7c\x89\x49\x3c\x09\x60\xee\x08\x49"
          "\xfa\xdf\x76\x66\x78\x85\xd5",
          "\x62\x6b\xf0\x0a\xcb\x93\x04\x80",
          "\x13\xaa\x17\x48\xae\xc4\x10\x42", "", "",
          "\x9c\x45\x32\x75\xaf\xb0\x06\xc7\x8f\x6f\x29\x07\x9c\x7c\x3e\xf1", 1,
          64, 0 },
        { 64, 192, 128, 240,
          "\x0b\x17\x71\x98\xc8\xb4\x19\xbf\x74\xac\xc3\xbc\x65\xb5\xfb\x3d\x09"
          "\xa9\x15\xff\x71\xad\xd7\x54",
          "\x8f\x07\x5c\xbc\xda\x98\x31\xc3", "",
          "\xc4\xb1\xe0\x5c\xa3\xd5\x91\xf9\x54\x3e\x64\xde\x3f\xc6\x82\xac",
          "\x01\x48\xcd\xf9\x0d\x56\x6a\x8e\xb6\x51\x40\x99\x56\xc3\x69\x5e",
          "\xb1\x0d\x57\xdf\x83\xc4\xc7\x9b\x9f\x59\x0e\x3e\x5a\xa9\xe9\xb6", 1,
          0, 128 },
        { 64, 192, 128, 241,
          "\xdb\x86\x9e\x55\x57\x6f\x57\xc8\xf9\x26\x49\x65\x9e\x3c\xb8\xbe\x10"
          "\x65\x6b\xbf\xf4\xb6\x94\x60",
          "\x67\xc0\x30\x53\x32\xe1\x31\x7b",
          "\x93\xf5\x3a\xb3\x6f\x45\xcb\xa3",
          "\x00\x2f\xbd\x2e\x0f\x39\xd4\x9f\x25\x8b\x3f\x73\x98\x39\x1e\x2c",
          "\x0c\xe4\xb1\xf5\x39\x22\xea\x14\x8f\x26\xa6\x38\xd1\xc9\xe7\x85",
          "\x9b\xe9\x41\x7b\x3f\xf9\xe8\xd5\xb2\x4e\x04\x14\x39\xb0\x2c\x86", 1,
          64, 128 },
        { 64, 192, 128, 242,
          "\x2a\xf9\x6f\x8c\xca\x1b\x56\x3d\x17\xe7\x96\x9e\x01\x64\x5e\xe7\xb9"
          "\xf5\x41\x3a\xc9\x3e\xa5\x70",
          "\x95\x8d\x1f\xaf\x8c\x12\x67\xd8", "",
          "\xc7\x1e\xd8\x02\x7c\x74\x56\x26\xea\x03\xbd\x25\x62\x8b\x99\xe1"
          "\xdd",
          "\xfd\x66\xcd\x92\x6b\xea\xdb\xee\x33\xcd\xae\x43\x82\x4f\xba\xcf"
          "\xc0",
          "\x8c\x8d\xaf\xb2\x02\x7f\x2b\x0c\x03\xf6\x2b\x5f\x9f\xcc\x0a\xd8", 1,
          0, 136 },
        { 64, 192, 128, 243,
          "\x5e\xd7\x70\x86\xec\x0d\xa8\xf6\xac\x00\x56\x3a\xd6\xfc\xb8\x50\x05"
          "\xac\x40\xf3\x92\x11\xb0\xe4",
          "\x4e\x70\xdf\xd4\x9c\xc2\xac\x76",
          "\x29\xbf\x75\x6a\x2f\x77\x06\x6b",
          "\xc0\x49\xdc\xf1\x5a\xf3\xf9\x75\x98\x7d\x5f\x12\x50\xfe\xf5\x41"
          "\x4f",
          "\x36\x96\x0d\xa0\x29\xe6\x7a\xee\xb1\x45\xd5\x7d\xc0\xda\x68\xac"
          "\x27",
          "\x09\x50\x5b\xad\xdf\x28\xcd\x84\x2f\xd7\xfa\x7c\x54\x4d\x0c\x48", 1,
          64, 136 },
        { 72, 192, 128, 244,
          "\xf1\x62\xa1\x09\x40\x12\xf6\xbf\xb1\x02\x70\xcd\x56\x09\xa2\x0d\xc2"
          "\x4d\xec\x37\x27\xf8\xe5\x98",
          "\x05\x62\xf0\x3f\x51\x24\x64\x2f\x40", "", "", "",
          "\xa9\xee\xf8\xc9\xf9\x46\x00\x06\xb7\x3f\x2d\xa2\x31\x7c\x7b\x7d", 1,
          0, 0 },
        { 72, 192, 128, 245,
          "\x0f\xa5\x86\x1e\xf4\x39\x18\x42\x65\x11\x2c\xa6\xea\x78\x5d\x21\x4a"
          "\x5b\xb1\x2d\xd1\x08\xe4\x34",
          "\x04\x1f\xfc\xd9\x55\xeb\x49\x39\xff",
          "\xbe\xed\x0c\x76\x3b\x56\xc5\x82", "", "",
          "\x39\xfd\x1a\x21\x07\x54\x0f\x9e\x6d\x33\xad\x23\xb4\x25\xdd\xef", 1,
          64, 0 },
        { 72, 192, 128, 246,
          "\x4f\x58\x9a\xaf\x03\xe1\x21\x95\x85\xf4\x11\x63\x1a\x2b\x28\x7f\x20"
          "\xe9\xcc\xa9\x33\x04\xd0\x04",
          "\xf0\xbd\x78\x63\xd3\x4b\x6c\x96\x3f", "",
          "\xca\x80\xf9\x13\x29\xf1\xcf\xd8\x78\x4b\xdb\x97\xdc\x0d\x5b\x01",
          "\x0c\x3f\x7b\x1e\x05\x85\xde\xaa\x80\x0a\x71\x05\xfc\x14\x13\x64",
          "\x94\x27\xfd\x74\x87\x0e\x29\xdb\x52\x7f\x7d\xf2\x47\x47\x79\x39", 1,
          0, 128 },
        { 72, 192, 128, 247,
          "\x07\x87\x9e\x22\xe8\xc3\xcb\x5b\x5f\xc2\x05\x7c\x39\x85\x90\x6c\x39"
          "\xaf\xf4\xe4\x0a\xae\x4e\x20",
          "\x4e\xde\x0c\x3a\xf9\xc0\xde\xbb\x8a",
          "\xcb\x33\x3d\x66\xbd\xe2\x47\x5d",
          "\xb9\xac\x42\xc5\xd3\x16\x90\x87\xa7\x21\x87\x9c\x19\x86\x59\x08",
          "\x6c\xf2\xcd\x3a\x10\x61\xd9\xb6\xfb\xe3\x62\x33\x77\xc6\xb4\x43",
          "\xf7\x29\x7a\x72\x66\xd2\xf7\xf7\xaa\x7e\xc0\x5e\x0f\x9b\xf9\xa9", 1,
          64, 128 },
        { 72, 192, 128, 248,
          "\x0b\x14\x4f\x06\x68\xff\xd1\xa9\x7f\xf2\xd2\xbf\x93\x44\xef\x0e\x28"
          "\x48\x96\x4a\xec\xb2\x85\x0f",
          "\x3b\x7f\x06\xb4\xba\x5b\x0b\x71\xec", "",
          "\x60\x0b\x5c\xa3\xe8\xcf\x20\xa0\x9f\xf7\x52\xec\x2e\x73\x78\xac"
          "\x1f",
          "\x58\xd5\x76\x23\x17\xcf\x50\x24\x62\x71\x59\xac\xe6\xb4\x8f\x79"
          "\x7f",
          "\x16\xee\x7c\x4a\xad\xf2\x58\x45\x80\x30\xe5\xaf\x1b\xdb\xed\x2d", 1,
          0, 136 },
        { 72, 192, 128, 249,
          "\xa3\xbd\xd0\x65\xfe\x64\x75\xdf\x94\xa2\x09\x2c\x3f\x72\xb1\xdc\xd3"
          "\xd0\xf0\x41\x3b\x4f\x34\xdc",
          "\xfe\xeb\x53\xf7\xcd\x16\xad\xc8\xe4",
          "\x6b\xa7\x08\x2e\x39\x8b\xab\x61",
          "\xd1\xe7\x61\x64\x72\xca\x17\x01\x5e\xea\xea\xc3\x0b\x5b\x22\xf0"
          "\x07",
          "\x95\x38\xe5\xa7\x0a\xc3\x3a\xd0\x92\x4f\x03\x8b\x34\xd1\x99\x5b"
          "\x7b",
          "\xcb\x45\x9d\x32\xbb\xfd\x20\x93\xeb\x4d\x79\x33\xd5\x0f\xfa\x27", 1,
          64, 136 },
        { 80, 192, 128, 250,
          "\x17\x2f\x22\xf2\xe5\x93\x64\xdc\x41\x8c\xd7\x51\xdf\xa8\x44\x4a\xe1"
          "\x86\x44\xc0\xf9\xa2\xbe\x84",
          "\xbf\x90\x26\xd3\xdd\xaa\x37\xe7\xf1\x80", "", "", "",
          "\xb0\x77\xff\x4f\xad\x9f\xf4\xa9\x4b\x6d\xe8\xa6\x6b\xa5\xb1\x6c", 1,
          0, 0 },
        { 80, 192, 128, 251,
          "\x14\x3e\xfb\xf8\xe0\x29\x3d\xd4\xc1\x31\x59\xcf\x26\x0e\xc5\x91\xf5"
          "\xf9\x2b\xb3\xaf\x8d\xd8\x63",
          "\x11\x1a\x95\xbb\xb6\x0f\x9a\x3b\xba\x53",
          "\x51\xc1\x46\x78\xc4\x54\x47\x77", "", "",
          "\x09\x9a\x7c\x50\x90\x44\x3c\xd4\x00\x0f\x97\x0d\x42\xbc\xd1\xd5", 1,
          64, 0 },
        { 80, 192, 128, 252,
          "\x4c\x41\x10\x4d\x3f\x40\x26\x5f\x9e\x35\xc3\x20\xa0\x1e\x78\x76\xc3"
          "\x14\x00\xa0\xbd\x4d\x70\x92",
          "\x85\xfd\xc8\x1a\xfd\x9f\x48\x28\x17\x7e", "",
          "\xba\x7c\xd0\x7d\xfd\x8b\x5c\xf6\xff\xd3\xdd\xb7\x63\x56\x12\xc6",
          "\x38\x6b\x63\x4a\x5d\xef\x89\xdc\x73\x02\x72\x4a\xd1\x19\x21\xfe",
          "\x4d\x79\x22\x01\xa9\x98\x88\x94\x57\xb4\xc8\x3c\xab\x0e\x5c\x35", 1,
          0, 128 },
        { 80, 192, 128, 253,
          "\x8b\xcd\xe5\x17\xdd\xc6\x3f\xed\xcc\xe8\xe3\x41\x81\xf2\x35\x30\xf4"
          "\x71\xd6\x85\x8c\x48\xdb\xf9",
          "\xbc\x6d\x51\xde\x0c\x0b\xe7\xc4\x59\x11",
          "\xe0\xb3\xfb\x36\xc7\xb1\x63\x41",
          "\x1b\x42\x19\x8b\x4a\xc0\x82\x24\xe1\xe7\x61\xa7\x72\x05\xe3\x92",
          "\xe8\x73\x99\x72\xe4\x18\x0e\x2e\x52\x01\x21\xd8\xe9\xaa\xd7\xc5",
          "\x6c\xee\xbc\x4d\x20\x29\x45\x38\x3e\x51\x1b\x7c\xad\xde\x56\x95", 1,
          64, 128 },
        { 80, 192, 128, 254,
          "\x37\xf0\xb2\xd5\x3d\x52\x40\x7e\xb9\xff\x33\x53\x0e\x74\xb4\xed\xf5"
          "\x82\x5a\x7b\xb3\x7c\x3d\xc5",
          "\x30\x3c\x76\x67\x53\x01\x1b\x63\x55\x44", "",
          "\x1e\xd6\xab\xb2\xf2\x83\xca\x7f\xde\x5d\xe6\x62\xbd\x70\x58\xa1"
          "\xea",
          "\x75\xa6\x0d\xf0\x77\x8e\xb9\x3a\x34\x07\x2e\x74\xfa\x3d\x6b\x02"
          "\x24",
          "\xf2\x7b\x8c\xfc\x5b\xf5\xd2\xb4\xb4\xd9\x3f\xb5\x84\xd7\x19\xff", 1,
          0, 136 },
        { 80, 192, 128, 255,
          "\x10\xa7\x79\xb2\x45\x74\x1f\x1a\xb3\x12\x4e\x0e\x50\x4f\xdc\xd3\x15"
          "\x78\x4c\x67\xd0\x13\x6f\xcb",
          "\x75\xa4\x46\x16\xee\x96\xb3\x0c\x9e\xca",
          "\x4c\x5d\x64\x71\xac\x20\xdf\x18",
          "\x57\xd7\x58\xf9\x24\xa6\xea\xef\xe4\xd2\x62\x59\x31\xfc\x84\x71"
          "\x07",
          "\xab\x7b\x01\xba\x57\xed\xc0\xa4\x1b\x19\x0f\xb0\xf1\xd5\x18\x6c"
          "\xd5",
          "\x3e\x93\xa4\x5f\x5c\xc5\xea\xca\x21\x50\xdb\x35\x34\xa8\x90\x3e", 1,
          64, 136 },
        { 88, 192, 128, 256,
          "\x87\xc5\x5b\x2f\x18\x5f\x17\x7f\xaa\xf4\xb1\x6d\x93\xaf\x6d\xad\x47"
          "\x71\x46\x34\x5d\x0e\xa9\x92",
          "\x09\x46\xc6\x99\x53\xf4\xb9\x52\xbc\x7c\x23", "", "", "",
          "\x25\x7b\x3c\x59\x7e\xcd\x1d\x67\xc3\xdd\x35\xdc\x70\xc6\x8e\x48", 1,
          0, 0 },
        { 88, 192, 128, 257,
          "\x82\x07\xe8\xd5\x7d\xcc\xdf\x54\x80\xf7\x02\xc1\xfa\x72\xd0\xc6\xd0"
          "\x2f\x1b\xad\xc6\xfc\x08\xc5",
          "\xc1\x8e\x46\xa7\x0c\x59\x29\x80\xa2\xcc\xc2",
          "\xbd\x2e\x2a\x9d\xa3\x2a\x9d\x67", "", "",
          "\x11\x45\xc2\x0b\x7f\x31\xd5\x7d\x45\x8a\xfc\x65\x0a\x6d\x45\x90", 1,
          64, 0 },
        { 88, 192, 128, 258,
          "\x2c\x2f\x7e\x8b\xb7\x5b\xa9\x31\xa7\x11\xec\xa4\xd3\x19\xe1\x9a\xd8"
          "\x97\x67\x24\x8f\xee\x53\x60",
          "\x21\xa1\x04\x56\x47\x0d\x08\x3c\xa7\xbd\x7c", "",
          "\x1e\x9f\x46\x74\x41\xe4\x87\xbf\x68\xd1\x0b\xe8\x53\xb2\x44\x79",
          "\x18\x6b\x50\xf0\xed\xf7\xb5\x23\x02\x13\x84\xf5\xd8\xc0\x90\x49",
          "\x8d\xb0\x12\x36\xb7\x15\xa7\x64\x32\xfc\xb0\x2c\xff\x2f\x6b\xa6", 1,
          0, 128 },
        { 88, 192, 128, 259,
          "\x0a\x3b\xf0\xa9\x26\xfb\x14\xa3\xb7\x16\xbf\xa0\x21\xa2\x08\xda\x03"
          "\x30\xe5\x7b\xed\x36\x82\x8a",
          "\xa0\xba\x36\xed\xc4\x3d\x93\x5e\xe9\x42\x13",
          "\x3f\xcd\x93\xcc\xb8\xe9\x79\x56",
          "\x9a\xb6\xc1\x09\xc8\x06\x9d\x05\x4c\xcb\xb5\xc3\x3c\x6e\x70\xd0",
          "\x27\xd1\xe3\x53\x23\x37\x55\xa2\xfe\x28\x23\x16\x37\x73\x9c\x46",
          "\xb9\xb7\x47\x65\xed\x3d\x53\x03\x1b\xf3\xc7\x34\x9e\x74\x34\x0e", 1,
          64, 128 },
        { 88, 192, 128, 260,
          "\xa6\x8d\xfe\x22\xce\xf2\xbf\xf0\xf2\x8d\x4b\x68\xc2\xa6\x93\x8b\x16"
          "\xdc\x21\x09\xba\xb0\x9c\x38",
          "\xfe\x76\xa0\x3b\x77\x0b\x43\x1d\xc6\x87\x2b", "",
          "\xf5\x56\x91\x55\x30\x58\x00\xbc\x94\x18\x4b\x1e\xf1\xc1\x52\xe1"
          "\x97",
          "\x34\x28\x2b\x16\x48\x9e\x7b\xc7\x13\x6a\x24\x98\x32\x8b\xd2\x2e"
          "\x76",
          "\xe9\xb7\xae\x57\xe2\xb7\xf6\x0d\x09\xf5\x0b\xed\x23\xb9\x34\x38", 1,
          0, 136 },
        { 88, 192, 128, 261,
          "\xff\xe5\xd2\xad\x71\xd4\x32\xd6\xcd\x5f\x10\x72\xec\x2a\xcb\x7d\x7c"
          "\xde\x9c\x5c\x61\x5d\x0e\xb9",
          "\xea\x21\x98\x30\x74\x02\xa1\x06\xea\x42\x93",
          "\xf9\x3d\xb4\xf4\xae\xc8\xaf\xe8",
          "\xc9\xdb\x4d\x10\xd4\x23\x40\xac\x73\x62\x71\xed\xf9\xf6\x58\x1c"
          "\xe8",
          "\xbd\x96\x0c\x7f\x60\x39\x2e\x8d\x0a\xfb\x28\xba\x16\xea\x63\xaf"
          "\xd3",
          "\xf2\xca\x88\xd5\x49\xdf\xf2\x07\xd9\x79\x75\x6d\x13\xe8\x65\xd9", 1,
          64, 136 },
        { 104, 192, 128, 262,
          "\xd4\x65\x54\x4b\x5d\xb9\xeb\x1c\x49\x5c\xaf\xaf\x5d\x9a\xc7\xe1\x0f"
          "\xaa\xe7\x45\x41\xa0\xa7\x18",
          "\x95\x82\xaf\xc3\x05\x56\xca\x12\xd1\x54\xc4\x2f\x03", "", "", "",
          "\x37\xf6\x18\xf8\xbb\x7f\xf8\x5e\xc6\x44\xb1\xcb\xcc\xa4\xc2\x8a", 1,
          0, 0 },
        { 104, 192, 128, 263,
          "\x6f\x1c\xce\x6a\x35\x3a\xa4\x5f\x92\x6f\xac\xbb\x68\x65\xd3\x59\x82"
          "\x60\xdb\x53\x90\xe9\x37\xad",
          "\xae\x0f\xe0\x77\x39\x85\x87\x74\x7a\x64\x2e\x54\x22",
          "\x32\x66\x99\xf5\x6a\xc2\x8d\xef", "", "",
          "\x07\x52\x0b\x38\x4c\xcc\xbb\x80\xb9\x67\x9a\x0e\xf4\x8c\xb6\xa8", 1,
          64, 0 },
        { 104, 192, 128, 264,
          "\x36\xf9\x7a\x97\xd1\xdd\x67\xe5\xf8\x3c\xcb\x52\x9d\xa2\x5a\x60\x4b"
          "\x68\xb8\xda\x90\x4f\xe3\xf6",
          "\x23\x93\xa0\xa0\xe0\xb8\xef\xdd\x59\xdb\x34\x36\xdc", "",
          "\xc0\x2f\x28\x77\x32\x33\xff\xca\x81\x2e\xaf\x1c\x94\x6c\xd8\xd1",
          "\xd4\x12\x86\xc4\x61\xfb\x65\xd4\x10\x66\xa1\x03\x88\xeb\x69\xc8",
          "\x07\x36\x96\xdf\xfa\x20\x71\x44\x00\x14\xdf\xac\x4c\x6c\xad\xb2", 1,
          0, 128 },
        { 104, 192, 128, 265,
          "\xf2\x58\xd3\x3f\x1f\x1f\x3a\xad\xe5\x10\x3d\x56\xc4\x35\x7b\x7a\x4f"
          "\x8d\xd2\x05\xe4\x60\x65\x8e",
          "\x14\xa9\xed\x95\x39\x52\x5f\x54\x0d\x9a\x46\xaf\x69",
          "\xb6\x71\x96\xee\x87\x89\x0f\x55",
          "\xf2\x22\xfd\xfd\x34\x3b\x57\xa7\x0d\x00\x2d\x14\xa3\x9c\xae\x59",
          "\xd2\x7c\xda\x7a\xda\x56\x38\xdb\x59\x94\x5a\x31\xd9\x3e\xf2\x43",
          "\xc2\xc6\x4d\xd8\xb0\x8e\x7b\x4b\x1c\xe6\x0d\x5b\x96\x83\x29\x89", 1,
          64, 128 },
        { 104, 192, 128, 266,
          "\xee\x79\x41\x97\xf2\x0e\x64\x3c\x38\x77\xad\x08\x5f\x03\x1c\x75\x0f"
          "\xf2\x32\x56\x8e\x53\xd7\xc3",
          "\x31\xea\xac\xed\x4a\x01\x42\xb6\x45\x5c\xf7\x16\xe9", "",
          "\x77\x2c\x05\xb2\x37\x7b\xe0\xb3\xbd\xfd\x9a\x35\x7c\x27\x66\x08"
          "\xb0",
          "\xe0\x6e\x98\xbf\x61\x2f\x13\x44\xfa\xc0\xc3\xef\x8d\x3a\x65\x6b"
          "\xa0",
          "\xfc\x26\xa2\x6f\x23\x14\xe5\xa2\x79\xc2\xc7\xd0\x7c\x04\x45\x85", 1,
          0, 136 },
        { 104, 192, 128, 267,
          "\xb1\xbb\xea\xe5\xfb\xa3\x04\x41\xe1\x2b\x1a\xd2\xf7\x4e\x27\x2b\xc2"
          "\x05\x22\x1f\xe3\x4a\x34\x95",
          "\x99\x6c\xf4\xb0\xed\xed\x6a\xf6\x6c\xef\xfb\xe8\xb7",
          "\xb3\xc3\x37\xb6\x58\x59\x6f\x4c",
          "\x39\x11\x39\x00\xd2\x87\xd9\x0c\x54\x01\xd2\x19\xaa\x52\x82\xb9"
          "\x1e",
          "\xd1\x92\x8c\xe8\x58\x77\xf1\xd1\xfd\x56\x96\xe5\x6b\xb5\x05\x91"
          "\xe7",
          "\x7b\x85\x27\xe9\x81\x92\xd7\x11\x1d\xaf\xff\x55\x17\x82\xf7\x01", 1,
          64, 136 },
        { 56, 256, 128, 268,
          "\x49\x18\x28\xf2\xdd\xdc\xff\x5f\x96\x6e\x66\x27\xf4\xb6\xa8\x5a\x2e"
          "\xa7\x6f\xd1\xe0\xb6\x11\x7a\x13\xe9\x4d\x0e\x81\xc0\x63\xa5",
          "\x4f\xee\xdf\x9d\x9c\x07\xe0", "", "", "",
          "\x1c\xa0\xa4\x18\xf3\x37\xa4\xc0\x4f\x21\x23\xfe\xfd\x31\x79\x6d", 1,
          0, 0 },
        { 56, 256, 128, 269,
          "\xa5\x79\x05\xb9\xeb\x31\xfb\xb1\xcc\x53\x96\x39\xe6\x70\xb2\xf1\xd1"
          "\x2e\x27\x71\x39\xb5\x1a\x09\x8c\xfe\xbc\x18\x20\xfb\xa1\xa4",
          "\x27\xcf\xf7\x6e\x28\xc6\x13", "\xdc\xd2\xf8\x4e\xd0\xea\xfa\xd0",
          "", "",
          "\x0b\x21\xf5\x0e\x20\x6c\x07\x21\xc6\xc0\x59\xf9\x20\x7e\x6d\x3a", 1,
          64, 0 },
        { 56, 256, 128, 270,
          "\x55\xfa\x96\xeb\x3c\x94\x5c\xab\x67\x6c\x42\xb8\xca\xac\x34\xa1\x71"
          "\x7d\x43\x37\xf4\xc9\x08\x06\xb2\x26\xd5\x68\x12\x1e\xc5\xe0",
          "\x20\x97\x98\x00\x6d\x01\x2c", "",
          "\x34\xef\x60\x3e\x3c\x8f\x93\xa0\xe4\xa4\x77\x3f\x7b\x57\xac\xea",
          "\x79\x7c\xa0\x5b\x20\xa1\x49\xd4\x2e\x5a\xb3\x38\x35\x85\x5b\x5c",
          "\x81\x91\xbd\x25\x4a\x6e\x98\x6e\x3c\x22\xe8\x10\x68\x94\xd6\x4f", 1,
          0, 128 },
        { 56, 256, 128, 271,
          "\xe0\xd8\x2f\x60\x88\xec\x67\x5d\x92\xec\x6b\x44\xa6\x7d\xc6\xeb\x66"
          "\x00\xf1\xb7\x42\xbd\xd5\xa8\x51\xb0\x36\xaf\x02\xee\xf8\x25",
          "\x06\xed\xf6\xab\x0c\x7a\x92", "\xe9\x8f\xdd\x29\x22\x91\xdd\x01",
          "\x5b\xb3\x63\x92\x65\xc8\x56\x3e\x6f\xb7\x38\xbe\xd8\xc8\x53\x2c",
          "\xcb\x25\x13\x41\x7f\x9c\xb5\x46\xd7\x38\x30\xb9\x19\xb2\xcb\x33",
          "\xd3\xc0\x6c\x16\x14\xf7\xca\x3b\x09\x52\xd6\x7a\x5b\xd0\xd0\x17", 1,
          64, 128 },
        { 56, 256, 128, 272,
          "\x12\x36\x80\xa3\x5c\x43\xcf\x61\x8c\x69\xf2\x81\x29\x81\x99\xe5\x4e"
          "\x40\x08\x0e\x16\x57\x7f\x31\x0f\x09\x6e\x36\x7e\xe3\xcd\x40",
          "\xfe\xea\x3f\x0f\x2d\x0e\xca", "",
          "\x33\xee\x63\x0f\x34\x58\x8d\xc6\x8f\x8f\x43\x9f\xa3\x19\xf4\xef"
          "\x1e",
          "\x0b\x9f\x38\xde\xa9\xdd\x82\x65\x6f\xc1\xc2\xe1\x65\x1b\x12\xe1"
          "\xc1",
          "\x03\x79\x8b\x2b\xaa\xf5\xaf\x45\xe6\x7a\x71\x6c\x7b\x2a\x2a\x17", 1,
          0, 136 },
        { 56, 256, 128, 273,
          "\x7b\xeb\x1e\x06\xb5\x85\xfa\xda\x87\x5f\xc6\x10\xc3\xcb\xfb\x97\x88"
          "\xfe\xa2\x91\x43\x64\x10\x48\x7d\x8a\x84\x4c\x21\x7d\xfb\xb7",
          "\x37\xaf\x09\x74\xce\x28\x51", "\x23\x30\x13\xd9\x17\xf3\xad\x76",
          "\xe0\x39\x63\x76\xc6\xe7\x4a\xaf\x27\xf9\x33\xb6\xd5\x9f\x1b\xcf"
          "\x8c",
          "\x81\xf8\x49\x9c\x64\xed\x65\xe4\xd9\x96\xf8\xb2\xc6\x48\x4d\xe1"
          "\xe2",
          "\x6d\xb4\xb7\xc5\x5f\xcc\xa5\xfe\xde\xe9\x71\xa4\xa1\x22\xbb\xfe", 1,
          64, 136 },
        { 64, 256, 128, 274,
          "\x61\xba\x69\x48\x97\x92\x5d\x1b\x41\x74\xd4\x04\x01\x46\x9c\x3e\xf2"
          "\x67\xcd\xb9\xf8\x29\xed\xb1\xa1\x06\x18\xc1\x6d\x66\x60\x59",
          "\x0d\x10\xc5\xc8\x4b\x88\xd6\x88", "", "", "",
          "\x8e\xc7\x1f\x7d\xaf\x93\x5e\xdf\xac\x9d\xe9\x68\xf1\xd7\x64\x77", 1,
          0, 0 },
        { 64, 256, 128, 275,
          "\x30\xb7\x84\x51\x11\x93\x55\x5f\x16\x11\x23\xac\xad\x2f\x18\xae\x3b"
          "\xde\x91\x2e\xa9\xcc\x4a\x9e\x55\x31\x6d\x82\x2e\xce\x96\x52",
          "\x0f\x1d\x38\xc6\xf3\x0b\x44\x75",
          "\xd2\xcd\xd6\x22\x80\x88\x8f\xe5", "", "",
          "\x02\xfc\xa4\x1f\x06\xb8\xc5\x43\x80\x84\x44\x0f\xf4\xce\xa5\xc8", 1,
          64, 0 },
        { 64, 256, 128, 276,
          "\x11\x58\x84\xf6\x93\xb1\x55\x56\x3e\x9b\xfb\x3b\x07\xca\xcb\x2f\x7f"
          "\x7c\xaa\x9b\xfe\x51\xf8\x9e\x23\xfe\xb5\xa9\x46\x8b\xfd\xd0",
          "\x04\x10\x21\x99\xef\x21\xe1\xdf", "",
          "\x82\xe3\xe6\x04\xd2\xbe\x8f\xca\xb7\x4f\x63\x8d\x1e\x70\xf2\x4c",
          "\x74\xc3\xb0\x03\x22\xc0\x91\x60\x80\x37\xd4\xa8\xeb\x5a\xfb\xec",
          "\xa0\x98\xb6\x7a\x2c\x79\xdd\x93\x94\x72\xa1\x85\x02\x63\x27\x01", 1,
          0, 128 },
        { 64, 256, 128, 277,
          "\xa6\x74\x2d\xd3\x38\x7b\x1e\x11\xdc\x00\x48\x34\x71\x20\xf9\x17\x6d"
          "\xff\x30\x29\x5c\x03\x41\xd6\x9b\xc2\xde\xac\xe1\x93\x3f\xd8",
          "\xbd\x3a\xbd\x10\x1a\x6c\x62\x5e",
          "\x61\x51\x54\x63\xb6\x84\x95\xbd",
          "\xb9\xbe\x89\xba\x08\xc5\x5a\xc0\x44\xb6\x10\x9b\xc4\xa1\xeb\x6b",
          "\x2f\xbb\xa1\xef\x88\x55\x54\x5c\x67\xcf\xc5\x3e\xd4\x9b\x37\x24",
          "\x1a\x82\xcc\x39\x05\x01\xd2\x99\x15\xc2\xc1\x9a\xf0\xb5\xae\x53", 1,
          64, 128 },
        { 64, 256, 128, 278,
          "\xc4\x3a\x2f\xa6\xd3\x71\x17\xc1\xad\x70\xcf\x07\xcd\x5d\x60\x7c\x91"
          "\x3c\xa8\xfa\x55\x84\x80\xaa\x0a\x24\x13\xe3\xd6\xe8\xb1\xaf",
          "\x83\x9a\xe2\x4f\x13\xf2\xea\xba", "",
          "\x2c\xf8\x40\x59\x46\xbb\x72\x3d\x40\x66\x62\xa3\x1d\xff\xfd\x51"
          "\x41",
          "\xdb\x8c\x02\xd3\x79\x87\x60\xbb\x40\x38\xd3\x70\xab\x6a\x93\xe4"
          "\x51",
          "\x3d\xd4\x24\xa6\x17\x50\x2b\x64\x48\x4a\x88\x95\x7f\xf0\x94\xa7", 1,
          0, 136 },
        { 64, 256, 128, 279,
          "\xf9\x48\x9d\xda\x8a\x08\xab\x83\x3f\x2a\x65\x8f\x3e\x42\x5a\xd6\x77"
          "\x07\xb0\xa5\x29\x11\x08\x16\x22\xe0\xe7\xef\x90\xa3\x3e\x84",
          "\x6a\x1b\x55\x7a\x0f\x47\x08\x22",
          "\xec\x6c\x76\xbc\xee\x1e\xbc\x6b",
          "\xa5\xd3\x97\xbe\xbe\x7a\xc5\x70\xd2\x39\x93\x90\xe8\xf0\xec\xb2"
          "\xb6",
          "\xa4\xe3\xe0\x95\xa2\x00\x41\xae\x21\x7a\xcf\xfd\x45\x5a\x74\x2d"
          "\xb5",
          "\x31\x7b\xc9\xf1\xb5\x20\xe9\x8e\xd8\x82\x0d\xd2\x40\x29\xab\x52", 1,
          64, 136 },
        { 72, 256, 128, 280,
          "\x66\xf6\xd7\x9b\x72\x3c\xcd\x31\x36\xd2\xcf\x78\x8f\xc5\xb1\xc2\xf4"
          "\xb9\x84\x63\xa5\x7a\xe4\xdd\x29\xf3\x88\x8a\xba\x37\xd0\x86",
          "\x0a\x0a\xab\x42\x30\xfc\x3e\xe8\xca", "", "", "",
          "\x2e\x59\xd7\xb1\xd1\xad\xa4\xc5\xf4\xc7\x4b\x35\x39\x66\x87\x99", 1,
          0, 0 },
        { 72, 256, 128, 281,
          "\xdf\x89\xe9\x4e\x19\x79\x57\x6e\xb8\x6b\x48\x19\xc9\x02\xaa\x5c\xdd"
          "\xfd\x14\xe0\x22\x45\x48\xc0\x35\x31\xea\xa7\x9e\x9a\x22\x64",
          "\x39\xd9\x12\xcc\x1c\xd3\xde\x7f\x18",
          "\xfb\x13\x08\xe9\x08\x2d\xba\x57", "", "",
          "\xdd\x8b\x28\x4b\x1b\xa7\x18\xff\x14\x9b\x29\xc0\xbe\x62\xe7\x08", 1,
          64, 0 },
        { 72, 256, 128, 282,
          "\x3e\x67\x83\x07\x50\x9e\xa3\x1e\xd5\xf3\xbe\x53\x2b\xa6\x1a\x4f\x03"
          "\xbc\x8e\x13\x75\x11\x36\x41\xd1\x09\x98\xb5\x0d\x1e\x42\xe3",
          "\xc0\x63\x66\x67\xb3\x31\xa0\x81\x13", "",
          "\x32\x0d\x03\x28\xd2\x16\x4a\xfc\xfb\x89\x92\x65\x93\x8b\xae\x67",
          "\x7c\x56\x07\x16\x00\xb1\xa3\xc6\xd8\x7a\x4e\xd8\xbe\x56\x18\x7a",
          "\x58\xc8\x51\x26\xd5\xa5\x29\x1b\x48\xa9\x39\x55\x6c\xa8\xf3\xd6", 1,
          0, 128 },
        { 72, 256, 128, 283,
          "\x7c\x9b\x18\x43\x5f\x55\x63\xe0\x35\x05\xa6\xf5\xed\xfc\xb1\x04\xde"
          "\xda\x40\xec\x89\x99\x8f\x68\x16\xe1\x08\xda\x97\x04\xcd\xda",
          "\x98\x63\xce\x13\x79\xa0\x6a\x5d\xef",
          "\xf0\x0d\xc0\x5b\xd0\x00\xfc\x70",
          "\xb0\x37\x68\x45\xc0\x26\x97\x93\x5f\x91\x43\x98\x55\x5e\xc4\x27",
          "\x49\xd7\xd0\xb7\x96\xd1\x6d\xff\x6d\x0f\x7a\xab\x8c\x02\x27\x76",
          "\x6a\x25\x90\xae\xc1\x3a\x76\x5e\xd7\x73\xf4\xde\xd0\xf1\x21\x86", 1,
          64, 128 },
        { 72, 256, 128, 284,
          "\x94\x33\x11\xd4\xa1\xf7\xd2\x11\x08\xcc\xce\xe9\x40\x35\xdd\x71\x7f"
          "\xc3\xab\x41\xd7\x3c\x36\xc2\xff\xbc\x01\x7f\x82\x22\xe8\x57",
          "\x82\x33\x9e\x77\x61\x51\x3c\x74\xa7", "",
          "\xb6\x8f\x03\x3c\x45\xc6\x72\xb6\x96\xc0\x32\x07\x67\x4b\x39\x5b"
          "\x89",
          "\xc7\xa2\xfe\x3a\x9f\xcf\x3b\x0b\x5a\xd8\xdc\xc3\x00\xc4\x9b\xa4"
          "\x85",
          "\x26\xa6\xc3\x71\x43\x86\xa9\x70\x56\x02\x0d\x4b\xf2\x4f\x7a\xa4", 1,
          0, 136 },
        { 72, 256, 128, 285,
          "\xb3\x6a\x33\x80\xf9\xbf\xce\x99\x2d\x15\x5e\x18\x47\x3e\xef\x8c\x7e"
          "\xee\xd8\xc4\xfe\x8f\x54\x47\xa5\x5f\xfe\x88\xdd\xf3\xbb\x9e",
          "\xa2\x15\x98\x49\xb3\x9d\x86\x28\x52",
          "\xbd\x75\x19\x2f\xba\xcb\xef\xe6",
          "\x3e\x27\x32\x60\x92\x43\x55\xf5\x94\x89\x64\x60\x80\x87\x0f\x19"
          "\xda",
          "\x19\x5b\xcb\x64\xad\x94\x74\xf8\x3d\xd1\x65\x9d\x47\xc2\x2a\x02"
          "\x82",
          "\x80\xa8\x3e\x5a\x8c\xc7\x44\xbc\xb3\x22\xab\x07\x17\x39\x52\x93", 1,
          64, 136 },
        { 80, 256, 128, 286,
          "\x44\xab\x20\x4d\x15\x0a\xdb\x17\xf8\x3d\x1e\x52\x05\xb6\xe1\x41\x96"
          "\x73\xfa\xde\xe6\x10\xfb\x9a\x38\x18\x5a\x96\x74\x10\x21\xeb",
          "\xff\x39\x14\x98\x2b\xe3\x0b\x3b\x21\x12", "", "", "",
          "\xf5\x00\xce\xf3\x10\x41\x0d\x89\x40\xcf\x34\x90\xf5\xf3\xb5\xd7", 1,
          0, 0 },
        { 80, 256, 128, 287,
          "\xdd\xee\x6a\x7b\x13\x1d\x31\x27\x5e\xc1\xcb\x35\x65\x4f\x9d\x25\xc3"
          "\x94\x98\x0a\x1d\xda\x37\xf7\x0a\xf0\xfb\x62\xdd\x77\xa9\xde",
          "\x06\xd8\x4b\xae\x11\x70\x8c\x42\x80\x23",
          "\x04\xc1\x27\x1e\xf5\x2c\x04\x1b", "", "",
          "\xba\xc4\x36\xba\x98\x5f\xdf\x3f\x14\x44\x6b\x92\xdd\xf3\x5d\xd1", 1,
          64, 0 },
        { 80, 256, 128, 288,
          "\xd3\xb4\x4b\x8d\xfc\x35\x30\x40\x4a\x63\xb3\xca\x04\xcc\x71\xcf\xc7"
          "\x1a\x55\x38\x44\x8b\x26\x25\xc9\x81\x85\x6c\xb7\xda\xed\x0f",
          "\x7c\x3c\x42\xfa\x17\x34\x7e\x1d\xf7\x97", "",
          "\x1d\x17\x75\x57\x96\x56\xf7\xf6\xc6\x89\x14\x01\xd7\x33\xe2\xab",
          "\x61\xd6\xde\xba\x72\xb4\x1e\x9d\xa6\x25\x9f\xa8\x05\xd7\x7e\xb9",
          "\x51\x3f\x57\x31\xbd\x00\x0c\xe6\x8a\x6e\xaa\xdf\x3c\x92\x53\x5a", 1,
          0, 128 },
        { 80, 256, 128, 289,
          "\xfe\xec\xec\x22\x5f\xcf\x20\x09\x38\x18\x88\x09\x94\xfe\xda\xd5\x3d"
          "\xc0\xc1\x74\x3a\xa9\x96\x71\xce\xfe\x29\x29\xa5\x03\xe0\xc6",
          "\xab\x8d\x23\x83\x0b\x91\xdc\x6a\x89\x8e",
          "\x24\x88\x9b\x2e\xf1\x2a\x31\x8a",
          "\x7b\x70\xe1\xbf\xe1\xa7\x76\xe8\xf4\x4c\xa4\x32\xdd\x9e\xf9\x99",
          "\x46\xf6\x07\x30\xdb\x04\x13\x36\xcc\x05\x1d\x4e\xf4\xde\x02\x9d",
          "\x77\x17\xad\xcf\x7d\x3e\xd0\xf7\x87\x8e\x1a\xc3\x3a\x35\xcb\x47", 1,
          64, 128 },
        { 80, 256, 128, 290,
          "\xcf\xb7\x33\x08\xa8\x30\x90\x16\x1f\xed\x74\x33\x68\xf5\x48\x08\x72"
          "\xea\xa6\x2d\xf5\xa8\xea\x07\x7d\xee\x54\x0f\xd5\xa2\xef\x15",
          "\x1d\x37\x5b\x8e\x07\xc3\xc4\xde\x82\xf8", "",
          "\xfa\x0b\xc3\xe2\xcb\x70\x18\x3c\xd5\x6f\x47\xfa\x12\x91\x30\x1f"
          "\x47",
          "\xd9\x2c\x03\x75\xa4\xdc\xb1\x84\xbc\x90\x25\x15\x85\x06\x1d\xb0"
          "\x36",
          "\xa0\xdd\xef\x0c\x6b\xd9\x4f\xcd\xec\x39\xa7\xf0\x7f\x0a\x2c\x13", 1,
          0, 136 },
        { 80, 256, 128, 291,
          "\x81\x5b\xda\xab\x3c\x18\x7a\xd7\x3b\x12\x7c\x8d\x39\xa1\x33\xb4\x1b"
          "\x66\xe2\x99\xba\x24\xfb\x44\x6e\x35\xe3\xb1\x12\xdb\x8e\x66",
          "\x0c\xd0\x55\x1f\x0c\x74\x17\x60\xb7\x47",
          "\xc1\xd0\x1e\x47\x31\xf3\x60\x66",
          "\x55\x87\x69\xc6\xd4\xf5\x0a\x0d\xb6\x20\xc2\x3f\xe1\x07\xa7\xfb"
          "\xe4",
          "\xc1\xce\x19\x2f\xb6\x71\x89\x2b\xb8\x3b\xd2\x2d\xbc\x82\xd6\x40"
          "\x82",
          "\x4e\x0a\x0b\xe1\xaa\x0e\x75\xcd\x7b\xb1\xdc\xb2\x7a\x01\x09\x10", 1,
          64, 136 },
        { 88, 256, 128, 292,
          "\x46\x94\x8c\x6d\x69\x84\x54\x99\x10\x4d\x5d\xc2\xfa\xe4\x48\x80\xcf"
          "\xe7\xd0\xbc\xbc\xee\x57\xef\xc0\x13\x3c\x26\x6b\x6d\x26\x21",
          "\x05\xf7\x15\xfd\x0a\x56\x03\xdd\x84\xaf\x76", "", "", "",
          "\x11\xe6\x78\xc0\xb2\x60\xc5\xa3\xea\x70\xf6\xa4\x6e\x4e\xf4\x36", 1,
          0, 0 },
        { 88, 256, 128, 293,
          "\xe6\x89\xeb\x77\xa5\x78\x39\x9f\xa1\x7a\x75\x08\x3d\x25\x01\x8f\xfb"
          "\xb6\x8f\x24\xd7\x7a\x02\x97\x57\x54\x1d\x65\x39\xbf\xfb\xdf",
          "\x4a\x41\x96\x18\xb2\x83\x2d\xe7\xa4\xf9\x9b",
          "\xec\xf4\x6e\xac\xa8\x41\x76\x9f", "", "",
          "\x4a\x26\x15\xd2\xd5\xf8\xe9\x7b\x92\x74\x3b\x0e\xf2\xf4\x86\xab", 1,
          64, 0 },
        { 88, 256, 128, 294,
          "\xaa\xcb\x13\x36\xd6\xee\x4d\x96\xa9\xa1\x2e\x5b\x8f\x25\xf0\x48\x00"
          "\xd4\xaa\xba\x55\xf3\x79\x21\x8d\x64\xed\xb3\x46\x0f\xe2\x15",
          "\x99\x4c\x19\x1e\x7a\x29\xc0\xef\xc1\xeb\x4d", "",
          "\x7b\xea\xd5\xab\xcc\xc8\x76\xef\xb0\x10\x9e\x41\x2f\x06\xc7\x51",
          "\x5a\xa3\x1a\xa5\xeb\x10\x36\x55\xb7\x8c\x4f\x7b\xcf\x08\xc9\x17",
          "\x64\xe4\x1d\x31\xeb\x0d\xf8\x0a\xdc\xee\x32\x8f\x08\x1c\x4a\xeb", 1,
          0, 128 },
        { 88, 256, 128, 295,
          "\x60\xd6\x84\x1e\x9e\x62\x18\xa2\xc8\x60\x5a\x77\x94\xe7\x4f\xb2\x15"
          "\xdc\xf3\xa7\x0a\x00\x15\xd4\x97\xed\x16\x56\x4f\x2a\x83\xa0",
          "\x4c\x93\xf5\x91\xaf\x92\xf1\x65\x96\x55\x4e",
          "\x7c\xb0\xeb\x9a\xa2\x1f\xe8\x59",
          "\xc0\xd1\xe6\x35\x58\x6b\x0e\xf8\x35\xc0\x14\x79\xa3\x21\x75\xa3",
          "\x0c\x26\x61\x13\x54\x4d\x7a\x90\x1c\xe7\x21\xe1\xea\xd6\xd8\xf9",
          "\x8a\x14\x9e\xaa\x05\xc8\x72\x2b\x26\x63\xc3\x45\xa6\xa5\x41\x8c", 1,
          64, 128 },
        { 88, 256, 128, 296,
          "\x9d\xcd\xe5\x7c\xec\x27\xde\x6b\x58\x4d\xb4\xbd\x81\x09\x35\xbd\x3b"
          "\x3c\x4e\xa8\xf2\x2a\x16\xa7\xb2\xa6\x2e\xf5\x16\x79\xa1\x3b",
          "\x5c\x34\x39\xbd\xca\x45\x7b\x02\xb0\x49\x25", "",
          "\x40\x2c\xb1\xfd\x3b\x07\x96\x20\x0d\x88\x8f\x7b\x39\x92\x35\xf5"
          "\xb5",
          "\x43\xf7\xd9\x9c\x1a\x0e\x50\x4a\xad\xd8\xf8\xb2\x98\x1b\x4a\xea"
          "\x52",
          "\x95\x8e\x19\xb5\xc1\x4e\xeb\xd2\xd2\x55\x09\x33\x6a\xa6\xd4\xc2", 1,
          0, 136 },
        { 88, 256, 128, 297,
          "\xb3\xa0\x6e\x00\x10\x0f\xfc\x42\xdb\xdd\x53\x17\xf4\x3d\x2b\x48\xf8"
          "\xc1\x1e\x4b\xd6\xe9\xe3\xed\xab\x58\xe9\x94\x4c\x55\x92\x78",
          "\xf3\xd2\x4b\x36\x2b\xf1\x2b\x84\xb8\xa6\x6a",
          "\x02\x42\xb5\xe8\x04\xa7\x91\x88",
          "\x03\xb0\x3b\x45\xf6\xf3\x20\xb9\x9d\x81\x58\xff\x8b\x00\xf0\xad"
          "\x92",
          "\xd1\x27\xfd\x42\xb2\xca\x4b\xec\xa9\xf9\xac\x86\xb6\x3a\x16\x22"
          "\xef",
          "\x8a\x49\x9a\xab\x9e\x8f\x40\x96\xda\x60\x3c\x6c\xcf\xb9\xac\x4a", 1,
          64, 136 },
        { 104, 256, 128, 298,
          "\xa4\x99\x4b\x65\x14\x35\x36\x70\x7b\x15\x1e\xe6\xe7\x9e\x69\xab\x9c"
          "\x6d\x73\x00\x08\x19\xfd\x29\x91\xdd\x28\xab\xed\xe6\xb3\xe8",
          "\xac\x64\x44\x49\x72\xd7\x78\xd5\x2f\x55\x31\xae\x88", "", "", "",
          "\x8f\x35\x30\xc8\xad\xf8\x6e\xbc\x6c\x44\x97\xce\xde\x15\xcc\xd9", 1,
          0, 0 },
        { 104, 256, 128, 299,
          "\xf9\x9f\x27\x20\xf0\x3e\xc3\xa9\xd0\xda\xd3\x7e\x3a\x91\x5b\xea\x3a"
          "\x11\xcb\xa4\xbb\x0f\x60\xcd\x8f\x54\x2b\x33\x01\x63\xbc\xd0",
          "\x7e\x0f\x99\xa0\x48\xb6\xe2\x87\x97\x20\xfe\x43\x18",
          "\x94\xba\x97\x7e\x74\x45\x5e\xd8", "", "",
          "\xcd\xc3\xbe\xf3\x9e\xa5\x3a\xf6\x80\x19\x9e\x36\x26\x09\xdc\x29", 1,
          64, 0 },
        { 104, 256, 128, 300,
          "\x50\x5b\x26\xd1\x66\xa6\xeb\xd3\xdb\x69\xcf\x12\xbe\xe2\x5b\x73\x65"
          "\x1d\x0d\x33\x2d\x0f\xb2\x48\xb5\x0c\xe9\xa1\xfb\x3a\x13\xf1",
          "\xfb\x04\xf7\xbb\x3c\xd3\x82\xcb\xc0\x89\x37\x19\xaa", "",
          "\xae\x8b\xb1\xcb\xc9\x2c\x73\xe7\x3e\x59\xa0\xd7\xa9\xd7\xf5\x28",
          "\x43\x35\xb7\x08\xf2\x7d\x1c\x1b\x4d\x6e\x98\x5f\x18\xab\xa7\xc5",
          "\x06\x9e\xe6\xf5\x27\x9d\xab\x73\x59\x3e\x11\x44\x0d\x23\x9e\xb8", 1,
          0, 128 },
        { 104, 256, 128, 301,
          "\xa6\x93\x8b\x2e\x56\xd5\xdc\x55\x66\x59\x56\x84\x0a\xc6\x90\xc8\xac"
          "\x9f\xf4\x21\xcc\x06\x2f\xc3\x42\x09\xf7\x71\x5f\x2d\x52\x6e",
          "\xad\x37\xde\x72\xd3\x52\x15\x46\xd5\xff\x51\x46\x2b",
          "\x0a\x38\x09\xbc\x56\x3c\x66\x75",
          "\x9d\x28\x6b\xcc\x11\x5f\x10\xb2\xca\xa8\xc5\xd8\xda\xa9\x1e\xc7",
          "\x4e\xd4\xdb\xc8\xaa\x8c\xf6\x37\x50\x21\xd1\x5e\x43\xc1\xf6\xc3",
          "\xbf\xba\x9c\x41\xec\x63\xaa\x29\x6b\x14\x46\xb8\x88\xb6\x25\x1c", 1,
          64, 128 },
        { 104, 256, 128, 302,
          "\x45\xe5\x9f\x44\x29\x08\x73\x60\xb1\xb2\x40\xfb\x9b\x59\x1d\x86\x1a"
          "\xd4\x93\x68\x8b\x0a\x5e\x8f\x85\xff\xea\x2a\xcf\xf8\x39\x3a",
          "\x20\xe8\x93\xf4\x56\x2b\xc1\xc5\x6c\x32\xc0\x0c\xc3", "",
          "\x3f\xbc\x33\x8a\xd7\xbb\xd6\x77\x8c\xab\xe1\x34\xa0\x2c\x68\xe5"
          "\x3c",
          "\x67\x63\x7f\x9c\x9f\x7d\xa4\x1d\x4b\x36\x37\xe3\xa0\x54\x36\x2b"
          "\x30",
          "\xb3\x46\xd7\x00\xcf\xec\x0f\x2d\x8e\x17\x6d\x3e\xb9\xc5\xbe\xc9", 1,
          0, 136 },
        { 104, 256, 128, 303,
          "\x00\x4c\x6c\xa0\x40\x78\xbd\xfd\x55\x7f\x91\x50\x25\xa8\xec\x93\xb5"
          "\x36\x8b\x86\xca\xf3\xd6\x57\x43\x2a\x5e\x1d\x1c\xef\x99\x17",
          "\x99\x9d\x95\xed\xb9\x25\xe7\x74\x4e\x32\x87\x40\x09",
          "\x08\x2c\x14\x33\xbb\x64\xe1\x10",
          "\x05\x52\xfc\xb5\x2c\x49\x8d\x91\xb8\x98\x97\xae\x6f\x64\x0e\x1f"
          "\x5a",
          "\x5b\x47\x08\xb7\x2b\x68\x46\x66\x39\xe4\xb5\xf3\xd3\xda\x1d\x1e"
          "\x84",
          "\xf7\xf0\xc0\xe0\xc0\x1b\xf7\x72\xcb\xd9\x0c\xb9\x80\x93\xdf\xb8", 1,
          64, 136 },
        { 96, 128, 32, 304,
          "\x10\x3e\x85\x9d\x3a\x23\x87\x24\xbf\x85\xb2\x10\x0f\x44\x2f\x1d",
          "\xf9\x1d\x64\x78\x41\x61\xfa\xbd\x6c\x96\x2e\x50", "", "", "",
          "\x2b\x31\xc2\x1b", 1, 0, 0 },
        { 96, 128, 32, 305,
          "\x71\x46\x6d\xc3\x04\x6b\x1e\x6c\x08\x38\xba\x6c\x9e\xf4\x1e\x79",
          "\x29\x28\x09\x5b\xd7\x96\x2e\x9e\x60\x24\xa2\xb9",
          "\xa6\x17\xcc\xe7\x4d\x04\x39\x90\x05\x97\xcb\x3d\xdc\xfc\x25\xfb",
          "", "", "\x38\x3f\x8a\xbc", 1, 128, 0 },
        { 96, 128, 32, 306,
          "\x3c\xc9\x38\x04\xe2\xd6\x99\x61\x92\x78\xa9\x41\x38\x9c\xec\x3c",
          "\xc7\x75\xdd\xa3\x14\xaf\x64\xc3\x10\xa7\xc1\xd3", "",
          "\x12\x4c\xe7\x1e\x08\xc1\x32\x4f\x91\x65\x70\xd5\x33\x03\x29\x19",
          "\xf2\x46\x75\x4c\xd3\x2a\x99\x60\xd3\xd5\xe5\x35\x2f\x1d\x73\xc7",
          "\x60\xdb\xd6\x76", 1, 0, 128 },
        { 96, 128, 32, 307,
          "\x90\x89\xe1\x78\xf3\xf9\x0b\xfc\x0f\x68\xe5\x59\xd3\x38\xc3\x9d",
          "\x8b\x2b\xfc\xa6\x47\x75\xb5\x09\x35\xb4\x82\x21",
          "\xca\x9b\x40\x50\xb6\xbd\x0f\x0e\xba\xef\xfb\x78\xf2\x4a\x41\x1f",
          "\x33\xd9\x02\x09\x3b\xa5\x21\x69\x33\x23\x6c\x08\xfa\x5c\x0c\xb2",
          "\xe0\x57\x18\x08\xbf\x38\x9c\x1a\x07\xca\x7e\x5b\xbf\x49\xa1\xff",
          "\xcc\x34\x6e\x6d", 1, 128, 128 },
        { 96, 128, 32, 308,
          "\x33\xcf\xf6\x80\x61\xe3\xf5\xf9\x41\xc8\xc2\x0c\x89\x60\x8b\x77",
          "\xeb\x58\x1f\x66\xcc\xc7\xf1\xda\xa2\x35\xbf\x27", "",
          "\x24\xa9\xd8\x95\xf6\x04\x6b\x93\x68\xb0\xb6\xb0\xfb\x39\x6c\xd1"
          "\x0e",
          "\x12\x1f\x88\xe8\x1d\x27\xda\x5c\x5d\x5c\x9a\xb3\x97\xc7\xb2\x05"
          "\xf7",
          "\x2f\xa4\x51\x6d", 1, 0, 136 },
        { 96, 128, 32, 309,
          "\xc0\x1b\x91\x5d\x2d\x21\x12\x28\x8e\xd0\x4d\x2c\xdd\x38\x9b\xd7",
          "\x98\xac\xed\x46\x74\xfa\xeb\xe3\xfd\x48\x81\xcc",
          "\x20\x90\xbd\x59\x34\xb2\x0e\x26\xc7\x04\xaf\x9f\x85\xc9\xc4\x10",
          "\x63\xda\xb2\xe2\xa2\x2a\x63\xa7\xe5\x50\x46\x67\x63\x45\x55\x93"
          "\x4d",
          "\x13\xef\xab\xa6\x39\x13\xe7\xa9\xd8\xa4\xfd\x89\xe3\x49\xc4\xa0"
          "\xa0",
          "\x65\x53\xc6\x47", 1, 128, 136 },
        { 96, 128, 32, 310,
          "\xa9\x68\xcf\xd7\xf6\x3f\x3a\x27\x68\x71\xe3\x03\x83\x07\x7d\xe8",
          "\x54\xbf\xc8\x2e\x1c\xb5\xc0\xb9\xa6\x5b\x25\x2c", "",
          "\x03\x0f\xa6\xb0\xed\xde\x45\xcb\x65\x88\x13\xd0\xd7\x97\xae\xdf\x1b"
          "\xa2\x7f\x43\x5d\xf4\xf4\x43\xa3\x46\x9e\xa0\xe4\x1e\x63",
          "\x60\xd5\x64\x55\x60\xb0\xfa\x0b\x29\x57\x0b\xaf\xd2\xb6\xe1\x8d\x83"
          "\x9c\xea\xf8\x82\x42\xcb\x6c\x7c\x60\x8d\x30\x01\xb7\xcd",
          "\xa9\x2b\x60\xf6", 1, 0, 248 },
        { 96, 128, 32, 311,
          "\x76\x45\x87\x4c\xc7\xa9\xf0\xe7\x44\x32\x03\xab\xec\x23\x45\x5b",
          "\xce\x56\x6b\x86\x6e\xf0\xfd\x3b\x09\x6f\x3e\x9e",
          "\x1e\x00\x46\x9a\xd4\x5b\x2c\x24\xcd\xdb\xa5\x29\x85\x16\x9a\xab",
          "\xb6\xb0\x50\x21\xae\x99\xe4\xaf\xe0\xec\x92\xc0\x09\xd0\x6c\x42\x86"
          "\x02\x0f\xab\xca\x1c\x1a\xc7\x68\xfa\xf1\x84\x50\x61\x91",
          "\xea\x62\xf4\x28\x31\x70\x94\x24\xf8\xa8\x13\x83\x02\x47\x7d\x51\x6b"
          "\x05\xe3\x1f\x23\xb4\x5e\xf3\x77\x03\x3b\x79\x23\x29\x2f",
          "\x77\x4a\xae\x96", 1, 128, 248 },
        { 96, 128, 48, 312,
          "\x1a\x85\x2b\x34\x56\x35\x3c\xfd\x21\x72\x6d\x11\x22\x10\x9f\x1d",
          "\xbd\xe9\x16\x5d\x65\xf3\x01\xa2\xe4\xff\x1d\x4a", "", "", "",
          "\xbd\x22\xf7\x19\x5c\x49", 1, 0, 0 },
        { 96, 128, 48, 313,
          "\x44\xb5\x29\x8a\x67\x7b\xaf\xf5\xc3\xa6\x5d\x51\x2a\x65\x19\x92",
          "\xcb\xb2\x50\x28\x3f\x75\xa6\x60\x82\xf1\xa7\x85",
          "\x19\x03\x1c\x68\x8c\xee\xe8\x4e\x2d\x25\x25\x3a\xcc\xba\xe6\x8e",
          "", "", "\x93\x10\xab\x0e\x0d\x1c", 1, 128, 0 },
        { 96, 128, 48, 314,
          "\x63\xc7\x47\xbe\x2f\x30\x69\xd5\x00\x15\xf6\x9d\xba\xe0\x98\x76",
          "\xbc\x2c\x94\x05\x25\xe5\x14\x40\x98\x15\xab\x19", "",
          "\xad\x5c\xa7\x0a\x32\x53\x63\xc3\x4b\x2f\x3d\x5a\x85\x76\xb9\x64",
          "\xac\xb6\x2f\x8c\x47\x81\x27\x9d\x5c\x81\xcc\xae\xe4\xf6\x1e\xbe",
          "\xcb\xbc\xa0\x32\x69\x50", 1, 0, 128 },
        { 96, 128, 48, 315,
          "\xa4\x65\xbe\x21\xf5\xb4\x20\xcd\x39\x00\x9b\x0e\xf8\x9d\xbe\xc2",
          "\xd8\xb2\x87\xca\xee\x5a\xf6\x9b\xc8\x95\x45\xe9",
          "\xb4\x52\xe6\xc1\x12\x64\x7d\xe6\x74\x24\x9d\x1e\xec\x10\x9f\xfc",
          "\xc1\x90\xd1\x27\x03\x34\x01\x6d\xae\xeb\x12\xf0\xdd\xd5\x59\x05",
          "\xcd\x9e\x9c\xb0\x1e\x77\x37\xcf\x87\xa7\x36\xa5\x0a\x40\x69\x4b",
          "\xae\x86\xc7\x00\x51\x83", 1, 128, 128 },
        { 96, 128, 48, 316,
          "\x1c\xb1\x73\xba\x47\x85\xbc\x6b\x72\x8c\x86\x29\x29\xda\xea\x5f",
          "\xd7\x6c\xdf\xb5\x95\xc3\xfe\x3d\x7c\xc0\x65\x4f", "",
          "\xee\xf6\x69\x1b\xa8\xe2\x28\xb7\xbd\xa4\xb2\x6f\xd3\x53\x95\x07"
          "\x57",
          "\xe8\xad\x83\x31\x15\x84\xd4\xb4\xbd\xb2\x1b\xa0\xf6\x2f\xbb\x13"
          "\xd2",
          "\x0f\x8f\x63\x95\x41\x3d", 1, 0, 136 },
        { 96, 128, 48, 317,
          "\xa4\xa1\x07\xff\x7a\x4c\x09\x78\xaa\x17\xc5\x51\xff\x9f\x8a\x04",
          "\x50\x2d\x4b\xc4\x40\xc3\xf6\x6d\xb3\x9a\x09\xf4",
          "\x20\xd6\x43\xe0\xaf\x5c\x67\x3b\xe4\x54\xe5\x31\xd9\x29\x95\xc1",
          "\x51\x0d\x64\x55\x1a\x78\xca\x2c\xd8\xd3\x22\xf8\x2f\x6e\x2c\xd6"
          "\x17",
          "\x57\x85\x87\x6e\x6f\xd0\x45\xa0\xce\xa1\x85\xec\xb0\x75\x10\x2f"
          "\x97",
          "\x6c\x21\x04\x66\x57\xd9", 1, 128, 136 },
        { 96, 128, 48, 318,
          "\xb7\x8d\xd7\x5d\x16\xec\xe4\x9b\xfd\x01\xe8\xf4\xbc\xd0\xd5\x2e",
          "\x1f\xff\x0b\x5a\x56\x6f\x3d\x1b\x25\x2e\x51\x66", "",
          "\xf4\x38\x00\x03\x59\x44\x8e\xd5\xd7\x91\xbe\xab\x63\x72\x99\xa1\x8c"
          "\x9d\xf4\x5e\x6a\x03\x04\x28\xcc\xa6\xcc\x05\xb2\xc2\x5e",
          "\x65\xc3\x63\xa0\xcf\x88\xf9\xea\x74\xc4\x7f\x46\x98\x1f\xc9\xa8\x45"
          "\x40\x2c\x52\x05\xb1\xd0\xc1\xbd\xb4\x24\x9c\x78\x87\xfb",
          "\x39\xa8\x32\xac\x3b\x9f", 1, 0, 248 },
        { 96, 128, 48, 319,
          "\x22\x8b\xf7\x86\xa9\x37\x1d\x98\x75\x18\x96\x78\xa4\x0f\x55\xa0",
          "\x41\x48\xce\x9b\x64\x72\x28\x75\x1f\x31\x3c\x2d",
          "\x33\x90\xa6\x5d\x1a\xce\x02\xbf\x67\x26\x52\x54\xbe\x9c\x34\xd7",
          "\xa6\x0a\x55\x5b\xa4\x8a\x06\x5d\xa2\x99\x9a\x45\x26\xce\xce\x66\xe8"
          "\x60\x0f\xe1\x20\x96\xdb\x76\x67\x71\xe4\x0f\xcf\x40\xd9",
          "\xfd\x06\x73\x7f\x69\x5a\xd8\x7d\x70\x35\x4b\x67\xc2\x40\xcc\x80\xe4"
          "\x1e\xea\x60\xf3\x58\x34\xfa\x1c\x86\x43\x9a\x3a\x26\x93",
          "\x22\x28\x51\xc9\x6f\xc9", 1, 128, 248 },
        { 96, 128, 64, 320,
          "\x5a\xfb\x73\xf3\x7d\x05\x14\x75\x66\xa7\xac\x97\x34\xeb\xa3\xff",
          "\x02\x6d\xd1\x25\xc9\x8e\xf1\x50\x7f\x6d\x1d\x15", "", "", "",
          "\xa4\xc4\xb1\x36\x62\x5f\x02\x43", 1, 0, 0 },
        { 96, 128, 64, 321,
          "\x3c\xf9\x38\x73\x3c\xb7\x6e\x43\x3a\x5b\x5c\xcb\x06\xbe\x34\x21",
          "\xa5\xbc\x5b\xd3\x83\xce\x11\x08\x10\x2c\x3c\x7b",
          "\xbe\xfd\xff\x73\x13\xd3\x3c\xa6\x39\x8f\x84\xb3\x2e\xf7\x7c\x65",
          "", "", "\xd6\x65\xa6\xea\x1a\xc4\x64\x9a", 1, 128, 0 },
        { 96, 128, 64, 322,
          "\x22\xed\x64\xb5\xb9\x4a\x3c\x41\x16\xd0\x2b\x4f\xbd\x4e\x58\x81",
          "\xf4\x98\xfd\x65\xda\xb2\x34\x52\x0d\xe5\x29\x20", "",
          "\x94\xb0\x3b\x07\x77\x2b\x70\x56\x2b\xc7\x29\x50\x5b\x4a\xd4\x26",
          "\x4c\x4d\xfe\x97\x11\xb3\x20\x26\x4f\x3a\x57\xec\xdc\xd5\x98\x50",
          "\xb1\x3a\xea\x29\x80\x76\x7f\xd7", 1, 0, 128 },
        { 96, 128, 64, 323,
          "\xea\x5a\x91\x5f\xd7\xbe\x0a\xaf\x14\xb8\x8f\x5d\xc4\xfd\x71\x9a",
          "\xae\xec\xf1\x9f\x7d\x33\x79\xee\x55\xba\x64\x68",
          "\x13\x79\x1a\xad\x58\x12\xa3\x62\x29\x1a\x4f\x6d\x63\x68\x7d\x33",
          "\xd3\x13\xe0\x9c\xd4\x8b\x06\xf1\x6e\xf9\x17\x8e\x42\x62\x4b\xd0",
          "\xf9\xbc\x9a\x66\x18\x6b\x6a\x60\x03\x5d\x14\x4d\xfb\x34\xc4\xaf",
          "\x2f\xb6\x37\xff\x91\xd6\xfd\x9e", 1, 128, 128 },
        { 96, 128, 64, 324,
          "\x89\x12\x11\x03\xc3\x50\xe2\x9f\x7c\xd5\x80\xf0\x5b\xbf\xea\xac",
          "\xf6\xd6\xe8\x02\xab\xdf\x43\x23\x00\x30\xa8\x96", "",
          "\x63\x68\x40\xff\xbc\x66\x19\x1b\xc3\x7b\xf2\xe6\xbd\xdf\x28\xbd"
          "\xa9",
          "\xc6\x91\x20\x62\x54\x8d\xba\x55\xe6\x18\x4e\x8f\x50\x7d\x7f\x9c"
          "\x7d",
          "\x1b\x30\x0d\xe3\x55\x38\xc2\x52", 1, 0, 136 },
        { 96, 128, 64, 325,
          "\x03\xad\x5f\x47\x2b\x97\x8c\x5f\x72\xb7\xb1\xc2\x90\x80\x37\x4c",
          "\x77\x0d\xcc\x2e\xa1\xc2\xd9\xf6\xc9\x04\x94\x7d",
          "\x97\x2c\x90\xe3\x87\xf0\xaf\x93\x6b\x1c\x9d\xb0\xeb\xfe\xbb\xe9",
          "\x78\x47\x05\x11\xca\xf1\x2c\xb8\x82\x62\x80\x92\xbb\x57\x3b\xde"
          "\x8c",
          "\x3f\xb2\x2c\x2c\x36\x6c\x0a\x46\xba\x16\x40\xec\xcb\x54\x4d\xbd"
          "\xd2",
          "\x3e\xc7\xc4\x88\x8a\x12\x88\xfc", 1, 128, 136 },
        { 96, 128, 64, 326,
          "\x48\x56\xb1\x07\xdb\xbc\xe7\x02\xc7\xcd\xaa\x7e\xc1\x74\x0f\x35",
          "\x6f\x41\xac\xab\xda\x1e\x03\x48\xc4\x29\x0f\x0f", "",
          "\xd3\x2d\xec\xc5\x5d\xbd\x0c\x08\x91\x6c\x9a\x9e\x3d\x08\x46\xae\x2c"
          "\xac\xae\xb1\xba\x0e\x04\xeb\x02\x77\x2c\xf6\xa5\x0e\x46",
          "\x2f\x3f\x13\x3c\xa5\x44\xea\xa5\x15\xa1\x6f\x8b\x1c\xf1\x2e\x17\x4a"
          "\xa8\x0d\xb6\x08\x26\x8e\xad\x25\xac\xe1\xca\x4e\xef\xed",
          "\x2f\xfa\x78\x6a\xdc\x94\xae\x2a", 1, 0, 248 },
        { 96, 128, 64, 327,
          "\xc0\x83\x39\xa6\xf8\x0b\x84\xe2\x01\xe3\xd6\x03\x0c\xdb\x3f\x02",
          "\x1c\xbf\x2c\xa3\x13\x30\xab\xe7\x49\xdb\x58\x8b",
          "\xb5\x35\xa8\x47\xdf\xc9\x62\x01\x2d\x91\x3a\x40\x76\xf5\x8f\x9f",
          "\x4f\x9f\xd6\xad\x16\x56\xcc\xe9\x9a\xf7\x46\x99\x60\x07\x3a\x24\x15"
          "\x69\xce\x32\xda\xd5\x58\x11\x1b\x50\x30\x60\x53\xa0\xb6",
          "\xc9\x1d\x4c\x8b\xf7\xfd\xba\x49\xb8\x70\x01\xfc\x3e\xc9\x5f\x45\x5b"
          "\xa3\x2b\xc0\x5b\xa3\x36\xbc\x3d\x58\xf4\xad\x08\xb5\xbc",
          "\x34\xd6\x22\xfe\x4b\xa3\xca\xc5", 1, 128, 248 },
        { 96, 128, 80, 328,
          "\x1f\xaf\x80\x05\xf7\x75\x53\xf5\xee\x26\x86\x5e\x31\xf5\x08\x7b",
          "\x40\xdf\x77\xe5\x37\xc8\x95\xab\x71\x46\x4a\xcc", "", "", "",
          "\x22\xff\xed\x9c\x2d\xca\x19\xfa\x32\xef", 1, 0, 0 },
        { 96, 128, 80, 329,
          "\xf2\x0c\x79\xf8\x45\xbe\xd4\x06\x46\x9c\xf1\xcd\x3f\x7d\xaa\xc5",
          "\xf7\xbc\xa6\x6e\xcc\xd7\xd4\x94\xde\xc7\x58\xf5",
          "\x6e\x45\x36\x57\x58\x83\x92\x5a\x92\x9c\xed\x31\xad\x8f\xb6\xdd",
          "", "", "\x2f\x25\xa1\xd0\x02\x61\x58\x9f\x3f\x00", 1, 128, 0 },
        { 96, 128, 80, 330,
          "\xb8\xba\xe0\x12\x60\xce\xd6\x19\x4e\xf8\xdf\x72\x2d\x65\x9b\xe6",
          "\x71\xd1\x0b\x7c\xbb\xbe\xcb\x84\x3e\x67\x8a\xb5", "",
          "\x38\x7c\x03\x24\xcd\x47\xd3\xf2\x2c\xc9\xd9\x68\xa7\x2e\x43\x4d",
          "\x0c\x36\xe3\x03\xe2\x95\xa2\x89\xbb\x13\x47\x40\xe2\x1a\x66\x64",
          "\xd3\x58\x7e\x21\x86\x55\x3f\xd9\xd4\x09", 1, 0, 128 },
        { 96, 128, 80, 331,
          "\xb8\x00\x30\xb8\x3c\x4b\xca\xfd\x1b\x7e\xc9\xc7\x0a\xb9\x22\x4c",
          "\xa7\x89\x45\x7f\x80\xbd\xc5\xb8\xf1\x5f\xea\x91",
          "\x12\x30\x97\x7b\x9a\x5b\x12\xc8\xee\x10\xa3\xb4\xab\xb4\xf0\x6e",
          "\x19\x7a\x27\xed\xfc\x49\x95\x3b\x6d\xad\xfb\xe7\x17\x0f\xc7\x50",
          "\x2b\xc4\x76\x3b\xa5\xb4\x24\xa1\xf2\x6b\xb6\x25\xd9\xf6\xd5\x15",
          "\xd5\xbd\x4f\xa2\x3a\x45\x39\x5c\x71\x6f", 1, 128, 128 },
        { 96, 128, 80, 332,
          "\x95\xe5\x17\x9e\xb1\x97\xf1\xa5\x15\xe1\x99\xbd\x93\x79\x48\xcd",
          "\x49\xd4\x07\x7a\xd5\xd8\xbb\x84\xee\xcc\xf7\x11", "",
          "\x45\xd9\x09\x5c\xf3\x20\xc5\x82\xc8\x97\xf0\xab\xb5\x3e\x3a\xed"
          "\xec",
          "\x36\xb3\xc9\xe7\xc2\x54\x39\xf2\x05\xff\x0e\x38\xff\x46\x79\x61"
          "\xb8",
          "\xc6\xb8\x39\xab\x6e\xe9\x97\x8e\xae\xdb", 1, 0, 136 },
        { 96, 128, 80, 333,
          "\xfa\xc8\xd9\x8a\x8a\xf9\x32\x39\xb0\xd9\x55\x16\x57\xc5\x95\x1d",
          "\xff\x1f\x41\x9b\xed\x64\xbf\x4a\x02\xc3\x57\xe5",
          "\x2e\x3f\x10\x2d\xe4\x45\xb4\xec\x11\x7b\x63\xfb\xa7\x08\x9d\xe8",
          "\x11\x97\xd7\x6a\x46\x9c\x17\x43\x82\x01\xef\x40\x00\xfa\x05\xf0"
          "\xa9",
          "\x96\xe2\x39\x10\xda\xa8\x64\xeb\x12\x68\xdb\xf2\x33\x9e\xd4\xbb"
          "\x62",
          "\xeb\xd1\x52\xd5\xf2\xd0\x0c\x60\xec\xd4", 1, 128, 136 },
        { 96, 128, 80, 334,
          "\xde\x54\x50\x44\xb8\x14\xf3\x13\xc2\x3b\x5c\xb8\x54\xf7\x39\xa2",
          "\x99\xfc\xac\xe8\xe5\x9b\xdd\x6b\x88\xdd\x96\x0c", "",
          "\x83\x52\x5d\xbb\xb5\x4d\xe0\xfc\x1d\x24\x87\x49\xa7\x16\xd9\xde\xbc"
          "\x65\xfe\x44\xc7\x9b\x16\x3b\x36\x14\xfb\x8d\x62\xee\x2e",
          "\xa0\xe6\xe3\xd5\x31\xb8\x63\xb9\xe6\xf3\x8c\xf0\x3d\x60\xf1\xd6\x93"
          "\x0c\xb1\x7a\xa4\x1a\x78\xa6\x6d\x5b\x94\x9c\x5f\x7e\xc7",
          "\x01\x38\xc4\x33\x9b\xfe\xd8\x18\x96\x4b", 1, 0, 248 },
        { 96, 128, 80, 335,
          "\xbb\xbf\xa9\x44\x44\x93\xdd\x2f\xbf\x72\xba\xf3\x87\xa4\x09\x00",
          "\x29\x35\x56\x7a\xa5\x72\x90\x8e\x49\x91\x71\x30",
          "\xc0\xdb\x66\x6f\x38\x14\xfd\xc2\xcf\x7c\xb3\xd4\xce\xfa\xf2\xd3",
          "\x59\xfc\x37\x65\x4b\x0a\x5e\x3b\x86\x87\xa3\xd8\x5b\x32\x64\x4d\xc7"
          "\xa1\x56\xb6\x0d\xd7\xa6\x4d\x22\x98\x37\x3e\x15\x8f\x21",
          "\x46\x4f\x1d\x04\x17\x28\x0f\x22\xf0\x60\x53\xcb\xea\x16\xe2\x8e\xb0"
          "\xf7\x90\x82\xa6\x82\xb5\x8c\xb7\x19\x42\x36\x93\xe6\x6c",
          "\x19\x87\x01\x52\x03\x23\xf4\x61\x3b\x59", 1, 128, 248 },
        { 96, 128, 96, 336,
          "\x0a\xd9\xda\x99\x4d\xb2\xed\x7b\x9e\x35\xe9\x88\x95\x19\x4c\x4b",
          "\x57\xe3\x64\xc1\x6b\x36\x89\xbc\x15\x6b\x31\x15", "", "", "",
          "\x73\x58\x6e\xab\x8c\xed\x75\x40\x62\x0f\xea\x72", 1, 0, 0 },
        { 96, 128, 96, 337,
          "\x97\x04\x95\xf7\x0d\xc6\x4f\x0f\xe4\xe8\xc1\x09\x46\xdf\x2e\xd1",
          "\x69\xb1\xa3\x19\x5c\x16\x55\x17\xfe\xd6\x65\x95",
          "\xbf\xe8\x73\x6a\x21\x13\xf7\x74\xc6\x82\x8e\x5b\x93\x0f\x1c\xb9",
          "", "", "\x18\xd7\xc5\x4f\x8f\xcb\xec\x44\x2b\x31\x39\x87", 1, 128,
          0 },
        { 96, 128, 96, 338,
          "\xf3\x63\xf1\xa7\xd3\x3c\x96\x94\x9f\xd0\x8f\x44\x0c\xfb\xa0\x00",
          "\x67\xb9\x20\x07\xf5\x7b\x83\xfd\x9f\x3e\xe6\xfa", "",
          "\xa6\x51\xd2\xca\x4b\x16\x98\x0b\x0e\x4a\x7a\x10\xc7\x5c\x47\xed",
          "\x20\xc2\xa2\xf1\x8d\x07\x53\xac\xd3\x6e\x20\x49\x85\x14\x95\x28",
          "\x4a\x44\x22\xd3\xb9\x9c\x8d\x77\xdb\xde\x2a\xb2", 1, 0, 128 },
        { 96, 128, 96, 339,
          "\x6b\x74\x89\xd1\x58\xf3\x77\xe6\x69\x2d\x84\xa9\x77\x27\xff\x41",
          "\x9a\xc0\x91\xef\x05\xd0\xce\x74\x28\x82\x7e\xd3",
          "\x38\x46\x9f\x10\x49\xa7\xea\x3d\xa0\x55\x1c\xfb\x34\x01\x0b\xf6",
          "\x35\x2d\xbd\x5b\xb8\xab\xf0\xa0\x97\xb9\x29\x16\x0b\x8f\x8c\xec",
          "\x00\xd3\x94\x8b\xac\x85\x72\xed\x1e\xd5\x9c\x26\x55\xb7\x69\xf7",
          "\x32\x3b\xa1\xc8\x06\xf3\xea\xc6\x73\x01\x5a\x88", 1, 128, 128 },
        { 96, 128, 96, 340,
          "\x38\xd4\xd2\x7c\x30\x83\x49\x68\xb5\x28\x5b\x99\xac\x18\x73\x4a",
          "\x18\x3a\xe3\x52\xd9\xc3\x40\xee\x61\x67\xc3\xb6", "",
          "\xf1\x53\xd0\x1c\x5b\x9a\xb2\x02\x45\x56\x87\x53\x7e\x83\x52\xd2"
          "\x94",
          "\x3c\xa2\x62\xd9\x2d\xb8\x40\x4d\x5d\xb0\xe5\x5c\xcc\xdd\xff\x06"
          "\x5b",
          "\xd2\x7a\xd6\x86\x6e\xa9\x2b\xa2\x68\x0d\xce\xef", 1, 0, 136 },
        { 96, 128, 96, 341,
          "\x74\xb9\x75\x6c\xb2\xac\x63\x61\xce\x9d\x68\x44\x77\xb8\xd0\xc9",
          "\xc2\x60\x6f\xc9\x64\xb6\x13\xa0\xb1\x53\xfc\x0f",
          "\xdc\xe9\x30\x9c\xf7\x1c\xed\x35\xeb\x22\x0c\x70\x9f\xdd\xc4\x14",
          "\x66\xf3\x21\x69\x11\x74\x80\x38\xf9\x14\x32\x34\x49\x14\xee\x8a"
          "\x35",
          "\xc8\xae\xe8\x33\x0a\x37\xca\x70\x6f\x47\x6f\x77\x4f\xf3\x57\x00"
          "\xca",
          "\xb3\x7e\x7e\x62\xd0\xb1\xae\xab\x26\x78\xbc\xf3", 1, 128, 136 },
        { 96, 128, 96, 342,
          "\xe1\xe4\x5f\x35\x00\xa4\x05\xdf\x5a\xbd\xcb\x3b\x86\xbe\xa1\x4d",
          "\x59\x28\x9d\xa2\xd5\xf1\x3e\xea\x49\x95\x61\x1f", "",
          "\x5c\xda\x60\x60\xa7\xe1\x05\xcc\x57\xc7\x75\xa0\x2a\xf9\x21\x75\x73"
          "\x50\xc9\x69\x2b\xc4\xfa\x40\x4a\xce\x98\xeb\x1e\x61\x71",
          "\xf2\x67\x01\x4a\xc2\x64\x66\x05\x8b\x80\xd2\x8c\x0d\x82\x52\x1d\x69"
          "\xb2\x30\x2c\x36\x56\x74\x0c\x23\x78\x31\x85\x9a\x0f\x24",
          "\x9e\xdc\x28\x31\x74\x36\xd6\x6d\x75\x2a\xd9\xb7", 1, 0, 248 },
        { 96, 128, 96, 343,
          "\xbc\xe5\x99\xcb\x75\xa2\x27\x10\x70\xe6\x19\x9c\xb0\x96\x65\x6b",
          "\xf9\xa8\x33\x3f\x46\x73\x68\x9e\x39\x59\xc9\xe0",
          "\xf6\x1e\x10\x35\x17\x1c\x92\xb0\x22\xae\x55\x9e\x86\x57\x93\x0e",
          "\x41\x89\x4a\xcc\x83\x8d\x4a\x8f\x62\xe6\xcc\x92\x71\xf1\xd6\x5d\xf7"
          "\xf3\x65\xa3\x8e\x9a\x94\x11\x0f\x4c\x8d\x57\xb8\xbe\x18",
          "\x0e\xb5\xc0\x3d\x69\x15\x3d\xbe\x79\x4c\x53\xcb\x29\x3b\x25\xd3\x8c"
          "\xaf\xa1\x36\x72\xc9\x15\x60\x68\xa4\x02\x6d\xb0\xd7\x08",
          "\xd4\x06\x38\x9c\xe2\x22\x8e\xbb\xbc\x40\x0b\xbf", 1, 128, 248 },
        { 96, 128, 112, 344,
          "\xf2\x1f\x07\x00\xf1\x6a\xa0\x98\xd6\x61\x7c\xc3\x68\x30\x12\xc1",
          "\x42\x39\x4a\x30\xfc\xd2\x52\x55\x6b\xf2\xcb\x36", "", "", "",
          "\x39\xd0\x70\x3d\xcf\x7d\x0c\x31\x62\x22\xd7\x16\xaf\xec", 1, 0, 0 },
        { 96, 128, 112, 345,
          "\x7d\x28\x27\x73\x9a\xd3\xce\x2d\xc7\xf2\x7e\x35\xf6\xcd\x83\x7f",
          "\x09\xa2\x49\x07\x7d\xb1\xf8\x4e\x98\x4a\x98\x29",
          "\xb5\xe5\x9d\x8c\x3f\x81\xda\xe7\x78\x9a\x82\x6a\x0d\x32\x00\xf9",
          "", "", "\x45\x55\x3d\x58\x83\x9d\x45\xa3\x77\xbe\x85\xe9\x5a\x41", 1,
          128, 0 },
        { 96, 128, 112, 346,
          "\x1e\x70\xde\x0c\xba\x8f\x88\x48\xdb\xc8\xdd\x9c\xfa\x53\xc1\x61",
          "\xd4\xe6\x77\xbd\xb0\x4b\xf9\x35\xd1\x30\xce\x15", "",
          "\x71\x02\xb7\x71\x0b\x1d\xb1\xa0\x74\x84\x74\xf8\xe3\x7b\x6d\xd8",
          "\x55\xdf\xe0\xe8\x8c\x81\xbf\xc5\x61\x97\x5d\xfa\xba\xa2\x1a\x12",
          "\x02\x4e\x3b\xf1\x98\x5a\x7f\x7e\xcc\xda\xa0\xee\x2a\x18", 1, 0,
          128 },
        { 96, 128, 112, 347,
          "\x0b\xb3\x80\xf7\x25\x73\xe6\xd4\x97\x17\x23\x81\xf5\xf4\xeb\x6a",
          "\xe7\x9f\x20\x84\x0e\x41\x82\xac\x6b\xf0\xf8\x48",
          "\x44\x9d\xce\xa2\x7c\xd6\x10\x31\xf9\xbf\xaf\x87\xd3\xbc\xf9\xc4",
          "\x4a\xbf\xe6\x0e\xd6\xbf\x24\x19\x0e\x41\x6e\x68\x09\x71\x8f\xa0",
          "\x12\xe6\x3d\x6d\x51\xc1\x4a\x2e\xe7\x81\x0a\x24\x0f\xfe\xbc\x13",
          "\x5c\xfc\x7d\xf5\xf7\x0a\x81\xf9\x3a\x8f\x47\x14\xe1\x43", 1, 128,
          128 },
        { 96, 128, 112, 348,
          "\xc4\x8d\xe4\xc9\x1e\xfd\xf7\xb2\x4c\x8f\x80\x07\x3f\x6f\x17\xd2",
          "\xdd\xa7\x45\x36\x01\xd5\x16\xe0\x87\x32\x0e\xbf", "",
          "\x01\xbe\x64\x0c\xaf\xc9\xeb\x72\x88\x27\xfc\xf1\xc9\xcb\xa5\xe0"
          "\xcc",
          "\x23\x5b\x7e\xdd\x4b\x3d\xf0\x3c\x4a\xd8\xff\x11\x12\xcc\xb3\xd9"
          "\x28",
          "\x7b\x95\xbc\x04\x20\xce\x86\xac\x2f\x2a\x37\x5d\x5f\xe0", 1, 0,
          136 },
        { 96, 128, 112, 349,
          "\x21\xf8\x4c\x57\xb6\xd4\xa2\xd2\xd3\x0d\x4c\x37\xec\xf1\x10\x30",
          "\xd3\xce\x63\xa1\xaf\x0b\xef\x6c\x9e\x0b\xbd\x81",
          "\x0f\x78\xdd\x2b\x4e\x56\x6c\x9d\x15\xd0\x52\xb0\x1f\x6f\x85\xba",
          "\x33\x58\x54\x3c\x39\xc1\x00\x25\xe0\x1c\xe8\x90\x06\xba\x00\x43"
          "\x26",
          "\xcb\xb9\x21\x40\x6c\xe9\xe4\x4c\x19\xb0\x19\xca\x26\x9a\x6b\x7b"
          "\x13",
          "\xf6\xba\x3a\x6a\x43\x3a\x50\xc4\xab\xe0\x0d\xa2\x41\x1f", 1, 128,
          136 },
        { 96, 128, 112, 350,
          "\xa0\x8b\xe6\x8d\x04\x4e\x76\xe4\x7d\x04\xd0\x93\xee\x54\x8e\x59",
          "\xf1\x7b\x6f\x94\xa8\x86\x42\x05\xc7\x57\xa6\x35", "",
          "\x05\xe4\x54\x20\x55\xfa\x84\xe2\xd3\x49\x83\x7d\xef\x40\x23\x53\xfe"
          "\xa7\xec\x56\xd3\xfd\x81\xa4\x48\x31\x40\x3f\x1f\x7f\x72",
          "\x60\x19\x8b\xdf\x8b\x37\x8d\xbe\x55\x32\xdb\x73\x29\xaa\xcc\x58\xba"
          "\x32\x5b\x82\x79\x65\xd4\x69\xb4\xec\x7d\x06\x98\xb9\xdf",
          "\x05\x99\xec\x3c\x8c\x56\xae\x5d\x1e\xe6\xea\xc6\xca\x05", 1, 0,
          248 },
        { 96, 128, 112, 351,
          "\xd9\x5f\x7f\x6a\x07\x53\x0e\xe3\xf9\x67\xfd\x1f\xf9\x90\x8a\xfe",
          "\xba\xbe\x02\x81\xf3\xcb\xa8\x06\x67\xc3\x65\xaf",
          "\xf4\x9c\x18\xd6\x5a\x19\x7b\x97\x3d\x26\xfd\x29\xa1\x43\x74\x60",
          "\xe0\x2f\xec\x4c\x11\x8b\xcc\x96\x67\x01\x58\x72\xd8\x96\xc8\x86\x8c"
          "\x15\x90\xf8\x47\x34\xce\xc6\x5c\xe9\x0b\x3d\xc0\x76\xd3",
          "\xbc\xd3\x79\xde\x4b\xd6\xea\x47\xf2\x93\xa2\x5c\x41\x1d\x14\xd0\x1f"
          "\x5d\xe7\x3a\x99\xc5\xe2\xe2\xe5\x93\x0f\xd3\xbb\x3b\x23",
          "\x43\xb9\x4d\xf5\x7d\xf5\xf7\x6a\xc5\xa0\x1f\x52\x51\x38", 1, 128,
          248 },
        { 96, 192, 32, 352,
          "\x85\xe0\x17\xfb\xc8\x60\x56\xc8\xc1\x89\x15\xb3\x69\xc0\xc9\x2d\xd3"
          "\xaf\x3f\xc6\x77\x78\x2f\x8c",
          "\x3d\x57\x51\x1e\xaf\xfb\xe4\xe9\xe9\x0d\x6e\xc3", "", "", "",
          "\x4f\xc4\x19\x2c", 1, 0, 0 },
        { 96, 192, 32, 353,
          "\x0d\xf9\x7b\xa4\x0e\x5f\x24\xcd\x5f\x1b\xd0\xec\xf4\x74\xac\x9a\x4a"
          "\x8b\x4c\xf1\x38\x80\x65\x49",
          "\x70\x5b\xc1\xa6\xcb\x54\xc1\x43\xd4\xfa\x10\x02",
          "\xdf\xf5\xca\xd8\xf5\xb6\xcc\x65\xdf\x4e\x4e\x12\x80\x2b\xd0\xe6",
          "", "", "\x48\xde\xd0\x1f", 1, 128, 0 },
        { 96, 192, 32, 354,
          "\x79\x50\x63\x24\x8c\x61\x9c\x9c\xe6\x1b\x56\xc1\x7d\xb6\xc0\x23\xfa"
          "\xb1\x2c\xa6\x10\x31\x92\x5c",
          "\xd3\xaa\x2d\xfb\x01\x9b\x56\x46\x7f\xdb\x36\x8b", "",
          "\x01\x7e\x69\x0c\x00\x69\xbf\x92\xd6\x9f\x27\x0d\x32\xaf\x15\xef",
          "\x3b\xf2\x4b\x2a\xda\x60\x4a\xd0\xad\x9f\xa5\x38\xe3\xb4\xe3\x8a",
          "\x84\xd2\xcf\x30", 1, 0, 128 },
        { 96, 192, 32, 355,
          "\xa7\xac\xdc\x89\xa8\x6a\xda\x31\x90\xda\x95\x4e\x02\x9b\xd3\xd5\x8e"
          "\x05\xbb\xee\x02\x72\xcc\x94",
          "\x4a\xca\x59\x38\xa8\x8a\x69\x8e\xc7\x45\xb4\x43",
          "\x9c\xfc\xfd\x28\x4e\xd3\x5f\xa1\x11\x04\xe5\x28\x56\xfa\x3d\x08",
          "\x64\x18\x73\x87\xc7\xcf\x3b\x56\x20\x63\xab\x35\x45\xca\x71\xaa",
          "\x97\x02\xe5\x11\x9a\x1b\x3a\x09\xe7\xc8\x0e\x65\xe8\x2b\xb8\xc8",
          "\x46\x12\xd0\xbf", 1, 128, 128 },
        { 96, 192, 32, 356,
          "\x63\x69\xc4\x28\x16\x2c\xd7\xc8\x61\xaa\xf2\x8c\x4c\x36\xb8\xe5\x38"
          "\x89\x5e\x46\x9e\x0d\x1f\x48",
          "\xc5\xf0\x9c\xb9\xd0\x30\x8a\x13\xfc\x73\x19\x12", "",
          "\xb1\x98\xa9\xce\x48\x23\xd7\x47\x79\x36\xf5\xcf\x9c\x73\x9a\x83"
          "\x0c",
          "\x1a\x39\xea\x1b\xec\xc6\x94\x11\x65\x66\x98\x7a\x67\xd8\xff\x3e"
          "\xd7",
          "\x3c\x31\x93\xc5", 1, 0, 136 },
        { 96, 192, 32, 357,
          "\x12\x40\xf2\x45\x5c\x1e\xf9\xa7\xe7\x6f\xe9\x3f\x61\x79\xd9\xbd\x6a"
          "\x24\x9b\x66\xba\x26\xbb\x0a",
          "\xc4\xf3\xa0\x72\xf2\x0f\xc2\x2a\x9f\xeb\x74\xc8",
          "\x41\xda\x67\xad\x57\x37\xcd\x4d\x60\x1b\x37\x8d\x31\x2f\x87\x40",
          "\xb4\xf3\xa0\x29\x07\x6a\x1b\xce\x99\xe8\x36\x5b\x1b\x12\x70\x5f"
          "\x17",
          "\xaa\xd2\xfa\xc7\x98\xf0\xf4\x3c\x70\x30\xaa\xa3\xae\xe1\xfa\x50"
          "\x8f",
          "\x09\x73\x36\x97", 1, 128, 136 },
        { 96, 192, 32, 358,
          "\xc3\x35\xb7\x6e\xa5\x97\xd4\x44\xa1\xe6\x63\x50\xbd\xce\xfe\x5c\x96"
          "\x84\xaf\x17\xee\x9e\x39\xa4",
          "\xab\xd4\xd1\x25\x1f\x48\x1d\xfe\xe3\x5c\xfc\x71", "",
          "\xa8\xca\xad\x10\xe1\x60\x20\x41\xa0\xa2\x92\x76\x3c\xe5\xf9\x03\x23"
          "\xec\xfd\x3c\x93\x17\x05\x33\x3f\x3b\x00\xe6\xfb\xe2\x62",
          "\x6e\xaf\xde\xed\xbe\x5b\x36\x7b\xaf\x14\x06\x43\x68\xe6\xf3\x2e\x2e"
          "\xd0\x7b\x0e\xa6\x22\x18\xcf\x50\x56\x9f\x79\x6b\xb6\xb4",
          "\x45\x16\x64\x97", 1, 0, 248 },
        { 96, 192, 32, 359,
          "\x6a\xcc\xd4\xbd\x6b\x18\xb9\xf6\x59\x36\xd8\x7f\x5b\x3f\x83\x39\xd8"
          "\xae\x08\xa2\xa8\x6b\x67\x05",
          "\xa3\x9d\xd2\xe2\xc2\xe2\x15\xce\xbd\xa0\x0e\x13",
          "\xdf\x01\x44\xcb\x65\xec\x35\x29\x9d\x30\x45\x8b\xd6\x1a\x60\xcd",
          "\x97\xe6\xba\x8a\x7e\x71\x7f\x8c\x16\x0b\x9b\x4b\xf5\x2e\x5b\xa0\x39"
          "\x89\xd1\xfb\x17\xe0\x80\x78\xd7\x7f\x7c\x26\xa6\x53\x00",
          "\x3a\x66\x3f\x78\x97\xc8\xf7\x74\xac\x8d\x74\xbb\xf0\x53\x04\xe4\xd7"
          "\xfe\xf9\x2b\xb5\x96\x1d\x0c\x88\xe4\x13\xae\xb4\x7f\x36",
          "\x04\xd5\x07\x14", 1, 128, 248 },
        { 96, 192, 48, 360,
          "\x21\xac\xb0\x9b\xb4\x8d\xc6\x41\x7e\x4d\x87\xa3\x16\x8f\xcb\x84\xe3"
          "\x19\x50\x51\x93\x31\xdb\x93",
          "\x5d\x3e\x03\x63\x37\x46\xd3\x72\x9b\x60\x9d\xd1", "", "", "",
          "\x40\xd0\x42\x96\xcf\x7e", 1, 0, 0 },
        { 96, 192, 48, 361,
          "\xeb\x47\x0c\x2b\xe6\xb3\x25\x75\xc4\x2c\xf9\x08\x53\xbd\xbe\xd1\xe6"
          "\x41\x2c\xae\x16\x15\x33\x0f",
          "\x9e\xd7\x46\x01\x5a\xd7\x2f\x1f\x4a\x86\x88\x37",
          "\xe8\x15\x4f\xb5\x03\xcb\xa6\x64\x91\xa7\xa9\xad\x2f\x31\x02\x82",
          "", "", "\x8d\x8f\x8d\x39\x46\xb8", 1, 128, 0 },
        { 96, 192, 48, 362,
          "\xb7\x85\x8c\x86\xb3\x55\x19\xe9\xc4\x28\x62\x4c\x41\xf4\xda\x83\x79"
          "\xd0\xf8\x55\xb3\xdc\xd6\x22",
          "\xd6\xcb\xa3\x5f\x02\x78\xd6\x67\xd9\x3d\x43\xe3", "",
          "\x77\xae\x65\x5c\x3d\x5f\x9a\x6e\xc0\x6c\xce\xc7\x14\x82\x7d\x87",
          "\xd6\x74\xd8\x3e\x11\x21\xbe\x22\x6b\xd7\x33\x55\xdd\x33\x65\x7e",
          "\x57\x82\x10\x5b\x45\xbd", 1, 0, 128 },
        { 96, 192, 48, 363,
          "\xa9\x98\x8d\xf0\xc0\x01\x13\x2d\xee\x87\x30\x6d\xaa\x4a\x48\x06\x2c"
          "\xa0\xa7\x3a\x61\xd3\x8b\x2e",
          "\xd0\x2d\x4c\x03\x6d\x75\xb4\xc2\xbd\x03\x86\x05",
          "\x6d\x9d\xf5\x3d\xc7\x1e\x44\x76\x61\xb5\xd6\x4b\x31\xc2\xa6\x6d",
          "\x66\xda\x05\xe7\xd6\xdd\x8f\xb9\x99\x82\x7f\xd5\xcc\xe8\xa1\xe8",
          "\x65\x70\x4e\x76\x07\x60\xfd\xcb\xed\x42\x8a\x29\xef\x60\x48\x84",
          "\xe8\x9d\x18\xb4\x39\xc6", 1, 128, 128 },
        { 96, 192, 48, 364,
          "\x50\xa0\x22\xe8\xd8\x56\x41\x33\x7e\x86\xd1\x4d\x75\xf5\x37\x74\x78"
          "\xaf\x29\x7d\x20\x91\xf5\xcc",
          "\xad\x59\x6a\xfb\x65\x49\x09\x81\x62\xca\x53\xed", "",
          "\x0d\x7d\xe7\x6a\xf7\x7e\x8d\x11\x8e\x97\x19\xd5\x42\x9b\x3b\xe4"
          "\x5b",
          "\xf2\x0d\x2d\xa7\x45\xeb\x30\xc5\x16\x63\xa8\x4e\x9e\x1e\x00\x27"
          "\x84",
          "\x90\xe8\x41\x8f\x11\x3d", 1, 0, 136 },
        { 96, 192, 48, 365,
          "\x97\xc5\xaf\x8e\x0f\x0c\xa6\x9d\x77\x13\x7f\xec\x21\xdb\x36\xc9\xde"
          "\xa6\xc8\x36\xa9\x2a\x29\xd2",
          "\x7b\x4e\x8a\x9a\x66\xf6\x82\xbd\x9a\x2f\xd5\xe1",
          "\xbd\xa1\xce\xb6\x3c\x2c\x5f\x54\xee\x92\x6a\x83\x20\x94\xe8\x87",
          "\xcf\x14\xe1\xfd\x8c\x85\x7c\x3b\xa2\x74\xaf\xd4\x23\xec\xc1\xd8"
          "\xd9",
          "\x67\x21\x31\x0f\xca\x31\x2d\x96\x14\xe4\xe2\x9d\xff\xc7\x3f\xdf"
          "\xdb",
          "\x80\xab\x89\x81\x90\xdd", 1, 128, 136 },
        { 96, 192, 48, 366,
          "\x44\x33\xa4\x40\x38\x99\x57\x49\xfc\x7b\x84\xf3\x76\x4f\x9f\xc9\xf8"
          "\xf9\x1d\x20\xed\x19\x00\xa6",
          "\x6a\xac\x37\x28\x40\x93\xec\x85\x9b\x3c\x0a\xf4", "",
          "\x33\xd5\x96\x7e\x20\xad\x5c\x2d\x98\x8c\x6c\xd2\x6a\x92\x15\xb5\x2e"
          "\x0f\xb4\xdf\xbb\x37\x53\x0a\xd4\x4f\x4b\x0e\xc4\x1e\x12",
          "\xcb\xe3\x7d\x72\xb0\xc3\xea\xf2\x81\xab\x34\xac\x47\xb6\x39\xf4\x40"
          "\xd2\x18\xe0\x9b\x14\x80\x8b\xc3\xa8\xe2\xf6\x48\x4b\xa5",
          "\x69\xe1\x9b\xaa\x18\xe3", 1, 0, 248 },
        { 96, 192, 48, 367,
          "\x2b\x05\x07\xb1\x6f\xa4\x9e\x08\x8b\x18\x4e\xb0\xd3\xe1\xd3\xf0\x53"
          "\xea\x3f\x8e\xaa\xf3\xe5\x3d",
          "\xb0\xac\xcf\x6f\x28\x26\x2e\x0e\x1f\xce\x23\xfd",
          "\xa4\xbd\x9d\xa3\xad\x1f\x44\xf5\xdc\x19\x71\x8f\x67\x8d\xe5\xbf",
          "\x3e\x83\x20\xfe\x8a\xbf\xbc\xbf\x29\xd7\x24\xdc\x33\x07\x15\x6e\x6b"
          "\xe5\x3b\x21\xe9\xbc\xc3\xcd\xa9\x1b\x38\x0a\xd5\x80\xda",
          "\x44\x51\x76\x14\x12\x89\x25\xef\xdb\x7f\xb1\x3a\x6c\x4a\x75\x9b\x73"
          "\x7c\x82\xd3\x09\x86\xd2\xaf\xde\x97\x3c\x88\xd6\x01\x3c",
          "\xea\x19\xec\xad\x57\x16", 1, 128, 248 },
        { 96, 192, 64, 368,
          "\x5c\x04\x9b\x3e\xdd\x2b\x92\x6f\xcd\x34\x34\xc4\x21\x53\x2b\x7e\x79"
          "\x08\x71\x2a\x85\x05\x72\x26",
          "\xb2\xb7\x93\x46\x9d\x4a\xc1\xdf\xc3\x75\x6c\x8f", "", "", "",
          "\xc2\x78\x16\xbb\x97\xe9\x8d\x11", 1, 0, 0 },
        { 96, 192, 64, 369,
          "\x5b\x04\xc3\x42\xef\xd5\xe8\x9a\xa5\xd3\x8e\xf3\x2e\xed\xea\xf2\xac"
          "\x03\x5f\x43\xb9\xb4\x20\x1d",
          "\x14\xd4\x78\x1e\x21\x59\x2e\xfc\x44\x09\xb9\x44",
          "\x3f\xd3\xb6\x91\xd0\x51\x1d\x71\xf5\xdb\xec\x4f\x13\x20\xfc\x8c",
          "", "", "\x2f\x84\xac\x2d\x50\xbe\xf7\x5e", 1, 128, 0 },
        { 96, 192, 64, 370,
          "\x1a\x2f\x92\x13\xe6\x6c\x96\x93\x06\xb9\x8c\xe3\x3d\x32\xca\x91\x26"
          "\xe7\x65\x78\x35\x5a\x67\xab",
          "\x6e\xda\xe6\x28\x13\x3c\x51\x0f\x00\x96\x58\x5a", "",
          "\xd4\xa9\x42\x70\x12\x40\x3f\x9c\x51\x8c\x7b\x23\x60\xce\x0a\xb3",
          "\x92\xbd\x38\xe1\xfd\xfa\x11\x75\xdc\x23\x0b\xe5\xf5\x41\x76\x0b",
          "\x99\x02\xe9\xda\x26\x90\x82\x95", 1, 0, 128 },
        { 96, 192, 64, 371,
          "\xa5\x93\x74\x68\xdd\xde\x3c\x31\x2b\x6f\xce\xc7\xd5\xd1\x9a\x92\x85"
          "\x3d\x2c\x66\xad\xa9\x7a\x18",
          "\x5b\xf9\x54\x7b\x27\x53\xdd\x71\x2a\x5d\x8f\x95",
          "\xe5\x6b\xc3\x35\x6c\xbd\xdb\x3e\xf0\x99\xca\xd5\x89\xbb\xe6\x84",
          "\x58\x13\xc3\xc7\x56\xa8\xf2\x72\x1a\x08\xbe\x97\xc4\x43\x92\x69",
          "\x1b\x77\xaa\x30\x34\x01\x89\xfe\x4f\xbb\xd7\xea\x1c\x96\xd5\xc4",
          "\xee\x2f\x19\x5b\x66\x7a\xa2\x67", 1, 128, 128 },
        { 96, 192, 64, 372,
          "\x4d\x85\x76\xff\x63\x5e\xc7\xd9\x9c\x47\xbe\x74\x12\xa2\x84\x6f\xc6"
          "\x38\xc9\xf9\xfb\x0f\x55\x31",
          "\x8a\x53\x40\xf4\xa8\x5e\x3a\x9c\xf7\x43\x0f\xeb", "",
          "\x0b\x89\x63\x37\xa5\x9a\xf8\xe9\xca\x15\xf3\x3c\xd6\xda\xaa\xe0"
          "\xac",
          "\x5f\xdf\x4a\x0f\xce\x8b\xe9\xcf\x74\x0b\x61\xd1\x20\x88\x3b\xcc"
          "\x1e",
          "\x56\x63\x21\xb1\x2e\xce\xc6\x87", 1, 0, 136 },
        { 96, 192, 64, 373,
          "\x9c\xa4\x67\xaf\x0c\x27\x29\xf4\x3f\xbd\x86\x63\x73\xef\x4b\x8f\x2b"
          "\xca\xbe\x43\xf5\xa1\x0f\x97",
          "\xe3\xec\x43\x9d\x33\x4b\x9f\xc0\x7d\x65\xdf\xf5",
          "\x60\xd9\xbe\x32\xc5\x62\x66\x6a\x19\x01\x42\x84\x74\x04\xe8\x04",
          "\xf0\x61\x11\x0e\x43\x63\x6e\xb5\x25\xcd\x2f\x94\xf6\x31\xf1\x28"
          "\x2d",
          "\x5f\x8d\xd3\x0c\xb7\x0f\x49\x5e\xb5\x77\x77\x30\xb0\xc7\xda\xde"
          "\x30",
          "\xb0\x1f\xee\xdd\x3e\xd3\x64\x0b", 1, 128, 136 },
        { 96, 192, 64, 374,
          "\xe9\x23\xbb\xfb\xbd\xb8\x1c\xec\x86\x32\x63\x49\x40\xc9\x24\xbc\x9a"
          "\x23\x0f\x15\x87\xf0\xed\x63",
          "\x41\x90\x00\x4b\xf9\x66\xaf\x35\xe0\x49\x44\x5d", "",
          "\xa3\x8f\x8e\x64\xa3\x91\xa0\x9b\x8a\x29\x8d\x4f\xeb\x01\x13\xe3\x08"
          "\xcb\xfc\x6e\xdb\xc3\xcd\x59\xa2\x5a\x31\xa3\xf0\xd5\x34",
          "\x01\xc7\x76\x5b\x13\x96\xfc\x6d\x36\x2c\x00\x77\xa3\xa1\xef\x9c\x3f"
          "\xe5\x4b\x87\x68\x8b\x7a\x64\x12\x0d\x8a\x20\x2d\xe3\x9c",
          "\x89\x90\xa6\xb1\xf3\x86\xcc\x7c", 1, 0, 248 },
        { 96, 192, 64, 375,
          "\x7b\xcc\xcd\x49\x44\x60\xa7\x55\xcf\x82\xee\xdc\xca\xe6\xb1\x41\xb3"
          "\xc5\xb8\x36\x0f\x09\xdc\xfd",
          "\x3a\xb4\x79\x8a\xd9\xc0\x5c\xc7\x93\xf5\xc3\x3d",
          "\x90\x55\x30\x0f\x9a\xf4\x4b\x8c\x4a\x7f\xdd\xbd\xd8\xe2\x49\x72",
          "\xe1\xeb\x07\xd7\x97\xf5\xfe\x2a\x31\xc2\x8c\x03\x82\xb5\x21\x61\x2c"
          "\xbb\x0a\x6f\xdc\x6e\x53\xe2\x7b\x29\x14\x08\x78\x82\xd0",
          "\x6a\x7c\xb6\x7d\x39\x58\x97\xd5\xce\x8c\x59\x73\x09\xd5\x10\x20\x14"
          "\x9b\x1f\xeb\x13\x13\x61\xdc\x1a\x23\x6e\xe9\x2b\x40\xa8",
          "\x1f\xfc\x13\xf7\x4d\x3c\x07\x76", 1, 128, 248 },
        { 96, 192, 80, 376,
          "\x89\xc4\xe7\x97\x06\x2e\x49\xad\x02\xd2\xbc\xf2\xeb\x0f\xf6\x5f\xc1"
          "\x7c\xd2\x9c\xd5\x5c\x8b\xbf",
          "\x68\xde\x74\x04\xe6\xd1\x37\xa5\x83\x89\x0b\x0f", "", "", "",
          "\xba\x50\xe0\x4e\xf8\x87\x14\x55\x62\xf1", 1, 0, 0 },
        { 96, 192, 80, 377,
          "\xc9\xb9\x28\x03\x80\x27\x6a\x99\xc7\xe8\xb0\x0b\x03\xa0\xac\x35\x93"
          "\x66\xa9\x25\x53\x2c\x4b\x08",
          "\x3d\x69\x75\x92\xa7\x80\x07\xee\x3f\xc9\xf8\x71",
          "\x56\x6f\xce\xd9\xa2\x4e\x20\xae\x05\x5f\x03\x4d\xe8\x9f\x76\x2a",
          "", "", "\x7e\x43\xc9\x45\xa8\x82\x6a\x9f\x71\x64", 1, 128, 0 },
        { 96, 192, 80, 378,
          "\x19\x90\x4b\xd0\xb5\x44\xa2\x9e\x2c\x0a\x30\x5a\x12\x43\x23\xa1\xde"
          "\x6f\xae\xb7\x1b\xdd\x0f\x87",
          "\x1d\x15\xb8\x7d\xfe\x88\xc8\x31\xb1\x05\x45\xaa", "",
          "\xa6\x89\x6e\x25\x78\x68\x9e\x31\xd3\x05\xf3\xce\x21\x41\x5f\xfd",
          "\xbc\xbd\x19\x43\x82\xf5\x21\x49\x8c\x93\x0f\x05\x2f\x81\xf5\xc5",
          "\xca\x50\xc7\xa2\xd0\xe3\x9a\x64\x2e\x92", 1, 0, 128 },
        { 96, 192, 80, 379,
          "\xfd\x10\x95\x28\x5c\x2d\x1d\x6a\x65\x45\x00\x45\x3e\x12\x41\xf1\x3a"
          "\xda\x13\x64\x23\x4d\x16\x6c",
          "\x95\x48\x7c\xb5\x3c\x6f\xae\x13\x29\x00\x52\xdc",
          "\x7d\x97\xf4\xb8\x61\xa8\x33\x6c\xe9\xb4\xc7\x25\x0c\xbd\x82\x5b",
          "\xfe\x05\xd5\xfd\x3a\x3d\x4a\x70\x7b\x4a\x63\x09\x7c\x48\x3c\x9c",
          "\x49\x85\x19\x00\x2f\xf3\x26\x6d\x85\x84\xe5\x64\x17\xa8\x55\x11",
          "\x82\x4e\xfa\xaf\x7b\x11\x98\xbe\x4d\x3e", 1, 128, 128 },
        { 96, 192, 80, 380,
          "\xb2\xfb\x99\x1a\x1a\xbc\xfd\xba\xfa\x87\xb4\x15\xc8\xfa\x0f\x03\x95"
          "\xe3\x2f\x23\xd7\x8a\x1a\x88",
          "\x0b\xbb\x61\x0c\x4f\xb7\x55\x18\x0e\xfe\xe9\xcb", "",
          "\x17\x3a\xbd\xf0\xe8\x4a\x4d\x6b\xce\x7f\x84\x9c\x50\xee\x54\x80"
          "\xc5",
          "\x19\x5c\xe4\xaa\x74\xd9\x9f\xd8\xe5\x44\x4e\x29\x6e\x6a\x5d\x13"
          "\x9e",
          "\x29\x08\xe7\xb3\xa0\x07\x2a\xb8\x64\x6d", 1, 0, 136 },
        { 96, 192, 80, 381,
          "\x00\x1c\xca\xa8\x5e\xd7\xda\x56\xfa\x3f\x1e\x9b\x47\xe3\xa2\x04\x2c"
          "\x18\xf2\x1c\x19\xe6\xe9\x64",
          "\x8c\x16\xa9\x44\xb8\x0e\xef\x9d\x32\x5e\x1b\x71",
          "\x21\x8a\xd9\xdb\x9c\x23\x92\x14\x87\x58\xec\x3c\xc4\x8f\x9c\x12",
          "\xed\x07\x99\xeb\xa5\x04\x59\x5e\x80\xa7\x32\x5d\x13\x4c\x5d\xe3"
          "\x9a",
          "\x2e\x3e\x78\xff\x00\xe5\x83\xa6\x39\x45\xdc\x2c\xb7\x28\xa2\x84"
          "\xfb",
          "\x3c\x89\x31\x64\xf1\x45\x6d\x54\xb9\xdd", 1, 128, 136 },
        { 96, 192, 80, 382,
          "\x1d\x75\x7f\x84\xc6\x47\xa4\x2c\xe3\x95\xb5\x4d\xb5\xd9\x21\x79\x86"
          "\x27\xba\x1b\xcf\xcc\x7f\x64",
          "\xc0\xa2\xa0\xfc\xf5\xc2\x00\xe1\x7c\x32\xc3\x94", "",
          "\x51\xa2\xa8\xd9\x95\x84\x4e\x4e\x78\xf9\xb2\x0b\x1a\xf6\x73\x20\xb1"
          "\x80\x90\x3c\xbb\xf4\xef\xbc\x60\x1b\x99\xb4\x1f\x07\xf8",
          "\x6b\x8b\xc9\x3c\xb3\x48\xd8\x42\xf3\x23\x6b\x66\x58\xde\x7e\xe3\xf5"
          "\x57\xe9\x34\x69\x25\x3e\x8a\xfc\x7f\xee\xa8\x7f\x78\xf4",
          "\x81\xd5\x96\xe3\x77\xa3\xa3\x01\x64\x0e", 1, 0, 248 },
        { 96, 192, 80, 383,
          "\x54\xf1\x0b\xae\xb7\x56\x4e\x94\x7b\xb6\xe1\xe2\xa8\x37\xc1\x6d\xda"
          "\xe0\x64\x6a\x8b\x7e\xb3\x38",
          "\x8e\xc4\xd8\x54\x4f\xd2\x1e\x6a\x51\x32\xab\xc9",
          "\x87\x96\xea\x33\x62\x18\xd2\xa0\x99\x1b\x4c\xb4\x23\x01\xf6\x5d",
          "\x1d\x8a\xab\x01\x08\xd7\x29\x90\x92\x8b\x9d\x1a\x8a\x48\x0b\x93\xaf"
          "\x27\x63\x4b\x16\x60\x77\xe3\x13\x4e\x2e\x87\x91\xca\x13",
          "\x00\xf6\x49\xa1\xfb\x32\x1a\x48\xfc\x1d\xac\xd5\xb9\xfc\x19\x77\x9d"
          "\x7f\xb4\x94\xca\xd6\x0e\x2c\x2d\x72\x77\x13\xcd\xe9\x3f",
          "\x7f\xc9\x19\xa9\x2b\xf3\x57\x7b\xd0\xb0", 1, 128, 248 },
        { 96, 192, 96, 384,
          "\x08\x71\x13\x72\xdb\xac\xac\xbb\x68\xef\x12\xe5\xef\x59\xb6\x9f\xd4"
          "\x6c\x9b\xe4\xc2\xfb\x83\x24",
          "\x83\x21\x74\x84\x12\x38\x0b\x0e\x7b\x14\xa7\xef", "", "", "",
          "\x6c\x1e\xe8\xd9\x71\x8f\x72\x4c\xe8\xd9\x6b\xeb", 1, 0, 0 },
        { 96, 192, 96, 385,
          "\x0a\x12\x32\x6b\x7e\xfa\xc1\x79\x42\x1f\xdb\xce\xd8\x0d\x52\xf2\x40"
          "\x7e\x99\x3e\xf5\x04\x77\xf9",
          "\x34\x47\x21\x31\x54\x78\x40\x26\x3d\x9e\x9f\xd3",
          "\x17\xbe\x4b\xb1\xe4\xa4\x0f\xac\x70\x68\x79\x38\x1a\x2d\x6f\x47",
          "", "", "\x6f\xb7\x2e\x37\x68\x83\x2a\x7b\xab\x90\x7a\x75", 1, 128,
          0 },
        { 96, 192, 96, 386,
          "\x56\xd5\xf5\xeb\x69\x7d\x96\xfa\x9c\x11\x52\x8b\x19\x1e\xaf\xc4\x15"
          "\x9c\x2c\xb2\x90\x2f\x06\x95",
          "\x8e\x04\xdf\x79\x13\x42\x92\x99\xcf\x2f\x23\x37", "",
          "\x9f\x6e\xda\xfc\x71\xef\x15\x61\xd7\x00\x5a\x53\x3a\x5c\xde\xb5",
          "\x53\x61\x42\xd2\x7a\x03\x12\xb8\x0e\x53\xff\x32\xbe\x18\x9e\x29",
          "\xf1\x6a\x36\x4c\x64\x22\x9f\xab\x13\x90\x87\x61", 1, 0, 128 },
        { 96, 192, 96, 387,
          "\x25\x94\x30\x07\xa4\x49\x78\x39\xbc\x13\x38\x69\x45\xb4\xbc\x46\xbf"
          "\x10\x5e\xaf\x6e\x6b\xec\x2c",
          "\x56\xad\xa6\xe5\x59\xc2\x68\x75\x50\x92\xbd\x6f",
          "\x25\xfe\x12\xa5\x28\xd1\x26\xb4\xcc\xbf\x68\x10\x17\x0d\xc2\x8c",
          "\x20\x21\x1e\x52\xeb\xbd\x1b\xba\x78\x38\xd4\x02\xe8\xeb\xba\x93",
          "\x4c\x41\x2a\xc4\x1e\xc5\x22\x82\x5a\x88\x44\xf7\xd5\xf8\xf6\x07",
          "\x81\x77\x42\xf2\xa0\x1b\x9d\xbe\x9a\x7f\x39\x02", 1, 128, 128 },
        { 96, 192, 96, 388,
          "\xeb\x3c\xa2\x96\x88\x8a\x76\x28\x98\xe5\x10\x3f\x0d\x54\xd5\x38\x74"
          "\xfc\x7f\x4e\x4b\x9d\x21\x5d",
          "\xf6\xa1\x64\xa5\x5c\xbe\x06\x44\x72\x39\x71\xb2", "",
          "\x96\xda\x54\x41\xe8\x83\x12\x53\x6d\x28\x92\xb1\xe2\x7b\x41\xe6"
          "\x41",
          "\x35\x8c\x85\xd8\x3d\xce\x34\x5c\xc5\xa1\x56\x60\xad\xb0\x16\xa9"
          "\xf8",
          "\xf9\x3d\x30\x5c\x3c\xf6\x92\x93\x28\x9e\x09\xd6", 1, 0, 136 },
        { 96, 192, 96, 389,
          "\xaf\xe1\x2b\xcd\x5e\xf3\x54\x90\x71\x3d\x20\xfe\xd4\x8f\x6b\x94\x2b"
          "\x08\x1b\x9f\x24\x44\x41\x83",
          "\x95\x3e\x94\x4b\xea\xa7\x6f\xd2\x46\x3c\x27\x8b",
          "\xc9\x02\x81\xef\xb0\xb9\x48\x9b\x61\x72\x2f\x1f\xc7\xde\x5b\xa6",
          "\x94\x9f\x81\xce\x36\xdb\xe8\x5e\xac\x14\xa7\x2b\x8b\x77\x58\xea"
          "\x47",
          "\x69\x7c\x99\xee\xe5\x05\x6d\xec\x98\x51\x60\xab\x2a\xfc\xbf\x0c"
          "\x3f",
          "\x03\xbb\x58\xfa\xcd\xe9\xaf\x29\x08\xb5\x2e\x55", 1, 128, 136 },
        { 96, 192, 96, 390,
          "\x73\x8e\x95\xe8\x89\xdc\x79\x3e\x29\xf3\x3b\x9e\x35\xee\x3c\x10\x30"
          "\xd7\x53\xe5\xe9\x9b\xdd\xbd",
          "\xc3\x29\x71\x81\x6c\x7d\x84\x34\x2f\xf7\x64\x88", "",
          "\x7f\x64\x2c\x9e\x9d\x91\x57\x1b\x87\x45\x0d\x59\xa9\xbe\x2b\xe6\xb4"
          "\x5c\x5b\x8a\x0e\xeb\x32\x69\x32\xc3\xe8\x75\x11\x84\x85",
          "\x4a\xef\xf5\xa7\xca\x46\xa8\x80\x4e\xab\x6f\x23\xcb\xeb\x24\x02\x72"
          "\x40\x8a\xf0\x64\x47\xb7\xa6\x73\x8f\x91\xc4\xa9\x0f\x20",
          "\xc7\xee\xdf\x4f\x03\x33\x29\xa5\x12\x50\x44\x55", 1, 0, 248 },
        { 96, 192, 96, 391,
          "\x70\xbc\x9c\x8a\x60\xda\xc5\xf2\x53\xec\xf3\x2c\x7d\x1e\x6d\xe1\x31"
          "\xea\xb7\x9f\xaa\x83\x1e\x76",
          "\x45\xeb\xab\xe2\xb6\xa0\x3f\xbb\x15\x97\x85\x31",
          "\xab\xd0\x9a\xe3\x17\x84\x91\xea\x28\x98\x2b\xc8\x39\xe3\x97\x21",
          "\xee\x8c\x1a\x65\xe1\xc2\x49\x1e\xe7\x25\xa2\x85\xad\x1f\x3a\x22\x75"
          "\xc2\xec\x4a\xf8\x2b\xa3\x2a\x66\xcd\x7e\x87\xdb\xff\xea",
          "\xf4\x2c\x5b\xeb\x2a\xf7\xa9\x71\x5d\x53\x5c\xb7\x21\xba\xdd\x42\x1d"
          "\x47\x2f\xab\xee\x43\x4c\x77\xf4\x2d\x0e\x4b\x16\x3e\x4c",
          "\xb5\x0f\x8c\x07\x0e\x11\x70\xb1\x0b\x9a\x99\x32", 1, 128, 248 },
        { 96, 192, 112, 392,
          "\xcd\x2a\xdc\x91\xb1\x9d\x56\x4b\xab\xc9\x7e\x12\x03\x7c\x8b\xc9\x1a"
          "\xf6\x87\xf9\x59\xda\xe1\xd4",
          "\x67\x8b\x89\xfd\xf4\xe1\x35\xdd\x67\xe3\xf2\x8f", "", "", "",
          "\xa7\x54\x07\xb6\x29\x89\xf1\xbe\x04\x13\x1a\x43\xce\x16", 1, 0, 0 },
        { 96, 192, 112, 393,
          "\x59\xb4\xb1\x81\x6f\x2a\x9f\xb6\x26\x6a\x39\xaf\x3e\x49\x7e\x2b\x89"
          "\xb1\xfa\x51\xfc\xb9\x65\xef",
          "\x99\x05\x97\x9f\x5b\x03\xa5\x0d\x54\x40\xaa\x08",
          "\xe8\x2c\xb1\x13\x39\x72\x77\xe2\x20\x05\x2a\xc5\x53\x04\xd7\x93",
          "", "", "\x67\xf6\xe8\xc4\x46\x5b\xb6\x47\xc0\x3e\xf4\xfc\x5f\x1d", 1,
          128, 0 },
        { 96, 192, 112, 394,
          "\x2d\xe7\xb9\x83\x7d\x63\xf5\x31\xdb\x27\x05\xc5\xe2\xc8\x00\xaf\xbf"
          "\x5c\xce\xf7\x3b\x80\xf7\x9d",
          "\x1a\x0c\xe3\xa2\xe9\x28\x3d\x06\x92\x85\x41\x6c", "",
          "\xc1\x26\x51\x83\xd4\x09\x5f\xbe\xa0\xbf\xa3\x5b\x27\x81\xd5\x2a",
          "\x34\x0b\x2f\xd7\xc3\x9b\xba\x1a\x1a\x93\x91\xb6\x01\x0e\xf8\xb4",
          "\x99\xb1\x9c\x91\xeb\x23\x12\xff\x5c\x42\xbd\x88\x90\x68", 1, 0,
          128 },
        { 96, 192, 112, 395,
          "\x7f\xda\x00\x39\x31\xc5\xea\x09\xaf\xa3\xc9\x3b\xca\xa9\xcd\x33\xaf"
          "\xfa\x55\x06\x1d\xf3\xc4\xda",
          "\xc7\xa7\xaf\xe9\xd8\xd9\xda\x3a\xc8\x1c\x7b\x58",
          "\x32\x09\x2c\x8d\xc6\x2f\xf2\x57\x0f\xae\x6e\xcc\xcf\xd9\x2b\xe2",
          "\xc5\xbd\xa3\xc8\x6f\x31\x16\x0c\x96\x23\x98\x4d\xf8\x85\xf9\x2a",
          "\x50\x22\x4b\xff\x26\xb6\xb9\x66\x69\x32\x50\x37\xf1\x29\x4a\x2a",
          "\xf1\xfe\x37\x1a\x39\x74\xcd\x23\x80\xda\xb2\xc7\xdb\x62", 1, 128,
          128 },
        { 96, 192, 112, 396,
          "\x0b\xb8\x9e\xe6\x66\xcc\x14\x3c\x89\x58\x3c\xe3\x05\x5d\x02\x80\xa3"
          "\xff\x65\xdd\x5b\x0a\xc9\xa8",
          "\xca\x9e\x52\xc9\xf7\x5a\xe6\x26\x25\x6d\x21\x0d", "",
          "\x4c\x8c\xdd\x0f\x6c\x9e\x8a\x00\x91\xb7\x30\x70\x42\x98\xb9\x0e"
          "\xaa",
          "\x93\x18\x5d\xe9\x8b\x9b\x95\xa1\x18\x55\x09\x64\x40\x02\x7f\xf5"
          "\xd5",
          "\x8e\xdf\x2a\x34\x08\x3c\xd4\xfc\x82\xee\x34\x90\x4d\x55", 1, 0,
          136 },
        { 96, 192, 112, 397,
          "\x44\xde\xf0\x2b\x19\xd8\xb7\x4b\x25\x80\x1e\xc2\x52\x73\xb6\x8f\x50"
          "\xde\xa1\x26\xec\x4a\x36\x66",
          "\x21\x5d\xbc\x07\x2f\x69\x8b\xa9\x6f\x85\x50\x48",
          "\x20\x28\x29\x92\x7e\x08\xe4\x0a\xed\x36\x96\xff\xde\xdd\x10\x7d",
          "\x49\x25\xd7\xf7\x0c\x12\xa6\xb8\x48\x7d\x0c\x9f\x16\xf4\x8e\x8e"
          "\x8d",
          "\xc5\x4f\xb9\xe5\x55\xfb\xcb\x5e\x1e\x70\xaa\xaa\xef\xbc\x12\x25"
          "\x00",
          "\x1b\x59\x84\x53\x8b\xea\xfa\x71\x14\x2f\x0c\x0e\xc4\x2a", 1, 128,
          136 },
        { 96, 192, 112, 398,
          "\xa2\x9a\x0c\x3f\x1e\x2e\x3e\xe8\x8d\xfd\x3f\x01\x9b\x42\x5a\x5f\x64"
          "\x75\x26\xd3\xf3\x68\xa1\xbe",
          "\xf2\xba\x8a\x66\x20\xd4\xe5\x34\x87\xb8\xd6\x6d", "",
          "\x23\x59\x87\x89\xd7\xa7\xa2\x48\xd1\x7e\xc0\xc6\xaa\x31\x32\xb4\x10"
          "\x2c\x0d\xf2\xfd\xab\xa4\x3e\x4e\x45\x81\x43\x9b\xdf\xdb",
          "\xb0\x80\x13\x0f\x95\xe4\x6d\x79\xed\x5f\x67\xf0\xdc\x88\xa2\x3c\x34"
          "\xdc\xf7\x4f\x6e\x61\xb6\x56\x21\xb6\xef\x53\x75\x82\x79",
          "\x67\x85\x6e\x34\x44\x53\xca\xb3\x35\xa8\xf0\x7b\x1f\x63", 1, 0,
          248 },
        { 96, 192, 112, 399,
          "\x90\x95\x4f\xb2\x2a\xa8\x48\x60\xdd\x7c\x3f\xad\xb3\x19\xdd\x1d\x16"
          "\x85\x77\x23\xbd\x1b\xad\xb1",
          "\x7c\xa5\x17\x8d\x42\x79\xad\xb8\xd2\x2b\x48\x70",
          "\xfc\x77\xe3\xc5\x01\x03\xc5\x86\x08\x82\xe8\xce\xd3\x40\x29\x33",
          "\xea\x6e\x7a\xa0\x10\xe1\x9a\x7c\x76\xa4\xd7\xd3\x44\x0d\xc6\x1e\xed"
          "\xa4\x4a\x5a\x6f\xb7\xfa\x82\x44\x17\x18\x5d\x4a\x55\xce",
          "\x87\xb7\x53\xfa\x7c\xe3\xe7\xd1\x62\x92\x59\x46\xe8\x57\x19\x93\x3a"
          "\x0d\xd1\x0e\xaf\x72\xb5\x25\x9c\xba\xce\x8c\x41\xc5\x3b",
          "\x2b\x55\x64\x55\xa6\x57\xee\x61\x71\xf4\xed\xe6\x43\xb5", 1, 128,
          248 },
        { 96, 256, 32, 400,
          "\x99\x48\xed\xf5\xcf\xb2\xf5\x33\x63\xed\x83\xbf\xb1\x5e\x7c\xb5\x02"
          "\xf0\x62\x8d\xc9\xf2\xb8\x72\x23\xf2\x23\x34\xc4\x0b\x89\x23",
          "\x44\xe1\x54\xe9\xb3\xf7\xfd\x47\xa9\x7f\xc7\xbe", "", "", "",
          "\x92\xa5\x99\x22", 1, 0, 0 },
        { 96, 256, 32, 401,
          "\x93\xb7\x5a\xc1\x29\xec\x19\x5f\x8c\x18\x0e\x9b\x91\xdf\xed\xaa\xe2"
          "\xb2\xfa\xcd\xc1\x55\x93\xb3\xe4\x25\x8c\x78\xd2\xff\x94\xd7",
          "\xdb\x53\x5f\xe7\x23\xba\x65\x0b\x66\xd2\x30\xfb",
          "\x7b\x3d\xd4\x20\x60\x71\x39\xc1\x9c\x6d\xb7\xa4\xef\xe0\x9a\x0b",
          "", "", "\x50\xe4\x2c\x1f", 1, 128, 0 },
        { 96, 256, 32, 402,
          "\xc7\x67\x91\x45\xa1\x5e\x53\xdb\x5c\xd6\x16\x61\x43\xa9\xfe\xfe\x67"
          "\x46\x71\x5f\x5d\x84\xd9\xdf\xa6\x04\xf1\xd3\xdc\x33\x7e\x6c",
          "\x6a\xc0\xd6\xaa\x44\x6e\x86\xff\x32\xf8\xfc\x76", "",
          "\x83\xb0\x83\x05\x52\x6f\xbc\xbc\xde\xeb\xb3\xd7\xa8\xac\x44\xf5",
          "\xdc\xb5\x25\x05\x59\xa0\x3c\x8e\x70\xe5\xc0\x10\x71\x21\xcf\x58",
          "\x00\x81\xc1\xfd", 1, 0, 128 },
        { 96, 256, 32, 403,
          "\xbc\x5c\xaa\x30\x6c\x42\x3e\x6f\x85\x0c\xd5\x64\x4b\x09\xdd\x4b\xa7"
          "\x76\xb3\x01\x71\xc7\x2e\x00\x50\xe5\xa6\x0a\xfe\x9c\xb7\x7c",
          "\xf9\x56\xd4\x14\x22\xd8\xeb\x63\x23\x1b\x38\x26",
          "\xfa\x6e\x34\x46\x33\x18\x23\x7e\x98\x5d\xd2\xf7\x2b\x0d\xd0\x14",
          "\x46\xc9\xda\x60\x2a\x54\xfe\x80\x37\xcf\x0b\xee\x72\xaf\xfc\x72",
          "\xdb\xb6\xb4\xec\x70\xf9\x32\x4f\x4b\xc2\x2b\x59\x24\x09\xd4\xac",
          "\x80\x3a\x69\x48", 1, 128, 128 },
        { 96, 256, 32, 404,
          "\xa9\x59\xc6\x10\xa8\xef\x46\x8b\xb8\xe8\x66\xa0\x9b\x26\x27\xa6\xc3"
          "\x9e\xe2\xed\x51\x0d\x22\xe8\x72\xaf\xa6\x3e\xba\xb7\xcf\xb0",
          "\xf6\x48\x00\x2f\xfd\x7c\xff\x0b\xd2\x6d\x1c\x45", "",
          "\x34\x65\xe9\xb8\x35\xc2\x16\x95\xbf\xd9\xa5\x20\xa9\xe0\xf0\x79"
          "\xd1",
          "\xbc\xa3\x38\xdc\x06\xcc\xf0\x3c\xbf\x30\x25\x1c\xce\xac\x64\x8a"
          "\xaa",
          "\x97\x6e\xd7\x31", 1, 0, 136 },
        { 96, 256, 32, 405,
          "\xe2\x61\x31\x4c\x54\x0a\xef\x81\x14\x5a\xc2\x23\xff\xc7\xbd\xe0\x11"
          "\x65\x67\x93\x57\xe7\x86\xcd\x2f\x88\x15\xe2\x3f\x1d\x69\xdf",
          "\xfd\x69\xf4\xb9\x39\xe3\xbb\x09\x00\x6f\x2d\x2b",
          "\xae\x20\x5a\x7a\xcc\x94\x57\x16\xf7\x52\xf0\x95\x42\xb7\x8c\x5a",
          "\x90\x64\x8b\x56\xd3\x5b\xf1\xca\x99\x0e\xa2\x59\x50\x35\x4f\xf1"
          "\xa3",
          "\x66\x6d\xe4\x14\xb3\x38\x90\x81\xd0\x70\x28\xd5\xa6\xa3\xf8\x5d"
          "\x5b",
          "\x49\x5a\x49\x8b", 1, 128, 136 },
        { 96, 256, 32, 406,
          "\x04\x79\x81\x7a\xfb\x26\xc2\xce\x77\xb7\x15\xbb\xb0\xd6\x43\x02\xfb"
          "\x09\xff\x92\x5d\x34\x98\x35\xcd\x1d\xd3\x27\x9f\xbb\x72\x38",
          "\x4f\xa9\x0e\x2d\x99\xc7\xa6\xd2\x5d\x38\xbc\xb4", "",
          "\xdd\xeb\xd4\xe2\xaf\x2e\xfe\x97\x20\xc9\xe2\x72\xe4\x01\xb9\x3a\xc1"
          "\x1b\x0b\x8f\xf9\x76\xad\x2d\xea\x0c\xbb\x3e\x8c\x5a\x7f",
          "\x6e\x20\x73\xfa\xa6\x80\xe0\x58\x85\xa5\x9b\x7a\x75\xdd\xe2\xd3\x0f"
          "\xd6\x33\x32\x33\xfc\x9d\x03\xe9\x9c\x49\x0f\x8c\x94\xef",
          "\xbe\x02\x37\xf8", 1, 0, 248 },
        { 96, 256, 32, 407,
          "\x22\x8e\xdf\xfb\x10\x35\x24\x83\x59\x07\x72\x3f\x7a\xf9\xec\x18\x02"
          "\x3c\xb8\x2c\x71\x96\x97\xb3\xa1\xc5\xdf\x0f\x2c\x30\xab\x18",
          "\x44\xf7\xcb\xcb\xf2\x5c\x4c\x0f\xaf\xea\x93\xf2",
          "\x2d\x70\x18\x20\x3f\x67\x83\x38\xef\xb6\xb3\x41\x14\x97\x94\x1f",
          "\x10\x64\x7f\xb1\xe5\x04\x0f\xa0\x09\x09\xd3\xfe\x51\x71\xf0\x4c\x1c"
          "\xe9\x45\x40\x83\x5e\x19\xe6\x25\x35\x5b\x81\x3d\x81\xe7",
          "\x2e\x15\x81\xea\x47\x4d\x67\x07\xa6\x94\xbb\xab\xb2\x6e\xfb\xad\xe1"
          "\xeb\x8d\x8e\x8c\x06\x3f\x7c\x05\x82\x09\xeb\x1b\x33\xb5",
          "\xb0\x6b\x64\xb5", 1, 128, 248 },
        { 96, 256, 48, 408,
          "\xf1\x62\xc3\x19\xc6\xcf\xf0\x93\xd5\x95\x6a\xee\xde\x37\x01\x18\x19"
          "\x42\x88\x82\x11\x08\x78\x24\x81\x78\x27\xa4\x32\xf8\x6d\x9f",
          "\x69\xd7\x42\xd9\x4f\xee\x25\x11\x40\xe6\xd7\x79", "", "", "",
          "\xfc\xdc\x5a\xa3\x39\x14", 1, 0, 0 },
        { 96, 256, 48, 409,
          "\xed\xdc\xcd\x5e\xda\x6e\xaf\x42\x1b\xbf\x87\xd9\x19\x54\x9c\x1f\x3a"
          "\xc2\x04\x5c\x0a\xc2\xbc\xc2\xef\xa5\x0e\xc8\x40\x50\xb3\x6e",
          "\x30\xf3\xdb\x31\x2e\x76\xd2\x93\x45\xed\xde\x59",
          "\x07\x8e\x76\xef\x2d\xee\xbd\xd8\xf2\xd5\x49\x08\x9f\x4a\x93\xe3",
          "", "", "\x0d\xf6\xd2\xdc\x83\xdf", 1, 128, 0 },
        { 96, 256, 48, 410,
          "\x1c\x9b\x20\xe6\x4a\xd7\x83\xbf\x04\xf8\x01\xbe\x53\x2f\x6b\x08\x8e"
          "\x00\x4d\x3a\xa2\xd7\x2d\x77\xf3\x9e\xc8\xfe\x9d\xdc\x51\x89",
          "\x49\x7f\xa4\x1d\xf3\x08\x58\xe3\xfb\xb3\x6a\x68", "",
          "\x03\xd3\x3c\x0a\x11\xa6\xcd\xa9\x9d\x76\xe9\x8f\x75\x05\x9f\xbf",
          "\xde\xea\x99\x43\x7d\x38\x5b\x21\x1f\x3d\xeb\xda\x65\x86\x9d\xaa",
          "\x81\x8e\xa9\x63\x04\x2c", 1, 0, 128 },
        { 96, 256, 48, 411,
          "\x5c\x8b\x72\x87\x01\x76\x56\xc3\x10\x8d\x7e\xb6\x14\x37\x10\x4b\x41"
          "\x1f\xd2\xd6\x15\x24\x5b\xf2\x3c\x82\x7d\x3d\xab\xe4\x30\xa5",
          "\x99\x6a\x93\xe4\x7c\x2d\xab\x38\xc9\x35\x29\xae",
          "\x23\x33\xe2\xc9\x58\x02\x88\x3f\xb3\xcf\x98\x73\x4d\xcf\x9c\x64",
          "\xd1\xa2\x2a\x8d\xa2\x20\x07\x2c\x49\xd8\xaa\x1e\x28\x33\x34\xa6",
          "\xd6\xc3\xe9\x29\x18\x13\xd3\x9a\xd9\x19\x48\x79\x03\xc6\xa7\xa5",
          "\xe6\x39\x54\x04\x16\xfd", 1, 128, 128 },
        { 96, 256, 48, 412,
          "\x96\x4c\x2d\x69\xf7\xb5\x3c\x40\x62\x88\x41\x01\xd5\x62\xf5\x23\x16"
          "\xcc\xbc\x81\x4a\x29\xb0\xfe\x6e\xfe\x7f\x1e\xc7\xf7\xdd\xfe",
          "\x63\xe4\xd4\x4f\x41\xf3\xce\x45\x14\xb7\x37\x00", "",
          "\x52\x36\xea\x08\x20\xe8\x37\x45\x21\x2c\xdc\xd7\xc1\x0a\x5f\x35"
          "\x29",
          "\x05\x67\x5f\xa4\x2a\x07\xd4\x3f\xe9\x1b\x53\x39\x7f\x74\x60\x9c"
          "\xff",
          "\x54\x53\x41\x14\x41\x5d", 1, 0, 136 },
        { 96, 256, 48, 413,
          "\xc0\xa9\xd3\x35\xf3\x29\x96\x6a\x5b\xc8\xcd\xef\x38\x60\x90\x80\xb8"
          "\x5a\x2e\x6e\x96\xf6\xac\x82\x03\x67\x94\x96\x6e\x7c\x82\xc1",
          "\x58\x29\xfb\x77\xbb\xdf\xb3\x87\x21\xa5\x91\x00",
          "\x49\xa3\xed\x9c\xd3\x09\x68\xfd\xb7\xff\x73\xd1\x2d\x30\xe1\x55",
          "\xff\x00\xf8\xc6\xcc\xbc\x90\xa8\x4f\x94\xfc\x98\x8c\xba\xb8\x2c"
          "\xa1",
          "\x29\x9b\x30\xe3\xd3\xc6\x06\x0b\xf5\xd2\x1f\x7f\xc0\x13\x89\x69"
          "\x68",
          "\xa5\x96\x5c\x20\xfd\xc0", 1, 128, 136 },
        { 96, 256, 48, 414,
          "\x48\x71\xb9\x1e\x5e\x7f\x3c\xf9\xcc\x1b\x01\xd5\x0b\xc6\x20\x36\x10"
          "\x75\xad\xa3\xed\xc4\x23\x39\x8d\x47\x40\xde\x72\x1f\x8c\xe1",
          "\x7b\xd8\xcf\x2f\xc2\x4a\x3a\x83\x5c\xf9\x1b\xf7", "",
          "\xe4\x39\x36\xc2\xd0\x5a\x3a\x35\xf7\xc2\xdd\xd1\x65\xd3\x97\xe5\xd3"
          "\xc2\xec\x2b\x48\x23\x60\xd3\xf2\xe6\x21\x7c\xe0\x00\x37",
          "\x43\xb6\x65\x99\xdd\x97\x82\xbe\xcf\x88\x4f\x04\x4f\x0c\x85\xb4\xae"
          "\x6f\x7f\xd0\xf6\xce\x2a\xfb\xba\x84\x2e\x6b\x59\x4b\x3a",
          "\x55\xd8\xf7\x6e\xa7\xe6", 1, 0, 248 },
        { 96, 256, 48, 415,
          "\x71\x70\xed\x6d\xbf\x43\x4b\xfd\x0b\xcb\x6b\xd6\x92\xa3\x69\x36\x52"
          "\x51\xfa\x31\x90\x9b\x4a\x2e\x3b\xee\x10\x66\x3a\x01\xe0\x0f",
          "\xd1\x3e\xe3\x9b\x84\x2f\x86\x0a\x5f\x4d\x78\xe3",
          "\xf8\x7d\x88\x71\xa8\x95\x1c\x39\x85\x73\x21\xe3\x20\xb8\xb8\x36",
          "\x14\x5b\xe0\xa7\x8b\xdb\x38\x01\x4e\xe6\x19\x31\x45\x13\x1e\xc8\xa3"
          "\xfd\x7c\x89\x79\x3a\x30\x05\x36\x4f\xf1\xe7\x93\xf6\x7b",
          "\x6b\x91\xe6\x79\x92\xf8\x70\x30\x6f\x24\x24\x70\xc5\x11\x31\x87\x3e"
          "\x2a\x6c\x07\x6c\xda\x25\x9c\x33\x49\xc9\x49\x4c\x39\x04",
          "\xc8\xcb\x36\x0f\x80\xc5", 1, 128, 248 },
        { 96, 256, 64, 416,
          "\xd2\xa4\x1c\xd9\xce\x5e\x91\x7d\x16\xb9\xab\x55\x81\x9e\xf8\x50\x1e"
          "\x06\xaa\x78\xef\x13\x2f\xd3\xeb\xe6\xfe\xcd\x91\xbe\xb3\x9b",
          "\xf7\x1b\xf6\xbc\x21\xc6\xd6\x35\x4e\x4b\x4c\xdf", "", "", "",
          "\x23\x92\x8a\x00\x9d\x21\xa1\x0f", 1, 0, 0 },
        { 96, 256, 64, 417,
          "\x88\x21\x07\xab\x29\x05\x3d\x4b\x44\xc8\x7b\x5b\xb9\x49\x37\x21\x1c"
          "\x20\x52\x8d\xa9\xac\x49\x0f\x6c\x57\x4c\xae\xcd\xcd\x2f\x17",
          "\xe6\xa1\x35\x37\xbb\x7f\x2a\xf7\x49\xb3\x18\x23",
          "\xe9\xee\x32\xe6\xf1\x97\xe4\x02\x04\x68\x2d\xac\x42\xdd\x4c\x75",
          "", "", "\x57\x73\xc7\x25\xf2\xf9\x46\x17", 1, 128, 0 },
        { 96, 256, 64, 418,
          "\xb9\x67\x09\x1c\x98\xbb\x64\x92\x24\x30\x83\x3d\x1b\x55\x33\x26\xb8"
          "\xe9\x1b\x6e\xf7\x14\x19\x71\xcc\x8e\x8c\xc5\xf6\xef\x61\x70",
          "\xa5\xdd\x07\x6d\x8a\x9d\xc3\xd7\xec\x43\xd0\x4f", "",
          "\xc8\xa3\x31\xb5\x54\xe6\xc7\xb0\x78\x3c\x53\xfe\xe6\xf1\x61\x8e",
          "\x99\xb5\xc2\x22\x25\xe5\x32\x5f\x9a\xa9\x59\x9a\x34\xde\xec\x59",
          "\xe9\xc9\x36\x19\xd3\x3d\x26\x8d", 1, 0, 128 },
        { 96, 256, 64, 419,
          "\x71\x60\x43\x47\x20\x50\x4d\xce\x28\x84\x56\x25\xa3\x42\x31\x66\xd9"
          "\xb5\x02\x5d\x97\x5c\x6e\xe4\x72\x99\xbb\x5b\xd6\x77\xdb\xeb",
          "\x02\x96\xc9\x5b\x44\xc1\x74\x63\x43\x4c\x7e\x19",
          "\x19\x08\x2b\xf5\x7b\x6c\x41\x30\xea\xc5\x8c\x05\x26\xa0\x44\xee",
          "\xc6\x6a\x48\x61\x5b\x62\xd2\xd8\x5e\xa8\x2e\xe4\xd5\x28\xa0\x3a",
          "\x89\x34\xea\x7a\xfb\x44\xfd\xca\x40\x27\xed\x9b\xbb\x24\x73\x58",
          "\xb3\x33\xf0\xe1\x38\x3c\xf3\xe8", 1, 128, 128 },
        { 96, 256, 64, 420,
          "\x1d\xd5\xa0\x92\x94\x9b\x67\x63\x5d\xb0\xc4\x8a\x03\x74\x0d\xa8\x06"
          "\xdb\xe9\x7a\xad\x5b\x84\x12\x30\x0d\x68\x5c\xec\xfe\x84\x07",
          "\x3f\x9e\xa3\x93\x62\xc8\xd8\xe4\x92\xea\x8b\x41", "",
          "\x84\x40\x8d\x8b\xcc\xb4\x28\x8e\x62\x2b\xf7\xc6\x31\x40\x1d\x99"
          "\x08",
          "\x4f\x19\xd2\x7e\x0a\x40\xe4\x83\x5e\xbc\x3b\x89\xce\x8b\x51\x94"
          "\x1b",
          "\x44\xd9\xe5\x0d\xca\x91\x5c\x2e", 1, 0, 136 },
        { 96, 256, 64, 421,
          "\x47\xf6\x64\xe6\x79\x0f\x3e\x25\xbc\x41\x0d\x84\x7f\x38\x66\x2f\x04"
          "\x5f\x0a\xa3\x64\x14\x29\xed\xf8\x09\x9f\x4b\x4d\xf3\x2f\x06",
          "\xf0\x92\xa3\x57\xb5\xef\x0c\x97\x5e\xe1\x69\xc4",
          "\x33\x8b\x4c\xc6\x0e\xc1\x51\xfa\x28\x3c\x1c\xb1\x0e\x72\x2d\x9d",
          "\xb0\x1d\xfe\x72\x41\x66\xa2\xbc\x98\xcb\xb9\x6c\xf5\x40\x02\x8a"
          "\x0e",
          "\xd7\x74\x6f\x18\x6a\xab\xfa\x36\x68\x54\x81\xec\x8a\x7f\x00\x22"
          "\xe8",
          "\x41\x15\x82\x92\xa1\xd8\x7c\xfd", 1, 128, 136 },
        { 96, 256, 64, 422,
          "\xa4\x7a\xbe\x6e\x86\x7f\xbc\x16\xc4\x6a\x6f\xd7\xf1\x0b\x77\x92\x9b"
          "\xaa\x12\x93\x69\xc8\x98\xd2\x52\x65\xb0\x17\x00\x56\xf9\xd0",
          "\x65\x0b\x12\x68\x7c\xa8\x5a\x50\xe6\x50\x98\x84", "",
          "\x20\x09\x14\x57\x1d\xd0\x38\x27\xf0\x7c\x2b\xd9\x38\x2e\x7d\x19\xd6"
          "\x2f\x1e\xa4\xa7\xc7\x26\x9d\x86\x73\x3e\x43\xe4\x5a\x4d",
          "\xbc\x23\x14\xa5\x89\xdb\xdd\x95\xb3\x58\xcd\xad\x30\xb1\x5e\x86\x7d"
          "\xcd\x8d\xbd\xe4\x28\xb4\x7e\x39\x0a\xc4\x37\x62\xf6\x34",
          "\x88\x1f\xa5\xfe\xcb\x51\x4c\xcf", 1, 0, 248 },
        { 96, 256, 64, 423,
          "\x11\x04\x80\xea\x9c\x9f\x4c\x5e\x6b\x5b\xe0\x1a\x2a\xaf\xc8\x61\xd1"
          "\x37\x0c\x24\x3a\xff\x9f\xaa\xfd\x0a\x92\xa9\xd1\x8e\x58\x45",
          "\x0e\x5c\xf6\x83\xe1\x32\x04\xcf\x91\xa2\xd4\xb6",
          "\xc4\x90\xa5\xfa\x19\xb9\x7c\x3e\x3a\xdf\x20\xbc\x4d\xf5\x11\x40",
          "\xc9\x2e\xc3\xd6\xa2\xc2\xfa\x19\xc4\x5b\xe7\x10\x7a\x48\xa9\xea\x0f"
          "\xe4\x6a\x92\x97\x8b\x5d\xab\xb3\xf9\x4b\x45\x7b\x5f\xbd",
          "\xbb\x51\x10\xdd\x12\xbd\x3d\x12\x14\x4c\x8d\xe5\x5b\x3b\x26\x77\xfc"
          "\x70\x84\xd5\x6a\xfc\xc6\xa7\x6a\x52\x28\xff\xf8\xdb\xd3",
          "\xe3\x9b\x0d\x11\x74\xf7\x60\x9b", 1, 128, 248 },
        { 96, 256, 80, 424,
          "\xa0\x91\x7e\xbe\x15\x17\x78\xcb\x88\xbb\x2e\x35\x61\x69\xad\x1a\x4b"
          "\x9e\xbe\x2b\xcc\x2a\x35\x2b\xc7\x89\xa5\x0b\x4f\x31\x2d\x3e",
          "\x32\x81\x13\x54\x38\x26\x08\xbd\x07\x6d\x8a\x87", "", "", "",
          "\xb4\x1d\x1d\xaf\xd0\xd2\x59\x31\xd2\x85", 1, 0, 0 },
        { 96, 256, 80, 425,
          "\xaa\x8a\x48\xf8\xb6\xd1\x86\x34\xec\x96\x33\x8e\x82\x0f\x7e\xb9\xf0"
          "\xfe\xa8\x86\x4b\xb9\x27\xa5\x7c\x65\xf8\x34\x49\x90\x19\x9b",
          "\xa0\xf7\x30\x46\x48\xf9\x7a\x30\x34\x91\x6d\x35",
          "\xf4\xab\xe3\x08\x15\xce\x6a\xe9\xcf\x2f\x4e\xaa\x8b\xd0\x04\xcb",
          "", "", "\xf7\x60\x5f\x52\x01\x93\x6d\xa1\x6d\x39", 1, 128, 0 },
        { 96, 256, 80, 426,
          "\x8a\xb5\x05\x16\xb0\x53\xa3\xed\x51\xb9\xf8\x4f\x76\xdb\xf9\x30\xbd"
          "\xe2\xb5\x5a\xa4\x99\xa0\x16\x19\x43\x50\x46\x1f\xf0\xc7\x08",
          "\x14\x0a\x72\xad\x89\xb2\xfa\x23\xc3\x85\xe8\x04", "",
          "\x53\x6b\x90\x06\xa4\x1f\xeb\xbe\x7a\x10\xd1\x6a\xe2\xb6\x44\x88",
          "\xf1\xed\x66\x67\xa2\x18\x87\xa3\x94\xd8\x16\xa4\x5a\xe0\x6a\x5d",
          "\x45\x55\xc7\x16\x14\xa7\x65\xc6\xa8\xfc", 1, 0, 128 },
        { 96, 256, 80, 427,
          "\x14\x50\xb9\xd4\x36\x61\xc2\x7d\xbd\x08\x00\xd6\x61\x6c\xac\xf4\xe2"
          "\x83\x10\x99\x0e\x74\x4f\x8a\x89\x66\x54\xae\x43\x87\x2b\xcb",
          "\x91\xb8\xa7\x08\xbe\x02\xcb\x63\x35\xc2\x85\x83",
          "\xa4\xa3\xe0\xca\x16\x5b\xff\xcc\x30\x52\x05\x66\x7c\x38\x68\x6b",
          "\x6c\x03\x01\x32\x6a\x61\x33\xf5\xd5\xfa\x87\x17\xda\xe4\xe1\x90",
          "\x37\xd8\xf3\x8e\x20\x4c\x36\xc0\x29\xcf\x15\xf7\xff\x3a\xc5\xda",
          "\xfd\x94\x29\x18\xf7\xaa\xf3\x08\xe5\x6e", 1, 128, 128 },
        { 96, 256, 80, 428,
          "\x1b\x05\xcb\xa5\x87\x24\x72\x13\xa0\xd9\x59\xd6\x4a\x29\xa5\x9e\xe2"
          "\xd0\xee\xa2\xd9\x7e\xfa\x29\x68\x61\x43\x4d\xb8\xe5\x27\x54",
          "\xb8\x3b\x0e\x7a\x52\xdd\x50\x7a\x8d\x67\x36\x61", "",
          "\xd0\x76\x3c\x30\x60\xb7\xf9\xeb\x2d\x42\x75\x8c\xcb\x3e\xbb\x03"
          "\x11",
          "\x27\xb4\x4a\x64\xbc\xd0\xa0\x73\xd7\x70\xa7\x1d\x38\x2b\xd4\xec"
          "\x99",
          "\x9a\x1c\xff\x81\x02\x66\x69\xdb\x70\xd1", 1, 0, 136 },
        { 96, 256, 80, 429,
          "\xe2\x54\x11\x83\x8a\x5a\x8d\xc7\xfa\x86\x6e\xa7\x43\x47\xab\x00\x3f"
          "\x2a\x86\x62\x27\x5b\x69\x3a\xe8\xa6\xdd\xba\x97\x9e\x18\x87",
          "\xbd\xad\x47\x51\x7b\xb9\xb6\x6b\x5e\x64\xc2\x19",
          "\x9a\x1b\x3c\xda\xc0\x76\x7c\xb2\x34\xe5\xe4\x68\x78\x6c\xe3\x27",
          "\x88\x98\x29\xa2\xb4\xa8\x86\xd3\x9f\x1f\x7f\x68\xc2\xcd\xb4\xf3"
          "\x65",
          "\x80\x66\xe4\xa8\xcd\xf7\xac\x2f\x70\xe2\xf5\xba\x51\x26\xd5\xe3"
          "\x47",
          "\x39\x29\x24\x8c\x35\x8b\xdc\xf3\x62\xf1", 1, 128, 136 },
        { 96, 256, 80, 430,
          "\xde\x1c\x7d\x37\x84\xb9\x82\x50\x42\x2e\x6f\xff\xed\x88\x57\x71\x54"
          "\xc1\x93\xf7\x2d\x4a\x97\x96\xd4\xff\x4d\xfc\x88\x23\x5a\x17",
          "\x9d\x14\xa6\xb7\x93\x32\xee\x97\xc4\x8f\x07\xe1", "",
          "\x55\xdc\x11\x79\xcd\xad\x38\xd4\x5e\xd4\x39\x39\x5c\x67\xa8\x72\x4d"
          "\x75\x13\xa9\xa4\xc6\x2f\xb5\x9a\x78\x8b\x0a\xc6\x7b\x7d",
          "\x94\x82\xb6\x00\x66\xc9\x99\xcc\x89\x5c\xf9\x80\xe8\x1a\x29\x23\x7f"
          "\x80\x9e\x9b\x80\xb3\x24\x90\xe6\x0a\xc8\x57\x30\xca\xfc",
          "\x67\x5e\xb8\x19\x7e\x60\x5b\xdd\xf2\xe5", 1, 0, 248 },
        { 96, 256, 80, 431,
          "\xbd\x02\x55\x52\xc3\x4a\x55\x2f\x07\xde\x3a\x34\x8b\xf7\xdf\xb3\x08"
          "\xbe\xc3\x6c\x47\x89\x3a\xd2\x9f\x3f\xe4\x41\xe2\x4f\xb2\x55",
          "\x18\x51\x40\xaa\xc8\x3f\x26\x1a\x8c\x0d\xce\xa4",
          "\xa7\x21\xa6\x9f\x3a\x24\xdd\xbc\x2e\x16\x01\x52\x28\xc8\x48\x3a",
          "\x05\xba\xbe\x1d\x63\xf8\x12\x06\x9d\xfc\xd0\xf5\x92\x62\xfe\x05\xbd"
          "\x45\xb3\xc1\x1a\x3d\x6b\xdf\xea\x5a\x0c\x80\xd1\x32\x20",
          "\x74\xc9\x70\x0f\xb3\xc7\xbd\x4d\x65\xbd\xcd\x0d\xf8\xcc\x73\xa4\x14"
          "\xad\x9c\xd7\x87\xb0\x5c\xc9\xff\xbf\xb6\x3c\x84\x8d\x1a",
          "\x4d\xd4\x3d\xc3\x2b\x30\x16\x73\xf4\x04", 1, 128, 248 },
        { 96, 256, 96, 432,
          "\x07\x37\x42\x4e\x0c\x2f\x40\x48\x63\x81\x33\xa1\x8d\x67\x6d\xc1\xd8"
          "\x3a\x23\x38\x77\x61\x3a\xcc\x0e\xb5\xa6\x81\x30\x53\x66\xc0",
          "\xf0\x28\xd0\xec\xf2\x6c\x31\x2b\x9f\x62\x33\x95", "", "", "",
          "\xd3\x7f\x07\xc4\xec\xef\x1f\xca\xf0\xfe\x44\x4a", 1, 0, 0 },
        { 96, 256, 96, 433,
          "\x8e\x4c\x13\xc9\x82\xa0\x6f\x3a\x98\x29\x59\xeb\x7c\x2e\x9f\x0e\x41"
          "\xa8\xe0\x54\x36\x0e\x5b\x93\x11\x1b\xc6\xd9\x39\x70\xee\x8d",
          "\x8c\x08\x1e\xb6\x0f\xa0\x90\x35\x95\x71\x3a\x73",
          "\x24\xf1\xed\x7c\xad\x53\x54\x68\x02\xe2\xe5\xf5\xed\x51\x62\x47",
          "", "", "\x97\xfe\xd4\x10\xc9\xfd\xb0\x6b\xcd\xb3\x85\x85", 1, 128,
          0 },
        { 96, 256, 96, 434,
          "\x62\x7f\xfd\x55\x17\x6d\x65\x55\xda\x82\xb4\xeb\x87\xe6\x51\x90\x44"
          "\xb8\x81\x33\x4c\x95\x78\x9d\x67\x07\x29\xaf\x05\x84\x12\x8b",
          "\xc1\x5c\xb8\xab\xce\x00\x8f\x01\x5e\x27\x15\xae", "",
          "\x00\x02\x24\xe6\x3d\x99\xe8\xb1\xa0\xa2\xab\xb4\xb4\x5b\xca\x15",
          "\x59\xa1\xb9\x55\x22\xe9\x6a\x5f\xea\x0a\xe7\x7d\x17\x92\x23\xec",
          "\xaa\xb2\xf3\x4d\xe6\xe5\xba\xc7\xcc\xf9\x36\x18", 1, 0, 128 },
        { 96, 256, 96, 435,
          "\xbb\x65\xd8\x0b\x7a\x47\x82\xe0\x5f\xfc\xb7\x77\xe5\x95\x28\xba\xb8"
          "\x7e\x20\xaa\x84\xdb\xe4\x58\x8e\x2a\x17\x03\xf8\x8c\x68\xca",
          "\x56\x41\x0b\xb8\x2b\xb0\x54\x23\x4b\x5e\x62\xc1",
          "\xff\xe0\x9f\xb3\x4f\x17\xb5\x17\x95\x6f\xbb\xb5\x8a\x62\x62\x3a",
          "\x3a\xf8\xc0\x49\xa1\x93\xb1\xca\x39\x52\xee\xd0\xf5\x8f\x09\xdd",
          "\x54\xee\x65\x4f\x5c\x44\xb8\x58\x76\x43\xd4\xc5\x8d\xe4\x02\x67",
          "\x32\x37\xb2\xfa\x6a\xd7\x85\xa8\x82\xa3\x8e\x72", 1, 128, 128 },
        { 96, 256, 96, 436,
          "\xde\x59\xc6\xda\xa2\x10\xca\x6b\xed\xd9\xdb\x7b\x30\xe8\x86\x03\x04"
          "\x9b\x18\x0f\x6e\x31\x96\xb4\xc3\x3d\x8c\x51\x89\xb5\xc4\x50",
          "\x1f\xc9\x68\x4e\x4d\x96\x8b\xfe\x27\x77\x50\x00", "",
          "\xcd\x42\xfb\x94\xb1\x07\xa8\x89\x1b\x15\x9b\xf3\xbd\xb3\xed\xa8"
          "\x44",
          "\xfb\x48\xf5\x71\x63\x3d\x67\xd5\x34\xcd\x20\xb6\xc8\x81\x7e\x96"
          "\x33",
          "\x55\x1d\x3b\xb6\x86\xee\xdf\xdf\xf7\x76\xef\x19", 1, 0, 136 },
        { 96, 256, 96, 437,
          "\x22\x23\x4e\x83\x14\x09\xb5\xfb\xec\x25\x2c\x78\x5d\x69\x4b\x00\x4a"
          "\x59\xff\xda\x15\x6c\xff\x62\xf5\x70\x2b\x72\xfb\xf1\x00\xad",
          "\x5b\x38\xb9\x53\x11\x5e\x80\x88\x43\x0e\xbb\xd8",
          "\x0d\xfb\xea\x34\xbe\xbb\x2c\xcd\xeb\x12\x77\xe0\xb4\x4a\xcc\xfb",
          "\x60\x04\x18\xcb\xef\x85\x64\x39\xe4\x0d\x83\x9f\x7b\x57\xc5\xe3"
          "\x2e",
          "\xda\xaa\xb3\xcc\xa5\xab\x11\xf9\xe1\xf4\x4c\xdb\xfe\x82\xb6\x0c"
          "\x8f",
          "\xae\xf2\xf1\xa9\x0f\xfa\x6e\x96\x89\x2f\x37\x28", 1, 128, 136 },
        { 96, 256, 96, 438,
          "\xb8\x74\xb8\x69\xd0\x04\x50\x51\x4f\xa1\xf8\xfb\x94\x7c\xc0\x87\xe8"
          "\x73\x2e\xd0\x76\x0b\x41\xb2\x21\xc6\x9c\xda\x04\x9c\xba\x02",
          "\x41\x01\x2a\x5f\x5c\x6b\x70\xac\xee\x93\xbb\xa1", "",
          "\x1b\xe4\x61\x3b\xb9\xa8\xa1\x24\x60\x66\x50\xde\x32\x62\xf2\x57\xfd"
          "\x6b\xae\x4b\x7c\x27\xb4\xf0\xff\x36\xba\xee\x97\xbc\xb8",
          "\x83\xcc\x85\xa0\x13\xc8\x2f\xe0\x7d\x24\xb3\x84\x80\xf3\x0d\x6e\x09"
          "\x27\x4a\xf8\x80\xf1\x14\xe0\x8b\x56\x28\x54\x7a\x04\x2b",
          "\xb7\x8d\x7f\x57\xe5\xa6\xad\x5d\x77\x08\x38\x76", 1, 0, 248 },
        { 96, 256, 96, 439,
          "\x10\xf9\xd3\x90\xd9\xe8\x9f\xdd\x3b\xde\xd9\xcb\xcb\x6c\x98\x5f\x9c"
          "\xfa\xe0\x07\x49\xfe\x7c\xd4\x0c\x83\xa6\xeb\x95\xb4\xdc\xeb",
          "\x21\xa2\x28\x6f\xee\xe9\x73\x86\xec\x1d\x2a\x49",
          "\x2d\xee\x72\xe8\x9b\x03\x97\x93\xf6\xa2\x8c\x92\x02\xd6\x26\x59",
          "\x2c\xa3\x70\xd1\x4c\x09\xa5\xab\xa5\x32\x7b\x4d\xe3\x0a\x98\x3f\x6e"
          "\x50\x21\xea\xa7\xb5\x74\x50\x89\x1e\xaf\x38\x6b\x7a\xe9",
          "\xa7\x51\xee\x90\x93\x08\x18\x07\xb5\x24\x07\x59\x19\xfc\x64\xca\x80"
          "\x6b\x3f\x5a\x29\xca\xb2\x6b\x06\x57\xe1\x63\x04\x2f\x96",
          "\x74\x3d\xf3\xe0\x1f\x34\x49\x63\x45\x73\x57\x15", 1, 128, 248 },
        { 96, 256, 112, 440,
          "\x08\xf5\xfe\x4c\x8f\x63\x93\xac\xcd\xcb\x56\x0a\x3c\x27\x10\x96\xff"
          "\x0d\x9d\x67\x43\x8f\xff\xd3\x4d\xf7\x18\x65\x2c\x6b\x8e\xfe",
          "\x25\xc5\xf8\x4f\xe6\xec\x3c\x2f\x7c\x1b\x7c\xc5", "", "", "",
          "\x66\xb2\x30\x23\xe6\x08\xcd\x93\x91\x56\x7a\xa8\x5f\x5a", 1, 0, 0 },
        { 96, 256, 112, 441,
          "\x84\x95\x29\x8b\x9c\x20\x8e\x6c\x5b\x23\x4e\x85\x6e\xec\xff\x6a\x11"
          "\x4c\xd8\xb3\xae\xee\xb7\x45\xa1\x60\xff\xa3\x30\x5c\xf5\xef",
          "\xcc\xe0\x26\x35\xc3\x77\x1f\xb5\xb6\x73\xf8\x8c",
          "\xcc\x9a\xf3\xcc\xa9\xf3\xc2\xc1\x21\x1b\x23\x58\x1e\xc5\xfd\xd1",
          "", "", "\x0d\x34\x89\x6c\x64\xb6\x78\x7d\xa0\xac\x7c\x03\xfa\x93", 1,
          128, 0 },
        { 96, 256, 112, 442,
          "\x4f\x49\x65\x5c\x76\xa6\x29\xe5\x8c\xfb\x94\xc8\x51\xa9\x15\x10\xc2"
          "\xf1\x28\xdc\x4b\xce\x1f\x1f\x11\xc3\xdc\x99\x43\x6d\x26\x8c",
          "\x96\x7f\xde\x29\x67\x1d\x46\x54\xf9\xf6\x70\xc0", "",
          "\xb4\xd1\x2c\x3e\xdf\x38\x02\xe2\x1f\x62\x4b\x71\x8b\x63\xfd\x6c",
          "\x3b\xa4\xe2\xa4\x50\x7c\x0b\x6f\x5a\xe1\xbe\x29\xc3\x0b\x25\xe9",
          "\x8c\xef\xa2\x49\x54\x73\xee\xe1\xb2\x2c\x3f\xa6\xef\x12", 1, 0,
          128 },
        { 96, 256, 112, 443,
          "\x4d\xac\x9a\x0c\xbf\xc3\xdd\x29\x1d\x40\x6e\x68\x38\x89\xfc\x10\xe2"
          "\xa0\xdd\x25\xd4\xd0\xb4\x3b\x11\x11\x1a\xa8\x28\x27\x39\xe9",
          "\x86\x4a\xa8\xc8\x65\x58\x8c\x9a\x21\xae\xa7\xfd",
          "\x5d\xb8\xe0\x96\x97\xd1\xff\x79\xa8\x86\x39\x5e\x40\xfb\x1a\x1d",
          "\x5d\x2c\x63\x29\x60\xf8\x23\xcf\x72\x42\xbf\x61\xf9\x39\x13\x17",
          "\xfd\x80\xa3\x82\x7d\xb1\x72\x42\xb2\xdf\x0c\xd8\xca\x96\xd9\x97",
          "\xdf\xb5\x8a\x6b\xe4\xe7\xe0\x01\x0f\x7c\x74\x04\xb4\x67", 1, 128,
          128 },
        { 96, 256, 112, 444,
          "\x37\x76\xa8\x4b\x86\x9e\xc4\xa7\x1e\xd8\x4a\x74\xe6\xa9\x8c\x42\xc0"
          "\xff\xa2\x3f\x6e\xb2\xe2\x97\x0f\x13\x11\x21\xc5\xba\x69\xfe",
          "\x72\xcd\xa6\xef\xb0\x82\x5c\x74\x0d\x19\xf4\x85", "",
          "\x05\x05\xd2\x88\x90\x8d\x5c\x28\xe4\x72\x3d\x9d\x4b\x8b\x0f\xc0"
          "\xba",
          "\xdc\xd6\x2b\xdc\x23\xee\x8b\xdb\x7a\xfd\xec\xd4\x49\xcd\xb4\x99"
          "\x4a",
          "\x9a\xa0\xf8\xf0\x32\xbe\x13\x42\xad\x5d\x40\x99\xc3\xae", 1, 0,
          136 },
        { 96, 256, 112, 445,
          "\x01\xfc\xbc\x4a\x3b\x2e\xe3\x21\x09\xcd\x0f\x27\xd8\x29\xe2\x0d\x1d"
          "\x92\x03\xd6\xff\x81\x2e\xd9\x84\x1e\xf9\x08\x90\x4d\x74\xa8",
          "\xae\x9e\xe7\xf9\xf5\x28\x78\x21\x58\x38\xf5\xcb",
          "\x1b\xe1\x77\xd6\xe8\x86\x51\xc4\x0f\x6a\x1b\x53\x38\x17\xc2\x79",
          "\x26\x8a\x75\xfb\x89\x0e\x8a\xf7\xc2\x4b\x63\xcf\xb8\x70\x80\xe0"
          "\x28",
          "\xe1\x44\x0c\x49\x55\x62\xf6\xc8\x56\x28\x81\x83\x23\x4e\x0a\xd2"
          "\x2e",
          "\xd9\x3e\x1c\x12\xbc\xc7\x66\x60\x12\x7d\xfd\x8c\x28\xa0", 1, 128,
          136 },
        { 96, 256, 112, 446,
          "\xa0\x17\x45\xf5\x2f\x1f\x35\x64\xda\x0a\xdf\x84\x5f\xdb\xd4\x7a\x5b"
          "\xd1\x86\x50\x92\x57\x95\x58\xf6\x7f\x67\xba\x07\xf2\x38\xa0",
          "\x87\xd7\xce\xc6\x30\x1b\x81\xe3\xe0\x66\x6e\x27", "",
          "\xd5\xc0\x12\x80\xac\xf0\xaf\xe7\x7d\xf7\x67\xff\x3c\x02\x8f\x52\xe3"
          "\xd3\x78\x6a\x84\xcc\x7c\xc0\x07\x06\x61\xa8\x1c\x1f\xbd",
          "\xcb\x07\xfc\x59\x62\xf7\xd3\x26\x86\x06\xf1\xd2\x24\xfd\x92\xb3\xc2"
          "\x30\x26\x20\xf0\x33\x20\x78\x4a\x71\x18\x0d\x72\x65\x01",
          "\x7f\x64\xeb\xeb\x84\xbc\xad\x46\x34\x7f\xf1\xf2\x74\x47", 1, 0,
          248 },
        { 96, 256, 112, 447,
          "\x24\x0e\xf4\xec\x0a\x7b\x24\x01\x7c\x13\xe4\x61\x22\x7d\x11\xf6\x08"
          "\xc4\x16\x98\x45\x7e\x94\x8f\x65\x7d\x82\xa1\x9d\x97\x05\x44",
          "\x52\xec\x46\xf5\x27\x81\xbb\x7c\xd0\x0f\xbf\xd3",
          "\x89\x9c\x64\xab\xbe\xc1\x46\x8e\xc5\xb8\x42\x7e\x61\xb9\x90\xab",
          "\x2b\x25\x88\x2f\x82\x4b\x41\xea\xf4\xb2\x15\x0e\xb1\xfe\x8d\xc0\xf9"
          "\xc7\x15\x6a\x41\x88\x1b\x39\xd1\x3d\xae\xc1\xf9\xb0\xb1",
          "\xe9\x4e\x44\xb5\xe7\xbb\x26\xb2\x49\xb4\x8c\xaa\xf2\xa9\xab\x5a\x75"
          "\x06\xff\x39\x66\x8f\xfe\xa6\xf6\x2b\xb0\x30\xfe\x5c\x87",
          "\x1a\x85\x9a\xa8\x06\x26\x04\x72\xa5\x39\x79\xcc\x4e\xaa", 1, 128,
          248 },
        { 0, 128, 96, 448,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xbe\x17\x22\xa5\x81\x71\x95\xc5\x03\x81\x4b\xe1\xbd\x09\x31\x10",
          "\x6f\x79\xa8\xcf\x92\xc8\x56\xb8\xf1\x6d\xee\x92", 0, 0, 128 },
        { 8, 128, 96, 449,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x40", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x21\x03\x89\x22\x69\x58\xde\xf4\xb4\x4f\x1e\x16\x86\x32\x11\x3c",
          "\xd4\xe9\x7a\x10\x08\x00\xa5\xc1\x6b\xea\x4f\xdf", 0, 0, 128 },
        { 16, 128, 96, 450,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x40\x41", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x95\xbf\x20\x8e\x86\x73\xb9\xf9\xa3\x8f\x96\x09\xb5\xe7\x8f\x2a",
          "\xdf\x81\x41\x91\x69\x6c\xf3\x12\x9f\xb4\x0d\xc0", 0, 0, 128 },
        { 32, 128, 96, 451,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x40\x41\x42\x43", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xa7\xda\xb4\xbf\xcf\x3e\x2a\xfa\x4b\x31\x9c\xfd\xc1\x7f\x15\xf1",
          "\xc4\xe8\xb1\xfa\x0d\x79\x17\x77\x41\x7c\xe5\x2c", 0, 0, 128 },
        { 48, 128, 96, 452,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x40\x41\x42\x43\x44\x45", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xa8\x9a\x23\xf4\xf3\x2b\xa0\x09\xc3\xaa\x8f\xa0\x19\x1f\x84\xc5",
          "\x65\x96\x21\xc2\xad\x5b\xc6\x1d\xe2\xce\x80\x46", 0, 0, 128 },
        { 112, 128, 96, 453,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xf9\xd0\x07\x8b\xcd\x56\x8b\xf9\x79\x24\xe6\xd7\x1f\x40\x60\x87",
          "\x09\x5c\x0d\xa2\xea\x6d\xda\x5a\x87\x12\x1c\x2a", 0, 0, 128 },
        { 120, 128, 96, 454,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x67\x0c\xd0\x68\xe6\x5b\x08\xfc\xef\xb9\xc0\xaf\xa7\xbb\x5c\x33",
          "\xda\xa0\x28\x10\xe9\x97\xe7\x97\xdd\xa9\x75\x5d", 0, 0, 128 },
        { 128, 128, 96, 455,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x5e\xdb\xeb\xec\x6c\x53\x3d\xac\x8c\xa8\x9f\xaf\x60\xd8\xc1\x37",
          "\x94\x53\xd6\xa8\xff\x91\xb7\x14\xf3\x2c\x0b\x71", 0, 0, 128 },
        { 160, 128, 96, 456,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x5e\xdb\xeb\xec\x6c\x53\x3d\xac\x8c\xa8\x9f\xaf\x60\xd8\xc1\x37",
          "\x94\x53\xd6\xa8\xff\x91\xb7\x14\xf3\x2c\x0b\x71", 0, 0, 128 },
        { 256, 128, 96, 457,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x5e\xdb\xeb\xec\x6c\x53\x3d\xac\x8c\xa8\x9f\xaf\x60\xd8\xc1\x37",
          "\x94\x53\xd6\xa8\xff\x91\xb7\x14\xf3\x2c\x0b\x71", 0, 0, 128 },
        { 512, 128, 96, 458,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xc3\x2a\x76\x43\xab\x0f\x6e\xa3\x45\x8d\x7e\x63\xb0\xed\x64\x99",
          "\x8f\xc9\xb6\xf4\x0b\x3a\x81\xfd\x5f\xd6\xc5\x3c", 0, 0, 128 },
        { 1024, 128, 96, 459,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f\x40\x41\x42\x43"
          "\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51\x52\x53\x54"
          "\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f\x60\x61\x62\x63\x64\x65"
          "\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x73\x74\x75\x76"
          "\x77\x78\x79\x7a\x7b\x7c\x7d\x7e\x7f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xc3\x2a\x76\x43\xab\x0f\x6e\xa3\x45\x8d\x7e\x63\xb0\xed\x64\x99",
          "\x8f\xc9\xb6\xf4\x0b\x3a\x81\xfd\x5f\xd6\xc5\x3c", 0, 0, 128 },
        { 2144, 128, 96, 460,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f\x40\x41\x42\x43"
          "\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51\x52\x53\x54"
          "\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f\x60\x61\x62\x63\x64\x65"
          "\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x73\x74\x75\x76"
          "\x77\x78\x79\x7a\x7b\x7c\x7d\x7e\x7f\x80\x81\x82\x83\x84\x85\x86\x87"
          "\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98"
          "\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9"
          "\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba"
          "\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb"
          "\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc"
          "\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed"
          "\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe"
          "\xff\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xc3\x2a\x76\x43\xab\x0f\x6e\xa3\x45\x8d\x7e\x63\xb0\xed\x64\x99",
          "\x8f\xc9\xb6\xf4\x0b\x3a\x81\xfd\x5f\xd6\xc5\x3c", 0, 0, 128 },
        { 0, 192, 96, 461,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x15\x69\x9c\x20\x19\x86\x88\xb9\xe4\x88\x2a\x65\x42\x81\x1a\xda",
          "\xc6\x93\x17\xb9\x9b\x43\x08\x6b\x62\x1e\xb1\x4a", 0, 0, 128 },
        { 8, 192, 96, 462,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x40", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x7e\x84\xb5\xaa\x41\xd2\x21\x2b\x3a\x5d\x73\x0d\xf5\xb2\x0e\xaa",
          "\x59\x24\xd8\xbd\x85\x31\x8b\x03\x3b\xf4\xf2\xfd", 0, 0, 128 },
        { 16, 192, 96, 463,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x40\x41", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xeb\x81\x33\x67\xe3\xd1\xfa\x4e\xe4\xc4\x02\x45\x0f\x29\x46\xd1",
          "\xcf\x6e\xee\x49\x5f\x94\xc0\x8f\xef\x7c\xe5\xb5", 0, 0, 128 },
        { 32, 192, 96, 464,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x40\x41\x42\x43", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\xe9\xc6\x21\xdb\xe0\x57\xb8\x6a\xca\xef\x8a\xd0\xe3\x8e\xe0",
          "\x6d\xd3\x3d\x42\x27\x8b\xb2\xf2\x7e\xab\x7a\x0b", 0, 0, 128 },
        { 48, 192, 96, 465,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x40\x41\x42\x43\x44\x45", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x41\xbd\x6e\x62\x6e\xf1\xd4\xfa\x33\xe3\xe6\x2b\x6b\x71\xb2\x47",
          "\xb0\x35\x06\xdf\x38\x08\x5e\x4f\x93\xee\x9e\xa4", 0, 0, 128 },
        { 112, 192, 96, 466,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x39\x0f\x24\xac\xc1\x13\xb4\x33\xe4\xb7\x85\xe9\x18\x3d\x48\x38",
          "\x9b\xc0\x39\x7f\xee\x59\xe6\x99\x0c\x3b\xbc\x81", 0, 0, 128 },
        { 120, 192, 96, 467,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb2\xd1\x08\x59\x06\x25\xee\x4a\xf6\x6b\x7c\xb6\x63\xdf\x50\xc1",
          "\xcf\xea\xbe\x25\x26\x50\xd1\x25\x84\x47\x8b\xd0", 0, 0, 128 },
        { 128, 192, 96, 468,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x17\xef\x53\xd9\x25\xbb\xa4\xe1\xf3\x35\xd0\x01\x86\xb7\xc3\x8e",
          "\x8f\x64\x77\xda\x94\xef\x6f\x63\xc4\xd1\xa0\x71", 0, 0, 128 },
        { 160, 192, 96, 469,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x17\xef\x53\xd9\x25\xbb\xa4\xe1\xf3\x35\xd0\x01\x86\xb7\xc3\x8e",
          "\x8f\x64\x77\xda\x94\xef\x6f\x63\xc4\xd1\xa0\x71", 0, 0, 128 },
        { 256, 192, 96, 470,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x17\xef\x53\xd9\x25\xbb\xa4\xe1\xf3\x35\xd0\x01\x86\xb7\xc3\x8e",
          "\x8f\x64\x77\xda\x94\xef\x6f\x63\xc4\xd1\xa0\x71", 0, 0, 128 },
        { 512, 192, 96, 471,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x81\xa8\xa0\x87\xcf\x96\xd5\x8f\x64\x86\x8b\x18\x9e\xdd\x0b\xb4",
          "\xc5\xcc\x4f\x2b\x5a\x46\x0c\x1d\x22\x9a\x6b\xa8", 0, 0, 128 },
        { 1024, 192, 96, 472,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f\x40\x41\x42\x43"
          "\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51\x52\x53\x54"
          "\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f\x60\x61\x62\x63\x64\x65"
          "\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x73\x74\x75\x76"
          "\x77\x78\x79\x7a\x7b\x7c\x7d\x7e\x7f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x81\xa8\xa0\x87\xcf\x96\xd5\x8f\x64\x86\x8b\x18\x9e\xdd\x0b\xb4",
          "\xc5\xcc\x4f\x2b\x5a\x46\x0c\x1d\x22\x9a\x6b\xa8", 0, 0, 128 },
        { 2144, 192, 96, 473,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f\x40\x41\x42\x43"
          "\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51\x52\x53\x54"
          "\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f\x60\x61\x62\x63\x64\x65"
          "\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x73\x74\x75\x76"
          "\x77\x78\x79\x7a\x7b\x7c\x7d\x7e\x7f\x80\x81\x82\x83\x84\x85\x86\x87"
          "\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98"
          "\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9"
          "\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba"
          "\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb"
          "\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc"
          "\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed"
          "\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe"
          "\xff\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x81\xa8\xa0\x87\xcf\x96\xd5\x8f\x64\x86\x8b\x18\x9e\xdd\x0b\xb4",
          "\xc5\xcc\x4f\x2b\x5a\x46\x0c\x1d\x22\x9a\x6b\xa8", 0, 0, 128 },
        { 0, 256, 96, 474,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3c\xd9\xba\xce\x5f\x5d\xc7\x7c\x89\xc2\xbc\x13\x90\x65\xe7\x97",
          "\x99\xf6\x05\x8e\xeb\x8e\x3a\x80\x36\xaa\xda\xb8", 0, 0, 128 },
        { 8, 256, 96, 475,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x40", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb5\xf0\x44\x21\x1e\x18\xb1\x35\x72\xe2\xea\x70\xed\x17\x83\x53",
          "\x24\xcf\x3f\x3f\x36\x9b\x69\x2f\xe7\x30\x97\x0c", 0, 0, 128 },
        { 16, 256, 96, 476,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x40\x41", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xc0\x00\x74\x6e\xd8\x24\x6d\x20\xed\xda\x90\xc0\x4f\x38\x0b\xa8",
          "\xaf\x82\x09\x34\x87\xd3\xa5\xd4\x87\x2f\xf9\xe2", 0, 0, 128 },
        { 32, 256, 96, 477,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x40\x41\x42\x43", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xb0\x0b\xd7\xb8\xcd\x03\x1c\x16\x8e\x37\x40\x7e\xb0\x9f\x06\x2e",
          "\xbf\xca\xe1\x10\xc7\x37\xbb\xe7\x57\x96\x7f\x4e", 0, 0, 128 },
        { 48, 256, 96, 478,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x40\x41\x42\x43\x44\x45", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xae\x28\x65\xf8\x6b\xa6\x32\x8c\xe1\x31\xa4\x9c\xd4\x99\xf9\x36",
          "\x43\x90\xb5\x4f\x3b\x7c\xbf\x9e\x54\xa2\x20\x48", 0, 0, 128 },
        { 112, 256, 96, 479,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x56\x80\xeb\xd1\x6a\xe4\x46\xe9\xe2\xd0\x7f\xba\xac\x7a\xbd\x0b",
          "\xd7\x2d\x01\x57\x82\xfd\x94\xd7\x6d\x2f\x68\x2f", 0, 0, 128 },
        { 120, 256, 96, 480,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x6a\x61\x1e\x6f\xb6\x7d\x83\x1b\x4b\x09\x61\x69\xf2\xe8\x66\x47",
          "\x0c\x39\xbb\x24\x62\xbb\xaf\xf7\x19\x39\xee\x1f", 0, 0, 128 },
        { 128, 256, 96, 481,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x68\x18\x41\xa0\xa0\x13\x92\x39\x07\xc6\x69\xef\xd3\xff\xd0\x69",
          "\x05\x4c\xd6\xf1\xcd\xa1\xb1\xbf\x91\xe0\x10\x0f", 0, 0, 128 },
        { 160, 256, 96, 482,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x68\x18\x41\xa0\xa0\x13\x92\x39\x07\xc6\x69\xef\xd3\xff\xd0\x69",
          "\x05\x4c\xd6\xf1\xcd\xa1\xb1\xbf\x91\xe0\x10\x0f", 0, 0, 128 },
        { 256, 256, 96, 483,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30"
          "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x68\x18\x41\xa0\xa0\x13\x92\x39\x07\xc6\x69\xef\xd3\xff\xd0\x69",
          "\x05\x4c\xd6\xf1\xcd\xa1\xb1\xbf\x91\xe0\x10\x0f", 0, 0, 128 },
        { 512, 256, 96, 484,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xe7\x3c\xc2\xee\x05\x0a\x0e\x7b\x34\x5a\xeb\x10\x00\xc4\x81\xc3",
          "\x18\x2d\xab\xaf\xf0\x40\x0d\xe7\x08\x74\x6b\x6a", 0, 0, 128 },
        { 1024, 256, 96, 485,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f\x40\x41\x42\x43"
          "\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51\x52\x53\x54"
          "\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f\x60\x61\x62\x63\x64\x65"
          "\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x73\x74\x75\x76"
          "\x77\x78\x79\x7a\x7b\x7c\x7d\x7e\x7f",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xe7\x3c\xc2\xee\x05\x0a\x0e\x7b\x34\x5a\xeb\x10\x00\xc4\x81\xc3",
          "\x18\x2d\xab\xaf\xf0\x40\x0d\xe7\x08\x74\x6b\x6a", 0, 0, 128 },
        { 2144, 256, 96, 486,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21"
          "\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32"
          "\x33\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\x3e\x3f\x40\x41\x42\x43"
          "\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51\x52\x53\x54"
          "\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f\x60\x61\x62\x63\x64\x65"
          "\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x73\x74\x75\x76"
          "\x77\x78\x79\x7a\x7b\x7c\x7d\x7e\x7f\x80\x81\x82\x83\x84\x85\x86\x87"
          "\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98"
          "\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9"
          "\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba"
          "\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb"
          "\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc"
          "\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed"
          "\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe"
          "\xff\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b",
          "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xe7\x3c\xc2\xee\x05\x0a\x0e\x7b\x34\x5a\xeb\x10\x00\xc4\x81\xc3",
          "\x18\x2d\xab\xaf\xf0\x40\x0d\xe7\x08\x74\x6b\x6a", 0, 0, 128 },
        { 96, 128, 16, 487,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\x19\x8c", 0, 0, 128 },
        { 96, 128, 24, 488,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\x19\x8c\x08", 0, 0, 128 },
        { 96, 128, 40, 489,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\x23\x1a\x2d\x8f\x6a", 0, 0, 128 },
        { 96, 128, 56, 490,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\xb1\xbb\xf3\x88\x35\x07\xcd", 0, 0, 128 },
        { 96, 128, 72, 491,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\xcd\x0a\xe6\x3f\x3a\x30\xf7\xfb\x5b", 0, 0, 128 },
        { 96, 128, 88, 492,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\x53\x5e\x32\xac\x41\x68\x16\x61\x5e\x5a\x20", 0, 0, 128 },
        { 96, 128, 104, 493,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\xa6\xc5\x84\x58\xd3\x96\x9d\xa9\xcb\x08\x49\xf9\x5e", 0, 0, 128 },
        { 96, 128, 120, 494,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\xd3\xda\xb1\xee\x49\x4c\xc2\x29\x09\x9d\x6c\xac\x7d\xf1\x4a\xdd",
          "\xf7\x87\x9f\xb7\xfe\x88\xdd\x74\xcb\x8e\x96\xfd\xa1\xd2\xeb", 0, 0,
          128 },
        { 96, 192, 16, 495,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\x95\xeb", 0, 0, 128 },
        { 96, 192, 24, 496,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\x95\xeb\x98", 0, 0, 128 },
        { 96, 192, 40, 497,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\x3f\xd4\x0d\xd8\xe0", 0, 0, 128 },
        { 96, 192, 56, 498,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\x79\x3c\xa5\xd3\x51\xe6\x8c", 0, 0, 128 },
        { 96, 192, 72, 499,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\x63\xa0\x98\x7f\xff\xf1\x31\x3c\xaa", 0, 0, 128 },
        { 96, 192, 88, 500,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\x0e\xe4\x0f\x14\x47\x5b\x7e\x28\x75\x29\x83", 0, 0, 128 },
        { 96, 192, 104, 501,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\x40\xa4\xfc\x82\xd4\x29\xa0\x09\x1c\x96\x2d\x71\x52", 0, 0, 128 },
        { 96, 192, 120, 502,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x1c\x49\x32\x45\x15\xa3\x46\xd4\x24\xee\xd6\xfe\xd9\xbd\xdc\x17",
          "\xf8\xf9\xbd\xc6\xb8\x50\x6a\xfd\x3a\xe5\x4a\x0a\x67\xe1\x85", 0, 0,
          128 },
        { 96, 256, 16, 503,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\x8f\x8b", 0, 0, 128 },
        { 96, 256, 24, 504,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\x8f\x8b\x32", 0, 0, 128 },
        { 96, 256, 40, 505,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\xa9\x4e\x19\xf3\x4c", 0, 0, 128 },
        { 96, 256, 56, 506,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\x5e\x90\x21\x8c\xac\xa4\x70", 0, 0, 128 },
        { 96, 256, 72, 507,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\x38\x5c\xef\x2c\x25\x99\xfa\xa9\x60", 0, 0, 128 },
        { 96, 256, 88, 508,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\xe8\x1c\x27\x00\x20\xed\xd9\x3b\xa7\xe5\x64", 0, 0, 128 },
        { 96, 256, 104, 509,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\xc5\xd5\xf2\x9a\xf5\xc0\xdb\x44\x4a\xc2\x61\x8b\x9d", 0, 0, 128 },
        { 96, 256, 120, 510,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
          "\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x50\x51", "",
          "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f",
          "\x3b\x68\x29\xd5\xde\xb4\x7c\xa9\xf1\x0a\xbf\x48\x15\x64\xae\xe1",
          "\xf2\xf6\xd8\xb6\xab\x69\xc8\xe1\x00\x39\xb5\x75\x4f\x55\x37", 0, 0,
          128 },
        { 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0 }
};
