/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import org.osjava.jardiff.MethodInfo;

public abstract class AbstractInfo {
    public final String ACCESS_PUBLIC = "public";
    public final String ACCESS_PROTECTED = "protected";
    public final String ACCESS_PACKAGE = "package";
    public final String ACCESS_PRIVATE = "private";
    private final int access;
    private final String name;

    public AbstractInfo(int access, String name) {
        this.access = access;
        this.name = name;
    }

    public final int getAccess() {
        return this.access;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isPublic() {
        return (this.access & 1) != 0;
    }

    public final boolean isProtected() {
        return (this.access & 4) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.access & 7) == 0;
    }

    public final boolean isPrivate() {
        return (this.access & 2) != 0;
    }

    public final boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public final boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    public final boolean isBridge() {
        return (this.access & 0x40) != 0;
    }

    public final boolean isDeprecated() {
        return (this.access & 0x20000) != 0;
    }

    public final boolean isEnum() {
        return (this.access & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    public final boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public final boolean isNative() {
        return (this.access & 0x100) != 0;
    }

    public final boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public final boolean isStrict() {
        return (this.access & 0x800) != 0;
    }

    public final boolean isSuper() {
        return (this.access & 0x20) != 0;
    }

    public final boolean isSynchronized() {
        return (this.access & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.access & 0x1000) != 0;
    }

    public final boolean isTransient() {
        return !(this instanceof MethodInfo) && (this.access & 0x80) != 0;
    }

    public final boolean isVarargs() {
        return this instanceof MethodInfo && (this.access & 0x80) != 0;
    }

    public final boolean isVolatile() {
        return (this.access & 0x40) != 0;
    }

    public final String getAccessType() {
        if (this.isPublic()) {
            return "public";
        }
        if (this.isProtected()) {
            return "protected";
        }
        if (this.isPrivate()) {
            return "private";
        }
        return "package";
    }
}

