/*
 * Copyright 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.sf.ezmorph.object;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 * @author Andres Almiray <a href="mailto:aalmiray@users.sourceforge.net">aalmiray@users.sourceforge.net</a>
 */
public class IdentityObjectMorpherTest extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(IdentityObjectMorpherTest.class);
        suite.setName("IdentityMorpher Tests");
        return suite;
    }

    private IdentityObjectMorpher morpher = IdentityObjectMorpher.getInstance();

    public IdentityObjectMorpherTest(String name) {
        super(name);
    }

    // -----------------------------------------------------------------------

    public void testMorph() {
        assertNull(morpher.morph(null));
        Object expected = new Object();
        assertSame(expected, morpher.morph(expected));
    }
}
