//---------------------------------------------------------------------------
//
// "" for ʳβʳβ
// ֥(黻)
//
//      Programed by Suikyo.
//
//  2002.04.18  Phase 8.0.0   黻֥ɺ
//
//---------------------------------------------------------------------------
#ifndef KAWARI_CODESET_H__
#define KAWARI_CODESET_H__
//---------------------------------------------------------------------------
#include "libkawari/kawari_code.h"
#include "libkawari/kawari_dict.h"
//---------------------------------------------------------------------------
#include <string>
#include <set>
//---------------------------------------------------------------------------
// 黻֥ɤδ쥯饹
class TKVMSetCode_base : public TKVMCode_base {
public:
	// ¹
	virtual std::string Run(class TKawariVM &vm);
	// ɾ
	virtual void Evaluate(class TKawariVM &vm, std::set<TWordID> &wordcol)=0;
	// ǥȥ饯
	virtual ~TKVMSetCode_base () {}
};

//---------------------------------------------------------------------------
// 黻黻ҥɤδ쥯饹
class TKVMSetBinaryCode_base : public TKVMSetCode_base {
protected:
	TKVMSetCode_base *lhs;
	TKVMSetCode_base *rhs;
	// 黻ʸ֤
	virtual std::string GetOperator(void)const=0;
public:
	//  Ʊ饹ξΤ߸ƤФ롣
	virtual bool Less(const TKVMCode_base& r_) const;
	// եѥ
	virtual std::string DisCompile(void) const;
	// ǥХåѥĥ꡼ɽ
	virtual std::ostream &Debug(std::ostream& os, unsigned int level=0) const;
	// 󥹥ȥ饯
	TKVMSetBinaryCode_base(TKVMSetCode_base *l, TKVMSetCode_base *r) : lhs(l), rhs(r) {}
	// ǥȥ饯
	virtual ~TKVMSetBinaryCode_base(void){
		if (lhs) delete lhs;
		if (rhs) delete rhs;
	}
};

//---------------------------------------------------------------------------
// 
class TKVMSetCodePLUS : public TKVMSetBinaryCode_base {
protected:
	virtual std::string GetOperator(void)const{ return "+"; }
public:
	// ɾ
	virtual void Evaluate(class TKawariVM &vm, std::set<TWordID> &wordcol);
	// 󥹥ȥ饯
	TKVMSetCodePLUS(TKVMSetCode_base *l, TKVMSetCode_base *r):TKVMSetBinaryCode_base(l, r) {}
};
//---------------------------------------------------------------------------
// 
class TKVMSetCodeMINUS : public TKVMSetBinaryCode_base {
protected:
	virtual std::string GetOperator(void)const{ return "-"; }
public:
	// ɾ
	virtual void Evaluate(class TKawariVM &vm, std::set<TWordID> &wordcol);
	// 󥹥ȥ饯
	TKVMSetCodeMINUS(TKVMSetCode_base *l, TKVMSetCode_base *r):TKVMSetBinaryCode_base(l, r) {}
};
//---------------------------------------------------------------------------
// 
class TKVMSetCodeAND : public TKVMSetBinaryCode_base {
protected:
	virtual std::string GetOperator(void)const{ return "&"; }
public:
	// ɾ
	virtual void Evaluate(class TKawariVM &vm, std::set<TWordID> &wordcol);
	// 󥹥ȥ饯
	TKVMSetCodeAND(TKVMSetCode_base *l, TKVMSetCode_base *r):TKVMSetBinaryCode_base(l, r) {}
};
//---------------------------------------------------------------------------
// Set Expression Word
class TKVMSetCodeWord : public TKVMSetCode_base {
	TKVMCode_base *code;
public:
	// ɾ
	virtual void Evaluate(class TKawariVM &vm, std::set<TWordID> &wordcol);
	//  Ʊ饹ξΤ߸ƤФ롣
	virtual bool Less(const TKVMCode_base& r_) const;
	// եѥ
	virtual std::string DisCompile(void) const{
		return code->DisCompile();
	}
	// ǥХåѥĥ꡼ɽ
	virtual std::ostream &Debug(std::ostream& os, unsigned int level=0) const{
		return code->Debug(os, level);
	}
	// ⤷codeTKVMCodeIDStringʤС֤
	const TKVMCodeIDString *GetIfPVW(void) const;
	// 󥹥ȥ饯
	TKVMSetCodeWord(TKVMCode_base *c) : code(c) {}
	// ǥȥ饯
	~TKVMSetCodeWord(void){
		if (code) delete code;
	}
};
//---------------------------------------------------------------------------
// ȥƤӽФʰ ( '${' EntryExpr '}' )
// ʰdone.
class TKVMCodeEntryCall : public TKVMCode_base {
	TKVMSetCode_base *code;
public:
	// ¹
	virtual std::string Run(class TKawariVM &vm);
	//  Ʊ饹ξΤ߸ƤФ롣
	virtual bool Less(const TKVMCode_base& r_) const;
	// եѥ
	virtual std::string DisCompile(void) const;
	// ǥХåѥĥ꡼ɽ
	virtual std::ostream &Debug(std::ostream& os, unsigned int level=0) const;
	// 󥹥ȥ饯
	TKVMCodeEntryCall(TKVMSetCode_base *c) : code(c) {}
	// ǥȥ饯
	virtual ~TKVMCodeEntryCall();
};

//---------------------------------------------------------------------------
// 貾ñ(ü쥨ȥƤӽФ) ( '${' Literal '}' )
class TKVMCodePVW : public TKVMCode_base {
	std::string entry;
public:
	// ȥȥ֤̾
	virtual std::string Get(void) { return entry; }
	// ¹
	virtual std::string Run(class TKawariVM &vm);
	//  Ʊ饹ξΤ߸ƤФ롣
	virtual bool Less(const TKVMCode_base& r_) const;
	// եѥ
	virtual std::string DisCompile(void) const;
	// ǥХåѥĥ꡼ɽ
	virtual std::ostream &Debug(std::ostream& os, unsigned int level=0) const;
	// 󥹥ȥ饯
	TKVMCodePVW(const std::string &c) : entry(c) {}
	// ǥȥ饯
	virtual ~TKVMCodePVW() {}
};

//---------------------------------------------------------------------------
// 򻲾 ( '${' Integer '}' )
class TKVMCodeHistoryCall : public TKVMCode_base {
	int index;
public:
	// ¹
	virtual std::string Run(class TKawariVM &vm);
	//  Ʊ饹ξΤ߸ƤФ롣
	virtual bool Less(const TKVMCode_base& r_) const;
	// եѥ
	virtual std::string DisCompile(void) const;
	// ǥХåѥĥ꡼ɽ
	virtual std::ostream &Debug(std::ostream& os, unsigned int level=0) const;
	// 󥹥ȥ饯
	TKVMCodeHistoryCall(int i) : index(i) {}
	// ǥȥ饯
	virtual ~TKVMCodeHistoryCall() {}
};

//---------------------------------------------------------------------------
#endif // KAWARI_CODESET_H__
